C
C*********************************************************************          
C                                                                               
C
C      TESTPROGRAM FOR NLPQLP USING THE PROBLEMS DESCRIBED IN:         
C             
C      W. Hock, K. Schittkowski, 'Test Examples for Nonlinear                    
C      Programming Codes', Lecture Notes in Economics and Mathematical         
C      Systems, Springer, No, 187, 1981                                           
C
C      K. Schittkowski, 'More Test Examples for Nonlinear Programming 
C      Codes', Lecture Notes in Economics and Mathematical Systems, 
C      Springer, No, 282, 1987                                           
C                                  
C
C
C      Purpose:
C      -------
C
C      The 306 test problems of the two mentioned collections are executed 
C      within a loop. A decision is made which of the test runs is considered
C      to be successful, and performance results are evaluated.
C
C      It is possible to add random errors to function values and to evaluate
C      derivatives by three different approximation formulae.
C
C
C
C      Output:
C      ------
C
C      Four files are generated by the test program, one for individual results
C      (TEST.DAT), one for a Latex table (TEST.TEX), another one for final 
C      performance results in 'readable' form (RESULT.DAT), and a file with 
C      numerical performance data in one line (TEMP.DAT).
C
C      a) TEST.DAT:
C
C      Typical contants of TEST.DAT without lines generated by the NLP routine:
C
C      TP 1 2 0 0 0 26  19 102  0.73115910D-10  0.000D+00  0.000D+00
C      TP 2 2 0 0 0 20  15  80  0.50426193D-01  0.106D-06  0.000D+00
C      TP 3 2 0 0 0 10  10  50  0.38971022D-21  0.106D-06  0.000D+00
C      TP 4 2 0 0 0  2   2  10  0.26666667D+01  0.000D+00  0.000D+00
C      TP 5 2 0 0 0  8   6  32 -0.19132230D+01  0.109D-10  0.000D+00
C      TP  ...............
C
C      The following data are listed:
C
C       1.  NTP      (Test problem number)  
C       2.  N        (Number of variables)
C       3.  ME       (Number of equality constraints)                                        
C       4.  M        (Number of constraints)                                        
C       5.  IFAIL    (Convergence criterion)                             
C       6.  NF       (Number of objective function evaluations)                     
C       7.  NDF      (Number of gradient evaluations of objective function)                                                     
C       8.  NEF      (Number of equivalent function evaluations, i.e. NF plus
C                     number of function calls needed for gradient approximation)
C       9.  FEX      (Exact objective function value)
C      10.  F        (Cmputed objective function value)
C      11.  DFX      (Relative error in objective function)                   
C      12.  DGX      (Sum of constraint violations including bound violations)                                              
C
C
C      b) TEST.TEX:
C
C      Same with Latex separators
C
C
C      c) RESULT.DAT:
C
C      The following summary is listed:
C
C      Tolerance for gradient approximation
C      Termination accuracy for NLP routine
C      Total number of test runs
C      Number of successful test runs
C      - constraint violation less than squared tolerance and
C        either error in objective less than tolerance or
C        termination criteria of NLP routine satisfied
C      Number of better test runs
C      - constraint violation less than squared tolerance and
C        error in objective less than -tolerance
C      Number of local solutions obtained
C      Number of runs without satisfying termination accuracy
C      - as indicated by NLP routine, i.e. IFAIL>0
C      Tolerance for determining successful return
C      Average number of function evaluations
C      Average number of gradient evaluations
C      Average number of equivalent function calls      
C      - additionlly counted function calls for gradient 
C        approximations
C
C
C      d) TEMP.DAT:
C
C      Contains more or less the same data in one row, e.g.
C
C     0.1D-07 0.1D-06 0.1D-12 0.4D-42 306   0  44  22 322 285  21
C
C
C
C      Compilation and Link:
C      --------------------
C
C      To run the code, the following files must be linked:
C
C      TESTP.OBJ    : test program
C      PROB.OBJ     : 306 test problems
C      CONV.OBJ     : interface for executing individual test problems 
C      NLPQLP.OBJ   : nonlinear programming code     
C      QL.OBJ       : auxiliary routine called by NLPQLP
C 
C
C
C      Version:
C      -------
C
C      1.0   June 2001
C      2.0   April 2008
C      3.0   November 2009
C      4.0   February 2010
C      5.0   April 2010
C      6.0   February 20011
C
C
C
C      Author (C):
C      ----------
C
C      Prof. K. Schittkowski,
C      Dept. of Computer Science,
C      University of Bayreuth,
C      D-95440 Bayreuth,
C      Germany
C
C
C
C      Reference:
C      ---------
C  
C      K. Schittkowski. NLPQL: A Fortran subroutine solving
C      constrained nonlinear programming problems, Annals of
C      Operations Research, Vol.5 (1985/6), 485-500.
C
C      K. Schittkowski. NLPQLP: A Fortran implementation 
C      of a sequential quadratic programming algorithm with 
C      distributed and non-monotone line search, Report, 
C      Department of Computer Science, University of Bayreuth, 
C      2006
C
C                                              
C                                                                               
C*********************************************************************          
C
      IMPLICIT NONE  
      INTEGER    NMAX, MMAX, LMAX, MNNMAX, LWA, LIWA, LACTIV, N, 
     /           NILI, NINL, NELI, NENL, NEX              
      PARAMETER (NMAX   = 101, 
     /           MMAX   = 50, 
     /           LMAX   = 1, 
     /           MNNMAX = NMAX + NMAX + MMAX + 2,
     /           LWA    = 3*NMAX*NMAX/2 + 33*NMAX + 10*MMAX + 150,
     /           LIWA   = MMAX + NMAX + 150,
     /           LACTIV = 2*MMAX + 15)             
      COMMON     /L1/  N, NILI, NINL, NELI, NENL 
     /           /L2/  XTP(NMAX)                              
     /           /L3/  GTP(MMAX)           
     /           /L4/  DFTP(NMAX)          
     /           /L5/  DGTP(NMAX*MMAX)        
     /           /L6/  FXTP
     /           /L8/  NTP              
     /           /L9/  INDEX1(MMAX)     
     /           /L10/ INDEX2(MMAX)
     /           /L11/ LXL(NMAX)       
     /           /L12/ LXU(NMAX)    
     /           /L13/ XL(NMAX)     
     /           /L14/ XU(NMAX)    
     /           /L20/ LEX, NEX, FEX, XEX(NMAX) 
      LOGICAL    INDEX1, INDEX2, LXL, LXU, LEX      
      REAL*8     XTP, GTP, DFTP, DGTP, FXTP, XL,XU, FEX, XEX 
      DIMENSION  F(LMAX), X(NMAX,LMAX), G(MMAX,LMAX), GEPS(MMAX),
     /           DF(NMAX), DG(MMAX,NMAX), U(MNNMAX), C(NMAX,NMAX),
     /           D(NMAX), WA(LWA), IWA(LIWA), ACTIVE(LACTIV)
      REAL*8     X, F, G, DF, DG, U, C, D, ACC, ACCQP, STPMIN, EPSMACH,
     /           WA, DGX, DGX1, DFX, DFX1, EPSSUCC, RHOB, GEPS, EPSGRD
      LOGICAL    ACTIVE
      INTEGER    NOTOT, NOFAIL, NOSUCC, NFTOT, NDFTOT, NEFTOT, NOEX, 
     /           NOEXGT, NDFEQU, NOBETT, IOUT1, IOUT2, IOUT3, IOUT4,
     /           I, J, L, IPRINT, MAXFUN, MAXIT, MODE, MAXNM, NTPA, 
     /           NTPE, NTP, MNN2, NF, NDF, IFAIL, ME, MI, M, IWA 
      COMMON     /TESTR/ EPSGRD
      EXTERNAL   QL
C
C   Open output files 
C
      IOUT1 = 61
      IOUT2 = 62
      IOUT3 = 63
      IOUT4 = 64
      OPEN(IOUT1,FILE='TEST.DAT',STATUS='UNKNOWN')
      OPEN(IOUT2,FILE='TEMP.DAT',STATUS='UNKNOWN')
      OPEN(IOUT3,FILE='RESULT.DAT',STATUS='UNKNOWN')
      OPEN(IOUT4,FILE='TEST.TEX',STATUS='UNKNOWN')
C
C   Tolerances for calling optimization routine
C
      IPRINT  = 2
      MAXFUN  = 30
      MAXIT   = 3000
      MODE    = 0
      MAXNM   = 30      
      RHOB    = 1.0D4
      L       = 1
      STPMIN  = 1.0D-10
      ACC     = 1.0D-7
      ACCQP   = 1.0D-13
      EPSSUCC = 0.01D0
      EPSGRD  = 1.0D-8      
C                                                                                    
C   Initializing counters  
C
      NOTOT  = 0
      NOFAIL = 0
      NOSUCC = 0
      NFTOT  = 0
      NDFTOT = 0
      NEFTOT = 0
      NOEX   = 0
      NOEXGT = 0
      NOBETT = 0
C                                                                               
C   Initial data for executing test problems in a loop
C                                                                               
      NTPA = 1
      NTPE = 395
      NTP  = NTPA       
    1 CONTINUE   
C
C   Some test problem numbers do not exist
C    
      IF (NTP.EQ.58.OR.NTP.EQ.82.OR.NTP.EQ.94
     / .OR.NTP.EQ.115.OR.(NTP.GT.119.AND.NTP.LT.200)
     / .OR.NTP.EQ.306.OR.NTP.EQ.313.OR.NTP.EQ.349.OR.NTP.EQ.363
     / .OR.NTP.EQ.390) GOTO 3
C                                                                               
C   Initialize test problem                                                                
C              
      CALL CONV(1)  
      ME = NELI + NENL  
      MI = NILI + NINL  
      M  = ME + MI
      DO I = 1,N
         X(I,1) = XTP(I)
         IF (.NOT.LXL(I)) XL(I) = X(I,1) - 1.0D+5 
         IF (.NOT.LXU(I)) XU(I) = X(I,1) + 1.0D+5
         IF (X(I,1).LT.XL(I)) X(I,1) = XL(I)
         IF (X(I,1).GT.XU(I)) X(I,1) = XU(I)
      ENDDO
      MNN2 = M + N + N + 2 
      DO J = 1,M                                             
         INDEX1(J) = .TRUE.                                
      ENDDO
C
C ----------------------------------------------------------------------
C   Beginn of optimization block (reverse communication)
C
      NF   = 0
      NDF  = 0
   11 CONTINUE    
      IFAIL = 0
      DO J = 1,M
         ACTIVE(J) = .TRUE.   
      ENDDO
  100 CONTINUE
      IF (IFAIL.EQ.-1.OR.IFAIL.EQ.0) THEN
         NF = NF + 1
         CALL NLFUNC(M, ME,  N, F, G, X)
      ENDIF   
      IF (IFAIL.EQ.-2.OR.IFAIL.EQ.0) THEN
         NDF = NDF + 1
         CALL NLGRAD(M, ME, MMAX, N, F, G, DF, DG, X, GEPS)
      ENDIF   
      CALL NLPQLP(     L,     M,     ME,   MMAX,      N,  
     /              NMAX,   MNN2,      X,      F,      G,
     /                DF,     DG,      U,     XL,     XU,
     /                 C,      D,    ACC,  ACCQP, STPMIN,
     /            MAXFUN,  MAXIT,  MAXNM,   RHOB, IPRINT,
     /              MODE,  IOUT1,  IFAIL,     WA,    LWA,
     /               IWA,   LIWA, ACTIVE, LACTIV, .TRUE.,
     /                QL)
      IF (IFAIL.LT.0) GOTO 100
C
C   End of optimization block
C ----------------------------------------------------------------------
C
C   Evaluate results
C
      DFX  = F(1) - FEX
      DFX1 = DFX  
      IF (FEX.NE.0.0D0) DFX1=DFX/DABS(FEX)                        
      DGX = 0.0D+0                                                      
      DO J = 1,M                                                     
         IF (J.LE.ME.OR.G(J,1).LT.0.0D+0) THEN
            DGX = DMAX1(DGX,DABS(G(J,1)))
         ENDIF  
      ENDDO         
      DO I = 1,N
         IF (X(I,1).LT.XL(I)) DGX = DGX + XL(I) - X(I,1)
         IF (X(I,1).GT.XU(I)) DGX = DGX + X(I,1) - XU(I)   
      ENDDO
      NFTOT  = NFTOT + NF
      NDFTOT = NDFTOT + NDF
      NDFEQU = NF + N*NDF
      NEFTOT = NEFTOT + NDFEQU
      WRITE(IOUT1,120) NTP,N,ME,M,IFAIL,NF,NDF,NDFEQU,FEX,F(1),
     /                 DFX1,DGX
      WRITE(IOUT4,150) NTP,N,ME,M,IFAIL,NF,NDF,NDFEQU,FEX,F(1),
     /                 DFX1,DGX
      IF (DFX1.LT.EPSSUCC.AND.DGX.LT.EPSSUCC**2) THEN
         NOSUCC = NOSUCC + 1
         NOEX   = NOEX + 1
         IF (DFX1.LT.-EPSSUCC) THEN
            WRITE(IOUT3,175) NTP
            NOBETT = NOBETT + 1
         ENDIF
      ELSE   
      IF (IFAIL.EQ.0.AND.DGX.LT.EPSSUCC**2.AND.DFX1.GE.EPSSUCC) THEN
         NOSUCC = NOSUCC + 1
         NOEXGT = NOEXGT + 1
         WRITE(IOUT3,160) NTP
      ELSE
         NOFAIL = NOFAIL + 1
         WRITE(IOUT3,170) NTP
      ENDIF
      ENDIF
      IF (IFAIL.GT.0) WRITE(IOUT3,180) IFAIL,NTP
  200 CONTINUE    
      NOTOT = NOTOT + 1   
C                                                                               
C   Next problem                                                                
C                                                                               
    3 NTP = NTP + 1                                       
      IF (NTP.LE.NTPE) GOTO 1
      IF (NOSUCC.GT.0) WRITE(IOUT2,130) EPSGRD,ACC,ACCQP,
     /          NOTOT,NOSUCC,NOFAIL,INT(DBLE(NFTOT/NOSUCC)),
     /          INT(DBLE(NDFTOT/NOSUCC)),INT(DBLE(NEFTOT/NOSUCC)),
     /          NOEX,NOEXGT
      IF (NOSUCC.GT.0) WRITE(IOUT3,140) EPSGRD,ACC,
     /          NOTOT,NOSUCC,NOBETT,NOEXGT,NOFAIL,EPSSUCC
      IF (NOSUCC.GT.0) WRITE(IOUT3,141) INT(DBLE(NFTOT/NOSUCC)),
     /          INT(DBLE(NDFTOT/NOSUCC)),
     /          INT(DBLE(NEFTOT/NOSUCC))
      CLOSE(IOUT1)
      CLOSE(IOUT2)
      CLOSE(IOUT3)
      CLOSE(IOUT4)
C      
  120 FORMAT('TP',5I4,3I8,2D16.8,2D11.3)              
  130 FORMAT(3X,4D8.1,8I6,E10.2)    
  140 FORMAT(//,' *** NUMERICAL RESULTS ***',///,
     /  ' Tolerance for gradient approximation:           ',D14.1,//,
     /  ' Termination accuracy for NLP routine:           ',D14.1,//,
     /  ' Total number of test runs:                      ',I14,//,
     /  ' Number of successful test runs:                 ',I14,/,
     /  ' - constraint violation less than squared tolerance and',
     //,'   either error in objective less than tolerance or',/,
     /  '   termination criteria of NLP routine satisfied',//,
     /  ' Number of better test runs:                     ',I14,/,
     /  ' - constraint violation less than squared tolerance and',
     //,'   error in objective less than -tolerance',//,
     /  ' Number of local solutions obtained:             ',I14,//,
     /  ' Number of runs without satisfying termination accuracy:',I7,/,
     /  ' - as indicated by NLP routine, i.e. IFAIL>0',//,
     /  ' Tolerance for determining successful return:    ',D14.1)
  141 FORMAT(//,   
     /  ' Average number of function evaluations:         ',I14,/,
     /  ' - NLFUNC calls for successful returns',//,
     /  ' Average number of gradient evaluations:         ',I14,/,
     /  ' - NLGRAD calls for successful returns',//,
     /  ' Average number of equivalent function calls     ',I14,/,
     /  ' - additionlly counted function calls for gradient ',
     /                                              'approximations',//)
  150 FORMAT(I4,' &',I4,' &',I4,' &',I4,' &',I4,' &',
     /        I8,'& ',I8,' &',I8,' &',E16.8,' &',E16.8,' &',E11.2,' &',
     /        E11.2,' \\')     
  160 FORMAT(' *** Local solution:  TP',I3) 
  170 FORMAT(' *** False solution:  TP',I3) 
  175 FORMAT(' *** Better solution: TP',I3) 
  180 FORMAT(' *** Message IFAIL=',I4, ': TP',I3) 
C                                                                               
C   End of test program                                                        
C                                                                               
      STOP                                                              
      END
      SUBROUTINE NLFUNC(M, ME, N, F, G, X)
C
C********************************************************************
C
C   Evaluation of test problem functions 
C
C*********************************************************************
C
      IMPLICIT NONE
      INTEGER    NMAX, MMAX
      PARAMETER (NMAX = 101, 
     /           MMAX = 50) 
      COMMON     /L1/  NTP, NILI, NINL, NELI, NENL 
     /           /L2/  XTP(NMAX)                              
     /           /L3/  GTP(MMAX)           
     /           /L4/  DFTP(NMAX)          
     /           /L5/  DGTP(NMAX*MMAX)        
     /           /L6/  FXTP
     /           /L9/  INDEX1(MMAX)     
     /           /L10/ INDEX2(MMAX)
     /           /L11/ LXL(NMAX)       
     /           /L12/ LXU(NMAX)    
     /           /L13/ XL(NMAX)     
     /           /L14/ XU(NMAX)    
      LOGICAL    INDEX1, INDEX2, LXL, LXU      
      INTEGER    M, ME, N, NTP, NILI, NINL, NELI, NENL, MI,
     /           I, J
      REAL*8     XTP, GTP, DFTP, DGTP, FXTP, XL, XU, F, G(M), X(N)
C                                                                               
      DO I = 1,N                           
         XTP(I) = X(I)        
      ENDDO   
      CALL CONV(2)  
      F = FXTP
      IF (M.EQ.0) RETURN                     
      DO J = 1,M 
         INDEX1(J) = .TRUE. 
      ENDDO   
      CALL CONV(4)                                
      IF (ME.EQ.0) GOTO 5                     
      DO J = 1,ME  
         G(J) = GTP(J+M-ME)
      ENDDO   
    5 IF (ME.EQ.M) RETURN                 
      DO J = ME+1,M
         G(J) = GTP(J-ME)	   	                    
      ENDDO   
C                                                                               
C   End of function evaluation
C                                                                               
      RETURN                                                    
      END                                                  
      SUBROUTINE NLGRAD(M, ME, MMAX, N, F, G, DF, DG, X, GEPS)
C
C*********************************************************************
C
C   Gradient evaluation by differnce formulae
C
C*********************************************************************
C
      IMPLICIT NONE
      REAL*8  F, G(MMAX), X(N), DF(N), DG(MMAX,N), GEPS(MMAX)
      INTEGER M, ME, MMAX, N, I, J
      REAL*8  EPSI, EPSA, FEPS, XOLD, UFL
      COMMON  /TESTR/ EPSGRD
      REAL*8  EPSGRD
C
      UFL = DSQRT(DSQRT(EPSGRD))
C                                                                               
C   One-sided differences
C          
      DO I = 1,N
         XOLD = X(I)   
         EPSA = EPSGRD*DMAX1(UFL,DABS(X(I)))
         EPSI = 1.0D0/EPSA
         X(I) = X(I) + EPSA
         CALL NLFUNC(M, ME, N, FEPS, GEPS, X)
         DF(I) = EPSI*(FEPS - F)
         DO J=1,M
            DG(J,I) = EPSI*(GEPS(J) - G(J))
         ENDDO   
         X(I) = XOLD
      ENDDO   
C                                                                               
C   End of gradient evaluation                                                      
C                                                                               
      RETURN         
      END             
C      