C*********************************************************************
C      TEST_FRAMEMISQP.FOR
C*********************************************************************
C
C          TESTPROGRAM FOR SOLVING ALL NONLINEAR MIXED-INTEGER
C                        TEST PROBLEMS BY MISQP        
C             
C
C
C   The Mathematical Problem: 
C
C   Test examples are presented for the mixed-integer nonlinear program 
C   (MINLP)
C
C             minimize        f(x,y)
C             subject to      g_j(x,y)    =  0  , j=1,...,me
C                             g_j(x,y)   >=  0  , j=me+1,...,m
C                             xl  <=  x  <=  xu
C                             yl  <=  y  <=  yu
C
C   where x is a real, and y an integer variable vector including the
C   binary variables.
C
C
C
C   Purpose:
C
C   Test problems are executed in a loop and perfomance summary is computed
C   based on a decision whether the result of a test run is considered as a 
C   successful one or not.
C
C
C
C   Output:
C
C   a) TEST.DAT:
C      Original output of MISQP depending on the flag IPRINT, moreover a 
C      one-line summary of the form
C
C      MITP41 (nvs24)  0  10   0   0  10   0      1466  74      1466\\
C           -0.10332000D+04 -0.10318000D+04  0.39984000D+06  0.136D-02  \\
C            0.000D+00  0.000D+00
C
C      where the following data are displayed,
C      1.  PNAM      - test problem number  
C      2.  NCONT     - number of continuous variables
C      3.  NINT      - number of integer variables
C      4.  NBIN      - number of binary variables
C      5.  ME        - number of equality constraints  
C      6.  M         - number of all constraints  
C      7.  IFAIL     - error code (termination reason)                             
C      8.  NGRAD     - number of iterations, corresponds to number of 
C                      gradient evaluations subject to continuous variables         
C      9.  NEFUNC    - number of equivalent function calls including those
C                      needed for derivative approximations
C      10. FEX       - exact objective function value, as far as known
C      11. F         - last computed objective function value rep[orted by 
C                      MISQP
C      12. F0        - objective function value at starting point
C      13. DFX       - relative error of computed objective function value                   
C      14. DGX       - maximum constraint violation
C      15. XINT      - error of integrality condition           
C
C   b) TEST1.TEX:
C      Generation of characteristic problem parameters,
C      1.  IPROB     - serial execution number
C      2.  PNAM      - test problem number  
C      3.  PREF      - reference citation
C      4.  NCONT     - number of continuous variables
C      5.  NINT      - number of integer variables
C      6.  NBIN      - number of binary variables
C      7.  ME        - number of equality constraints  
C      8.  M         - number of all constraints  
C      9.  FEX       - exact objective function value, as far as known
C
C   c) TEST2.TEX:
C      Generation of numerical results,
C      1.  IPROB     - serial execution number
C      2.  IFAIL     - error code (termination reason)                             
C      3.  NGRAD     - number of iterations, corresponds to number of 
C                      gradient evaluations subject to continuous variables         
C      4.  NEFUNC    - number of equivalent function calls including those
C                      needed for derivative approximations
C      5.  F         - last computed objective function value reported by 
C                      MISQP
C      6.  DFX       - relative error of computed objective function value                   
C      7.  DGX       - maximum constraint violation
C      8.  TRUNTP    - execution time (sec)           
C
C  d)  RESULT.DAT:
C      Summary of results, average performance data,
C      1.  EPS       - tolerance for gradient approximation
C      2.  ACC       - termination accuracy
C      3.  NOTOT     - total number of test runs
C      4.  NOSUCC    - number of successful test runs, where constraint
C                      violation less than squared tolerance and where
C                      either error in objective less than tolerance or
C                      termination criteria of MISQP are satisfied
C      5.  NOBETT    - number of better test runs, i.e., number of test 
C                      runs, where constraint violation less than squared 
C                      tolerance and where error in objective fnuction value
C                      is less than negative tolerance value
C      6.  NOEXGT    - number of local solutions obtained, where constraint 
C                      violation less than squared tolerance, and where
C                      error in objective function value is greater than 
C                      tolerance, but termination criteria of MISQP are
C                      satisfied (IFAIL=0)
C      7.  NOFAIL    - number of non-successful runs without satisfying 
C                      termination accuracy (IFAIL>0).
C      8.  EPSSUCC   - tolerance for determining successful return as 
C                      outlined above
C      9.  NDFTOT    - avarage number of iterations, corresponds to average
C                      number of gradient evaluations subject to continuous 
C                      variables   
C      10. NEFTOT    - average number of equivalent function calls including
C                      those needed for derivative approximations 
C      11. TRUN      - Average execution time (log mean)
C      12. DFX1MEAN  - Average error in objective function values of local 
C                      solutions
C
C   d) TIME.DAT:
C      Some data as above including execution time,    
C      1.  IPROB     - serial execution number
C      2.  NCONT     - number of continuous variables
C      3.  NINT      - number of integer variables
C      4.  NBIN      - number of binary variables
C      5.  ME        - number of equality constraints  
C      6.  M         - number of all constraints  
C      7.  TRUN      - Execution time (sec)
C
C
C
C   Linking:     
C
C   The test program must be linked with the code SETUP to intialize the test 
C   and to retrieve some characteristic data, the function evaluation code 
C   FUNCTIONS, the nonlinear mixed-integer solver MISQP, the branch-
C   and-bound code BFOUR, the Cholesky decomposition code CHOLKY, and the
C   mixed-integer quadratic programming code MIQL.
C
C  NOTE: Execution of test example MITP10 requires availability of input data
C        read from a file with name 'INPUT.DAT'.
C
C
C
C   Authors:       T. Lehmann, O. Exler, K. Schittkowski, Department of 
C                  Computer Science, University of Bayreuth, D-95440 Bayreuth, 
C                  Germany
C
C
C
C   References:    O. Exler, K. Schittkowksi (2007): A trust region SQP 
C                  algorithm for mixed-integer nonlinear programming, 
C                  Optimization Letters, Vol. 1, 269-280
C
C                  T. Lehmann, K. Schittkowski, T. Spickenreuther (2009): 
C                  MIQL: A Fortran subroutine for mixed-integer convex quadratic 
C                  programming based on branch-and-cut, User's guide, Report, 
C                  Department of Computer Science, University of Bayreuth, 
C                  Germany
C
C                  O. Exler, T. Lehmann, K. Schittkowski (2009): MISQP: A 
C                  Fortran implementation of a trust region SQP algorithm 
C                  for mixed-integer nonlinear programming - User's guide, 
C                  Report, Department of Computer Science, University of 
C                  Bayreuth, Germany
C
C
C
C   Version:    
C      
C    1.0   (Oct, 2009) - first implementation
C    1.1   (Nov, 2009) - XEX eliminated                   
C    1.2   (May, 2010) - version 3.2 of MISQP
C    2.0   (Jul, 2010) - version 4.0 of MISQP
C    3.0   (Feb, 2012) - multiple versions of MISQP
C
C***********************************************************************
C
      IMPLICIT     NONE
      INTEGER      NMAX, MMAX, MAXNDE, MMAX0, LERW, LEIW, LELW
      PARAMETER   (NMAX   = 1000, 
     /             MMAX   = 1000, 
     /             MAXNDE = 500,
     /             MMAX0  = 2*MMAX + NMAX + 20,
     /             LERW   = 7*NMAX*NMAX/2 + MMAX0*NMAX + 105*NMAX
     /                      + 37*MMAX0 + 3*MAXNDE + 3*MMAX*MMAX/2
     /                      + 4*MMAX*NMAX + 500,  
     /             LEIW   = 14*NMAX + 6*MMAX0 + 6*MAXNDE + 150,
     /             LELW   = 4*NMAX + MMAX0 + 100)
      REAL*8       X(NMAX), X0(NMAX), G(MMAX), DF(NMAX), 
     /             DG(MMAX,NMAX), XL(NMAX), XU(NMAX), 
     /             RWORK(LERW)   
      LOGICAL      LWORK(LELW)
      CHARACTER*30 PNAM, PREF
      REAL         TRUN, TRUNTP
      REAL*8       ACC, DGX, DFX, DFX1, DFX1MEAN, F, FEX, F0, 
     /             EPSSUCC, EPS, XINT, SCF, SCG(MMAX), ROPT(60), 
     /             EPSSUCG
      INTEGER      N, M, ME, NCONT, NINT, NBIN, NOTOT, NOFAIL, I, J,
     /             NOSUCC, NOSCC0, NFTOT, NDFTOT, NEFTOT, NOEX,
     /             NOEXGT, NOBETT, NFUNC, NEFUNC, NGRAD, IEVAL, MNFS,
     /             IPRINT, IOUT1, IOUT2, IOUT3, IOUT7, NREST, VERSION,
     /             LAST_VERSION, NDERIV, IDIFF, NDE, 
     /             IOUT4, IOUT5, IOUT6, IFAIL, IPROB, NPROB, MAXIT,
     /             MNN, IOPT(60),LERW0,LEIW0,LELW0,MMAX00, IWORK(LEIW)
      integer :: counti, countf, count_rate
      LOGICAL      IDERIV(NMAX), LOPT(60)
C
C   Open output files   
C
      IOUT1 = 61
      IOUT2 = 62
      IOUT3 = 63
      IOUT4 = 64
      IOUT5 = 65
      IOUT6 = 66
      IOUT7 = 67
      OPEN(IOUT1,FILE='TEST.DAT',
     /                STATUS='UNKNOWN')
      OPEN(IOUT3,FILE='RESULT.DAT',STATUS='UNKNOWN')
      OPEN(IOUT4,FILE='TEST1.TEX',STATUS='UNKNOWN')
      OPEN(IOUT5,FILE='TEST2.TEX',STATUS='UNKNOWN')
      OPEN(IOUT6,FILE='TIME.DAT',STATUS='UNKNOWN')
      OPEN(IOUT7,FILE='EVALUATE.DAT',STATUS='UNKNOWN')
C
C   Loop over versions
C
      VERSION = 1
      LAST_VERSION = 1
      WRITE(IOUT7,*) LAST_VERSION-VERSION+1, 200
 1000 CONTINUE  
C
C   Define version
C    
      IF (VERSION.EQ.1) THEN
         WRITE(6,*) ' *** MISQPscale1_16 (version 1)'
         WRITE(IOUT1,*) ' *** MISQPscale1_16 (version 1)'
         WRITE(IOUT3,*) ' *** MISQPscale1_16 (version 1)'
         WRITE(IOUT6,*) ' *** MISQPscale1_16 (version 1)'
      END IF    
      IF (VERSION.EQ.2) THEN
         WRITE(6,*) ' *** MISQPcuts_2 (version 2)'
         WRITE(IOUT1,*) ' *** MISQPscale2_2 (version 2)'
         WRITE(IOUT3,*) ' *** MISQPscale2_2 (version 2)'
         WRITE(IOUT6,*) ' *** MISQPscale2_2 (version 2)'
      END IF
      IF (VERSION.EQ.3) THEN
         WRITE(6,*) ' *** MISQPscale0_15 (version 3)'
         WRITE(IOUT1,*) ' *** MISQPscale0_15 (version 3)'
         WRITE(IOUT3,*) ' *** MISQPscale0_15 (version 3)'
         WRITE(IOUT6,*) ' *** MISQPscale0_15 (version 3)'
      END IF
      IF (VERSION.EQ.4) THEN
         WRITE(6,*) ' *** MISQPbmod_3 (version 4)'
         WRITE(IOUT1,*) ' *** MISQPbmod_3 (version 4)'
         WRITE(IOUT3,*) ' *** MISQPbmod_3 (version 4)'
         WRITE(IOUT6,*) ' *** MISQPbmod_3 (version 4)'
      END IF
      IF (VERSION.EQ.5) THEN
         WRITE(6,*) ' *** MISQPider_11 (version 5)'
         WRITE(IOUT1,*) ' *** MISQPider_11 (version 5)'
         WRITE(IOUT3,*) ' *** MISQPider_11 (version 5)'
         WRITE(IOUT6,*) ' *** MISQPider_11 (version 5)'
      END IF
      IF (VERSION.EQ.6) THEN
         WRITE(6,*) ' *** MISQPrest0_12 (version 6)'
         WRITE(IOUT1,*) ' *** MISQPrest0_12 (version 6)'
         WRITE(IOUT3,*) ' *** MISQPrest0_12 (version 6)'
         WRITE(IOUT6,*) ' *** MISQPrest0_12 (version 6)'
      END IF
      IF (VERSION.EQ.7) THEN
         WRITE(6,*) ' *** MISQP_5_restarts (version 7)'
         WRITE(IOUT1,*) ' *** MISQP_5_restarts (version 7)'
         WRITE(IOUT3,*) ' *** MISQP_5_restarts (version 7)'
         WRITE(IOUT6,*) ' *** MISQP_5_restarts (version 7)'
      END IF
      IF (VERSION.EQ.8) THEN
         WRITE(6,*) ' *** MISQP_fwddiff (version 8)'
         WRITE(IOUT1,*) ' *** MISQP_fwddiff (version 8)'
         WRITE(IOUT3,*) ' *** MISQP_fwddiff (version 8)'
         WRITE(IOUT6,*) ' *** MISQP_fwddiff (version 8)'
      END IF
      IF (VERSION.EQ.9) THEN
         WRITE(6,*) ' *** MISQP_mono (version 9)'
         WRITE(IOUT1,*) ' *** MISQP_monotone (version 9)'
         WRITE(IOUT3,*) ' *** MISQP_monotone (version 9)'
         WRITE(IOUT6,*) ' *** MISQP_monotone (version 9)'
      END IF
      IF (VERSION.EQ.10) THEN
         WRITE(6,*) ' *** MISQP_xscale (version 10)'
         WRITE(IOUT1,*) ' *** MISQP_monotone (version 10)'
         WRITE(IOUT3,*) ' *** MISQP_monotone (version 10)'
         WRITE(IOUT6,*) ' *** MISQP_monotone (version 10)'
      END IF
C
C   Select test problem range
C
      IPROB = 1  
      NPROB = 200  
c        
C   Initial constants, tolerances, counters          
C
      NOTOT    = 0
      NOFAIL   = 0
      NOSUCC   = 0
      NOBETT   = 0
      NFTOT    = 0
      NDFTOT   = 0
      NEFTOT   = 0
      DFX1MEAN = 0.0D0
      NOEX     = 0 
      NOEXGT   = 0
      TRUN     = 0.0D0
      IPRINT   = 2
      IFAIL    = 0
      IEVAL    = 0
      MAXIT    = 300   
      MNFS     = 10
      NREST    = 0
      EPS      = 1.0D-6
      ACC      = 1.0D-6
      EPSSUCC  = 0.01D0 
      EPSSUCG  = EPSSUCC**2
C
C   Internal loop over problems
C
    1 CONTINUE 
C 
C   Initialize counters
C     
      NFUNC  = 0
      NEFUNC = 0
      NGRAD  = 0
C
C   Get problem parameters
C
      call get_minlp_prob(     0,  iprob,     m,     me,  mmax,
     /                     ncont,   nbin,  nint,   nmax,    x0,
     /                        xl,     xu,      f,     g,   pnam,
     /                      pref,    fex )     
C
C   Set parameters and tolerances
C
      N   = NCONT + NINT + NBIN      
      MNN = M + N + N                                            
C
C   Small problems   
C         
cc      IF (NBIN.GT.40.OR.NINT.GT.40) THEN
c      IF (N.GT.80) THEN
c         IF (IPROB.LT.NPROB) THEN
c            IPROB = IPROB + 1
c            GOTO 1
c         ELSE
c            GOTO 10
c         END IF      
c      END IF 
C
C   Initialize option arrays
C                      
      DO I=1,60
         ROPT(I) = -1.D0
         IOPT(I) = -1
         LOPT(I) = .TRUE.
      END DO      
      ROPT(7) = 1.0D0 
      DO I=NCONT+1,N
         IF (XU(I)-XL(I).GT.ROPT(7)) ROPT(7) = XU(I) - XL(I)
      END DO
      ROPT(7) = DMIN1(1.0D1,ROPT(7))   
C
      DO I=NCONT+1,N
         X0(I) = DNINT(X0(I))
      END DO
      DO I=1,N
         X(I) = X0(I)
      END DO 
      DO I=1,NINT+NBIN
         IDERIV(I) = .FALSE.
      END DO             
      WRITE(*,*) '** Test problem:',IPROB,PNAM
C
C   Initialize scaling values
C      
      SCF = 1.0D0
      DO J=1,M
         SCG(J) = 1.0D0
      END DO 
C
C   Loop over different versions
C
      IDIFF = 1
      IF (VERSION.EQ.1) THEN
C ... default tolerances       
         NDERIV = NCONT   
      END IF   
      
      IF (VERSION.EQ.2) THEN
C ... external function scaling 
         NDERIV = NCONT
         IOPT(1) = 0
         DO I=NCONT+NBIN+1,N
            X(I) = DMAX1(XL(I),DMIN1(1.0D0,XU(I)))
         END DO   
         CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF, 
     /               G, SCG, X)     
         IF (DABS(F).GT.1.0D-0) THEN
            SCF = 1.0D0/DABS(F)
         END IF   
         DO J=1,M
            IF (DABS(G(J)).GT.1.0D0) SCG(J) = 1.0D0/DABS(G(J))
         END DO   
         DO I=NCONT+NBIN+1,N
            X(I) = X0(I)
         END DO   
      END IF
      
      IF (VERSION.EQ.3) THEN
C ... function scaling suppressed
         NDERIV = NCONT      
         IOPT(1) = 0
      END IF   
      
      IF (VERSION.EQ.4) THEN
C ... internal scaling of matrix B_k suppressed 
         NDERIV = NCONT      
         LOPT(2) = .FALSE.
      END IF   
      
      IF (VERSION.EQ.5) THEN
C  ... partial derivatives of integer variables computed by difference formula
         NDERIV = N
         DO I=1,NINT+NBIN
            IDERIV(I) = .TRUE.
         END DO             
      END IF   
      
      IF (VERSION.EQ.6) THEN
C  ... restarts suppressed
         NDERIV = NCONT      
         IOPT(6) = 0
      END IF   
      
      IF (VERSION.EQ.7) THEN
C  ... 5 restarts
         NDERIV = NCONT      
         IOPT(6) = 5    
c         LOPT(3) = .FALSE.
      END IF   
      
      IF (VERSION.EQ.8) THEN
C  ... forward difference formula for continuous derivatives
         NDERIV = NCONT      
         IDIFF = 3 - IDIFF
      END IF   
      
      IF (VERSION.EQ.9) THEN
C ... no monotone trust regions
         NDERIV = NCONT             
         IOPT(2) = 0     
      END IF   

      IF (VERSION.EQ.10) THEN
C ... no scaling of continuous variables
         NDERIV = NCONT             
         LOPT(1) = .FALSE.     
      END IF                        
c      CALL CPU_TIME(TRUN1)
      call system_clock(counti,count_rate)
C
C ----------------------------------------------------------------------
C   Call MISQP with reverse communication, integer variables treated as 
C   non-relaxable
C                                 
      MMAX00 = M + ME + NINT + NBIN + 20
      LERW0 = 7*N*N/2 + MMAX00*N + 105*N + 37*MMAX00 + 3*MAXNDE 
     /        + 3*M*M/2 + 4*M*N + 500     
      LEIW0 = 14*N + 6*MMAX00 + 6*MAXNDE + 150
      LELW0 = 4*N + MMAX00 + 150
c      NDE = MIN0(MAXNDE,10*(NBIN+NINT))
      NDE = MAXNDE
C
C   Optimization loop
C
      IFAIL = 0         
   20 CONTINUE                    
      IF ((IFAIL.EQ.0).OR.(IFAIL.EQ.-1)) THEN
         CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF, 
     /               G, SCG, X)
         NFUNC = NFUNC + 1
         NEFUNC = NEFUNC + 1
      END IF   
      IF (((IFAIL.EQ.0).OR.(IFAIL.EQ.-2)).AND.(NDERIV.GT.0)) THEN
         CALL NLGRAD(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF, 
     /               G, SCG, DF, DG, X, NDERIV, EPS, IDIFF)
         NGRAD = NGRAD + 1
         NEFUNC = NEFUNC + DBLE(IDIFF)*NDERIV  + 1
      END IF         
      CALL MISQP(     M,     ME,   MMAX,      N,   NBIN,       
     /             NINT,      X,      F,      G,     DF, 
     /               DG,     XL,     XU,    ACC,  MAXIT, 
C     /             MNFS, MAXNDE, IPRINT,  IOUT1,  IFAIL, 
     /             MNFS,    NDE, IPRINT,  IOUT1,  IFAIL, 
     /           IDERIV,   ROPT,   IOPT,   LOPT,  RWORK,
     /            LERW0,  IWORK,  LEIW0,  LWORK,  LELW0)  
      IF (IFAIL.EQ.-1.OR.IFAIL.EQ.-2) GOTO 20
      IF (IFAIL.GT.100) WRITE(6,*) ' *** ERROR MIQL:',IFAIL-100
C ----------------------------------------------------------------------       
C   End of optimization block, compute statistics
C
C      CALL CPU_TIME(TRUN2)
      call system_clock(countf)
      TRUNTP = REAL(countf-counti)/REAL(count_rate)
C
C  Final unscaled objective function value
C
      SCF = 1.0D0
      IF (IOPT(1).GE.1) THEN
         DO J=1,M
            SCG(J) = RWORK(J+1)
         END DO
      END IF      
      CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF, 
     /            G, SCG, X)
C
C  Constraint violation
C
      DGX = 0.0D0
      IF (M.GT.0) THEN
         DO I=1,ME
            DGX = DMAX1(DGX,DABS(G(I)))
         END DO
         DO I=ME+1,M
            DGX = DMAX1(DGX,-G(I))
         END DO
      END IF   
C
C  Function value at starting point
C      
      CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F0, SCF, 
     /            G, SCG, X0)
C
C  Error in objective function
C      
      DFX = F - FEX
      DFX1 = DFX  
      IF (FEX.NE.0.0D0) DFX1 = DFX/DABS(FEX)  
C 
C  Error in integrality condition
C      
      XINT = 0.0D0
      DO I=NCONT+1,N
         XINT = XINT + DABS(X(I) - DNINT(X(I)))
      END DO    
C
C   Output
C      
      WRITE(IOUT1,120) PNAM, NCONT, NINT, NBIN, ME, M, IFAIL, 
     /                 NGRAD, NEFUNC, FEX, F, F0, DFX1, DGX, XINT
      WRITE(IOUT4,150) IPROB, PNAM, PREF, NCONT, NINT, NBIN, ME, M, FEX
c      WRITE(IOUT5,151) IPROB, PNAM, NEFUNC, F, DFX1, DGX, TRUNTP
c      WRITE(IOUT5,151) IPROB, PNAM, NEFUNC, F, DGX, TRUNTP
      WRITE(IOUT5,151) IPROB, PNAM, NEFUNC, F, DGX, TRUNTP
C
C   Performance evaluation
C     
      NOSCC0 = NOSUCC
      IF (DFX1.LT.EPSSUCC .AND. DGX.LT.EPSSUCG) THEN
         NOSUCC = NOSUCC + 1
         NOEX   = NOEX + 1
         NFTOT  = NFTOT + NFUNC
         NDFTOT = NDFTOT + NGRAD
         NEFTOT = NEFTOT + NEFUNC
         IFAIL  = 0
         TRUN   = TRUN + TRUNTP
         IF (DFX1.LT.-EPSSUCC) THEN
            WRITE(IOUT3,175) IPROB, PNAM, F, FEX
            NOBETT = NOBETT + 1
         END IF
         IEVAL = 0
      ELSE   
      IF (IFAIL.LE.2.AND.DGX.LT.EPSSUCG.AND.DFX1.GE.EPSSUCC) THEN
C     /            .OR.(IFAIL.EQ.2.AND.DGX.LT.EPSSUCG)) THEN
         NOSUCC = NOSUCC + 1
         NOEXGT = NOEXGT + 1
         WRITE(IOUT3,160) IPROB, PNAM, DFX1, F, FEX
         DFX1MEAN = DFX1MEAN + DABS(DFX1)
         IEVAL = 1
      ELSE
         NOFAIL = NOFAIL + 1   
         WRITE(IOUT3,170) IPROB,PNAM
         IEVAL = 2
      END IF
      END IF  
      NOTOT = NOTOT + 1
      WRITE(IOUT6,135) IPROB, NCONT, NINT, NBIN, ME, M,
     /      TRUNTP
      WRITE(IOUT7,137) VERSION,IPROB,IEVAL,NFUNC,NGRAD,NEFUNC,TRUNTP
C        
C   Next problem                   
C        
    2 CONTINUE
      IPROB = IPROB + 1
      IF (IPROB.LE.NPROB) GOTO 1  
   10 CONTINUE        
C
C   Performance summary
C
C      NOSUCC = MAX0(1,NOSUCC)     
C      NOEXGT = MAX0(1,NOEXGT)
C      NOFAIL = MAX0(1,NOFAIL)

      IF (NOSUCC.GT.0) THEN
         WRITE(IOUT3,140) EPS, ACC, NOTOT,
     /          NOSUCC, DBLE(NOSUCC)/DBLE(NOTOT)*100.0,
     /          NOBETT, 
C     /          DBLE(NOBETT)/DBLE(NOTOT)*100.0,
     /          NOEXGT, 
C     DBLE(NOEXGT)/DBLE(NOTOT)*100.0,
C     /          DFX1MEAN/DBLE(NOEXGT),
     /          NOFAIL, DBLE(NOFAIL)/DBLE(NOTOT)*100.0,
     /          EPSSUCC, EPSSUCG, NDFTOT/NOSUCC, NEFTOT/NOSUCC,
     /          TRUN/DBLE(NOSUCC)
      END IF
C
C   Loop over versions
C      
      WRITE(6,*) 
      WRITE(IOUT1,*) 
      WRITE(IOUT3,*)
      WRITE(IOUT6,*) 
      WRITE(6,*) '-------------------------------------------------'
      WRITE(IOUT1,*) '-------------------------------------------------'
      WRITE(IOUT3,*) '-------------------------------------------------'
      WRITE(IOUT6,*) '-------------------------------------------------'
      WRITE(6,*) 
      WRITE(IOUT1,*) 
      WRITE(IOUT3,*)
      WRITE(IOUT6,*) 
      VERSION = VERSION + 1
      IF (VERSION.LE.LAST_VERSION) GOTO 1000       
C 
C   Close files
C    
      CLOSE(IOUT1)
      CLOSE(IOUT3)
      CLOSE(IOUT4)
      CLOSE(IOUT5)
      CLOSE(IOUT7)
C      
C   Format statements
C
  120 FORMAT(A30,6I4,2I10,3D16.8,3D11.3)              
  125 FORMAT(A30,F14.8)              
  130 FORMAT(3X,I3,4D8.1,8I6,E10.3)    
  135 FORMAT(6I10,F15.4)              
  136 FORMAT(I10,F10.2)              
  137 FORMAT(6I10,F12.4)              
  140 FORMAT(//,' *** NUMERICAL RESULTS ***',///,
     /  ' Tolerance for gradient approximation:           ',D14.1,//,
     /  ' Termination accuracy:                           ',D14.1,//,
     /  ' Total number of test runs:                      ',I14,//,
     /  ' Number of successful test runs:                 ',I14,2X,
     /       F10.4,'%' ,/,
     /  ' - constraint violation less than squared tolerance and',
     //,'   either error in objective less than tolerance or',/,
     /  '   termination criteria of NLP routine satisfied',//,
     /  ' Number of better test runs:                     ',I14,2X,
C     /       F10.4,'%' ,
     //,' - error in objective less than -tolerance',//,
     /  ' Number of feasible solutions obtained:          ',I14,2X,
C     /       F10.4,'%' ,
     //  ' - constraint violation less than squared tolerance,',
     //,'   error in objective greater than tolerance and',/,
     /  '   termination criteria of NLP routine satisfied',//,
C     /  ' Average function error of local solutions:      ',F14.4,//,
     /  ' Number of runs without satisfying termination accuracy',/,
     /  ' or zero integer trust-region radius:            ',I14,2X,
     /       F10.4,'%' ,/,
     /  ' - as indicated by NLP routine, i.e. IFAIL>0',//,
     /  ' Tolerance for determining successful return:    ',D14.1,/,
     /  ' Tolerance for determining violation:            ',D14.1,//,
     /  ' Average number of iterations:                   ',I14,/,
     /  ' - corresponds to average number of gradient evaluations ',/,
     /  '   subject to continuous variables', //,
     /  ' Average number of equivalent function calls:    ',I14,/,
     /  ' - plus function calls needed for derivative approximation'
     /       ,//,
     /  ' Average execution time:                         ',F14.4,
     /  ' (sec)',///)
  141 FORMAT(I4,' &',F12.1,' &',F12.1,' &',F12.1,' & ',I10,
     /      ' & ',I10,' &',F10.3,' &',F10.4,' \\')
  150 FORMAT(I4,' &',A30,' &',A30,' &',I4,' &',I4,' & ', I4,' & ',I4,
     /           ' &',I4,' &',E16.5,' \\')
  151 FORMAT(I4,' &',A30,' &',I8,' &',E16.6,' &',E11.2,' &',F12.4,' \\')   
  160 FORMAT(' *** Local solution: TP',I3,' ',A10, ' with error ',G12.4,
     /       '(',G12.5,' / ',G12.5,')') 
  170 FORMAT(' *** False solution: TP',I3,' ',A10) 
  175 FORMAT(' *** Better solution: TP',I3,' ',A10,'(',
     / G16.9,'/',G16.9,')') 
  180 FORMAT(A25, ' &', I4, ' &', I4, ' &', I6, ' &', I8, ' &'
     /         ,F10.3,'\\') 
  195 FORMAT(A25, ' &', F10.2, ' &', F10.2, ' &', F10.3, ' &', F10.3, 
     / '\\')            
  196 FORMAT(A25, ' &', I4, ' &', I4, ' &', F10.3, ' &', F10.3,
     / ' &', F10.3,'\\')  
  197 FORMAT(A25,' &',I1,' &',I3,'& ',I2,' &',G14.6,' &',G14.6,
     /       ' &',G14.6,' &',G11.3,' &',G11.3,'\\')
C        
C   End of main program              
C        
      STOP      
      END
C
C   Evaluation of derivatives (without integer!)
C
      SUBROUTINE NLGRAD(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, 
     /                  F, SCF, G, SCG, DF, DG, X, NDERIV, EPS, IDIFF)
      IMPLICIT   NONE
      INTEGER    IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, I, J,
     /           NDERIV, IDIFF
      REAL*8     F, SCF, G(MMAX), SCG(MMAX), DF(N), DG(MMAX,N), X(N), 
     /           GEPS1(1000), FEPS1, GEPS2(1000), FEPS2, EPS, EPSA, 
     /           EPSI, XBCK
C    
      CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF,
     /               G, SCG, X)
      IF (IDIFF.GT.1) GOTO 1
      EPS = 1.0D-6
      DO I=1,NDERIV
         XBCK = X(I)
         EPSA = EPS*DMAX1(1.0D-4,DABS(X(I)))
         EPSI = 1.0D0/EPSA
         X(I) = X(I) + EPSA         
         CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, FEPS1,SCF,
     /               GEPS1, SCG, X)
         DF(I) = EPSI*(FEPS1 - F)
         DO J=1,M
            DG(J,I) = EPSI*(GEPS1(J) - G(J))
         END DO
         X(I) = XBCK
      END DO
      RETURN
C      
    1 CONTINUE      
      EPS = 1.0D-5
      DO I=1,NDERIV 
         EPSA = EPS*DMAX1(1.0D-4,DABS(X(I)))
         EPSI = 0.5D0/EPSA
         XBCK = X(I)
         X(I) = X(I) + EPSA
         CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, FEPS1,SCF,
     /               GEPS1, SCG, X)
         X(I) = XBCK - EPSA
         CALL NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, FEPS2,SCF,
     /               GEPS2, SCG, X)
         DF(I) = EPSI*(FEPS1 - FEPS2)
         DO J=1,M
            DG(J,I) = EPSI*(GEPS1(J) - GEPS2(J))
         END DO
         X(I) = XBCK
      END DO
C
C   End of NLGRAD
C
      RETURN
      END
C
C   Evaluation of function values
C
      SUBROUTINE NLFUNC(IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, F, SCF,
     /                  G, SCG, X)
      IMPLICIT   NONE
      INTEGER    IPROB, M, ME, MMAX, N, NMAX, NBIN, NINT, NCONT, J
      REAL*8     F, FEX, SCF, G(MMAX), SCG(MMAX), X(NMAX), 
     /           XL(1000), XU(1000)
      CHARACTER*30 PNAM, PREF

C
      ncont = n - nint - nbin
      call get_minlp_prob(     1,  iprob,     m,     me,  mmax,
     /                     ncont,   nbin,  nint,   nmax,     x,
     /                        xl,     xu,      f,      g,   pnam,
     /                      pref,    fex )
      F = F*SCF
      DO J=1,M
         G(J) = G(J)*SCG(J)
      END DO   
C
C   End of NLFUNC
C
      RETURN
      END
C