C*********************************************************************
C      SOLVE_SPRING.FOR
C*********************************************************************
C
C
C          TESTPROGRAM FOR THE NONLINEAR MIXED-INTEGER CODE MISQP        
C             
C
C
C   The Mathematical Problem: 
C
C   Test examples are presented in form of mixed-integer nonlinear programs 
C   (MINLP)
C
C             minimize        f(x,y)
C             subject to      g_j(x,y)    =  0  , j=1,...,me
C                             g_j(x,y)   >=  0  , j=me+1,...,m
C                             xl  <=  x  <=  xu
C                             yl  <=  y  <=  yu
C
C   where x is a real, and y an integer variable vector including 
C   binary variabls.
C
C
C
C   Purpose:
C
C   Test problems are executed in a loop and perfomance summary is computed
C   based on a decision whether the result of a test run is considered as a 
C   successful one or not.
C
C
C
C   Usage:
C
C   The test program either calls a test problem code directly or, if several 
C   or all problems are to be executed in a loop, the code GET_MINLP_PROB.
C   In the latter case, the test problem is identified by a number between 1 
C   and 100. Detail are found in the corresponding report.
C
C
C
C   Authors:       K. Schittkowski, Department of Computer Science, 
C                  University of Bayreuth, D-95440 Bayreuth, Germany
C
C
C
C   References:    O. Exler, K. Schittkowksi (2007): A trust region SQP 
C                  algorithm for mixed-integer nonlinear programming, 
C                  Optimization Letters, Vol. 1, 269-280
C
C                  T. Lehmann, K. Schittkowski, T. Spickenreuther (2009): 
C                  MIQL: A Fortran subroutine for mixed-integer convex quadratic 
C                  programming based on branch-and-cut, User's guide, Report, 
C                  Department of Computer Science, University of Bayreuth, 
C                  Germany
C
C                  O. Exler, T. Lehmann, K. Schittkowski (2009): MISQP: A 
C                  Fortran implementation of a trust region SQP algorithm 
C                  for mixed-integer nonlinear programming - User's guide, 
C                  Report, Department of Computer Science, University of 
C                  Bayreuth, Germany
C
C
C
C   Version:    
C      
C    1.0   (Oct, 2009) - first implementation
C    1.1   (Nov, 2009) - XEX eliminated
C    2.0   (Nov, 2009) - new version MISQP
C    3.0   (Dec, 2010) - new test problem interface
C    4.0   (Nov, 2012) - maxcut replaced by mnfs
C
C***********************************************************************
C
      implicit     none
      integer      nmax, mmax, mmax0, maxnde, lerw, leiw, lelw
      parameter   (nmax   = 1000, 
     /             mmax   = 3000, 
     /             mmax0  = 2*mmax + 20,
     /             maxnde = 100000)
      parameter   (lerw  = 7*nmax*nmax/2 + mmax0*nmax + 102*nmax 
     /                     + 34*mmax0 + 3*maxnde + 3*mmax*mmax/2 
     /                     + 4*mmax*nmax + 400,
     /             leiw  = 14*nmax + 5*mmax0 + 6*maxnde + 105,
     /             lelw  = 4*nmax + mmax0 + 100)
      double precision x(nmax), g(mmax), df(nmax), dg(mmax,nmax), 
     /             xl(nmax), xu(nmax), geps(mmax), rw(lerw)
      logical      lw(lelw), ideriv(nmax), lopt(60)
      character*30 pnam, pref
      double precision f, feps, fex, acc, eps, xbck, ropt(60)
      integer      m, me, n, ncont, nint, nbin, ifail, maxit, mnfs, 
     /             iprint, iout, iprob, i, j, iw(leiw), iopt(60)

c   Set test problem number and prepare initial data

      iprob = 56      
      call get_minlp_prob(     0,  iprob,     m,     me,   mmax,
     /                     ncont,   nbin,  nint,   nmax,      x,
     /                        xl,    xu,      f,      g,   pnam,
     /                      pref,   fex )  

c  or call SPRING directly

c       call spring(     0,      m,    me,   mmax,  ncont, 
c     /               nbin,   nint,  nmax,      x,     xl,
c     /                 xu,      f,     g,   pnam,   pref,
c     /                fex )  
                                                                               
c   Set constants and tolerances for calling MISQP    

      do i = 1,60
         ropt(i) = -1.d0
         iopt(i) = -1
         lopt(i) = .true.
      enddo	      
      iout   = 6       ! output channel
      iprint = 2       ! print flag
      ifail  = 0       ! initialize flag
      maxit  = 1000    ! maximum number of iterations   
      mnfs   = 10      ! maximum number of steps without progress
      eps    = 1.0d-6  ! tolerance for forward differences
      acc    = 1.0d-6  ! final termination tolerance
      n      = ncont + nbin + nint
      do i=ncont+1,n
         ideriv(i) = .false.
      enddo        
      write(iout,*)
      write(iout,*) ' *** solving now ',pnam(1:10), ', fex =',fex

c   Begin of optimization block

c ----------------------------------------------------------------------
c   Call MISQP with reverse communication, integer variables treated as 
c   non-relaxable

      ifail = 0         
    1 continue

c   Evaluation of function values
   
      if ((ifail.eq.0).or.(ifail.eq.-1)) then

c   call through interface
      
         call get_minlp_prob(     1,  iprob,     m,     me,   mmax,
     /                        ncont,   nbin,  nint,   nmax,      x,
     /                           xl,    xu,      f,      g,   pnam,
     /                         pref,   fex )  

c   or call SPRING directly

c       call spring(     1,      m,    me,   mmax,  ncont, 
c     /               nbin,   nint,  nmax,      x,     xl,
c     /                 xu,      f,     g,   pnam,   pref,
c     /                fex )  
      endif   

c   approximation of partial derivatives subject to continuous
c   variables by forward differences
   
      if ((ifail.eq.0).or.(ifail.eq.-2)) then
         do i = 1, ncont
            xbck = x(i)
            x(i) = x(i) + eps

c   call through interface
            
            call get_minlp_prob(     1,  iprob,     m,     me,   mmax,
     /                           ncont,   nbin,  nint,   nmax,      x,
     /                              xl,    xu,   feps,   geps,   pnam,
     /                            pref,   fex )  

c   or call SPRING directly

c          call spring(     1,      m,    me,   mmax,  ncont, 
c     /                  nbin,   nint,  nmax,      x,     xl,
c     /                    xu,   feps,  geps,   pnam,   pref,
c     /                   fex )  
            df(i) = (feps - f)/eps
            do j = 1, m
               dg(j,i) = (geps(j) - g(j))/eps
            enddo
            x(i) = xbck
         enddo
      endif
  
c   Call driving routine 
  
      call MISQP(      m,     me,   mmax,      n,   nbin, 
     /              nint,      x,      f,      g,     df, 
     /                dg,     xl,     xu,    acc,  maxit, 
     /              mnfs, maxnde, iprint,   iout,  ifail, 
     /            ideriv,   ropt,   iopt,   lopt,     rw,
     /              lerw,     iw,   leiw,     lw,   lelw )
      if (ifail.lt.0) goto 1

c   End of optimization block
c ----------------------------------------------------------------------       

      stop      
      end
  