
      subroutine alan( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

C  GAMS:
C
C  MINLP written by GAMS Convert at 04/18/01 12:05:57
C  
C  Equation counts
C     Total       E       G       L       N       X
C         8       3       0       5       0       0
C  
C  Variable counts
C                 x       b       i     s1s     s2s      sc      si
C     Total    cont  binary integer    sos1    sos2   scont    sint
C         9       5       4       0       0       0       0       0
C  FX     0       0       0       0       0       0       0       0
C  
C  Nonzero counts
C     Total   const      NL     DLL
C        24      21       3       0
C
C  Solve m using MINLP minimizing objvar;
C
C    objvar.l = 2.89903846153846  

      implicit double precision(a-h,o-z)
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, x4, b6, b7, b8, b9, e1, e2, e4, e5,
     /        e6, e7, e8
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ALAN'
         pref  = '\cite{MINLPLib}'
         fex   = 2.89903846153846d0
         ncont = 4
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 7
         me    = 2
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo 
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      b6 = y(1)
      b7 = y(2)
      b8 = y(3)
      b9 = y(4)

      f = x1*(4.0d0*x1 + 3.0d0*x2 - x3) + x2*(3.0d0*x1 + 6.0d0*x2 + x3) 
     /    + x3*(x2 - x1 + 10.0d0*x3)
      
      e1 = x1 + x2 + x3 + x4 - 1.0d0

      e2 = 8.0d0*x1 + 9.0d0*x2 + 12.0d0*x3 + 7.0d0*x4 - 10.0d0

      e4 = x1 - b6 

      e5 = x2 - b7

      e6 = x3 - b8

      e7 = x4 - b9

      e8 = b6 + b7 + b8 + b9 - 3.0d0

      g(1) = e1
      g(2) = e2
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6
      g(6) = -e7
      g(7) = -e8

  999 continue
      return
      end

      subroutine asaadi11( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI11'
         pref  = '\cite{Asa73}'
         fex   = -0.40956609d+2
         ncont = 1
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = y(1)**2 + y(2)**2 + 2.0d0*x(1)**2 + y(3)**2 - 5.0d0*y(1)
     /       - 5.0d0*y(2) - 21.0d0*x(1) + 7.0d0*y(3)
      
      g(1) = -y(1)**2 - y(2)**2 - x(1)**2 - y(3)**2 - y(1)
     /          + y(2) - x(1) + y(3) + 8.0d0
     
      g(2) = -y(1)**2 - 2.0d0*y(2)**2 - x(1)**2 - 2.0d0*y(3)**2
     /          + y(1) + y(3) + 10.0d0
     
      g(3) = -2.0d0*y(1)**2 - y(2)**2 - x(1)**2 - 2.0d0*y(1)
     /          + y(2) + y(3) + 5.0d0

  999 continue
      return
      end

      subroutine asaadi12( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI12'
         pref  = '\cite{Asa73}'
         fex   = -38.0d0
         ncont = 0
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0d0
         enddo
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      f = y(1)**2 + y(2)**2 + 2.0d0*y(3)**2 + y(4)**2 - 5.0d0*y(1)
     /       - 5.0d0*y(2) - 21.0d0*y(3) + 7.0d0*y(4)
     
      g(1) = -y(1)**2 - y(2)**2 - y(3)**2 - y(4)**2 - y(1)
     /          + y(2) - y(3) + y(4) + 8.0d0
     
      g(2) = -y(1)**2 - 2.0d0*y(2)**2 - y(3)**2 - 2.0d0*y(4)**2
     /          + y(1) + y(4) + 10.0d0
     
      g(3) = -2.0d0*y(1)**2 - y(2)**2 - y(3)**2 - 2.0d0*y(1)
     /          + y(2) + y(4) + 5.0d0

  999 continue
      return
      end

      subroutine asaadi21( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI21'
         pref  = '\cite{Asa73}'
         fex   = 0.69490268d+3
         ncont = 3
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 2.0d0
            xu(i) = 5.0d0
         end do
         xl(1) = -4.64d-4
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do
      
      f = (y(1) - 10.0d0)**2 + 5.0d0*(y(2) - 12.0d0)**2 + y(3)**4
     /       + 3.0d0*(y(4) - 11.0d0)**2 + 10.0d0*x(1)**6 + 7.0d0*x(2)**2
     /       + x(3)**4 - 4.0d0*x(2)*x(3) - 10.0d0*x(2) - 8.0d0*x(3)

      g(1) = -2.0d0*y(1)**2 - 3.0d0*y(2)**4 - y(3) - 4.0d0*y(4)**2
     /          - 5.0d0*x(1) + 127.0d0
     
      g(2) = 7.0d0*y(1) - 3.0d0*y(2) - 10.0d0*y(3)**2 - y(4) + x(1)
     /          + 282.0d0
     
      g(3) = 23.0d0*y(1) - y(2)**2 - 6.0d0*x(2)**2 + 8.0d0*x(3) 
     /           + 196.0d0
     
      g(4) = -4.0d0*y(1)**2 - y(2)**2 + 3.0d0*y(1)*y(2) 
     /          - 2.0d0*y(3)**2 - 5.0d0*x(2) + 11.0d0*x(3)

  999 continue
      return
      end

      subroutine asaadi22( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI22'
         pref  = '\cite{Asa73}'
         fex   = 700.0d0
         ncont = 0
         nint  = 7
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 8.0d0
         end do
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      f = (y(1) - 10.0d0)**2 + 5.0d0*(y(2) - 12.0d0)**2 + y(3)**4
     /       + 3.0d0*(y(4) - 11.0d0)**2 + 10.0d0*y(5)**6 + 7.0d0*y(6)**2
     /       + y(7)**4 - 4.0d0*y(6)*y(7) - 10.0d0*y(6) - 8.0d0*y(7)

      g(1) = -2.0d0*y(1)**2 - 3.0d0*y(2)**4 - y(3) - 4.0d0*y(4)**2
     /          - 5.0d0*y(5) + 127.0d0
     
      g(2) = 7.0d0*y(1) - 3.0d0*y(2) - 10.0d0*y(3)**2 - y(4) + y(5)
     /          + 282.0d0
     
      g(3) = 23.0d0*y(1) - y(2)**2 - 6.0d0*y(6)**2 + 8.0d0*y(7) 
     /          + 196.0d0
     
      g(4) = -4.0d0*y(1)**2 - y(2)**2 + 3.0d0*y(1)*y(2) 
     /          - 2.0d0*y(3)**2 - 5.0d0*y(6) + 11.0d0*y(7)

  999 continue
      return
      end

      subroutine asaadi31( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI31'
         pref  = '\cite{Asa73}'
         fex   = 37.21954d0
         ncont = 4
         nint  = 6
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 8
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0d0
         end do
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      f = y(1)**2 + x(1)**2 + y(1)*x(1) - 14.0d0*y(1) - 16.0d0*x(1)
     /       + (y(2) - 10.0d0)**2 + 4.0d0*(x(2) - 5.0d0)**2 
     /       + (y(3) - 3.0d0)**2 + 2.0d0*(x(3) - 1.0d0)**2 
     /       + 5.0d0*y(4)**2 + 7.0d0*(y(5) - 11.0d0)**2
     /       + 2.0d0*(y(6) - 10.0d0)**2 + (x(4) - 7.0d0)**2 + 45.0d0

      g(1) = -3.0d0*(y(1) - 2.0d0)**2 - 4.0d0*(x(1) - 3.0d0)**2 
     /       - 2.0d0*y(2)**2 + 7.0d0*x(2) + 120.0d0
 
      g(2) = -5*y(1)**2 - 8*x(1) - (y(2)-6)**2 + 2*x(2) + 40
 
      g(3) = -0.5d0*(y(1) - 8.0d0)**2 - 2.0d0*(x(1) - 4.0d0)**2 
     /       - 3.0d0*y(3)**2 + x(3) + 30.0d0
 
      g(4) = -y(1)**2 - 2.0d0*(x(1) - 2.0d0)**2 + 2.0d0*y(1)*x(1)
     /       - 14.0d0*y(3) + 6.0d0*x(3)
 
      g(5) = 3.0d0*y(1) - 6.0d0*x(1) - 12.0d0*(y(6) - 8.0d0)**2 
     /       + 7.0d0*x(4)
 
      g(6) = -4.0d0*y(1) - 5.0d0*x(1) + 3.0d0*y(4) - 9.0d0*y(5)
     /       + 105.0d0
 
      g(7) = -10.0d0*y(1) + 8.0d0*x(1) + 17.0d0*y(4) - 2.0d0*y(5)
 
      g(8) = 8.0d0*y(1) - 2.0d0*x(1) - 5.0d0*y(6) + 2.0d0*x(4) + 12.0d0

  999 continue
      return
      end

      subroutine asaadi32( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ASAADI32'
         pref  = '\cite{Asa73}'
         fex   = 43.0d0
         ncont = 0
         nint  = 10
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 8
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0d0
         end do
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      f = y(1)**2 + y(2)**2 + y(1)*y(2) - 14.0d0*y(1) - 16.0d0*y(2)
     /       + (y(3) - 10.0d0)**2 + 4.0d0*(y(4)-5.0d0)**2 
     /       + (y(5) - 3.0d0)**2 + 2.0d0*(y(6) - 1.0d0)**2 
     /       + 5.0d0*y(7)**2 + 7.0d0*(y(8) - 11.0d0)**2
     /       + 2.0d0*(y(9) - 10.0d0)**2 + (y(10) - 7.0d0)**2 + 45.0d0

      g(1) = -3.0d0*(y(1) - 2.0d0)**2 - 4.0d0*(y(2) - 3.0d0)**2 
     /       - 2.0d0*y(3)**2 + 7.0d0*y(4) + 120.0d0
 
      g(2) = -5.0d0*y(1)**2 - 8.0d0*y(2) - (y(3) - 6.0d0)**2 
     /       + 2.0d0*y(4) + 40.0d0
 
      g(3) = -0.5d0*(y(1) - 8.0d0)**2 - 2.0d0*(y(2) - 4.0d0)**2 
     /       - 3.0d0*y(5)**2 + y(6) + 30.0d0
 
      g(4) = -y(1)**2 - 2.0d0*(y(2) - 2.0d0)**2 + 2.0d0*y(1)*y(2) 
     /       - 14.0d0*y(5) + 6.0d0*y(6)
 
      g(5) = 3.0d0*y(1) - 6.0d0*y(2) - 12.0d0*(y(9) - 8.0d0)**2 
     /       + 7.0d0*y(10)
 
      g(6) = -4.0d0*y(1) - 5.0d0*y(2) + 3.0d0*y(7) - 9.0d0*y(8) 
     /       + 105.0d0
 
      g(7) = -10.0d0*y(1) + 8.0d0*y(2) + 17.0d0*y(7) - 2.0d0*y(8)
 
      g(8) = 8.0d0*y(1) - 2.0d0*y(2) - 5.0d0*y(9) + 2.0d0*y(10) + 12.0d0

  999 continue
      return
      end

      subroutine batch( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

C  GAMS:
C
C  MINLP written by GAMS Convert at 04/17/01 16:35:06
C  
C  Equation counts
C     Total       E       G       L       N       X
C        74      13      60       1       0       0
C  
C  Variable counts
C                 x       b       i     s1s     s2s      sc      si
C     Total    cont  binary integer    sos1    sos2   scont    sint
C        47      23      24       0       0       0       0       0
C  FX     0       0       0       0       0       0       0       0
C  
C  Nonzero counts
C     Total   const      NL     DLL
C       191     169      22       0

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), e2, e3, e4, e5, e6, e7, e8, e9, e10, 
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, 
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, 
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, 
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, 
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, 
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, 
     /        e71, e72, e73, e74,
     /        x1,   x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10, 
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, 
     /        x21, x22, b23, b24, b25, b26, b27, b28, b29, b30, 
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40, 
     /        b41, b42, b43, b44, b45, b46
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'BATCH'
         pref  = '\cite{MINLPLib}'
         fex   = 0.285506d6
         ncont = 23
         nint  = 0
         nbin  = 24
         n     = ncont + nbin + nint
         m     = 73
         me    = 12
         do i = 1,ncont
            xl(i) = 0.0d0
            xu(i) = 1.0d6
            x(i)  = 0.0d0
         enddo   
         xu(1) = 1.38629436111989 
         xu(2) = 1.38629436111989 
         xu(3) = 1.38629436111989 
         xu(4) = 1.38629436111989 
         xu(5) = 1.38629436111989 
         xu(6) = 1.38629436111989 
         xl(7) = 5.7037824746562
         xu(7) = 8.00636756765025 
         xl(8) = 5.7037824746562
         xu(8) = 8.00636756765025 
         xl(9) = 5.7037824746562
         xu(9) = 8.00636756765025 
         xl(10) = 5.7037824746562
         xu(10) = 8.00636756765025 
         xl(11) = 5.7037824746562
         xu(11) = 8.00636756765025 
         xl(12) = 5.7037824746562 
         xu(12) = 8.00636756765025 
         xl(13) = 4.45966 
         xu(13) = 397.747 
         xl(14) = 3.7495
         xu(14) = 882.353 
         xl(15) = 4.49144 
         xu(15) = 833.333 
         xl(16) = 3.14988 
         xu(16) = 638.298 
         xl(17) = 3.04452 
         xu(17) = 666.667 
         xl(18) = 0.729961 
         xu(18) = 2.11626 
         xl(19) = 0.530628 
         xu(19) = 1.91626 
         xl(20) = 1.09024 
         xu(20) = 2.47654 
         xl(21) = -0.133531 
         xu(21) = 1.25276 
         xl(22) = 0.0487901 
         xu(22) = 1.43508 
         do i = 1,n
            x(i) = 1.0d0
            if (x(i).gt.xu(i)) x(i) = xu(i)
            if (x(i).lt.xl(i)) x(i) = xl(i)
         enddo 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      b23 = y(1)
      b24 = y(2)
      b25 = y(3)
      b26 = y(4)
      b27 = y(5)
      b28 = y(6)
      b29 = y(7)
      b30 = y(8)
      b31 = y(9)
      b32 = y(10)
      b33 = y(11)
      b34 = y(12)
      b35 = y(13)
      b36 = y(14)
      b37 = y(15)
      b38 = y(16)
      b39 = y(17)
      b40 = y(18)
      b41 = y(19)
      b42 = y(20)
      b43 = y(21)
      b44 = y(22)
      b45 = y(23)
      b46 = y(24)

      f = 250.0d0*dexp(x1 + 0.6d0*x7) + 250.0d0*dexp(x2 + 0.6d0*x8) 
     /      + 250.0d0*dexp(x3 + 0.6d0*x9) + 250.0d0*dexp(x4 + 0.6d0*x10) 
     /      + 250.0d0*dexp(x5 + 0.6d0*x11) 
     /      + 250.0d0*dexp(x6 + 0.6d0*x12) 

      e2 = x7 - x13 - 2.06686275947298d0

      e3 = x8 - x13 - 0.693147180559945d0

      e4 = x9 - x13 - 1.64865862558738d0

      e5 = x10 - x13 - 1.58923520511658d0

      e6 = x11 - x13 - 1.80828877117927d0

      e7 = x12 - x13 - 1.43508452528932d0

      e8 = x7 - x14 + 0.356674943938732d0

      e9 = x8 - x14 + 0.22314355131421d0

      e10 = x9 - x14 + 0.105360515657826d0

      e11 = x10 - x14 - 1.22377543162212d0

      e12 = x11 - x14 - 0.741937344729377d0

      e13 = x12 - x14 - 0.916290731874155d0

      e14 = x7 - x15 -0.356674943938732d0

      e15 = x8 - x15 - 0.955511445027436d0

      e16 = x9 - x15 - 0.470003629245736d0

      e17 = x10 - x15 - 1.28093384546206d0

      e18 = x11 - x15 - 1.16315080980568d0

      e19 = x12 - x15 - 1.06471073699243d0

      e20 = x7 - x16 - 1.54756250871601d0

      e21 = x8 - x16 - 0.832909122935104d0

      e22 = x9 - x16 - 0.470003629245736d0

      e23 = x10 - x16 - 0.993251773010283d0

      e24 = x11 - x16 - 0.182321556793955d0

      e25 = x12 - x16 - 0.916290731874155d0

      e26 = x7 - x17 - 0.182321556793955d0

      e27 = x8 - x17 - 1.28093384546206d0

      e28 = x9 - x17 - 0.8754687373539d0

      e29 = x10 - x17 - 1.50407739677627d0

      e30 = x11 - x17 - 0.470003629245736d0

      e31 = x12 - x17 - 0.741937344729377d0

      e32 = x1 + x18 - 1.85629799036563d0

      e33 = x2 + x18 - 1.54756250871601d0

      e34 = x3 + x18 - 2.11625551480255d0

      e35 = x4 + x18 - 1.3609765531356d0

      e36 = x5 + x18 - 0.741937344729377d0

      e37 = x6 + x18 - 0.182321556793955d0

      e38 = x1 + x19 - 1.91692261218206d0

      e39 = x2 + x19 - 1.85629799036563d0

      e40 = x3 + x19 - 1.87180217690159d0

      e41 = x4 + x19 - 1.48160454092422d0

      e42 = x5 + x19 - 0.832909122935104d0

      e43 = x6 + x19 - 1.16315080980568d0

      e44 = x1 + x20 

      e45 = x2 + x20 - 1.84054963339749d0

      e46 = x3 + x20 - 1.68639895357023d0

      e47 = x4 + x20 - 2.47653840011748d0

      e48 = x5 + x20 - 1.7404661748405d0

      e49 = x6 + x20 - 1.82454929205105d0

      e50 = x1 + x21 - 1.16315080980568d0

      e51 = x2 + x21 - 1.09861228866811d0

      e52 = x3 + x21 - 1.25276296849537d0

      e53 = x4 + x21 - 1.19392246847243d0

      e54 = x5 + x21 - 1.02961941718116d0

      e55 = x6 + x21 - 1.22377543162212d0

      e56 = x1 + x22 - 0.741937344729377d0

      e57 = x2 + x22 - 0.916290731874155d0

      e58 = x3 + x22 - 1.43508452528932d0

      e59 = x4 + x22 - 1.28093384546206d0

      e60 = x5 + x22 - 1.30833281965018d0

      e61 = x6 + x22 - 0.78845736036427d0

      e62 = 250000.0d0*dexp(x18 - x13) + 150000.0d0*dexp(x19 - x14) 
     /      + 180000.0d0*dexp(x20 - x15) + 160000.0d0*dexp(x21 - x16) 
     /      + 120000.0d0*dexp(x22 - x17) - 6000.0d0
c      e62 = e62*1.0d-4

      e63 = x1 - 0.693147180559945d0*b29 - 1.09861228866811d0*b35
     /      - 1.38629436111989d0*b41

      e64 = x2 - 0.693147180559945d0*b30 - 1.09861228866811d0*b36
     /      - 1.38629436111989d0*b42

      e65 = x3 - 0.693147180559945d0*b31 - 1.09861228866811d0*b37
     /      - 1.38629436111989d0*b43

      e66 = x4 - 0.693147180559945d0*b32 - 1.09861228866811d0*b38
     /      - 1.38629436111989d0*b44

      e67 = x5 - 0.693147180559945d0*b33 - 1.09861228866811d0*b39
     /       - 1.38629436111989d0*b45

      e68 = x6 - 0.693147180559945d0*b34 - 1.09861228866811d0*b40
     /       - 1.38629436111989d0*b46

      e69 = b23 + b29 + b35 + b41 - 1.0d0

      e70 = b24 + b30 + b36 + b42 - 1.0d0

      e71 = b25 + b31 + b37 + b43 - 1.0d0

      e72 = b26 + b32 + b38 + b44 - 1.0d0

      e73 = b27 + b33 + b39 + b45 - 1.0d0

      e74 = b28 + b34 + b40 + b46 - 1.0d0
     
      g(1) = e63
      g(2) = e64
      g(3) = e65
      g(4) = e66
      g(5) = e67
      g(6) = e68
      g(7) = e69
      g(8) = e70
      g(9) = e71
      g(10) = e72
      g(11) = e73
      g(12) = e74
      g(13) = -e62
      g(14) = e2
      g(15) = e3
      g(16) = e4
      g(17) = e5
      g(18) = e6
      g(19) = e7
      g(20) = e8
      g(21) = e9
      g(22) = e10
      g(23) = e11
      g(24) = e12
      g(25) = e13
      g(26) = e14
      g(27) = e15
      g(28) = e16
      g(29) = e17
      g(30) = e18
      g(31) = e19
      g(32) = e20
      g(33) = e21
      g(34) = e22
      g(35) = e23
      g(36) = e24
      g(37) = e25
      g(38) = e26
      g(39) = e27
      g(40) = e28
      g(41) = e29
      g(42) = e30
      g(43) = e31
      g(44) = e32
      g(45) = e33
      g(46) = e34
      g(47) = e35
      g(48) = e36
      g(49) = e37
      g(50) = e38
      g(51) = e39
      g(52) = e40
      g(53) = e41
      g(54) = e42
      g(55) = e43
      g(56) = e44
      g(57) = e45
      g(58) = e46
      g(59) = e47
      g(60) = e48
      g(61) = e49
      g(62) = e50
      g(63) = e51
      g(64) = e52
      g(65) = e53
      g(66) = e54
      g(67) = e55
      g(68) = e56
      g(69) = e57
      g(70) = e58
      g(71) = e59
      g(72) = e60
      g(73) = e61

  999 continue
      return
      end

      subroutine batchdes( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

C  GAMS:
C
C  MINLP written by GAMS Convert at 04/17/01 16:35:07
C  
C  Equation counts
C     Total       E       G       L       N       X
C        20       7      12       1       0       0
C  
C  Variable counts
C                 x       b       i     s1s     s2s      sc      si
C     Total    cont  binary integer    sos1    sos2   scont    sint
C        20      11       9       0       0       0       0       0
C  FX     0       0       0       0       0       0       0       0
C  
C  Nonzero counts
C     Total   const      NL     DLL
C        53      43      10       0
C
C  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, 
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, 
     /        b1,   b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, x10, 
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19 

      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'BATCHDES'
         pref  = '\cite{MINLPLib}'
         fex   =  0.1674277d6
         ncont = 10
         nint  = 0
         nbin  = 9
         m     = 19
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         xl(1) = 5.52146091786225d0
         x(1)  = 6.70502272492805d0 
         xu(1) = 7.82404601085629d0
         xl(2) = 5.52146091786225d0 
         x(2)  = 7.11048783303622d0 
         xu(2) = 7.82404601085629d0 
         xl(3) = 5.52146091786225d0 
         x(3)  = 7.30700912709102d0 
         xu(3) = 7.82404601085629d0 
         xl(4) = 5.40367788220586d0 
         x(4)  = 5.92071476597113d0 
         xu(4) = 6.4377516497364d0 
         xl(5) = 4.60517018598809d0 
         x(5)  = 5.31872836380816d0
         xu(5) = 6.03228654162824d0 
         xl(6) = 1.89711998488588d0 
         x(6)  = 2.0d0
         xu(6) = 2.99573227355399d0
         xl(7) = 1.38629436111989d0 
         x(7)  = 2.0d0
         xu(7) = 2.484906649788d0 
         xu(8) = 1.09861228866811d0 
         xu(9) = 1.09861228866811d0 
         xu(10) = 1.09861228866811d0 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
        goto 999
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
 
      x10 = x(1)
      x11 = x(2)
      x12 = x(3)
      x13 = x(4)
      x14 = x(5)
      x15 = x(6)
      x16 = x(7)
      x17 = x(8)
      x18 = x(9)
      x19 = x(10)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)

      f = 250.0d0*dexp(0.6d0*x10 + x17) + 500.0d0*dexp(0.6d0*x11 + x18) 
     /     + 340.0d0*dexp(0.6d0*x12 + x19)

      e1 = x10 - x13 - 0.693147180559945d0

      e2 = x11 - x13 - 1.09861228866811d0

      e3 = x12 - x13 - 1.38629436111989d0

      e4 = x10 - x14 - 1.38629436111989d0

      e5 = x11 - x14 - 1.79175946922805d0

      e6 = x12 - x14 - 1.09861228866811d0

      e7 = x15 + x17 - 2.07944154167984d0

      e8 = x15 + x18 - 2.99573227355399d0

      e9 = x15 + x19 - 1.38629436111989d0    

      e10 = x16 + x17 - 2.30258509299405d0

      e11 = x16 + x18 - 2.484906649788d0

      e12 = x16 + x19 - 1.09861228866811d0

      e13 = 200000.0d0*dexp(x15 - x13) + 150000.0d0*dexp(x16 - x14) 
     /      - 6000.0d0
      e13 = e13*1.0d-7

      e14 = -0.693147180559945d0*b4 - 1.09861228866811d0*b7 + x17

      e15 = -0.693147180559945d0*b5 - 1.09861228866811d0*b8 + x18 

      e16 = -0.693147180559945d0*b6 - 1.09861228866811d0*b9 + x19 

      e17 = b1 + b4 + b7 - 1.0d0

      e18 = b2 + b5 + b8 - 1.0d0

      e19 = b3 + b6 + b9 - 1.0d0

      g(1) = e14
      g(2) = e15
      g(3) = e16
      g(4) = e17
      g(5) = e18
      g(6) = e19
      g(7) = e1
      g(8) = e2
      g(9) = e3
      g(10) = e4
      g(11) = e5
      g(12) = e6
      g(13) = e7
      g(14) = e8
      g(15) = e9
      g(16) = e10
      g(17) = e11
      g(18) = e12
      g(19) = -e13

  999 continue
      return
      end
      subroutine braak1( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), w(7)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'BRAAK1'
         pref  = '\cite{Braa01}'
         fex   = 1.0d0
         ncont = 4
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         do i = 1,n
            xl(i) = -20.0d0
            x(i)  = 0.0d0
            xu(i) = 20.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      w(1) = y(1) - 3.0d0
      w(2) = y(2) + 2.0d0
      w(3) = y(3) - 3.0d0
      w(4) = x(1) - 3.0d0
      w(5) = x(2) - 3.0d0
      w(6) = x(3) - 5.0d0
      w(7) = x(4) - 10.0d0

      f = w(2)**2*w(3)**2 + dabs(w(1)**3) + 8.0d0*w(1)**2 
     /    + 8.0d0*w(2)**2 + 8.0d0*w(3)**2 + dabs(w(1)) + dabs(w(2)) 
     /    + dabs(w(3)) + 12.0d0*dabs(w(1)*w(2)) + 12.0d0*dabs(w(1)*w(3))
     /    + 12.0d0*dabs(w(2)*w(3)) + dexp(0.01d0*(w(4) - w(1))**2) 
     /    + (1.25d0*w(5) - w(3))**4 + 100.0d0*w(6)**2 + 100.0d0*w(7)**2
         
      g(1) = -w(4) + w(1) - w(3) + w(6)
      
      g(2) = -w(5) + w(2) + w(3) + w(7)

  999 continue
      return
      end

      subroutine braak2( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), a
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'BRAAK2'
         pref  = '\cite{Braa01}'
         fex   = -2.7182811d0
         ncont = 4
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,n
            xl(i) = -10.0d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      a = 10.0d0
      f = 100.0d0*(y(1)*(2.0d0*y(1) + y(2)) + y(2)*(y(1) + 2.0d0*y(2))
     /    + y(3)**2) + a*(dabs(y(1)) + dabs(y(2)) + dabs(y(3))
     /    + 12.0d0*dabs(y(1)*y(2)) + 12.0d0*dabs(y(1)*y(3)) 
     /    - 12.0d0*dabs(y(2)*y(3))) - dexp(0.01d0*(x(1) - y(1))**2) 
     /    + (1.25d0*x(2) - y(3))**4 + 100.0d0*x(3)**2 + 100.0d0*x(4)**2

      g(1) = -x(1) + y(1) - 0.1d0*y(3) + 0.1d0*x(3)
  
      g(2) = -x(2) + y(2) + y(3) + x(4)
  
      g(3) = -(x(1) - y(1)) + 10.0d0
  
      g(4) = (x(1) - y(1)) + 10.0d0

  999 continue
      return
      end

      subroutine braak3( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), a
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'BRAAK3'
         pref  = '\cite{Braa01}'
         fex   = -0.19656d7
         ncont = 4
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,n
            xl(i) = -50.0d0
            xu(i) = 50.0d0
         enddo
         x(1) = -10.0d0
         x(2) = -20.0d0
         x(3) = 35.0d0
         x(4) = 50.0d0
         x(5) = -10.0d0
         x(6) = -20.0d0
         x(7) = -20.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      a = 100.0d0
      f = 100.0d0*(y(1)*(2.0d0*y(1) + y(2)) + y(2)*(y(1) + 2.0d0*y(2))
     /    + y(3)**2) + a*(dabs(y(1)) + dabs(y(2)) + dabs(y(3))
     /    + 12.0d0*dabs(y(1)*y(2)) + 12.0d0*dabs(y(1)*y(3)) 
     /    - 12.0d0*dabs(y(2)*y(3))) - dexp(0.01d0*(x(1) - y(1))**2) 
     /    + (1.25d0*x(2) - y(3))**4 + 100.0d0*x(3)**2 + 100.0d0*x(4)**2
      
      g(1) = -x(1) + y(1) - 0.1d0*y(3) + 0.1d0*x(3)

      g(2) = -x(2) + y(2) + y(3) + x(4)

      g(3) = -(x(1) - y(1)) + 10.0d0

      g(4) = (x(1) - y(1)) + 10.0d0

  999 continue
      return
      end

      subroutine crop100( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), gu1, gu2, gu3, xlog,
     /        gl1, gl2, gl3, r(100), tau(100), delta(100), a1(100), 
     /        a2(100), a3(100), s1, s2, s3, b1, b2, b3, xli, xui 
      character*30 pnam, pref
      common /random_data_array/ ran_num(600)
      double precision ran_num

      if (mode.eq.0) then
         pnam  = 'CROP100'
         pref  = '\cite{SRL06}'
c         fex   = 0.95237978d0
         fex   = 0.85147079d0
         ncont = 0
         nint  = 100
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i = 1,nint
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         end do 
         call random_data(ran_num)
         goto 999       
      end if     

      ran_num( 1) = 0.0022477954
      ran_num( 2) = 0.0850324482
      ran_num( 3) = 0.6013526320
      ran_num( 4) = 0.8916112781
      ran_num( 5) = 0.9679557085
      ran_num( 6) = 0.1896897703
      ran_num( 7) = 0.5149758458
      ran_num( 8) = 0.3980083764
      ran_num( 9) = 0.2629061639
      ran_num(10) = 0.7435124516
      ran_num(11) = 0.0895477682
      ran_num(12) = 0.5603899360
      ran_num(13) = 0.5822296739
      ran_num(14) = 0.8095666766
      ran_num(15) = 0.5919187665
      ran_num(16) = 0.5117125511
      ran_num(17) = 0.8766338825
      ran_num(18) = 0.9950845242
      ran_num(19) = 0.7262117267
      ran_num(20) = 0.9666113853
      ran_num(21) = 0.2971023321
      ran_num(22) = 0.4260508418
      ran_num(23) = 0.8994976878
      ran_num(24) = 0.6529987454
      ran_num(25) = 0.9015342593
      ran_num(26) = 0.9615331292
      ran_num(27) = 0.1647129357
      ran_num(28) = 0.8579873443
      ran_num(29) = 0.9068445563
      ran_num(30) = 0.2940261364
      ran_num(31) = 0.9362435937
      ran_num(32) = 0.4146445692
      ran_num(33) = 0.3084567189
      ran_num(34) = 0.5148928761
      ran_num(35) = 0.3954297602
      ran_num(36) = 0.7897845507
      ran_num(37) = 0.6891413927
      ran_num(38) = 0.5442727804
      ran_num(39) = 0.5924073458
      ran_num(40) = 0.0936299115
      ran_num(41) = 0.6094846129
      ran_num(42) = 0.4322595298
      ran_num(43) = 0.5995492935
      ran_num(44) = 0.8449274302
      ran_num(45) = 0.4923820198
      ran_num(46) = 0.7728464603
      ran_num(47) = 0.0716619045
      ran_num(48) = 0.1918589473
      ran_num(49) = 0.2236079723
      ran_num(50) = 0.7803667784
      ran_num(51) = 0.0839672163
      ran_num(52) = 0.1813431829
      ran_num(53) = 0.6166969538
      ran_num(54) = 0.5791414976
      ran_num(55) = 0.7393116951
      ran_num(56) = 0.3141314387
      ran_num(57) = 0.4388434589
      ran_num(58) = 0.4119845927
      ran_num(59) = 0.9088892341
      ran_num(60) = 0.9923054576      
      ran_num(61) = 0.5770579576
      ran_num(62) = 0.1639224142
      ran_num(63) = 0.6985215545
      ran_num(64) = 0.3348481655
      ran_num(65) = 0.4557824731
      ran_num(66) = 0.0762182027
      ran_num(67) = 0.1287973076
      ran_num(68) = 0.1745238751
      ran_num(69) = 0.4417774081
      ran_num(70) = 0.0372999161
      ran_num(71) = 0.5041633248
      ran_num(72) = 0.4674147964
      ran_num(73) = 0.5790158510
      ran_num(74) = 0.6741126776
      ran_num(75) = 0.0934115052
      ran_num(76) = 0.0667032525
      ran_num(77) = 0.8327026367
      ran_num(78) = 0.3897824883
      ran_num(79) = 0.1908633560
      ran_num(80) = 0.1653986573
      ran_num(81) = 0.9585463405
      ran_num(82) = 0.9908042550
      ran_num(83) = 0.1135644689
      ran_num(84) = 0.8706391454
      ran_num(85) = 0.6222509146
      ran_num(86) = 0.6726526022
      ran_num(87) = 0.6140454412
      ran_num(88) = 0.5877059102
      ran_num(89) = 0.1509033442
      ran_num(90) = 0.2550143898
      ran_num(91) = 0.7989391685
      ran_num(92) = 0.5930454731
      ran_num(93) = 0.8966516256
      ran_num(94) = 0.2717200518
      ran_num(95) = 0.1979505420
      ran_num(96) = 0.2704811692
      ran_num(97) = 0.3963683248
      ran_num(98) = 0.0959302261
      ran_num(99) = 0.6480833888
      ran_num(100) = 0.6325563192
      ran_num(101) = 0.1250885874
      ran_num(102) = 0.1512727886
      ran_num(103) = 0.0888514593
      ran_num(104) = 0.9488624930
      ran_num(105) = 0.5406360626
      ran_num(106) = 0.0426042527
      ran_num(107) = 0.5499727726
      ran_num(108) = 0.7350890636
      ran_num(109) = 0.4845448732
      ran_num(110) = 0.4654970467
      ran_num(111) = 0.0072553405
      ran_num(112) = 0.2225395441
      ran_num(113) = 0.2061811686
      ran_num(114) = 0.5714842081
      ran_num(115) = 0.1150091067
      ran_num(116) = 0.6045694351
      ran_num(117) = 0.1701373011
      ran_num(118) = 0.6980018020
      ran_num(119) = 0.2440319210
      ran_num(120) = 0.6646856666
      ran_num(121) = 0.0413534753
      ran_num(122) = 0.1736522168
      ran_num(123) = 0.3658459783
      ran_num(124) = 0.7514945269
      ran_num(125) = 0.3933795691
      ran_num(126) = 0.8249168992
      ran_num(127) = 0.5634801984
      ran_num(128) = 0.7530959249
      ran_num(129) = 0.6925963759
      ran_num(130) = 0.3190492988
      ran_num(131) = 0.8284380436
      ran_num(132) = 0.5325512290
      ran_num(133) = 0.7804095149
      ran_num(134) = 0.1475541294
      ran_num(135) = 0.5853368044
      ran_num(136) = 0.7926281095
      ran_num(137) = 0.9524334073
      ran_num(138) = 0.9125310183
      ran_num(139) = 0.7836339474
      ran_num(140) = 0.7943811417
      ran_num(141) = 0.5720620751
      ran_num(142) = 0.0094084013
      ran_num(143) = 0.1529181153
      ran_num(144) = 0.5100528598
      ran_num(145) = 0.7612913847
      ran_num(146) = 0.2955936491
      ran_num(147) = 0.6014493108
      ran_num(148) = 0.5599189401
      ran_num(149) = 0.8471236229
      ran_num(150) = 0.5041725039
      ran_num(151) = 0.9114439487
      ran_num(152) = 0.3100162446
      ran_num(153) = 0.7934781313
      ran_num(154) = 0.9825788736
      ran_num(155) = 0.0636399612
      ran_num(156) = 0.9644553065
      ran_num(157) = 0.2222131044
      ran_num(158) = 0.4485636055
      ran_num(159) = 0.6137909889
      ran_num(160) = 0.3035138547
      ran_num(161) = 0.9174464345
      ran_num(162) = 0.0562084056
      ran_num(163) = 0.2360175252
      ran_num(164) = 0.8019191027
      ran_num(165) = 0.4363486171
      ran_num(166) = 0.9838125110
      ran_num(167) = 0.6138064265
      ran_num(168) = 0.0510625765
      ran_num(169) = 0.8416075706
      ran_num(170) = 0.2398034483
      ran_num(171) = 0.5522592068
      ran_num(172) = 0.1046994925
      ran_num(173) = 0.9490902424
      ran_num(174) = 0.5347968340
      ran_num(175) = 0.1787723750
      ran_num(176) = 0.5214069486
      ran_num(177) = 0.8352081180
      ran_num(178) = 0.3299794793
      ran_num(179) = 0.4401051998
      ran_num(180) = 0.3176380694
      ran_num(181) = 0.7072771788
      ran_num(182) = 0.9778584242
      ran_num(183) = 0.2031392604
      ran_num(184) = 0.7350865602
      ran_num(185) = 0.3620176315
      ran_num(186) = 0.9536167383
      ran_num(187) = 0.0342037566
      ran_num(188) = 0.0494682044
      ran_num(189) = 0.8796497583
      ran_num(190) = 0.5725380182
      ran_num(191) = 0.9817915559
      ran_num(192) = 0.0608454049
      ran_num(193) = 0.0686294362
      ran_num(194) = 0.8116285205
      ran_num(195) = 0.1191394255
      ran_num(196) = 0.9791864157
      ran_num(197) = 0.3072906137
      ran_num(198) = 0.2258253694
      ran_num(199) = 0.8165442348
      ran_num(200) = 0.4063695073
      ran_num(201) = 0.8619796634
      ran_num(202) = 0.6190462708
      ran_num(203) = 0.9833182096
      ran_num(204) = 0.7545562983
      ran_num(205) = 0.1878543198
      ran_num(206) = 0.9159882069
      ran_num(207) = 0.6665292978
      ran_num(208) = 0.0364922434
      ran_num(209) = 0.5170149803
      ran_num(210) = 0.8305760026
      ran_num(211) = 0.7351391912
      ran_num(212) = 0.9036428332
      ran_num(213) = 0.7427062988
      ran_num(214) = 0.1759922057
      ran_num(215) = 0.3197896481
      ran_num(216) = 0.5667828321
      ran_num(217) = 0.1744179428
      ran_num(218) = 0.3281818330
      ran_num(219) = 0.6653144360
      ran_num(220) = 0.3945692480
      ran_num(221) = 0.2515478134
      ran_num(222) = 0.4645519853
      ran_num(223) = 0.3891608417
      ran_num(224) = 0.1832683533
      ran_num(225) = 0.5464410782
      ran_num(226) = 0.2574996948
      ran_num(227) = 0.7681342959
      ran_num(228) = 0.6105491519
      ran_num(229) = 0.8190465569
      ran_num(230) = 0.1965037882
      ran_num(231) = 0.4345909953
      ran_num(232) = 0.1412926018
      ran_num(233) = 0.3351633251
      ran_num(234) = 0.6693440676
      ran_num(235) = 0.9085124135
      ran_num(236) = 0.8018334508
      ran_num(237) = 0.3022965193
      ran_num(238) = 0.1558958441
      ran_num(239) = 0.2480468899
      ran_num(240) = 0.4714280069
      ran_num(241) = 0.3007241488
      ran_num(242) = 0.2557282448
      ran_num(243) = 0.2585816383
      ran_num(244) = 0.9939777255
      ran_num(245) = 0.2987652719
      ran_num(246) = 0.6987614036
      ran_num(247) = 0.9111650586
      ran_num(248) = 0.8473509550
      ran_num(249) = 0.4787775278
      ran_num(250) = 0.0693812966
      ran_num(251) = 0.1046838015
      ran_num(252) = 0.1917860955
      ran_num(253) = 0.7065527439
      ran_num(254) = 0.0081466278
      ran_num(255) = 0.2458710074
      ran_num(256) = 0.4396530390
      ran_num(257) = 0.4918769002
      ran_num(258) = 0.3896131516
      ran_num(259) = 0.0170316678
      ran_num(260) = 0.1356570125
      ran_num(261) = 0.2998539209
      ran_num(262) = 0.2492311746
      ran_num(263) = 0.6380116940
      ran_num(264) = 0.4613918066
      ran_num(265) = 0.8435022831
      ran_num(266) = 0.6983891129
      ran_num(267) = 0.9418534040
      ran_num(268) = 0.2068566829
      ran_num(269) = 0.1790346652
      ran_num(270) = 0.1822617650
      ran_num(271) = 0.9574152827
      ran_num(272) = 0.3943927586
      ran_num(273) = 0.7331967950
      ran_num(274) = 0.1424623281
      ran_num(275) = 0.7990867496
      ran_num(276) = 0.7156515121
      ran_num(277) = 0.2138441950
      ran_num(278) = 0.4731195867
      ran_num(279) = 0.9549286962
      ran_num(280) = 0.3617199659
      ran_num(281) = 0.5840566754
      ran_num(282) = 0.0003100010
      ran_num(283) = 0.9640564919
      ran_num(284) = 0.9721087217
      ran_num(285) = 0.6591171026
      ran_num(286) = 0.2425971180
      ran_num(287) = 0.4058265686
      ran_num(288) = 0.6542797089
      ran_num(289) = 0.7356164455
      ran_num(290) = 0.9402005076
      ran_num(291) = 0.4182758927
      ran_num(292) = 0.5962569714
      ran_num(293) = 0.9203228354
      ran_num(294) = 0.9038577080
      ran_num(295) = 0.1164535955
      ran_num(296) = 0.3315315247
      ran_num(297) = 0.3579644859
      ran_num(298) = 0.3040432930
      ran_num(299) = 0.4745225012
      ran_num(300) = 0.6753978133
      ran_num(301) = 0.1279743463
      ran_num(302) = 0.4497845471
      ran_num(303) = 0.5501524806
      ran_num(304) = 0.4090323746
      ran_num(305) = 0.4012475014
      ran_num(306) = 0.6183051467
      ran_num(307) = 0.2081321031
      ran_num(308) = 0.7445054650
      ran_num(309) = 0.0231618844
      ran_num(310) = 0.0473447405
      ran_num(311) = 0.3779013455
      ran_num(312) = 0.6760365367
      ran_num(313) = 0.9595205784
      ran_num(314) = 0.0181979313
      ran_num(315) = 0.4322996140
      ran_num(316) = 0.5346748233
      ran_num(317) = 0.2884742022
      ran_num(318) = 0.9381738305
      ran_num(319) = 0.5876898766
      ran_num(320) = 0.3780444562
      ran_num(321) = 0.5843154788
      ran_num(322) = 0.4923105538
      ran_num(323) = 0.3225057721
      ran_num(324) = 0.6757508516
      ran_num(325) = 0.1682953387
      ran_num(326) = 0.7841882110
      ran_num(327) = 0.5480701327
      ran_num(328) = 0.8936816454
      ran_num(329) = 0.9073092937
      ran_num(330) = 0.7271186709
      ran_num(331) = 0.7456510663
      ran_num(332) = 0.3215143979
      ran_num(333) = 0.8210342526
      ran_num(334) = 0.1452370137
      ran_num(335) = 0.7361611724
      ran_num(336) = 0.2371827960
      ran_num(337) = 0.0505937710
      ran_num(338) = 0.2119230330
      ran_num(339) = 0.7365958095
      ran_num(340) = 0.2155033052
      ran_num(341) = 0.5598926544
      ran_num(342) = 0.5781766772
      ran_num(343) = 0.1673210114
      ran_num(344) = 0.7528159618
      ran_num(345) = 0.1785915047
      ran_num(346) = 0.7902348638
      ran_num(347) = 0.4258899391
      ran_num(348) = 0.1334382296
      ran_num(349) = 0.1969169974
      ran_num(350) = 0.3804549277
      ran_num(351) = 0.9401374459
      ran_num(352) = 0.3735495508
      ran_num(353) = 0.6108906865
      ran_num(354) = 0.3045221865
      ran_num(355) = 0.5899327993
      ran_num(356) = 0.6447989941
      ran_num(357) = 0.0931785703
      ran_num(358) = 0.8226777315
      ran_num(359) = 0.4758298397
      ran_num(360) = 0.7827875614
      ran_num(361) = 0.9397883415
      ran_num(362) = 0.5243809223
      ran_num(363) = 0.3924345672
      ran_num(364) = 0.2091601044
      ran_num(365) = 0.3675837219
      ran_num(366) = 0.6340267658
      ran_num(367) = 0.1061846539
      ran_num(368) = 0.6395674944
      ran_num(369) = 0.5621540546
      ran_num(370) = 0.7389461994
      ran_num(371) = 0.6717838645
      ran_num(372) = 0.6803544164
      ran_num(373) = 0.3872387111
      ran_num(374) = 0.3994060457
      ran_num(375) = 0.7286778092
      ran_num(376) = 0.0070855981
      ran_num(377) = 0.0289047845
      ran_num(378) = 0.2628518343
      ran_num(379) = 0.1211465225
      ran_num(380) = 0.8639008999
      ran_num(381) = 0.3600431681
      ran_num(382) = 0.6442009807
      ran_num(383) = 0.2255520821
      ran_num(384) = 0.6243784428
      ran_num(385) = 0.3721618652
      ran_num(386) = 0.6260344982
      ran_num(387) = 0.3101984560
      ran_num(388) = 0.5895665288
      ran_num(389) = 0.9656101465
      ran_num(390) = 0.9665053487
      ran_num(391) = 0.1810116917
      ran_num(392) = 0.6154634953
      ran_num(393) = 0.0397644192
      ran_num(394) = 0.4682799876
      ran_num(395) = 0.3439874947
      ran_num(396) = 0.6210166216
      ran_num(397) = 0.0922532976
      ran_num(398) = 0.1587940753
      ran_num(399) = 0.1490572542
      ran_num(400) = 0.1424958259
      ran_num(401) = 0.4161269665
      ran_num(402) = 0.8650104403
      ran_num(403) = 0.9189181328
      ran_num(404) = 0.0967810899
      ran_num(405) = 0.7201726437
      ran_num(406) = 0.4542153776
      ran_num(407) = 0.4298714697
      ran_num(408) = 0.3257477582
      ran_num(409) = 0.1706928462
      ran_num(410) = 0.5143592358
      ran_num(411) = 0.6361196637
      ran_num(412) = 0.1336501837
      ran_num(413) = 0.4277945161
      ran_num(414) = 0.0697474927
      ran_num(415) = 0.7811528444
      ran_num(416) = 0.0295329392
      ran_num(417) = 0.5845535398
      ran_num(418) = 0.9835484028
      ran_num(419) = 0.8662542701
      ran_num(420) = 0.9586989880
      ran_num(421) = 0.3601956069
      ran_num(422) = 0.0020161648
      ran_num(423) = 0.3222924471
      ran_num(424) = 0.3794400394
      ran_num(425) = 0.9495432973
      ran_num(426) = 0.4057386816
      ran_num(427) = 0.4116591811
      ran_num(428) = 0.2009703815
      ran_num(429) = 0.0413572565
      ran_num(430) = 0.3561730385
      ran_num(431) = 0.8293330073
      ran_num(432) = 0.7346497178
      ran_num(433) = 0.2769494057
      ran_num(434) = 0.6252169013
      ran_num(435) = 0.8444274068
      ran_num(436) = 0.3567881584
      ran_num(437) = 0.5207084417
      ran_num(438) = 0.1171127483
      ran_num(439) = 0.1495444626
      ran_num(440) = 0.6604409814
      ran_num(441) = 0.1466274261
      ran_num(442) = 0.8526706696
      ran_num(443) = 0.2665611506
      ran_num(444) = 0.1731693596
      ran_num(445) = 0.0583617464
      ran_num(446) = 0.1798154265
      ran_num(447) = 0.8701629043
      ran_num(448) = 0.6336611509
      ran_num(449) = 0.4563294649
      ran_num(450) = 0.4802404344
      ran_num(451) = 0.6856380105
      ran_num(452) = 0.4312964380
      ran_num(453) = 0.1109517962
      ran_num(454) = 0.7539982796
      ran_num(455) = 0.2502958179
      ran_num(456) = 0.0289346464
      ran_num(457) = 0.7043169141
      ran_num(458) = 0.0820451975
      ran_num(459) = 0.4037746787
      ran_num(460) = 0.6080194712
      ran_num(461) = 0.7074568868
      ran_num(462) = 0.6512397528
      ran_num(463) = 0.9940306544
      ran_num(464) = 0.8540795445
      ran_num(465) = 0.2726124823
      ran_num(466) = 0.2766901255
      ran_num(467) = 0.1089401692
      ran_num(468) = 0.6509330869
      ran_num(469) = 0.1923322827
      ran_num(470) = 0.0713509843
      ran_num(471) = 0.1833635569
      ran_num(472) = 0.1423473060
      ran_num(473) = 0.2471489310
      ran_num(474) = 0.1258753091
      ran_num(475) = 0.1270938218
      ran_num(476) = 0.9457383752
      ran_num(477) = 0.7363206744
      ran_num(478) = 0.9365277290
      ran_num(479) = 0.1303664446
      ran_num(480) = 0.9184697866
      ran_num(481) = 0.4557211101
      ran_num(482) = 0.1141432300
      ran_num(483) = 0.8077465296
      ran_num(484) = 0.7322529554
      ran_num(485) = 0.5825182796
      ran_num(486) = 0.7387614846
      ran_num(487) = 0.7551013827
      ran_num(488) = 0.4982334673
      ran_num(489) = 0.2276457548
      ran_num(490) = 0.6883481145
      ran_num(491) = 0.2530863285
      ran_num(492) = 0.7302589417
      ran_num(493) = 0.3291190863
      ran_num(494) = 0.9073755741
      ran_num(495) = 0.9259986877
      ran_num(496) = 0.8835535645
      ran_num(497) = 0.0134823211
      ran_num(498) = 0.8050974011
      ran_num(499) = 0.8570957184
      ran_num(500) = 0.8669693470
      ran_num(501) = 0.4766717255
      ran_num(502) = 0.4203334153
      ran_num(503) = 0.9141405821
      ran_num(504) = 0.4805978239
      ran_num(505) = 0.9377011061
      ran_num(506) = 0.7713710070
      ran_num(507) = 0.8504115939
      ran_num(508) = 0.2168776095
      ran_num(509) = 0.8990701437
      ran_num(510) = 0.0153987715
      ran_num(511) = 0.3140995204
      ran_num(512) = 0.8980708718
      ran_num(513) = 0.7777256370
      ran_num(514) = 0.5932051539
      ran_num(515) = 0.6057070494
      ran_num(516) = 0.0855107382
      ran_num(517) = 0.6888228059
      ran_num(518) = 0.1656781882
      ran_num(519) = 0.4518715143
      ran_num(520) = 0.2897655368
      ran_num(521) = 0.2717156708
      ran_num(522) = 0.9873772264
      ran_num(523) = 0.6864975691
      ran_num(524) = 0.9251617193
      ran_num(525) = 0.4814865887
      ran_num(526) = 0.8390673399
      ran_num(527) = 0.6187738180
      ran_num(528) = 0.8315677643
      ran_num(529) = 0.6086922288
      ran_num(530) = 0.1838935167
      ran_num(531) = 0.7242165804
      ran_num(532) = 0.6571297646
      ran_num(533) = 0.3097558022
      ran_num(534) = 0.2221978903
      ran_num(535) = 0.7146814466
      ran_num(536) = 0.3893588781
      ran_num(537) = 0.7423028350
      ran_num(538) = 0.7008612156
      ran_num(539) = 0.2704947889
      ran_num(540) = 0.0546571687
      ran_num(541) = 0.3562358320
      ran_num(542) = 0.8604826927
      ran_num(543) = 0.3604167402
      ran_num(544) = 0.6757764816
      ran_num(545) = 0.4059304893
      ran_num(546) = 0.6708380580
      ran_num(547) = 0.0225189161
      ran_num(548) = 0.0105974246
      ran_num(549) = 0.5482597351
      ran_num(550) = 0.0459554307
      ran_num(551) = 0.3145297170
      ran_num(552) = 0.6633679271
      ran_num(553) = 0.4345039725
      ran_num(554) = 0.9408182502
      ran_num(555) = 0.2363594472
      ran_num(556) = 0.3066358268
      ran_num(557) = 0.6175540686
      ran_num(558) = 0.9518507123
      ran_num(559) = 0.7849456072
      ran_num(560) = 0.1086578369
      ran_num(561) = 0.0225380324
      ran_num(562) = 0.9333841205
      ran_num(563) = 0.3853944242
      ran_num(564) = 0.3744615316
      ran_num(565) = 0.6322875023
      ran_num(566) = 0.1488009095
      ran_num(567) = 0.7687067389
      ran_num(568) = 0.2433277667
      ran_num(569) = 0.6747196913
      ran_num(570) = 0.3934460580
      ran_num(571) = 0.0342266858
      ran_num(572) = 0.1564391255
      ran_num(573) = 0.4726727009
      ran_num(574) = 0.3842920661
      ran_num(575) = 0.1623536944
      ran_num(576) = 0.9753003120
      ran_num(577) = 0.7208225727
      ran_num(578) = 0.8260412812
      ran_num(579) = 0.8382324576
      ran_num(580) = 0.3191163540
      ran_num(581) = 0.0649910867
      ran_num(582) = 0.1848385036
      ran_num(583) = 0.3393439651
      ran_num(584) = 0.4721176326
      ran_num(585) = 0.5909519792
      ran_num(586) = 0.8434938192
      ran_num(587) = 0.2914036214
      ran_num(588) = 0.3443292379
      ran_num(589) = 0.1165848076
      ran_num(590) = 0.6652519107
      ran_num(591) = 0.3763219118
      ran_num(592) = 0.4344066381
      ran_num(593) = 0.2421203852
      ran_num(594) = 0.3933202922
      ran_num(595) = 0.9634307027
      ran_num(596) = 0.7626393437
      ran_num(597) = 0.3637337983
      ran_num(598) = 0.7938021421
      ran_num(599) = 0.6222771406
      ran_num(600) = 0.9411050081

      gu1 = 0.0d0
      gu2 = 0.0d0
      gu3 = 0.0d0
      gl1 = 0.0d0
      gl2 = 0.0d0
      gl3 = 0.0d0
      xli = 1.0d0
      xui = 5.0d0
      do i=1,nint
         r(i)     = 0.8d0 + ran_num(i)*0.18d0
         a1(i)    = 1.0d0 + ran_num(nint+i)*49.0d0
         a2(i)    = 1.0d0 + ran_num(2*nint+i)*49.0d0
         a3(i)    = 1.0d0 + ran_num(3*nint+i)*49.0d0
         delta(i) = ran_num(4*nint+i)*0.01d0
         tau(i)   = ran_num(5*nint+i)*0.01d0
      enddo
      do i=1,nint
         gu1 = gu1 + a1(i)*xui**2
         gu2 = gu2 + a2(i)*(xui + dexp(delta(i)*xui))
         gu3 = gu3 + a3(i)*xui*dexp(tau(i)*xui)
         gl1 = gl1 + a1(i)*xli**2
         gl2 = gl2 + a2(i)*(xli + dexp(delta(i)*xli))
         gl3 = gl3 + a3(i)*xli*dexp(tau(i)*xli)
      enddo
      b1 = gl1 + 0.3d0*(gu1 - gl1)
      b2 = gl2 + 0.3d0*(gu2 - gl2)
      b3 = gl3 + 0.3d0*(gu3 - gl3)

      do i=1,nint
         y(i) = x(i)
      enddo
      
      f  = 0.0d0
      s1 = 0.0d0
      s2 = 0.0d0
      s3 = 0.0d0
      do i=1,nint
         if (y(i).gt.0.5d0) then
            f = f + xlog(1.0d0 - (1.0d0 - r(i))**y(i))    
         endif
         s1 = s1 + a1(i)*y(i)**2
         s2 = s2 + a2(i)*(y(i) + dexp(delta(i)*y(i)))
         s3 = s3 + a3(i)*y(i)*dexp(tau(i)*y(i))
      enddo
      f = -f
      
      g(1) = b1 - s1
      g(2) = b2 - s2
      g(3) = b3 - s3
     
  999 continue
      return
      end

      subroutine crop20( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), gu1, gu2, gu3, 
     /        gl1, gl2, gl3, r(20), tau(20), delta(20), a1(20), 
     /        a2(20), a3(20), s1, s2, s3, b1, b2, b3, xli, xui, xlog
      character*30 pnam, pref
      common /random_data_array/ ran_num(600)
      double precision ran_num

      if (mode.eq.0) then
         pnam  = 'CROP20'
         pref  = '\cite{SRL06}'
c         fex   = 0.13178478d0
c         fex   = 0.12455987d0
         fex   = 0.11161405d0
         ncont = 0
         nint  = 20
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i = 1,nint
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         end do 
         call random_data(ran_num)
         goto 999       
      end if     

      gu1 = 0.0d0
      gu2 = 0.0d0
      gu3 = 0.0d0
      gl1 = 0.0d0
      gl2 = 0.0d0
      gl3 = 0.0d0
      xli = 1.0d0
      xui = 5.0d0
      do i=1,nint
         r(i)     = 0.8d0 + ran_num(i)*0.18d0
         a1(i)    = 1.0d0 + ran_num(nint+i)*49.0d0
         a2(i)    = 1.0d0 + ran_num(2*nint+i)*49.0d0
         a3(i)    = 1.0d0 + ran_num(3*nint+i)*49.0d0
         delta(i) = ran_num(4*nint+i)*0.01d0
         tau(i)   = ran_num(5*nint+i)*0.01d0
      end do
      do i=1,nint
         gu1 = gu1 + a1(i)*xui**2
         gu2 = gu2 + a2(i)*(xui + dexp(delta(i)*xui))
         gu3 = gu3 + a3(i)*xui*dexp(tau(i)*xui)
         gl1 = gl1 + a1(i)*xli**2
         gl2 = gl2 + a2(i)*(xli + dexp(delta(i)*xli))
         gl3 = gl3 + a3(i)*xli*dexp(tau(i)*xli)
      end do
      b1 = gl1 + 0.3d0*(gu1 - gl1)
      b2 = gl2 + 0.3d0*(gu2 - gl2)
      b3 = gl3 + 0.3d0*(gu3 - gl3)

      do i=1,nint
         y(i) = x(i)
      end do
      
      f  = 0.0d0
      s1 = 0.0d0
      s2 = 0.0d0
      s3 = 0.0d0
      do i=1,nint
         if (y(i).gt.0.5d0) THEN
            f = f + xlog(1.0d0 - (1.0d0 - r(i))**y(i)) 
         endif
         s1 = s1 + a1(i)*y(i)**2
         s2 = s2 + a2(i)*(y(i) + dexp(delta(i)*y(i)))
         s3 = s3 + a3(i)*y(i)*dexp(tau(i)*y(i))
      end do
      f = -f
      
      g(1) = b1 - s1
      g(2) = b2 - s2
      g(3) = b3 - s3
     
  999 continue
      return
      end

      subroutine crop5( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r(5), c(5), v(5), w(5), cc, vv, ww, s1, s2, s3,
     /        xlog
      character*30 pnam, pref
      data r/0.8d0, 0.85d0, 0.9d0, 0.65d0, 0.75d0/
      data c/1.0d0, 2.0d0, 3.0d0, 4.0d0, 2.0d0/, cc/110.0d0/
      data v/7.0d0, 7.0d0, 5.0d0, 9.0d0, 4.0d0/, vv/175.0d0/
      data w/7.0d0, 8.0d0, 8.0d0, 6.0d0, 9.0d0/, ww/200.0d0/

      if (mode.eq.0) then
         pnam  = 'CROP5'
         pref  = '\cite{SRL06}'
c         fex   = 0.10040913d0
         fex   = 0.95309881d-1
         ncont = 0
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i=1,n
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = 0.0d0
      s1 = 0.0d0
      s2 = 0.0d0
      s3 = 0.0d0
      do i=1,nint
         f = f + xlog(dabs(1.0d0 - (1.0d0 - r(i))**y(i)))
         s1 = s1 + c(i)*y(i)**2
         s2 = s2 + v(i)*(y(i) + dexp(y(i)*0.25d0))
         s3 = s3 + w(i)*y(i)*dexp(y(i)*0.25d0)
      enddo
      f = -f
      
      g(1) = cc - s1
      g(2) = vv - s2
      g(3) = ww - s3

  999 continue
      return
      end

      subroutine crop50( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), gu1, gu2, gu3, 
     /        gl1, gl2, gl3, r(50), tau(50), delta(50), a1(50), 
     /        a2(50),a3(50), s1, s2, s3, b1, b2, b3, xli, xui, xlog 
      character*30 pnam, pref
      common /random_data_array/ ran_num(600)
      double precision ran_num

      if (mode.eq.0) then
         pnam  = 'CROP50'
         pref  = '\cite{SRL06}'
c         fex   = 0.37459d0
         fex   = 0.32424327d0
         ncont = 0
         nint  = 50
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i = 1,nint
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         end do 
         call random_data(ran_num)
         goto 999       
      end if     

      gu1 = 0.0d0
      gu2 = 0.0d0
      gu3 = 0.0d0
      gl1 = 0.0d0
      gl2 = 0.0d0
      gl3 = 0.0d0
      xli = 1.0d0
      xui = 5.0d0
      do i=1,nint
         r(i)     = 0.8d0 + ran_num(i)*0.18d0
         a1(i)    = 1.0d0 + ran_num(nint+i)*49.0d0
         a2(i)    = 1.0d0 + ran_num(2*nint+i)*49.0d0
         a3(i)    = 1.0d0 + ran_num(3*nint+i)*49.0d0
         delta(i) = ran_num(4*nint+i)*0.01d0
         tau(i)   = ran_num(5*nint+i)*0.01d0
      enddo
      do i=1,nint
         gu1 = gu1 + a1(i)*xui**2
         gu2 = gu2 + a2(i)*(xui + dexp(delta(i)*xui))
         gu3 = gu3 + a3(i)*xui*dexp(tau(i)*xui)
         gl1 = gl1 + a1(i)*xli**2
         gl2 = gl2 + a2(i)*(xli + dexp(delta(i)*xli))
         gl3 = gl3 + a3(i)*xli*dexp(tau(i)*xli)
      enddo
      b1 = gl1 + 0.3d0*(gu1 - gl1)
      b2 = gl2 + 0.3d0*(gu2 - gl2)
      b3 = gl3 + 0.3d0*(gu3 - gl3)

      do i=1,nint
         y(i) = x(i)
      enddo
      
      f  = 0.0d0
      s1 = 0.0d0
      s2 = 0.0d0
      s3 = 0.0d0
      do i=1,nint
         if (y(i).gt.0.5d0) THEN
            f = f + xlog(1.0d0 - (1.0d0 - r(i))**y(i)) 
         endif
         s1 = s1 + a1(i)*y(i)**2
         s2 = s2 + a2(i)*(y(i) + dexp(delta(i)*y(i)))
         s3 = s3 + a3(i)*y(i)*dexp(tau(i)*y(i))
      enddo
      f = -f
      
      g(1) = b1 - s1
      g(2) = b2 - s2
      g(3) = b3 - s3
     
  999 continue
      return
      end

      subroutine csched1( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  GAMS:
*
*  MINLP written by GAMS Convert at 04/17/01 16:35:14
*  
*  Equation counts
*     Total       E       G       L       N       X
*        23      13       3       7       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        77      14      63       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       174     166       8       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, 
     /        e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23,
     /        x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, 
     /        x11, x12, x13, b14, b15, b16, b17, b18, b19, b20, 
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30, 
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40,
     /        b41, b42, b43, b44, b45, b46, b47, b48, b49, b50,
     /        b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, b67, b68, b69, b70,
     /        b71, b72, b73, b74, b75, b76
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'CSCHED1'
         pref  = '\cite{MINLPLib}'
         fex   = -0.37603950d5
         ncont = 13
         nint  = 0
         nbin  = 63
         n     = ncont + nbin + nint
         m     = 22
         me    = 12
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         end do 
         do i = 4,6
            xl(i) = 0.01d0
            x(i)  = 1.0d0
            xu(i) = 20.0d0
         end do 
         xl(13) = 0.01d0 
         x(13) = 100.0d0 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      b14 = y(1)
      b15 = y(2)
      b16 = y(3)
      b17 = y(4)
      b18 = y(5)
      b19 = y(6)
      b20 = y(7)
      b21 = y(8)
      b22 = y(9)
      b23 = y(10)
      b24 = y(11)
      b25 = y(12)
      b26 = y(13)
      b27 = y(14)
      b28 = y(15)
      b29 = y(16)
      b30 = y(17)
      b31 = y(18)
      b32 = y(19)
      b33 = y(20)
      b34 = y(21)
      b35 = y(22)
      b36 = y(23)
      b37 = y(24)
      b38 = y(25)
      b39 = y(26)
      b40 = y(27)
      b41 = y(28)
      b42 = y(29)
      b43 = y(30)
      b44 = y(31)
      b45 = y(32)
      b46 = y(33)
      b47 = y(34)
      b48 = y(35)
      b49 = y(36)
      b50 = y(37)
      b51 = y(38)
      b52 = y(39)
      b53 = y(40)
      b54 = y(41)
      b55 = y(42)
      b56 = y(43)
      b57 = y(44)
      b58 = y(45)
      b59 = y(46)
      b60 = y(47)
      b61 = y(48)
      b62 = y(49)
      b63 = y(50)
      b64 = y(51)
      b65 = y(52)
      b66 = y(53)
      b67 = y(54)
      b68 = y(55)
      b69 = y(56)
      b70 = y(57)
      b71 = y(58)
      b72 = y(59)
      b73 = y(60)
      b74 = y(61)
      b75 = y(62)
      b76 = y(63)

      f = -(416000.0d0*x4*(1.0d0 - dexp(-0.1d0*x1/x4)) + 37440.0d0*x1 
     /     - 100.0d0*x4 + 124615.384615385d0*x5*(1.0d0 
     /     - dexp(-0.13d0*x2/x5)) + 9000.0d0*x2 - 90.0d0*x5 
     /     + 278666.666666667d0*x6*(1.0d0 - dexp(-0.09d0*x3/x6)) 
     /     + 15840.0d0*x3 - 80.0d0*x6)/x13   

      e2 = - 1300.0d0*x1 + x7 + 350.0d0*x13  

      e3 = - 1000.0d0*x2 + x8 + 300.0d0*x13 
     
      e4 = - 1100.0d0*x3 + x9 + 300.0d0*x13   

      e5 = x7 - 300.0d0*x13     

      e6 = x8 - 300.0d0*x13                

      e7 = x9 - 300.0d0*x13                                         

      e8 = x4 - 0.01d0*b14 - b15 - 2.0d0*b16 - 3.0d0*b17 - 4.0d0*b18 
     /     - 5.0d0*b19 - 6.0d0*b20 - 7.0d0*b21 - 8.0d0*b22 - 9.0d0*b23
     /     - 10.0d0*b24 - 11.0d0*b25 - 12.0d0*b26 - 13.0d0*b27 
     /     - 14.0d0*b28 - 15.0d0*b29 - 16.0d0*b30 - 17.0d0*b31
     /     - 18.0d0*b32 - 19.0d0*b33 - 20.0d0*b34         

      e9 = x5 - 0.01d0*b35 - b36 - 2.0d0*b37 - 3.0d0*b38 - 4.0d0*b39 
     /     - 5.0d0*b40 - 6.0d0*b41 - 7.0d0*b42 - 8.0d0*b43 - 9.0d0*b44 
     /     - 10.0d0*b45 - 11.0d0*b46 - 12.0d0*b47 - 13.0d0*b48 
     /     - 14.0d0*b49 - 15.0d0*b50 - 16.0d0*b51 - 17.0d0*b52 
     /     - 18.0d0*b53 - 19.0d0*b54 - 20.0d0*b55         

      e10 = x6 - 0.01d0*b56 - b57 - 2.0d0*b58 - 3.0d0*b59 - 4.0d0*b60 
     /      - 5.0d0*b61 - 6.0d0*b62 - 7.0d0*b63 - 8.0d0*b64 - 9.0d0*b65 
     /      - 10.0d0*b66 - 11.0d0*b67 - 12.0d0*b68 - 13.0d0*b69 
     /      - 14.0d0*b70 - 15.0d0*b71 - 16.0d0*b72 - 17.0d0*b73 
     /      - 18.0d0*b74 - 19.0d0*b75 - 20.0d0*b76   

      e11 = - b14 - b15 - b16 - b17 - b18 - b19 - b20 - b21 - b22 
     /      - b23 - b24 - b25 - b26 - b27 - b28 - b29 - b30 - b31 
     /      - b32 - b33 - b34 + 1.0d0                                 

      e12 = - b35 - b36 - b37 - b38 - b39 - b40 - b41 - b42 - b43 
     /      - b44 - b45 - b46 - b47 - b48 - b49 - b50 - b51 - b52 
     /      - b53 - b54 - b55 + 1.0d0                                 

      e13 = - b56 - b57 - b58 - b59 - b60 - b61 - b62 - b63 - b64 
     /      - b65 - b66 - b67 - b68 - b69 - b70 - b71 - b72 - b73 
     /      - b74 - b75 - b76 + 1.0d0                                 

      e14 = - x1 - 2.0d0*x4 + x10                      

      e15 = - x2 - 3.0d0*x5 + x11                                      

      e16 = - x3 - 3.0d0*x6 + x12                  

      e17 =   x10 + x11 + x12 - x13                 

      e18 =   x1 + 150.0d0*b14 - 150.0d0

      e19 =   x2 + 150.0d0*b35 - 150.0d0                 

      e20 =   x3 + 150.0d0*b56 - 150.0d0               
 
      e21 =   x4 - 1.0d0                                        

      e22 =   x5 - 1.0d0                                

      e23 =   x6 - 1.0d0           
 
      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e8
      g(5) = e9
      g(6) = e10
      g(7) = e11
      g(8) = e12
      g(9) = e13
      g(10) = e14
      g(11) = e15
      g(12) = e16
      g(13) = -e5
      g(14) = -e6
      g(15) = -e7
      g(16) = -e17
      g(17) = -e18
      g(18) = -e19
      g(19) = -e20
      g(20) = e21
      g(21) = e22
      g(22) = e23

  999 continue
      return
      end

      subroutine dakota( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), xex1, xex2, xex3, xex4, i1, i2, x1, x2
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DAKOTA'
         pref  = '\cite{EGW02}'
         xex1 = 0.5D0
         xex2 = 0.5D0
         xex3 = 1.0d0
         xex4 = 1.0d0
         fex = (xex1 - 1.4d0)**4 + (xex2 - 1.4d0)**4 
     /         + (xex3 - 1.4d0)**4 + (xex4 - 1.4d0)**4
         ncont = 2
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         do i=1,ncont
            xl(i) = -10.0d0
            x(i)  = 0.5d0
            xu(i) = 10.0d0
         enddo
         x(2) = 1.5D0
         do i = ncont+1, n
            xl(i) = 0.0d0
            x(i)  = 2.0d0
            xu(i) = 4.0d0
         enddo
      goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      x1 = x(1)
      x2 = x(2)
      i1 = y(1)
      i2 = y(2)      

      f = (x1 - 1.4d0)**4 + (x2 - 1.4d0)**4 
     /                 + (i1 - 1.4d0)**4 + (i2 - 1.4d0)**4

      g(1) = 0.5d0*x2 - x1**2
      
      g(2) = 0.5d0*x1 - x2**2        

  999 continue
      return
      end

      subroutine deb10(  mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:35:18
*  
*  Equation counts
*     Total       E       G       L       N       X
*       130      66      20      44       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       183     161      22       0       0       0       0       0
*  FX    45      34      11       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       692     260     432       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex,
     /         g(mmax), 
     /          x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14,  x15, x16, x17, x18, x19,x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /         x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /         x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /         x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /         x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /         x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /         x101,x102,x103,x104,x105,x106,x107,x108,x109,x110,
     /         x111,x112,x113,x114,x115,x116,x117,x118,x119,x120,
     /         x121,x122,x123,x124,x125,x126,x127,x128,x129,x130,
     /         x131,x132,x133,x134,x135,x136,x137,x138,x139,x140,
     /         x141,x142,x143,x144,x145,x146,x147,x148,x149,x150,
     /         x151,x152,x153,x154,x155,x156,x157,x158,x159,x160
      double precision
     /              b162,b163,b164,b165,b166,b167,b168,b169,b170,
     /         b171,b172,b173,b174,b175,b176,b177,b178,b179,b180,
     /         b181,b182,b183,
     /           e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /          e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /          e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /          e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /          e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /          e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /          e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /          e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /          e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /          e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /         e101,e102,e103,e104,e105,e106,e107,     e109,e110,
     /         e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /         e121,e122,e123,e124,e125,e126,e127,e128,e129,e130
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DEB10'
         pref  = '\cite{MINLPLib}'
         fex   = 0.19880067D+03
         ncont = 160
         nint  = 0
         nbin  = 22
         n     = ncont + nbin + nint
         m     = 129
         me    = 65
         do i = 1,ncont
            xl(i) = -1.0d2
            x(i)  = 0.0d0
            xu(i) = 1.0d2
         enddo
         do i = ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xl(1) = 0.0d0
         xl(3) = 0.0d0
         xl(5) = 0.0d0
         xl(8) = 0.0d0
         xl(16) = 0.0d0
         xl(49) = 0.0d0     
         do i = 34,70
            x(i) = -1.0d0
         enddo
         do i = 65,80
            xl(i) = 0.0d0
         enddo
         xl(82) = 0.0d0     
         xl(84) = 0.0d0     
         xl(86) = 0.0d0     
         xl(87) = 0.0d0     
         do i = 89,95
            xl(i) = 0.0d0
         enddo
         do i = 129,160
            xl(i) = 0.0d0
         enddo
         xl(2) = 0.9d0 
         xu(2) = 1.05d0           
         xl(4) = 0.9d0 
         xu(4) = 1.05d0           
         xl(6) = 0.9d0 
         xu(6) = 1.05d0           
         xl(7) = 0.9d0 
         xu(7) = 1.05d0  
         do i=9,15         
            xl(i) = 0.9d0 
            xu(i) = 1.05d0           
         enddo   
         xl(17) = 1.06d0         
         x(17) = 1.06d0          
         xu(17) = 1.06d0          
         xl(49) = 0d0             
         x(49) = 0d0             
         xu(49) = 0d0             
         xu(65) = 4d0             
         xl(66) = 0d0             
         x(66) = 0d0             
         xu(66) = 0d0             
         xu(67) = 0.8d0           
         xl(68) = 0d0             
         x(68) = 0d0             
         xu(68) = 0d0             
         xu(69) = 1.2d0           
         xl(70) = 0d0             
         x(70) = 0d0             
         xu(70) = 0d0             
         xl(71) = 0d0            
         x(71) = 0d0             
         xu(71) = 0d0             
         xu(72) = 0.24d0
         do i=73,79          
            xl(i) = 0d0             
            x(i)  = 0d0             
            xu(i) = 0d0             
         enddo   
         xu(80) = 0.5d0           
         xl(81) = -0.2d0 
         xu(81) = 0.6d0         
         xl(82) = 0d0             
         x(82) = 0d0             
         xu(82) = 0d0             
         xl(83) = -0.08d0 
         xu(83) = 0.2d0        
         xl(84) = 0d0             
         x(84) = 0d0             
         xu(84) = 0d0             
         xl(85) = -0.3d0 
         xu(85) = 0.6d0         
         xl(86) = 0d0             
         x(86) = 0d0             
         xl(86) = 0d0             
         xl(87) = 0d0             
         x(87) = 0d0             
         xu(87) = 0d0             
         xl(88) = -0.1d0 
         xu(88) = 0.13d0   
         do i=89,95     
            xl(i) = 0d0             
            x(i)  = 0d0             
            xu(i) = 0d0             
         enddo   
         xl(96) = -0.04d0 
         xu(96) = 0.24d0  
         xl(129) = 0.0d0          
         x(129) = 0.0d0          
         xu(129) = 0.0d0          
         xl(131) = 0.0d0          
         x(131) = 0.0d0          
         xu(131) = 0.0d0          
         xl(133) = 0.0d0          
         x(133) = 0.0d0          
         xu(133) = 0.0d0          
         xl(136) = 0.0d0          
         x(136) = 0.0d0          
         xu(136) = 0.0d0          
         xl(144) = 0.0d0          
         x(144) = 0.0d0          
         xu(144) = 0.0d0          
         xl(145) = 0.0d0          
         x(145) = 0.0d0          
         xu(145) = 0.0d0          
         xl(147) = 0.0d0          
         x(147) = 0.0d0          
         xu(147) = 0.0d0          
         xl(149) = 0.0d0          
         x(149) = 0.0d0          
         xu(149) = 0.0d0          
         xl(152) = 0.0d0          
         x(152) = 0.0d0          
         xu(152) = 0.0d0          
         xl(160) = 0.0d0  
         x(160) = 0.0d0  
         xu(160) = 0.0d0  
         do i=173,183        
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 0.0d0
         enddo   
         x(1) = 1.0d0 
         x(2) = 1.0d0 
         x(3) = 1.0d0 
         x(4) = 1.0d0 
         x(5) = 1.0d0 
         x(6) = 1.0d0 
         x(7) = 1.0d0 
         x(8) = 1.0d0 
         x(9) = 1.0d0 
         x(10) = 1.0d0 
         x(11) = 1.0d0 
         x(12) = 1.0d0 
         x(13) = 1.0d0 
         x(14) = 1.0d0 
         x(15) = 1.0d0 
         x(16) = 1.0d0 
         x(18) = 1.066509d0       
         x(19) = 1.068869d0       
         x(20) = 0.920165d0       
         x(21) = 0.956102d0       
         x(22) = 0.909677d0       
         x(23) = 0.89072d0        
         x(24) = 0.899717d0       
         x(25) = 0.92757d0        
         x(26) = 0.942703d0       
         x(27) = 0.952092d0       
         x(28) = 0.951126d0       
         x(29) = 0.982623d0       
         x(30) = 0.940819d0       
         x(31) = 0.880136d0       
         x(32) = 0.944062d0    
         do i=1,n
            if (x(i).lt.xl(i)) x(i) = xl(i)
            if (x(i).gt.xu(i)) x(i) = xu(i)
         enddo   
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      x73 = x(73)
      x74 = x(74)
      x75 = x(75)
      x76 = x(76)
      x77 = x(77)
      x78 = x(78)
      x79 = x(79)
      x80 = x(80)
      x81 = x(81)
      x82 = x(82)
      x83 = x(83)
      x84 = x(84)
      x85 = x(85)
      x86 = x(86)
      x87 = x(87)
      x88 = x(88)
      x89 = x(89)
      x90 = x(90)
      x91 = x(91)
      x92 = x(92)
      x93 = x(93)
      x94 = x(94)
      x95 = x(95)
      x96 = x(96)
      x97 = x(97)
      x98 = x(98)
      x99 = x(99)
      x100 = x(100)
      x101 = x(101)
      x102 = x(102)
      x103 = x(103)
      x104 = x(104)
      x105 = x(105)
      x106 = x(106)
      x107 = x(107)
      x108 = x(108)
      x109 = x(109)
      x110 = x(110)
      x111 = x(111)
      x112 = x(112)
      x113 = x(113)
      x114 = x(114)
      x115 = x(115)
      x116 = x(116)
      x117 = x(117)
      x118 = x(118)
      x119 = x(119)
      x120 = x(120)
      x121 = x(121)
      x122 = x(122)
      x123 = x(123)
      x124 = x(124)
      x125 = x(125)
      x126 = x(126)
      x127 = x(127)
      x128 = x(128)
      x129 = x(129)
      x130 = x(130)
      x131 = x(131)
      x132 = x(132)
      x133 = x(133)
      x134 = x(134)
      x135 = x(135)
      x136 = x(136)
      x137 = x(137)
      x138 = x(138)
      x139 = x(139)
      x140 = x(140)
      x141 = x(141)
      x142 = x(142)
      x143 = x(143)
      x144 = x(144)
      x145 = x(145)
      x146 = x(146)
      x147 = x(147)
      x148 = x(148)
      x149 = x(149)
      x150 = x(150)
      x151 = x(151)
      x152 = x(152)
      x153 = x(153)
      x154 = x(154)
      x155 = x(155)
      x156 = x(156)
      x157 = x(157)
      x158 = x(158)
      x159 = x(159)
      x160 = x(160)
      b162 = y(1)
      b163 = y(2)
      b164 = y(3)
      b165 = y(4)
      b166 = y(5)
      b167 = y(6)
      b168 = y(7)
      b169 = y(8)
      b170 = y(9)
      b171 = y(10)
      b172 = y(11)
      b173 = y(12)
      b174 = y(13)
      b175 = y(14)
      b176 = y(15)
      b177 = y(16)
      b178 = y(17)
      b179 = y(18)
      b180 = y(19)
      b181 = y(20)
      b182 = y(21)
      b183 = y(22)

      f = -(-100.0d0*x130 - 100.0d0*x132 - 100.0d0*x134 - 100.0d0*x135 
     /     - 100.0d0*x137 - 100.0d0*x138 - 100.0d0*x139 - 100.0d0*x140 
     /     - 100.0d0*x141 - 100.0d0*x142 - 100.0d0*x143 - 100.0d0*x146 
     /     - 100.0d0*x148 - 100.0d0*x150 - 100.0d0*x151 - 100.0d0*x153
     /     - 100.0d0*x154 - 100.0d0*x155 - 100.0d0*x156 - 100.0d0*x157
     /     - 100.0d0*x158 - 100.0d0*x159 - 10.0d0*b162    
     /     - 10.0d0*b163 - 10.0d0*b164 - 10.0d0*b165 - 10.0d0*b166 
     /     - 10.0d0*b167 - 10.0d0*b168 - 10.0d0*b169 - 10.0d0*b170 
     /     - 10.0d0*b171 - 10.0d0*b172 - 10.0d0*b173 - 10.0d0*b174 
     /     - 10.0d0*b175 - 10.0d0*b176 - 10.0d0*b177 - 10.0d0*b178 
     /     - 10.0d0*b179 - 10.0d0*b180 - 10.0d0*b181 - 10.0d0*b182 
     /     - 10.0d0*b183)

      e1 = -(15.8964171454635*x1*x1 + x1*x2*(-2.26704183302539
     /      *dcos(x34 - x33) - 18.5374266808153*dsin(x34 - x33)) 
     /      + x1*x5*(-13.6293753124381*dcos(x37 - x33)
     /      - 7.07407023136926*dsin(x37 - x33))) + x65  

      e2 = -(x2*x1*(-2.26704183302539*dcos(x33 - x34) 
     /      - 18.5374266808153*dsin(x33 - x34)) + 3.53430764694598
     /      *x2*x2 + x2*x3*(-1.26726581392059*dcos(x35 - x34)  
     /      - 7.28131607739717*dsin(x35 - x34))) + x66  

      e3 = -(x3*x2*(-1.26726581392059*dcos(x34 - x35) - 7.28131607739717
     /      *dsin(x34 - x35)) + 1.5448109718374*x3*x3 + x3*x4
     /      *(-0.27754515791681*dcos(x36 - x35) - 1.6615816969355
     /      *dsin(x36 - x35))) + x67      

      e4 = -(x4*x3*(-0.27754515791681*dcos(x35 - x36) - 1.6615816969355
     /      *dsin(x35 - x36)) + 2.29003563010891*x4*x4 + x4*x6
     /      *(-0.864296115364742*dcos(x38 - x36) - 6.06886185353939
     /      *dsin(x38 - x36)) + x4*x7*(-0.824884423842853
     /      *dcos(x39 - x36) - 6.35284123437183*dsin(x39 - x36)) 
     /      + x4*x9*(-0.323309932984507*dcos(x41 - x36) 
     /      - 3.06668980551481*dsin(x41 - x36)) - 10.0d0*x4*x16
     /      *dsin(x48 - x36)) + x68            

      e5 = -(x5*x1*(-13.6293753124381*dcos(x33 - x37) - 7.07407023136926
     /      *dsin(x33 - x37)) + 14.9328222636193*x5*x5 + x5*x6
     /      *(-0.556466438117951*dcos(x38 - x37) - 3.59715804640533
     /      *dsin(x38 - x37)) + x5*x7*(-0.746980513063235
     /      *dcos(x39 - x37) - 3.99601522253739*dsin(x39 - x37))) + x69

      e6 = -(x6*x4*(-0.864296115364742*dcos(x36 - x38) 
     /     - 6.06886185353939*dsin(x36 - x38)) + x6*x5
     /     *(-0.556466438117951*dcos(x37 - x38) - 3.59715804640533
     /     *dsin(x37 - x38)) + 1.42076255348269*x6*x6) + x70 - 0.28d0

      e7 = -(x7*x4*(-0.824884423842853*dcos(x36 - x39) 
     /      - 6.35284123437183*dsin(x36 - x39)) + x7*x5
     /      *(-0.746980513063235*dcos(x37 - x39) - 3.99601522253739
     /      *dsin(x37 - x39)) + 8.01827911901728*x7*x7 + x7*x8
     /      *(-6.44641418211119*dcos(x40 - x39) - 56.4061240934729
     /      *dsin(x40 - x39)) - 20*x7*x15*dsin(x47 - x39)) + x71 

      e8 = -(x8*x7*(-6.44641418211119*dcos(x39 - x40) - 56.4061240934729
     /      *dsin(x39 - x40)) + 7.92491432585426*x8*x8 + x8*x9
     /      *(-1.47850014374307*dcos(x41 - x40) - 12.7315290155653
     /      *dsin(x41 - x40))) + x72  

      e9 = -(x9*x4*(-0.323309932984507*dcos(x36 - x41) 
     /      - 3.06668980551481*dsin(x36 - x41)) + x9*x8
     /      *(-1.47850014374307*dcos(x40 - x41) - 12.7315290155653
     /      *dsin(x40 - x41)) + 3.67227520253507*x9*x9 + x9*x10
     /      *(-1.53864841883629*dcos(x42 - x41) - 12.6331133336033
     /      *dsin(x42 - x41)) + x9*x11*(-0.331816706971196
     /      *dcos(x43 - x41) - 2.02240182793204*dsin(x43 - x41)) 
     /      - 6.66666666666667*x9*x14*dsin(x46 - x41)) + x73  

      e10 = -(x10*x9*(-1.53864841883629*dcos(x41 - x42) 
     /       - 12.6331133336033*dsin(x41 - x42)) + 1.87592107119826
     /       *x10*x10 + x10*x11*(-0.337272652361963*dcos(x43 - x42) 
     /       - 2.74800558799463*dsin(x43 - x42)) - 6.66666666666667*x10
     /       *x12*dsin(x44 - x42)) + x74 

      e11 = -(x11*x9*(-0.331816706971196*dcos(x41 - x43) 
     /       - 2.02240182793204*dsin(x41 - x43)) + x11*x10
     /       *(-0.337272652361963*dcos(x42 - x43) - 2.74800558799463
     /       *dsin(x42 - x43)) + 0.669089359333159*x11*x11 
     /       - 6.66666666666667*x11*x13*dsin(x45 - x43)) + x75 - 0.3d0 

      e12 = 6.66666666666667*x12*x10*dsin(x42 - x44) + x76 - 0.56d0    

      e13 = 6.66666666666667*x13*x11*dsin(x43 - x45) + x77  

      e14 = 6.66666666666667*x14*x9*dsin(x41 - x46) + x78 - 0.44d0   

      e15 = 20.0d0*x15*x7*dsin(x39 - x47) + x79 - 2.4d0     

      e16 = 10.0d0*x16*x4*dsin(x36 - x48) + x80             

      e17 = -(25.4742969121846*x1*x1 + x1*x2*(2.26704183302539
     /       *dsin(x34 - x33) - 18.5374266808153*dcos(x34 - x33)) 
     /       + x1*x5*(13.6293753124381*dsin(x37 - x33)
     /       - 7.07407023136926*dcos(x37 - x33))) + x81 + x129 - x145  

      e18 = -(x2*x1*(2.26704183302539*dsin(x33 - x34) - 18.5374266808153
     /       *dcos(x33 - x34)) + 25.7248427582125*x2*x2 + x2*x3
     /       *(1.26726581392059*dsin(x35 - x34) - 7.28131607739717
     /       *dcos(x35 - x34))) + x82 + x130 - x146            

      e19 = -(x3*x2*(1.26726581392059*dsin(x34 - x35) - 7.28131607739717
     /       *dcos(x34 - x35)) + 8.82609777433267*x3*x3 + x3*x4
     /       *(0.27754515791681*dsin(x36 - x35) - 1.6615816969355
     /       *dcos(x36 - x35))) + x83 + x131 - x147             

      e20 = -(x4*x3*(0.27754515791681*dsin(x35 - x36) - 1.6615816969355
     /       *dcos(x35 - x36)) + 27.0030745903615*x4*x4 + x4*x6
     /       *(0.864296115364742*dsin(x38 - x36) - 6.06886185353939
     /       *dcos(x38 - x36)) + x4*x7*(0.824884423842853
     /       *dsin(x39 - x36) - 6.35284123437183*dcos(x39 - x36)) 
     /       + x4*x9*(0.323309932984507*dsin(x41 - x36) 
     /       - 3.06668980551481*dcos(x41 - x36)) - 10.0d0*x4*x16
     /       *dcos(x48 - x36)) + x84 + x132 - x148  

      e21 = -(x5*x1*(13.6293753124381*dsin(x33 - x37) - 7.07407023136926
     /       *dcos(x33 - x37)) + 14.428443500312*x5*x5 + x5*x6
     /       *(0.556466438117951*dsin(x38 - x37) - 3.59715804640533
     /       *dcos(x38 - x37)) + x5*x7*(0.746980513063235
     /       *dsin(x39 - x37) - 3.99601522253739*dcos(x39 - x37)))
     /       + x85 + x133 - x149        

      e22 = -(x6*x4*(0.864296115364742*dsin(x36 - x38) 
     /       - 6.06886185353939*dcos(x36 - x38)) + x6*x5
     /       *(0.556466438117951*dsin(x37 - x38) - 3.59715804640533
     /       *dcos(x37 - x38)) + 9.58501989994471*x6*x6) + x86 + x134 
     /       - x150 - 0.08d0

      e23 = -(x7*x4*(0.824884423842853*dsin(x36 - x39)
     /       - 6.35284123437183*dcos(x36 - x39)) + x7*x5
     /       *(0.746980513063235*dsin(x37 - x39) - 3.99601522253739
     /       *dcos(x37 - x39)) + 86.6293805503822*x7*x7 + x7*x8
     /       *(6.44641418211119*dsin(x40 - x39) - 56.4061240934729
     /       *dcos(x40 - x39)) - 20*x7*x15*dcos(x47 - x39)) + x87
     /       + x135 - x151 + 0.5d0

      e24 = -(x8*x7*(6.44641418211119*dsin(x39 - x40) - 56.4061240934729
     /       *dcos(x39 - x40)) + 69.1318531090383*x8*x8 + x8*x9
     /       *(1.47850014374307*dsin(x41 - x40) - 12.7315290155653
     /       *dcos(x41 - x40))) + x88 + x136 - x152            

      e25 = -(x9*x4*(0.323309932984507*dsin(x36 - x41) 
     /       - 3.06668980551481*dcos(x36 - x41)) + x9*x8
     /       *(1.47850014374307*dsin(x40 - x41) - 12.7315290155653
     /       *dcos(x40 - x41)) + 37.0715006492821*x9*x9 + x9*x10
     /       *(1.53864841883629*dsin(x42 - x41) - 12.6331133336033
     /       *dcos(x42 - x41)) + x9*x11*(0.331816706971196
     /       *dsin(x43 - x41) - 2.02240182793204*dcos(x43 - x41)) 
     /       - 6.66666666666667*x9*x14*dcos(x46 - x41)) + x89 + x137 
     /       - x153 + 0.2d0

      e26 = -(x10*x9*(1.53864841883629*dsin(x41 - x42) 
     /       - 12.6331133336033*dcos(x41 - x42)) + 22.0194855882646*x10
     /       *x10 + x10*x11*(0.337272652361963*dsin(x43 - x42) 
     /       - 2.74800558799463*dcos(x43 - x42)) - 6.66666666666667*x10
     /       *x12*dcos(x44 - x42)) + x90 + x138 - x154 + 0.2d0

      e27 = -(x11*x9*(0.331816706971196*dsin(x41 - x43) 
     /       - 2.02240182793204*dcos(x41 - x43)) + x11*x10
     /       *(0.337272652361963*dsin(x42 - x43) - 2.74800558799463
     /       *dcos(x42 - x43)) + 11.3946740825933*x11*x11 
     /       - 6.66666666666667*x11*x13*dcos(x45 - x43)) + x91 + x139
     /       - x155 - 0.1d0

      e28 = -(6.66666666666667*x12*x12 - 6.66666666666667*x12*x10
     /       *dcos(x42 - x44)) + x92 + x140 - x156 + 0.08d0

      e29 = -(6.66666666666667*x13*x13 - 6.66666666666667*x13*x11
     /       *dcos(x43 - x45)) + x93 + x141 - x157 + 0.2d0              

      e30 = -(6.66666666666667*x14*x14 - 6.66666666666667*x14*x9
     /       *dcos(x41 - x46)) + x94 + x142 - x158 + 0.1d0

      e31 = -(20.0d0*x15*x15 - 20.0d0*x15*x7*dcos(x39 - x47)) + x95 
     /       + x143 - x159      

      e32 = -(10.0d0*x16*x16 - 10.0d0*x16*x4*dcos(x36 - x48)) + x96 
     /       + x144 - x160      

      e33 =  x33           

      e34 = 15.8964171454635*x17*x17 + x17*x18*(-2.26704183302539
     /      *dcos(x50 - x49) - 18.5374266808153*dsin(x50 - x49)) + x17
     /      *x21*(-13.6293753124381*dcos(x53 - x49) - 7.07407023136926
     /      *dsin(x53 - x49)) - x97  

      e35 = x18*x17*(-2.26704183302539*dcos(x49 - x50) 
     /      - 18.5374266808153*dsin(x49 - x50)) + 3.53430764694598*x18
     /      *x18 + x18*x19*(-1.26726581392059*dcos(x51 - x50) 
     /      - 7.28131607739717*dsin(x51 - x50)) - x98  

      e36 = x19*x18*(-1.26726581392059*dcos(x50 - x51) 
     /      - 7.28131607739717*dsin(x50 - x51)) + 1.5448109718374*x19
     /      *x19 + x19*x20*(-0.27754515791681*dcos(x52 - x51) 
     /      - 1.6615816969355*dsin(x52 - x51)) - x99

      e37 = x20*x19*(-0.27754515791681*dcos(x51 - x52) - 1.6615816969355
     /      *dsin(x51 - x52)) + 2.29003563010891*x20*x20 + x20*x22
     /      *(-0.864296115364742*dcos(x54 - x52) - 6.06886185353939
     /      *dsin(x54 - x52)) + x20*x23*(-0.824884423842853
     /      *dcos(x55 - x52) - 6.35284123437183*dsin(x55 - x52))
     /      + x20*x25*(-0.323309932984507*dcos(x57 - x52) 
     /      - 3.06668980551481*dsin(x57 - x52)) - 10.0d0*x20*x32
     /      *dsin(x64 - x52) - x100  

      e38 = x21*x17*(-13.6293753124381*dcos(x49 - x53) 
     /      - 7.07407023136926*dsin(x49 - x53)) + 14.9328222636193*x21
     /      *x21 + x21*x22*(-0.556466438117951*dcos(x54 -x53) 
     /      - 3.59715804640533*dsin(x54 - x53)) + x21*x23
     /      *(-0.746980513063235*dcos(x55 - x53) - 3.99601522253739
     /      *dsin(x55 - x53)) - x101 

      e39 = x22*x20*(-0.864296115364742*dcos(x52 - x54) 
     /      - 6.06886185353939*dsin(x52 - x54)) + x22*x21
     /      *(-0.556466438117951*dcos(x53 - x54) - 3.59715804640533
     /      *dsin(x53 - x54)) + 1.42076255348269*x22*x22 - x102        

      e40 = x23*x20*(-0.824884423842853*dcos(x52 - x55) 
     /      - 6.35284123437183*dsin(x52 - x55)) + x23*x21
     /      *(-0.746980513063235*dcos(x53 - x55) - 3.99601522253739
     /      *dsin(x53 - x55)) + 8.01827911901728*x23*x23 + x23*x24
     /      *(-6.44641418211119*dcos(x56 - x55) - 56.4061240934729
     /      *dsin(x56 - x55)) - 20*x23*x31*dsin(x63 - x55) - x103  

      e41 = x24*x23*(-6.44641418211119*dcos(x55 - x56) 
     /      - 56.4061240934729*dsin(x55 - x56)) + 7.92491432585426*x24
     /      *x24 + x24*x25*(-1.47850014374307*dcos(x57 - x56) 
     /      - 12.7315290155653*dsin(x57 - x56)) - x104           

      e42 = x25*x20*(-0.323309932984507*dcos(x52 - x57) 
     /      - 3.06668980551481*dsin(x52 - x57)) + x25*x24
     /      *(-1.47850014374307*dcos(x56 - x57) - 12.7315290155653
     /      *dsin(x56 - x57)) + 3.67227520253507*x25*x25 + x25*x26
     /      *(-1.53864841883629*dcos(x58 - x57) - 12.6331133336033
     /      *dsin(x58 - x57)) + x25*x27*(-0.331816706971196
     /      *dcos(x59 - x57) - 2.02240182793204*dsin(x59 - x57)) 
     /      - 6.66666666666667*x25*x30*dsin(x62 - x57) - x105  

      e43 = x26*x25*(-1.53864841883629*dcos(x57 - x58) 
     /      - 12.6331133336033*dsin(x57 - x58)) + 1.87592107119826*x26
     /      *x26 + x26*x27*(-0.337272652361963*dcos(x59 - x58) 
     /      - 2.74800558799463*dsin(x59 - x58)) - 6.66666666666667*x26
     /      *x28*dsin(x60 - x58) - x106  

      e44 = x27*x25*(-0.331816706971196*dcos(x57 - x59) 
     /      - 2.02240182793204*dsin(x57 - x59)) + x27*x26
     /      *(-0.337272652361963*dcos(x58 - x59) - 2.74800558799463
     /      *dsin(x58 - x59)) + 0.669089359333159*x27*x27 
     /      - 6.66666666666667*x27*x29*dsin(x61 - x59) - x107 

      e45 = -6.66666666666667*x28*x26*dsin(x58 - x60) - x108        

      e46 = -6.66666666666667*x29*x27*dsin(x59 - x61) - x109        

      e47 = -6.66666666666667*x30*x25*dsin(x57 - x62) - x110        

      e48 = -20.0d0*x31*x23*dsin(x55 - x63) - x111        

      e49 = -10.0d0*x32*x20*dsin(x52 - x64) - x112        

      e50 = 25.4742969121846*x17*x17 + x17*x18*(2.26704183302539
     /      *dsin(x50 - x49) - 18.5374266808153*dcos(x50 - x49)) 
     /      + x17*x21*(13.6293753124381*dsin(x53 - x49) 
     /      - 7.07407023136926*dcos(x53 - x49)) - x113 - x129 + x145 

      e51 = x18*x17*(2.26704183302539*dsin(x49 - x50) - 18.5374266808153
     /      *dcos(x49 - x50)) + 25.7248427582125*x18*x18 + x18*x19
     /      *(1.26726581392059*dsin(x51 - x50) - 7.28131607739717
     /      *dcos(x51 - x50)) - x114 - x130 + x146 

      e52 = x19*x18*(1.26726581392059*dsin(x50 - x51) - 7.28131607739717
     /      *dcos(x50 - x51)) + 8.82609777433267*x19*x19 + x19*x20
     /      *(0.27754515791681*dsin(x52 - x51) - 1.6615816969355
     /      *dcos(x52 - x51)) - x115 - x131 + x147  

      e53 = x20*x19*(0.27754515791681*dsin(x51 - x52) - 1.6615816969355
     /      *dcos(x51 - x52)) + 27.0030745903615*x20*x20 + x20*x22
     /      *(0.864296115364742*dsin(x54 - x52) - 6.06886185353939
     /      *dcos(x54 - x52)) + x20*x23*(0.824884423842853
     /      *dsin(x55 - x52) - 6.35284123437183*dcos(x55 - x52))
     /      + x20*x25*(0.323309932984507*dsin(x57 - x52) 
     /      - 3.06668980551481*dcos(x57 - x52)) - 10.0d0*x20*x32
     /      *dcos(x64 - x52) - x116 - x132 + x148                  

      e54 = x21*x17*(13.6293753124381*dsin(x49 - x53) - 7.07407023136926
     /      *dcos(x49 - x53)) + 14.428443500312*x21*x21 + x21*x22
     /      *(0.556466438117951*dsin(x54 - x53) - 3.59715804640533
     /      *dcos(x54 - x53)) + x21*x23*(0.746980513063235
     /      *dsin(x55 - x53) - 3.99601522253739*dcos(x55 - x53)) - x117
     /      - x133 + x149       

      e55 = x22*x20*(0.864296115364742*dsin(x52 - x54)
     /      - 6.06886185353939*dcos(x52 - x54)) + x22*x21
     /      *(0.556466438117951*dsin(x53 - x54) - 3.59715804640533
     /      *dcos(x53 - x54)) + 9.58501989994471*x22*x22 - x118 - x134 
     /      + x150           

      e56 = x23*x20*(0.824884423842853*dsin(x52 - x55) 
     /      - 6.35284123437183*dcos(x52 - x55)) + x23*x21
     /      *(0.746980513063235*dsin(x53 - x55) - 3.99601522253739
     /      *dcos(x53 - x55)) + 86.6293805503822*x23*x23 + x23*x24
     /      *(6.44641418211119*dsin(x56 - x55) - 56.4061240934729
     /      *dcos(x56 - x55)) - 20*x23*x31*dcos(x63 - x55)
     /      - x119 - x135 + x151 - 0.5d0

      e57 = x24*x23*(6.44641418211119*dsin(x55 - x56) - 56.4061240934729
     /      *dcos(x55 - x56)) + 69.1318531090383*x24*x24 + x24*x25
     /      *(1.47850014374307*dsin(x57 - x56) - 12.7315290155653
     /      *dcos(x57 - x56)) - x120 - x136 + x152 

      e58 = x25*x20*(0.323309932984507*dsin(x52 - x57) 
     /      - 3.06668980551481*dcos(x52 - x57)) + x25*x24
     /      *(1.47850014374307*dsin(x56 - x57) - 12.7315290155653
     /      *dcos(x56 - x57)) + 37.0715006492821*x25*x25 + x25*x26
     /      *(1.53864841883629*dsin(x58 - x57) - 12.6331133336033
     /      *dcos(x58 - x57)) + x25*x27*(0.331816706971196
     /      *dsin(x59 - x57) - 2.02240182793204*dcos(x59 - x57)) 
     /      - 6.66666666666667*x25*x30*dcos(x62 - x57) - x121 - x137 
     /      + x153 - 0.2d0  

      e59 = x26*x25*(1.53864841883629*dsin(x57 - x58) - 12.6331133336033
     /      *dcos(x57 - x58)) + 22.0194855882646*x26*x26 + x26*x27
     /      *(0.337272652361963*dsin(x59 - x58) - 2.74800558799463
     /      *dcos(x59 - x58)) - 6.66666666666667*x26*x28
     /      *dcos(x60 - x58) - x122 - x138 + x154 - 0.2d0          

      e60 = x27*x25*(0.331816706971196*dsin(x57 - x59) 
     /      - 2.02240182793204*dcos(x57 - x59)) + x27*x26
     /      *(0.337272652361963*dsin(x58 - x59) - 2.74800558799463
     /      *dcos(x58 - x59)) + 11.3946740825933*x27*x27 
     /      - 6.66666666666667*x27*x29*dcos(x61 - x59) - x123 - x139 
     /      + x155               

      e61 = 6.66666666666667*x28*x28 - 6.66666666666667*x28*x26
     /      *dcos(x58 - x60) - x124 - x140 + x156 - 0.2d0

      e62 = 6.66666666666667*x29*x29 - 6.66666666666667*x29*x27
     /      *dcos(x59 - x61) - x125 - x141 + x157 - 0.2d0

      e63 = 6.66666666666667*x30*x30 - 6.66666666666667*x30*x25
     /      *dcos(x57 - x62) - x126 - x142 + x158 - 0.2d0

      e64 = 20*x31*x31 - 20*x31*x23*dcos(x55 - x63) - x127 - x143 + x159
     /      - 0.5d0   

      e65 = 10.0d0*x32*x32 - 10.0d0*x32*x20*dcos(x52 - x64) - x128 
     /      - x144 + x160           

      e66 = -x97 + 4.0d0      

      e67 = -x99 + 0.8d0    

      e68 = -x101 + 1.2d0   

      e69 = -x104 + 0.24d0  

      e70 = -x112 + 0.5d0   

      e71 = x97

      e72 = x99

      e73 = x101            

      e74 = x104            

      e75 = x112            

      e76 = -x113 + 0.6d0   

      e77 = -x115 + 0.2d0   

      e78 = -x117 + 0.6d0   

      e79 = -x120 + 0.13d0  

      e80 = -x128 + 0.24d0  

      e81 = x113 + 0.2d0   

      e82 = x115 + 0.08d0  

      e83 = x117 + 0.3d0   

      e84 = x120 + 0.1d0   

      e85 = x128 + 0.04d0  

      e86 = x98

      e87 = x100            

      e88 = x102 + 0.329411764705882d0             

      e89 = x103            

      e90 = x105            

      e91 = x106            

      e92 = x107 + 0.352941176470588d0             

      e93 = x108 + 0.658823529411765d0             

      e94 = x109            

      e95 = x110 + 0.517647058823529d0             

      e96 = x111 + 2.82352941176471d0              

      e97 = x114            

      e98 = x116            

      e99 = x118 + 0.0941176470588235d0            

      e100 = x119           

      e101 = x121           

      e102 = x122           

      e103 = x123 + 0.117647058823529d0            

      e104 = x124 + 0.141176470588235d0            

      e105 = x125           

      e106 = x126 + 0.117647058823529d0            

      e107 = x127 + 0.588235294117648d0            

      e109 = x130 - 0.4d0*b162

      e110 = x132 - 0.4d0*b163

      e111 = x134 - 0.4d0*b164

      e112 = x135 - 0.4d0*b165

      e113 = x137 - 0.4d0*b166

      e114 = x138 - 0.4d0*b167

      e115 = x139 - 0.4d0*b168

      e116 = x140 - 0.4d0*b169

      e117 = x141 - 0.4d0*b170

      e118 = x142 - 0.4d0*b171

      e119 = x143 - 0.4d0*b172

      e120 = x146 - 0.4d0*b173

      e121 = x148 - 0.4d0*b174

      e122 = x150 - 0.4d0*b175

      e123 = x151 - 0.4d0*b176

      e124 = x153 - 0.4d0*b177

      e125 = x154 - 0.4d0*b178

      e126 = x155 - 0.4d0*b179

      e127 = x156 - 0.4d0*b180

      e128 = x157 - 0.4d0*b181

      e129 = x158 - 0.4d0*b182

      e130 = x159 - 0.4d0*b183   

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = e5
      g(6) = e6
      g(7) = e7
      g(8) = e8
      g(9) = e9
      g(10) = e10
      g(11) = e11
      g(12) = e12
      g(13) = e13
      g(14) = e14
      g(15) = e15
      g(16) = e16
      g(17) = e17
      g(18) = e18
      g(19) = e19
      g(20) = e20
      g(21) = e21
      g(22) = e22
      g(23) = e23
      g(24) = e24
      g(25) = e25
      g(26) = e26
      g(27) = e27
      g(28) = e28
      g(29) = e29
      g(30) = e30
      g(31) = e31
      g(32) = e32
      g(33) = e33
      g(34) = e34
      g(35) = e35
      g(36) = e36
      g(37) = e37
      g(38) = e38
      g(39) = e39
      g(40) = e40
      g(41) = e41
      g(42) = e42
      g(43) = e43
      g(44) = e44
      g(45) = e45
      g(46) = e46
      g(47) = e47
      g(48) = e48
      g(49) = e49
      g(50) = e50
      g(51) = e51
      g(52) = e52
      g(53) = e53
      g(54) = e54
      g(55) = e55
      g(56) = e56
      g(57) = e57
      g(58) = e58
      g(59) = e59
      g(60) = e60
      g(61) = e61
      g(62) = e62
      g(63) = e63
      g(64) = e64
      g(65) = e65
      g(66) = e66
      g(67) = e67
      g(68) = e68
      g(69) = e69
      g(70) = e70
      g(71) = e71
      g(72) = e72
      g(73) = e73
      g(74) = e74
      g(75) = e75
      g(76) = e76
      g(77) = e77
      g(78) = e78
      g(79) = e79
      g(80) = e80
      g(81) = e81
      g(82) = e82
      g(83) = e83
      g(84) = e84
      g(85) = e85
      g(86) = -e86
      g(87) = -e87
      g(88) = -e88
      g(89) = -e89
      g(90) = -e90
      g(91) = -e91
      g(92) = -e92
      g(93) = -e93
      g(94) = -e94
      g(95) = -e95
      g(96) = -e96
      g(97) = -e97
      g(98) = -e98
      g(99) = -e99
      g(100) = -e100
      g(101) = -e101
      g(102) = -e102
      g(103) = -e103
      g(104) = -e104
      g(105) = -e105
      g(106) = -e106
      g(107) = -e107
      g(108) = -e109
      g(109) = -e110
      g(110) = -e111
      g(111) = -e112
      g(112) = -e113
      g(113) = -e114
      g(114) = -e115
      g(115) = -e116
      g(116) = -e117
      g(117) = -e118
      g(118) = -e119
      g(119) = -e120
      g(120) = -e121
      g(121) = -e122
      g(122) = -e123
      g(123) = -e124
      g(124) = -e125
      g(125) = -e126
      g(126) = -e127
      g(127) = -e128
      g(128) = -e129
      g(129) = -e130

  999 continue
      return
      end
 

      subroutine dex2( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), w(2)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DEX2'
         pref  = '\cite{CM89}'
         fex   = -56.9375d0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         xl(1) = 0.0d0
         x(1)  = 10.0d0
         xu(1) = 20.0d0
         xl(2) = 12.0d0
         x(2)  = 12.0d0
         xu(2) = 20.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo
      
      w(1) = y(1)*0.25d0
      w(2) = y(2)*0.25d0   

      f =  2.0d0*w(1)**2 + w(2)**2 - 16.0d0*w(1) - 10.0d0*w(2)

      g(1) = -w(1)**2 + 6.0d0*w(1) - w(2) + 11.0d0
     
      g(2) = w(1)*w(2) - 3.0d0*w(2)**2 - dexp(w(1) - 3.0d0) + 51.5d0

  999 continue
      return
      end

      subroutine diophe( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DIOPHE'
         pref  = 'diophantine equation'
         fex   = -2.0D0  
         ncont = 0
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 1
         xl(1) = 1.0d0
         x(1)  = 1.0d0
         xu(1) = 10.0d0
         do i=2,4
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 100.0d0
         end do     
         goto 999       
      end if
      
      f = -x(1) 
      
      g(1) = x(2)**x(1) + x(3)**x(1) - x(4)**x(1)

  999 continue
      return
      end

      subroutine dirty( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me, ncont, nint, nbin, n, nmax, mmax, i, j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), s, a(25,10), b(10), c(25,25), d(25)
      character*30 pnam, pref
      data    a/  1.0d0, 64.0d0, 86.0d0, 56.0d0, 55.0d0, 
     /           95.0d0, 78.0d0, 74.0d0, 72.0d0, 34.0d0,  
     /           33.0d0, 94.0d0, 36.0d0,  8.0d0, 36.0d0, 
     /           97.0d0, 58.0d0,  9.0d0, 86.0d0, 22.0d0,
     /           68.0d0, 69.0d0, 12.0d0, 38.0d0, 12.0d0,
     /            3.0d0, 19.0d0, 18.0d0, 49.0d0, 12.0d0, 
     /           65.0d0, 28.0d0, 96.0d0, 75.0d0, 90.0d0,
     /           40.0d0, 22.0d0, 21.0d0, 60.0d0, 95.0d0,
     /           73.0d0, 64.0d0,  7.0d0, 52.0d0, 67.0d0,
     /           53.0d0,  8.0d0,  5.0d0, 68.0d0,  7.0d0,
     /           12.0d0, 92.0d0, 36.0d0, 75.0d0, 73.0d0, 
     /           84.0d0, 35.0d0, 60.0d0, 27.0d0, 45.0d0,
     /            6.0d0, 45.0d0, 39.0d0, 79.0d0, 17.0d0,
     /           26.0d0, 41.0d0, 43.0d0, 45.0d0, 45.0d0,
     /           50.0d0, 53.0d0, 42.0d0, 16.0d0, 34.0d0,
     /           39.0d0, 29.0d0,  3.0d0, 58.0d0, 68.0d0,    
     /           28.0d0, 16.0d0, 57.0d0, 96.0d0, 45.0d0,
     /           94.0d0, 24.0d0, 30.0d0, 29.0d0, 73.0d0,
     /           90.0d0,  4.0d0,  0.0d0, 35.0d0,  1.0d0,
     /           78.0d0, 39.0d0, 99.0d0, 35.0d0,  7.0d0,
     /           79.0d0, 72.0d0, 58.0d0, 78.0d0, 27.0d0,
     /           65.0d0,  5.0d0, 35.0d0,  5.0d0, 16.0d0,
     /           50.0d0, 98.0d0, 78.0d0, 65.0d0, 83.0d0, 
     /           76.0d0, 97.0d0, 66.0d0, 84.0d0, 77.0d0,  
     /           25.0d0, 19.0d0, 19.0d0, 12.0d0, 70.0d0,
     /           82.0d0, 84.0d0, 19.0d0, 63.0d0, 66.0d0,   
     /           32.0d0, 61.0d0,  9.0d0, 46.0d0, 68.0d0, 
     /            6.0d0, 72.0d0, 54.0d0,  8.0d0,  2.0d0,  
     /           48.0d0, 69.0d0, 85.0d0, 22.0d0, 10.0d0,
     /           57.0d0, 72.0d0, 95.0d0, 26.0d0, 35.0d0,
     /           35.0d0, 44.0d0, 35.0d0, 90.0d0, 19.0d0,
     /           44.0d0, 82.0d0, 48.0d0, 99.0d0,  8.0d0,
     /           52.0d0, 66.0d0, 75.0d0, 67.0d0, 81.0d0,
     /           85.0d0, 69.0d0, 99.0d0, 43.0d0, 33.0d0,
     /           46.0d0, 43.0d0, 35.0d0, 12.0d0, 92.0d0,
     /           50.0d0,  7.0d0, 26.0d0, 81.0d0, 62.0d0,
     /            6.0d0, 37.0d0, 15.0d0, 16.0d0, 48.0d0,
     /           35.0d0, 37.0d0, 86.0d0, 45.0d0, 57.0d0,
     /           90.0d0, 16.0d0,  8.0d0, 25.0d0,  2.0d0,
     /           27.0d0, 20.0d0, 53.0d0, 70.0d0, 85.0d0,
     /           97.0d0, 49.0d0, 91.0d0, 42.0d0, 68.0d0,
     /            8.0d0, 62.0d0,  1.0d0, 88.0d0, 84.0d0, 
     /           12.0d0, 46.0d0,  9.0d0, 19.0d0, 98.0d0,
     /           44.0d0, 62.0d0, 65.0d0, 19.0d0, 50.0d0,
     /            0.0d0, 13.0d0, 57.0d0, 80.0d0, 93.0d0,
     /           99.0d0, 32.0d0, 63.0d0,  7.0d0, 50.0d0,
     /           70.0d0, 11.0d0, 96.0d0, 88.0d0, 74.0d0,
     /            6.0d0, 55.0d0, 81.0d0, 54.0d0, 99.0d0,
     /           92.0d0, 86.0d0, 63.0d0,  1.0d0, 99.0d0,
     /           88.0d0, 52.0d0, 91.0d0,  7.0d0, 50.0d0/
      data     b/-7997.37910547808d0,
     /           -6122.36999196370d0,     
     /           -6437.83374209528d0,     
     /           -6948.80683513356d0,     
     /           -8797.11553317864d0,     
     /           -6890.30255880676d0,     
     /           -8453.77372487109d0,     
     /           -6768.99351719498d0,     
     /           -7880.52838512544d0,     
     /           -8656.13717903568d0/     
      data     c/   576.0d0,  2256.0d0,  1032.0d0,  2016.0d0,     0.0d0,
     /              840.0d0,  1416.0d0,  1248.0d0,   408.0d0,   552.0d0,
     /             1272.0d0,  1584.0d0,   216.0d0,  2280.0d0,  1272.0d0,
     /             2232.0d0,  1704.0d0,  1320.0d0,   696.0d0,    72.0d0,
     /             1032.0d0,  1968.0d0,   504.0d0,  1056.0d0,  2232.0d0,
     /             2256.0d0,  9092.0d0,  5066.0d0,  9272.0d0,   336.0d0,
     /             3962.0d0,  5626.0d0,  5736.0d0,  2270.0d0,  2882.0d0,
     /             6166.0d0,  7340.0d0,  1662.0d0, 10226.0d0,  5206.0d0,
     /             8982.0d0,  8242.0d0,  6642.0d0,  3398.0d0,   426.0d0,
     /             5082.0d0,  8956.0d0,  2326.0d0,  5608.0d0,  9654.0d0,
     /             1032.0d0,  5066.0d0,  7466.0d0, 12392.0d0,  3567.0d0,
     /             6689.0d0,  5236.0d0,  9255.0d0,  3692.0d0,  6482.0d0,
     /             9706.0d0, 11048.0d0,  6108.0d0, 11336.0d0,  5905.0d0,
     /             8508.0d0, 12367.0d0,  8955.0d0,  7016.0d0,  2889.0d0,
     /             8583.0d0, 10078.0d0,  2935.0d0,  9457.0d0, 11352.0d0,
     /             2016.0d0,  9272.0d0, 12392.0d0, 22133.0d0,  7919.0d0,
     /            13203.0d0, 12435.0d0, 18838.0d0,  7478.0d0, 12405.0d0,
     /            17312.0d0, 21096.0d0, 12459.0d0, 20498.0d0, 13786.0d0,
     /            18746.0d0, 22044.0d0, 15994.0d0, 14834.0d0,  7955.0d0,
     /            16221.0d0, 17406.0d0,  7450.0d0, 16845.0d0, 22494.0d0,
     /                0.0d0,   336.0d0,  3567.0d0,  7919.0d0,  6643.0d0,
     /             7809.0d0,  7675.0d0, 11406.0d0,  6247.0d0,  7803.0d0,
     /             7631.0d0, 10531.0d0,  9531.0d0,  7546.0d0, 10026.0d0,
     /            10270.0d0,  9520.0d0,  7752.0d0, 10771.0d0,  9178.0d0,
     /             8758.0d0,  5820.0d0,  6676.0d0,  8704.0d0, 10476.0d0,
     /              840.0d0,  3962.0d0,  6689.0d0, 13203.0d0,  7809.0d0,
     /            15711.0d0, 16010.0d0, 17418.0d0, 15515.0d0, 17496.0d0,
     /            16070.0d0, 16420.0d0, 16950.0d0, 16161.0d0, 19183.0d0,
     /            17365.0d0, 21209.0d0, 15755.0d0, 15655.0d0, 15854.0d0,
     /            17388.0d0, 19333.0d0,  8418.0d0, 20160.0d0, 18948.0d0,
     /             1416.0d0,  5626.0d0,  5236.0d0, 12435.0d0,  7675.0d0,
     /            16010.0d0, 28149.0d0, 17967.0d0, 19169.0d0, 19469.0d0,
     /            20733.0d0, 19470.0d0, 24394.0d0, 15932.0d0, 25066.0d0,
     /            26917.0d0, 25194.0d0, 18880.0d0, 13623.0d0, 22637.0d0,
     /            23089.0d0, 19661.0d0, 14464.0d0, 25909.0d0, 28171.0d0,
     /             1248.0d0,  5736.0d0,  9255.0d0, 18838.0d0, 11406.0d0,
     /            17418.0d0, 17967.0d0, 25243.0d0, 18092.0d0, 20489.0d0,
     /            23186.0d0, 26854.0d0, 23458.0d0, 20843.0d0, 25897.0d0,
     /            25650.0d0, 26489.0d0, 21613.0d0, 21762.0d0, 20311.0d0,
     /            23993.0d0, 20609.0d0, 13391.0d0, 23012.0d0, 28072.0d0,
     /              408.0d0,  2270.0d0,  3692.0d0,  7478.0d0,  6247.0d0,
     /            15515.0d0, 19169.0d0, 18092.0d0, 28016.0d0, 24121.0d0,
     /            24927.0d0, 21852.0d0, 29152.0d0, 16666.0d0, 29056.0d0,
     /            22945.0d0, 28192.0d0, 25369.0d0, 17189.0d0, 27734.0d0,
     /            27809.0d0, 24931.0d0, 15041.0d0, 30328.0d0, 24550.0d0,
     /              552.0d0,  2882.0d0,  6482.0d0, 12405.0d0,  7803.0d0,
     /            17496.0d0, 19469.0d0, 20489.0d0, 24121.0d0, 26151.0d0,
     /            28057.0d0, 25701.0d0, 29316.0d0, 18224.0d0, 29850.0d0,
     /            23894.0d0, 30676.0d0, 24780.0d0, 19993.0d0, 25719.0d0,
     /            29566.0d0, 27121.0d0, 13408.0d0, 30039.0d0, 27044.0d0,
     /             1272.0d0,  6166.0d0,  9706.0d0, 17312.0d0,  7631.0d0,
     /            16070.0d0, 20733.0d0, 23186.0d0, 24927.0d0, 28057.0d0,
     /            38296.0d0, 37475.0d0, 37498.0d0, 22645.0d0, 35490.0d0,
     /            30418.0d0, 39052.0d0, 34120.0d0, 23623.0d0, 28199.0d0,
     /            39615.0d0, 31160.0d0, 20621.0d0, 36685.0d0, 37085.0d0,
     /             1584.0d0,  7340.0d0, 11048.0d0, 21096.0d0, 10531.0d0,
     /            16420.0d0, 19470.0d0, 26854.0d0, 21852.0d0, 25701.0d0,
     /            37475.0d0, 48378.0d0, 44423.0d0, 29796.0d0, 41209.0d0,
     /            37366.0d0, 48756.0d0, 38650.0d0, 36477.0d0, 30728.0d0,
     /            45834.0d0, 33333.0d0, 33923.0d0, 41919.0d0, 44614.0d0,
     /              216.0d0,  1662.0d0,  6108.0d0, 12459.0d0,  9531.0d0,
     /            16950.0d0, 24394.0d0, 23458.0d0, 29152.0d0, 29316.0d0,
     /            37498.0d0, 44423.0d0, 55831.0d0, 26174.0d0, 49255.0d0,
     /            41746.0d0, 53645.0d0, 42658.0d0, 35354.0d0, 44076.0d0,
     /            51209.0d0, 37801.0d0, 36707.0d0, 47583.0d0, 43866.0d0,
     /             2280.0d0, 10226.0d0, 11336.0d0, 20498.0d0,  7546.0d0,
     /            16161.0d0, 15932.0d0, 20843.0d0, 16666.0d0, 18224.0d0,
     /            22645.0d0, 29796.0d0, 26174.0d0, 35325.0d0, 32874.0d0,
     /            30148.0d0, 45280.0d0, 30052.0d0, 28689.0d0, 25767.0d0,
     /            36393.0d0, 33883.0d0, 23376.0d0, 36341.0d0, 35446.0d0,
     /             1272.0d0,  5206.0d0,  5905.0d0, 13786.0d0, 10026.0d0,
     /            19183.0d0, 25066.0d0, 25897.0d0, 29056.0d0, 29850.0d0,
     /            35490.0d0, 41209.0d0, 49255.0d0, 32874.0d0, 62484.0d0,
     /            44456.0d0, 60044.0d0, 47104.0d0, 41701.0d0, 54272.0d0,
     /            56115.0d0, 43293.0d0, 38686.0d0, 52798.0d0, 49701.0d0,
     /             2232.0d0,  8982.0d0,  8508.0d0, 18746.0d0, 10270.0d0,
     /            17365.0d0, 26917.0d0, 25650.0d0, 22945.0d0, 23894.0d0,
     /            30418.0d0, 37366.0d0, 41746.0d0, 30148.0d0, 44456.0d0,
     /            58288.0d0, 54317.0d0, 37615.0d0, 39499.0d0, 48111.0d0,
     /            45018.0d0, 40789.0d0, 30352.0d0, 41223.0d0, 49648.0d0,
     /             1704.0d0,  8242.0d0, 12367.0d0, 22044.0d0,  9520.0d0,
     /            21209.0d0, 25194.0d0, 26489.0d0, 28192.0d0, 30676.0d0,
     /            39052.0d0, 48756.0d0, 53645.0d0, 45280.0d0, 60044.0d0,
     /            54317.0d0, 91332.0d0, 60250.0d0, 61652.0d0, 62702.0d0,
     /            74628.0d0, 70016.0d0, 47950.0d0, 73057.0d0, 63467.0d0,
     /             1320.0d0,  6642.0d0,  8955.0d0, 15994.0d0,  7752.0d0,
     /            15755.0d0, 18880.0d0, 21613.0d0, 25369.0d0, 24780.0d0,
     /            34120.0d0, 38650.0d0, 42658.0d0, 30052.0d0, 47104.0d0,
     /            37615.0d0, 60250.0d0, 64364.0d0, 49131.0d0, 52601.0d0,
     /            57965.0d0, 50461.0d0, 46861.0d0, 61765.0d0, 44727.0d0,
     /              696.0d0,  3398.0d0,  7016.0d0, 14834.0d0, 10771.0d0,
     /            15655.0d0, 13623.0d0, 21762.0d0, 17189.0d0, 19993.0d0,
     /            23623.0d0, 36477.0d0, 35354.0d0, 28689.0d0, 41701.0d0,
     /            39499.0d0, 61652.0d0, 49131.0d0, 62956.0d0, 53740.0d0,
     /            55529.0d0, 53555.0d0, 46442.0d0, 54090.0d0, 42735.0d0,
     /               72.0d0,   426.0d0,  2889.0d0,  7955.0d0,  9178.0d0,
     /            15854.0d0, 22637.0d0, 20311.0d0, 27734.0d0, 25719.0d0,
     /            28199.0d0, 30728.0d0, 44076.0d0, 25767.0d0, 54272.0d0,
     /            48111.0d0, 62702.0d0, 52601.0d0, 53740.0d0, 79838.0d0,
     /            64626.0d0, 59686.0d0, 43075.0d0, 60589.0d0, 48551.0d0,
     /             1032.0d0,  5082.0d0,  8583.0d0, 16221.0d0,  8758.0d0,
     /            17388.0d0, 23089.0d0, 23993.0d0, 27809.0d0, 29566.0d0,
     /            39615.0d0, 45834.0d0, 51209.0d0, 36393.0d0, 56115.0d0,
     /            45018.0d0, 74628.0d0, 57965.0d0, 55529.0d0, 64626.0d0,
     /            83266.0d0, 74131.0d0, 51167.0d0, 72850.0d0, 61726.0d0,
     /             1968.0d0,  8956.0d0, 10078.0d0, 17406.0d0,  5820.0d0,
     /            19333.0d0, 19661.0d0, 20609.0d0, 24931.0d0, 27121.0d0,
     /            31160.0d0, 33333.0d0, 37801.0d0, 33883.0d0, 43293.0d0,
     /            40789.0d0, 70016.0d0, 50461.0d0, 53555.0d0, 59686.0d0,
     /            74131.0d0, 92026.0d0, 39524.0d0, 70930.0d0, 57250.0d0,
     /              504.0d0,  2326.0d0,  2935.0d0,  7450.0d0,  6676.0d0,
     /             8418.0d0, 14464.0d0, 13391.0d0, 15041.0d0, 13408.0d0,
     /            20621.0d0, 33923.0d0, 36707.0d0, 23376.0d0, 38686.0d0,
     /            30352.0d0, 47950.0d0, 46861.0d0, 46442.0d0, 43075.0d0,
     /            51167.0d0, 39524.0d0, 58879.0d0, 59668.0d0, 40495.0d0,
     /             1056.0d0,  5608.0d0,  9457.0d0, 16845.0d0,  8704.0d0,
     /            20160.0d0, 25909.0d0, 23012.0d0, 30328.0d0, 30039.0d0,
     /            36685.0d0, 41919.0d0, 47583.0d0, 36341.0d0, 52798.0d0,
     /            41223.0d0, 73057.0d0, 61765.0d0, 54090.0d0, 60589.0d0,
     /            72850.0d0, 70930.0d0, 59668.0d0,100359.0d0, 68938.0d0,
     /             2232.0d0,  9654.0d0, 11352.0d0, 22494.0d0, 10476.0d0,
     /            18948.0d0, 28171.0d0, 28072.0d0, 24550.0d0, 27044.0d0,
     /            37085.0d0, 44614.0d0, 43866.0d0, 35446.0d0, 49701.0d0,
     /            49648.0d0, 63467.0d0, 44727.0d0, 42735.0d0, 48551.0d0,
     /            61726.0d0, 57250.0d0, 40495.0d0, 68938.0d0, 78402.0d0/
      data     d/ -180927.035520d0,     
     /            -821092.607840d0,     
     /            -1125170.39438d0,     
     /            -2214936.75185d0,     
     /            -1196849.13585d0,     
     /            -2177319.73753d0,     
     /            -2762906.51637d0,     
     /            -2979267.99080d0,     
     /            -2868216.87464d0,     
     /            -3083916.29315d0,     
     /            -3922558.24226d0,     
     /            -4693073.83941d0,     
     /            -4916917.43070d0,     
     /            -3709335.07238d0,     
     /            -5393374.15245d0,     
     /            -4934088.94732d0,     
     /            -6686713.13771d0,     
     /            -5346666.36725d0,     
     /            -5089230.23305d0,     
     /            -5520517.53951d0,     
     /            -6374885.15708d0,     
     /            -5698147.14326d0,     
     /            -4518985.38665d0,     
     /            -6491714.51747d0,     
     /            -5923998.27934d0/     

      if (mode.eq.0) then
         pnam  = 'DIRTY'
         pref  = ''
         fex   = -304723942.920279
         ncont = 12
         nint  = 13
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 10
         me    = 0
         do i = 1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         end do
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      do j=1,m
         s = 0.0d0
         do i=1,ncont
            s = s + a(i,j)*x(i)
         end do
         do i=1,nint
            s = s + a(ncont+i,j)*y(i)
         end do
         g(j) = s + b(j)
      end do
      
      f = 0.0d0
      do j=1,ncont
         s = 0.0d0
         do i=1,ncont
            s = s + c(j,i)*x(i)
         end do
         do i=1,nint
            s = s + c(j,ncont+i)*y(i)
         end do
         f = f + 0.5d0*s*x(j) + d(j)*x(j)
      end do
      do j=1,nint
         s = 0.0d0
         do i=1,ncont
            s = s + c(ncont+j,i)*x(i)
         enddo
         do i=1,nint
            s = s + c(ncont+j,ncont+i)*y(i)
         end do
         f = f + 0.5d0*s*y(j) + d(ncont+j)*y(j)
      end do

  999 continue
      return
      end

      subroutine du_opt( mode,     m,     me,  mmax, ncont,  
     /             nbin,  nint,   nmax,     x,    xl,
     /               xu,     f,      g,  pnam,  pref,
     /              fex )    

*  MINLP written by GAMS Convert at 08/07/01 10:06:16
*  
*  Equation counts
*     Total       E       G       L       N       X
*        10       1       6       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        21       8       0      13       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        47      27      20       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /  g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /  i10, i11, i12, i13, x14, x15, x16, x17, x18, x19, x20
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DU_OPT'
         pref  = '\cite{MINLPLib}'
c         fex   = 3.55634d0 
         fex   = 4.2010d0 
         ncont = 7
         nint  = 13
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i=1,ncont
            xl(i) = -1.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d3
         enddo
         xl(1) = -0.0408d0
         x(1)  = -0.0288d0
         xu(1) = -0.0288d0
         x(2)  = 0.0d0
         xu(2) = 0.008d0
         xl(3) = -0.0311d0
         x(3)  = -0.0211d0
         xu(3) = -0.0211d0
         xl(4) = 0.1d0
         x(4)  = 0.5d0
         xu(4) = 1.0d0
         xl(5) = 0.01d0
         x(5)  = 0.05d0
         xu(5) = 0.08d0              
         xl(6) = 0.1d0
         x(6)  = 0.5d0
         xu(6) = 1.0d0
         xl(7) = 0.01d0
         x(7)  = 0.05d0
         xu(7) = 0.08d0
         xu(8) = 16.0d0
         xl(9) = 43.0d0
         x(9)  = 44.0d0
         xu(9) = 46.0d0
         x(10)  = 100.0d0
         xu(10) = 210.0d0
         xl(11) = 51.0d0 
         x(11)  = 75.0d0
         xu(11) = 108.0d0
         xu(12) = 10.0d0
         xu(13) = 10.0d0
         xu(14) = 10.0d0
         xu(15) = 25.0d0
         xu(16) = 10.0d0
         xu(17) = 50.0d0
         xu(18) = 80.0d0
         xu(19) = 80.0d0
         xu(20) = 40.0d0
         goto 999       
      endif
      
      do i=1,nint
         y(i) = x(ncont+i)
      enddo
      
      x14 = x(1)
      x15 = x(2)
      x16 = x(3)
      x17 = x(4)
      x18 = x(5)
      x19 = x(6)
      x20 = x(7)
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)

      f = sqr(0.109998945d0*i1 + 0.0233959355d0*i2
     /  - 4.58859d-5*i3 - 0.0002277963d0*i4 + 0.1034669954d0*i5
     /  + 0.0250971293d0*i6 + 0.0155411331d0*i7 + 0.0108014479d0*i8
     /  + 0.0045137101d0*i9 + 5.79036d-5*i10 + 4.6583d-5*i11
     /  - 4.49004d-5*i12 - 0.0002233547d0*i13 + 25.6672504104d0*x14
     /  - 0.6845946712d0*x15 + 0.1535300974d0*x16 - 0.0933139579d0*x17
     /  + 0.4614083343d0*x18 - 0.0641379463d0*x19 + 0.7660466359d0*x20
     /  - 0.7218179833d0) + 0.64d0*sqr(6.0625297988d0- 0.0412432802d0*i1
     /  - 0.0977224635d0*i2 - 2.99531d-5*i3 + 2.19582d-5*i4
     /  - 0.0404334455d0*i5 - 0.0036426374d0*i6 - 0.0023078396d0*i7
     /  - 0.0017816172d0*i8 - 0.0534985628d0*i9 - 9.84543d-5*i10
     /  - 4.95918d-5*i11 - 3.7099d-6*i12 + 0.0001434197d0*i13
     /  + 42.9101274821d0*x14 + 0.2915268667d0*x15
     /  - 0.2170048789d0*x16 + 0.004584997d0*x17 + 0.0358768521d0*x18
     /  - 0.0026046819d0*x19 - 0.0659624243d0*x20)
      f = f
     /  + sqr(0.4743717354d0*i1 + 0.1020157564d0*i2
     /  - 0.0002031502d0*i3 - 0.0010662478d0*i4 + 0.4666550138d0*i5
     /  + 0.1314268225d0*i6 + 0.084416812d0*i7 + 0.0654657324d0*i8
     /  + 0.01782331d0*i9 + 4.90424d-5*i10 + 0.0002019234d0*i11
     /  - 5.9754d-5*i12 - 0.0008357089d0*i13 + 117.0980126167d0*x14
     /  - 4.4993202945d0*x15 + 0.3643926817d0*x16 - 0.3496847607d0*x17
     /  + 1.0892794617d0*x18 - 0.3623631585d0*x19 + 4.9211060051d0*x20
     /  - 3.4964885411d0) 
      f = f + 0.64d0*sqr(14.9681958649d0
     /  -0.0904443982d0*i1 - 0.2422030626d0*i2 - 4.81325d-5*i3
     /  + 6.32651d-5*i4 - 0.0912625633d0*i5 - 0.0091396804d0*i6
     /  - 0.0057223094d0*i7 - 0.0057218804d0*i8 - 0.1313310662d0*i9
     /  - 0.0001386674d0*i10 - 9.56742d-5*i11 - 3.61025d-5*i12
     /  + 0.0002902713d0*i13 + 107.758560078d0*x14
     /  + 0.8779839107d0*x15 - 0.7455513768d0*x16 - 0.0041815651d0*x17
     /  + 0.2339673006d0*x18 - 0.0188546046d0*x19
     /  - 0.0721138144d0*x20) 
      f = f
     /  + sqr(1.1841807559d0*i1
     /  + 0.2536871508d0*i2 - 0.000504313d0*i3 - 0.0029079317d0*i4
     /  + 1.2051591944d0*i5 + 0.3899446443d0*i6 + 0.2645788473d0*i7
     /  + 0.2308894513d0*i8 + 0.037835822d0*i9 - 0.0005927225d0*i10
     /  + 0.0006435569d0*i11 + 0.0001857575d0*i12 - 0.0014105165d0*i13
     /  + 307.4529463057d0*x14 - 15.1780937915d0*x15
     /  + 0.8257601211d0*x16 - 0.7326525441d0*x17 + 0.9539276158d0*x18
     /  - 1.1866139503d0*x19 + 19.1856490596d0*x20 - 10.0395122378d0)
      f = f
     /  + 0.64d0*sqr(29.1812808818d0 - 0.1505133307d0*i1
     /  - 0.4733849216d0*i2 - 6.6772d-6*i3 + 0.0001616999d0*i4
     /  - 0.1525298733d0*i5 - 0.013887604d0*i6 - 0.0089085314d0*i7
     /  - 0.012068192d0*i8 - 0.2546447213d0*i9 - 3.41376d-5*i10
     /  - 0.0001166405d0*i11 - 0.0001495758d0*i12 + 0.0004938578d0*i13
     /  + 218.6403200779d0*x14 + 1.2343329355d0*x15
     /  - 2.7282000308d0*x16 - 0.0389929967d0*x17 + 0.6694703489d0*x18
     /  - 0.100837974d0*x19 + 0.7305808787d0*x20)
      f = f
     /  + sqr(2.3708502127d0*i1 + 0.5195662306d0*i2
     /  - 0.0008477105d0*i3 - 0.0068346834d0*i4 + 2.4514220089d0*i5
     /  + 0.8661311066d0*i6 + 0.6237286445d0*i7 + 0.5914661375d0*i8
     /  + 0.0784555045d0*i9 - 0.0027211116d0*i10 + 0.0026993491d0*i11
     /  + 0.0004810095d0*i12 - 0.0010923505d0*i13
     /  + 643.3290493179d0*x14 - 27.7561017376d0*x15
     /  + 8.0186395117d0*x16 - 1.2672557345d0*x17 - 0.4706787663d0*x18
     /  - 2.8653875681d0*x19 + 59.2034194606d0*x20 - 23.7020755551d0)
      f = f 
     /  + 0.64d0*sqr(51.4300329684d0 -0.2234856666d0*i1
     /  - 0.8374419222d0*i2 + 0.0003145414d0*i3 + 0.0006754657d0*i4
     /  - 0.2212388548d0*i5 - 0.0117941003d0*i6 - 0.0059571079d0*i7
     /  - 0.0173358628d0*i8 - 0.4490822392d0*i9 + 0.0004791788d0*i10
     /  + 5.62011d-5*i11 - 0.0005546644d0*i12 + 0.0009739492d0*i13
     /  + 407.9383501237d0*x14 - 1.6716467509d0*x15
     /  - 8.9148857096d0*x16 - 0.1461956666d0*x17 + 1.8262409945d0*x18
     /  - 0.3641018035d0*x19 + 6.6067986768d0*x20)
      f = f
     /  + sqr(1.5205390249d0 + 0.0016574761d0*i1 - 0.0047143999d0*i2
     /  - 0.0049142443d0*i3 - 0.0023612315d0*i4 + 0.0010244274d0*i5
     /  + 0.0012504326d0*i6 + 0.0008633596d0*i7 + 0.000644332d0*i8
     /  + 0.0006879339d0*i9 - 0.0003898037d0*i10 - 0.0044686618d0*i11
     /  - 0.002670126d0*i12 + 6.14008d-5*i13 + 0.3179776364d0*x14
     /  + 2.1638530828d0*x15 + 8.7870371217d0*x16 + 0.0179414544d0*x17
     /  - 0.3506843253d0*x18 + 0.0249174581d0*x19
     /  - 0.0707439832d0*x20)
      f = f
     /  + 0.64d0*sqr(0.0027535897d0*i2
     /  - 0.0004960452d0*i1 + 0.0015616094d0*i3 + 0.0030231273d0*i4
     /  - 0.0005203089d0*i5 - 0.000524428d0*i6 - 0.0008124192d0*i7
     /  - 0.000120356d0*i8 + 0.0006398551d0*i9 + 0.0017502319d0*i10
     /  + 0.0013384171d0*i11 + 0.0007672716d0*i12 + 3.3045d-6*i13 
     /  - 0.2278089449d0*x14 - 16.9817650317d0*x15
     /  - 13.5358723599d0*x16 - 0.0073805759d0*x17
     /  + 0.0464963135d0*x18 - 0.0013299842d0*x19 + 0.0223486039d0*x20
     /  - 1.0705236795d0) 
      f = f
     /  + 0.0001d0*sqr(1.9787606911d0
     /  + (-0.0140777027d0*i1) - 0.0092284949d0*i2 - 7.69383d-5*i3
     /  - 0.0008575465d0*i4 - 0.0247761473d0*i5 - 0.0230188689d0*i6
     /  - 0.0286149497d0*i7 - 0.0302855775d0*i8 - 0.0124768477d0*i9
     /  + 0.0001666727d0*i10 + 0.0011894631d0*i11 + 0.001945323d0*i12
     /  - 0.0002322853d0*i13 - 8.1494297476d0*x14 + 1.2112563557d0*x15
     /  - 1.0244950034d0*x16 - 0.0397435234d0*x17 + 0.3761970557d0*x18
     /  + 0.3968598514d0*x19 - 13.9072845464d0*x20)
      f = f
     /  + 0.16d0*sqr(0.0606986501d0*i1 - 0.0027926299d0*i2
     /  + 0.0013158327d0*i3 + 0.0057745025d0*i4 + 0.0538069931d0*i5
     /  + 0.0243317611d0*i6 + 0.0144922688d0*i7 + 0.0094251612d0*i8
     /  - 0.0088671854d0*i9 + 0.0046728622d0*i10 + 0.0030260521d0*i11
     /  + 0.0022528517d0*i12 + 0.0003454089d0*i13
     /  - 11.5441497882d0*x14 + 8.6339417127d0*x15
     /  + 3.0878470794d0*x16 - 0.1539564087d0*x17 + 1.2956126461d0*x18 
     /  - 0.2281345018d0*x19 + 1.2655596015d0*x20 - 1.2363027807d0)
      f = f
     /  + sqr(1.0696475202d0 + 0.108777336d0*i1 + 0.0161504276d0*i2
     /  - 0.0055453119d0*i3 - 0.0029763136d0*i4 + 0.0988637135d0*i5
     /  + 0.0230518007d0*i6 + 0.0141451127d0*i7 + 0.0092098087d0*i8
     /  + 0.0048936457d0*i9 - 0.0003706211d0*i10 - 0.0045875314d0*i11
     /  - 0.0025188137d0*i12 - 5.88752d-5*i13 + 25.3489456455d0*x14
     /  + 2.0315152176d0*x15 + 9.784645976d0*x16 - 0.0858756841d0*x17
     /  + 0.2913560986d0*x18 - 0.0176306534d0*x19
     /  + 0.4233453864d0*x20)
      f = f
     / + sqr(3.7253595801d0
     /  + (-0.075895616d0*i1) - 0.033308761d0*i2 - 0.0076936261d0*i3
     /  - 0.0023553179d0*i4 - 0.073930358d0*i5 - 0.0179037565d0*i6
     /  - 0.0090440794d0*i7 - 0.0078909669d0*i8 - 0.0073447322d0*i9
     /  - 0.0004806952d0*i10 - 0.0070242719d0*i11 - 0.0044029984d0*i12
     /  - 0.0003709394d0*i13 - 5.3086746864d0*x14 + 1.324393925d0*x15
     /  + 9.8395107194d0*x16 + 0.0835697813d0*x17 - 0.559990113d0*x18
     /  + 0.0882573076d0*x19 - 0.8702943348d0*x20)
      f = f
     /  + 0.64d0*sqr(6.0105079707d0 + (-0.0423830939d0*i1)
     /  - 0.0966975232d0*i2 - 0.0001505861d0*i3 + 0.0001386454d0*i4
     /  - 0.0412563344d0*i5 - 0.0035437896d0*i6 - 0.0021618442d0*i7
     /  - 0.0016011984d0*i8 - 0.0531058373d0*i9 - 4.73722d-5*i10
     /  - 0.0002472853d0*i11 - 0.0001874507d0*i12 + 0.0001328949d0*i13
     /  + 42.287929839d0*x14 - 0.4406355124d0*x15 - 0.2701371681d0*x16
     /  + 0.006536567d0*x17 + 0.0072686485d0*x18 - 0.0017404103d0*x19
     /  - 0.0555149205d0*x20)
      f = f 
     /  + 0.64d0*sqr(0.0003120168d0*i2
     /  - 0.0034204879d0*i1 + 0.0014706184d0*i3 + 0.0029278191d0*i4
     /  - 0.0024025221d0*i5 - 0.0003088925d0*i6 - 0.0006351334d0*i7
     /  + 0.0001400931d0*i8 - 0.0010774108d0*i9 + 0.0016335831d0*i10
     /  + 0.0011916896d0*i11 + 0.0006333799d0*i12 + 2.3513d-6*i13
     /  + 1.1667799922d0*x14 - 16.1521973658d0*x15
     /  - 12.7763196896d0*x16 - 0.0029281577d0*x17
     /  - 0.0074349867d0*x18 - 0.0001382348d0*x19 + 0.0310644996d0*x20
     /  - 0.8439928522d0) 
      f = f 
     /  + 0.0001d0*sqr(3.8361669057d0
     /  + (-0.0088650691d0*i1) - 0.027297845d0*i2 + 0.0001942472d0*i3
     /  - 0.0010950468d0*i4 - 0.0233645944d0*i5 - 0.0302422233d0*i6
     /  - 0.0500220544d0*i7 - 0.0565055513d0*i8 - 0.0263114686d0*i9
     /  + 0.0019305253d0*i10 + 0.0021950699d0*i11 + 0.0039928037d0*i12
     /  - 0.000421782d0*i13 - 17.9119743477d0*x14 + 2.1182361999d0*x15
     /  - 2.8424893661d0*x16 + 0.0490655808d0*x17 - 0.3240083732d0*x18
     /  + 0.6257146478d0*x19 - 29.8931414536d0*x20)
      f = f 
     /  + 0.16d0*sqr(0.2296179664d0*i1 - 0.0073360485d0*i2
     /  + 0.0051226739d0*i3 + 0.0217771574d0*i4 + 0.2255766687d0*i5
     /  + 0.1200081359d0*i6 + 0.0766999943d0*i7 + 0.0554677112d0*i8
     /  - 0.0295155687d0*i9 + 0.0175713047d0*i10 + 0.0111367848d0*i11
     /  + 0.0077548382d0*i12 + 0.0014120662d0*i13
     /  - 41.9083056697d0*x14 + 30.9460857583d0*x15
     /  + 11.7762638807d0*x16 - 0.4879869942d0*x17
     /  + 3.0804388516d0*x18 - 1.1873441589d0*x19 + 8.9588206656d0*x20
     /  - 5.5877726318d0) 
      f = f 
     /  + sqr(0.4625093993d0*i1 + 0.0856630954d0*i2
     /  - 0.0073957704d0*i3 - 0.0047973714d0*i4 + 0.4452013205d0*i5
     /  + 0.1152938351d0*i6 + 0.0712927223d0*i7 + 0.0503418969d0*i8
     /  + 0.0169817766d0*i9 - 0.0003043091d0*i10 - 0.0047378871d0*i11
     /  - 0.0021361526d0*i12 - 0.0004760507d0*i13
     /  + 114.5668136229d0*x14 + 0.1243165441d0*x15
     /  + 11.9843516021d0*x16 - 0.3535818823d0*x17
     /  + 1.1284243163d0*x18 - 0.2301405927d0*x19 + 3.0148825878d0*x20
     /  - 0.6688058813d0) 
      f = f 
     /  + sqr(6.5525257248d0 + (-0.1241870163d0*i1)
     /  - 0.0536602159d0*i2 - 0.0141424812d0*i3 - 0.0041277783d0*i4
     /  - 0.1370171489d0*i5 - 0.0491673352d0*i6 - 0.0294082977d0*i7
     /  - 0.0295916798d0*i8 - 0.0103063839d0*i9 - 0.0005794342d0*i10
     /  - 0.0120270278d0*i11 - 0.0070370341d0*i12 - 0.0005822378d0*i13
     /  - 13.3700983917d0*x14 + 3.5575652001d0*x15
     /  + 15.9354642568d0*x16 + 0.0837321797d0*x17
     /  - 0.2374101362d0*x18 + 0.2291951229d0*x19
     /  - 3.1033858692d0*x20) 
      f = f 
     /  + 0.64d0*sqr(14.8037013717d0
     /  + (-0.0927962332d0*i1) - 0.239026571d0*i2 - 0.0003350288d0*i3
     /  + 0.0001707769d0*i4 - 0.0940082779d0*i5 - 0.0090743157d0*i6
     /  - 0.0052075796d0*i7 - 0.0049432367d0*i8 - 0.130291969d0*i9
     /  - 0.000130393d0*i10 - 0.0005243999d0*i11 - 0.0003514537d0*i12
     /  + 0.0002839231d0*i13 + 105.2928430205d0*x14
     /  - 0.5090195889d0*x15 - 0.5559139461d0*x16 - 0.001884071d0*x17
     /  + 0.2028909215d0*x18 - 0.0113540425d0*x19
     /  - 0.1161260005d0*x20) 
      f = f 
     /  + 0.64d0*sqr((-0.0102954229d0*i1)
     /  - 0.006122584d0*i2 + 0.0012521468d0*i3 + 0.0026005078d0*i4
     /  - 0.0084341659d0*i5 - 0.0001608865d0*i6 - 0.0001650072d0*i7
     /  + 0.0011062956d0*i8 - 0.0054116563d0*i9 + 0.0012844339d0*i10
     /  + 0.0008302662d0*i11 + 0.0003743032d0*i12 + 8.2607d-6*i13
     /  + 4.2749976192d0*x14 - 13.9639192437d0*x15
     /  - 10.8648952369d0*x16 + 0.0046091996d0*x17
     /  - 0.0617617291d0*x18 + 0.0109049916d0*x19 - 0.024829922d0*x20
     /  - 0.2711632143d0) + 0.0001d0*sqr(4.7368865d0
     /  + (-0.0179521837d0*i1) - 0.0324999755d0*i2 + 0.0001877057d0*i3
     /  - 0.0014861555d0*i4 - 0.0207352794d0*i5 - 0.0283829651d0*i6
     /  - 0.0645153989d0*i7 - 0.0603615854d0*i8 - 0.0455161822d0*i9
     /  + 0.0011104169d0*i10 + 0.0014246164d0*i11 + 0.004399654d0*i12
     /  - 0.0025487765d0*i13 - 28.5532641368d0*x14
     /  + 3.7291549175d0*x15 - 5.1441052974d0*x16 + 0.1161311806d0*x17
     /  - 1.4551474166d0*x18 + 0.7094975709d0*x19
     /  - 43.6065360868d0*x20) 
      f = f 
     /  + 0.16d0*sqr(0.4703706128d0*i1
     /  + 0.0095015391d0*i2 + 0.0107788871d0*i3 + 0.0442574417d0*i4
     /  + 0.5081887828d0*i5 + 0.3135069575d0*i6 + 0.2159907851d0*i7
     /  + 0.1806946774d0*i8 - 0.0464209789d0*i9 + 0.0344331825d0*i10
     /  + 0.0221598537d0*i11 + 0.0139587185d0*i12 + 0.0031293169d0*i13
     /  - 74.0327234359d0*x14 + 59.0811380719d0*x15
     /  + 22.6183807248d0*x16 - 0.8777959059d0*x17
     /  + 3.7972647124d0*x18 - 3.4732150542d0*x19 
     /  + 35.9883905408d0*x20 - 14.6237193582d0) 
     /  + sqr(1.1409846015d0*i1 + 0.2174097748d0*i2
     /  - 0.0102121922d0*i3 - 0.0076844543d0*i4 + 1.1491043521d0*i5
     /  + 0.3409735732d0*i6 + 0.2159827038d0*i7 + 0.1720041292d0*i8
     /  + 0.0317109219d0*i9 - 0.0001185329d0*i10 - 0.0046123931d0*i11
     /  - 0.001551773d0*i12 - 0.0011383077d0*i13
     /  + 299.4383227892d0*x14 - 7.4791629824d0*x15
     /  + 15.0249048147d0*x16 - 0.7189464072d0*x17
     /  + 1.1858655471d0*x18 - 0.8355843028d0*x19
     /  + 11.3520280307d0*x20 - 4.742827527d0) 
      f = f 
     /  + sqr(8.7874647257d0
     /  + (-0.1535764498d0*i1) - 0.0636508743d0*i2 - 0.0190249178d0*i3
     /  - 0.0046863862d0*i4 - 0.1835500731d0*i5 - 0.0911962696d0*i6
     /  - 0.0644433402d0*i7 - 0.07637679d0*i8 - 0.0109485707d0*i9
     /  + 0.0001440146d0*i10 - 0.0146320903d0*i11 - 0.0080348173d0*i12
     /  - 0.0008824001d0*i13 - 25.642445996d0*x14 + 6.1510841152d0*x15
     /  + 17.3139236759d0*x16 + 0.0327173388d0*x17
     /  + 0.3041107825d0*x18 + 0.4167065057d0*x19 - 8.389949878d0*x20) 
     /  + 0.64d0*sqr(28.7139260236d0 + (-0.1528363362d0*i1)
     /  - 0.4639595922d0*i2 - 0.0005899734d0*i3 - 0.0001363739d0*i4
     /  - 0.1574288315d0*i5 - 0.014794976d0*i6 - 0.007899692d0*i7
     /  - 0.010742359d0*i8 - 0.251023988d0*i9 - 0.000352116d0*i10
     /  - 0.0007996019d0*i11 - 0.0005210174d0*i12 + 0.0004703318d0*i13
     /  + 210.7366501966d0*x14 - 0.4820761867d0*x15
     /  - 1.5088768249d0*x16 - 0.0334770967d0*x17 + 0.57319738d0*x18
     /  - 0.0590174758d0*x19 + 0.0028596741d0*x20)
      f = f 
     /  + 0.64d0*sqr(0.3457787122d0 + (-0.0161705598d0*i1)
     /  - 0.0124112057d0*i2 + 0.0009498183d0*i3 + 0.0019433781d0*i4
     /  - 0.0165157634d0*i5 - 0.0019802806d0*i6 - 0.0001641793d0*i7
     /  + 0.0017883958d0*i8 - 0.0097508262d0*i9 + 0.0006660726d0*i10
     /  + 0.0003906614d0*i11 + 0.0001670015d0*i12 - 9.8812d-6*i13
     /  + 5.6620080256d0*x14 - 10.7222556951d0*x15
     /  - 8.0483203578d0*x16 + 0.0160387494d0*x17 - 0.1211418715d0*x18
     /  + 0.0539193344d0*x19 - 0.6024547036d0*x20)
     /  + 0.16d0*sqr(0.7501496025d0*i1 + 0.091631133d0*i2
     /  + 0.0189532866d0*i3 + 0.071209475d0*i4 + 0.8691242467d0*i5
     /  + 0.5911179615d0*i6 + 0.440636915d0*i7 + 0.4064826358d0*i8
     /  - 0.0227243008d0*i9 + 0.0529781278d0*i10 + 0.0356056482d0*i11
     /  + 0.0192254774d0*i12 + 0.0085772439d0*i13 - 56.342960691d0*x14
     /  + 88.7586686673d0*x15 + 31.5826614981d0*x16
     /  - 1.3557460277d0*x17 + 3.9043216717d0*x18 - 8.0614504732d0*x19
     /  + 122.9145364338d0*x20 - 30.9984760322d0)
      f = f 
     /  + sqr(2.2433003606d0*i1 + 0.3965325948d0*i2
     /  - 0.0133497179d0*i3 - 0.011748375d0*i4 + 2.312159801d0*i5
     /  + 0.7536961363d0*i6 + 0.4878761411d0*i7 + 0.4391322777d0*i8
     /  + 0.0172795967d0*i9 + 0.0003869474d0*i10 - 0.0048174588d0*i11
     /  - 0.0003265422d0*i12 - 0.0019476982d0*i13
     /  + 604.6261109412d0*x14 - 31.8275450762d0*x15
     /  + 22.3021114905d0*x16 - 1.1078810785d0*x17
     /  - 0.0513668537d0*x18 - 1.9954801737d0*x19
     /  + 28.0530826925d0*x20 - 11.3598350491d0) + sqr(12.1379962226d0
     /  + (-0.2277017049d0*i1) - 0.091141468d0*i2 - 0.0227388896d0*i3
     /  - 0.0030743255d0*i4 - 0.2616367427d0*i5 - 0.1419935836d0*i6
     /  - 0.1154940945d0*i7 - 0.1507188696d0*i8 - 0.0254442327d0*i9
     /  + 0.001796488d0*i10 - 0.0164620351d0*i11 - 0.0079883882d0*i12
     /  - 0.0014234879d0*i13 - 54.2871786886d0*x14
     /  + 1.6486577747d0*x15 + 9.9342805153d0*x16 - 0.0494461107d0*x17
     /  + 1.59320066d0*x18 + 0.6872677378d0*x19 - 21.0483328068d0*x20)
      f = f 
     /  + 0.64d0*sqr(49.277241262d0 + (-0.2163075465d0*i1)
     /  - 0.7938092282d0*i2 - 0.0010986197d0*i3 - 0.0015188105d0*i4
     /  - 0.2196119607d0*i5 - 0.0134240514d0*i6 - 0.0076745243d0*i7
     /  - 0.0146132646d0*i8 - 0.4267100558d0*i9 - 0.0010060279d0*i10
     /  - 0.0013702202d0*i11 - 0.0005229596d0*i12+ 0.0008915738d0*i13
     /  + 378.332229536d0*x14 - 2.0382852627d0*x15
     /  - 3.8306759867d0*x16 - 0.0638064923d0*x17 + 0.8796449423d0*x18
     /  - 0.1901924983d0*x19 + 0.0196078677d0*x20)
     /  + 0.64d0*sqr(0.0056296892d0*i2 - 0.0130312793d0*i1
     /  + 0.0003729619d0*i3 + 0.0005646842d0*i4 - 0.0187752972d0*i5
     /  - 0.0070031283d0*i6 - 0.0022324933d0*i7 + 0.0010766025d0*i8
     /  + 0.0013045532d0*i9 - 0.0005210538d0*i10 - 0.0001687226d0*i11
     /  + 0.000238775d0*i12 - 0.0002689523d0*i13 - 7.4785361452d0*x14
     /  - 6.3098285835d0*x15 - 3.0022136691d0*x16 + 0.0557080781d0*x17
     /  - 0.4336150459d0*x18 + 0.2358490882d0*x19 - 5.3316404952d0*x20
     /  - 0.3252071332d0) 
      f = f 
     /  + sqr(6.1126533342d0 + 0.0063571711d0*i1
     /  - 0.0210288641d0*i2 - 0.0192924286d0*i3 - 0.0090860848d0*i4
     /  + 0.0040562184d0*i5 + 0.0046781148d0*i6 + 0.003160636d0*i7
     /  + 0.0022890179d0*i8 + 0.0018592833d0*i9 - 0.0015634745d0*i10
     /  - 0.0179263104d0*i11 - 0.0110489292d0*i12 + 0.0003235049d0*i13
     /  + 1.3652462464d0*x14 + 7.9428825848d0*x15
     /  + 34.7388067135d0*x16 + 0.0823525777d0*x17
     /  - 1.6195043446d0*x18 + 0.0909955211d0*x19
     /  - 0.0850371218d0*x20) + 0.64d0*sqr(0.0067978328d0*i2
     /  - 0.0010534483d0*i1 + 0.003573349d0*i3 + 0.0063177541d0*i4
     /  - 0.0011795262d0*i5 - 0.0010523756d0*i6 - 0.0017005199d0*i7
     /  - 0.0002107428d0*i8 + 0.0015737049d0*i9 + 0.0037140954d0*i10
     /  + 0.003230842d0*i11 + 0.0020336834d0*i12 + 2.367d-6*i13
     /  - 0.548040633d0*x14 - 35.4912339934d0*x15
     /  - 29.5664987967d0*x16 - 0.0180559302d0*x17
     /  + 0.1599995255d0*x18 - 0.0030419667d0*x19 + 0.0044670753d0*x20
     /  - 2.3683307173d0)
            f = f 
     / + 0.0001d0*sqr(7.6499767981d0
     /  + (-0.0571502154d0*i1) - 0.0457308831d0*i2 - 0.0018548561d0*i3
     /  - 0.0034541498d0*i4 - 0.111543805d0*i5 - 0.1055356012d0*i6
     /  - 0.0898181821d0*i7 - 0.1133619848d0*i8 - 0.0222630329d0*i9
     /  + 0.000501825d0*i10 + 0.0048081889d0*i11 + 0.0066599177d0*i12
     /  + 0.0001004665d0*i13 - 24.1502370784d0*x14 + 3.590505155d0*x15
     /  + 7.3127021637d0*x16 - 0.3184833839d0*x17 + 4.5843524774d0*x18
     /  + 1.6594965528d0*x19 - 39.2593229915d0*x20)
     /  + 0.16d0*sqr(0.1251859207d0*i1 - 0.0077038523d0*i2
     /  + 0.0022670292d0*i3 + 0.0119125151d0*i4 + 0.1032640914d0*i5
     /  + 0.0434589067d0*i6 + 0.0245384166d0*i7 + 0.0141492223d0*i8
     /  - 0.0212842524d0*i9 + 0.0097511812d0*i10 + 0.0071436678d0*i11
     /  + 0.006348892d0*i12 + 0.0012026933d0*i13 - 26.037191031d0*x14
     /  + 18.9235979398d0*x15 + 6.7656627646d0*x16
     /  - 0.4166604188d0*x17 + 4.1351334135d0*x18 - 0.3816674126d0*x19
     /  + 1.1769320486d0*x20 - 2.5260390338d0) 
      f = f 
     /  + sqr(6.4101559959d0
     /  + 0.1053781335d0*i1 - 0.007068748d0*i2 - 0.0215428885d0*i3
     /  - 0.0109009132d0*i4 + 0.0860906177d0*i5 + 0.018078682d0*i6
     /  + 0.0110470953d0*i7 + 0.0058774703d0*i8 + 0.0056105795d0*i9
     /  - 0.0017546263d0*i10 - 0.0187391468d0*i11 - 0.010328613d0*i12
     /  + 0.0006031714d0*i13 + 24.5823703006d0*x14
     /  + 9.3387785302d0*x15 + 38.5763378184d0*x16
     /  - 0.0594883815d0*x17 - 0.2623967618d0*x18 + 0.1019703287d0*x19
     /  - 0.11159399d0*x20) + sqr(8.0717357197d0
     /  + (-0.1589734385d0*i1) - 0.0692163791d0*i2 - 0.0171613374d0*i3
     /  - 0.0050520949d0*i4 - 0.1518107465d0*i5 - 0.0331939768d0*i6
     /  - 0.0156598481d0*i7 - 0.0132225385d0*i8 - 0.0150186389d0*i9
     /  - 0.0011871055d0*i10 - 0.0169462197d0*i11 - 0.011646797d0*i12
     /  - 0.0011891504d0*i13 - 10.8339562621d0*x14
     /  + 2.3920432845d0*x15 + 23.8770409229d0*x16
     /  + 0.2047719702d0*x17 - 1.6516894952d0*x18 + 0.1550154879d0*x19
     /  - 1.3059803643d0*x20)
      f = f 
     /  + 0.64d0*sqr(5.8701212763d0
     /  + (-0.0457735722d0*i1) - 0.0939732835d0*i2 - 0.0004780001d0*i3
     /  + 0.0004872865d0*i4 - 0.0434579543d0*i5 - 0.0033195608d0*i6
     /  - 0.0019177924d0*i7 - 0.0012353053d0*i8 - 0.0520762291d0*i9
     /  + 9.71737d-5*i10 - 0.0008319018d0*i11 - 0.0008243862d0*i12
     /  + 5.97876d-5*i13 + 40.4729903906d0*x14 - 2.6146532755d0*x15
     /  - 0.58046538d0*x16 + 0.0140750568d0*x17 - 0.1015166663d0*x18
     /  + 0.0010341359d0*x19 - 0.030965449d0*x20)
     /  + 0.64d0*sqr(0.0019101712d0*i2 - 0.0068584285d0*i1
     /  + 0.0033262354d0*i3 + 0.0062132167d0*i4 - 0.0044003564d0*i5
     /  - 0.0005850161d0*i6 - 0.0014089061d0*i7 + 0.0001755788d0*i8
     /  - 0.0017169146d0*i9 + 0.0035203071d0*i10 + 0.0028735982d0*i11
     /  + 0.0016086374d0*i12 - 3.27645d-5*i13 + 2.4205682873d0*x14
     /  - 33.7265709729d0*x15 - 27.9573268564d0*x16
     /  - 0.0053157955d0*x17 - 0.0159966559d0*x18 - 0.0026557276d0*x19
     /  + 0.0318094448d0*x20 - 1.9000693551d0)
      f = f 
     /  + 0.0001d0*sqr(15.4460966615d0 + (-0.1022940502d0*i1)
     /  - 0.1105460971d0*i2 - 0.0037780327d0*i3 - 0.0055846863d0*i4
     /  - 0.1895478298d0*i5 - 0.1950630715d0*i6 - 0.1616726126d0*i7
     /  - 0.22794103d0*i8 - 0.0711848201d0*i9 + 0.0028432697d0*i10
     /  + 0.0086250769d0*i11 + 0.0114552524d0*i12 - 0.0019720262d0*i13
     /  - 61.3668479856d0*x14 + 8.9259752968d0*x15
     /  + 14.4396522548d0*x16 - 0.2530977597d0*x17
     /  + 4.2680343521d0*x18 + 3.2764060344d0*x19
     /  - 85.9662948622d0*x20) + 0.16d0*sqr(0.4568808671d0*i1
     /  - 0.0279886225d0*i2 + 0.0086305745d0*i3 + 0.0445209448d0*i4
     /  + 0.4240071578d0*i5 + 0.209657602d0*i6 + 0.1280332449d0*i7
     /  + 0.0789279496d0*i8 - 0.0732428132d0*i9 + 0.0360714267d0*i10
     /  + 0.0265566502d0*i11 + 0.0214024511d0*i12 + 0.0042041311d0*i13
     /  - 94.9931943965d0*x14 + 67.8238048618d0*x15
     /  + 25.5020193615d0*x16 - 1.2641528796d0*x17
     /  + 8.6854605662d0*x18 - 1.9537231543d0*x19 + 9.2121201535d0*x20
     /  - 10.2591752001d0) 
      f = f
     /  + sqr(7.2545035424d0 + 0.4349505737d0*i1
     /  + 0.0387362456d0*i2 - 0.0281402193d0*i3 - 0.0159562915d0*i4
     /  + 0.3872348952d0*i5 + 0.0757452989d0*i6 + 0.042778296d0*i7
     /  + 0.0187323889d0*i8 + 0.0154930433d0*i9 - 0.0020027406d0*i10
     /  - 0.0200780741d0*i11 - 0.0083595959d0*i12 + 0.0011075045d0*i13
     /  + 106.9691650219d0*x14 + 12.3298154856d0*x15
     /  + 47.7959005982d0*x16 - 0.3806894476d0*x17
     /  + 1.3003567452d0*x18 + 0.097041998d0*x19 - 0.4923380619d0*x20)
     /  + sqr(13.9503196684d0 + (-0.2559219795d0*i1)
     /  - 0.1105206902d0*i2 - 0.0313597509d0*i3 - 0.0095446568d0*i4
     /  - 0.2838067687d0*i5 - 0.0922749482d0*i6 - 0.0499509638d0*i7
     /  - 0.0468580924d0*i8 - 0.0204074307d0*i9 - 0.0020211226d0*i10
     /  - 0.0292784894d0*i11 - 0.0179578576d0*i12 - 0.0014506444d0*i13
     /  - 27.2483068958d0*x14 + 6.8357802598d0*x15
     /  + 39.7335986547d0*x16 + 0.1837391147d0*x17
     /  - 0.6774943126d0*x18 + 0.4024494055d0*x19
     /  - 4.4688504034d0*x20) 
      f = f 
     /  + 0.64d0*sqr(14.3917445971d0
     /  + (-0.1005342031d0*i1) - 0.2305746472d0*i2 - 0.0011658462d0*i3
     /  + 0.0007966507d0*i4 - 0.1022660917d0*i5 - 0.008999162d0*i6
     /  - 0.0042244744d0*i7 - 0.0032236301d0*i8 - 0.1272220489d0*i9
     /  + 0.000114597d0*i10 - 0.001862252d0*i11 - 0.001451677d0*i12
     /  + 0.0002189005d0*i13 + 99.9026997721d0*x14
     /  - 4.2794508863d0*x15 - 0.289880094d0*x16 + 0.0048704372d0*x17
     /  + 0.1224131652d0*x18 + 0.0060441225d0*x19
     /  - 0.1593517642d0*x20) + 0.64d0*sqr((-0.0222018418d0*i1)
     /  - 0.0116935045d0*i2 + 0.0028226664d0*i3 + 0.005730231d0*i4
     /  - 0.0167841756d0*i5 - 0.000142195d0*i6 - 0.0008539001d0*i7
     /  + 0.0016396311d0*i8 - 0.011024342d0*i9 + 0.0029012839d0*i10
     /  + 0.0019442541d0*i11 + 0.0007455887d0*i12 - 8.22757d-5*i13
     /  + 8.9108175175d0*x14 - 29.2610239684d0*x15
     /  - 24.0324296338d0*x16 + 0.0145771681d0*x17
     /  - 0.1432295058d0*x18 + 0.0127355322d0*x19 + 0.0028635772d0*x20
     /  - 0.6911236333d0) 
      f = f 
     /  + 0.0001d0*sqr(17.2005159204d0
     /  + (-0.0910706703d0*i1) - 0.1353551992d0*i2 - 0.0045604449d0*i3
     /  - 0.0058886233d0*i4 - 0.1544772411d0*i5 - 0.1777468247d0*i6
     /  - 0.1643967385d0*i7 - 0.2447547979d0*i8 - 0.0695046741d0*i9
     /  + 0.0074175259d0*i10 + 0.0095563648d0*i11 + 0.0096650697d0*i12
     /  - 0.0036650179d0*i13 - 83.5475857469d0*x14
     /  + 17.5444503235d0*x15 + 24.0403945324d0*x16
     /  - 0.1697469511d0*x17 + 6.6072373388d0*x18 + 3.702054964d0*x19
     /  - 115.1114277859d0*x20) + 0.16d0*sqr(0.9236280974d0*i1
     /  - 0.0183246537d0*i2 + 0.0189502894d0*i3 + 0.0897048431d0*i4
     /  + 0.9719412505d0*i5 + 0.5687799133d0*i6 + 0.3652683828d0*i7
     /  + 0.2667249028d0*i8 - 0.1198458943d0*i9 + 0.0719303519d0*i10
     /  + 0.054459644d0*i11 + 0.0381337454d0*i12 + 0.0084372917d0*i13
     /  - 172.3571556156d0*x14 + 128.6111684769d0*x15
     /  + 47.5980282546d0*x16 - 2.0864881272d0*x17
     /  + 10.0774182155d0*x18 - 5.8968747535d0*x19
     /  + 41.6695373549d0*x20 - 25.6825534808d0)
      f = f 
     /  + sqr(8.6404612843d0 + 1.0470538624d0*i1 + 0.1265399768d0*i2
     /  - 0.0382708217d0*i3 - 0.0229868843d0*i4 + 1.0127245011d0*i5
     /  + 0.2264519238d0*i6 + 0.1198727849d0*i7 + 0.0496850607d0*i8
     /  + 0.0256657433d0*i9 - 0.001380951d0*i10 - 0.0202111208d0*i11
     /  - 0.0061255822d0*i12 + 0.0008857942d0*i13
     /  + 279.6115378044d0*x14 + 12.6478515168d0*x15
     /  + 58.2338999026d0*x16 - 0.7407788996d0*x17
     /  + 1.6954162324d0*x18 - 0.0281070188d0*x19
     /  - 2.7233199693d0*x20) + sqr(17.9484831771d0
     /  + (-0.2957647998d0*i1) - 0.1282769511d0*i2 - 0.0424456722d0*i3
     /  - 0.012308059d0*i4 - 0.3701941021d0*i5 - 0.17078673d0*i6
     /  - 0.1029835609d0*i7 - 0.1196187747d0*i8 - 0.0163783684d0*i9
     /  - 0.0018793693d0*i10 - 0.0354804279d0*i11 - 0.0194724169d0*i12
     /  - 0.0013696531d0*i13 - 51.6252785538d0*x14
     /  + 13.0257273562d0*x15 + 45.5497603331d0*x16
     /  + 0.0271465582d0*x17 + 0.4765352422d0*x18 + 0.7456509784d0*x19
     /  - 11.702389109d0*x20)
      f = f 
     /  + 0.64d0*sqr(27.6492094586d0
     /  + (-0.16206578d0*i1) - 0.4430814744d0*i2 - 0.0022016388d0*i3
     /  - 9.27478d-5*i4 - 0.1743256573d0*i5 - 0.0180197723d0*i6
     /  - 0.0065277971d0*i7 - 0.0079737986d0*i8 - 0.2433891135d0*i9
     /  - 0.0006366382d0*i10 - 0.0029943458d0*i11 - 0.0018392849d0*i12
     /  + 0.0004019119d0*i13 + 191.7962056686d0*x14
     /  - 5.1846674433d0*x15 + 1.2439454336d0*x16 - 0.0218678855d0*x17
     /  + 0.3849436864d0*x18 + 0.0262492576d0*x19
     /  - 0.9654915869d0*x20) + 0.64d0*sqr(0.7313866655d0
     /  + (-0.0369626284d0*i1) - 0.0279440208d0*i2 + 0.002152423d0*i3
     /  + 0.0049481078d0*i4 - 0.0359031491d0*i5 - 0.0031300384d0*i6
     /  - 0.0011206133d0*i7 + 0.0032861258d0*i8 - 0.0218768904d0*i9
     /  + 0.0020226047d0*i10 + 0.0007690433d0*i11 + 0.0001033874d0*i12
     /  - 0.0001029558d0*i13 + 13.8500336434d0*x14
     /  - 22.6807804628d0*x15 - 18.3863230016d0*x16
     /  + 0.0302860152d0*x17 - 0.1454486567d0*x18 + 0.0762093249d0*x19
     /  - 0.5480081939d0*x20) 
      f = f 
     /  + 0.16d0*sqr(1.481390691d0*i1
     /  + 0.0899334362d0*i2 + 0.0376647593d0*i3 + 0.1404303474d0*i4
     /  + 1.7046542178d0*i5 + 1.1229862589d0*i6 + 0.7315242919d0*i7
     /  + 0.6418588879d0*i8 - 0.1588453132d0*i9 + 0.113117524d0*i10
     /  + 0.0863865555d0*i11 + 0.0566125966d0*i12 + 0.0156276651d0*i13
     /  - 200.1847266898d0*x14 + 184.8153459101d0*x15
     /  + 57.8684929964d0*x16 - 2.7792085501d0*x17
     /  + 9.0767134995d0*x18 - 13.942861566d0*x19
     /  + 127.0169941145d0*x20 - 52.5425602964d0)
     /  + sqr(11.2591544766d0 + 1.9929618598d0*i1 + 0.2363240124d0*i2
     /  - 0.0511937674d0*i3 - 0.0293329322d0*i4 + 2.0329311329d0*i5
     /  + 0.5245706282d0*i6 + 0.2629618577d0*i7 + 0.126212306d0*i8
     /  - 0.0019258114d0*i9 + 0.0021679191d0*i10 - 0.0199382345d0*i11
     /  - 0.0033997016d0*i12 - 0.0002802765d0*i13
     /  + 557.8529479327d0*x14 + 3.0143555386d0*x15
     /  + 65.3736501251d0*x16 - 1.0800203847d0*x17
     /  + 2.8399031977d0*x18 - 0.2294386604d0*x19
     /  - 14.7469110313d0*x20) 
      f = f 
     /  + sqr(21.6114276014d0
     /  + (-0.3794268138d0*i1) - 0.1359049851d0*i2 - 0.0522607329d0*i3
     /  - 0.0124067534d0*i4 - 0.4717160532d0*i5 - 0.2545973282d0*i6
     /  - 0.1686685879d0*i7 - 0.2403802808d0*i8 + 0.0011373805d0*i9
     /  - 0.0008573392d0*i10 - 0.0375338624d0*i11 - 0.0192629492d0*i12
     /  - 0.0015633624d0*i13 - 94.5375544285d0*x14
     /  + 18.2250544427d0*x15 + 38.0675842791d0*x16
     /  - 0.2238422448d0*x17 + 2.001336626d0*x18 + 1.0138181445d0*x19
     /  - 23.1438722685d0*x20) + 0.64d0*sqr(46.7782203241d0
     /  + (-0.2223546814d0*i1) - 0.7395971394d0*i2 - 0.0040475573d0*i3
     /  - 0.003779285d0*i4 - 0.2467887221d0*i5 - 0.0306073217d0*i6
     /  - 0.0079486792d0*i7 - 0.0189593819d0*i8 - 0.4011393907d0*i9
     /  - 0.0031966331d0*i10 - 0.0042381208d0*i11 - 0.0023012821d0*i12
     /  + 0.0002202888d0*i13 + 327.6551151698d0*x14
     /  - 4.6492502074d0*x15 + 6.6637844433d0*x16 - 0.0500060739d0*x17
     /  + 0.6775119117d0*x18 + 0.1602738202d0*x19
     /  - 6.4757521432d0*x20) 
      f = f 
     /  + 0.64d0*sqr(0.9116644463d0
     /  + (-0.0422053363d0*i1) - 0.0218370644d0*i2 + 0.0013117376d0*i3
     /  + 0.0039100868d0*i4 - 0.0513592002d0*i5 - 0.013366308d0*i6
     /  - 0.0041364668d0*i7 + 0.0005264153d0*i8 - 0.0174573785d0*i9
     /  + 0.0007329203d0*i10 - 0.0001582492d0*i11 - 0.0002836937d0*i12
     /  - 0.000494575d0*i13 + 4.7797259826d0*x14 - 14.3122665377d0*x15
     /  - 10.9646223177d0*x16 + 0.043573141d0*x17 - 0.3045615131d0*x18
     /  + 0.279954818d0*x19 - 3.3767931789d0*x20)
      f = f
     /  + sqr(13.8496391201d0 + 0.0134893339d0*i1 - 0.0546241416d0*i2
     /  - 0.0421969775d0*i3 - 0.0189935256d0*i4 + 0.0086879414d0*i5
     /  + 0.0095671335d0*i6 + 0.0062541874d0*i7 + 0.0042914317d0*i8
     /  + 0.0014679428d0*i9 - 0.003326583d0*i10 - 0.0404226913d0*i11
     /  - 0.0261580188d0*i12 + 0.0009760295d0*i13 + 3.5498897321d0*x14
     /  + 16.1561586043d0*x15+ 76.1755770646d0*x16
     /  + 0.2165709541d0*x17 - 4.4161081307d0*x18 + 0.183857392d0*x19
     /  + 0.3055886284d0*x20) 
      f = f 
     /  + 0.64d0*sqr(0.0138916297d0*i2
     /  - 0.0016112926d0*i1 + 0.0064871233d0*i3 + 0.0100484335d0*i4
     /  - 0.0020517997d0*i5 - 0.001518082d0*i6 - 0.0026530534d0*i7
     /  - 0.0001671183d0*i8 + 0.0033008582d0*i9 + 0.0060350783d0*i10
     /  + 0.0062323261d0*i11 + 0.0044103683d0*i12 + 1.34992d-5*i13
     /  - 1.055738354d0*x14 - 56.937097335d0*x15 - 50.3080442297d0*x16
     /  - 0.0403968632d0*x17 + 0.4781256075d0*x18 - 0.004820015d0*x19
     /  - 0.0882113129d0*x20 - 4.1276099743d0)
      f = f
     /  + 0.0001d0*sqr(10.7794007035d0 + (-0.1027500435d0*i1)
     /  - 0.0437077268d0*i2 - 0.0042608613d0*i3 - 0.0054005871d0*i4
     /  - 0.2217325771d0*i5 - 0.2036834341d0*i6 - 0.1536688756d0*i7
     /  - 0.182917313d0*i8 - 0.0092610244d0*i9 - 0.0028718144d0*i10
     /  + 0.008765582d0*i11 + 0.0154612115d0*i12 + 0.002949574d0*i13
     /  - 41.3982537441d0*x14 - 0.4939416253d0*x15
     /  + 13.7491137587d0*x16 - 0.9135159317d0*x17
     /  + 9.7126592931d0*x18 + 2.8528519857d0*x19
     /  - 42.524194597d0*x20)
      f = f 
     /  + 0.16d0*sqr(0.1958722411d0*i1
     /  - 0.0118265109d0*i2 + 0.0023904676d0*i3 + 0.018778841d0*i4
     /  + 0.1434642091d0*i5 + 0.0535288547d0*i6 + 0.0294513128d0*i7
     /  + 0.0136110673d0*i8 - 0.0294248695d0*i9 + 0.0159294386d0*i10
     /  + 0.0118730276d0*i11 + 0.0138666684d0*i12 + 0.0033611513d0*i13
     /  - 44.6850648185d0*x14 + 30.1445830407d0*x15
     /  + 12.9990890991d0*x16 - 0.9499115318d0*x17
     /  + 11.4382579566d0*x18 - 0.4170309667d0*x19
     /  + 0.3784044555d0*x20 - 4.2220465925d0) + sqr(15.175268689d0
     /  + 0.1002145531d0*i1 - 0.0495334512d0*i2 - 0.046919432d0*i3
     /  - 0.02267109d0*i4 + 0.0675430045d0*i5 + 0.0130802886d0*i6
     /  + 0.0084060715d0*i7 + 0.0032060051d0*i8 + 0.0052885861d0*i9
     /  - 0.0039272147d0*i10 - 0.0429347295d0*i11 - 0.024658985d0*i12
     /  + 0.0020304879d0*i13 + 24.318483031d0*x14
     /  + 19.9554555304d0*x15 + 86.0701095092d0*x16
     /  - 0.0079381579d0*x17 - 1.2317154197d0*x18 + 0.2597808541d0*x19
     /  + 0.046547833d0*x20)
      f = f 
     /  + sqr(13.6543378053d0
     /  + (-0.2567697759d0*i1) - 0.1110211715d0*i2 - 0.029891517d0*i3
     /  - 0.0080014448d0*i4 - 0.236451453d0*i5 - 0.0441803185d0*i6
     /  - 0.0189725038d0*i7 - 0.0152706799d0*i8 - 0.0242306374d0*i9
     /  - 0.0021581627d0*i10 - 0.032158306d0*i11 - 0.02507444d0*i12
     /  - 0.0031898028d0*i13 - 16.8998454606d0*x14
     /  + 2.6515703721d0*x15 + 44.5383700882d0*x16
     /  + 0.4270802076d0*x17 - 4.2406883369d0*x18 + 0.1817822414d0*x19
     /  - 1.2990884338d0*x20) + 0.64d0*sqr(5.6877270607d0
     /  + (-0.0509316739d0*i1) - 0.0899873302d0*i2 - 0.0010672511d0*i3
     /  + 0.0012269042d0*i4 - 0.0460810164d0*i5 - 0.0030215419d0*i6
     /  - 0.0017089579d0*i7 - 0.0008960043d0*i8 - 0.0503824405d0*i9
     /  + 0.0004481339d0*i10 - 0.0017704342d0*i11 - 0.0020844447d0*i12
     /  - 0.0001547897d0*i13 + 38.4978917657d0*x14
     /  - 5.7154043223d0*x15 - 1.3118401345d0*x16 + 0.0327195254d0*x17
     /  - 0.3675197017d0*x18 + 0.0006192276d0*x19
     /  + 0.0084917392d0*x20) 
      f = f 
     /  + 0.64d0*sqr(0.0061211388d0*i2
     /  - 0.0098272689d0*i1 + 0.0060406869d0*i3 + 0.0099167954d0*i4
     /  - 0.0055976062d0*i5 - 0.0007878593d0*i6 - 0.0024627591d0*i7
     /  + 0.0001091634d0*i8 - 0.0019063383d0*i9 + 0.0057189921d0*i10
     /  + 0.0056093079d0*i11 + 0.0034173555d0*i12 - 0.0001406113d0*i13
     /  + 3.0552737446d0*x14 - 54.2499870768d0*x15
     /  - 47.9264759598d0*x16 - 0.0082705764d0*x17
     /  - 0.0605154328d0*x18 - 0.0067698022d0*x19 - 0.0545052962d0*x20
     /  - 3.3913450716d0) 
      f = f
     /  + 0.0001d0*sqr(18.7892368515d0
     /  + (-0.1538926793d0*i1) - 0.0871062409d0*i2 - 0.0097767387d0*i3
     /  - 0.0055333772d0*i4 - 0.3200579008d0*i5 - 0.3485288775d0*i6
     /  - 0.2583428965d0*i7 - 0.351496112d0*i8 - 0.000511772d0*i9
     /  - 0.0028518468d0*i10 + 0.0187496157d0*i11 + 0.0251862229d0*i12
     /  + 0.0032716782d0*i13 - 109.3000284295d0*x14
     /  + 2.1450969802d0*x15 + 31.7825915933d0*x16
     /  - 0.9893136845d0*x17 + 5.2409083648d0*x18 + 5.3829884111d0*x19
     /  - 87.3346786956d0*x20) 
      f = f 
     /  + 0.16d0*sqr(0.707257822d0*i1
     /  - 0.0615161527d0*i2 + 0.0093164155d0*i3 + 0.068536869d0*i4
     /  + 0.596657314d0*i5 + 0.2590793017d0*i6 + 0.1509095992d0*i7
     /  + 0.068322962d0*i8 - 0.1186944602d0*i9 + 0.0555551994d0*i10
     /  + 0.0479939209d0*i11 + 0.0482973425d0*i12 + 0.0128017544d0*i13
     /  - 168.9033426052d0*x14 + 108.3885243362d0*x15
     /  + 48.348717818d0*x16 - 2.7970407623d0*x17
     /  + 22.0796840577d0*x18 - 2.1451176404d0*x19
     /  + 3.7963629845d0*x20 - 15.0414837509d0) + sqr(19.4397559466d0
     /  + 0.4019882894d0*i1 - 0.0372389175d0*i2 - 0.0603438751d0*i3
     /  - 0.0336688256d0*i4 + 0.2996694143d0*i5 + 0.0272621038d0*i6
     /  + 0.0138810181d0*i7 - 0.0078788208d0*i8 + 0.0131939321d0*i9
     /  - 0.00573995d0*i10 - 0.0476935894d0*i11 - 0.0194312061d0*i12
     /  + 0.0048998423d0*i13 + 94.1107720449d0*x14
     /  + 28.998307874d0*x15 + 109.829171541d0*x16
     /  - 0.4498027437d0*x17 + 1.8390377019d0*x18 + 0.4832341831d0*x19
     /  - 1.7919794167d0*x20) 
      f = f 
     /  + sqr(23.132764885d0
     /  + (-0.4092337351d0*i1) - 0.1752815817d0*i2 - 0.0542592094d0*i3
     /  - 0.0161774929d0*i4 - 0.4514197134d0*i5 - 0.1241856791d0*i6
     /  - 0.0598724442d0*i7 - 0.0492098054d0*i8 - 0.0326420465d0*i9
     /  - 0.0042091537d0*i10 - 0.0568444786d0*i11 - 0.0379374765d0*i12
     /  - 0.00343355d0*i13 - 43.4189059559d0*x14 + 10.1252158257d0*x15
     /  + 77.9788177737d0*x16 + 0.3370546232d0*x17
     /  - 1.4549710707d0*x18 + 0.489493217d0*x19 - 3.9857951868d0*x20)
     /  + 0.64d0*sqr(13.8564717531d0 + (-0.1141686445d0*i1)
     /  - 0.2191862214d0*i2 - 0.0025448286d0*i3 + 0.00239861d0*i4
     /  - 0.1144706672d0*i5 - 0.0085848528d0*i6 - 0.0035218461d0*i7
     /  - 0.001600416d0*i8 - 0.1228898407d0*i9 + 0.000914048d0*i10
     /  - 0.0041742745d0*i11 - 0.0038012678d0*i12 - 3.23811d-5*i13
     /  + 93.8857141632d0*x14 - 9.7411135156d0*x15
     /  - 0.5732088498d0*x16 + 0.0199212507d0*x17 + 0.0208043091d0*x18
     /  + 0.0175764412d0*x19 - 0.0815881622d0*x20)
      f = f 
     /  + 0.64d0*sqr((-0.03608066d0*i1) - 0.014056266d0*i2
     /  + 0.0050338315d0*i3 + 0.0096325638d0*i4 - 0.0228356671d0*i5
     /  + 0.0005897623d0*i6 - 0.0018447306d0*i7 + 0.0015702018d0*i8
     /  - 0.0155263332d0*i9 + 0.0050006206d0*i10 + 0.003852327d0*i11
     /  + 0.0011741859d0*i12 - 0.0004337085d0*i13
     /  + 15.3248475624d0*x14 - 47.2905178532d0*x15
     /  - 41.8063079022d0*x16 + 0.0313039393d0*x17 - 0.296380168d0*x18
     /  + 0.0036803543d0*x19 + 0.006213577d0*x20 - 1.4654518443d0)
     /  + 0.0001d0*sqr(18.425410362d0 + (-0.1439232314d0*i1)
     /  - 0.1047333108d0*i2 - 0.0121434245d0*i3 - 0.003629836d0*i4
     /  - 0.2453778956d0*i5 - 0.307832879d0*i6 - 0.2487130071d0*i7
     /  - 0.3821881872d0*i8 - 0.0082958874d0*i9 + 0.0008311951d0*i10
     /  + 0.0234687515d0*i11 + 0.0212263335d0*i12 - 0.0025169633d0*i13
     /  - 162.9216743805d0*x14 + 0.6069838295d0*x15
     /  + 33.6263912566d0*x16 - 0.5818848984d0*x17
     /  + 0.4916767822d0*x18 + 5.9384033682d0*x19
     /  - 105.0147070331d0*x20) 
      f = f 
     /  + 0.16d0*sqr(1.3765716016d0*i1
     /  - 0.1289229446d0*i2 + 0.0190698796d0*i3 + 0.13796709d0*i4
     /  + 1.369802016d0*i5 + 0.7213337592d0*i6 + 0.437642633d0*i7
     /  + 0.2356608263d0*i8 - 0.2359036464d0*i9 + 0.1114416754d0*i10
     /  + 0.1010350555d0*i11 + 0.0841849503d0*i12 + 0.0209393283d0*i13
     /  - 324.876865998d0*x14 + 211.7847928717d0*x15
     /  + 91.5487266435d0*x16 - 4.2419017625d0*x17
     /  + 21.9041455225d0*x18 - 6.4503519664d0*x19
     /  + 20.5350536277d0*x20 - 32.1842133879d0)
     /  + sqr(27.0290256459d0 + 0.957697711d0*i1 - 0.0082391871d0*i2
     /  - 0.0813430324d0*i3 - 0.0501068225d0*i4 + 0.8336253118d0*i5
     /  + 0.0892756746d0*i6 + 0.0368980247d0*i7 - 0.0501048986d0*i8
     /  + 0.0252255515d0*i9 - 0.00815609d0*i10 - 0.0487858863d0*i11
     /  - 0.0126270252d0*i12 + 0.0071029695d0*i13
     /  + 245.9820390329d0*x14 + 36.5783315848d0*x15
     /  + 136.0277393488d0*x16 - 0.8807902958d0*x17
     /  + 2.2707277859d0*x18 + 0.8479304948d0*x19
     /  - 9.1285738954d0*x20)
      f = f 
     /  + sqr(29.0548186711d0
     /  + (-0.4379945283d0*i1) - 0.2088131632d0*i2 - 0.0732256897d0*i3
     /  - 0.0239641788d0*i4 - 0.5900546031d0*i5 - 0.2428476725d0*i6
     /  - 0.1244476172d0*i7 - 0.1236978209d0*i8 - 0.0285903567d0*i9
     /  - 0.0061900868d0*i10 - 0.0703772887d0*i11 - 0.0385982014d0*i12
     /  - 0.0014575845d0*i13 - 88.7963420677d0*x14
     /  + 20.3324025392d0*x15 + 94.9808940384d0*x16
     /  + 0.0105696349d0*x17 + 0.5364673412d0*x18 + 0.9038719013d0*x19
     /  - 9.6778384118d0*x20) + 0.64d0*sqr(26.3789577283d0
     /  + (-0.1816797092d0*i1) - 0.4195839375d0*i2 - 0.0047736081d0*i3
     /  + 0.0023617675d0*i4 - 0.2053211397d0*i5 - 0.0214250689d0*i6
     /  - 0.0061899533d0*i7 - 0.0041549446d0*i8 - 0.2353338886d0*i9
     /  + 0.0006359016d0*i10 - 0.0071061708d0*i11 - 0.0045752371d0*i12
     /  + 0.0003519476d0*i13 + 172.1680687341d0*x14
     /  - 10.8415575999d0*x15 + 3.6362070477d0*x16
     /  - 0.0132159164d0*x17 + 0.3076388785d0*x18 + 0.0826159866d0*x19
     /  - 0.8688992794d0*x20)
      f = f 
     /  + 0.64d0*sqr(0.9440674981d0
     /  + (-0.0650776693d0*i1) - 0.0422739602d0*i2 + 0.0037971709d0*i3
     /  + 0.0094296564d0*i4 - 0.0577633117d0*i5 - 0.0020669462d0*i6
     /  - 0.0028611583d0*i7 + 0.0041239641d0*i8 - 0.0346613481d0*i9
     /  + 0.0043925649d0*i10 + 0.0012549378d0*i11
     /  - 0.0006050918d0*i12 - 0.0004830789d0*i13
     /  + 27.1112542336d0*x14 - 36.9200749555d0*x15
     /  - 33.0774743145d0*x16 + 0.0508171114d0*x17
     /  - 0.1274755827d0*x18 + 0.0553021477d0*x19
     /  + 0.0013939617d0*x20) + 0.16d0*sqr(2.1813628267d0*i1
     /  - 0.1545507679d0*i2 + 0.039163584d0*i3 + 0.210595855d0*i4
     /  + 2.4031839085d0*i5 + 1.4473181944d0*i6 + 0.9061155364d0*i7
     /  + 0.5780098491d0*i8 - 0.3732071072d0*i9 + 0.1709683744d0*i10
     /  + 0.1646340073d0*i11 + 0.1174019409d0*i12 + 0.0255527091d0*i13
     /  - 471.431966531d0*x14 + 289.6009154816d0*x15
     /  + 122.1258853701d0*x16 - 5.3231652518d0*x17
     /  + 24.0625644277d0*x18 - 14.3501693276d0*x19
     /  + 38.5392409731d0*x20 - 58.0191890609d0) 
      f = f 
     /  + sqr(38.0118455163d0
     /  + 1.7520272485d0*i1 + 0.0636572431d0*i2 - 0.1076325163d0*i3
     /  - 0.0695183984d0*i4 + 1.7170458637d0*i5 + 0.2636405478d0*i6
     /  + 0.1013980865d0*i7 - 0.1445192027d0*i8 + 0.0484463478d0*i9
     /  - 0.0109589866d0*i10 - 0.0429784057d0*i11 - 0.0078105656d0*i12
     /  + 0.006252233d0*i13 + 515.2918119641d0*x14
     /  + 41.5620366801d0*x15 + 149.9399579296d0*x16
     /  - 1.2697032171d0*x17 + 2.1796366891d0*x18 + 1.5710763787d0*x19
     /  - 30.6184678297d0*x20) + sqr(33.5710771107d0
     /  + (-0.4728673308d0*i1) - 0.2010544485d0*i2 - 0.0902522712d0*i3
     /  - 0.0308265474d0*i4 - 0.6749953998d0*i5 - 0.3666892682d0*i6
     /  - 0.189796208d0*i7 - 0.2619720144d0*i8 + 0.0147632556d0*i9
     /  - 0.0082828855d0*i10 - 0.0734323184d0*i11 - 0.0359947855d0*i12
     /  - 0.0005805197d0*i13 - 130.6618505398d0*x14
     /  + 31.8815027643d0*x15 + 98.4635347459d0*x16
     /  - 0.4392195739d0*x17 + 0.6030186151d0*x18 + 1.2678674023d0*x19
     /  - 17.8419259821d0*x20) 
      f = f
     /  + 0.64d0*sqr(44.2196893415d0
     /  + (-0.2469468564d0*i1) - 0.6976506683d0*i2 - 0.0082307807d0*i3
     /  - 0.0014266429d0*i4 - 0.2964317522d0*i5 - 0.0478706966d0*i6
     /  - 0.0129552016d0*i7 - 0.0226061611d0*i8 - 0.3889418107d0*i9
     /  - 0.0024918904d0*i10 - 0.0097414786d0*i11 - 0.0050816254d0*i12
     /  - 0.0002169046d0*i13 + 272.8953072747d0*x14
     /  - 8.2260585995d0*x15 + 13.3367849503d0*x16
     /  - 0.0210102051d0*x17 - 0.200858329d0*x18 + 0.3447937286d0*x19
     /  - 4.7324932298d0*x20) + 0.64d0*sqr(2.3916082775d0
     /  + (-0.0830229296d0*i1) - 0.0607072137d0*i2 + 0.0025890994d0*i3
     /  + 0.0100013643d0*i4 - 0.092511806d0*i5 - 0.0106796455d0*i6
     /  - 0.0060733193d0*i7 + 0.0058175128d0*i8 - 0.0478475083d0*i9
     /  + 0.0040087079d0*i10 - 0.0009799351d0*i11 - 0.0011759111d0*i12
     /  - 0.0005345845d0*i13 + 25.709095923d0*x14
     /  - 24.4731791748d0*x15 - 24.6131479194d0*x16
     /  + 0.0454106213d0*x17 - 0.0646065275d0*x18 + 0.1581190219d0*x19
     /  + 0.2116796041d0*x20)
      f = f
     /  + sqr(24.6740164037d0
     /  + 0.0223977103d0*i1 - 0.1121987606d0*i2 - 0.0723574747d0*i3
     /  - 0.0304799906d0*i4 + 0.0141026892d0*i5 + 0.0150496313d0*i6
     /  + 0.009356091d0*i7 + 0.0061453714d0*i8 - 0.0029939245d0*i9
     /  - 0.0052432754d0*i10 - 0.0715164075d0*i11 - 0.0491435187d0*i12
     /  + 0.0022578622d0*i13 + 7.4688258927d0*x14
     /  + 25.6140478631d0*x15 + 128.5602665698d0*x16
     /  + 0.4757541454d0*x17 - 10.0833898265d0*x18
     /  + 0.2812647597d0*x19 + 1.3069721605d0*x20)
     /  + 0.64d0*sqr(0.025866576d0*i2 - 0.002043184d0*i1
     /  + 0.0107957855d0*i3 + 0.0142117191d0*i4 - 0.0030627984d0*i5
     /  - 0.0016988735d0*i6 - 0.0035051809d0*i7 + 0.000204285d0*i8
     /  + 0.0065467563d0*i9 + 0.0087981309d0*i10 + 0.0109097143d0*i11
     /  + 0.0086807432d0*i12 + 5.64288d-5*i13 - 1.9200628335d0*x14
     /  - 82.6218554875d0*x15 - 77.7620621346d0*x16
     /  - 0.0899689319d0*x17 + 1.3246157882d0*x18 - 0.0060396204d0*x19
     /  - 0.2836216482d0*x20 - 6.5767760637d0)
      f = f     
     /  + 0.0001d0*sqr(13.4408088149d0 + (-0.1335354833d0*i1)
     /  - 0.0513877546d0*i2 - 0.0043335559d0*i3 - 0.006151427d0*i4
     /  - 0.3784010428d0*i5 - 0.2996327994d0*i6 - 0.216483775d0*i7
     /  - 0.1967597646d0*i8 + 0.0025108018d0*i9 - 0.0030313115d0*i10
     /  + 0.0016603186d0*i11 + 0.0272463384d0*i12 + 0.0122595633d0*i13
     /  - 32.7638050291d0*x14 - 13.079882575d0*x15
     /  + 16.4306490378d0*x16 - 2.0852677276d0*x17
     /  + 25.0395554658d0*x18 + 3.4583936295d0*x19
     /  - 36.3419153111d0*x20) 
      f = f 
     /  + 0.16d0*sqr(0.2726125833d0*i1
     /  - 0.017621104d0*i2 + 0.0020860949d0*i3 + 0.0265588688d0*i4
     /  + 0.1752405105d0*i5 + 0.0561057505d0*i6 + 0.029476967d0*i7
     /  + 0.0075101638d0*i8 - 0.0414871915d0*i9 + 0.0219235679d0*i10
     /  + 0.0175705997d0*i11 + 0.0267389822d0*i12 + 0.0081458252d0*i13
     /  - 60.7627429307d0*x14 + 45.0531668914d0*x15
     /  + 23.9517373918d0*x16 - 2.2103463222d0*x17
     /  + 30.7877802516d0*x18 - 0.3917482702d0*x19
     /  + 0.0764416754d0*x20 - 6.3060317451d0) + sqr(27.194557222d0
     /  + 0.0917014531d0*i1 - 0.1151495709d0*i2 - 0.0801969223d0*i3
     /  - 0.0366203739d0*i4 + 0.0462435601d0*i5 + 0.0097394551d0*i6
     /  + 0.0063913226d0*i7 + 0.0015667954d0*i8 + 0.0015410448d0*i9
     /  - 0.0066552614d0*i10 - 0.0772208424d0*i11 - 0.0474166511d0*i12
     /  + 0.0043032293d0*i13 + 25.6773735693d0*x14
     /  + 31.8686922353d0*x15 + 149.3606489483d0*x16
     /  + 0.0887203646d0*x17 - 2.6020875573d0*x18 + 0.4248066623d0*x19
     /  + 1.4206154804d0*x20) 
      f = f 
     /  + sqr(20.9585644712d0
     /  + (-0.3743985215d0*i1) - 0.1620729809d0*i2 - 0.0471999158d0*i3
     /  - 0.0103687457d0*i4 - 0.3281530126d0*i5 - 0.0496949468d0*i6
     /  - 0.0185921118d0*i7 - 0.0143010524d0*i8 - 0.0363039622d0*i9
     /  - 0.0030777596d0*i10 - 0.05404877d0*i11 - 0.0483645323d0*i12
     /  - 0.0074639288d0*i13 - 22.9502388184d0*x14
     /  + 1.3288409711d0*x15 + 71.1560662147d0*x16
     /  + 0.8530716695d0*x17 - 10.3125827307d0*x18
     /  + 0.1499773618d0*x19 - 1.2612936268d0*x20)
     /  + 0.64d0*sqr(5.5222886784d0 + (-0.0567235021d0*i1)
     /  - 0.0856894075d0*i2 - 0.0019092286d0*i3 + 0.0021686274d0*i4
     /  - 0.047989126d0*i5 - 0.0024578628d0*i6 - 0.0014553154d0*i7
     /  - 0.0005997188d0*i8 - 0.0486072521d0*i9 + 0.0008577712d0*i10
     /  - 0.0029453271d0*i11 - 0.004086349d0*i12 - 0.0006021977d0*i13
     /  + 36.4857205385d0*x14 - 9.5382707914d0*x15
     /  - 2.5662814081d0*x16 + 0.0701123319d0*x17 - 0.9739957489d0*x18
     /  - 0.0039118764d0*x19 + 0.014801047d0*x20)
      f = f 
     /  + 0.64d0*sqr(0.0155658196d0*i2 - 0.0112453555d0*i1
     /  + 0.0100303673d0*i3 + 0.014032605d0*i4 - 0.0055943743d0*i5
     /  - 0.0008915657d0*i6 - 0.0035956623d0*i7 + 0.0001225999d0*i8
     /  - 0.0004941962d0*i9 + 0.0083145248d0*i10 + 0.009984122d0*i11
     /  + 0.0068260588d0*i12 - 0.0003265892d0*i13 + 3.3349538071d0*x14
     /  - 78.7011629566d0*x15 - 74.4766668825d0*x16
     /  - 0.012150969d0*x17 - 0.2438248091d0*x18 - 0.0132360482d0*x19
     /  - 0.2890630013d0*x20 - 5.5428877033d0)
     /  + 0.0001d0*sqr(22.91202141d0 + (-0.1697990249d0*i1)
     /  - 0.1270118159d0*i2 - 0.0112563551d0*i3 - 0.0018247055d0*i4
     /  - 0.5780024277d0*i5 - 0.5089288567d0*i6 - 0.3623853104d0*i7
     /  - 0.3635107225d0*i8 + 0.0127387282d0*i9 + 0.002681067d0*i10
     /  + 0.0050860991d0*i11 + 0.0469918947d0*i12 + 0.0209276578d0*i13
     /  - 103.5695914313d0*x14 - 17.7443509241d0*x15
     /  + 32.7638919927d0*x16 - 2.3776473089d0*x17
     /  + 17.4772130373d0*x18 + 6.3325007642d0*x19
     /  - 70.1193265701d0*x20) 
      f = f 
     /  + 0.16d0*sqr(0.9718848502d0*i1
     /  - 0.1318564648d0*i2 + 0.0078259228d0*i3 + 0.0937484136d0*i4
     /  + 0.6881965791d0*i5 + 0.248035874d0*i6 + 0.1278728121d0*i7
     /  + 0.0382745977d0*i8 - 0.2009234089d0*i9 + 0.0782781847d0*i10
     /  + 0.0692352133d0*i11 + 0.0934309017d0*i12 + 0.031754053d0*i13
     /  - 248.0302545011d0*x14 + 156.5108386651d0*x15
     /  + 81.0934897165d0*x16 - 5.7060974008d0*x17
     /  + 53.3125644434d0*x18 - 1.8399288936d0*x19
     /  - 0.4332042885d0*x20 - 19.1037149037d0) + sqr(35.3714337539d0
     /  + 0.3642209122d0*i1 - 0.1423479061d0*i2 - 0.1017866514d0*i3
     /  - 0.0549860104d0*i4 + 0.1871482383d0*i5 - 0.0177104734d0*i6
     /  - 0.0105679624d0*i7 - 0.0223660365d0*i8 + 0.0061559896d0*i9
     /  - 0.0103810974d0*i10 - 0.0898924115d0*i11 - 0.0377808332d0*i12
     /  + 0.011632108d0*i13 + 79.3520417825d0*x14
     /  + 49.2861444143d0*x15 + 199.688966238d0*x16
     /  - 0.5706539784d0*x17 + 3.50694557d0*x18 + 0.8453712325d0*x19
     /  + 0.4981575316d0*x20) 
      f = f 
     /  + sqr(35.0017112093d0
     /  + (-0.6055332323d0*i1) - 0.2491329203d0*i2 - 0.0849802779d0*i3
     /  - 0.0224647015d0*i4 - 0.6451950556d0*i5 - 0.1404866339d0*i6
     /  - 0.0602240313d0*i7 - 0.0416040158d0*i8 - 0.0496262557d0*i9
     /  - 0.0065177732d0*i10 - 0.0980857019d0*i11 - 0.074191225d0*i12
     /  - 0.0084886228d0*i13 - 59.1471556858d0*x14
     /  + 12.8393595714d0*x15 + 132.3494388126d0*x16
     /  + 0.597164433d0*x17 - 2.6471256653d0*x18 + 0.4806616333d0*x19
     /  - 2.9211234364d0*x20) + 0.64d0*sqr(13.3242917752d0
     /  + (-0.1333606586d0*i1) - 0.2060297611d0*i2 - 0.0043336404d0*i3
     /  + 0.0048206981d0*i4 - 0.1255605261d0*i5 - 0.0068561106d0*i6
     /  - 0.0025640389d0*i7 - 0.0002025911d0*i8 - 0.1177170248d0*i9
     /  + 0.0020789244d0*i10 - 0.0071077195d0*i11 - 0.0079888861d0*i12
     /  - 0.0007563718d0*i13 + 90.1828519606d0*x14
     /  - 16.7705535388d0*x15 - 2.5547451251d0*x16
     /  + 0.0444115721d0*x17 - 0.0681078714d0*x18 + 0.0153484518d0*x19
     /  + 0.0025491801d0*x20) 
      f = f 
     /  + 0.64d0*sqr((-0.049482695d0*i1)
     /  - 0.0105572827d0*i2 + 0.0081720297d0*i3 + 0.0139602074d0*i4
     /  - 0.022512747d0*i5 + 0.0024956475d0*i6 - 0.0027146251d0*i7
     /  + 0.0012832223d0*i8 - 0.0180832171d0*i9 + 0.0073530068d0*i10
     /  + 0.0072506127d0*i11 + 0.0019280634d0*i12 - 0.0013136646d0*i13
     /  + 22.354352107d0*x14 - 69.4261066563d0*x15
     /  - 65.9673942362d0*x16 + 0.0630205182d0*x17
     /  - 0.6756411564d0*x18 - 0.0172196827d0*x19 - 0.1847089481d0*x20
     /  - 2.8171206293d0) + 0.0001d0*sqr(21.7879588169d0
     /  + (-0.0947365547d0*i1) - 0.1798660943d0*i2 - 0.01717141d0*i3
     /  + 0.0019039585d0*i4 - 0.4407563665d0*i5 - 0.4383439497d0*i6
     /  - 0.3352661452d0*i7 - 0.3702712169d0*i8 + 0.0256058978d0*i9
     /  + 0.0038440139d0*i10 + 0.0079542915d0*i11 + 0.0387199773d0*i12
     /  + 0.0172231689d0*i13 - 189.427546876d0*x14
     /  - 46.7180298532d0*x15 + 30.1363300837d0*x16
     /  - 1.6231543138d0*x17 + 7.3508136199d0*x18 + 6.5997072711d0*x19
     /  - 82.0209643098d0*x20)
      f = f 
     /  + 0.16d0*sqr(1.8568434952d0*i1
     /  - 0.3106290428d0*i2 + 0.0094972219d0*i3 + 0.1860850432d0*i4
     /  + 1.6211935409d0*i5 + 0.7146245879d0*i6 + 0.4279294974d0*i7
     /  + 0.1480826461d0*i8 - 0.3431607178d0*i9 + 0.1528034855d0*i10
     /  + 0.1501944571d0*i11 + 0.163165132d0*i12 + 0.0525199133d0*i13
     /  - 514.936957251d0*x14 + 290.3735314192d0*x15
     /  + 141.6853205036d0*x16 - 7.8736279955d0*x17
     /  + 50.5912316647d0*x18 - 5.3692662428d0*x19
     /  - 1.2634691605d0*x20 - 37.2484380527d0) + sqr(49.7793154236d0
     /  + 0.8974566082d0*i1 - 0.2016545606d0*i2 - 0.1372420643d0*i3
     /  - 0.0849370149d0*i4 + 0.597216156d0*i5 - 0.0529743107d0*i6
     /  - 0.0327123325d0*i7 - 0.0956973786d0*i8 + 0.0135051726d0*i9
     /  - 0.0174040586d0*i10 - 0.0995786119d0*i11 - 0.0222788768d0*i12
     /  + 0.0202069403d0*i13 + 183.5676339425d0*x14
     /  + 67.4179160872d0*x15 + 260.0168205722d0*x16
     /  - 1.1081123903d0*x17 + 3.8671994285d0*x18 + 1.5222166d0*x19
     /  - 5.0366128035d0*x20) 
      f = f 
     /  + sqr(43.021067804d0
     /  + (-0.6083620583d0*i1) - 0.3029124972d0*i2 - 0.1135882353d0*i3
     /  - 0.0355395701d0*i4 - 0.8790947665d0*i5 - 0.3016593148d0*i6
     /  - 0.1408025397d0*i7 - 0.1002537841d0*i8 - 0.0514080181d0*i9
     /  - 0.0094415925d0*i10 - 0.1266638291d0*i11 - 0.0719574481d0*i12
     /  - 0.0018496895d0*i13 - 135.5420938387d0*x14
     /  + 33.8072474452d0*x15 + 173.1509254254d0*x16
     /  + 0.0154455776d0*x17 + 0.9579081923d0*x18 + 0.9045568743d0*x19
     /  - 6.1259070911d0*x20) + 0.64d0*sqr(25.0638931642d0
     /  + (-0.2136068538d0*i1) - 0.3940535057d0*i2 - 0.0079956209d0*i3
     /  + 0.0078872724d0*i4 - 0.2472793465d0*i5 - 0.0214199028d0*i6
     /  - 0.0053286994d0*i7 + 0.0001186708d0*i8 - 0.2265402821d0*i9
     /  + 0.0039784291d0*i10 - 0.0130345369d0*i11 - 0.0097124796d0*i12
     /  + 8.47382d-5*i13 + 161.5508352661d0*x14
     /  - 17.8973790682d0*x15 + 3.0754846652d0*x16
     /  - 0.0131686905d0*x17 + 0.4333019034d0*x18 + 0.0861189709d0*x19
     /  - 0.3218074323d0*x20) 
      f = f 
     /  + 0.64d0*sqr(0.6473699839d0
     /  + (-0.1009737998d0*i1) - 0.0447676904d0*i2 + 0.0063388465d0*i3
     /  + 0.0147504297d0*i4 - 0.0728844726d0*i5 + 0.003141144d0*i6
     /  - 0.0026665157d0*i7 + 0.0048304665d0*i8 - 0.04371889d0*i9
     /  + 0.0072335014d0*i10 + 0.0029920234d0*i11 - 0.0023317602d0*i12
     /  - 0.0016459968d0*i13 + 50.5469705602d0*x14
     /  - 55.5675725111d0*x15 - 54.2122022045d0*x16
     /  + 0.0682390665d0*x17 - 0.0958560558d0*x18 + 0.01421791d0*x19
     /  + 0.2779557025d0*x20) + 0.16d0*sqr(2.7737928335d0*i1
     /  - 0.5532575743d0*i2 + 0.0156658048d0*i3 + 0.2891603733d0*i4
     /  + 2.9065199338d0*i5 + 1.5465361344d0*i6 + 0.8914561677d0*i7
     /  + 0.2733903038d0*i8 - 0.4133526968d0*i9 + 0.2270135677d0*i10
     /  + 0.2701158308d0*i11 + 0.2145218945d0*i12 + 0.0728906458d0*i13
     /  - 812.3382165169d0*x14 + 374.2616854026d0*x15
     /  + 159.2434025232d0*x16 - 8.3531458586d0*x17
     /  + 37.4532747863d0*x18 - 11.6181359664d0*x19
     /  - 10.4220063327d0*x20 - 57.9853544596d0)
      f = f 
     /  + sqr(72.2005752966d0 + 1.5759625636d0*i1 - 0.2566483609d0*i2
     /  - 0.1785641791d0*i3 - 0.1287946874d0*i4 + 1.3533851444d0*i5
     /  - 0.0184812506d0*i6 - 0.0125873895d0*i7 - 0.2717241723d0*i8
     /  + 0.0370423817d0*i9 - 0.0352393621d0*i10 - 0.0928409915d0*i11
     /  - 0.0108914457d0*i12 + 0.0220530873d0*i13
     /  + 403.4279641629d0*x14 + 57.2476586121d0*x15
     /  + 304.648651667d0*x16 - 1.4921447174d0*x17
     /  + 0.5675587323d0*x18 + 2.8263646656d0*x19
     /  - 21.8009701189d0*x20) + sqr(51.2834375764d0
     /  + (-0.5417732483d0*i1) - 0.3773631527d0*i2 - 0.1423336457d0*i3
     /  - 0.0535593584d0*i4 - 0.9705512747d0*i5 - 0.5008961292d0*i6
     /  - 0.2305517518d0*i7 - 0.2277147556d0*i8 - 0.0445987583d0*i9
     /  - 0.016344045d0*i10 - 0.1398022291d0*i11 - 0.062421874d0*i12
     /  + 0.0030033061d0*i13 - 257.1964984571d0*x14
     /  + 47.5204718859d0*x15 + 204.8907748828d0*x16
     /  - 0.5298037875d0*x17 + 0.4997334966d0*x18 + 1.3165875998d0*x19
     /  - 14.9476248756d0*x20)
      f = f 
     /  + 0.64d0*sqr(40.8609115933d0
     /  + (-0.2719857145d0*i1) - 0.6594952711d0*i2 - 0.0150264222d0*i3
     /  + 0.0082096416d0*i4 - 0.3654629352d0*i5 - 0.0500388586d0*i6
     /  - 0.0106461309d0*i7 - 0.0084873809d0*i8 - 0.3757245206d0*i9
     /  + 0.0038448141d0*i10 - 0.0200843262d0*i11 - 0.0097674219d0*i12
     /  + 0.0010369999d0*i13 + 220.7856326007d0*x14
     /  - 9.8944334188d0*x15 + 18.1994216348d0*x16
     /  - 0.0314578944d0*x17 + 0.3637738371d0*x18 + 0.2888783431d0*x19
     /  - 2.4044479313d0*x20) + 0.64d0*sqr(3.1835502966d0
     /  + (-0.1273885113d0*i1) - 0.0801064562d0*i2 + 0.003542304d0*i3
     /  + 0.0182177895d0*i4 - 0.134241299d0*i5 - 0.0005278085d0*i6
     /  - 0.0032882925d0*i7 + 0.0148782954d0*i8 - 0.0698664409d0*i9
     /  + 0.0096435295d0*i10 - 0.0024311368d0*i11 - 0.00381761d0*i12
     /  - 0.000946167d0*i13 + 63.2346641976d0*x14
     /  - 38.2784911039d0*x15 - 40.1606271682d0*x16
     /  + 0.0365675552d0*x17 + 0.6620309299d0*x18 - 0.0055537207d0*x19
     /  + 1.1735430798d0*x20)

      g(1) = -(- i1 - i5 - i6 - i7 - i8 + 31.0d0)
 
      g(2) = -i1 - i5 - i6 - i7 - i8 + 41.0d0
 
      g(3) = -(- i2 - i9 + 44.0d0)
 
      g(4) = -i2 - i9 + 47.0d0
 
      g(5) = -i4 - i10 + 210.0d0
 
      g(6) = -i3 - i11 - i12 - i13 + 210.0d0
 
      g(7) = -i1 - i5 + 16.0d0
 
      g(8) = -(- i4 - i10 + 89.0d0)
 
      g(9) = -i4 - i10 + 136.0d0

  999 continue
      return
      end

      subroutine du_opt5( mode,     m,     me,  mmax, ncont,  
     /              nbin,  nint,   nmax,     x,    xl,
     /                xu,     f,      g,  pnam,  pref,
     /               fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /  g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /  i10, i11, i12, i13, x14, x15, x16, x17, x18, x19, x20
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'DU_OPT5'
         pref  = '\cite{MINLPLib}'
c         fex   = 8.073658d0  
         fex   = 0.20254254D+2
         ncont = 7
         nint  = 13
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i=1,ncont
            xl(i) = -1.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d1
         end do
         xl(1) = -0.0408d0
         x(1)  = -0.0288d0
         xu(1) = -0.0288d0
         x(2)  = 0.0d0
         xu(2) = 0.008d0
         xl(3) = -0.0311d0
         x(3)  = -0.0211d0
         xu(3) = -0.0211d0
         xl(4) = 0.1d0
         x(4)  = 0.5d0
         xu(4) = 1.0d0
         xl(5) = 0.01d0
         x(5)  = 0.05d0
         xu(5) = 0.08d0
         xl(6) = 0.1d0
         x(6)  = 0.5d0
         xu(6) = 1.0d0
         xl(7) = 0.01d0
         x(7)  = 0.05d0
         xu(7) = 0.08d0
         xu(8) = 3.0d0
         xl(9) = 9.0d0
         x(9)  = 9.0d0
         xu(9) = 9.0d0
         xu(10) = 42.0d0
         xl(11) = 11.0d0
         x(11)  = 15.0d0         
         xu(11) = 21.0d0
         xl(15) = 0.0d0
         xu(15) = 5.0d0     
         xu(17) = 10.0d0
         xu(18) = 16.0d0
         xu(19) = 16.0d0
         xu(20) = 8.0d0
         goto 999       
      end if
      
      do i=1,nint
         y(i) = x(ncont+i)
      end do
      
      x14 = x(1)
      x15 = x(2)
      x16 = x(3)
      x17 = x(4)
      x18 = x(5)
      x19 = x(6)
      x20 = x(7)
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)

      f = sqr(0.549994725d0*i1 + 0.1169796775d0*i2
     /  - 0.0002294295d0*i3 - 0.0011389815d0*i4 + 0.517334977d0*i5
     /  + 0.1254856465d0*i6 + 0.0777056655d0*i7 + 0.0540072395d0*i8
     /  + 0.0225685505d0*i9 + 0.000289518d0*i10 + 0.000232915d0*i11
     /  - 0.000224502d0*i12- 0.0011167735d0*i13 + 25.6672504104d0*x14
     /  - 0.6845946712d0*x15 + 0.1535300974d0*x16 - 0.0933139579d0*x17
     /  + 0.461408334d0*x18 - 0.0641379463d0*x19
     /  + 0.7660466359d0*x20- 0.7218179833)
     /  + 0.64d0*sqr(6.0625297988d0 + (-0.206216401d0*i1)
     /  - 0.4886123175d0*i2 - 0.0001497655d0*i3 + 0.000109791d0*i4
     /  - 0.2021672275d0*i5 - 0.018213187d0*i6 - 0.011539198d0*i7
     /  - 0.008908086d0*i8 - 0.267492814d0*i9 - 0.0004922715d0*i10
     /  - 0.000247959d0*i11 - 1.85495d0-5d0*i12 + 0.0007170985d0*i13
     /  +  42.9101274821d0*x14 + 0.2915268667d0*x15
     /  - 0.2170048789d0*x16 + 0.004584997d0*x17 + 0.0358768521d0*x18
     /  - 0.0026046819d0*x19 - 0.065962424d0*x20)
      f = f
     /  + sqr(2.371858677d0*i1 + 0.510078782d0*i2 - 0.001015751d0*i3
     /  - 0.005331239d0*i4 + 2.333275069d0*i5 + 0.6571341125d0*i6
     /  + 0.42208406d0*i7 + 0.327328662d0*i8 + 0.08911655d0*i9
     /  + 0.000245212d0*i10 + 0.001009617d0*i11 - 0.00029877d0*i12
     /  - 0.0041785445d0*i13 + 117.0980126167d0*x14
     /  - 4.4993202945d0*x15 + 0.3643926817d0*x16 - 0.3496847607d0*x17
     /  + 1.0892794617d0*x18 - 0.3623631585d0*x19 + 4.9211060051d0*x20
     /  - 3.4964885411) + 0.64d0*sqr(14.9681958649d0
     /  + (-0.452221991d0*i1) - 1.211015313d0*i2 - 0.0002406625d0*i3
     /  + 0.0003163255d0*i4 - 0.4563128165d0*i5 - 0.045698402d0*i6
     /  - 0.028611547d0*i7 - 0.028609402d0*i8 - 0.656655331d0*i9
     /  - 0.000693337d0*i10 - 0.000478371d0*i11 - 0.0001805125d0*i12
     /  + 0.0014513565d0*i13 + 107.758560078d0*x14
     /  + 0.8779839107d0*x15 - 0.7455513768d0*x16 - 0.0041815651d0*x17
     /  + 0.2339673006d0*x18 - 0.0188546046d0*x19
     /  - 0.0721138144d0*x20) 
      f = f
     /  + sqr(5.9209037795d0*i1
     /  + 1.268435754d0*i2 - 0.002521565d0*i3 - 0.0145396585d0*i4
     /  + 6.025795972d0*i5 + 1.9497232215d0*i6 + 1.3228942365d0*i7
     /  + 1.1544472565d0*i8 + 0.18917911d0*i9 - 0.0029636125d0*i10
     /  + 0.0032177845d0*i11 + 0.0009287875d0*i12 - 0.0070525825d0*i13
     /  + 307.4529463057d0*x14 - 15.1780937915d0*x15
     /  + 0.8257601211d0*x16 - 0.7326525441d0*x17 + 0.9539276158d0*x18
     /  - 1.1866139503d0*x19 + 19.1856490596d0*x20 - 10.0395122378)
     /  + 0.64d0*sqr(29.1812808818d0 + (-0.7525666535d0*i1)
     /  - 2.366924608d0*i2 - 3.3386d-5*i3 + 0.0008084995d0*i4
     /  - 0.7626493665d0*i5 - 0.06943802d0*i6 - 0.044542657d0*i7
     /  - 0.06034096d0*i8 - 1.2732236065d0*i9 - 0.000170688d0*i10
     /  - 0.0005832025d0*i11 - 0.000747879d0*i12 + 0.002469289d0*i13
     /  + 218.6403200779d0*x14 + 1.2343329355d0*x15
     /  - 2.7282000308d0*x16 - 0.0389929967d0*x17 + 0.6694703489d0*x18
     /  - 0.100837974d0*x19 + 0.7305808787d0*x20)
      f = f
     /  + sqr(11.8542510635d0*i1 + 2.597831153d0*i2
     /  - 0.0042385525d0*i3 - 0.034173417d0*i4 + 12.2571100445d0*i5
     /  + 4.33065553d0*i6 + 3.1186432225d0*i7 + 2.9573306875d0*i8
     /  + 0.3922775225d0*i9 - 0.013605558d0*i10 + 0.0134967455d0*i11
     /  + 0.0024050475d0*i12 - 0.0054617525d0*i13
     /  + 643.3290493179d0*x14 - 27.7561017376d0*x15
     /  + 8.0186395117d0*x16 - 1.2672557345d0*x17 - 0.4706787663d0*x18
     /  - 2.8653875681d0*x19 + 59.2034194606d0*x20 - 23.7020755551)
     /  + 0.64d0*sqr(51.4300329684d0 + (-1.11742833d0*i1)
     /  - 4.187209611d0*i2 + 0.001572707d0*i3 + 0.0033773285d0*i4
     /  - 1.106194274d0*i5 - 0.0589705015d0*i6 - 0.0297855395d0*i7
     /  - 0.086679314d0*i8 - 2.245411196d0*i9 + 0.002395894d0*i10
     /  + 0.0002810055d0*i11 - 0.002773322d0*i12 + 0.004869746d0*i13
     /  + 407.9383501237d0*x14 - 1.6716467509d0*x15
     /  - 8.9148857096d0*x16 - 0.1461956666d0*x17 + 1.8262409945d0*x18
     /  - 0.3641018035d0*x19 + 6.6067986768d0*x20)
      f = f
     /  + sqr(1.5205390249d0 + 0.0082873805d0*i1 - 0.0235719995d0*i2
     /  - 0.0245712215d0*i3 - 0.0118061575d0*i4 + 0.005122137d0*i5
     /  + 0.006252163d0*i6 + 0.004316798d0*i7 + 0.00322166d0*i8
     /  + 0.0034396695d0*i9 - 0.0019490185d0*i10 - 0.022343309d0*i11
     /  - 0.01335063d0*i12 + 0.000307004d0*i13 + 0.3179776364d0*x14
     /  + 2.1638530828d0*x15 + 8.7870371217d0*x16 + 0.0179414544d0*x17
     /  - 0.3506843253d0*x18 + 0.0249174581d0*x19
     /  - 0.0707439832d0*x20) + 0.64d0*sqr(0.0137679485d0*i2
     /  - 0.002480226d0*i1 + 0.007808047d0*i3 + 0.0151156365d0*i4
     /  - 0.0026015445d0*i5 - 0.00262214d0*i6 - 0.004062096d0*i7
     /  - 0.00060178d0*i8 + 0.0031992755d0*i9 + 0.0087511595d0*i10
     /  + 0.0066920855d0*i11 + 0.003836358d0*i12 + 1.65225d-5*i13
     /  - 0.2278089449d0*x14 - 16.9817650317d0*x15
     /  - 13.5358723599d0*x16 - 0.0073805759d0*x17
     /  + 0.0464963135d0*x18 - 0.0013299842d0*x19
     /  + 0.0223486039d0*x20 - 1.0705236795)
      f = f
     /  + 0.0001d0*sqr(1.9787606911d0 + (-0.0703885135d0*i1)
     /  - 0.0461424745d0*i2 - 0.0003846915d0*i3 - 0.0042877325d0*i4
     /  - 0.1238807365d0*i5 - 0.1150943445d0*i6 - 0.1430747485d0*i7
     /  - 0.1514278875d0*i8 - 0.0623842385d0*i9 + 0.0008333635d0*i10
     /  + 0.0059473155d0*i11 + 0.009726615d0*i12 - 0.0011614265d0*i13
     /  - 8.1494297476d0*x14 + 1.2112563557d0*x15 - 1.0244950034d0*x16
     /  - 0.0397435234d0*x17 + 0.3761970557d0*x18 + 0.3968598514d0*x19
     /  - 13.9072845464d0*x20) + 0.16d0*sqr(0.3034932505d0*i1
     /  - 0.0139631495d0*i2 + 0.0065791635d0*i3 + 0.0288725125d0*i4
     /  + 0.2690349655d0*i5 + 0.1216588055d0*i6 + 0.072461344d0*i7
     /  + 0.047125806d0*i8 - 0.044335927d0*i9 + 0.023364311d0*i10
     /  + 0.0151302605d0*i11 + 0.0112642585d0*i12 + 0.0017270445d0*i13
     /  - 11.5441497882d0*x14 + 8.6339417127d0*x15
     /  + 3.0878470794d0*x16 - 0.1539564087d0*x17 + 1.2956126461d0*x18
     /  - 0.2281345018d0*x19 + 1.2655596015d0*x20 - 1.2363027807) 
      f = f
     /  + sqr(1.0696475202d0 + 0.54388668d0*i1 + 0.080752138d0*i2
     /  - 0.0277265595d0*i3 - 0.014881568d0*i4 + 0.4943185675d0*i5
     /  + 0.1152590035d0*i6 + 0.0707255635d0*i7 + 0.0460490435d0*i8
     /  + 0.0244682285d0*i9 - 0.0018531055d0*i10 - 0.022937657d0*i11
     /  - 0.0125940685d0*i12 - 0.000294376d0*i13 + 25.3489456455d0*x14
     /  + 2.0315152176d0*x15 + 9.784645976d0*x16 - 0.0858756841d0*x17
     /  + 0.2913560986d0*x18 - 0.0176306534d0*x19 + 0.4233453864d0*x20)
     /  + sqr(3.7253595801d0 + (-0.37947808d0*i1) - 0.166543805d0*i2
     /  - 0.0384681305d0*i3 - 0.0117765895d0*i4 - 0.36965179d0*i5
     /  - 0.0895187825d0*i6 - 0.045220397d0*i7 - 0.0394548345d0*i8
     /  - 0.036723661d0*i9 - 0.002403476d0*i10 - 0.0351213595d0*i11
     /  - 0.022014992d0*i12 - 0.001854697d0*i13 - 5.3086746864d0*x14
     /  + 1.324393925d0*x15 + 9.8395107194d0*x16 + 0.0835697813d0*x17
     /  - 0.559990113d0*x18 + 0.0882573076d0*x19 - 0.8702943348d0*x20)
      f = f
     /  + 0.64d0*sqr(6.0105079707d0 + (-0.2119154695d0*i1)
     /  - 0.483487616d0*i2 - 0.0007529305d0*i3 + 0.000693227d0*i4
     /  - 0.206281672d0*i5 - 0.017718948d0*i6 - 0.010809221d0*i7
     /  - 0.008005992d0*i8 - 0.2655291865d0*i9 - 0.000236861d0*i10
     /  - 0.0012364265d0*i11 - 0.0009372535d0*i12 + 0.0006644745d0*i13
     /  + 42.287929839d0*x14 - 0.4406355124d0*x15 - 0.2701371681d0*x16
     /  + 0.006536567d0*x17 + 0.0072686485d0*x18 - 0.0017404103d0*x19
     /  - 0.0555149205d0*x20) + 0.64d0*sqr(0.001560084d0*i2 
     /  - 0.0171024395d0*i1 + 0.007353092d0*i3 + 0.0146390955d0*i4
     /  - 0.0120126105d0*i5 - 0.0015444625d0*i6 - 0.003175667d0*i7
     /  + 0.0007004655d0*i8 - 0.005387054d0*i9 + 0.0081679155d0*i10
     /  + 0.005958448d0*i11 + 0.0031668995d0*i12 + 1.17565d-5*i13
     /  + 1.1667799922d0*x14 - 16.1521973658d0*x15
     /  - 12.7763196896d0*x16 - 0.0029281577d0*x17
     /  - 0.0074349867d0*x18 - 0.0001382348d0*x19 + 0.0310644996d0*x20
     /  - 0.8439928522) 
      f = f
     /  + 0.0001d0*sqr(3.8361669057d0
     /  + (-0.0443253455d0*i1) - 0.136489225d0*i2 + 0.000971236d0*i3
     /  - 0.005475234d0*i4 - 0.116822972d0*i5 - 0.1512111165d0*i6
     /  - 0.250110272d0*i7 - 0.2825277565d0*i8 - 0.131557343d0*i9
     /  + 0.0096526265d0*i10 + 0.0109753495d0*i11 + 0.0199640185d0*i12
     /  - 0.00210891d0*i13 - 17.9119743477d0*x14 + 2.1182361999d0*x15
     /  - 2.8424893661d0*x16 + 0.0490655808d0*x17 - 0.3240083732d0*x18
     /  + 0.6257146478d0*x19 - 29.8931414536d0*x20)
     /  + 0.16d0*sqr(1.148089832d0*i1 - 0.0366802425d0*i2
     /  + 0.0256133695d0*i3 + 0.108885787d0*i4 + 1.1278833435d0*i5
     /  + 0.6000406795d0*i6 + 0.3834999715d0*i7 + 0.277338556d0*i8
     /  - 0.1475778435d0*i9 + 0.0878565235d0*i10 + 0.055683924d0*i11
     /  + 0.038774191d0*i12 + 0.007060331d0*i13 - 41.9083056697d0*x14
     /  + 30.9460857583d0*x15 + 11.7762638807d0*x16
     /  - 0.4879869942d0*x17 + 3.0804388516d0*x18 - 1.1873441589d0*x19
     /  + 8.9588206656d0*x20 - 5.5877726318d0) 
      f = f
     /  + sqr(2.3125469965d0*i1
     /  + 0.428315477d0*i2 - 0.036978852d0*i3 - 0.023986857d0*i4
     /  + 2.2260066025d0*i5 + 0.5764691755d0*i6 + 0.3564636115d0*i7
     /  + 0.2517094845d0*i8 + 0.084908883d0*i9 - 0.0015215455d0*i10
     /  - 0.0236894355d0*i11 - 0.010680763d0*i12 - 0.0023802535d0*i13
     /  + 114.5668136229d0*x14 + 0.1243165441d0*x15
     /  + 11.9843516021d0*x16 - 0.3535818823d0*x17
     /  + 1.1284243163d0*x18 - 0.2301405927d0*x19 + 3.0148825878d0*x20
     /  - 0.6688058813) + sqr(6.5525257248d0
     /  + (-0.6209350815d0*i1) - 0.2683010795d0*i2 - 0.070712406d0*i3
     /  - 0.0206388915d0*i4 - 0.6850857445d0*i5 - 0.245836676d0*i6
     /  - 0.1470414885d0*i7 - 0.147958399d0*i8 - 0.0515319195d0*i9
     /  - 0.002897171d0*i10 - 0.060135139d0*i11 - 0.0351851705d0*i12
     /  - 0.002911189d0*i13 - 13.3700983917d0*x14 + 3.5575652001d0*x15
     /  + 15.9354642568d0*x16 + 0.0837321797d0*x17
     /  - 0.2374101362d0*x18 + 0.2291951229d0*x19
     /  - 3.1033858692d0*x20) 
      f = f
     /  + 0.64d0*sqr(14.8037013717d0
     /  + (-0.463981166d0*i1) - 1.195132855d0*i2 - 0.001675144d0*i3
     /  + 0.0008538845d0*i4 - 0.4700413895d0*i5 - 0.0453715785d0*i6
     /  - 0.026037898d0*i7 - 0.0247161835d0*i8 - 0.651459845d0*i9
     /  - 0.000651965d0*i10 - 0.0026219995d0*i11 - 0.0017572685d0*i12
     /  + 0.0014196155d0*i13 + 105.2928430205d0*x14
     /  - 0.5090195889d0*x15 - 0.5559139461d0*x16 - 0.001884071d0*x17
     /  + 0.2028909215d0*x18 - 0.0113540425d0*x19
     /  - 0.1161260005d0*x20) + 0.64d0*sqr((-0.0514771145d0*i1)
     /  - 0.03061292d0*i2 + 0.006260734d0*i3 + 0.013002539d0*i4
     /  - 0.0421708295d0*i5 - 0.0008044325d0*i6 - 0.000825036d0*i7
     /  + 0.005531478d0*i8 - 0.0270582815d0*i9 + 0.0064221695d0*i10
     /  + 0.004151331d0*i11 + 0.001871516d0*i12 + 4.13035d-5*i13
     /  + 4.2749976192d0*x14 - 13.9639192437d0*x15
     /  - 10.8648952369d0*x16 + 0.0046091996d0*x17
     /  - 0.0617617291d0*x18 + 0.0109049916d0*x19 - 0.024829922d0*x20
     /  - 0.2711632143d0) 
      f = f
     /  + 0.0001d0*sqr(4.7368865d0
     /  + (-0.0897609185d0*i1) - 0.1624998775d0*i2 + 0.0009385285d0*i3
     /  - 0.0074307775d0*i4 - 0.103676397d0*i5 - 0.1419148255d0*i6
     /  - 0.3225769945d0*i7 - 0.301807927d0*i8 - 0.227580911d0*i9
     /  + 0.0055520845d0*i10 + 0.007123082d0*i11 + 0.02199827d0*i12
     /  - 0.0127438825d0*i13 - 28.5532641368d0*x14
     /  + 3.7291549175d0*x15 - 5.1441052974d0*x16 + 0.1161311806d0*x17
     /  - 1.4551474166d0*x18 + 0.7094975709d0*x19
     /  - 43.6065360868d0*x20) + 0.16d0*sqr(2.351853064d0*i1
     /  + 0.0475076955d0*i2 + 0.0538944355d0*i3 + 0.2212872085d0*i4
     /  + 2.540943914d0*i5 + 1.5675347875d0*i6 + 1.0799539255d0*i7
     /  + 0.903473387d0*i8 - 0.2321048945d0*i9 + 0.1721659125d0*i10
     /  + 0.1107992685d0*i11 + 0.0697935925d0*i12 + 0.0156465845d0*i13
     /  - 74.0327234359d0*x14 + 59.0811380719d0*x15
     /  + 22.6183807248d0*x16 - 0.8777959059d0*x17
     /  + 3.7972647124d0*x18 - 3.4732150542d0*x19
     /  + 35.9883905408d0*x20 - 14.6237193582d0)
      f = f
     /  + sqr(5.7049230075d0*i1 + 1.087048874d0*i2 - 0.051060961d0*i3
     /  - 0.0384222715d0*i4 + 5.7455217605d0*i5 + 1.704867866d0*i6
     /  + 1.079913519d0*i7 + 0.860020646d0*i8 + 0.1585546095d0*i9
     /  - 0.0005926645d0*i10 - 0.0230619655d0*i11 - 0.007758865d0*i12
     /  - 0.0056915385d0*i13 + 299.4383227892d0*x14
     /  - 7.4791629824d0*x15 + 15.0249048147d0*x16
     /  - 0.7189464072d0*x17 + 1.1858655471d0*x18 - 0.8355843028d0*x19
     /  + 11.3520280307d0*x20 - 4.742827527d0) + sqr(8.7874647257d0
     /  + (-0.767882249d0*i1) - 0.3182543715d0*i2 - 0.095124589d0*i3
     /  - 0.023431931d0*i4 - 0.9177503655d0*i5 - 0.455981348d0*i6
     /  - 0.322216701d0*i7 - 0.38188395d0*i8 - 0.0547428535d0*i9
     /  + 0.000720073d0*i10 - 0.0731604515d0*i11 - 0.0401740865d0*i12
     /  - 0.0044120005d0*i13 - 25.642445996d0*x14 + 6.1510841152d0*x15
     /  + 17.3139236759d0*x16 + 0.0327173388d0*x17
     /  + 0.3041107825d0*x18 + 0.4167065057d0*x19 - 8.389949878d0*x20)
      f = f
     /  + 0.64d0*sqr(28.7139260236d0 + (-0.764181681d0*i1)
     /  - 2.319797961d0*i2 - 0.002949867d0*i3 - 0.0006818695d0*i4
     /  - 0.7871441575d0*i5 - 0.07397488d0*i6 - 0.03949846d0*i7
     /  - 0.053711795d0*i8 - 1.25511994d0*i9 - 0.00176058d0*i10
     /  - 0.0039980095d0*i11 - 0.002605087d0*i12 + 0.002351659d0*i13
     /  + 210.7366501966d0*x14 - 0.4820761867d0*x15
     /  - 1.5088768249d0*x16 - 0.0334770967d0*x17 + 0.57319738d0*x18
     /  - 0.0590174758d0*x19 + 0.0028596741d0*x20)
     /  + 0.64d0*sqr(0.3457787122d0 + (-0.080852799d0*i1)
     /  - 0.0620560285d0*i2 + 0.0047490915d0*i3 + 0.0097168905d0*i4
     /  - 0.082578817d0*i5 - 0.009901403d0*i6 - 0.0008208965d0*i7
     /  + 0.008941979d0*i8 - 0.048754131d0*i9 + 0.003330363d0*i10
     /  + 0.001953307d0*i11 + 0.0008350075d0*i12 - 4.9406d-5*i13
     /  + 5.6620080256d0*x14 - 10.7222556951d0*x15
     /  - 8.0483203578d0*x16 + 0.0160387494d0*x17 - 0.1211418715d0*x18
     /  + 0.0539193344d0*x19 - 0.6024547036d0*x20)
           f = f
     /  + 0.16d0*sqr(3.7507480125d0*i1 + 0.458155665d0*i2
     /  + 0.09476643d0*i3 + 0.356047375d0*i4 + 4.3456212335d0*i5
     /  + 2.9555898075d0*i6 + 2.203184575d0*i7 + 2.032413179d0*i8
     /  - 0.113621504d0*i9 + 0.264890639d0*i10 + 0.178028241d0*i11
     /  + 0.096127387d0*i12 + 0.0428862195d0*i13 - 56.342960691d0*x14
     /  + 88.7586686673d0*x15 + 31.5826614981d0*x16
     /  - 1.3557460277d0*x17 + 3.9043216717d0*x18 - 8.0614504732d0*x19
     /  + 122.9145364338d0*x20 - 30.9984760322d0)
     /  + sqr(11.216501803d0*i1 + 1.982662974d0*i2 - 0.0667485895d0*i3
     /  - 0.058741875d0*i4 + 11.560799005d0*i5 + 3.7684806815d0*i6
     /  + 2.4393807055d0*i7 + 2.1956613885d0*i8 + 0.0863979835d0*i9
     /  + 0.001934737d0*i10 - 0.024087294d0*i11 - 0.001632711d0*i12
     /  - 0.009738491d0*i13 + 604.6261109412d0*x14
     /  - 31.8275450762d0*x15 + 22.3021114905d0*x16
     /  - 1.1078810785d0*x17 - 0.0513668537d0*x18 - 1.9954801737d0*x19
     /  + 28.0530826925d0*x20 - 11.3598350491d0) 
      f = f
     /  + sqr(12.1379962226d0
     /  + (-1.1385085245d0*i1) - 0.45570734d0*i2 - 0.113694448d0*i3
     /  - 0.0153716275d0*i4 - 1.3081837135d0*i5 - 0.709967918d0*i6
     /  - 0.5774704725d0*i7 - 0.753594348d0*i8 - 0.1272211635d0*i9
     /  + 0.00898244d0*i10 - 0.0823101755d0*i11 - 0.039941941d0*i12
     /  - 0.0071174395d0*i13 - 54.2871786886d0*x14
     /  + 1.6486577747d0*x15 + 9.9342805153d0*x16 - 0.0494461107d0*x17
     /  + 1.59320066d0*x18 + 0.6872677378d0*x19 - 21.0483328068d0*x20)
     /  + 0.64d0*sqr(49.277241262d0 + (-1.0815377325d0*i1)
     /  - 3.969046141d0*i2 - 0.0054930985d0*i3 - 0.0075940525d0*i4
     /  - 1.0980598035d0*i5 - 0.067120257d0*i6 - 0.0383726215d0*i7
     /  - 0.073066323d0*i8 - 2.133550279d0*i9 - 0.0050301395d0*i10
     /  - 0.006851101d0*i11 - 0.002614798d0*i12 + 0.004457869d0*i13
     /  + 378.332229536d0*x14 - 2.0382852627d0*x15
     /  - 3.8306759867d0*x16 - 0.0638064923d0*x17 + 0.8796449423d0*x18
     /  - 0.1901924983d0*x19 + 0.0196078677d0*x20)
      f = f
     /  + 0.64d0*sqr(0.028148446d0*i2 - 0.0651563965d0*i1
     /  + 0.0018648095d0*i3 + 0.002823421d0*i4 - 0.093876486d0*i5
     /  - 0.0350156415d0*i6 - 0.0111624665d0*i7 + 0.0053830125d0*i8
     /  + 0.006522766d0*i9 - 0.002605269d0*i10 - 0.000843613d0*i11
     /  + 0.001193875d0*i12 - 0.0013447615d0*i13 - 7.4785361452d0*x14
     /  - 6.3098285835d0*x15 - 3.0022136691d0*x16 + 0.0557080781d0*x17
     /  - 0.4336150459d0*x18 + 0.2358490882d0*x19 - 5.3316404952d0*x20
     /  - 0.3252071332d0) + sqr(6.1126533342d0 + 0.0317858555d0*i1
     /  - 0.1051443205d0*i2 - 0.096462143d0*i3 - 0.045430424d0*i4
     /  + 0.020281092d0*i5 + 0.023390574d0*i6 + 0.01580318d0*i7
     /  + 0.0114450895d0*i8 + 0.0092964165d0*i9 - 0.0078173725d0*i10
     /  - 0.089631552d0*i11 - 0.055244646d0*i12 + 0.0016175245d0*i13
     /  + 1.3652462464d0*x14 + 7.9428825848d0*x15
     /  + 34.7388067135d0*x16 + 0.0823525777d0*x17
     /  - 1.6195043446d0*x18 + 0.0909955211d0*x19
     /  - 0.0850371218d0*x20) 
      f = f
     /  + 0.64d0*sqr(0.033989164d0*i2
     /  - 0.0052672415d0*i1 + 0.017866745d0*i3 + 0.0315887705d0*i4
     /  - 0.005897631d0*i5 - 0.005261878d0*i6 - 0.0085025995d0*i7
     /  - 0.001053714d0*i8 + 0.0078685245d0*i9 + 0.018570477d0*i10
     /  + 0.01615421d0*i11 + 0.010168417d0*i12 + 1.1835d-5*i13
     /  - 0.54804063d0*x14 - 35.4912339934d0*x15
     /  - 29.5664987967d0*x16 - 0.0180559302d0*x17
     /  + 0.1599995255d0*x18 - 0.0030419667d0*x19 + 0.0044670753d0*x20
     /  - 2.3683307173d0) + 0.0001d0*sqr(7.6499767981d0
     /  + (-0.285751077d0*i1) - 0.2286544155d0*i2 - 0.0092742805d0*i3
     /  - 0.017270749d0*i4 - 0.557719025d0*i5 - 0.527678006d0*i6
     /  - 0.4490909105d0*i7 - 0.566809924d0*i8 - 0.1113151645d0*i9
     /  + 0.002509125d0*i10 + 0.0240409445d0*i11 + 0.0332995885d0*i12
     /  + 0.0005023325d0*i13 - 24.1502370784d0*x14 + 3.590505155d0*x15
     /  + 7.3127021637d0*x16 - 0.3184833839d0*x17 + 4.5843524774d0*x18
     /  + 1.6594965528d0*x19 - 39.2593229915d0*x20)
      f = f
     /  + 0.16d0*sqr(0.6259296035d0*i1 - 0.0385192615d0*i2
     /  + 0.011335146d0*i3 + 0.0595625755d0*i4 + 0.516320457d0*i5
     /  + 0.2172945335d0*i6 + 0.122692083d0*i7 + 0.0707461115d0*i8
     /  - 0.106421262d0*i9 + 0.048755906d0*i10 + 0.035718339d0*i11
     /  + 0.03174446d0*i12 + 0.0060134665d0*i13 - 26.037191031d0*x14
     /  + 18.9235979398d0*x15 + 6.7656627646d0*x16
     /  - 0.4166604188d0*x17 + 4.1351334135d0*x18 - 0.3816674126d0*x19
     /  + 1.1769320486d0*x20 - 2.5260390338d0) + sqr(6.4101559959d0
     /  + 0.5268906675d0*i1 - 0.03534374d0*i2 - 0.1077144425d0*i3
     /  - 0.054504566d0*i4 + 0.4304530885d0*i5 + 0.09039341d0*i6
     /  + 0.0552354765d0*i7 + 0.0293873515d0*i8 + 0.0280528975d0*i9
     /  - 0.0087731315d0*i10 - 0.093695734d0*i11 - 0.051643065d0*i12
     /  + 0.003015857d0*i13 + 24.5823703006d0*x14 + 9.3387785302d0*x15
     /  + 38.5763378184d0*x16 - 0.0594883815d0*x17
     /  - 0.2623967618d0*x18 + 0.1019703287d0*x19 - 0.11159399d0*x20)
      f = f
     /  + sqr(8.0717357197d0 + (-0.7948671925d0*i1)
     /  - 0.3460818955d0*i2 - 0.085806687d0*i3 - 0.0252604745d0*i4
     /  - 0.7590537325d0*i5 - 0.165969884d0*i6 - 0.0782992405d0*i7
     /  - 0.0661126925d0*i8 - 0.0750931945d0*i9 - 0.0059355275d0*i10
     /  - 0.0847310985d0*i11 - 0.058233985d0*i12 - 0.005945752d0*i13
     /  - 10.8339562621d0*x14 + 2.3920432845d0*x15
     /  + 23.8770409229d0*x16 + 0.2047719702d0*x17
     /  - 1.6516894952d0*x18 + 0.1550154879d0*x19
     /  - 1.3059803643d0*x20) + 0.64d0*sqr(5.8701212763d0
     /  + (-0.228867861d0*i1) - 0.4698664175d0*i2 - 0.0023900005d0*i3
     /  + 0.0024364325d0*i4 - 0.2172897715d0*i5 - 0.016597804d0*i6
     /  - 0.009588962d0*i7 - 0.0061765265d0*i8 - 0.2603811455d0*i9
     /  + 0.0004858685d0*i10 - 0.004159509d0*i11 - 0.004121931d0*i12
     /  + 0.000298938d0*i13 + 40.4729903906d0*x14 - 2.6146532755d0*x15
     /  - 0.58046538d0*x16 + 0.0140750568d0*x17 - 0.1015166663d0*x18
     /  + 0.0010341359d0*x19 - 0.030965449d0*x20)
      f = f
     /  + 0.64d0*sqr(0.009550856d0*i2 - 0.0342921425d0*i1
     /  + 0.016631177d0*i3 + 0.0310660835d0*i4 - 0.022001782d0*i5
     /  - 0.0029250805d0*i6 - 0.0070445305d0*i7 + 0.000877894d0*i8
     /  - 0.008584573d0*i9 + 0.0176015355d0*i10 + 0.014367991d0*i11
     /  + 0.008043187d0*i12 - 0.0001638225d0*i13 + 2.4205682873d0*x14
     /  - 33.7265709729d0*x15 - 27.9573268564d0*x16
     /  - 0.0053157955d0*x17 - 0.0159966559d0*x18 - 0.0026557276d0*x19
     /  + 0.0318094448d0*x20 - 1.9000693551d0)
     /  + 0.0001d0*sqr(15.4460966615d0 + (-0.511470251d0*i1)
     /  - 0.5527304855d0*i2 - 0.0188901635d0*i3 - 0.0279234315d0*i4
     /  - 0.947739149d0*i5 - 0.9753153575d0*i6 - 0.808363063d0*i7
     /  - 1.13970515d0*i8 - 0.3559241005d0*i9 + 0.0142163485d0*i10
     /  + 0.0431253845d0*i11 + 0.057276262d0*i12 - 0.009860131d0*i13
     /  - 61.3668479856d0*x14 + 8.9259752968d0*x15
     /  + 14.4396522548d0*x16 - 0.2530977597d0*x17
     /  + 4.2680343521d0*x18 + 3.2764060344d0*x19
     /  - 85.9662948622d0*x20) 
      f = f
     /  + 0.16d0*sqr(2.2844043355d0*i1
     /  - 0.1399431125d0*i2 + 0.0431528725d0*i3 + 0.222604724d0*i4
     /  + 2.120035789d0*i5 + 1.04828801d0*i6 + 0.6401662245d0*i7
     /  + 0.394639748d0*i8 - 0.366214066d0*i9 + 0.1803571335d0*i10
     /  + 0.132783251d0*i11 + 0.1070122555d0*i12 + 0.0210206555d0*i13
     /  - 94.9931943965d0*x14 + 67.8238048618d0*x15
     /  + 25.5020193615d0*x16 - 1.2641528796d0*x17
     /  + 8.6854605662d0*x18 - 1.9537231543d0*x19 + 9.2121201535d0*x20
     /  - 10.2591752001d0) + sqr(7.2545035424d0 + 2.1747528685d0*i1
     /  + 0.193681228d0*i2 - 0.1407010965d0*i3 - 0.0797814575d0*i4
     /  + 1.936174476d0*i5 + 0.3787264945d0*i6 + 0.21389148d0*i7
     /  + 0.0936619445d0*i8 + 0.0774652165d0*i9 - 0.010013703d0*i10
     /  - 0.1003903705d0*i11 - 0.0417979795d0*i12 + 0.0055375225d0*i13
     /  + 106.9691650219d0*x14 + 12.3298154856d0*x15
     /  + 47.7959005982d0*x16 - 0.3806894476d0*x17
     /  + 1.3003567452d0*x18 + 0.097041998d0*x19 - 0.4923380619d0*x20)
      f = f
     /  + sqr(13.9503196684d0 + (-1.2796098975d0*i1)
     /  - 0.552603451d0*i2 - 0.1567987545d0*i3 - 0.047723284d0*i4
     /  - 1.4190338435d0*i5 - 0.461374741d0*i6 - 0.249754819d0*i7
     /  - 0.234290462d0*i8 - 0.1020371535d0*i9 - 0.010105613d0*i10
     /  - 0.146392447d0*i11 - 0.089789288d0*i12 - 0.007253222d0*i13
     /  - 27.2483068958d0*x14 + 6.8357802598d0*x15
     /  + 39.7335986547d0*x16 + 0.1837391147d0*x17
     /  - 0.6774943126d0*x18 + 0.4024494055d0*x19
     /  - 4.4688504034d0*x20) + 0.64d0*sqr(14.3917445971d0
     /  + (-0.5026710155d0*i1) - 1.152873236d0*i2 - 0.005829231d0*i3
     /  + 0.0039832535d0*i4 - 0.5113304585d0*i5 - 0.04499581d0*i6
     /  - 0.021122372d0*i7 - 0.0161181505d0*i8 - 0.6361102445d0*i9
     /  + 0.000572985d0*i10 - 0.00931126d0*i11 - 0.007258385d0*i12
     /  + 0.0010945025d0*i13 + 99.9026997721d0*x14
     /  - 4.2794508863d0*x15 - 0.289880094d0*x16 + 0.0048704372d0*x17
     /  + 0.1224131652d0*x18 + 0.0060441225d0*x19
     /  - 0.1593517642d0*x20) 
      f = f
     /  + 0.64d0*sqr((-0.111009209d0*i1)
     /  - 0.0584675225d0*i2 + 0.014113332d0*i3 + 0.028651155d0*i4
     /  - 0.083920878d0*i5 - 0.000710975d0*i6 - 0.0042695005d0*i7
     /  + 0.0081981555d0*i8 - 0.05512171d0*i9 + 0.0145064195d0*i10
     /  + 0.0097212705d0*i11 + 0.0037279435d0*i12 - 0.0004113785d0*i13
     /  + 8.9108175175d0*x14 - 29.2610239684d0*x15
     /  - 24.0324296338d0*x16 + 0.0145771681d0*x17
     /  - 0.1432295058d0*x18 + 0.0127355322d0*x19 + 0.0028635772d0*x20
     /  - 0.6911236333d0) + 0.0001d0*sqr(17.2005159204d0
     /  + (-0.4553533515d0*i1) - 0.676775996d0*i2 - 0.0228022245d0*i3
     /  - 0.0294431165d0*i4 - 0.7723862055d0*i5 - 0.8887341235d0*i6
     /  - 0.8219836925d0*i7 - 1.2237739895d0*i8 - 0.3475233705d0*i9
     /  + 0.0370876295d0*i10 + 0.047781824d0*i11 + 0.0483253485d0*i12
     /  - 0.0183250895d0*i13 - 83.5475857469d0*x14
     /  + 17.5444503235d0*x15 + 24.0403945324d0*x16
     /  - 0.1697469511d0*x17 + 6.6072373388d0*x18 + 3.702054964d0*x19
     /  - 115.1114277859d0*x20) 
      f = f
     /  + 0.16d0*sqr(4.618140487d0*i1
     /  - 0.0916232685d0*i2 + 0.094751447d0*i3 + 0.4485242155d0*i4
     /  + 4.8597062525d0*i5 + 2.8438995665d0*i6 + 1.826341914d0*i7
     /  + 1.333624514d0*i8 - 0.5992294715d0*i9 + 0.3596517595d0*i10
     /  + 0.27229822d0*i11 + 0.190668727d0*i12 + 0.0421864585d0*i13
     /  - 172.3571556156d0*x14 + 128.6111684769d0*x15
     /  + 47.5980282546d0*x16 - 2.0864881272d0*x17
     /  + 10.0774182155d0*x18 - 5.8968747535d0*x19
     /  + 41.6695373549d0*x20 - 25.6825534808d0) + sqr(8.6404612843d0
     /  + 5.235269312d0*i1 + 0.632699884d0*i2 - 0.1913541085d0*i3
     /  - 0.1149344215d0*i4 + 5.0636225055d0*i5 + 1.132259619d0*i6
     /  + 0.5993639245d0*i7 + 0.2484253035d0*i8 + 0.1283287165d0*i9
     /  - 0.006904755d0*i10 - 0.101055604d0*i11 - 0.030627911d0*i12
     /  + 0.004428971d0*i13 + 279.6115378044d0*x14
     /  + 12.6478515168d0*x15 + 58.2338999026d0*x16
     /  - 0.7407788996d0*x17 + 1.6954162324d0*x18 - 0.0281070188d0*x19
     /  - 2.7233199693d0*x20) 
      f = f
     /  + sqr(17.9484831771d0
     /  + (-1.478823999d0*i1) - 0.6413847555d0*i2 - 0.212228361d0*i3
     /  - 0.061540295d0*i4 - 1.8509705105d0*i5 - 0.85393365d0*i6
     /  - 0.5149178045d0*i7 - 0.5980938735d0*i8 - 0.081891842d0*i9
     /  - 0.0093968465d0*i10 - 0.1774021395d0*i11 - 0.0973620845d0*i12
     /  - 0.0068482655d0*i13 - 51.6252785538d0*x14
     /  + 13.0257273562d0*x15 + 45.5497603331d0*x16
     /  + 0.0271465582d0*x17 + 0.4765352422d0*x18 + 0.7456509784d0*x19
     /  - 11.702389109d0*x20) + 0.64d0*sqr(27.6492094586d0
     /  + (-0.8103289d0*i1) - 2.215407372d0*i2 - 0.011008194d0*i3
     /  - 0.000463739d0*i4 - 0.8716282865d0*i5 - 0.0900988615d0*i6
     /  - 0.0326389855d0*i7 - 0.039868993d0*i8 - 1.2169455675d0*i9
     /  - 0.003183191d0*i10 - 0.014971729d0*i11 - 0.0091964245d0*i12
     /  + 0.0020095595d0*i13 + 191.7962056686d0*x14
     /  - 5.184667443d0*x15 + 1.2439454336d0*x16 - 0.0218678855d0*x17
     /  + 0.3849436864d0*x18 + 0.0262492576d0*x19
     /  - 0.9654915869d0*x20) 
      f = f
     /  + 0.64d0*sqr(0.7313866655d0
     /  + (-0.184813142d0*i1) - 0.139720104d0*i2 + 0.010762115d0*i3
     /  + 0.024740539d0*i4 - 0.1795157455d0*i5 - 0.015650192d0*i6
     /  - 0.0056030665d0*i7 + 0.016430629d0*i8 - 0.109384452d0*i9
     /  + 0.0101130235d0*i10 + 0.0038452165d0*i11 + 0.000516937d0*i12
     /  - 0.000514779d0*i13 + 13.8500336434d0*x14
     /  - 22.6807804628d0*x15 - 18.3863230016d0*x16
     /  + 0.0302860152d0*x17 - 0.1454486567d0*x18 + 0.0762093249d0*x19
     /  - 0.5480081939d0*x20) + 0.16d0*sqr(7.406953455d0*i1
     /  + 0.449667181d0*i2 + 0.1883237965d0*i3 + 0.702151737d0*i4
     /  + 8.523271089d0*i5 + 5.6149312945d0*i6 + 3.6576214595d0*i7
     /  + 3.2092944395d0*i8 - 0.794226566d0*i9 + 0.56558762d0*i10
     /  + 0.4319327775d0*i11 + 0.283062983d0*i12 + 0.0781383255d0*i13
     /  - 200.1847266898d0*x14 + 184.8153459101d0*x15
     /  + 57.8684929964d0*x16 - 2.7792085501d0*x17
     /  + 9.0767134995d0*x18 - 13.942861566d0*x19
     /  + 127.0169941145d0*x20 - 52.5425602964d0)
      f = f
     /  + sqr(11.2591544766d0 + 9.964809299d0*i1 + 1.181620062d0*i2
     /  - 0.255968837d0*i3 - 0.146664661d0*i4 + 10.1646556645d0*i5
     /  + 2.622853141d0*i6 + 1.3148092885d0*i7 + 0.63106153d0*i8
     /  - 0.009629057d0*i9 + 0.0108395955d0*i10 - 0.0996911725d0*i11
     /  - 0.016998508d0*i12 - 0.0014013825d0*i13
     /  + 557.8529479327d0*x14 + 3.0143555386d0*x15
     /  + 65.3736501251d0*x16 - 1.0800203847d0*x17
     /  + 2.8399031977d0*x18 - 0.2294386604d0*x19
     /  - 14.7469110313d0*x20) + sqr(21.6114276014d0
     /  + (-1.897134069d0*i1) - 0.6795249255d0*i2 - 0.2613036645d0*i3
     /  - 0.062033767d0*i4 - 2.358580266d0*i5 - 1.272986641d0*i6
     /  - 0.8433429395d0*i7 - 1.201901404d0*i8 + 0.0056869025d0*i9
     /  - 0.004286696d0*i10 - 0.187669312d0*i11 - 0.096314746d0*i12
     /  - 0.007816812d0*i13 - 94.5375544285d0*x14
     /  + 18.2250544427d0*x15 + 38.0675842791d0*x16
     /  - 0.2238422448d0*x17 + 2.001336626d0*x18 + 1.0138181445d0*x19
     /  - 23.1438722685d0*x20) 
      f = f
     /  + 0.64d0*sqr(46.7782203241d0
     /  + (-1.111773407d0*i1) - 3.697985697d0*i2 - 0.0202377865d0*i3
     /  - 0.018896425d0*i4 - 1.2339436105d0*i5 - 0.1530366085d0*i6
     /  - 0.039743396d0*i7 - 0.0947969095d0*i8 - 2.0056969535d0*i9
     /  - 0.0159831655d0*i10 - 0.021190604d0*i11 - 0.0115064105d0*i12
     /  + 0.001101444d0*i13 + 327.6551151698d0*x14
     /  - 4.6492502074d0*x15 + 6.663784443d0*x16 - 0.0500060739d0*x17
     /  + 0.6775119117d0*x18 + 0.1602738202d0*x19
     /  - 6.4757521432d0*x20) + 0.64d0*sqr(0.9116644463d0
     /  + (-0.2110266815d0*i1) - 0.109185322d0*i2 + 0.006558688d0*i3
     /  + 0.019550434d0*i4 - 0.256796001d0*i5 - 0.06683154d0*i6
     /  - 0.020682334d0*i7 + 0.0026320765d0*i8 - 0.0872868925d0*i9
     /  + 0.0036646015d0*i10 - 0.000791246d0*i11 - 0.0014184685d0*i12
     /  - 0.002472875d0*i13 + 4.7797259826d0*x14 - 14.3122665377d0*x15
     /  - 10.9646223177d0*x16 + 0.043573141d0*x17 - 0.3045615131d0*x18
     /  + 0.279954818d0*x19 - 3.3767931789d0*x20)
           f = f
     /  + sqr(13.8496391201d0 + 0.0674466695d0*i1 - 0.273120708d0*i2
     /  - 0.2109848875d0*i3 - 0.094967628d0*i4 + 0.043439707d0*i5
     /  + 0.0478356675d0*i6 + 0.031270937d0*i7 + 0.0214571585d0*i8
     /  + 0.007339714d0*i9 - 0.016632915d0*i10 - 0.2021134565d0*i11
     /  - 0.130790094d0*i12 + 0.0048801475d0*i13 + 3.5498897321d0*x14
     /  + 16.1561586043d0*x15 + 76.1755770646d0*x16
     /  + 0.2165709541d0*x17 - 4.4161081307d0*x18 + 0.183857392d0*x19
     /  + 0.3055886284d0*x20) + 0.64d0*sqr(0.0694581485d0*i2
     /  - 0.008056463d0*i1 + 0.0324356165d0*i3 + 0.0502421675d0*i4
     /  - 0.0102589985d0*i5 - 0.00759041d0*i6 - 0.013265267d0*i7
     /  - 0.0008355915d0*i8 + 0.016504291d0*i9 + 0.0301753915d0*i10
     /  + 0.0311616305d0*i11 + 0.0220518415d0*i12 + 6.7496d-5*i13
     /  - 1.055738354d0*x14 - 56.937097335d0*x15 - 50.3080442297d0*x16
     /  - 0.0403968632d0*x17 + 0.4781256075d0*x18 - 0.004820015d0*x19
     /  - 0.0882113129d0*x20 - 4.1276099743d0)
           f = f
     /  + 0.0001d0*sqr(10.7794007035d0 + (-0.5137502175d0*i1)
     /  - 0.218538634d0*i2 - 0.0213043065d0*i3 - 0.0270029355d0*i4
     /  - 1.1086628855d0*i5 - 1.0184171705d0*i6 - 0.768344378d0*i7
     /  - 0.914586565d0*i8 - 0.046305122d0*i9 - 0.014359072d0*i10
     /  + 0.04382791d0*i11 + 0.0773060575d0*i12 + 0.01474787d0*i13
     /  - 41.3982537441d0*x14 - 0.4939416253d0*x15
     /  + 13.7491137587d0*x16 - 0.9135159317d0*x17
     /  + 9.7126592931d0*x18 + 2.8528519857d0*x19
     /  - 42.524194597d0*x20) + 0.16d0*sqr(0.9793612055d0*i1
     /  - 0.0591325545d0*i2 + 0.011952338d0*i3 + 0.093894205d0*i4
     /  + 0.7173210455d0*i5 + 0.2676442735d0*i6 + 0.147256564d0*i7
     /  + 0.0680553365d0*i8 - 0.1471243475d0*i9 + 0.079647193d0*i10
     /  + 0.059365138d0*i11 + 0.069333342d0*i12 + 0.0168057565d0*i13
     /  - 44.6850648185d0*x14 + 30.1445830407d0*x15
     /  + 12.9990890991d0*x16 - 0.9499115318d0*x17
     /  + 11.4382579566d0*x18 - 0.4170309667d0*x19
     /  + 0.3784044555d0*x20 - 4.2220465925d0) 
      f = f
     /  + sqr(15.175268689d0
     /  + 0.5010727655d0*i1 - 0.247667256d0*i2 - 0.23459716d0*i3
     /  - 0.11335545d0*i4 + 0.3377150225d0*i5 + 0.065401443d0*i6
     /  + 0.0420303575d0*i7 + 0.0160300255d0*i8 + 0.0264429305d0*i9
     /  - 0.0196360735d0*i10 - 0.2146736475d0*i11 - 0.123294925d0*i12
     /  + 0.0101524395d0*i13 + 24.318483031d0*x14
     /  + 19.9554555304d0*x15 + 86.0701095092d0*x16
     /  - 0.0079381579d0*x17 - 1.2317154197d0*x18 + 0.2597808541d0*x19
     /  + 0.04654783d0*x20) + sqr(13.6543378053d0
     /  + (-1.2838488795d0*i1) - 0.5551058575d0*i2 - 0.149457585d0*i3
     /  - 0.040007224d0*i4 - 1.182257265d0*i5 - 0.2209015925d0*i6
     /  - 0.094862519d0*i7 - 0.0763533995d0*i8 - 0.121153187d0*i9 
     /  - 0.0107908135d0*i10 - 0.16079153d0*i11 - 0.1253722d0*i12
     /  - 0.015949014d0*i13 - 16.8998454606d0*x14 + 2.6515703721d0*x15
     /  + 44.5383700882d0*x16 + 0.4270802076d0*x17
     /  - 4.2406883369d0*x18 + 0.1817822414d0*x19
     /  - 1.2990884338d0*x20) 
      f = f
     /  + 0.64d0*sqr(5.6877270607d0
     /  + (-0.2546583695d0*i1) - 0.449936651d0*i2 - 0.0053362555d0*i3
     /  + 0.006134521d0*i4 - 0.230405082d0*i5 - 0.0151077095d0*i6
     /  - 0.0085447895d0*i7 - 0.0044800215d0*i8 - 0.2519122025d0*i9
     /  + 0.0022406695d0*i10 - 0.008852171d0*i11 - 0.0104222235d0*i12
     /  - 0.0007739485d0*i13 + 38.4978917657d0*x14
     /  - 5.7154043223d0*x15 - 1.3118401345d0*x16 + 0.0327195254d0*x17
     /  - 0.3675197017d0*x18 + 0.0006192276d0*x19
     /  + 0.0084917392d0*x20) + 0.64d0*sqr(0.030605694d0*i2
     /  - 0.0491363445d0*i1 + 0.0302034345d0*i3 + 0.049583977d0*i4
     /  - 0.027988031d0*i5 - 0.0039392965d0*i6 - 0.0123137955d0*i7
     /  + 0.000545817d0*i8 - 0.0095316915d0*i9 + 0.0285949605d0*i10
     /  + 0.0280465395d0*i11 + 0.0170867775d0*i12 - 0.0007030565d0*i13
     /  + 3.0552737446d0*x14 - 54.2499870768d0*x15
     /  - 47.9264759598d0*x16 - 0.0082705764d0*x17
     /  - 0.0605154328d0*x18 - 0.0067698022d0*x19 - 0.0545052962d0*x20
     /  - 3.3913450716d0) 
      f = f
     /  + 0.0001d0*sqr(18.7892368515d0
     /  + (-0.7694633965d0*i1) - 0.4355312045d0*i2 - 0.0488836935d0*i3
     /  - 0.027666886d0*i4 - 1.600289504d0*i5 - 1.7426443875d0*i6
     /  - 1.2917144825d0*i7 - 1.75748056d0*i8 - 0.00255886d0*i9
     /  - 0.014259234d0*i10 + 0.0937480785d0*i11 + 0.1259311145d0*i12
     /  + 0.016358391d0*i13 - 109.3000284295d0*x14
     /  + 2.1450969802d0*x15 + 31.782591593d0*x16
     /  - 0.9893136845d0*x17 + 5.2409083648d0*x18 + 5.3829884111d0*x19
     /  - 87.3346786956d0*x20) + 0.16d0*sqr(3.53628911d0*i1
     /  - 0.3075807635d0*i2 + 0.0465820775d0*i3 + 0.342684345d0*i4
     /  + 2.98328657d0*i5 + 1.2953965085d0*i6 + 0.754547996d0*i7
     /  + 0.34161481d0*i8 - 0.593472301d0*i9 + 0.277775997d0*i10
     /  + 0.2399696045d0*i11 + 0.2414867125d0*i12 + 0.064008772d0*i13
     /  - 168.9033426052d0*x14 + 108.3885243362d0*x15
     /  + 48.348717818d0*x16 - 2.7970407623d0*x17
     /  + 22.0796840577d0*x18 - 2.1451176404d0*x19
     /  + 3.7963629845d0*x20 - 15.0414837509d0) 
      f = f
     /  + sqr(19.4397559466d0
     /  + 2.009941447d0*i1 - 0.1861945875d0*i2 - 0.3017193755d0*i3
     /  - 0.168344128d0*i4 + 1.4983470715d0*i5 + 0.136310519d0*i6
     /  + 0.0694050905d0*i7 - 0.039394104d0*i8 + 0.0659696605d0*i9
     /  - 0.02869975d0*i10 - 0.238467947d0*i11 - 0.0971560305d0*i12
     /  + 0.0244992115d0*i13 + 94.1107720449d0*x14
     /  + 28.998307874d0*x15+ 109.829171541d0*x16 - 0.4498027437d0*x17
     /  + 1.8390377019d0*x18 + 0.4832341831d0*x19
     /  - 1.7919794167d0*x20) + sqr(23.132764885d0
     /  + (-2.0461686755d0*i1) - 0.8764079085d0*i2 - 0.271296047d0*i3
     /  - 0.0808874645d0*i4 - 2.257098567d0*i5 - 0.6209283955d0*i6
     /  - 0.299362221d0*i7 - 0.246049027d0*i8 - 0.1632102325d0*i9
     /  - 0.0210457685d0*i10 - 0.284222393d0*i11 - 0.1896873825d0*i12
     /  - 0.01716775d0*i13 - 43.4189059559d0*x14 + 10.1252158257d0*x15
     /  + 77.9788177737d0*x16 + 0.3370546232d0*x17
     /  - 1.4549710707d0*x18 + 0.489493217d0*x19 - 3.9857951868d0*x20)
      f = f
     /  + 0.64d0*sqr(13.8564717531d0 + (-0.5708432225d0*i1)
     /  - 1.095931107d0*i2 - 0.012724143d0*i3 + 0.01199305d0*i4
     /  - 0.572353336d0*i5 - 0.042924264d0*i6 - 0.0176092305d0*i7
     /  - 0.00800208d0*i8 - 0.6144492035d0*i9 + 0.00457024d0*i10
     /  - 0.0208713725d0*i11 - 0.019006339d0*i12 - 0.0001619055d0*i13
     /  + 93.8857141632d0*x14 - 9.7411135156d0*x15
     /  - 0.5732088498d0*x16 + 0.0199212507d0*x17 + 0.0208043091d0*x18
     /  + 0.0175764412d0*x19 - 0.0815881622d0*x20)
     /  + 0.64d0*sqr((-0.180403d0*i1) - 0.0702813d0*i2
     /  + 0.0251691575d0*i3 + 0.048162819d0*i4 - 0.1141783355d0*i5
     /  + 0.0029488115d0*i6 - 0.009223653d0*i7 + 0.007851009d0*i8
     /  - 0.077631666d0*i9 + 0.025003103d0*i10 + 0.019261635d0*i11
     /  + 0.0058709295d0*i12 - 0.0021685425d0*i13
     /  + 15.3248475624d0*x14 - 47.2905178532d0*x15
     /  - 41.8063079022d0*x16 + 0.0313039393d0*x17 - 0.296380168d0*x18
     /  + 0.0036803543d0*x19 + 0.006213577d0*x20 - 1.4654518443d0)
      f = f
     /  + 0.0001d0*sqr(18.425410362d0 + (-0.719616157d0*i1)
     /  - 0.523666554d0*i2 - 0.0607171225d0*i3 - 0.01814918d0*i4
     /  - 1.226889478d0*i5 - 1.539164395d0*i6 - 1.2435650355d0*i7
     /  - 1.910940936d0*i8 - 0.041479437d0*i9 + 0.0041559755d0*i10
     /  + 0.1173437575d0*i11 + 0.1061316675d0*i12 - 0.0125848165d0*i13
     /  - 162.9216743805d0*x14 + 0.6069838295d0*x15
     /  + 33.6263912566d0*x16 - 0.5818848984d0*x17
     /  + 0.4916767822d0*x18 + 5.9384033682d0*x19
     /  - 105.0147070331d0*x20) + 0.16d0*sqr(6.882858008d0*i1
     /  - 0.644614723d0*i2 + 0.095349398d0*i3 + 0.68983545d0*i4
     /  + 6.84901008d0*i5 + 3.606668796d0*i6 + 2.188213165d0*i7
     /  + 1.1783041315d0*i8 - 1.179518232d0*i9 + 0.557208377d0*i10
     /  + 0.5051752775d0*i11 + 0.4209247515d0*i12 + 0.1046966415d0*i13
     /  - 324.876865998d0*x14 + 211.7847928717d0*x15
     /  + 91.5487266435d0*x16 - 4.2419017625d0*x17
     /  + 21.9041455225d0*x18 - 6.4503519664d0*x19
     /  + 20.5350536277d0*x20 - 32.1842133879d0)
      f = f
     /  + sqr(27.0290256459d0 + 4.788488555d0*i1 - 0.0411959355d0*i2
     /  - 0.406715162d0*i3 - 0.2505341125d0*i4 + 4.168126559d0*i5
     /  + 0.446378373d0*i6 + 0.1844901235d0*i7 - 0.250524493d0*i8
     /  + 0.1261277575d0*i9 - 0.04078045d0*i10 - 0.2439294315d0*i11
     /  - 0.063135126d0*i12 + 0.0355148475d0*i13
     /  + 245.9820390329d0*x14 + 36.5783315848d0*x15
     /  + 136.0277393488d0*x16 - 0.8807902958d0*x17
     /  + 2.2707277859d0*x18 + 0.8479304948d0*x19
     /  - 9.1285738954d0*x20) + sqr(29.0548186711d0
     /  + (-2.1899726415d0*i1) - 1.044065816d0*i2 - 0.3661284485d0*i3
     /  - 0.119820894d0*i4 - 2.9502730155d0*i5 - 1.2142383625d0*i6
     /  - 0.622238086d0*i7 - 0.6184891045d0*i8 - 0.1429517835d0*i9
     /  - 0.030950434d0*i10 - 0.3518864435d0*i11 - 0.192991007d0*i12
     /  - 0.0072879225d0*i13 - 88.7963420677d0*x14
     /  + 20.3324025392d0*x15 + 94.9808940384d0*x16
     /  + 0.0105696349d0*x17 + 0.5364673412d0*x18 + 0.9038719013d0*x19
     /  - 9.6778384118d0*x20) 
      f = f
     /  + 0.64d0*sqr(26.3789577283d0
     /  + (-0.908398546d0*i1) - 2.0979196875d0*i2 - 0.0238680405d0*i3
     /  + 0.0118088375d0*i4 - 1.0266056985d0*i5 - 0.1071253445d0*i6
     /  - 0.0309497665d0*i7 - 0.020774723d0*i8 - 1.176669443d0*i9
     /  + 0.003179508d0*i10 - 0.035530854d0*i11 - 0.0228761855d0*i12
     /  + 0.001759738d0*i13 + 172.1680687341d0*x14
     /  - 10.8415575999d0*x15 + 3.6362070477d0*x16
     /  - 0.0132159164d0*x17 + 0.3076388785d0*x18 + 0.0826159866d0*x19
     /  - 0.8688992794d0*x20) + 0.64d0*sqr(0.9440674981d0
     /  + (-0.3253883465d0*i1) - 0.211369801d0*i2 + 0.0189858545d0*i3
     /  + 0.047148282d0*i4 - 0.2888165585d0*i5 - 0.010334731d0*i6
     /  - 0.0143057915d0*i7 + 0.0206198205d0*i8 - 0.1733067405d0*i9
     /  + 0.0219628245d0*i10 + 0.006274689d0*i11 - 0.003025459d0*i12
     /  - 0.0024153945d0*i13 + 27.1112542336d0*x14
     /  - 36.9200749555d0*x15 - 33.0774743145d0*x16
     /  + 0.0508171114d0*x17 - 0.1274755827d0*x18 + 0.0553021477d0*x19
     /  + 0.0013939617d0*x20) 
      f = f
     /  + 0.16d0*sqr(10.9068141335d0*i1
     /  - 0.7727538395d0*i2 + 0.19581792d0*i3 + 1.052979275d0*i4
     /  + 12.0159195425d0*i5 + 7.236590972d0*i6 + 4.530577682d0*i7
     /  + 2.8900492455d0*i8 - 1.866035536d0*i9 + 0.854841872d0*i10
     /  + 0.8231700365d0*i11 + 0.5870097045d0*i12 + 0.1277635455d0*i13
     /  - 471.431966531d0*x14 + 289.6009154816d0*x15
     /  + 122.1258853701d0*x16 - 5.3231652518d0*x17
     /  + 24.0625644277d0*x18 - 14.3501693276d0*x19
     /  + 38.5392409731d0*x20 - 58.0191890609d0)
     /  + sqr(38.0118455163d0 + 8.7601362425d0*i1 + 0.3182862155d0*i2
     /  - 0.5381625815d0*i3 - 0.347591992d0*i4 + 8.5852293185d0*i5
     /  + 1.318202739d0*i6 + 0.5069904325d0*i7 - 0.7225960135d0*i8
     /  + 0.242231739d0*i9 - 0.05479493d0*i10 - 0.2148920285d0*i11
     /  - 0.039052828d0*i12 + 0.031261165d0*i13 + 515.2918119641d0*x14
     /  + 41.5620366801d0*x15 + 149.9399579296d0*x16
     /  - 1.2697032171d0*x17 + 2.1796366891d0*x18 + 1.5710763787d0*x19
     /  - 30.6184678297d0*x20) 
      f = f
     /  + sqr(33.5710771107d0
     /  + (-2.364336654d0*i1) - 1.0052722425d0*i2 - 0.451261356d0*i3
     /  - 0.154132737d0*i4 - 3.374976999d0*i5 - 1.833446341d0*i6
     /  - 0.94898104d0*i7 - 1.309860072d0*i8 + 0.073816278d0*i9
     /  - 0.0414144275d0*i10 - 0.367161592d0*i11 - 0.1799739275d0*i12
     /  - 0.0029025985d0*i13 - 130.6618505398d0*x14
     /  + 31.8815027643d0*x15 + 98.4635347459d0*x16
     /  - 0.4392195739d0*x17 + 0.6030186151d0*x18 + 1.2678674023d0*x19
     /  - 17.8419259821d0*x20) + 0.64d0*sqr(44.2196893415d0
     /  + (-1.234734282d0*i1) - 3.4882533415d0*i2 - 0.0411539035d0*i3
     /  - 0.0071332145d0*i4 - 1.482158761d0*i5 - 0.239353483d0*i6
     /  - 0.064776008d0*i7 - 0.1130308055d0*i8 - 1.9447090535d0*i9
     /  - 0.012459452d0*i10 - 0.048707393d0*i11 - 0.025408127d0*i12
     /  - 0.001084523d0*i13 + 272.8953072747d0*x14
     /  - 8.2260585995d0*x15 + 13.3367849503d0*x16
     /  - 0.0210102051d0*x17 - 0.200858329d0*x18 + 0.3447937286d0*x19
     /  - 4.7324932298d0*x20)
      f = f
     /  + 0.64d0*sqr(2.3916082775d0
     /  + (-0.415114648d0*i1) - 0.3035360685d0*i2 + 0.012945497d0*i3
     /  + 0.0500068215d0*i4 - 0.46255903d0*i5 - 0.0533982275d0*i6
     /  - 0.0303665965d0*i7 + 0.029087564d0*i8 - 0.2392375415d0*i9
     /  + 0.0200435395d0*i10 - 0.0048996755d0*i11 - 0.0058795555d0*i12
     /  - 0.0026729225d0*i13 + 25.709095923d0*x14
     /  - 24.4731791748d0*x15 - 24.6131479194d0*x16
     /  + 0.0454106213d0*x17 - 0.0646065275d0*x18 + 0.1581190219d0*x19
     /  + 0.2116796041d0*x20) + sqr(24.6740164037d0
     /  + 0.1119885515d0*i1 - 0.560993803d0*i2 - 0.3617873735d0*i3
     /  - 0.152399953d0*i4 + 0.070513446d0*i5 + 0.0752481565d0*i6
     /  + 0.046780455d0*i7 + 0.030726857d0*i8 - 0.0149696225d0*i9
     /  - 0.026216377d0*i10 - 0.3575820375d0*i11 - 0.2457175935d0*i12
     /  + 0.011289311d0*i13 + 7.4688258927d0*x14 + 25.6140478631d0*x15
     /  + 128.5602665698d0*x16 + 0.4757541454d0*x17
     /  - 10.0833898265d0*x18 + 0.2812647597d0*x19
     /  + 1.3069721605d0*x20) 
      f = f
     /  + 0.64d0*sqr(0.12933288d0*i2
     /  - 0.01021592d0*i1 + 0.0539789275d0*i3 + 0.0710585955d0*i4
     /  - 0.015313992d0*i5 - 0.0084943675d0*i6 - 0.0175259045d0*i7
     /  + 0.001021425d0*i8 + 0.0327337815d0*i9 + 0.0439906545d0*i10
     /  + 0.0545485715d0*i11 + 0.043403716d0*i12 + 0.000282144d0*i13
     /  - 1.9200628335d0*x14 - 82.6218554875d0*x15
     /  - 77.7620621346d0*x16 - 0.0899689319d0*x17
     /  + 1.3246157882d0*x18 - 0.0060396204d0*x19 - 0.2836216482d0*x20
     /  - 6.5767760637d0) + 0.0001d0*sqr(13.4408088149d0
     /  + (-0.6676774165d0*i1) - 0.256938773d0*i2 - 0.0216677795d0*i3
     /  - 0.030757135d0*i4 - 1.892005214d0*i5 - 1.498163997d0*i6
     /  - 1.082418875d0*i7 - 0.983798823d0*i8 + 0.012554009d0*i9
     /  - 0.0151565575d0*i10 + 0.008301593d0*i11 + 0.136231692d0*i12
     /  + 0.0612978165d0*i13 - 32.7638050291d0*x14
     /  - 13.079882575d0*x15 + 16.4306490378d0*x16
     /  - 2.0852677276d0*x17 + 25.0395554658d0*x18
     /  + 3.4583936295d0*x19 - 36.3419153111d0*x20)
      f = f
     /  + 0.16d0*sqr(1.3630629165d0*i1 - 0.08810552d0*i2
     /  + 0.0104304745d0*i3 + 0.132794344d0*i4 + 0.8762025525d0*i5
     /  + 0.2805287525d0*i6 + 0.147384835d0*i7 + 0.037550819d0*i8
     /  - 0.2074359575d0*i9 + 0.1096178395d0*i10 + 0.0878529985d0*i11
     /  + 0.133694911d0*i12 + 0.040729126d0*i13 - 60.7627429307d0*x14
     /  + 45.0531668914d0*x15 + 23.9517373918d0*x16
     /  - 2.2103463222d0*x17 + 30.7877802516d0*x18
     /  - 0.3917482702d0*x19 + 0.0764416754d0*x20 - 6.3060317451d0)
     /  + sqr(27.194557222d0 + 0.4585072655d0*i1 - 0.5757478545d0*i2
     /  - 0.4009846115d0*i3 - 0.1831018695d0*i4 + 0.2312178005d0*i5
     /  + 0.0486972755d0*i6 + 0.031956613d0*i7 + 0.007833977d0*i8
     /  + 0.007705224d0*i9 - 0.033276307d0*i10 - 0.386104212d0*i11
     /  - 0.2370832555d0*i12 + 0.0215161465d0*i13
     /  + 25.6773735693d0*x14 + 31.8686922353d0*x15
     /  + 149.3606489483d0*x16 + 0.0887203646d0*x17
     /  - 2.6020875573d0*x18 + 0.4248066623d0*x19
     /  + 1.4206154804d0*x20) 
      f = f
     /  + sqr(20.9585644712d0
     /  + (-1.8719926075d0*i1) - 0.8103649045d0*i2 - 0.235999579d0*i3
     /  - 0.0518437285d0*i4 - 1.640765063d0*i5 - 0.248474734d0*i6
     /  - 0.092960559d0*i7 - 0.071505262d0*i8 - 0.181519811d0*i9
     /  - 0.015388798d0*i10 - 0.27024385d0*i11 - 0.2418226615d0*i12
     /  - 0.037319644d0*i13 - 22.9502388184d0*x14 + 1.3288409711d0*x15
     /  + 71.1560662147d0*x16 + 0.8530716695d0*x17
     /  - 10.3125827307d0*x18 + 0.1499773618d0*x19
     /  - 1.2612936268d0*x20) + 0.64d0*sqr(5.5222886784d0
     /  + (-0.2836175105d0*i1) - 0.4284470375d0*i2 - 0.009546143d0*i3
     /  + 0.010843137d0*i4 - 0.23994563d0*i5 - 0.012289314d0*i6
     /  - 0.007276577d0*i7 - 0.002998594d0*i8 - 0.2430362605d0*i9
     /  + 0.004288856d0*i10 - 0.0147266355d0*i11 - 0.020431745d0*i12
     /  - 0.0030109885d0*i13 + 36.4857205385d0*x14
     /  - 9.5382707914d0*x15 - 2.5662814081d0*x16 + 0.0701123319d0*x17
     /  - 0.9739957489d0*x18 - 0.0039118764d0*x19 + 0.014801047d0*x20)
      f = f
     /  + 0.64d0*sqr(0.077829098d0*i2 - 0.0562267775d0*i1
     /  + 0.0501518365d0*i3 + 0.070163025d0*i4 - 0.0279718715d0*i5
     /  - 0.0044578285d0*i6 - 0.0179783115d0*i7 + 0.0006129995d0*i8
     /  - 0.002470981d0*i9 + 0.041572624d0*i10 + 0.04992061d0*i11
     /  + 0.034130294d0*i12 - 0.001632946d0*i13 + 3.3349538071d0*x14
     /  - 78.7011629566d0*x15 - 74.4766668825d0*x16
     /  - 0.012150969d0*x17 - 0.2438248091d0*x18 - 0.0132360482d0*x19
     /  - 0.2890630013d0*x20 - 5.5428877033d0)
      f = f 
     /  + 0.0001d0*sqr(22.91202141d0 + (-0.8489951245d0*i1)
     /  - 0.6350590795d0*i2 - 0.0562817755d0*i3 - 0.0091235275d0*i4
     /  - 2.8900121385d0*i5 - 2.5446442835d0*i6 - 1.811926552d0*i7
     /  - 1.8175536125d0*i8 + 0.063693641d0*i9 + 0.013405335d0*i10
     /  + 0.0254304955d0*i11 + 0.2349594735d0*i12 + 0.104638289d0*i13
     /  - 103.5695914313d0*x14 - 17.7443509241d0*x15
     /  + 32.7638919927d0*x16 - 2.3776473089d0*x17
     /  + 17.4772130373d0*x18 + 6.3325007642d0*x19
     /  - 70.1193265701d0*x20) + 0.16d0*sqr(4.859424251d0*i1
     /  - 0.659282324d0*i2 + 0.039129614d0*i3 + 0.468742068d0*i4
     /  + 3.4409828955d0*i5 + 1.24017937d0*i6 + 0.6393640605d0*i7
     /  + 0.1913729885d0*i8 - 1.0046170445d0*i9 + 0.3913909235d0*i10
     /  + 0.3461760665d0*i11 + 0.4671545085d0*i12 + 0.158770265d0*i13
     /  - 248.0302545011d0*x14 + 156.5108386651d0*x15
     /  + 81.0934897165d0*x16 - 5.7060974008d0*x17
     /  + 53.3125644434d0*x18 - 1.8399288936d0*x19
     /  - 0.4332042885d0*x20 - 19.1037149037d0) 
      f = f
     /  + sqr(35.3714337539d0
     /  + 1.821104561d0*i1 - 0.7117395305d0*i2 - 0.508933257d0*i3
     /  - 0.274930052d0*i4 + 0.9357411915d0*i5 - 0.088552367d0*i6
     /  - 0.052839812d0*i7 - 0.1118301825d0*i8 + 0.030779948d0*i9
     /  - 0.051905487d0*i10 - 0.4494620575d0*i11 - 0.188904166d0*i12
     /  + 0.05816054d0*i13 + 79.3520417825d0*x14 + 49.2861444143d0*x15
     /  + 199.688966238d0*x16 - 0.5706539784d0*x17 + 3.50694557d0*x18
     /  + 0.8453712325d0*x19 + 0.4981575316d0*x20)
     /  + sqr(35.0017112093d0 + (-3.0276661615d0*i1)
     /  - 1.2456646015d0*i2 - 0.4249013895d0*i3 - 0.1123235075d0*i4
     /  - 3.225975278d0*i5 - 0.7024331695d0*i6 - 0.3011201565d0*i7
     /  - 0.208020079d0*i8 - 0.2481312785d0*i9 - 0.032588866d0*i10
     /  - 0.4904285095d0*i11 - 0.370956125d0*i12 - 0.042443114d0*i13
     /  - 59.1471556858d0*x14 + 12.8393595714d0*x15
     /  + 132.3494388126d0*x16 + 0.59716443d0*x17                    
     /  - 2.6471256653d0*x18 + 0.480661633d0*x19
     /  - 2.9211234364d0*x20) 
      f = f
     /  + 0.64d0*sqr(13.3242917752d0
     /  + (-0.666803293d0*i1) - 1.0301488055d0*i2 - 0.021668202d0*i3
     /  + 0.0241034905d0*i4 - 0.6278026305d0*i5 - 0.034280553d0*i6
     /  - 0.0128201945d0*i7 - 0.0010129555d0*i8 - 0.588585124d0*i9
     /  + 0.010394622d0*i10 - 0.0355385975d0*i11 - 0.0399444305d0*i12
     /  - 0.003781859d0*i13 + 90.1828519606d0*x14
     /  - 16.7705535388d0*x15 - 2.5547451251d0*x16
     /  + 0.0444115721d0*x17 - 0.0681078714d0*x18 + 0.0153484518d0*x19
     /  + 0.0025491801d0*x20) + 0.64d0*sqr((-0.247413475d0*i1)
     /  - 0.0527864135d0*i2 + 0.0408601485d0*i3 + 0.069801037d0*i4
     /  - 0.112563735d0*i5 + 0.0124782375d0*i6 - 0.0135731255d0*i7
     /  + 0.0064161115d0*i8 - 0.0904160855d0*i9 + 0.036765034d0*i10
     /  + 0.0362530635d0*i11 + 0.009640317d0*i12 - 0.006568323d0*i13
     /  + 22.354352107d0*x14 - 69.4261066563d0*x15
     /  - 65.9673942362d0*x16 + 0.0630205182d0*x17
     /  - 0.6756411564d0*x18 - 0.0172196827d0*x19 - 0.1847089481d0*x20
     /  - 2.8171206293d0) 
      f = f
     /  + 0.0001d0*sqr(21.7879588169d0
     /  + (-0.4736827735d0*i1) - 0.8993304715d0*i2 - 0.08585705d0*i3
     /  + 0.0095197925d0*i4 - 2.2037818325d0*i5 - 2.1917197485d0*i6
     /  - 1.676330726d0*i7 - 1.8513560845d0*i8 + 0.128029489d0*i9
     /  + 0.0192200695d0*i10 + 0.0397714575d0*i11 + 0.1935998865d0*i12
     /  + 0.0861158445d0*i13 - 189.427546876d0*x14
     /  - 46.7180298532d0*x15 + 30.1363300837d0*x16
     /  - 1.6231543138d0*x17 + 7.3508136199d0*x18 + 6.5997072711d0*x19
     /  - 82.0209643098d0*x20) + 0.16d0*sqr(9.284217476d0*i1
     /  - 1.553145214d0*i2 + 0.0474861095d0*i3 + 0.930425216d0*i4
     /  + 8.1059677045d0*i5 + 3.5731229395d0*i6 + 2.139647487d0*i7
     /  + 0.7404132305d0*i8 - 1.715803589d0*i9 + 0.7640174275d0*i10
     /  + 0.7509722855d0*i11 + 0.81582566d0*i12 + 0.2625995665d0*i13
     /  - 514.936957251d0*x14 + 290.3735314192d0*x15
     /  + 141.6853205036d0*x16 - 7.8736279955d0*x17
     /  + 50.5912316647d0*x18 - 5.3692662428d0*x19
     /  - 1.2634691605d0*x20 - 37.2484380527d0) 
      f = f
     /  + sqr(49.7793154236d0
     /  + 4.487283041d0*i1 - 1.008272803d0*i2 - 0.6862103215d0*i3
     /  - 0.4246850745d0*i4 + 2.98608078d0*i5 - 0.2648715535d0*i6
     /  - 0.1635616625d0*i7 - 0.478486893d0*i8 + 0.067525863d0*i9
     /  - 0.087020293d0*i10 - 0.4978930595d0*i11 - 0.111394384d0*i12
     /  + 0.1010347015d0*i13 + 183.5676339425d0*x14
     /  + 67.4179160872d0*x15 + 260.0168205722d0*x16
     /  - 1.1081123903d0*x17 + 3.8671994285d0*x18 + 1.5222166d0*x19
     /  - 5.0366128035d0*x20) + sqr(43.021067804d0
     /  + (-3.0418102915d0*i1) - 1.514562486d0*i2 - 0.5679411765d0*i3
     /  - 0.1776978505d0*i4 - 4.3954738325d0*i5 - 1.508296574d0*i6
     /  - 0.7040126985d0*i7 - 0.5012689205d0*i8 - 0.2570400905d0*i9
     /  - 0.0472079625d0*i10 - 0.6333191455d0*i11 - 0.3597872405d0*i12
     /  - 0.0092484475d0*i13 - 135.5420938387d0*x14
     /  + 33.8072474452d0*x15 + 173.1509254254d0*x16
     /  + 0.0154455776d0*x17 + 0.9579081923d0*x18 + 0.9045568743d0*x19
     /  - 6.1259070911d0*x20) 
      f = f
     /  + 0.64d0*sqr(25.0638931642d0
     /  + (-1.068034269d0*i1) - 1.9702675285d0*i2 - 0.0399781045d0*i3
     /  + 0.039436362d0*i4 - 1.2363967325d0*i5 - 0.107099514d0*i6
     /  - 0.026643497d0*i7 + 0.000593354d0*i8 - 1.1327014105d0*i9
     /  + 0.0198921455d0*i10 - 0.0651726845d0*i11 - 0.048562398d0*i12
     /  + 0.000423691d0*i13 + 161.5508352661d0*x14
     /  - 17.8973790682d0*x15 + 3.0754846652d0*x16
     /  - 0.0131686905d0*x17 + 0.4333019034d0*x18 + 0.0861189709d0*x19
     /  - 0.3218074323d0*x20) 
     /  + 0.64d0*sqr(0.6473699839d0
     /  + (-0.504868999d0*i1) - 0.223838452d0*i2 + 0.0316942325d0*i3
     /  + 0.0737521485d0*i4 - 0.364422363d0*i5 + 0.01570572d0*i6
     /  - 0.0133325785d0*i7 + 0.0241523325d0*i8 - 0.21859445d0*i9
     /  + 0.036167507d0*i10 + 0.014960117d0*i11 - 0.011658801d0*i12
     /  - 0.008229984d0*i13 + 50.5469705602d0*x14
     /  - 55.5675725111d0*x15 - 54.2122022045d0*x16
     /  + 0.0682390665d0*x17 - 0.0958560558d0*x18 + 0.01421791d0*x19
     /  + 0.2779557025d0*x20) 
      f = f
     /  + 0.16d0*sqr(13.8689641675d0*i1
     /  - 2.7662878715d0*i2 + 0.078329024d0*i3 + 1.4458018665d0*i4
     /  + 14.532599669d0*i5 + 7.732680672d0*i6 + 4.4572808385d0*i7
     /  + 1.366951519d0*i8 - 2.066763484d0*i9 + 1.1350678385d0*i10
     /  + 1.350579154d0*i11 + 1.0726094725d0*i12 + 0.364453229d0*i13
     /  - 812.3382165169d0*x14 + 374.2616854026d0*x15
     /  + 159.2434025232d0*x16 - 8.3531458586d0*x17
     /  + 37.4532747863d0*x18 - 11.6181359664d0*x19
     /  - 10.4220063327d0*x20 - 57.9853544596d0)
     /  + sqr(72.2005752966d0 + 7.879812818d0*i1 - 1.2832418045d0*i2
     /  - 0.8928208955d0*i3 - 0.643973437d0*i4 + 6.766925722d0*i5
     /  - 0.092406253d0*i6 - 0.0629369475d0*i7 - 1.3586208615d0*i8
     /  + 0.1852119085d0*i9 - 0.1761968105d0*i10 - 0.4642049575d0*i11
     /  - 0.0544572285d0*i12 + 0.1102654365d0*i13
     /  + 403.4279641629d0*x14 + 57.2476586121d0*x15
     /  + 304.648651667d0*x16 - 1.4921447174d0*x17
     /  + 0.5675587323d0*x18 + 2.8263646656d0*x19
     /  - 21.8009701189d0*x20) 
      f = f
     /  + sqr(51.2834375764d0
     /  + (-2.7088662415d0*i1) - 1.8868157635d0*i2 - 0.7116682285d0*i3
     /  - 0.267796792d0*i4 - 4.8527563735d0*i5 - 2.504480646d0*i6
     /  - 1.152758759d0*i7 - 1.138573778d0*i8 - 0.2229937915d0*i9
     /  - 0.081720225d0*i10 - 0.6990111455d0*i11 - 0.31210937d0*i12
     /  + 0.0150165305d0*i13 - 257.1964984571d0*x14
     /  + 47.5204718859d0*x15 + 204.8907748828d0*x16
     /  - 0.5298037875d0*x17 + 0.4997334966d0*x18 + 1.3165875998d0*x19
     /  - 14.9476248756d0*x20) + 0.64d0*sqr(40.8609115933d0
     /  + (-1.3599285725d0*i1) - 3.2974763555d0*i2 - 0.075132111d0*i3
     /  + 0.041048208d0*i4 - 1.827314676d0*i5 - 0.250194293d0*i6
     /  - 0.0532306545d0*i7 - 0.0424369045d0*i8 - 1.878622603d0*i9
     /  + 0.0192240705d0*i10 - 0.100421631d0*i11 - 0.0488371095d0*i12
     /  + 0.0051849995d0*i13 + 220.7856326007d0*x14
     /  - 9.8944334188d0*x15 + 18.1994216348d0*x16
     /  - 0.0314578944d0*x17 + 0.3637738371d0*x18 + 0.2888783431d0*x19
     /  - 2.4044479313d0*x20) 
      f = f
     /  + 0.64d0*sqr(3.1835502966d0
     /  + (-0.6369425565d0*i1) - 0.400532281d0*i2 + 0.01771152d0*i3
     /  + 0.0910889475d0*i4 - 0.671206495d0*i5 - 0.0026390425d0*i6
     /  - 0.0164414625d0*i7 + 0.074391477d0*i8 - 0.3493322045d0*i9
     /  + 0.0482176475d0*i10 - 0.012155684d0*i11 - 0.01908805d0*i12
     /  - 0.004730835d0*i13 + 63.2346641976d0*x14
     /  - 38.2784911039d0*x15 - 40.1606271682d0*x16
     /  + 0.0365675552d0*x17 + 0.6620309299d0*x18 - 0.0055537207d0*x19
     /  + 1.1735430798d0*x20)

      g(1) = -(-5.0d0*i1 - 5.0d0*i5 - 5.0d0*i6 - 5.0d0*i7 
     /   - 5.0d0*i8 + 31.0d0)
 
      g(2) = -5.0d0*i1 - 5.0d0*i5 - 5.0d0*i6 - 5.0d0*i7 
     /   - 5.0d0*i8 + 41.0d0
 
      g(3) = -(-5.0d0*i2 - 5.0d0*i9 + 44.0d0)
 
      g(4) = -5.0d0*i2 - 5.0d0*i9 + 47.0d0
 
      g(5) = -5.0d0*i4 - 5.0d0*i10 + 210.0d0
 
      g(6) = -5.0d0*i3 - 5.0d0*i11 - 5.0d0*i12 - 5.0d0*i13 + 210.0d0
 
      g(7) = -5.0d0*i1 - 5.0d0*i5 + 16.0d0
 
      g(8) = -(-5.0d0*i4 - 5.0d0*i10 + 89.0d0)
 
      g(9) = -5.0d0*i4 - 5.0d0*i10 + 136.0d0

  999 continue
      return
      end

      subroutine elf(  mode,     m,     me,  mmax, ncont,  
     /    nbin,  nint,   nmax,     x,    xl,
     /      xu,     f,      g,  pnam,  pref,
     /     fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:06:34
*  
*  Equation counts
*     Total       E       G       L       N       X
*        39       7      32       0       0       0
*  
*  Variable counts
* x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        55      31      24       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       178     148      30       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr,
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, 
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38
      character*30 pnam, pref


      if (mode.eq.0) then
         pnam  = 'ELF'
         pref  = '\cite{MINLPLib}'
         fex   = 0.19166667d0 
         ncont = 30
         nint  = 0
         nbin  = 24
         n     = ncont + nbin + nint
         m     = 38
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d5
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      b1  = y(1)
      b2  = y(2)
      b3  = y(3)
      b4  = y(4)
      b5  = y(5)
      b6  = y(6)
      b7  = y(7)
      b8  = y(8)
      b9  = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      x25 = x(1)
      x26 = x(2)
      x27 = x(3)
      x28 = x(4)
      x29 = x(5)
      x30 = x(6)
      x31 = x(7)
      x32 = x(8)
      x33 = x(9)
      x34 = x(10)
      x35 = x(11)
      x36 = x(12)
      x37 = x(13)
      x38 = x(14)
      x39 = x(15)
      x40 = x(16)
      x41 = x(17)
      x42 = x(18)
      x43 = x(19)
      x44 = x(20)
      x45 = x(21)
      x46 = x(22)
      x47 = x(23)
      x48 = x(24)
      x49 = x(25)
      x50 = x(26)
      x51 = x(27)
      x52 = x(28)
      x53 = x(29)
      x54 = x(30)

      f = x25 + x26 + x27 + x28 + x29 + x30 + x31 + x32 + x33 + x34 
     /    + x35 + x36 + x37 + x38 + x39 + x40 + x41 + x42 + x43 + x44
     /    + x45 + x46 + x47 + x48

      e1 = - sqr(8.0d0 - x49) - 100.0d0*b1 + x25 + 100.0d0    

      e2 = - sqr(8.0d0 - x50) - 100.0d0*b2 + x26 + 100.0d0   

      e3 = - sqr(8.0d0 - x51) - 100.0d0*b3 + x27 + 100.0d0   

      e4 = - sqr(8.5d0 - x49) - 100.0d0*b4 + x28 + 100.0d0 

      e5 = - sqr(8.5d0 - x50) - 100.0d0*b5 + x29 + 100.0d0 

      e6 = - sqr(8.5d0 - x51) - 100.0d0*b6 + x30 + 100.0d0 

      e7 = - sqr(8.3d0 - x49) - 100.0d0*b7 + x31 + 100.0d0 

      e8 = - sqr(8.3d0 - x50) - 100.0d0*b8 + x32 + 100.0d0 

      e9 = - sqr(8.3d0 - x51) - 100.0d0*b9 + x33 + 100.0d0 

      e10 = - sqr(8.7d0 - x49) - 100.0d0*b10 + x34 + 100.0d0  

      e11 = - sqr(8.7d0 - x50) - 100.0d0*b11 + x35 + 100.0d0  

      e12 = - sqr(8.7d0 - x51) - 100.0d0*b12 + x36 + 100.0d0  

      e13 = - sqr(8.6d0 - x49) - 100.0d0*b13 + x37 + 100.0d0  

      e14 = - sqr(8.6d0 - x50) - 100.0d0*b14 + x38 + 100.0d0  

      e15 = - sqr(8.6d0 - x51) - 100.0d0*b15 + x39 + 100.0d0  
      
      e16 = - sqr(9.0d0 - x49) - 100.0d0*b16 + x40 + 100.0d0 

      e17 = - sqr(9.0d0 - x50) - 100.0d0*b17 + x41 + 100.0d0 

      e18 = - sqr(9.0d0 - x51) - 100.0d0*b18 + x42 + 100.0d0 

      e19 = - sqr(9.2d0 - x49) - 100.0d0*b19 + x43 + 100.0d0 

      e20 = - sqr(9.2d0 - x50) - 100.0d0*b20 + x44 + 100.0d0 

      e21 = - sqr(9.2d0 - x51) - 100.0d0*b21 + x45 + 100.0d0  

      e22 = - sqr(9.5d0 - x49) - 100.0d0*b22 + x46 + 100.0d0 

      e23 = - sqr(9.5d0 - x50) - 100.0d0*b23 + x47 + 100.0d0  

      e24 = - sqr(9.5d0 - x51) - 100.0d0*b24 + x48 + 100.0d0  
      
      e25 = b1 + b2 + b3 - 1.0d0    

      e26 = b4 + b5 + b6 - 1.0d0    

      e27 = b7 + b8 + b9 - 1.0d0    

      e28 = b10 + b11 + b12 - 1.0d0 

      e29 = b13 + b14 + b15 - 1.0d0 

      e30 = b16 + b17 + b18 - 1.0d0 

      e31 = b19 + b20 + b21 - 1.0d0 

      e32 = b22 + b23 + b24 - 1.0d0 

      e33 = -b1 - b4 - b7 - b10 - b13 - b16 - b19 - b22 + x52      

      e34 = -b2 - b5 - b8 - b11 - b14 - b17 - b20 - b23 + x53      

      e35 = -b3 - b6 - b9 - b12 - b15 - b18 - b21 - b24 + x54      

      e36 = x52*x49 - 8.0d0*b1 - 8.5d0*b4 - 8.3d0*b7 - 8.7d0*b10 
     /      - 8.6d0*b13 - 9.0d0*b16 - 9.2d0*b19 - 9.5d0*b22          

      e37 = x53*x50 - 8.0d0*b2 - 8.5d0*b5 - 8.3d0*b8 - 8.7d0*b11
     /      - 8.6d0*b14 - 9.0d0*b17 - 9.2d0*b20 - 9.5d0*b23          

      e38 = x54*x51 - 8.0d0*b3 - 8.5d0*b6 - 8.3d0*b9 - 8.7d0*b12 
     /      - 8.6d0*b15 - 9.0d0*b18 - 9.2d0*b21 - 9.5d0*b24     

      g(1)  = e33
      g(2)  = e34
      g(3)  = e35
      g(4)  = e36
      g(5)  = e37
      g(6)  = e38
      g(7)  = e1
      g(8)  = e2
      g(9)  = e3
      g(10) = e4
      g(11) = e5
      g(12) = e6
      g(13) = e7
      g(14) = e8
      g(15) = e9
      g(16) = e10
      g(17) = e11
      g(18) = e12
      g(19) = e13
      g(20) = e14
      g(21) = e15
      g(22) = e16
      g(23) = e17
      g(24) = e18
      g(25) = e19
      g(26) = e20
      g(27) = e21
      g(28) = e22
      g(29) = e23
      g(30) = e24
      g(31) = e25
      g(32) = e26
      g(33) = e27
      g(34) = e28
      g(35) = e29
      g(36) = e30
      g(37) = e31
      g(38) = e32
      
  999 continue
      return
      end
 

      subroutine emso( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EMSO'
         pref  = ''
         fex   = -1.9230987d0
         ncont = 3
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         end do        
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do   
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do

      f = -2.9d0*x(3) - 8.9d0*dlog(1.0d0+x(1)) 
     /    - 10.44d0*dlog(1.0d0+x(2)) + 1.8d0*(x(1) + x(2))
     /    + 3.5d0*y(1) + y(2) + 1.5d0*y(3) 
      
      g(1) = y(1) - 0.9d0*(dlog(1.0d0+x(1)) + 1.2d0*dlog(1.0d0+x(2))
     /                     + 0.9d0*x(3))
          
      g(2) = 10.0d0*y(2) - dlog(1.0d0+x(1))
      
      g(3) = 10.0d0*y(3) - 1.2d0*dlog(1.0d0+x(2))

      g(4) = 1.0d0 - y(2) - y(3)
      
  999 continue
      return
      end
 
      subroutine eniplac(  mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

*  MINLP written by GAMS Convert at 08/08/01 16:34:55
*  
*  Equation counts
*     Total       E       G       L       N       X
*       190      88      30      72       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       142     118      24       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       511     463      48       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,  
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30, 
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40, 
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50, 
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70, 
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90, 
     /        x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /       x101,x102,x103,x104,x105,x106,x107,x108,x109,x110,
     /       x111,x112,x113,x114,x115,x116,x117,     b119,b120,
     /       b121,b122,b123,b124,b125,b126,b127,b128,b129,b130,
     /       b131,b132,b133,b134,b135,b136,b137,b138,b139,b140, 
     /       b141,b142
      double precision
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10, 
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, 
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, 
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, 
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /       e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /       e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /       e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /       e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /       e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /       e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /       e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /       e181,e182,e183,e184,e185,e186,e187,e188,e189
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ENIPLAC'
         pref  = '\cite{MINLPLib}'
         fex   = -131863.6d0
c         fex   = -131863.6d0*1.0d-5
         ncont = 117
         nint  = 0
         nbin  = 24
         n     = ncont + nbin + nint
         m     = 189
         me    = 87
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         end do
         xu(99) = 5.0d2
         do i = 100,104
            xu(i) = 1.0d2
         end do
         do i = 105,110
            xu(i) = 5.0d2
         end do
         x(1) = 250.0d0
         x(2) = 170.0d0 
         x(3) = 260.0d0 
         x(4) = 510.0d0 
         x(5) = 250.0d0 
         x(6) = 170.0d0 
         x(7) = 260.0d0 
         x(8) = 510.0d0 
         x(9) = 250.0d0 
         x(10) = 170.0d0
         x(11) = 260.0d0
         x(12) = 510.0d0
         x(13) = 250.0d0
         x(14) = 170.0d0
         x(15) = 260.0d0
         x(16) = 510.0d0
         x(17) = 250.0d0
         x(18) = 170.0d0
         x(19) = 260.0d0
         x(20) = 510.0d0
         x(21) = 250.0d0
         x(22) = 170.0d0
         x(23) = 260.0d0
         x(24) = 510.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      x73 = x(73)
      x74 = x(74)
      x75 = x(75)
      x76 = x(76)
      x77 = x(77)
      x78 = x(78)
      x79 = x(79)
      x80 = x(80)
      x81 = x(81)
      x82 = x(82)
      x83 = x(83)
      x84 = x(84)
      x85 = x(85)
      x86 = x(86)
      x87 = x(87)
      x88 = x(88)
      x89 = x(89)
      x90 = x(90)
      x91 = x(91)
      x92 = x(92)
      x93 = x(93)
      x94 = x(94)
      x95 = x(95)
      x96 = x(96)
      x97 = x(97)
      x98 = x(98)
      x99 = x(99)
      x100 = x(100)
      x101 = x(101)
      x102 = x(102)
      x103 = x(103)
      x104 = x(104)
      x105 = x(105)
      x106 = x(106)
      x107 = x(107)
      x108 = x(108)
      x109 = x(109)
      x110 = x(110)
      x111 = x(111)
      x112 = x(112)
      x113 = x(113)
      x114 = x(114)
      x115 = x(115)
      x116 = x(116)
      x117 = x(117)
      b119 = y(1)
      b120 = y(2)
      b121 = y(3)
      b122 = y(4)
      b123 = y(5)
      b124 = y(6)
      b125 = y(7)
      b126 = y(8)
      b127 = y(9)
      b128 = y(10)
      b129 = y(11)
      b130 = y(12)
      b131 = y(13)
      b132 = y(14)
      b133 = y(15)
      b134 = y(16)
      b135 = y(17)
      b136 = y(18)
      b137 = y(19)
      b138 = y(20)
      b139 = y(21)
      b140 = y(22)
      b141 = y(23)
      b142 = y(24)

      f = -x97 + x112 + x113
c      f = f*1.0d-5

      e1 = -3.3d0*x73 - 3.2d0*x74 - 3.1d0*x75 - 3.25d0*x76 - 3.3d0*x77
     /      - 3.2d0*x78 - 3.1d0*x79 - 3.25d0*x80 - 3.3d0*x81 - 3.2d0*x82
     /      - 3.1d0*x83 - 3.25d0*x84 - 3.3d0*x85 - 3.2d0*x86 - 3.1d0*x87
     /      - 3.25d0*x88 - 3.3d0*x89 - 3.2d0*x90 - 3.1d0*x91 
     /      - 3.25d0*x92 - 3.3d0*x93 - 3.2d0*x94 - 3.1d0*x95 
     /      - 3.25d0*x96 + x113       

      e2 = -33.0d0*x105 - 33.0d0*x106 - 33.0d0*x107 - 33.0d0*x108 
     /     -33.0d0*x109 - 33.0d0*x110 + x112  

      e3 = x25 - b119 

      e4 = x26 - b120 

      e5 = x27 - b121 

      e6 = x28 - b122 

      e7 = x29 - b123 

      e8 = x30 - b124 

      e9 = x31 - b125 

      e10 = x32 - b126

      e11 = x33 - b127

      e12 = x34 - b128

      e13 = x35 - b129

      e14 = x36 - b130

      e15 = x37 - b131

      e16 = x38 - b132

      e17 = x39 - b133

      e18 = x40 - b134

      e19 = x41 - b135

      e20 = x42 - b136

      e21 = x43 - b137

      e22 = x44 - b138

      e23 = x45 - b139

      e24 = x46 - b140

      e25 = x47 - b141

      e26 = x48 - b142

      e27 = x1 + x2 + x3 + x4 - x99 + x105 - 1170.0d0 

      e28 = x5 + x6 + x7 + x8 - x100 + x106 - 950.0d0   

      e29 = x9 + x10 + x11 + x12 - x101 + x107 - 950.0d0        

      e30 = x13 + x14 + x15 + x16 - x102 + x108 - 700.0d0   

      e31 = x17 + x18 + x19 + x20 - x103 + x109 - 600.0d0      

      e32 = x21 + x22 + x23 + x24 - x104 + x110 - 250.0d0     

      e33 = -(601.56d0 + 0.0131d0*sqr(x1) + 1.0622d0*x1)*x25 + x73 

      e34 = -(10.04286d0*x2 - 0.01048d0*sqr(x2) - 92.8095d0)*x26 + x74

      e35 = -(657.32d0 + 0.018317d0*sqr(x3))*x27 + x75    

      e36 = -(222.2d0 + 0.0001d0*sqr(x4) + 6.2749d0*x4)*x28 + x76     

      e37 = -(601.56d0 + 0.0131d0*sqr(x5) + 1.0622d0*x5)*x29 + x77    

      e38 = -(10.04286d0*x6 - 0.01048d0*sqr(x6) - 92.8095d0)*x30 + x78

      e39 = -(657.32d0 + 0.018317d0*sqr(x7))*x31 + x79    

      e40 = -(222.2d0 + 0.0001d0*sqr(x8) + 6.2749d0*x8)*x32 + x80     

      e41 = -(601.56d0 + 0.0131d0*sqr(x9) + 1.0622d0*x9)*x33 + x81    

      e42 = -(10.04286d0*x10 - 0.01048d0*sqr(x10) - 92.8095d0)*x34 
     /         + x82       

      e43 = -(657.32d0 + 0.018317d0*sqr(x11))*x35 + x83   

      e44 = -(222.2d0 + 0.0001d0*sqr(x12) + 6.2749d0*x12)*x36 + x84 

      e45 = -(601.56d0 + 0.0131d0*sqr(x13) + 1.0622d0*x13)*x37 + x85 

      e46 = -(10.04286d0*x14 - 0.01048d0*sqr(x14) - 92.8095d0)*x38 
     /         + x86       

      e47 = -(657.32d0 + 0.018317d0*sqr(x15))*x39 + x87   

      e48 = -(222.2d0 + 0.0001d0*sqr(x16) + 6.2749d0*x16)*x40 + x88 
      
      e49 = -(601.56d0 + 0.0131d0*sqr(x17) + 1.0622d0*x17)*x41 + x89 

      e50 = -(10.04286d0*x18 - 0.01048d0*sqr(x18) - 92.8095d0)*x42 
     /         + x90       

      e51 = -(657.32d0 + 0.018317d0*sqr(x19))*x43 + x91   

      e52 = -(222.2d0 + 0.0001d0*sqr(x20) + 6.2749d0*x20)*x44 + x92  

      e53 = -(601.56d0 + 0.0131d0*sqr(x21) + 1.0622d0*x21)*x45 + x93

      e54 = -(10.04286d0*x22 - 0.01048d0*sqr(x22) - 92.8095d0)*x46 
     /         + x94       

      e55 = -(657.32d0 + 0.018317d0*sqr(x23))*x47 + x95   

      e56 = -(222.2d0 + 0.0001d0*sqr(x24) + 6.2749d0*x24)*x48 + x96 

      e57 = -x73 - x77 - x81 - x85 - x89 - x93 + x114 

      e58 = -x74 - x78 - x82 - x86 - x90 - x94 + x115 

      e59 = -x75 - x79 - x83 - x87 - x91 - x95 + x116 

      e60 = -x76 - x80 - x84 - x88 - x92 - x96 + x117 

      e61 = x98 - 231000.0d0                           

      e62 = -30.0d0*x99 - 30.0d0*x100 - 30.0d0*x101 - 30.0d0*x102 
     /      -30.0d0*x103 - 30.0d0*x104 + x111     

      e63 = x97 - x98 - x111                         

      e64 = -x1 + x5 - 500.0d0                          

      e65 = -x2 + x6- 500.0d0                          

      e66 = -x3 + x7- 500.0d0                          

      e67 = -x4 + x8 - 500.0d0

      e68 = -x5 + x9 - 500.0d0                 

      e69 = -x6 + x10 - 500.0d0                         

      e70 = -x7 + x11 - 500.0d0                         

      e71 = -x8 + x12 - 500.0d0                         

      e72 = -x9 + x13 - 500.0d0                         

      e73 = -x10 + x14 - 500.0d0                        

      e74 = -x11 + x15 - 500.0d0                        

      e75 = -x12 + x16 - 500.0d0                        

      e76 = -x13 + x17 - 500.0d0                        

      e77 = -x14 + x18 - 500.0d0                        

      e78 = -x15 + x19 - 500.0d0                        

      e79 = -x16 + x20 - 500.0d0                        

      e80 = -x17 + x21 - 500.0d0                        

      e81 = -x18 + x22 - 500.0d0                        

      e82 = -x19 + x23 - 500.0d0                        

      e83 = -x20 + x24 - 500.0d0                        

      e84 = x1 - x5 - 500.0d0                          

      e85 = x2 - x6 - 500.0d0                          

      e86 = x3 - x7 - 500.0d0                          

      e87 = x4 - x8 - 500.0d0                          

      e88 = x5 - x9 - 500.0d0                          

      e89 = x6 - x10 - 500.0d0                         

      e90 = x7 - x11 - 500.0d0                         

      e91 = x8 - x12 - 500.0d0                         

      e92 = x9 - x13 - 500.0d0                         

      e93 = x10 - x14 - 500.0d0                        

      e94 = x11 - x15 - 500.0d0                        

      e95 = x12 - x16 - 500.0d0                        

      e96 = x13 - x17 - 500.0d0                        

      e97 = x14 - x18 - 500.0d0                        

      e98 = x15 - x19 - 500.0d0                        

      e99 = x16 - x20 - 500.0d0                        

      e100 = x17 - x21 - 500.0d0                       

      e101 = x18 - x22 - 500.0d0                       

      e102 = x19 - x23 - 500.0d0                       

      e103 = x20 - x24 - 500.0d0                       

      e104 = x1 - 800.0d0                              

      e105 = x2 - 650.0d0                              

      e106 = x3 - 660.0d0                              

      e107 = x4 - 750.0d0                              

      e108 = -x1 - 200.0d0                              

      e109 = -x2 - 350.0d0                              

      e110 = -x3 - 340.0d0                              

      e111 = -x4 - 250.0d0                              

      e112 = x1 + x49 - 250.0d0*b119                     

      e113 = x2 + x50 - 170.0d0*b120                     

      e114 = x3 + x51 - 260.0d0*b121                     

      e115 = x4 + x52 - 510.0d0*b122                     

      e116 = x5 + x53 - 250.0d0*b123                     

      e117 = x6 + x54 - 170.0d0*b124                     

      e118 = x7 + x55 - 260.0d0*b125                     

      e119 = x8 + x56 - 510.0d0*b126                     

      e120 = x9 + x57 - 250.0d0*b127                     

      e121 = x10 + x58 - 170.0d0*b128                    

      e122 = x11 + x59 - 260.0d0*b129                    

      e123 = x12 + x60 - 510.0d0*b130                    

      e124 = x13 + x61 - 250.0d0*b131                    

      e125 = x14 + x62 - 170.0d0*b132                    

      e126 = x15 + x63 - 260.0d0*b133                    

      e127 = x16 + x64 - 510.0d0*b134                    

      e128 = x17 + x65 - 250.0d0*b135                    

      e129 = x18 + x66 - 170.0d0*b136                    

      e130 = x19 + x67 - 260.0d0*b137                    

      e131 = x20 + x68 - 510.0d0*b138                    

      e132 = x21 + x69 - 250.0d0*b139                    

      e133 = x22 + x70 - 170.0d0*b140                    

      e134 = x23 + x71 - 260.0d0*b141                    

      e135 = x24 + x72 - 510.0d0*b142                    

      e136 = x49 + x50 + x51 + x52 - 25.0d0            

      e137 = x53 + x54 + x55 + x56 - 25.0d0             

      e138 = x57 + x58 + x59 + x60 - 25.0d0             

      e139 = x61 + x62 + x63 + x64 - 25.0d0             

      e140 = x65 + x66 + x67 + x68 - 25.0d0             

      e141 = x69 + x70 + x71 + x72 - 25.0d0             

      e142 = x1 - 250.0d0*b119                           

      e143 = x2 - 170.0d0*b120                           

      e144 = x3 - 260.0d0*b121                           

      e145 = x4 - 510.0d0*b122                           

      e146 = x5 - 250.0d0*b123                           

      e147 = x6 - 170.0d0*b124                           

      e148 = x7 - 260.0d0*b125                           

      e149 = x8 - 510.0d0*b126                           

      e150 = x9 - 250.0d0*b127                           

      e151 = x10 - 170.0d0*b128                          

      e152 = x11 - 260.0d0*b129                          

      e153 = x12 - 510.0d0*b130                          

      e154 = x13 - 250.0d0*b131                          

      e155 = x14 - 170.0d0*b132                          

      e156 = x15 - 260.0d0*b133                          

      e157 = x16 - 510.0d0*b134                          

      e158 = x17 - 250.0d0*b135                          

      e159 = x18 - 170.0d0*b136                          

      e160 = x19 - 260.0d0*b137                          

      e161 = x20 - 510.0d0*b138                          

      e162 = x21 - 250.0d0*b139                          

      e163 = x22 - 170.0d0*b140                          

      e164 = x23 - 260.0d0*b141                          

      e165 = x24 - 510.0d0*b142                          

      e166 = x1 - 140.0d0*b119                           

      e167 = x2 - 140.0d0*b120                           

      e168 = x3 - 140.0d0*b121                           

      e169 = x4 - 160.0d0*b122                           

      e170 = x5 - 140.0d0*b123                           

      e171 = x6 - 140.0d0*b124                           

      e172 = x7 - 140.0d0*b125                           

      e173 = x8 - 160.0d0*b126                           

      e174 = x9 - 140.0d0*b127                           

      e175 = x10 - 140.0d0*b128                          

      e176 = x11 - 140.0d0*b129                          

      e177 = x12 - 160.0d0*b130                          

      e178 = x13 - 140.0d0*b131                          

      e179 = x14 - 140.0d0*b132                          

      e180 = x15 - 140.0d0*b133                          

      e181 = x16 - 160.0d0*b134                          

      e182 = x17 - 140.0d0*b135                          

      e183 = x18 - 140.0d0*b136                          

      e184 = x19 - 140.0d0*b137                          

      e185 = x20 - 160.0d0*b138                          

      e186 = x21 - 140.0d0*b139                          

      e187 = x22 - 140.0d0*b140                          

      e188 = x23 - 140.0d0*b141                          

      e189 = x24 - 160.0d0*b142                          

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = e5
      g(6) = e6
      g(7) = e7
      g(8) = e8
      g(9) = e9
      g(10) = e10
      g(11) = e11
      g(12) = e12
      g(13) = e13
      g(14) = e14
      g(15) = e15
      g(16) = e16
      g(17) = e17
      g(18) = e18
      g(19) = e19
      g(20) = e20
      g(21) = e21
      g(22) = e22
      g(23) = e23
      g(24) = e24
      g(25) = e25
      g(26) = e26
      g(27) = e27
      g(28) = e28
      g(29) = e29
      g(30) = e30
      g(31) = e31
      g(32) = e32
      g(33) = e33
      g(34) = e34
      g(35) = e35
      g(36) = e36
      g(37) = e37
      g(38) = e38
      g(39) = e39
      g(40) = e40
      g(41) = e41
      g(42) = e42
      g(43) = e43
      g(44) = e44
      g(45) = e45
      g(46) = e46
      g(47) = e47
      g(48) = e48
      g(49) = e49
      g(50) = e50
      g(51) = e51
      g(52) = e52
      g(53) = e53
      g(54) = e54
      g(55) = e55
      g(56) = e56
      g(57) = e57
      g(58) = e58
      g(59) = e59
      g(60) = e60
      g(61) = e61
      g(62) = e62
      g(63) = e63      
      g(64) = e112
      g(65) = e113
      g(66) = e114
      g(67) = e115
      g(68) = e116
      g(69) = e117
      g(70) = e118
      g(71) = e119
      g(72) = e120
      g(73) = e121
      g(74) = e122
      g(75) = e123
      g(76) = e124
      g(77) = e125
      g(78) = e126
      g(79) = e127
      g(80) = e128
      g(81) = e129
      g(82) = e130
      g(83) = e131
      g(84) = e132
      g(85) = e133
      g(86) = e134
      g(87) = e135
      g(88) = -e64
      g(89) = -e65
      g(90) = -e66
      g(91) = -e67
      g(92) = -e68
      g(93) = -e69
      g(94) = -e70
      g(95) = -e71
      g(96) = -e72
      g(97) = -e73
      g(98) = -e74
      g(99) = -e75
      g(100) = -e76
      g(101) = -e77
      g(102) = -e78
      g(103) = -e79
      g(104) = -e80
      g(105) = -e81
      g(106) = -e82
      g(107) = -e83
      g(108) = -e84
      g(109) = -e85
      g(110) = -e86
      g(111) = -e87
      g(112) = -e88
      g(113) = -e89
      g(114) = -e90
      g(115) = -e91
      g(116) = -e92
      g(117) = -e93
      g(118) = -e94
      g(119) = -e95
      g(120) = -e96
      g(121) = -e97
      g(122) = -e98
      g(123) = -e99
      g(124) = -e100
      g(125) = -e101
      g(126) = -e102
      g(127) = -e103
      g(128) = -e104
      g(129) = -e105
      g(130) = -e106
      g(131) = -e107
      g(132) = -e108
      g(133) = -e109
      g(134) = -e110
      g(135) = -e111
      g(136) = e136
      g(137) = e137
      g(138) = e138
      g(139) = e139
      g(140) = e140
      g(141) = e141
      g(142) = -e142
      g(143) = -e143
      g(144) = -e144
      g(145) = -e145
      g(146) = -e146
      g(147) = -e147
      g(148) = -e148
      g(149) = -e149
      g(150) = -e150
      g(151) = -e151
      g(152) = -e152
      g(153) = -e153
      g(154) = -e154
      g(155) = -e155
      g(156) = -e156
      g(157) = -e157
      g(158) = -e158
      g(159) = -e159
      g(160) = -e160
      g(161) = -e161
      g(162) = -e162
      g(163) = -e163
      g(164) = -e164
      g(165) = -e165
      g(166) = e166
      g(167) = e167
      g(168) = e168
      g(169) = e169
      g(170) = e170
      g(171) = e171
      g(172) = e172
      g(173) = e173
      g(174) = e174
      g(175) = e175
      g(176) = e176
      g(177) = e177
      g(178) = e178
      g(179) = e179
      g(180) = e180
      g(181) = e181
      g(182) = e182
      g(183) = e183
      g(184) = e184
      g(185) = e185
      g(186) = e186
      g(187) = e187
      g(188) = e188
      g(189) = e189
      
      do i=54,m
         g(i) = g(i)*1.0d-3
      end do   
      
  999 continue
      return
      end
 

      subroutine enpro48(  mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:37
*  
*  Equation counts
*     Total       E       G       L       N       X
*       215      33     149      33       0       0
*  
*  Variable counts
*                 x(       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       154      62      92       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       742     713      29       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /          x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /         x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /         x61, x62, b63, b64, b65, b66, b67, b68, b69, b70,
     /         b71, b72, b73, b74, b75, b76, b77, b78, b79, b80,
     /         b81, b82, b83, b84, b85, b86, b87, b88, b89, b90,
     /         b91, b92, b93, b94, b95, b96, b97, b98, b99,b100,
     /         b101,b102,b103,b104,b105,b106,b107,b108,b109,b110,
     /         b111,b112,b113,b114,b115,b116,b117,b118,b119,b120,
     /         b121,b122,b123,b124,b125,b126,b127,b128,b129,b130,
     /         b131,b132,b133,b134,b135,b136,b137,b138,b139,b140,
     /         b141,b142,b143,b144,b145,b146,b147,b148,b149,b150,
     /         b151,b152,b153,b154
      double precision
     /           e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /          e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /          e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /          e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /          e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /          e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /          e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /          e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /          e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /          e91, e92, e93, e94, e95, e96, e97, e98, e99,e100
      double precision
     /         e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /         e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /         e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /         e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /         e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /         e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /         e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /         e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /         e181,e182,e183,e184,e185,e186,e187,e188,e189,e190,
     /         e191,e192,e193,e194,e195,e196,e197,e198,e199,e200,
     /         e201,e202,e203,e204,e205,e206,e207,e208,e209,e210,
     /         e211,e212,e213,e214
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ENPRO48'
         pref  = '\cite{MINLPLib}'
         fex   = 187277.3d0
         ncont = 61
         nint  = 0
         nbin  = 92
         n     = ncont + nbin + nint
         m     = 214
         me    = 32
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 4.0d0
            xu(i) = 1.0d5
         end do
         xl(1) = 4.60517018598809 
         xu(1) = 8.00636756765025          
         xl(2) = 4.60517018598809 
         xu(2) = 8.00636756765025          
         xl(3) = 4.60517018598809 
         xu(3) = 8.00636756765025          
         xl(4) = 4.60517018598809 
         xu(4) = 8.00636756765025          
         xl(5) = 4.60517018598809 
         xu(5) = 8.00636756765025          
         xl(6) = 4.60517018598809 
         xu(6) = 8.00636756765025          
         xl(7) = 4.60517018598809 
         xu(7) = 8.00636756765025          
         xl(8) = 4.60517018598809 
         xu(8) = 8.00636756765025          
         xl(9) = 1.6094379124341 
         xu(9) = 6.90775527898214           
         xl(10) = 1.6094379124341 
         xu(10) = 6.90775527898214         
         xl(11) = 1.6094379124341 
         xu(11) = 6.90775527898214         
         xl(12) = 1.6094379124341 
         xu(12) = 6.90775527898214         
         xl(13) = 1.6094379124341 
         xu(13) = 6.90775527898214         
         xl(14) = 1.6094379124341 
         xu(14) = 6.90775527898214         
         xl(15) = 1.6094379124341 
         xu(15) = 6.90775527898214         
         xl(16) = 1.6094379124341 
         xu(16) = 6.90775527898214         
         xl(17) = 1.6094379124341 
         xu(17) = 6.84321675784456         
         xl(18) = 1.6094379124341 
         xu(18) = 6.84321675784456         
         xl(19) = 1.6094379124341
         xu(19) = 6.84321675784456         
         xl(20) = 1.6094379124341 
         xu(20) = 6.84321675784456         
         xl(21) = 1.6094379124341 
         xu(21) = 6.84321675784456         
         xl(22) = 1.6094379124341 
         xu(22) = 6.84321675784456         
         xl(23) = 1.6094379124341 
         xu(23) = 6.84321675784456         
         xl(24) = 1.6094379124341 
         xu(24) = 6.84321675784456         
         xl(25) = 2.30258509299405 
         xu(25) = 6.84321675784456        
         xl(26) = 2.30258509299405 
         xu(26) = 6.84321675784456        
         xl(27) = 2.30258509299405 
         xu(27) = 6.84321675784456        
         xl(28) = 2.30258509299405 
         xu(28) = 6.84321675784456        
         xl(29) = 2.30258509299405 
         xu(29) = 6.84321675784456        
         xl(30) = 2.30258509299405 
         xu(30) = 6.84321675784456        
         xl(31) = 2.30258509299405 
         xu(31) = 6.84321675784456        
         xl(32) = 2.30258509299405 
         xu(32) = 6.84321675784456        
         xl(33) = 1.6094379124341 
         xu(33) = 6.62007320653036         
         xl(34) = 1.6094379124341 
         xu(34) = 6.62007320653036         
         xl(35) = 1.6094379124341 
         xu(35) = 6.62007320653036         
         xl(36) = 1.6094379124341 
         xu(36) = 6.62007320653036         
         xl(37) = 1.6094379124341 
         xu(37) = 6.62007320653036         
         xl(38) = 1.6094379124341 
         xu(38) = 6.62007320653036         
         xl(39) = 1.6094379124341 
         xu(39) = 6.62007320653036         
         xl(40) = 1.6094379124341 
         xu(40) = 6.62007320653036         
         xu(41) = 1.38629436111989                                   
         xu(42) = 1.38629436111989                                   
         xu(43) = 1.38629436111989                                   
         xu(44) = 1.38629436111989                                   
         xu(45) = 1.38629436111989                                   
         xu(46) = 1.38629436111989                                   
         xu(47) = 1.38629436111989                                   
         xu(48) = 1.38629436111989                                   
         xu(49) = 1.38629436111989                                   
         xu(50) = 1.38629436111989                                   
         xu(51) = 1.38629436111989                                   
         xu(52) = 1.38629436111989                                   
         xu(53) = 1.38629436111989                                   
         xu(54) = 1.38629436111989                                   
         xu(55) = 1.38629436111989                                   
         xu(56) = 1.38629436111989                                   
         xl(58) = 4.60517018598809 
         xu(58) = 9.61580548008435        
         x(9)  = 4.25859659570812                                     
         x(10) = 4.25859659570812                                    
         x(11) = 4.25859659570812                                    
         x(12) = 4.25859659570812                                    
         x(13) = 4.25859659570812                                    
         x(14) = 4.25859659570812                                    
         x(15) = 4.25859659570812                                    
         x(16) = 4.25859659570812                                    
         x(17) = 4.22632733513933                                    
         x(18) = 4.22632733513933                                    
         x(19) = 4.22632733513933                                    
         x(20) = 4.22632733513933                                    
         x(21) = 4.22632733513933                                    
         x(22) = 4.22632733513933                                    
         x(23) = 4.22632733513933                                    
         x(24) = 4.22632733513933                                    
         x(25) = 4.57290092541931                                    
         x(26) = 4.57290092541931                                    
         x(27) = 4.57290092541931                                    
         x(28) = 4.57290092541931                                    
         x(29) = 4.57290092541931                                    
         x(30) = 4.57290092541931                                    
         x(31) = 4.57290092541931                                    
         x(32) = 4.57290092541931                                    
         x(33) = 4.11475555948223                                    
         x(34) = 4.11475555948223                                    
         x(35) = 4.11475555948223                                    
         x(36) = 4.11475555948223                                    
         x(37) = 4.11475555948223                                    
         x(38) = 4.11475555948223                                    
         x(39) = 4.11475555948223                                    
         x(40) = 4.11475555948223                                    
         x(49) = 0.693147180559945                                   
         x(50) = 0.693147180559945                                   
         x(51) = 0.693147180559945                                   
         x(52) = 0.693147180559945                                   
         x(53) = 0.693147180559945                                   
         x(54) = 0.693147180559945                                   
         x(55) = 0.693147180559945                                   
         x(56) = 0.693147180559945                                   
         x(58) = 7.11048783303622                                    
         do i = 41,56
            xl(i) = 0.0d0
         end do
         do i = 59,62
            xl(i) = -10.0d0
            x(i)  = -1.0d0
            xu(i) = 0.0d0
         end do
         do i=1,ncont
            if (x(i).lt.xl(i)) xl(i) = x(i)
            if (x(i).gt.xu(i)) xu(i) = x(i)
         end do   
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      b63 = y(1)
      b64 = y(2)
      b65 = y(3)
      b66 = y(4)
      b67 = y(5)
      b68 = y(6)
      b69 = y(7)
      b70 = y(8)
      b71 = y(9)
      b72 = y(10)
      b73 = y(11)
      b74 = y(12)
      b75 = y(13)
      b76 = y(14)
      b77 = y(15)
      b78 = y(16)
      b79 = y(17)
      b80 = y(18)
      b81 = y(19)
      b82 = y(20)
      b83 = y(21)
      b84 = y(22)
      b85 = y(23)
      b86 = y(24)
      b87 = y(25)
      b88 = y(26)
      b89 = y(27)
      b90 = y(28)
      b91 = y(29)
      b92 = y(30)
      b93 = y(31)
      b94 = y(32)
      b95 = y(33)
      b96 = y(34)
      b97 = y(35)
      b98 = y(36)
      b99 = y(37)
      b100 = y(38)
      b101 = y(39)
      b102 = y(40)
      b103 = y(41)
      b104 = y(42)
      b105 = y(43)
      b106 = y(44)
      b107 = y(45)
      b108 = y(46)
      b109 = y(47)
      b110 = y(48)
      b111 = y(49)
      b112 = y(50)
      b113 = y(51)
      b114 = y(52)
      b115 = y(53)
      b116 = y(54)
      b117 = y(55)
      b118 = y(56)
      b119 = y(57)
      b120 = y(58)
      b121 = y(59)
      b122 = y(60)
      b123 = y(61)
      b124 = y(62)
      b125 = y(63)
      b126 = y(64)
      b127 = y(65)
      b128 = y(66)
      b129 = y(67)
      b130 = y(68)
      b131 = y(69)
      b132 = y(70)
      b133 = y(71)
      b134 = y(72)
      b135 = y(73)
      b136 = y(74)
      b137 = y(75)
      b138 = y(76)
      b139 = y(77)
      b140 = y(78)
      b141 = y(79)
      b142 = y(80)
      b143 = y(81)
      b144 = y(82)
      b145 = y(83)
      b146 = y(84)
      b147 = y(85)
      b148 = y(86)
      b149 = y(87)
      b150 = y(88)
      b151 = y(89)
      b152 = y(90)
      b153 = y(91)
      b154 = y(92)

      f = 592.0d0*dexp(0.65d0*x1 + x41 + x49) 
     /     + 582.0d0*dexp(0.59d0*x2 + x42 + x50) 
     /     + 1200.0d0*dexp(0.52d0*x3 + x43 + x51) 
     /     + 200.0d0*dexp(0.7d0*x4 + x44 + x52) 
     /     + 582.0d0*dexp(0.39d0*x5 + x45 + x53) 
     /     + 850.0d0*dexp(0.8d0*x6 + x46 + x54) 
     /     + 592.0d0*dexp(0.65d0*x7 + x47 + x55) 
     /     + 1200.0d0*dexp(0.52d0*x8 + x48 + x56) 
     /     + 150.0d0*dexp(0.5d0*x58)

      e1 = x1 - x9 + x41 - 0.993251773010283  

      e2 = x2 - x10 + x42 - 0.336472236621213 

      e3 = x3 - x11 + x43 - 0.182321556793955 

      e4 = x4 - x12 + x44 - 0.53062825106217  

      e5 = x5 - x13 + x45 - 0.741937344729377 

      e6 = x6 - x14 + x46 - 1.09861228866811  

      e7 = x7 - x15 + x47 - 0.587786664902119 

      e8 = x8 - x16 + x48 - 0.8754687373539   

      e9 = x1 - x17 + x41 - 0.587786664902119 

      e10 = x2 - x18 + x42 - 0.0953101798043249 

      e11 = x3 - x19 + x43 - 0.741937344729377

      e12 = x4 - x20 + x44 - 0.78845736036427 

      e13 = x5 - x21 + x45 - 1.09861228866811 

      e14 = x6 - x22 + x46 - 1.1314021114911  

      e15 = x7 - x23 + x47 - 0.8754687373539  

      e16 = x8 - x24 + x48 - 1.16315080980568 

      e17 = x1 - x25 + x41 - 1.16315080980568 

      e18 = x2 - x26 + x42 - 0.0953101798043249 

      e19 = x3 - x27 + x43 - 0.182321556793955

      e20 = x4 - x28 + x44 + 0.105360515657826 

      e21 = x5 - x29 + x45 - 0.262364264467491

      e22 = x6 - x30 + x46 - 0.8754687373539  

      e23 = x7 - x31 + x47 - 0.916290731874155

      e24 = x8 - x32 + x48 + 0.105360515657826 

      e25 = x1 - x33 + x41 - 1.1314021114911  

      e26 = x2 - x34 + x42 - 1.38629436111989 

      e27 = x3 - x35 + x43 - 1.16315080980568 

      e28 = x4 - x36 + x44 - 0.182321556793955

      e29 = x5 - x37 + x45 - 0.8754687373539  

      e30 = x6 - x38 + x46 - 0.993251773010283

      e31 = x7 - x39 + x47 - 1.06471073699243 

      e32 = x8 - x40 + x48 - 1.1314021114911  

      e33 = x9 + x49 + x59 - 1.09861228866811 

      e34 = x10 + x50 + x59 - 0.693147180559945 

      e35 = x11 + x51 + x59 - 0.693147180559945 

      e36 = x12 + x52 + x59                     

      e37 = x13 + x53 + x59 - 1.38629436111989

      e38 = x14 + x54 + x59                     

      e39 = x15 + x55 + x59 - 1.09861228866811

      e40 = x16 + x56 + x59 - 0.693147180559945 

      e41 = x17 + x49 + x60 - 0.693147180559945 

      e42 = x18 + x50 + x60 - 1.38629436111989

      e43 = x19 + x51 + x60                     

      e44 = x20 + x52 + x60 - 1.09861228866811

      e45 = x21 + x53 + x60 - 1.6094379124341 

      e46 = x22 + x54 + x60 - 0.693147180559945 

      e47 = x23 + x55 + x60 - 1.38629436111989

      e48 = x24 + x56 + x60 - 1.79175946922805

      e49 = x25 + x49 + x61 - 1.79175946922805

      e50 = x26 + x50 + x61 - 0.693147180559945 

      e51 = x27 + x51 + x61 - 0.693147180559945 

      e52 = x28 + x52 + x61 - 0.693147180559945 

      e53 = x29 + x53 + x61 - 1.09861228866811

      e54 = x30 + x54 + x61 -  1.6094379124341 

      e55 = x31 + x55 + x61 - 0.693147180559945 

      e56 = x32 + x56 + x61 - 1.38629436111989

      e57 = x33 + x49 + x62 - 0.693147180559945 

      e58 = x34 + x50 + x62 - 1.09861228866811

      e59 = x35 + x51 + x62 - 1.79175946922805

      e60 = x36 + x52 + x62 - 1.6094379124341 

      e61 = x37 + x53 + x62 - 1.38629436111989

      e62 = x38 + x54 + x62 - 0.693147180559945 

      e63 = x39 + x55 + x62 - 0.693147180559945 

      e64 = x40 + x56 + x62 - 1.09861228866811

      e65 = 30000.0d0*dexp(x59) + 20000.0d0*dexp(x60)
     /      + 40000.0d0*dexp(x61) + 20000.0d0*dexp(x62) - 6000.0d0  
      e65 = -e65*1.0d-6

      e66 = -x10 + x58 - 10.0d0*b127 + 8.61370563888011d0

      e67 = -x11 + x58 - 10.0d0*b128 + 8.61370563888011d0

      e68 = -x12 + x58 - 10.0d0*b129 + 8.61370563888011d0

      e69 = -x13 + x58 - 10.0d0*b130 + 8.61370563888011d0

      e70 = -x14 + x58 - 10.0d0*b131 + 8.61370563888011d0

      e71 = -x15 + x58 - 10.0d0*b132 + 8.61370563888011d0

      e72 = -x16 + x58 - 10.0d0*b133 + 8.61370563888011d0

      e73 = -x18 + x58 - 10.0d0*b134 + 8.61370563888011d0

      e74 = -x19 + x58 - 10.0d0*b135 + 8.61370563888011d0

      e75 = -x20 + x58 - 10.0d0*b136 + 8.61370563888011d0

      e76 = -x21 + x58 - 10.0d0*b137 + 8.61370563888011d0

      e77 = -x22 + x58 - 10.0d0*b138 + 8.61370563888011d0

      e78 = -x23 + x58 - 10.0d0*b139 + 8.61370563888011d0

      e79 = -x24 + x58 - 10.0d0*b140 + 8.61370563888011d0

      e80 = -x26 + x58 - 10.0d0*b141 + 8.61370563888011d0

      e81 = -x27 + x58 - 10.0d0*b142 + 8.61370563888011d0

      e82 = -x28 + x58 - 10.0d0*b143 + 8.61370563888011d0

      e83 = -x29 + x58 - 10.0d0*b144 + 8.61370563888011d0

      e84 = -x30 + x58 - 10.0d0*b145 + 8.61370563888011d0

      e85 = -x31 + x58 - 10.0d0*b146 + 8.61370563888011d0

      e86 = -x32 + x58 - 10.0d0*b147 + 8.61370563888011d0

      e87 = -x34 + x58 - 10.0d0*b148 + 8.61370563888011d0

      e88 = -x35 + x58 - 10.0d0*b149 + 8.61370563888011d0

      e89 = -x36 + x58 - 10.0d0*b150 + 8.61370563888011d0

      e90 = -x37 + x58 - 10.0d0*b151 + 8.61370563888011d0

      e91 = -x38 + x58 - 10.0d0*b152 + 8.61370563888011d0

      e92 = -x39 + x58 - 10.0d0*b153 + 8.61370563888011d0

      e93 = -x40 + x58 - 10.0d0*b154 + 8.61370563888011d0

      e94 = -x9 + x58 - 10.0d0*b127 + 8.61370563888011d0 

      e95 = -x10 + x58 - 10.0d0*b128 + 8.61370563888011d0

      e96 = -x11 + x58 - 10.0d0*b129 + 8.61370563888011d0

      e97 = -x12 + x58 - 10.0d0*b130 + 8.61370563888011d0

      e98 = -x13 + x58 - 10.0d0*b131 + 8.61370563888011d0

      e99 = -x14 + x58 - 10.0d0*b132 + 8.61370563888011d0

      e100 = -x15 + x58 - 10.0d0*b133 + 8.61370563888011d0 

      e101 = -x17 + x58 - 10.0d0*b134 + 8.61370563888011d0 

      e102 = -x18 + x58 - 10.0d0*b135 + 8.61370563888011d0 

      e103 = -x19 + x58 - 10.0d0*b136 + 8.61370563888011d0 

      e104 = -x20 + x58 - 10.0d0*b137 + 8.61370563888011d0 

      e105 = -x21 + x58 - 10.0d0*b138 + 8.61370563888011d0 

      e106 = -x22 + x58 - 10.0d0*b139 + 8.61370563888011d0 

      e107 = -x23 + x58 - 10.0d0*b140 + 8.61370563888011d0 

      e108 = -x25 + x58 - 10.0d0*b141 + 8.61370563888011d0 

      e109 = -x26 + x58 - 10.0d0*b142 + 8.61370563888011d0 

      e110 = -x27 + x58 - 10.0d0*b143 + 8.61370563888011d0 

      e111 = -x28 + x58 - 10.0d0*b144 + 8.61370563888011d0 

      e112 = -x29 + x58 - 10.0d0*b145 + 8.61370563888011d0 

      e113 = -x30 + x58 - 10.0d0*b146 + 8.61370563888011d0 

      e114 = -x31 + x58 - 10.0d0*b147 + 8.61370563888011d0 

      e115 = -x33 + x58 - 10.0d0*b148 + 8.61370563888011d0 

      e116 = -x34 + x58 - 10.0d0*b149 + 8.61370563888011d0 

      e117 = -x35 + x58 - 10.0d0*b150 + 8.61370563888011d0 

      e118 = -x36 + x58 - 10.0d0*b151 + 8.61370563888011d0 

      e119 = -x37 + x58 - 10.0d0*b152 + 8.61370563888011d0 

      e120 = -x38 + x58 - 10.0d0*b153 + 8.61370563888011d0 

      e121 = -x39 + x58 - 10.0d0*b154 + 8.61370563888011d0 

      e122 = x41 - 0.693147180559945*b71 - 1.09861228866811*b79  
     /        - 1.38629436111989*b87 
     
      e123 = x42 - 0.693147180559945*b72 - 1.09861228866811*b80  
     /        - 1.38629436111989*b88               

      e124 = x43 - 0.693147180559945*b73 - 1.09861228866811*b81  
     /        - 1.38629436111989*b89               

      e125 = x44 - 0.693147180559945*b74 - 1.09861228866811*b82  
     /        - 1.38629436111989*b90               

      e126 = x45 - 0.693147180559945*b75 - 1.09861228866811*b83  
     /        - 1.38629436111989*b91               

      e127 = x46 - 0.693147180559945*b76 - 1.09861228866811*b84  
     /        - 1.38629436111989*b92               

      e128 = x47 - 0.693147180559945*b77 - 1.09861228866811*b85  
     /        - 1.38629436111989*b93               

      e129 = x48 - 0.693147180559945*b78 - 1.09861228866811*b86  
     /        - 1.38629436111989*b94               

      e130 = x49 - 0.693147180559945*b103 - 1.09861228866811*b111
     /        - 1.38629436111989*b119              

      e131 = x50 - 0.693147180559945*b104 - 1.09861228866811*b112
     /        - 1.38629436111989*b120              

      e132 = x51 - 0.693147180559945*b105 - 1.09861228866811*b113
     /        - 1.38629436111989*b121              

      e133 = x52 - 0.693147180559945*b106 - 1.09861228866811*b114
     /        - 1.38629436111989*b122              

      e134 = x53 - 0.693147180559945*b107 - 1.09861228866811*b115
     /        - 1.38629436111989*b123              

      e135 = x54 - 0.693147180559945*b108 - 1.09861228866811*b116
     /        - 1.38629436111989*b124              

      e136 = x55 - 0.693147180559945*b109 - 1.09861228866811*b117
     /        - 1.38629436111989*b125              

      e137 = x56 - 0.693147180559945*b110 - 1.09861228866811*b118
     /        - 1.38629436111989*b126              

      e138 = b63 + b71 + b79 + b87 - 1.0d0   

      e139 = b64 + b72 + b80 + b88 - 1.0d0   

      e140 = b65 + b73 + b81 + b89 - 1.0d0   

      e141 = b66 + b74 + b82 + b90 - 1.0d0        

      e142 = b67 + b75 + b83 + b91 - 1.0d0   

      e143 = b68 + b76 + b84 + b92 - 1.0d0   

      e144 = b69 + b77 + b85 + b93 - 1.0d0   

      e145 = b70 + b78 + b86 + b94 - 1.0d0   

      e146 = b95 + b103 + b111 + b119 - 1.0d0

      e147 = b96 + b104 + b112 + b120 - 1.0d0

      e148 = b97 + b105 + b113 + b121 - 1.0d0

      e149 = b98 + b106 + b114 + b122 - 1.0d0

      e150 = b99 + b107 + b115 + b123 - 1.0d0

      e151 = b100 + b108 + b116 + b124 - 1.0d0  

      e152 = b101 + b109 + b117 + b125 - 1.0d0  

      e153 = b102 + b110 + b118 + b126 - 1.0d0  

      e154 = b127 + b128 + b129 + b130 + b131 + b132 + b133 - 1.0d0

      e155 = b134 + b135 + b136 + b137 + b138 + b139 + b140 - 1.0d0

      e156 = b141 + b142 + b143 + b144 + b145 + b146 + b147 - 1.0d0

      e157 = b148 + b149 + b150 + b151 + b152 + b153 + b154 - 1.0d0

      e158 = b127 + b128 + b129 + b130 + b131 + b132 + b133 + b134 
     /      + b135 + b136 + b137 + b138 + b139 + b140 + b141 + b142 
     /      + b143 + b144 + b145 + b146 + b147 + b148 + b149 + b150 
     /      + b151 + b152 + b153 + b154 - 1.0d0          

      e159 = x9 - x10 - 0.693147180559945*b127  

      e160 = x10 - x11 - 0.693147180559945*b128 

      e161 = x11 - x12 - 0.693147180559945*b129 

      e162 = x12 - x13 - 0.693147180559945*b130 

      e163 = x13 - x14 - 0.693147180559945*b131 

      e164 = x14 - x15 - 0.693147180559945*b132 

      e165 = x15 - x16 - 0.693147180559945*b133 

      e166 = x17 - x18 - 0.693147180559945*b134 

      e167 = x18 - x19 - 0.693147180559945*b135 

      e168 = x19 - x20 - 0.693147180559945*b136 

      e169 = x20 - x21 - 0.693147180559945*b137 

      e170 = x21 - x22 - 0.693147180559945*b138 

      e171 = x22 - x23 - 0.693147180559945*b139 

      e172 = x23 - x24 - 0.693147180559945*b140 

      e173 = x25 - x26 - 0.693147180559945*b141 

      e174 = x26 - x27 - 0.693147180559945*b142 

      e175 = x27 - x28 - 0.693147180559945*b143 

      e176 = x28 - x29 - 0.693147180559945*b144 

      e177 = x29 - x30 - 0.693147180559945*b145 

      e178 = x30 - x31 - 0.693147180559945*b146 

      e179 = x31 - x32 - 0.693147180559945*b147 

      e180 = x33 - x34 - 0.693147180559945*b148 

      e181 = x34 - x35 - 0.693147180559945*b149 

      e182 = x35 - x36 - 0.693147180559945*b150 

      e183 = x36 - x37 - 0.693147180559945*b151 

      e184 = x37 - x38 - 0.693147180559945*b152 

      e185 = x38 - x39 - 0.693147180559945*b153 

      e186 = x39 - x40 - 0.693147180559945*b154 

      e187 = x9 - x10 + 0.693147180559945*b127  

      e188 = x10 - x11 + 0.693147180559945*b128 

      e189 = x11 - x12 + 0.693147180559945*b129 

      e190 = x12 - x13 + 0.693147180559945*b130 

      e191 = x13 - x14 + 0.693147180559945*b131 

      e192 = x14 - x15 + 0.693147180559945*b132 

      e193 = x15 - x16 + 0.693147180559945*b133 

      e194 = x17 - x18 + 0.693147180559945*b134 

      e195 = x18 - x19 + 0.693147180559945*b135 

      e196 = x19 - x20 + 0.693147180559945*b136 

      e197 = x20 - x21 + 0.693147180559945*b137 

      e198 = x21 - x22 + 0.693147180559945*b138 

      e199 = x22 - x23 + 0.693147180559945*b139 

      e200 = x23 - x24 + 0.693147180559945*b140 

      e201 = x25 - x26 + 0.693147180559945*b141 

      e202 = x26 - x27 + 0.693147180559945*b142 

      e203 = x27 - x28 + 0.693147180559945*b143 

      e204 = x28 - x29 + 0.693147180559945*b144 

      e205 = x29 - x30 + 0.693147180559945*b145 

      e206 = x30 - x31 + 0.693147180559945*b146 

      e207 = x31 - x32 + 0.693147180559945*b147 

      e208 = x33 - x34 + 0.693147180559945*b148 

      e209 = x34 - x35 + 0.693147180559945*b149 

      e210 = x35 - x36 + 0.693147180559945*b150 

      e211 = x36 - x37 + 0.693147180559945*b151 

      e212 = x37 - x38 + 0.693147180559945*b152 

      e213 = x38 - x39 + 0.693147180559945*b153 

      e214 = x39 - x40 + 0.693147180559945*b154 

      g(1) = e122
      g(2) = e123
      g(3) = e124
      g(4) = e125
      g(5) = e126
      g(6) = e127
      g(7) = e128
      g(8) = e129
      g(9) = e130
      g(10) = e131
      g(11) = e132
      g(12) = e133
      g(13) = e134
      g(14) = e135
      g(15) = e136
      g(16) = e137
      g(17) = e138
      g(18) = e139
      g(19) = e140
      g(20) = e141
      g(21) = e142
      g(22) = e143
      g(23) = e144
      g(24) = e145
      g(25) = e146
      g(26) = e147
      g(27) = e148
      g(28) = e149
      g(29) = e150
      g(30) = e151
      g(31) = e152
      g(32) = e153
      g(33) = e1
      g(34) = e2
      g(35) = e3
      g(36) = e4
      g(37) = e5
      g(38) = e6
      g(39) = e7
      g(40) = e8
      g(41) = e9
      g(42) = e10
      g(43) = e11
      g(44) = e12
      g(45) = e13
      g(46) = e14
      g(47) = e15
      g(48) = e16
      g(49) = e17
      g(50) = e18
      g(51) = e19
      g(52) = e20
      g(53) = e21
      g(54) = e22
      g(55) = e23
      g(56) = e24
      g(57) = e25
      g(58) = e26
      g(59) = e27
      g(60) = e28
      g(61) = e29
      g(62) = e30
      g(63) = e31
      g(64) = e32
      g(65) = e33
      g(66) = e34
      g(67) = e35
      g(68) = e36
      g(69) = e37
      g(70) = e38
      g(71) = e39
      g(72) = e40
      g(73) = e41
      g(74) = e42
      g(75) = e43
      g(76) = e44
      g(77) = e45
      g(78) = e46
      g(79) = e47
      g(80) = e48
      g(81) = e49
      g(82) = e50
      g(83) = e51
      g(84) = e52
      g(85) = e53
      g(86) = e54
      g(87) = e55
      g(88) = e56
      g(89) = e57
      g(90) = e58
      g(91) = e59
      g(92) = e60
      g(93) = e61
      g(94) = e62
      g(95) = e63
      g(96) = e64
      g(97) = e65
      g(98) = e66
      g(99) = e67
      g(100) = e68
      g(101) = e69
      g(102) = e70
      g(103) = e71
      g(104) = e72
      g(105) = e73
      g(106) = e74
      g(107) = e75
      g(108) = e76
      g(109) = e77
      g(110) = e78
      g(111) = e79
      g(112) = e80
      g(113) = e81
      g(114) = e82
      g(115) = e83
      g(116) = e84
      g(117) = e85
      g(118) = e86
      g(119) = e87
      g(120) = e88
      g(121) = e89
      g(122) = e90
      g(123) = e91
      g(124) = e92
      g(125) = e93
      g(126) = e94
      g(127) = e95
      g(128) = e96
      g(129) = e97
      g(130) = e98
      g(131) = e99
      g(132) = e100
      g(133) = e101
      g(134) = e102
      g(135) = e103
      g(136) = e104
      g(137) = e105
      g(138) = e106
      g(139) = e107
      g(140) = e108
      g(141) = e109
      g(142) = e110
      g(143) = e111
      g(144) = e112
      g(145) = e113
      g(146) = e114
      g(147) = e115
      g(148) = e116
      g(149) = e117
      g(150) = e118
      g(151) = e119
      g(152) = e120
      g(153) = e121
      g(154) = -e154
      g(155) = -e155
      g(156) = -e156
      g(157) = -e157
      g(158) = e158
      g(159) = -e159
      g(160) = -e160
      g(161) = -e161
      g(162) = -e162
      g(163) = -e163
      g(164) = -e164
      g(165) = -e165
      g(166) = -e166
      g(167) = -e167
      g(168) = -e168
      g(169) = -e169
      g(170) = -e170
      g(171) = -e171
      g(172) = -e172
      g(173) = -e173
      g(174) = -e174
      g(175) = -e175
      g(176) = -e176
      g(177) = -e177
      g(178) = -e178
      g(179) = -e179
      g(180) = -e180
      g(181) = -e181
      g(182) = -e182
      g(183) = -e183
      g(184) = -e184
      g(185) = -e185
      g(186) = -e186
      g(187) = e187
      g(188) = e188
      g(189) = e189
      g(190) = e190
      g(191) = e191
      g(192) = e192
      g(193) = e193
      g(194) = e194
      g(195) = e195
      g(196) = e196
      g(197) = e197
      g(198) = e198
      g(199) = e199
      g(200) = e200
      g(201) = e201
      g(202) = e202
      g(203) = e203
      g(204) = e204
      g(205) = e205
      g(206) = e206
      g(207) = e207
      g(208) = e208
      g(209) = e209
      g(210) = e210
      g(211) = e211
      g(212) = e212
      g(213) = e213
      g(214) = e214

  999 continue
      return
      end
 

      subroutine enpro56( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    
     
*  MINLP written by GAMS Convert at 04/17/01 16:37:40
*  
*  Equation counts
*     Total       E       G       L       N       X
*       192      25     136      31       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       128      55      73       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       651     627      24       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /          x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /         x51, x52, x53, x54, x55, b56, b57, b58, b59,b60,
     /         b61, b62, b63, b64, b65, b66, b67, b68, b69, b70, 
     /         b71, b72, b73, b74, b75, b76, b77, b78, b79, b80,
     /         b81, b82, b83, b84, b85, b86, b87, b88, b89, b90,
     /         b91, b92, b93, b94, b95, b96, b97, b98, b99,b100,
     /        b101,b102,b103,b104,b105,b106,b107,b108,b109,b110,
     /        b111,b112,b113,b114,b115,b116,b117,b118,b119,b120,
     /        b121,b122,b123,b124,b125,b126,b127,b128
      double precision 
     /           e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /          e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /          e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /          e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /          e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /          e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /          e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /          e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /          e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /          e91, e92, e93, e94, e95, e96, e97, e98, e99,e100
      double precision 
     /         e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /         e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /         e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /         e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /         e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /         e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /         e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /         e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /         e181,e182,e183,e184,e185,e186,e187,e188,e189,e190,
     /         e191
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ENPRO56'
         pref  = '\cite{MINLPLib}'
         fex   = 263428.3d0
         fex   = fex*1.0d-5
         ncont = 54
         nint  = 0
         nbin  = 73
         n     = ncont + nbin + nint
         m     = 191
         me    = 24
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 4.0d0
            xu(i) = 1.0d5
         enddo
         xl(1) = 5.7037824746562 
         xu(1) = 8.1605182474775            
         xl(2) = 5.7037824746562 
         xu(2) = 8.1605182474775            
         xl(3) = 5.7037824746562 
         xu(3) = 8.1605182474775            
         xl(4) = 5.7037824746562 
         xu(4) = 8.1605182474775            
         xl(5) = 5.7037824746562 
         xu(5) = 8.1605182474775            
         xl(6) = 5.7037824746562 
         xu(6) = 8.1605182474775            
         xl(7) = 4.45966260231685 
         xu(7) = 6.09365548800453          
         xl(8) = 4.45966260231685 
         xu(8) = 6.09365548800453          
         xl(9) = 4.45966260231685 
         xu(9) = 6.09365548800453          
         xl(10) = 4.45966260231685 
         xu(10) = 6.09365548800453        
         xl(11) = 4.45966260231685 
         xu(11) = 6.09365548800453        
         xl(12) = 4.45966260231685 
         xu(12) = 6.09365548800453        
         xl(13) = 3.74950407593037 
         xu(13) = 6.93674281585539        
         xl(14) = 3.74950407593037 
         xu(14) = 6.93674281585539        
         xl(15) = 3.74950407593037 
         xu(15) = 6.93674281585539        
         xl(16) = 3.74950407593037 
         xu(16) = 6.93674281585539        
         xl(17) = 3.74950407593037 
         xu(17) = 6.93674281585539        
         xl(18) = 3.74950407593037 
         xu(18) = 6.93674281585539        
         xl(19) = 4.49144142065975 
         xu(19) = 6.87958440201544        
         xl(20) = 4.49144142065975 
         xu(20) = 6.87958440201544        
         xl(21) = 4.49144142065975 
         xu(21) = 6.87958440201544        
         xl(22) = 4.49144142065975 
         xu(22) = 6.87958440201544        
         xl(23) = 4.49144142065975 
         xu(23) = 6.87958440201544        
         xl(24) = 4.49144142065975 
         xu(24) = 6.87958440201544        
         xl(25) = 3.14988295338125 
         xu(25) = 6.61295573876149        
         xl(26) = 3.14988295338125 
         xu(26) = 6.61295573876149        
         xl(27) = 3.14988295338125 
         xu(27) = 6.61295573876149        
         xl(28) = 3.14988295338125 
         xu(28) = 6.61295573876149        
         xl(29) = 3.14988295338125 
         xu(29) = 6.61295573876149        
         xl(30) = 3.14988295338125 
         xu(30) = 6.61295573876149        
         xl(31) = 3.04452243772342 
         xu(31) = 6.65644085070123        
         xl(32) = 3.04452243772342 
         xu(32) = 6.65644085070123        
         xl(33) = 3.04452243772342 
         xu(33) = 6.65644085070123        
         xl(34) = 3.04452243772342 
         xu(34) = 6.65644085070123        
         xl(35) = 3.04452243772342 
         xu(35) = 6.65644085070123        
         xl(36) = 3.04452243772342 
         xu(36) = 6.65644085070123        
         x(7)  = 5.27665904516069                                     
         x(8)  = 5.27665904516069                                     
         x(9)  = 5.27665904516069                                     
         x(10) = 5.27665904516069                                    
         x(11) = 5.27665904516069                                    
         x(12) = 5.27665904516069                                    
         x(13) = 5.34312344589288                                    
         x(14) = 5.34312344589288                                    
         x(15) = 5.34312344589288                                    
         x(16) = 5.34312344589288                                    
         x(17) = 5.34312344589288                                    
         x(18) = 5.34312344589288                                    
         x(19) = 5.68551291133759                                    
         x(20) = 5.68551291133759                                    
         x(21) = 5.68551291133759                                    
         x(22) = 5.68551291133759                                    
         x(23) = 5.68551291133759                                    
         x(24) = 5.68551291133759                                    
         x(25) = 4.88141934607137                                    
         x(26) = 4.88141934607137                                    
         x(27) = 4.88141934607137                                    
         x(28) = 4.88141934607137                                    
         x(29) = 4.88141934607137                                    
         x(30) = 4.88141934607137                                    
         x(31) = 4.85048164421233                                    
         x(32) = 4.85048164421233                                    
         x(33) = 4.85048164421233                                    
         x(34) = 4.85048164421233                                    
         x(35) = 4.85048164421233                                    
         x(36) = 4.85048164421233   
         do i=37,48  
            xl(i) = 0.0d0                             
            x(i)  = 0.693147180559945                                   
            xu(i) = 1.38629436111989             
         end do   
         xl(50) = 4.60517018598809 
         x(50)  = 7.11048783303622                                    
         xu(50) = 9.61580548008435        
         do i=51,55
            xl(i) = -10.0d0
            x(i)  = -5.0d0
            xu(i) = 0.0d0
         end do   
         do i=1,ncont
            if (x(i).lt.xl(i)) x(i) = 0.5d0*(xl(i) + xu(i))
            if (x(i).gt.xu(i)) x(i) = 0.5d0*(xl(i) + xu(i))
         enddo   
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      b56 = y(1)
      b57 = y(2)
      b58 = y(3)
      b59 = y(4)
      b60 = y(5)
      b61 = y(6)
      b62 = y(7)
      b63 = y(8)
      b64 = y(9)
      b65 = y(10)
      b66 = y(11)
      b67 = y(12)
      b68 = y(13)
      b69 = y(14)
      b70 = y(15)
      b71 = y(16)
      b72 = y(17)
      b73 = y(18)
      b74 = y(19)
      b75 = y(20)
      b76 = y(21)
      b77 = y(22)
      b78 = y(23)
      b79 = y(24)
      b80 = y(25)
      b81 = y(26)
      b82 = y(27)
      b83 = y(28)
      b84 = y(29)
      b85 = y(30)
      b86 = y(31)
      b87 = y(32)
      b88 = y(33)
      b89 = y(34)
      b90 = y(35)
      b91 = y(36)
      b92 = y(37)
      b93 = y(38)
      b94 = y(39)
      b95 = y(40)
      b96 = y(41)
      b97 = y(42)
      b98 = y(43)
      b99 = y(44)
      b100 = y(45)
      b101 = y(46)
      b102 = y(47)
      b103 = y(48)
      b104 = y(49)
      b105 = y(50)
      b106 = y(51)
      b107 = y(52)
      b108 = y(53)
      b109 = y(54)
      b110 = y(55)
      b111 = y(56)
      b112 = y(57)
      b113 = y(58)
      b114 = y(59)
      b115 = y(60)
      b116 = y(61)
      b117 = y(62)
      b118 = y(63)
      b119 = y(64)
      b120 = y(65)
      b121 = y(66)
      b122 = y(67)
      b123 = y(68)
      b124 = y(69)
      b125 = y(70)
      b126 = y(71)
      b127 = y(72)
      b128 = y(73)

      f = -(-(250.0d0*(dexp(0.6d0*x1 + x37 + x43) 
     /     + dexp(0.6d0*x2 + x38 + x44) + dexp(0.6d0*x3 + x39 + x45) 
     /     + dexp(0.6d0*x4 + x40 + x46) + dexp(0.6d0*x5 + x41 + x47) 
     /     + dexp(0.6d0*x6 + x42 + x48)) + 150.0d0*dexp(0.5d0*x50)))
c      f = f*1.0d-5

      e1 = x1 - x7 + x37 - 2.06686275947298  

      e2 = x2 - x8 + x38 - 0.693147180559945 

      e3 = x3 - x9 + x39 - 1.64865862558738  

      e4 = x4 - x10 + x40 - 1.58923520511658 

      e5 = x5 - x11 + x41 - 1.80828877117927 

      e6 = x6 - x12 + x42 - 1.43508452528932 

      e7 = x1 - x13 + x37 + 0.356674943938732    

      e8 = x2 - x14 + x38 + 0.22314355131421

      e9 = x3 - x15 + x39 + 0.105360515657826    

      e10 = x4 - x16 + x40 - 1.22377543162212

      e11 = x5 - x17 + x41 - 0.741937344729377    

      e12 = x6 - x18 + x42 - 0.916290731874155    

      e13 = x1 - x19 + x37 + 0.356674943938732   

      e14 = x2 - x20 + x38 - 0.955511445027436    

      e15 = x3 - x21 + x39 - 0.470003629245736    

      e16 = x4 - x22 + x40 - 1.28093384546206

      e17 = x5 - x23 + x41 - 1.16315080980568

      e18 = x6 - x24 + x42 - 1.06471073699243

      e19 = x1 - x25 + x37 - 1.54756250871601

      e20 = x2 - x26 + x38 - 0.832909122935104    

      e21 = x3 - x27 + x39 - 0.470003629245736    

      e22 = x4 - x28 + x40 - 0.993251773010283    

      e23 = x5 - x29 + x41 - 0.182321556793955    

      e24 = x6 - x30 + x42 - 0.916290731874155    

      e25 = x1 - x31 + x37 - 0.182321556793955    

      e26 = x2 - x32 + x38 - 1.28093384546206

      e27 = x3 - x33 + x39 - 0.8754687373539 

      e28 = x4 - x34 + x40 - 1.50407739677627

      e29 = x5 - x35 + x41 - 0.470003629245736    

      e30 = x6 - x36 + x42 - 0.741937344729377    

      e31 = x7 + x43 + x51 - 1.85629799036563

      e32 = x8 + x44 + x51 - 1.54756250871601

      e33 = x9 + x45 + x51 - 2.11625551480255

      e34 = x10 + x46 + x51 - 1.3609765531356

      e35 = x11 + x47 + x51 - 0.741937344729377   

      e36 = x12 + x48 + x51 - 0.182321556793955   

      e37 = x13 + x43 + x52 - 1.91692261218206    

      e38 = x14 + x44 + x52 - 1.85629799036563    

      e39 = x15 + x45 + x52 - 1.87180217690159    

      e40 = x16 + x46 + x52 - 1.48160454092422    

      e41 = x17 + x47 + x52 - 0.832909122935104   

      e42 = x18 + x48 + x52 - 1.16315080980568    

      e43 = x19 + x43 + x53                    

      e44 = x20 + x44 + x53 - 1.84054963339749    

      e45 = x21 + x45 + x53 - 1.68639895357023    

      e46 = x22 + x46 + x53 - 2.47653840011748    

      e47 = x23 + x47 + x53 - 1.7404661748405

      e48 = x24 + x48 + x53 - 1.82454929205105    

      e49 = x25 + x43 + x54 - 1.16315080980568    

      e50 = x26 + x44 + x54 - 1.09861228866811    

      e51 = x27 + x45 + x54 - 1.25276296849537    

      e52 = x28 + x46 + x54 - 1.19392246847243    

      e53 = x29 + x47 + x54 - 1.02961941718116    

      e54 = x30 + x48 + x54 - 1.22377543162212    

      e55 = x31 + x43 + x55 - 0.741937344729377   

      e56 = x32 + x44 + x55 - 0.916290731874155   

      e57 = x33 + x45 + x55 - 1.43508452528932    

      e58 = x34 + x46 + x55 - 1.28093384546206    

      e59 = x35 + x47 + x55 - 1.30833281965018    

      e60 = x36 + x48 + x55 - 0.78845736036427    

      e61 = 250000.0d0*dexp(x51) + 150000.0d0*dexp(x52) 
     /      + 180000.0d0*dexp(x53) + 160000.0d0*dexp(x54) 
     /      + 120000.0d0*dexp(x55) - 6000.0d0
      e61 = e61*1.0d-6

      e62 = -x8 + x50 - 10.0d0*b104 + 7.69741490700595

      e63 = -x9 + x50 - 10.0d0*b105 + 7.69741490700595

      e64 = -x10 + x50 - 10.0d0*b106 + 7.69741490700595           

      e65 = -x11 + x50 - 10.0d0*b107 + 7.69741490700595           

      e66 = -x12 + x50 - 10.0d0*b108 + 7.69741490700595           

      e67 = -x14 + x50 - 10.0d0*b109 + 7.69741490700595           

      e68 = -x15 + x50 - 10.0d0*b110 + 7.69741490700595           

      e69 = -x16 + x50 - 10.0d0*b111 + 7.69741490700595           

      e70 = -x17 + x50 - 10.0d0*b112 + 7.69741490700595           

      e71 = -x18 + x50 - 10.0d0*b113 + 7.69741490700595           

      e72 = -x20 + x50 - 10.0d0*b114 + 7.69741490700595           

      e73 = -x21 + x50 - 10.0d0*b115 + 7.69741490700595           

      e74 = -x22 + x50 - 10.0d0*b116 + 7.69741490700595           

      e75 = -x23 + x50 - 10.0d0*b117 + 7.69741490700595           

      e76 = -x24 + x50 - 10.0d0*b118 + 7.69741490700595           

      e77 = -x26 + x50 - 10.0d0*b119 + 7.69741490700595           

      e78 = -x27 + x50 - 10.0d0*b120 + 7.69741490700595           

      e79 = -x28 + x50 - 10.0d0*b121 + 7.69741490700595           

      e80 = -x29 + x50 - 10.0d0*b122 + 7.69741490700595           

      e81 = -x30 + x50 - 10.0d0*b123 + 7.69741490700595           

      e82 = -x32 + x50 - 10.0d0*b124 + 7.69741490700595           

      e83 = -x33 + x50 - 10.0d0*b125 + 7.69741490700595           

      e84 = -x34 + x50 - 10.0d0*b126 + 7.69741490700595           

      e85 = -x35 + x50 - 10.0d0*b127 + 7.69741490700595           

      e86 = -x36 + x50 - 10.0d0*b128 + 7.69741490700595           

      e87 = -x7 + x50 - 10.0d0*b104 + 7.69741490700595

      e88 = -x8 + x50 - 10.0d0*b105 + 7.69741490700595

      e89 = -x9 + x50 - 10.0d0*b106 + 7.69741490700595

      e90 = -x10 + x50 - 10.0d0*b107 + 7.69741490700595           

      e91 = -x11 + x50 - 10.0d0*b108 + 7.69741490700595           

      e92 = -x13 + x50 - 10.0d0*b109 + 7.69741490700595           

      e93 = -x14 + x50 - 10.0d0*b110 + 7.69741490700595           

      e94 = -x15 + x50 - 10.0d0*b111 + 7.69741490700595           

      e95 = -x16 + x50 - 10.0d0*b112 + 7.69741490700595           

      e96 = -x17 + x50 - 10.0d0*b113 + 7.69741490700595           

      e97 = -x19 + x50 - 10.0d0*b114 + 7.69741490700595           

      e98 = -x20 + x50 - 10.0d0*b115 + 7.69741490700595           

      e99 = -x21 + x50 - 10.0d0*b116 + 7.69741490700595           

      e100 = -x22 + x50 - 10.0d0*b117 + 7.69741490700595          

      e101 = -x23 + x50 - 10.0d0*b118 + 7.69741490700595          

      e102 = -x25 + x50 - 10.0d0*b119 + 7.69741490700595          

      e103 = -x26 + x50 - 10.0d0*b120 + 7.69741490700595          

      e104 = -x27 + x50 - 10.0d0*b121 + 7.69741490700595          

      e105 = -x28 + x50 - 10.0d0*b122 + 7.69741490700595          

      e106 = -x29 + x50 - 10.0d0*b123 + 7.69741490700595          

      e107 = -x31 + x50 - 10.0d0*b124 + 7.69741490700595          

      e108 = -x32 + x50 - 10.0d0*b125 + 7.69741490700595          

      e109 = -x33 + x50 - 10.0d0*b126 + 7.69741490700595          

      e110 = -x34 + x50 - 10.0d0*b127 + 7.69741490700595          

      e111 = -x35 + x50 - 10.0d0*b128 + 7.69741490700595          

      e112 = x37 - 0.693147180559945*b62 - 1.09861228866811*b68 
     /        - 1.38629436111989*b74              

      e113 = x38 - 0.693147180559945*b63 - 1.09861228866811*b69 
     /        - 1.38629436111989*b75              

      e114 = x39 - 0.693147180559945*b64 - 1.09861228866811*b70 
     /        - 1.38629436111989*b76              

      e115 = x40 - 0.693147180559945*b65 - 1.09861228866811*b71 
     /        - 1.38629436111989*b77              

      e116 = x41 - 0.693147180559945*b66 - 1.09861228866811*b72 
     /        - 1.38629436111989*b78              

      e117 = x42 - 0.693147180559945*b67 - 1.09861228866811*b73 
     /        - 1.38629436111989*b79              

      e118 = x43 - 0.693147180559945*b86 - 1.09861228866811*b92 
     /        - 1.38629436111989*b98              

      e119 = x44 - 0.693147180559945*b87 - 1.09861228866811*b93 
     /        - 1.38629436111989*b99              

      e120 = x45 - 0.693147180559945*b88 - 1.09861228866811*b94 
     /        - 1.38629436111989*b100             

      e121 = x46 - 0.693147180559945*b89 - 1.09861228866811*b95 
     /        - 1.38629436111989*b101             

      e122 = x47 - 0.693147180559945*b90 - 1.09861228866811*b96 
     /        - 1.38629436111989*b102             

      e123 = x48 - 0.693147180559945*b91 - 1.09861228866811*b97 
     /        - 1.38629436111989*b103             

      e124 = b56 + b62 + b68 + b74 - 1.0d0       

      e125 = b57 + b63 + b69 + b75 - 1.0d0       

      e126 = b58 + b64 + b70 + b76 - 1.0d0       

      e127 = b59 + b65 + b71 + b77 - 1.0d0       

      e128 = b60 + b66 + b72 + b78 - 1.0d0       

      e129 = b61 + b67 + b73 + b79 - 1.0d0       

      e130 = b80 + b86 + b92 + b98 - 1.0d0       

      e131 = b81 + b87 + b93 + b99 - 1.0d0       

      e132 = b82 + b88 + b94 + b100 - 1.0d0      

      e133 = b83 + b89 + b95 + b101 - 1.0d0      

      e134 = b84 + b90 + b96 + b102 - 1.0d0      

      e135 = b85 + b91 + b97 + b103 - 1.0d0      

      e136 = b104 + b105 + b106 + b107 + b108 - 1.0d0 

      e137 = b109 + b110 + b111 + b112 + b113 - 1.0d0 

      e138 = b114 + b115 + b116 + b117 + b118 - 1.0d0 

      e139 = b119 + b120 + b121 + b122 + b123 - 1.0d0 

      e140 = b124 + b125 + b126 + b127 + b128 - 1.0d0 

      e141 = b104 + b105 + b106 + b107 + b108 + b109 + b110 + b111 
     /          + b112 + b113 + b114 + b115 + b116 + b117 + b118 + b119 
     /          + b120 + b121 + b122 + b123 + b124 + b125 + b126 + b127
     /          + b128 - 1.0d0

      e142 = x7 - x8 - 0.693147180559945*b104  

      e143 = x8 - x9 - 0.693147180559945*b105  

      e144 = x9 - x10 - 0.693147180559945*b106 

      e145 = x10 - x11 - 0.693147180559945*b107

      e146 = x11 - x12 - 0.693147180559945*b108

      e147 = x13 - x14 - 0.693147180559945*b109

      e148 = x14 - x15 - 0.693147180559945*b110

      e149 = x15 - x16 - 0.693147180559945*b111

      e150 = x16 - x17 - 0.693147180559945*b112

      e151 = x17 - x18 - 0.693147180559945*b113

      e152 = x19 - x20 - 0.693147180559945*b114

      e153 = x20 - x21 - 0.693147180559945*b115

      e154 = x21 - x22 - 0.693147180559945*b116

      e155 = x22 - x23 - 0.693147180559945*b117

      e156 = x23 - x24 - 0.693147180559945*b118

      e157 = x25 - x26 - 0.693147180559945*b119

      e158 = x26 - x27 - 0.693147180559945*b120

      e159 = x27 - x28 - 0.693147180559945*b121

      e160 = x28 - x29 - 0.693147180559945*b122

      e161 = x29 - x30 - 0.693147180559945*b123

      e162 = x31 - x32 - 0.693147180559945*b124

      e163 = x32 - x33 - 0.693147180559945*b125

      e164 = x33 - x34 - 0.693147180559945*b126

      e165 = x34 - x35 - 0.693147180559945*b127

      e166 = x35 - x36 - 0.693147180559945*b128

      e167 = x7 - x8 + 0.693147180559945*b104  

      e168 = x8 - x9 + 0.693147180559945*b105  

      e169 = x9 - x10 + 0.693147180559945*b106 

      e170 = x10 - x11 + 0.693147180559945*b107

      e171 = x11 - x12 + 0.693147180559945*b108

      e172 = x13 - x14 + 0.693147180559945*b109

      e173 = x14 - x15 + 0.693147180559945*b110

      e174 = x15 - x16 + 0.693147180559945*b111

      e175 = x16 - x17 + 0.693147180559945*b112

      e176 = x17 - x18 + 0.693147180559945*b113

      e177 = x19 - x20 + 0.693147180559945*b114

      e178 = x20 - x21 + 0.693147180559945*b115

      e179 = x21 - x22 + 0.693147180559945*b116

      e180 = x22 - x23 + 0.693147180559945*b117

      e181 = x23 - x24 + 0.693147180559945*b118

      e182 = x25 - x26 + 0.693147180559945*b119

      e183 = x26 - x27 + 0.693147180559945*b120

      e184 = x27 - x28 + 0.693147180559945*b121

      e185 = x28 - x29 + 0.693147180559945*b122

      e186 = x29 - x30 + 0.693147180559945*b123

      e187 = x31 - x32 + 0.693147180559945*b124

      e188 = x32 - x33 + 0.693147180559945*b125

      e189 = x33 - x34 + 0.693147180559945*b126

      e190 = x34 - x35 + 0.693147180559945*b127

      e191 = x35 - x36 + 0.693147180559945*b128   
    
      g(1) = e112
      g(2) = e113
      g(3) = e114
      g(4) = e115
      g(5) = e116
      g(6) = e117
      g(7) = e118
      g(8) = e119
      g(9) = e120
      g(10) = e121
      g(11) = e122
      g(12) = e123
      g(13) = e124
      g(14) = e125
      g(15) = e126
      g(16) = e127
      g(17) = e128
      g(18) = e129
      g(19) = e130
      g(20) = e131
      g(21) = e132
      g(22) = e133
      g(23) = e134
      g(24) = e135
      g(25) = e1
      g(26) = e2
      g(27) = e3
      g(28) = e4
      g(29) = e5
      g(30) = e6
      g(31) = e7
      g(32) = e8
      g(33) = e9
      g(34) = e10
      g(35) = e11
      g(36) = e12
      g(37) = e13
      g(38) = e14
      g(39) = e15
      g(40) = e16
      g(41) = e17
      g(42) = e18
      g(43) = e19
      g(44) = e20
      g(45) = e21
      g(46) = e22
      g(47) = e23
      g(48) = e24
      g(49) = e25
      g(50) = e26
      g(51) = e27
      g(52) = e28
      g(53) = e29
      g(54) = e30
      g(55) = e31
      g(56) = e32
      g(57) = e33
      g(58) = e34
      g(59) = e35
      g(60) = e36
      g(61) = e37
      g(62) = e38
      g(63) = e39
      g(64) = e40
      g(65) = e41
      g(66) = e42
      g(67) = e43
      g(68) = e44
      g(69) = e45
      g(70) = e46
      g(71) = e47
      g(72) = e48
      g(73) = e49
      g(74) = e50
      g(75) = e51
      g(76) = e52
      g(77) = e53
      g(78) = e54
      g(79) = e55
      g(80) = e56
      g(81) = e57
      g(82) = e58
      g(83) = e59
      g(84) = e60
      g(85) = -e61
      g(86) = e62
      g(87) = e63
      g(88) = e64
      g(89) = e65
      g(90) = e66
      g(91) = e67
      g(92) = e68
      g(93) = e69
      g(94) = e70
      g(95) = e71
      g(96) = e72
      g(97) = e73
      g(98) = e74
      g(99) = e75
      g(100) = e76
      g(101) = e77
      g(102) = e78
      g(103) = e79
      g(104) = e80
      g(105) = e81
      g(106) = e82
      g(107) = e83
      g(108) = e84
      g(109) = e85
      g(110) = e86
      g(111) = e87
      g(112) = e88
      g(113) = e89
      g(114) = e90
      g(115) = e91
      g(116) = e92
      g(117) = e93
      g(118) = e94
      g(119) = e95
      g(120) = e96
      g(121) = e97
      g(122) = e98
      g(123) = e99
      g(124) = e100
      g(125) = e101
      g(126) = e102
      g(127) = e103
      g(128) = e104
      g(129) = e105
      g(130) = e106
      g(131) = e107
      g(132) = e108
      g(133) = e109
      g(134) = e110
      g(135) = e111
      g(136) = -e136
      g(137) = -e137
      g(138) = -e138
      g(139) = -e139
      g(140) = -e140
      g(141) = e141
      g(142) = -e142
      g(143) = -e143
      g(144) = -e144
      g(145) = -e145
      g(146) = -e146
      g(147) = -e147
      g(148) = -e148
      g(149) = -e149
      g(150) = -e150
      g(151) = -e151
      g(152) = -e152
      g(153) = -e153
      g(154) = -e154
      g(155) = -e155
      g(156) = -e156
      g(157) = -e157
      g(158) = -e158
      g(159) = -e159
      g(160) = -e160
      g(161) = -e161
      g(162) = -e162
      g(163) = -e163
      g(164) = -e164
      g(165) = -e165
      g(166) = -e166
      g(167) = e167
      g(168) = e168
      g(169) = e169
      g(170) = e170
      g(171) = e171
      g(172) = e172
      g(173) = e173
      g(174) = e174
      g(175) = e175
      g(176) = e176
      g(177) = e177
      g(178) = e178
      g(179) = e179
      g(180) = e180
      g(181) = e181
      g(182) = e182
      g(183) = e183
      g(184) = e184
      g(185) = e185
      g(186) = e186
      g(187) = e187
      g(188) = e188
      g(189) = e189
      g(190) = e190
      g(191) = e191

  999 continue
      return
      end
 
 
      subroutine ex1221( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    
 
*  MINLP written by GAMS Convert at 04/17/01 16:37:42
*  
*  Equation counts
*     Total       E       G       L       N       X
*         6       3       0       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         6       3       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        17      15       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, x1, x2, b3, b4, b5, e2, e3, e4, e5, e6
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1221'
         pref  = '\cite{MINLPLib}'
         fex   = 7.66718006881d0   
         ncont = 2
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 5
         me    = 2
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d1
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
  
      x1 = x(1)
      x2 = x(2)
      b3 = y(1)
      b4 = y(2)
      b5 = y(3)
      
      f=  2.0d0*x1 + 3.0d0*x2 + 1.5d0*b3 + 2.0d0*b4 - 0.5d0*b5   

      e2 = sqr(x1) + b3 - 1.25d0           
      
      e3 = x2**1.5d0 + 1.5d0*b4 - 3.0d0

      e4 = x1 + b3 - 1.6d0          

      e5 = 1.333d0*x2 + b4 - 3.0d0     

      e6 = -b3 - b4 + b5         

      g(1) = e2
      g(2) = e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6

  999 continue 
      return 
      end 

      subroutine ex1222(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:44
*  
*  Equation counts
*     Total       E       G       L       N       X
*         4       1       0       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       3       1       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         9       7       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, x1, x2, b3, e1, e2, e3
     /        
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1222'
         pref  = '\cite{MINLPLib}'
         fex   = 1.076543d0
         ncont = 2
         nint  = 0
         nbin  = 1
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         xl(1) = 0.2d0  
         x(1)  = 0.5d0  
         xu(1) = 1.0d0                                      
         xl(2) = -2.22554d0
         x(2)  = -1.5d0  
         xu(2) = -1.0d0                                
         xl(3) = 0.0d0
         x(3)  = 0.0d0
         xu(3) = 1.0d0         
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1 = x(1)
      x2 = x(2)
      b3 = y(1)

      f = 5.0d0*sqr(x1 - 0.5d0) - 0.7d0*b3 + 0.8d0

      e1 = -dexp(x1 - 0.2d0) - x2   
      
      e2 =  x2 + 1.1d0*b3 + 1.0d0    
      
      e3 =  x1 - 1.2d0*b3    
      
      g(1) = -e1
      g(2) = -e2
      g(3) = -e3

  999 continue
      return
      end
 
 
      subroutine ex1223( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    
 
*  MINLP written by GAMS Convert at 04/17/01 16:37:46
*  
*  Equation counts
*     Total       E       G       L       N       X
*        14       5       0       9       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        12       8       4       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        40      23      17       0
*
*  Solve m using MINLP minimizing objvar;
 
      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, sqr,
     /        g(mmax), x1, x2, x3, x4, x5, x6, x7, b8, b9, b10, b11,
     /        e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1223'
         pref  = '\cite{MINLPLib}'
         fex   = 4.579582d0     
         ncont = 7
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 13
         me    = 4
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i) = 1.0d0
            xu(i) = 1.0d0
         enddo
         xu(1) = 1.0d1
         xu(2) = 1.0d1
         xu(3) = 1.0d1
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      x6  = x(6)
      x7  = x(7)
      b8  = x(8)
      b9  = x(9)
      b10 = x(10)
      b11 = x(11)
  
      f = sqr(x4 - 1.0d0) + sqr(x5 - 2.0d0) + sqr(x6 - 1.0d0) 
     /    - dlog(1.0d0 + x7) + sqr(x1 - 1.0d0) 
     /    + sqr(x2 - 2.0d0) + sqr(x3 - 3.0d0)

      e1 = x1 + x2 + x3 + b8 + b9 + b10 - 5.0d0      

      e2 = sqr(x6) + sqr(x1) + sqr(x2) + sqr(x3) - 5.5d0 

      e3 = x1 + b8 - 1.2d0                            

      e4 = x2 + b9 - 1.8d0                            

      e5 = x3 + b10 - 2.5d0                           

      e6 = x1 + b11 - 1.2d0                           

      e7 = sqr(x5) + sqr(x2) - 1.64d0

      e8 = sqr(x6) + sqr(x3) - 4.25d0                    

      e9 = sqr(x5) + sqr(x3) - 4.64d0                    

      e10 = x4 - b8                                   

      e11 = x5 - b9                                   

      e12 = x6 - b10                                  

      e13 = x7 - b11 

      g( 1) = e10
      g( 2) = e11
      g( 3) = e12
      g( 4) = e13
      g( 5) = -e1
      g( 6) = -e2
      g( 7) = -e3
      g( 8) = -e4
      g( 9) = -e5
      g(10) = -e6
      g(11) = -e7
      g(12) = -e8
      g(13) = -e9

  999 continue 
      return 
      end 

      subroutine ex1223a(  mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:48
*  
*  Equation counts
*     Total       E       G       L       N       X
*        10       1       0       9       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         8       4       4       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        32      23       9       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, x1, x2, x3, b4, b5, b6, b7, e1, e2, e3,
     /        e4, e5, e6, e7, e8, e9
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1223A'
         pref  = '\cite{MINLPLib}'
         fex   = 4.579582d0
         ncont = 3
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d1
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo

         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      b4 = y(1)
      b5 = y(2)
      b6 = y(3)
      b7 = y(4)

      f = (sqr(x1 - 1.0d0) + sqr(x2 - 2.0d0) + sqr(x3 - 3.0d0)) - b4 
     /    - 3.0d0*b5 - b6 - 0.693147180559945d0*b7 + 6.0d0

      e1 = x1 + x2 + x3 + b4 + b5 + b6 - 5.0d0

      e2 = sqr(x1) + sqr(x2) + sqr(x3) + b6 - 5.5d0 

      e3 = x1 + b4 - 1.2d0           

      e4 = x2 + b5 - 1.8d0           

      e5 = x3 + b6 - 2.5d0           

      e6 = x1 + b7 - 1.2d0

      e7 = sqr(x2) + b5 - 1.64d0          

      e8 = sqr(x3) + b6 - 4.25d0          

      e9 = sqr(x3) + b5 - 4.64d0

      g(1) = -e1
      g(2) = -e2
      g(3) = -e3
      g(4) = -e4
      g(5) = -e5
      g(6) = -e6
      g(7) = -e7
      g(8) = -e8
      g(9) = -e9

  999 continue
      return
      end
 

      subroutine ex1223b(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:50
*  
*  Equation counts
*     Total       E       G       L       N       X
*        10       1       0       9       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         8       4       4       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        32      15      17       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, x1, x2, x3, b4, b5, b6, b7, e1, e2, e3,
     /        e4, e5, e6, e7, e8, e9
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1223B'
         pref  = '\cite{MINLPLib}'
         fex   = 4.579582d0
         ncont = 3
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d1
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      b4 = y(1)
      b5 = y(2)
      b6 = y(3)
      b7 = y(4)

      f = sqr(b4 - 1.0d0) + sqr(b5 - 2.0d0) + sqr(b6 - 1.0d0) 
     /    - dlog(1.0d0 + b7) + sqr(x1 - 1.0d0) + sqr(x2 - 2.0d0) 
     /    + sqr(x3 - 3.0d0)

      e1 = x1 + x2 + x3 + b4 + b5 + b6 - 5.0d0              

      e2 = sqr(b6) + sqr(x1) + sqr(x2) + sqr(x3) - 5.5d0     

      e3 = x1 + b4 - 1.2d0                                

      e4 = x2 + b5 - 1.8d0                                

      e5 = x3 + b6 - 2.5d0                                

      e6 = x1 + b7 - 1.2d0 

      e7 = sqr(b5) + sqr(x2) - 1.64d0                        

      e8 = sqr(b6) + sqr(x3) - 4.25d0                        

      e9 = sqr(b5) + sqr(x3) - 4.64d0  

      g(1) = -e1
      g(2) = -e2
      g(3) = -e3
      g(4) = -e4
      g(5) = -e5
      g(6) = -e6
      g(7) = -e7
      g(8) = -e8
      g(9) = -e9

  999 continue
      return
      end
 

      subroutine ex1224(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:51
*  
*  Equation counts
*     Total       E       G       L       N       X
*         8       3       0       5       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        12       4       8       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        31      25       6       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), x1, x2, x3, b4, b5, b6, b7, b8, b9, b10, b11, 
     /        e2, e3, e4, e5, e6, e7, e8, xlog
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1224'
         pref  = '\cite{MINLPLib}'
         fex   = -0.9434705d0 
         ncont = 3
         nint  = 0
         nbin  = 8
         n     = ncont + nbin + nint
         m     = 7
         me    = 2
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.1d0
         enddo
         xu(1) = 0.997d0
         xu(2) = 0.9985d0                         
         xu(3) = 0.9988d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      b4  = y(1)
      b5  = y(2)
      b6  = y(3)
      b7  = y(4)
      b8  = y(5)
      b9  = y(6)
      b10 = y(7)
      b11 = y(8)

      f = -x1*x2*x3

      e2 = -xlog(1.0d0 - x1) - 2.30258509299405d0*b4 
     /      - 1.6094379124341d0*b5 - 1.89711998488588d0*b6      

      e3 = -xlog(1.0d0 - x2) - 2.99573227355399d0*b7 
     /      - 1.6094379124341d0*b8 - 1.89711998488588d0*b9    

      e4 = -xlog(1.0d0 - x3) - 3.91202300542815d0*b10 
     /     - 2.81341071676004d0*b11
      
      e5 = -b4 - b5 - b6 + 1.0d0                                    

      e6 = -b7 - b8 - b9 + 1.0d0                                    

      e7 = -b10 - b11 + 1.0d0                                       

      e8 = 3.0d0*b4 + b5 + 2.0d0*b6 + 3*b7 + 2.0d0*b8 + b9 
     /        + 3.0d0*b10 + 2.0d0*b11 - 10.0d0 
      
      g(1) = e2
      g(2) = e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6
      g(6) = -e7
      g(7) = -e8

  999 continue
      return
      end
 

      subroutine ex1225(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:53
*  
*  Equation counts
*     Total       E       G       L       N       X
*        11       3       0       8       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       3       6       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        27      25       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, b3, b4, b5, b6, b7, b8, e2, e3,
     /        e4, e5, e6, e7, e8, e9, e10, e11 
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1225'
         pref  = '\cite{MINLPLib}'
         fex   = 31.0d0 
         ncont = 2
         nint  = 0
         nbin  = 6
         n     = ncont + nbin + nint
         m     = 10
         me    = 2
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo 
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo 
         xl(1) = 1.0d0  
         xu(1) = 5.0d0  
         xl(2) = 1.0d0
         xu(2) = 5.0d0  
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1 = x(1)
      x2 = x(2)
      b3 = y(1)
      b4 = y(2)
      b5 = y(3)
      b6 = y(4)
      b7 = y(5)
      b8 = y(6)

      f =  7.0d0*x1 + 10*x2

      e2 = x1**1.2d0*x2**1.7d0 - 7.0d0*x1 - 9.0d0*x2 + 24.0d0     

      e3 = -x1 - 2.0d0*x2 + 5.0d0                       

      e4 = -3.0d0*x1 + x2 - 1.0d0                        

      e5 = 4.0d0*x1 - 3.0d0*x2 - 11.0d0                     

      e6 = x1 - b3 - 2.0d0*b4 - 4.0d0*b5 - 1.0d0            

      e7 = x2 - b6 - 2.0d0*b7 - 4.0d0*b8 - 1.0d0            

      e8 = b3 + b5 - 1.0d0                          

      e9 = b6 + b8 - 1.0d0                          

      e10 = b4 + b5 - 1.0d0                         

      e11 = b7 + b8 - 1.0d0  

      g(1) = e6
      g(2) = e7
      g(3) = -e2
      g(4) = -e3
      g(5) = -e4
      g(6) = -e5
      g(7) = -e8
      g(8) = -e9
      g(9) = -e10
      g(10) = -e11

  999 continue
      return
      end

      subroutine ex1226(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:55
*  
*  Equation counts
*     Total       E       G       L       N       X
*         6       2       0       4       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         6       3       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        15      13       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, x1, x2, b3, b4, b5, e1, e2, e3,
     /        e4, e5
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1226'
         pref  = '\cite{MINLPLib}'
         fex   = -17.0d0
         ncont = 2
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 5
         me    = 1
         xl(1) = 1.0d0 
         x(1)  = 1.0d0 
         xu(1) = 10.0d0                                       
         xl(2) = 1.0d0 
         x(2)  = 1.0d0 
         xu(2) = 6.0d0                                        
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      x1 = x(1)
      x2 = x(2)
      b3 = y(1)
      b4 = y(2)
      b5 = y(3)

      f = -5.0d0*x1 + 3.0d0*x2

      e1 = 8.0d0*x1 - 2.0d0*x1**0.5d0*sqr(x2) + 11.0d0*x2 
     /     + 2.0d0*sqr(x2) - 2.0d0*x2**0.5d0 - 39.0d0         
     
      e2 = x1 - x2 - 3.0d0
      
      e3 = 3.0d0*x1 + 2.0d0*x2 - 24.0d0  

      e4 = x2 - b3 - 2.0d0*b4 - 4.0d0*b5 - 1.0d0    

      e5 = b4 + b5 - 1.0d0                    

      g(1) = e4
      g(2) = -e1
      g(3) = -e2
      g(4) = -e3
      g(5) = -e5

  999 continue
      return
      end
 
 
      subroutine ex1233(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    


*  MINLP written by GAMS Convert at 04/17/01 16:37:56
*  
*  Equation counts
*     Total       E       G       L       N       X
*        65      21       0      44       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        53      41      12       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       221     193      28       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        b41, b42, b43, b44, b45, b46, b47, b48, b49, b50,
     /        b51, b52, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1233'
         pref  = '\cite{MINLPLib}'
         fex   = 155010.7d0
         ncont = 40
         nint  = 0
         nbin  = 12
         n     = ncont + nbin + nint
         m     = 64
         me    = 20
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 0.0d0
            xu(i) = 1.0d6
         enddo
         do i = 1,3
            xl(i) = 370.0d0
            x(i)  = 400.0d0
            xu(i) = 650.0d0
         enddo
         do i = 4,6
            xl(i) = 370.0d0
            x(i)  = 400.0d0
            xu(i) = 590.0d0
         enddo
         do i = 7,9
            xl(i) = 410.0d0
            x(i)  = 500.0d0
            xu(i) = 650.0d0
         enddo
         do i = 10,12
            xl(i) = 350.0d0
            x(i)  = 400.0d0
            xu(i) = 500.0d0
         enddo
         do i = 13,24
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         do i = 25,ncont
            xl(i) = 10.0d0
            x(i)  = 20.0d0
            xu(i) = 1.0d6
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      x6  = x(6)
      x7  = x(7)
      x8  = x(8)
      x9  = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      b41 = y(1)
      b42 = y(2)
      b43 = y(3)
      b44 = y(4)
      b45 = y(5)
      b46 = y(6)
      b47 = y(7)
      b48 = y(8)
      b49 = y(9)
      b50 = y(10)
      b51 = y(11)
      b52 = y(12)

      f = -(-(300.0d0*x13/(0.5d0*x25*x26*(x25 + x26))**0.3333d0 
     /      + 300.0d0*x14/(0.5d0*x26*x27*(x26 + x27))**0.3333d0 
     /      + 300.0d0*x15/(0.5d0*x28*x29*(x28 + x29))**0.3333d0 
     /      + 300.0d0*x16/(0.5d0*x29*x30*(x29 + x30))**0.3333d0
     /      + 300.0d0*x17/(0.5d0*x31*x32*(x31 + x32))**0.3333d0
     /      + 300.0d0*x18/(0.5d0*x32*x33*(x32 + x33))**0.3333d0
     /      + 300.0d0*x19/(0.5d0*x34*x35*(x34 + x35))**0.3333d0
     /      + 300.0d0*x20/(0.5d0*x35*x36*(x35 + x36))**0.3333d0
     /      + 300.0d0*x21/(35.0d0*x37*(70.0d0 + x37))**0.33333d0
     /      + 300.0d0*x22/(35.0d0*x38*(70.0d0 + x38))**0.33333d0
     /      + 180.0d0*x23/(15.0d0*x39*(30.0d0 + x39))**0.33333d0
     /      + 180.0d0*x24/(90.0d0*x40*(180.0d0 + x40))**0.33333d0
     /      + 80.0d0*x23 + 80.0d0*x24 + 15.0d0*x21 + 15.0d0*x22) 
     /      - 5500.0d0*b41 - 5500.0d0*b42 - 5500.0d0*b43 - 5500.0d0*b44
     /      - 5500.0d0*b45 - 5500.0d0*b46 - 5500.0d0*b47 - 5500.0d0*b48 
     /      - 5500.0d0*b49 - 5500.0d0*b50 - 5500.0d0*b51 - 5500.0d0*b52)

      e2 = x13 + x14 + x15 + x16 + x21 - 2800.0d0 

      e3 = x17 + x18 + x19 + x20 + x22 - 4400.0d0 

      e4 = x13 + x14 + x17 + x18 + x23 - 3600.0d0 

      e5 = x15 + x16 + x19 + x20 + x24 - 1950.0d0 

      e6 = 10.0d0*x1 - 10.0d0*x2 - x13 - x15 

      e7 = 10.0d0*x2 - 10.0d0*x3 - x14 - x16 

      e8 = 20.0d0*x4 - 20.0d0*x5 - x17 - x19 

      e9 = 20.0d0*x5 - 20.0d0*x6 - x18 - x20 

      e10 = 15.0d0*x7 - 15.0d0*x8 - x13 - x17

      e11 = 15.0d0*x8 - 15.0d0*x9 - x14 - x18

      e12 = 13.0d0*x10 - 13.0d0*x11 - x15 - x19         

      e13 = 13.0d0*x11 - 13.0d0*x12 - x16 - x20         

      e14 = x1 - 650.0d0               

      e15 = x4 - 590.0d0               

      e16 = x9 - 410.0d0               

      e17 = x12 - 350.0d0              

      e18 = - x1 + x2                  

      e19 = - x2 + x3                  

      e20 = - x4 + x5                  

      e21 = - x5 + x6                  

      e22 = - x7 + x8                  

      e23 = - x8 + x9                  

      e24 = - x10 + x11                

      e25 = - x11 + x12                

      e26 = - x3 + 370.0d0              

      e27 = - x6 + 370.0d0              

      e28 = x7 - 650.0d0               

      e29 = x10 - 500.0d0              

      e30 = 10.0d0*x3 - x21 - 3700.0d0     

      e31 = 20.0d0*x6 - x22 - 7400.0d0     

      e32 = 15.0d0*x7 + x23 - 9750.0d0     

      e33 = 13.0d0*x10 + x24 - 6500.0d0    

      e34 = x13 - 2800.0d0*b41           

      e35 = x14 - 2800.0d0*b42           

      e36 = x15 - 1950.0d0*b43           

      e37 = x16 - 1950.0d0*b44           

      e38 = x17 - 3600.0d0*b45           

      e39 = x18 - 3600.0d0*b46           

      e40 = x19 - 1950.0d0*b47           

      e41 = x20 - 1950.0d0*b48           

      e42 = x21 - 2800.0d0*b49           

      e43 = x22 - 4400.0d0*b50           

      e44 = x23 - 3600.0d0*b51           

      e45 = x24 - 1950.0d0*b52           

      e46 = - x1 + x7 + x25 + 280.0d0*b41 - 280.0d0     

      e47 = - x2 + x8 + x26 + 130.0d0*b42 - 130.0d0     

      e48 = - x1 + x10 + x28 + 280.0d0*b43 - 280.0d0    

      e49 = - x2 + x11 + x29 + 150.0d0*b44 - 150.0d0    

      e50 = - x4 + x7 + x31 + 280.0d0*b45 - 280.0d0     

      e51 = - x5 + x8 + x32 + 130.0d0*b46 - 130.0d0     

      e52 = - x4 + x10 + x34 + 280.0d0*b47 - 280.0d0    

      e53 = - x5 + x11 + x35 + 150.0d0*b48 - 150.0d0    

      e54 = - x2 + x8 + x26 + 280.0d0*b41 - 280.0d0     

      e55 = - x3 + x9 + x27 + 130.0d0*b42 - 130.0d0     

      e56 = - x2 + x11 + x29 + 280.0d0*b43 - 280.0d0    

      e57 = - x3 + x12 + x30 + 150.0d0*b44 - 150.0d0    

      e58 = - x5 + x8 + x32 + 280.0d0*b45 - 280.0d0     

      e59 = - x6 + x9 + x33 + 130.0d0*b46 - 130.0d0     

      e60 = - x5 + x11 + x35 + 280.0d0*b47 - 280.0d0    

      e61 = - x6 + x12 + x36 + 150.0d0*b48 - 150.0d0    

      e62 = - x3 + x37 + 320.0d0        

      e63 = - x6 + x38 + 320.0d0        

      e64 =   x7 + x39 - 680.0d0         

      e65 = x10 + x40 - 680.0d0  
              
      g(1)  = e2
      g(2)  = e3
      g(3)  = e4
      g(4)  = e5
      g(5)  = e6
      g(6)  = e7
      g(7)  = e8
      g(8)  = e9
      g(9)  = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e30
      g(18) = e31
      g(19) = e32
      g(20) = e33
      g(21) = -e18
      g(22) = -e19
      g(23) = -e20
      g(24) = -e21
      g(25) = -e22
      g(26) = -e23
      g(27) = -e24
      g(28) = -e25
      g(29) = -e26
      g(30) = -e27
      g(31) = -e28
      g(32) = -e29
      g(33) = -e34
      g(34) = -e35
      g(35) = -e36
      g(36) = -e37
      g(37) = -e38
      g(38) = -e39
      g(39) = -e40
      g(40) = -e41
      g(41) = -e42
      g(42) = -e43
      g(43) = -e44
      g(44) = -e45
      g(45) = -e46
      g(46) = -e47
      g(47) = -e48
      g(48) = -e49
      g(49) = -e50
      g(50) = -e51
      g(51) = -e52
      g(52) = -e53
      g(53) = -e54
      g(54) = -e55
      g(55) = -e56
      g(56) = -e57
      g(57) = -e58
      g(58) = -e59
      g(59) = -e60
      g(60) = -e61
      g(61) = -e62
      g(62) = -e63
      g(63) = -e64
      g(64) = -e65
      
  999 continue
      return
      end
 

      subroutine ex1243(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:57
*  
*  Equation counts
*     Total       E       G       L       N       X
*        97      25       0      72       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        69      53      16       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       329     293      36       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19 ,x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36 ,x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, b67, b68, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1243'
         pref  = '\cite{MINLPLib}'
         fex   = 83402.51d0
         ncont = 52
         nint  = 0
         nbin  = 16
         n     = ncont + nbin + nint
         m     = 96
         me    = 24
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 0.0d0
            xu(i) = 1.0d6
         end do
         do i = 1,4
            xl(i) = 333.0d0
            x(i)  = 400.0d0
            xu(i) = 443.0d0
         end do
         do i = 5,8
            xl(i) = 303.0d0
            x(i)  = 350.0d0
            xu(i) = 442.0d0
         end do
         do i = 9,12
            xl(i) = 293.0d0
            x(i)  = 350.0d0
            xu(i) = 408.0d0
         end do
         do i = 13,16
            xl(i) = 353.0d0
            x(i)  = 380.0d0
            xu(i) = 413.0d0
         end do
         do i = 17,32
            xl(i) = 0.0d0
            x(i)  = 1.0d0
         end do
         do i = 33,52
            xl(i) = 1.0d0
            x(i)  = 1.0d0
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      x6  = x(6)
      x7  = x(7)
      x8  = x(8)
      x9  = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      b53 = y(1)
      b54 = y(2)
      b55 = y(3)
      b56 = y(4)
      b57 = y(5)
      b58 = y(6)
      b59 = y(7)
      b60 = y(8)
      b61 = y(9)
      b62 = y(10)
      b63 = y(11)
      b64 = y(12)
      b65 = y(13)
      b66 = y(14)
      b67 = y(15)
      b68 = y(16)

      f =  -(-(208.15d0*x17/(x33 + x34) + 208.15d0*x18/(x34 + x35) 
     /       + 208.15d0*x19/(x35 + x36) + 208.15d0*x20/(x37 + x38) 
     /       + 208.15d0*x21/(x38 + x39) + 208.15d0*x22/(x39 + x40) 
     /       + 208.15d0*x23/(x41 + x42) + 208.15d0*x24/(x42 + x43) 
     /       + 208.15d0*x25/(x43 + x44) + 208.15d0*x26/(x45 + x46)
     /       + 208.15d0*x27/(x46 + x47) + 208.15d0*x28/(x47 + x48) 
     /       + 208.15d0*x29/(40.0d0 + x49) + 208.15d0*x30/(10.0d0 + x50)
     /       + 166.516666666667d0*x31/(42.0d0 + x51) 
     /       + 166.516666666667d0*x32/(37.0d0 + x52) 
     /       + 80.0d0*x31 + 80.0d0*x32 + 20.0d0*x29 + 20.0d0*x30) 
     /       - 6250.0d0*b53 - 6250.0d0*b54 - 6250.0d0*b55 - 6250.0d0*b56
     /       - 6250.0d0*b57 - 6250.0d0*b58 - 6250.0d0*b59 - 6250.0d0*b60
     /       - 6250.0d0*b61 - 6250.0d0*b62 - 6250.0d0*b63 - 6250.0d0*b64
     /       - 6250.0d0*b65 - 6250.0d0*b66 - 6250.0d0*b67 
     /       - 6250.0d0*b68)

      e2 = x17 + x18 + x19 + x20 + x21 + x22 + x29 - 3300.0d0

      e3 = x23 + x24 + x25 + x26 + x27 + x28 + x30 - 1800.0d0 

      e4 = x17 + x18 + x19 + x23 + x24 + x25 + x31 - 2300.0d0  

      e5 = x20 + x21 + x22 + x26 + x27 + x28 + x32 - 2400.0d0  

      e6 = 30.0d0*x1 - 30.0d0*x2 - x17 - x20                     

      e7 = 30.0d0*x2 - 30.0d0*x3 - x18 - x21                     

      e8 = 30.0d0*x3 - 30.0d0*x4 - x19 - x22                     

      e9 = 15.0d0*x5 - 15.0d0*x6 - x23 - x26                     

      e10 = 15.0d0*x6 - 15.0d0*x7 - x24 - x27                    

      e11 = 15.0d0*x7 - 15.0d0*x8 - x25 - x28                    

      e12 = 20.0d0*x9 - 20.0d0*x10 - x17 - x23                   

      e13 = 20.0d0*x10 - 20.0d0*x11 - x18 - x24                  

      e14 = 20.0d0*x11 - 20.0d0*x12 - x19 - x25                  

      e15 = 40.0d0*x13 - 40.0d0*x14 - x20 - x26                  

      e16 = 40.0d0*x14 - 40.0d0*x15 - x21 - x27                  

      e17 = 40.0d0*x15 - 40.0d0*x16 - x22 - x28                  

      e18 = x1 - 443.0d0            

      e19 = x5 - 423.0d0            

      e20 = x11 - 293.0d0           

      e21 = x15 - 353.0d0           

      e22 = -x1 + x2               

      e23 = -x2 + x3               

      e24 = -x3 + x4               

      e25 = -x5 + x6               

      e26 = -x6 + x7               

      e27 = -x7 + x8               

      e28 = -x9 + x10              

      e29 = -x10 + x11             

      e30 = -x11 + x12             

      e31 = -x13 + x14             

      e32 = -x14 + x15             

      e33 = -x15 + x16             

      e34 = -x3 + 333.0d0           

      e35 = -x7 + 303.0d0           

      e36 = x9 - 408.0d0            

      e37 = x13 - 413.0d0           

      e38 = 30.0d0*x3 - x29 - 9990.0d0  

      e39 = 15.0d0*x7 - x30 - 4545.0d0  

      e40 = 20.0d0*x9 + x31 - 8160.0d0  

      e41 = 40.0d0*x13 + x32 - 16520.0d0

      e42 = x17 - 2300.0d0*b53        

      e43 = x18 - 2300.0d0*b54        

      e44 = x19 - 2300.0d0*b55        

      e45 = x20 - 2400.0d0*b56        

      e46 = x21 - 2400.0d0*b57        

      e47 = x22 - 2400.0d0*b58        

      e48 = x23 - 1800.0d0*b59        

      e49 = x24 - 1800.0d0*b60        

      e50 = x25 - 1800.0d0*b61        

      e51 = x26 - 1800.0d0*b62        

      e52 = x27 - 1800.0d0*b63        

      e53 = x28 - 1800.0d0*b64        

      e54 = x29 - 3300.0d0*b65        

      e55 = x30 - 1800.0d0*b66        

      e56 = x31 - 2300.0d0*b67        

      e57 = x32 - 2400.0d0*b68        

      e58 = - x1 + x9 + x33 + 150.0d0*b53 - 150.0d0              

      e59 = - x2 + x10 + x34 + 150.0d0*b54 - 150.0d0             

      e60 = - x3 + x11 + x35 + 150.0d0*b55 - 150.0d0             

      e61 = - x1 + x13 + x37 + 90.0d0*b56 - 90.0d0               

      e62 = - x2 + x14 + x38 + 90.0d0*b57 - 90.0d0             

      e63 = - x3 + x15 + x39 + 90.0d0*b58 - 90.0d0               

      e64 = - x5 + x9 + x41 + 130.0d0*b59 - 130.0d0              

      e65 = - x6 + x10 + x42 + 130.0d0*b60 - 130.0d0             

      e66 = - x7 + x11 + x43 + 130.0d0*b61 - 130.0d0             

      e67 = - x5 + x13 + x45 + 70.0d0*b62 - 70.0d0               

      e68 = - x6 + x14 + x46 + 70.0d0*b63 - 70.0d0               

      e69 = - x7 + x15 + x47 + 70.0d0*b64 - 70.0d0               

      e70 = - x2 + x10 + x34 + 150.0d0*b53 - 150.0d0             

      e71 = - x3 + x11 + x35 + 150.0d0*b54 - 150.0d0             

      e72 = - x4 + x12 + x36 + 150.0d0*b55 - 150.0d0             

      e73 = - x2 + x14 + x38 + 90.0d0*b56 - 90.0d0               

      e74 = - x3 + x15 + x39 + 90.0d0*b57 - 90.0d0               

      e75 = - x4 + x16 + x40 + 90.0d0*b58 - 90.0d0               

      e76 = - x6 + x10 + x42 + 130.0d0*b59 - 130.0d0             

      e77 = - x7 + x11 + x43 + 130.0d0*b60 - 130.0d0             

      e78 = - x8 + x12 + x44 + 130.0d0*b61 - 130.0d0             

      e79 = - x6 + x14 + x46 + 70.0d0*b62 - 70.0d0               

      e80 = - x7 + x15 + x47 + 70.0d0*b63 - 70.0d0               

      e81 = - x8 + x16 + x48 + 70.0d0*b64 - 70.0d0               

      e82 = - x3 + x49 + 313.0d0     

      e83 = - x7 + x50 + 313.0d0     

      e84 = x9 + x51 - 450.0d0      

      e85 = x13 + x52 - 450.0d0     

      e86 = b53 + b59 - 1.0d0       

      e87 = b54 + b60 - 1.0d0       

      e88 = b55 + b61 - 1.0d0       

      e89 = b56 + b62 - 1.0d0       

      e90 = b57 + b63 - 1.0d0       

      e91 = b58 + b64 - 1.0d0       

      e92 = b53 + b56 - 1.0d0       

      e93 = b54 + b57 - 1.0d0       

      e94 = b55 + b58 - 1.0d0       

      e95 = b59 + b62 - 1.0d0       

      e96 = b60 + b63 - 1.0d0       

      e97 = b61 + b64 - 1.0d0              

      g(1)  = e2
      g(2)  = e3
      g(3)  = e4
      g(4)  = e5
      g(5)  = e6
      g(6)  = e7
      g(7)  = e8
      g(8)  = e9
      g(9)  = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e18
      g(18) = e19
      g(19) = e20
      g(20) = e21      
      g(21) = e38
      g(22) = e39
      g(23) = e40
      g(24) = e41
      g(25) = -e22
      g(26) = -e23
      g(27) = -e24
      g(28) = -e25
      g(29) = -e26
      g(30) = -e27
      g(31) = -e28
      g(32) = -e29
      g(33) = -e30
      g(34) = -e31
      g(35) = -e32
      g(36) = -e33
      g(37) = -e34
      g(38) = -e35
      g(39) = -e36
      g(40) = -e37
      g(41) = -e42
      g(42) = -e43
      g(43) = -e44
      g(44) = -e45
      g(45) = -e46
      g(46) = -e47
      g(47) = -e48
      g(48) = -e49
      g(49) = -e50
      g(50) = -e51
      g(51) = -e52
      g(52) = -e53
      g(53) = -e54
      g(54) = -e55
      g(55) = -e56
      g(56) = -e57
      g(57) = -e58
      g(58) = -e59
      g(59) = -e60
      g(60) = -e61
      g(61) = -e62
      g(62) = -e63
      g(63) = -e64
      g(64) = -e65
      g(65) = -e66
      g(66) = -e67
      g(67) = -e68
      g(68) = -e69
      g(69) = -e70
      g(70) = -e71
      g(71) = -e72
      g(72) = -e73
      g(73) = -e74
      g(74) = -e75
      g(75) = -e76
      g(76) = -e77
      g(77) = -e78
      g(78) = -e79
      g(79) = -e80
      g(80) = -e81
      g(81) = -e82
      g(82) = -e83
      g(83) = -e84
      g(84) = -e85
      g(85) = -e86
      g(86) = -e87
      g(87) = -e88
      g(88) = -e89
      g(89) = -e90
      g(90) = -e91
      g(91) = -e92
      g(92) = -e93
      g(93) = -e94
      g(94) = -e95
      g(95) = -e96
      g(96) = -e97

  999 continue
      return
      end
 
      
      subroutine ex1244(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:37:59
*  
*  Equation counts
*     Total       E       G       L       N       X
*       130      31       0      99       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        96      73      23       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       469     417      52       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10, 
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, 
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30, 
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40, 
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50, 
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60, 
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70, 
     /        x71, x72, b73, b74, b75, b76, b77, b78, b79, b80, 
     /        b81, b82, b83, b84, b85, b86, b87, b88, b89, b90, 
     /        b91, b92, b93, b94, b95
      double precision
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10, 
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, 
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, 
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, 
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, 
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, 
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, 
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, 
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, 
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100, 
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110, 
     /       e111,e112,e113,e114,e115,e116,e117,e118,e119,e120, 
     /       e121,e122,e123,e124,e125,e126,e127,e128,e129,e130
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1244'
         pref  = '\cite{MINLPLib}'
         fex   = 82042.91d0  
         ncont = 72
         nint  = 0
         nbin  = 23
         n     = ncont + nbin + nint
         m     = 129
         me    = 30
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d3
            xu(i) = 1.0d6
         enddo
         do i = 1,20
            x(i)  = 1.0d2
         enddo
         do i = 21,43
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         xl(1) = 77.0d0
         xu(1) = 159.0d0                                  
         xl(2) = 77.0d0 
         xu(2) = 159.0d0                                     
         xl(3) = 77.0d0  
         xu(3) = 159.0d0                                     
         xl(4) = 77.0d0  
         xu(4) = 159.0d0                                     
         xl(5) = 80.0d0  
         xu(5) = 267.0d0                                     
         xl(6) = 80.0d0  
         xu(6) = 267.0d0                                     
         xl(7) = 80.0d0  
         xu(7) = 267.0d0                                     
         xl(8) = 80.0d0  
         xu(8) = 267.0d0
         xl(9) = 90.0d0  
         xu(9) = 343.0d0                                     
         xl(10) = 90.0d0  
         xu(10) = 343.0d0                                   
         xl(11) = 90.0d0  
         xu(11) = 343.0d0                                   
         xl(12) = 90.0d0  
         xu(12) = 343.0d0                                   
         xl(13) = 26.0d0  
         xu(13) = 127.0d0                                   
         xl(14) = 26.0d0  
         xu(14) = 127.0d0                                   
         xl(15) = 26.0d0  
         xu(15) = 127.0d0                                   
         xl(16) = 26.0d0  
         xu(16) = 127.0d0                                   
         xl(17) = 118.0d0  
         x(17)  = 200.0d0
         xu(17) = 265.0d0                                  
         xl(18) = 118.0d0  
         x(18)  = 200.0d0
         xu(18) = 265.0d0                                  
         xl(19) = 118.0d0  
         x(19)  = 200.0d0
         xu(19) = 265.0d0                                  
         xl(20) = 118.0d0  
         x(20)  = 200.0d0
         xu(20) = 265.0d0   
         do i=44,72
            xl(i)  = 1.0d0
            x(i) = 2.0d0
         enddo                                  
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      b73 = y(1)
      b74 = y(2)
      b75 = y(3)
      b76 = y(4)
      b77 = y(5)
      b78 = y(6)
      b79 = y(7)
      b80 = y(8)
      b81 = y(9)
      b82 = y(10)
      b83 = y(11)
      b84 = y(12)
      b85 = y(13)
      b86 = y(14)
      b87 = y(15)
      b88 = y(16)
      b89 = y(17)
      b90 = y(18)
      b91 = y(19)
      b92 = y(20)
      b93 = y(21)
      b94 = y(22)
      b95 = y(23)

      f = (17600.0d0*x21/(x44 + x45) + 17600.0d0*x22/(x45 + x46) 
     /    + 17600.0d0*x23/(x46 + x47) + 1920.0d0*x24/(x48 + x49) 
     /    + 1920.0d0*x25/(x49 + x50) + 1920.0d0*x26/(x50 + x51) 
     /    + 20000.0d0*x27/(x52 + x53) + 20000.0d0*x28/(x53 + x54) 
     /    + 20000.0d0*x29/(x54 + x55) + 4320.0d0*x30/(x56 + x57) 
     /    + 4320.0d0*x31/(x57 + x58) + 4320.0d0*x32/(x58 + x59) 
     /    + 16320.0d0*x33/(x60 + x61) + 16320.0d0*x34/(x61 + x62) 
     /    + 16320.0d0*x35/(x62 + x63) + 640.0d0*x36/(x64 + x65) 
     /    + 640.0d0*x37/(x65 + x66) + 640.0d0*x38/(x66 + x67) 
     /    + 2400.0d0*x39/(57.0d0 + x68) + 4800.0d0*x40/(60.0d0 + x69)
     /    + 1120.0d0*x41/(70.0d0 + x70) + 19200.0d0*x42/(173.0d0 + x71)
     /    + 3520.0d0*x43/(35.0d0 + x72) + 110.0d0*x42 + 110.0d0*x43 
     /    + 10.0d0*x39 + 10.0d0*x40 + 10.0d0*x41) + 7400.0d0*b73 
     /    + 7400.0d0*b74 + 7400.0d0*b75 + 7400.0d0*b76 + 7400.0d0*b77
     /    + 7400.0d0*b78 + 7400.0d0*b79 + 7400.0d0*b80 + 7400.0d0*b81 
     /    + 7400.0d0*b82 + 7400.0d0*b83 + 7400.0d0*b84 + 7400.0d0*b85 
     /    + 7400.0d0*b86 + 7400.0d0*b87 + 7400.0d0*b88 + 7400.0d0*b89
     /    + 7400.0d0*b90 + 7400.0d0*b91 + 7400.0d0*b92 + 7400.0d0*b93 
     /    + 7400.0d0*b94 + 7400.0d0*b95   

      e2 = x21 + x22 + x23 + x24 + x25 + x26 + x39 - 187.37d0

      e3 = x27 + x28 + x29 + x30 + x31 + x32 + x40 - 38.148d0 

      e4 = x33 + x34 + x35 + x36 + x37 + x38 + x41 - 136.114d0

      e5 = x21 + x22 + x23 + x27 + x28 + x29 + x33 + x34 + x35 + x42 
     /     - 94.233d0

      e6 = x24 + x25 + x26 + x30 + x31 + x32 + x36 + x37 + x38 + x43 
     /     - 288.267d0

      e7 = 2.285d0*x1 - 2.285d0*x2 - x21 - x24           

      e8 = 2.285d0*x2 - 2.285d0*x3 - x22 - x25           

      e9 = 2.285d0*x3 - 2.285d0*x4 - x23 - x26           

      e10 = 0.204d0*x5 - 0.204d0*x6 - x27 - x30          

      e11 = 0.204d0*x6 - 0.204d0*x7 - x28 - x31          

      e12 = 0.204d0*x7 - 0.204d0*x8 - x29 - x32          

      e13 = 0.538d0*x9 - 0.538d0*x10 - x33 - x36         

      e14 = 0.538d0*x10 - 0.538d0*x11 - x34 - x37        

      e15 = 0.538d0*x11 - 0.538d0*x12 - x35 - x38        

      e16 = 0.933d0*x13 - 0.933d0*x14 - x21 - x27 - x33  

      e17 = 0.933d0*x14 - 0.933d0*x15 - x22 - x28 - x34  

      e18 = 0.933d0*x15 - 0.933d0*x16 - x23 - x29 - x35  

      e19 = 1.961d0*x17 - 1.961d0*x18 - x24 - x30 - x36  

      e20 = 1.961d0*x18 - 1.961d0*x19 - x25 - x31 - x37  

      e21 = 1.961d0*x19 - 1.961d0*x20 - x26 - x32 - x38  

      e22 = x1 - 159.0d0                               

      e23 = x5 - 267.0d0                                 

      e24 = x9 - 343.0d0                                 

      e25 = x15 - 26.0d0                                 

      e26 = x19 - 118.0d0                                

      e27 = -x1 + x2                                  

      e28 = -x2 + x3                                  

      e29 = -x3 + x4                                  

      e30 = -x5 + x6                                  

      e31 = -x6 + x7                                  

      e32 = -x7 + x8                                  

      e33 = -x9 + x10                                 

      e34 = -x10 + x11                                

      e35 = -x11 + x12                                

      e36 = -x13 + x14                                

      e37 = -x14 + x15                                

      e38 = -x15 + x16                                

      e39 = -x17 + x18                                

      e40 = -x18 + x19                                

      e41 = -x19 + x20                                

      e42 = -x3 + 77.0d0                               

      e43 = -x7 + 80.0d0                               

      e44 = -x11 + 90.0d0                              

      e45 = x13 - 127.0d0                              

      e46 = x17 - 265.0d0                              

      e47 = 2.285d0*x3 - x39 - 175.945d0              

      e48 = 0.204d0*x7 - x40 - 16.32d0                 

      e49 = 0.538d0*x11 - x41 - 48.42d0                

      e50 = 0.933d0*x13 + x42 - 118.491d0              

      e51 = 1.961d0*x17 + x43 - 519.665d0              

      e52 = x21 - 94.233d0*b73                         

      e53 = x22 - 94.233d0*b74                         

      e54 = x23 - 94.233d0*b75                         

      e55 = x24 - 187.37d0*b76                         

      e56 = x25 - 187.37d0*b77                         

      e57 = x26 - 187.37d0*b78                         

      e58 = x27 - 38.148d0*b79                         

      e59 = x28 - 38.148d0*b80                         

      e60 = x29 - 38.148d0*b81                         

      e61 = x30 - 38.148d0*b82                         

      e62 = x31 - 38.148d0*b83                         

      e63 = x32 - 38.148d0*b84                         

      e64 = x33 - 94.233d0*b85                         

      e65 = x34 - 94.233d0*b86                         

      e66 = x35 - 94.233d0*b87                         

      e67 = x36 - 136.114d0*b88                        

      e68 = x37 - 136.114d0*b89                        

      e69 = x38 - 136.114d0*b90                        

      e70 = x39 - 187.37d0*b91                         

      e71 = x40 - 38.148d0*b92                         

      e72 = x41 - 136.114d0*b93                        

      e73 = x42 - 94.233d0*b94                         

      e74 = x43 - 288.267d0*b95                        

      e75 = -x1 + x13 + x44 + 133.0d0*b73 - 133.0d0         

      e76 = -x2 + x14 + x45 + 133.0d0*b74 - 133.0d0          

      e77 = -x3 + x15 + x46 + 133.0d0*b75 - 133.0d0          

      e78 = -x1 + x17 + x48 + 41.0d0*b76 - 41.0d0            

      e79 = -x2 + x18 + x49 + 41.0d0*b77 - 41.0d0            

      e80 = -x3 + x19 + x50 + 41.0d0*b78 - 41.0d0            

      e81 = -x5 + x13 + x52 + 241.0d0*b79 - 241.0d0          

      e82 = -x6 + x14 + x53 + 241.0d0*b80 - 241.0d0          

      e83 = -x7 + x15 + x54 + 241.0d0*b81 - 241.0d0          

      e84 = -x5 + x17 + x56 + 149.0d0*b82 - 149.0d0          

      e85 = -x6 + x18 + x57 + 149.0d0*b83 - 149.0d0          

      e86 = -x7 + x19 + x58 + 149.0d0*b84 - 149.0d0          

      e87 = -x9 + x13 + x60 + 317.0d0*b85 - 317.0d0          

      e88 = -x10 + x14 + x61 + 317.0d0*b86 - 317.0d0         

      e89 = -x11 + x15 + x62 + 317.0d0*b87 - 317.0d0         

      e90 = -x9 + x17 + x64 + 225.0d0*b88 - 225.0d0          

      e91 = -x10 + x18 + x65 + 225.0d0*b89 - 225.0d0         

      e92 = -x11 + x19 + x66 + 225.0d0*b90 - 225.0d0         

      e93 = -x2 + x14 + x45 + 133.0d0*b73 - 133.0d0          

      e94 = -x3 + x15 + x46 + 133.0d0*b74 - 133.0d0          

      e95 = -x4 + x16 + x47 + 133.0d0*b75 - 133.0d0          

      e96 = -x2 + x18 + x49 + 41.0d0*b76 - 41.0d0            

      e97 = -x3 + x19 + x50 + 41.0d0*b77 - 41.0d0            

      e98 = -x4 + x20 + x51 + 41.0d0*b78 - 41.0d0            

      e99 = -x6 + x14 + x53 + 241.0d0*b79 - 241.0d0          

      e100 = -x7 + x15 + x54 + 241.0d0*b80 - 241.0d0         

      e101 = -x8 + x16 + x55 + 241.0d0*b81 - 241.0d0         

      e102 = -x6 + x18 + x57 + 149.0d0*b82 - 149.0d0         

      e103 = -x7 + x19 + x58 + 149.0d0*b83 - 149.0d0         

      e104 = -x8 + x20 + x59 + 149.0d0*b84 - 149.0d0         

      e105 = -x10 + x14 + x61 + 317.0d0*b85 - 317.0d0        

      e106 = -x11 + x15 + x62 + 317.0d0*b86 - 317.0d0        

      e107 = -x12 + x16 + x63 + 317.0d0*b87 - 317.0d0        

      e108 = -x10 + x18 + x65 + 225.0d0*b88 - 225.0d0        

      e109 = -x11 + x19 + x66 + 225.0d0*b89 - 225.0d0        

      e110 = -x12 + x20 + x67 + 225.0d0*b90 - 225.0d0        

      e111 = -x3 + x68 + 60.0d0                        

      e112 = -x7 + x69 + 60.0d0                        

      e113 = -x11 + x70 + 60.0d0                       

      e114 = x13 + x71 - 300.0d0                       

      e115 = x17 + x72 - 300.0d0                       

      e116 = b73 + b79 + b85 - 1.0d0             

      e117 = b74 + b80 + b86 - 1.0d0             

      e118 = b75 + b81 + b87 - 1.0d0             

      e119 = b76 + b82 + b88 - 1.0d0             

      e120 = b77 + b83 + b89 - 1.0d0             

      e121 = b78 + b84 + b90 - 1.0d0             

      e122 = b73 + b76 - 1.0d0                   

      e123 = b74 + b77 - 1.0d0                   

      e124 = b75 + b78 - 1.0d0                   

      e125 = b79 + b82 - 1.0d0                   

      e126 = b80 + b83 - 1.0d0                   

      e127 = b81 + b84 - 1.0d0                   

      e128 = b85 + b88 - 1.0d0                   

      e129 = b86 + b89 - 1.0d0                   

      e130 = b87 + b90 - 1.0d0

      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = e7
      g(7) = e8
      g(8) = e9
      g(9) = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e18
      g(18) = e19
      g(19) = e20
      g(20) = e21
      g(21) = e22
      g(22) = e23
      g(23) = e24
      g(24) = e25
      g(25) = e26
      g(26) = e47
      g(27) = e48
      g(28) = e49
      g(29) = e50
      g(30) = e51
      g(31) = -e27
      g(32) = -e28
      g(33) = -e29
      g(34) = -e30
      g(35) = -e31
      g(36) = -e32
      g(37) = -e33
      g(38) = -e34
      g(39) = -e35
      g(40) = -e36
      g(41) = -e37
      g(42) = -e38
      g(43) = -e39
      g(44) = -e40
      g(45) = -e41
      g(46) = -e42
      g(47) = -e43
      g(48) = -e44
      g(49) = -e45
      g(50) = -e46
      g(51) = -e52
      g(52) = -e53
      g(53) = -e54
      g(54) = -e55
      g(55) = -e56
      g(56) = -e57
      g(57) = -e58
      g(58) = -e59
      g(59) = -e60
      g(60) = -e61
      g(61) = -e62
      g(62) = -e63
      g(63) = -e64
      g(64) = -e65
      g(65) = -e66
      g(66) = -e67
      g(67) = -e68
      g(68) = -e69
      g(69) = -e70
      g(70) = -e71
      g(71) = -e72
      g(72) = -e73
      g(73) = -e74
      g(74) = -e75
      g(75) = -e76
      g(76) = -e77
      g(77) = -e78
      g(78) = -e79
      g(79) = -e80
      g(80) = -e81
      g(81) = -e82
      g(82) = -e83
      g(83) = -e84
      g(84) = -e85
      g(85) = -e86
      g(86) = -e87
      g(87) = -e88
      g(88) = -e89
      g(89) = -e90
      g(90) = -e91
      g(91) = -e92
      g(92) = -e93
      g(93) = -e94
      g(94) = -e95
      g(95) = -e96
      g(96) = -e97
      g(97) = -e98
      g(98) = -e99
      g(99) = -e100
      g(100) = -e101
      g(101) = -e102
      g(102) = -e103
      g(103) = -e104
      g(104) = -e105
      g(105) = -e106
      g(106) = -e107
      g(107) = -e108
      g(108) = -e109
      g(109) = -e110
      g(110) = -e111
      g(111) = -e112
      g(112) = -e113
      g(113) = -e114
      g(114) = -e115
      g(115) = -e116
      g(116) = -e117
      g(117) = -e118
      g(118) = -e119
      g(119) = -e120
      g(120) = -e121
      g(121) = -e122
      g(122) = -e123
      g(123) = -e124
      g(124) = -e125
      g(125) = -e126
      g(126) = -e127
      g(127) = -e128
      g(128) = -e129
      g(129) = -e130

  999 continue
      return
      end
 
      subroutine ex1252(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:00
*  
*  Equation counts
*     Total       E       G       L       N       X
*        44      23       0      21       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        40      25      15       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       118      82      36       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, power, x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,
     /        x11,x12,x13,x14,x15,x16,x17,x18,
     /        b19,b20,b21,b22,b23,b24,x25,x26,x27,b28,b29,b30,
     /        b31,b32,b33,x34,x35,x36,b37,b38,b39,
     /        e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13,e14,e15,e16,
     /        e17,e18,e19,e20,e21,e22,e23,e24,e25,e26,e27,e28,e29,
     /        e30,e31,e32,e33,e34,e35,e36,e37,e38,e39,e40,e41,e42,
     /        e43,e44
             
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1252'
         pref  = '\cite{MINLPLib}'
         fex   = 128893.7d0
         ncont = 24
         nint  = 0
         nbin  = 15
         n     = ncont + nbin + nint
         m     = 43
         me    = 22
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d1
            xu(i) = 1.0d6
         end do
         xu(1) = 80.0d0
         xu(2) = 25.0d0
         xu(3) = 45.0d0
         xu(4) = 2950.0d0  
         xu(5) = 2950.0d0  
         xu(6) = 2950.0d0  
         xu(7) = 400.0d0   
         xu(8) = 400.0d0   
         xu(9) = 400.0d0   
         xu(10) = 350.0d0  
         xu(11) = 350.0d0  
         xu(12) = 350.0d0  
         xu(13) = 1.0d1
         xu(14) = 1.0d1
         xu(15) = 1.0d1
         xu(16) = 3.0d1
         xu(17) = 3.0d1
         xu(18) = 3.0d1
         xu(19) = 3.0d1
         xu(20) = 3.0d1
         xu(21) = 3.0d1
         xu(22) = 1.0d1
         xu(23) = 1.0d1 
         xu(24) = 1.0d1
         x(4) = 983.333333333333d0                                     
         x(5) = 983.333333333333d0                                    
         x(6) = 983.333333333333d0                                     
         x(7) = 133.333333333333d0                                     
         x(8) = 133.333333333333d0                                     
         x(9) = 133.333333333333d0                                     
         x(10) = 116.666666666667d0                                    
         x(11) = 116.666666666667d0                                    
         x(12) = 116.666666666667d0                                    
         x(13) = 0.333333333333333d0                                   
         x(14) = 0.333333333333333d0                                   
         x(15) = 0.333333333333333d0                                   
         x(16) = 1.0d1 
         x(17) = 1.0d1 
         x(18) = 1.0d1         
         x(19) = 1.0d1 
         x(20) = 1.0d1 
         x(21) = 1.0d1 
         x(22) = 0.333333333333333d0                                   
         x(23) = 0.333333333333333d0                                   
         x(24) = 0.333333333333333d0  
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      x6  = x(6)
      x7  = x(7)
      x8  = x(8)
      x9  = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      b19 = y(1)
      b20 = y(2)
      b21 = y(3)
      b22 = y(4)
      b23 = y(5)
      b24 = y(6)
      x25 = x(19)
      x26 = x(20)
      x27 = x(21)
      b28 = y(7)
      b29 = y(8)
      b30 = y(9)
      b31 = y(10)
      b32 = y(11)
      b33 = y(12)
      x34 = x(22)
      x35 = x(23)
      x36 = x(24)
      b37 = y(13)
      b38 = y(14)
      b39 = y(15)  
        
      f = (6329.03d0 + 1800.0d0*x1)*x16*x25*x34
     /     + (2489.31d0 + 1800.0d0*x2)*x17*x26*x35 
     /     + (3270.27d0 + 1800.0d0*x3)*x18*x27*x36

      e2 = -19.9d0*power(0.000338983050847458d0*x4,3) 
     /     - 0.161d0*sqr(0.000338983050847458d0*x4)*x10 
     /     + 1.90169491525424d-7*x4*sqr(x10) + x1   

      e3 = -1.21d0*power(0.000338983050847458d0*x5,3) 
     /     - 0.0644d0*sqr(0.000338983050847458d0*x5)*x11 
     /     + 1.91186440677966d-7*x5*sqr(x11) + x2  

      e4 = -6.52d0*power(0.000338983050847458d0*x6,3) 
     /     - 0.102d0*sqr(0.000338983050847458d0*x6)*x12 
     /     + 7.86440677966102d-8*x6*sqr(x12) + x3   

      e5 = -0.00023593220338983d0*x4*x10 
     /     - 629.0d0*sqr(0.000338983050847458d0*x4) 
     /     + 0.0116d0*sqr(x10) + x7         

      e6 = -(0.001d0*x5*x11) - 215.0d0*sqr(0.000338983050847458d0*x5) 
     /     + 0.115d0*sqr(x11) + x8                       

      e7 = -0.000179661016949153d0*x6*x12 
     /     - 361.0d0*sqr(0.000338983050847458d0*x6) 
     /     + 0.00946d0*sqr(x12) + x9 

      e8 = x13 + x14 + x15 - 1.0d0 

      e9 = 0.00285714285714286d0*x10*x16 - x13            

      e10 = 0.00285714285714286d0*x11*x17 - x14           

      e11 = 0.00285714285714286d0*x12*x18 - x15           

      e12 = 0.0025d0*x7*x25 - x34  

      e13 = 0.0025d0*x8*x26 - x35  

      e14 = 0.0025d0*x9*x27 - x36  

      e15 = 0.000338983050847458d0*x4 - x34            

      e16 = 0.000338983050847458d0*x5 - x35            

      e17 = 0.000338983050847458d0*x6 - x36            

      e18 = 0.0125d0*x1 - x34   

      e19 = 0.04d0*x2 - x35     

      e20 = 0.0222222222222222d0*x3 - x36              

      e21 = 0.0025d0*x7 - x34   

      e22 =.0025d0*x8 - x35   

      e23 = 0.0025d0*x9 - x36   

      e24 = 0.00285714285714286d0*x10 - x34            

      e25 = 0.00285714285714286d0*x11 - x35            

      e26 = 0.00285714285714286d0*x12 - x36            

      e27 = x13 - x34         

      e28 = x14 - x35         

      e29 = x15 - x36         

      e30 = x16 - 3.0d0*x34       

      e31 = x17 - 3.0d0*x35       

      e32 = x18 - 3.0d0*x36       

      e33 = x25 - 3.0d0*x34       

      e34 = x26 - 3.0d0*x35       

      e35 = x27 - 3.0d0*x36       

      e36 = x16 - b19 - 2.0d0*b20 

      e37 = x17 - b21 - 2.0d0*b22 

      e38 = x18 - b23 - 2.0d0*b24 

      e39 = x25 - b28 - 2.0d0*b29 

      e40 = x26 - b30 - 2.0d0*b31 

      e41 = x27 - b32 - 2.0d0*b33 

      e42 = x34 - b37         

      e43 = x35 - b38         

      e44 = x36 - b39  
               
      g(1)  = e2
      g(2)  = e3
      g(3)  = e4
      g(4)  = e5
      g(5)  = e6
      g(6)  = e7
      g(7)  = e8
      g(8)  = e9
      g(9)  = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e36
      g(15) = e37
      g(16) = e38
      g(17) = e39
      g(18) = e40
      g(19) = e41
      g(20) = e42
      g(21) = e43
      g(22) = e44     
      g(23) = -e15
      g(24) = -e16
      g(25) = -e17
      g(26) = -e18
      g(27) = -e19
      g(28) = -e20
      g(29) = -e21
      g(30) = -e22
      g(31) = -e23
      g(32) = -e24
      g(33) = -e25
      g(34) = -e26
      g(35) = -e27
      g(36) = -e28
      g(37) = -e29
      g(38) = -e30
      g(39) = -e31
      g(40) = -e32
      g(41) = -e33
      g(42) = -e34
      g(43) = -e35

  999 continue
      return
      end
 

      subroutine ex1252a( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:01
*  
*  Equation counts
*     Total       E       G       L       N       X
*        35      14       0      21       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        25      16       3       6       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        94      58      36       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, x4, x5, x6, x7, x8, x9, 
     /        x10, x11, x12, x13, x14, x15, i16, i17, i18, i19, i20,
     /        i21, b22, b23, b24, power, sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1252A'
         pref  = '\cite{MINLPLib}'
         fex   = 0.12889374d6
         ncont = 15
         nint  = 6
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 34
         me    = 13
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d4
         end do
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         do i=ncont+nbin+1,n
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 3.0d0
         end do
         xu(1) = 80.0d0
         xu(2) = 25.0d0
         xu(3) = 45.0d0 
         xl(4) = 1.0d2
         x(4)  = 983.333333333333d0
         xu(4) = 0.295d4
         xl(5) = 1.0d2
         x(5)  = 983.333333333333d0
         xu(5) = 0.295d4
         xl(6) = 0.0d0
         x(6)  = 983.333333333333d0
         xu(6) = 0.295d4
         xu(7) = 400.0d0
         x(7)  = 133.333333333333d0
         xu(8) = 400.0d0
         x(8)  = 133.333333333333d0
         xu(9) = 400.0d0
         x(9)  = 133.333333333333d0
         xu(10) = 350.0d0
         x(10)  = 116.666666666667d0
         xu(11) = 350.0d0
         x(11)  = 116.666666666667d0
         xu(12) = 350.0d0
         x(12)  = 116.666666666667d0
         x(13)  = 0.33333333333333D0
         xu(13) = 1.0d0
         x(14)  = 0.33333333333333D0
         xu(14) = 1.0d0
         x(15)  = 0.33333333333333D0
         xu(15) = 1.0d0
         goto 999       
      end if
      
      do i=1,nbin
         y(nint+i) = x(ncont+i)
      end do
      do i=1,nint
         y(i) = x(ncont+nbin+i)
      end do
      
      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      x6  = x(6)
      x7  = x(7)
      x8  = x(8)
      x9  = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)       
      i16 = y(1)
      i17 = y(2)
      i18 = y(3)
      i19 = y(4)
      i20 = y(5)
      i21 = y(6)        
      b22 = y(7)
      b23 = y(8)
      b24 = y(9)       

      f = (6329.03d0 + 1800.0d0*x1)*i16*i19*b22 
     /    + (2489.31d0 + 1800.0d0*x2)*i17*i20*b23 
     /    + (3270.27d0 + 1800.0d0*x3)*i18*i21*b24 

      g(1) = -(19.9d0*power(0.000338983050847458d0*x4,3)
     /        + 0.161d0*sqr(0.000338983050847458d0*x4)*x10 
     /        - 1.90169491525424d-7*x4*sqr(x10)) + x1
 
      g(2) = -(1.21d0*power(0.000338983050847458d0*x5,3)
     /        + 0.0644d0*sqr(0.000338983050847458d0*x5)*x11 
     /        - 1.91186440677966d-7*x5*sqr(x11)) + x2
 
      g(3) = -(6.52d0*power(0.000338983050847458d0*x6,3) 
     /       + 0.102d0*sqr(0.000338983050847458d0*x6)*x12 
     /       - 7.86440677966102d-8*x6*sqr(x12)) + x3
 
      g(4) = -(0.00023593220338983d0*x4*x10  
     /        + 629.0d0*sqr(0.000338983050847458d0*x4) 
     /        - 0.0116d0*sqr(x10)) + x7
 
      g(5) = -(0.001d0*x5*x11 + 215.0d0*sqr(0.000338983050847458d0*x5) 
     /        - 0.115d0*sqr(x11)) + x8
 
      g(6) = -(0.000179661016949153d0*x6*x12
     /        + 361.0d0*sqr(0.000338983050847458d0*x6) 
     /        - 0.00946d0*sqr(x12)) + x9
 
      g(7) = x13 + x14 + x15 - 1.0d0
 
      g(8) = 0.00285714285714286d0*x10*i16 - x13
 
      g(9) = 0.00285714285714286d0*x11*i17 - x14
 
      g(10) = 0.00285714285714286d0*x12*i18 - x15
 
      g(11) = 0.0025d0*x7*i19 - b22
 
      g(12) = 0.0025d0*x8*i20 - b23
 
      g(13) = 0.0025d0*x9*i21 - b24
 
      g(14) = -0.000338983050847458d0*x4 + b22
 
      g(15) = -0.000338983050847458d0*x5 + b23
 
      g(16) = -0.000338983050847458d0*x6 + b24
 
      g(17) = -0.0125d0*x1 + b22         

      g(18) = -0.04d0*x2 + b23

      g(19) = -0.0222222222222222d0*x3 + b24

      g(20) = -0.0025d0*x7 + b22

      g(21) = -0.0025d0*x8 + b23

      g(22) = -0.0025d0*x9 + b24

      g(23) = -0.00285714285714286d0*x10 + b22

      g(24) = -0.00285714285714286d0*x11 + b23

      g(25) = -0.00285714285714286d0*x12 + b24

      g(26) = -x13 + b22

      g(27) = -x14 + b23

      g(28) = -x15 + b24

      g(29) = -i16 + 3.0d0*b22

      g(30) = -i17 + 3.0d0*b23

      g(31) = -i18 + 3.0d0*b24

      g(32) = -i19 + 3.0d0*b22

      g(33) = -i20 + 3.0d0*b23

      g(34) = -i21 + 3.0d0*b24  
         
  999 continue
      return
      end

      subroutine ex1263(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:03
*  
*  Equation counts
*     Total       E       G       L       N       X
*        56      21       5      30       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        93      21      72       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       241     209      32       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40,
     /        b41, b42, b43, b44, b45, b46, b47, b48, b49, b50,
     /        b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, b67, b68, x69, x70,
     /        x71, x72, b73, b74, b75, b76, b77, b78, b79, b80,
     /        b81, b82, b83, b84, b85, b86, b87, b88, b89, b90,
     /        b91, b92, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9,  e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1263'
         pref  = '\cite{MINLPLib}'
         fex   = 19.6d0
         ncont = 20
         nint  = 0
         nbin  = 72
         n     = ncont + nbin + nint
         m     = 55
         me    = 20
         do i=1,16
            xl(i) = 0.0d0
            x(i)  = 3.0d0
            xu(i) = 5.0d0
         enddo
         do i=17,20
            xl(i) = 0.0d0
            x(i)  = 20.0d0
            xu(i) = 30.0d0
         enddo   
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      b17 = y(1)
      b18 = y(2)
      b19 = y(3)
      b20 = y(4)
      b21 = y(5)
      b22 = y(6)
      b23 = y(7)
      b24 = y(8)
      b25 = y(9)
      b26 = y(10)
      b27 = y(11)
      b28 = y(12)
      b29 = y(13)
      b30 = y(14)
      b31 = y(15)
      b32 = y(16)
      b33 = y(17)
      b34 = y(18)
      b35 = y(19)
      b36 = y(20)
      b37 = y(21)
      b38 = y(22)
      b39 = y(23)
      b40 = y(24)
      b41 = y(25)
      b42 = y(26)
      b43 = y(27)
      b44 = y(28)
      b45 = y(29)
      b46 = y(30)
      b47 = y(31)
      b48 = y(32)
      b49 = y(33)
      b50 = y(34)
      b51 = y(35)
      b52 = y(36)
      b53 = y(37)
      b54 = y(38)
      b55 = y(39)
      b56 = y(40)
      b57 = y(41)
      b58 = y(42)
      b59 = y(43)
      b60 = y(44)
      b61 = y(45)
      b62 = y(46)
      b63 = y(47)
      b64 = y(48)
      b65 = y(49)
      b66 = y(50)
      b67 = y(51)
      b68 = y(52)
      x69= x(17)
      x70= x(18)
      x71= x(19)
      x72= x(20)   
      b73 = y(53)
      b74 = y(54)
      b75 = y(55)
      b76 = y(56)
      b77 = y(57)
      b78 = y(58)
      b79 = y(59)
      b80 = y(60)
      b81 = y(61)
      b82 = y(62)
      b83 = y(63)
      b84 = y(64)
      b85 = y(65)
      b86 = y(66)
      b87 = y(67)
      b88 = y(68)
      b89 = y(69)
      b90 = y(70)
      b91 = y(71)
      b92 = y(72)

      f =  0.1d0*b65 + 0.2d0*b66 + 0.3d0*b67 + 0.4d0*b68 + x69 + x70 
     /     + x71 + x72

      e2 = x69*x1 + x70*x2 + x71*x3 + x72*x4 - 15.0d0             

      e3 = x69*x5 + x70*x6 + x71*x7 + x72*x8 - 28.0d0              

      e4 = x69*x9 + x70*x10 + x71*x11 + x72*x12 - 21.0d0           

      e5 = x69*x13 + x70*x14 + x71*x15 + x72*x16 - 30.0d0          

      e6 = -290.0d0*x1 - 315.0d0*x5 - 350.0d0*x9 - 455.0d0*x13 
     /      + 1750.0d0*b65     

      e7 = -290.0d0*x2 - 315.0d0*x6 - 350.0d0*x10 - 455.0d0*x14 
     /      + 1750.0d0*b66    

      e8 = -290.0d0*x3 - 315.0d0*x7 - 350.0d0*x11 - 455.0d0*x15 
     /      + 1750.0d0*b67    

      e9 = -290.0d0*x4 - 315.0d0*x8 - 350.0d0*x12 - 455.0d0*x16 
     /      + 1750.0d0*b68    

      e10 = 290.0d0*x1 + 315.0d0*x5 + 350.0d0*x9 + 455.0d0*x13 
     /      - 1850.0d0*b65    

      e11 = 290.0d0*x2 + 315.0d0*x6 + 350.0d0*x10 + 455.0d0*x14 
     /      - 1850.0d0*b66   

      e12 = 290.0d0*x3 + 315.0d0*x7 + 350.0d0*x11 + 455.0d0*x15 
     /      - 1850.0d0*b67   

      e13 = 290.0d0*x4 + 315.0d0*x8 + 350.0d0*x12 + 455.0d0*x16 
     /     - 1850.0d0*b68   

      e14 = -x1 - x5 - x9 - x13 + b65    

      e15 = -x2 - x6 - x10 - x14 + b66   

      e16 = -x3 - x7 - x11 - x15 + b67   

      e17 = -x4 - x8 - x12 - x16 + b68   

      e18 = x1 + x5 + x9 + x13 - 5.0d0*b65  

      e19 = x2 + x6 + x10 + x14 - 5.0d0*b66 

      e20 = x3 + x7 + x11 + x15 - 5.0d0*b67 

      e21 = x4 + x8 + x12 + x16 - 5.0d0*b68 

      e22 = b65 - x69                   

      e23 = b66 - x70                   

      e24 = b67 - x71                   

      e25 = b68 - x72                   

      e26 = -30.0d0*b65 + x69                

      e27 = -30.0d0*b66 + x70                

      e28 = -30.0d0*b67 + x71                

      e29 = -30.0d0*b68 + x72                

      e30 = x69 + x70 + x71 + x72 - 19.0d0 

      e31 = -b65 + b66                   

      e32 = -b66 + b67                   

      e33 = -b67 + b68                   

      e34 = -x69 + x70                   

      e35 = -x70 + x71                   

      e36 = -x71 + x72                   

      e37 = x1 - b17 - 2.0d0*b18 - 4.0d0*b19    

      e38 = x2 - b20 - 2.0d0*b21 - 4.0d0*b22    

      e39 = x3 - b23 - 2.0d0*b24 - 4.0d0*b25    

      e40 = x4 - b26 - 2.0d0*b27 - 4.0d0*b28    

      e41 = x5 - b29 - 2.0d0*b30 - 4.0d0*b31    

      e42 = x6 - b32 - 2.0d0*b33 - 4.0d0*b34    

      e43 = x7 - b35 - 2.0d0*b36 - 4.0d0*b37    

      e44 = x8 - b38 - 2.0d0*b39 - 4.0d0*b40    

      e45 = x9 - b41 - 2.0d0*b42 - 4.0d0*b43    

      e46 = x10 - b44 - 2.0d0*b45 - 4.0d0*b46   

      e47 = x11 - b47 - 2.0d0*b48 - 4.0d0*b49   

      e48 = x12 - b50 - 2.0d0*b51 - 4.0d0*b52   

      e49 = x13 - b53 - 2.0d0*b54 - 4.0d0*b55   

      e50 = x14 - b56 - 2.0d0*b57 - 4.0d0*b58   

      e51 = x15 - b59 - 2.0d0*b60 - 4.0d0*b61   

      e52 = x16 - b62 - 2.0d0*b63 - 4.0d0*b64   

      e53 = x69 - b73 - 2.0d0*b74 - 4.0d0*b75 - 8.0d0*b76 - 16.0d0*b77 

      e54 = x70 - b78 - 2.0d0*b79 - 4.0d0*b80 - 8.0d0*b81 - 16.0d0*b82 
      
      e55 = x71 - b83 - 2.0d0*b84 - 4.0d0*b85 - 8.0d0*b86 - 16.0d0*b87 

      e56 = x72 - b88 - 2.0d0*b89 - 4.0d0*b90 - 8.0d0*b91 - 16.0d0*b92 

      g(1) = e37
      g(2) = e38
      g(3) = e39
      g(4) = e40
      g(5) = e41
      g(6) = e42
      g(7) = e43
      g(8) = e44
      g(9) = e45
      g(10) = e46
      g(11) = e47
      g(12) = e48
      g(13) = e49
      g(14) = e50
      g(15) = e51
      g(16) = e52
      g(17) = e53
      g(18) = e54
      g(19) = e55
      g(20) = e56
      g(21) = e2
      g(22) = e3
      g(23) = e4
      g(24) = e5
      g(25) = -e6
      g(26) = -e7
      g(27) = -e8
      g(28) = -e9
      g(29) = -e10
      g(30) = -e11
      g(31) = -e12
      g(32) = -e13
      g(33) = -e14
      g(34) = -e15
      g(35) = -e16
      g(36) = -e17
      g(37) = -e18
      g(38) = -e19
      g(39) = -e20
      g(40) = -e21
      g(41) = -e22
      g(42) = -e23
      g(43) = -e24
      g(44) = -e25
      g(45) = -e26
      g(46) = -e27
      g(47) = -e28
      g(48) = -e29
      g(49) = e30
      g(50) = -e31
      g(51) = -e32
      g(52) = -e33
      g(53) = -e34
      g(54) = -e35
      g(55) = -e36

  999 continue
      return
      end
 

      subroutine ex1263a( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:04
*  
*  Equation counts
*     Total       E       G       L       N       X
*        36       1       5      30       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        25       1       4      20       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       153     121      32       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /        i10, i11, i12, i13, i14, i15, i16, b17, b18, b19, b20,
     /        i21, i22, i23, i24
      character*30 pnam, pref
      
      if (mode.eq.0) then
         pnam  = 'EX1263A'
         pref  = '\cite{MINLPLib}'
         fex   = 19.6d0
         ncont = 0
         nint  = 20
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 35
         me    = 0
         do i=1,nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         do i=nbin+1,nbin+16
            xl(i) = 0.0d0
            x(i)  = 3.0d0
            xu(i) = 5.0d0
         enddo
         do i=nbin+17,nbin+nint
            xl(i) = 0.0d0
            x(i)  = 20.0d0
            xu(i) = 30.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(nint+i) = x(i)
      end do
      do i=1,nint
         y(i) = x(nbin+i)
      end do

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)
      i14 = y(14)
      i15 = y(15)
      i16 = y(16)
      b17 = y(21)
      b18 = y(22)
      b19 = y(23)
      b20 = y(24)
      i21 = y(17)
      i22 = y(18)
      i23 = y(19)
      i24 = y(20)

      f = 0.1d0*b17 + 0.2d0*b18 + 0.3d0*b19 + 0.4d0*b20
     /    + i21 + i22 + i23 + i24

      g(1) = i21*i1 + i22*i2 + i23*i3 + i24*i4 - 15.0d0

      g(2) = i21*i5 + i22*i6 + i23*i7 + i24*i8 - 28.0d0

      g(3) = i21*i9 + i22*i10 + i23*i11 + i24*i12 - 21.0d0

      g(4) = i21*i13 + i22*i14 + i23*i15 + i24*i16 - 30.0d0

      g(5) = - (-290.0d0*i1 - 315.0d0*i5 - 350.0d0*i9
     /       - 455.0d0*i13 + 1750.0d0*b17)

      g(6) = - (-290.0d0*i2 - 315.0d0*i6 - 350.0d0*i10
     /       - 455.0d0*i14 + 1750.0d0*b18)

      g(7) = - (-290.0d0*i3 - 315.0d0*i7 - 350.0d0*i11
     /       - 455.0d0*i15 + 1750.0d0*b19)

      g(8) = - (-290.0d0*i4 - 315.0d0*i8 - 350.0d0*i12
     /       - 455.0d0*i16 + 1750.0d0*b20)

      g(9) = - (290.0d0*i1 + 315.0d0*i5 + 350.0d0*i9
     /       + 455.0d0*i13 - 1850.0d0*b17)

      g(10) = - (290.0d0*i2 + 315.0d0*i6 + 350.0d0*i10
     /        + 455.0d0*i14 - 1850.0d0*b18)

      g(11) = - (290.0d0*i3 + 315.0d0*i7 + 350.0d0*i11
     /        + 455.0d0*i15 - 1850.0d0*b19)

      g(12) = - (290.0d0*i4 + 315.0d0*i8 + 350.0d0*i12
     /        + 455.0d0*i16 - 1850.0d0*b20)  
     
      do i=5,12
         g(i) = g(i)*1.0d-4
      end do   
      
      g(13) = -(-i1 - i5 - i9 - i13 + b17)

      g(14) = -(-i2 - i6 - i10 - i14 + b18)

      g(15) = -(-i3 - i7 - i11 - i15 + b19)

      g(16) = -(-i4 - i8 - i12 - i16 + b20)

      g(17) = -(i1 + i5 + i9 + i13 - 5.0d0*b17)         

      g(18) = -(i2 + i6 + i10 + i14 - 5.0d0*b18)

      g(19) = -(i3 + i7 + i11 + i15 - 5.0d0*b19)

      g(20) = -(i4 + i8 + i12 + i16 - 5.0d0*b20)

      g(21) = -b17 + i21

      g(22) = -b18 + i22

      g(23) = -b19 + i23

      g(24) = -b20 + i24

      g(25) = 30.0d0*b17 - i21

      g(26) = 30.0d0*b18 - i22

      g(27) = 30.0d0*b19 - i23

      g(28) = 30.0d0*b20 - i24

      g(29) = i21 + i22 + i23 + i24 - 19.0d0

      g(30) = b17 - b18

      g(31) = b18 - b19

      g(32) = b19 - b20

      g(33) = i21 - i22

      g(34) = i22 - i23  

      g(35) = i23 - i24

  999 continue
      return
      end

      subroutine ex1264(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:06
*  
*  Equation counts
*     Total       E       G       L       N       X
*        56      21       5      30       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        89      21      68       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       237     205      32       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40,
     /        b41, b42, b43, b44, b45, b46, b47, b48, b49, b50,
     /        b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, b67, b68, x69, x70,
     /        x71, x72, b73, b74, b75, b76, b77, b78, b79, b80,
     /        b81, b82, b83, b84, b85, b86, b87, b88,
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1264'
         pref  = '\cite{MINLPLib}'
         fex   = 8.6d0
         ncont = 20
         nint  = 0
         nbin  = 68
         n     = ncont + nbin + nint
         m     = 55
         me    = 20
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         x(17)  = 4.0d0
         xu(17) = 15.0d0
         x(18)  = 4.0d0
         xu(18) = 12.0d0    
         x(19)  = 4.0d0
         xu(19) = 9.0d0     
         x(20)  = 4.0d0
         xu(20) = 6.0d0     
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)     
      b17 = y(1)
      b18 = y(2)
      b19 = y(3)
      b20 = y(4)
      b21 = y(5)
      b22 = y(6)
      b23 = y(7)
      b24 = y(8)
      b25 = y(9)
      b26 = y(10)
      b27 = y(11)
      b28 = y(12)
      b29 = y(13)
      b30 = y(14)
      b31 = y(15)
      b32 = y(16)
      b33 = y(17)
      b34 = y(18)
      b35 = y(19)
      b36 = y(20)
      b37 = y(21)
      b38 = y(22)
      b39 = y(23)
      b40 = y(24)
      b41 = y(25)
      b42 = y(26)
      b43 = y(27)
      b44 = y(28)
      b45 = y(29)
      b46 = y(30)
      b47 = y(31)
      b48 = y(32)
      b49 = y(33)
      b50 = y(34)
      b51 = y(35)
      b52 = y(36)
      b53 = y(37)
      b54 = y(38)
      b55 = y(39)
      b56 = y(40)
      b57 = y(41)
      b58 = y(42)
      b59 = y(43)
      b60 = y(44)
      b61 = y(45)
      b62 = y(46)
      b63 = y(47)
      b64 = y(48)
      b65 = y(49)
      b66 = y(50)
      b67 = y(51)
      b68 = y(52)     
      x69 = x(17)
      x70 = x(18)
      x71 = x(19)
      x72 = x(20)
      b73 = y(53)
      b74 = y(54)
      b75 = y(55)
      b76 = y(56)
      b77 = y(57)
      b78 = y(58)
      b79 = y(59)
      b80 = y(60)
      b81 = y(61)
      b82 = y(62)
      b83 = y(63)
      b84 = y(64)
      b85 = y(65)
      b86 = y(66)
      b87 = y(67)
      b88 = y(68)

      f = 0.1d0*b65 + 0.2d0*b66 + 0.3d0*b67 + 0.4d0*b68 + x69 + x70 
     /    + x71 + x72

      e2 = x69*x1 + x70*x2 + x71*x3 + x72*x4 - 9.0d0           

      e3 = x69*x5 + x70*x6 + x71*x7 + x72*x8 - 7.0d0           

      e4 = x69*x9 + x70*x10 + x71*x11 + x72*x12 - 12.0d0       

      e5 = x69*x13 + x70*x14 + x71*x15 + x72*x16 - 11.0d0      

      e6 = -330.0d0*x1 - 360.0d0*x5 - 385.0d0*x9 - 415.0d0*x13 
     /     + 1700.0d0*b65  

      e7 = -330*x2 - 360.0d0*x6 - 385.0d0*x10 - 415.0d0*x14 
     /     + 1700.0d0*b66 

      e8 = -330.0d0*x3 - 360.0d0*x7 - 385.0d0*x11 - 415.0d0*x15 
     /     + 1700.0d0*b67 

      e9 = -330.0d0*x4 - 360.0d0*x8 - 385.0d0*x12 - 415.0d0*x16 
     /     + 1700.0d0*b68 

      e10 = 330.0d0*x1 + 360.0d0*x5 + 385.0d0*x9 + 415.0d0*x13 
     /      - 1900.0d0*b65 

      e11 = 330.0d0*x2 + 360.0d0*x6 + 385.0d0*x10 + 415.0d0*x14 
     /      - 1900.0d0*b66

      e12 = 330.0d0*x3 + 360.0d0*x7 + 385.0d0*x11 + 415.0d0*x15 
     /      - 1900.0d0*b67

      e13 = 330.0d0*x4 + 360.0d0*x8 + 385.0d0*x12 + 415.0d0*x16
     /      - 1900.0d0*b68

      e14 = -x1 - x5 - x9 - x13 + b65                      

      e15 = -x2 - x6 - x10 - x14 + b66                     

      e16 = -x3 - x7 - x11 - x15 + b67                     

      e17 = -x4 - x8 - x12 - x16 + b68                     

      e18 = x1 + x5 + x9 + x13 - 5.0d0*b65                    

      e19 = x2 + x6 + x10 + x14 - 5.0d0*b66                   

      e20 = x3 + x7 + x11 + x15 - 5.0d0*b67                   

      e21 = x4 + x8 + x12 + x16 - 5.0d0*b68                   

      e22 = b65 - x69                                     

      e23 = b66 - x70                                     

      e24 = b67 - x71                                     

      e25 = b68 - x72                                     

      e26 = -15.0d0*b65 + x69                                  

      e27 = -12.0d0*b66 + x70                                  

      e28 = -9.0d0*b67 + x71                                   

      e29 = -6.0d0*b68 + x72                                   

      e30 = x69 + x70 + x71 + x72 - 8.0d0                   

      e31 = -b65 + b66                                     

      e32 = -b66 + b67                                     

      e33 = -b67 + b68                                     

      e34 = -x69 + x70                                     

      e35 = -x70 + x71                                     

      e36 = -x71 + x72                                     

      e37 = x1 - b17 - 2.0d0*b18 - 4.0d0*b19                      

      e38 = x2 - b20 - 2.0d0*b21 - 4.0d0*b22                      

      e39 = x3 - b23 - 2.0d0*b24 - 4.0d0*b25                      

      e40 = x4 - b26 - 2.0d0*b27 - 4.0d0*b28                      

      e41 = x5 - b29 - 2.0d0*b30 - 4.0d0*b31                      

      e42 = x6 - b32 - 2.0d0*b33 - 4.0d0*b34                      

      e43 = x7 - b35 - 2.0d0*b36 - 4.0d0*b37                      

      e44 = x8 - b38 - 2.0d0*b39 - 4.0d0*b40                      

      e45 = x9 - b41 - 2.0d0*b42 - 4.0d0*b43                      

      e46 = x10 - b44 - 2.0d0*b45 - 4.0d0*b46                     

      e47 = x11 - b47 - 2.0d0*b48 - 4.0d0*b49                     

      e48 = x12 - b50 - 2.0d0*b51 - 4.0d0*b52                     

      e49 = x13 - b53 - 2.0d0*b54 - 4.0d0*b55                     

      e50 = x14 - b56 - 2.0d0*b57 - 4.0d0*b58                     

      e51 = x15 - b59 - 2.0d0*b60 - 4.0d0*b61                     

      e52 = x16 - b62 - 2.0d0*b63 - 4.0d0*b64                     

      e53 = x69 - b73 - 2.0d0*b74 - 4.0d0*b75 - 8.0d0*b76             

      e54 = x70 - b77 - 2.0d0*b78 - 4.0d0*b79 - 8.0d0*b80             

      e55 = x71 - b81 - 2.0d0*b82 - 4.0d0*b83 - 8.0d0*b84             

      e56 = x72 - b85 - 2.0d0*b86 - 4.0d0*b87 - 8.0d0*b88      

      g(1) = e37
      g(2) = e38
      g(3) = e39
      g(4) = e40
      g(5) = e41
      g(6) = e42
      g(7) = e43
      g(8) = e44
      g(9) = e45
      g(10) = e46
      g(11) = e47
      g(12) = e48
      g(13) = e49
      g(14) = e50
      g(15) = e51
      g(16) = e52
      g(17) = e53
      g(18) = e54
      g(19) = e55
      g(20) = e56
      g(21) = e2
      g(22) = e3
      g(23) = e4
      g(24) = e5
      g(25) = -e6
      g(26) = -e7
      g(27) = -e8
      g(28) = -e9
      g(29) = -e10
      g(30) = -e11
      g(31) = -e12
      g(32) = -e13
      g(33) = -e14
      g(34) = -e15
      g(35) = -e16
      g(36) = -e17
      g(37) = -e18
      g(38) = -e19
      g(39) = -e20
      g(40) = -e21
      g(41) = -e22
      g(42) = -e23
      g(43) = -e24
      g(44) = -e25
      g(45) = -e26
      g(46) = -e27
      g(47) = -e28
      g(48) = -e29
      g(49) = e30
      g(50) = -e31
      g(51) = -e32
      g(52) = -e33
      g(53) = -e34
      g(54) = -e35
      g(55) = -e36

  999 continue
      return
      end
 

      subroutine ex1264a( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:06
*  
*  Equation counts
*     Total       E       G       L       N       X
*        56      21       5      30       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        89      21      68       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       237     205      32       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /        i10, i11, i12, i13, i14, i15, i16, b17, b18, b19, b20,
     /        i21, i22, i23, i24
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1264A'
         pref  = '\cite{MINLPLib}'
         fex   = 8.6d0
         ncont = 0
         nint  = 20
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 35
         me    = 0
         do i=1,nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i=nbin+1,nbin+nint
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         xu(nbin+17) = 15.0D0
         xu(nbin+18) = 12.0D0
         xu(nbin+19) = 9.0D0
         xu(nbin+20) = 6.0D0
         goto 999       
      endif
      
      do i=1,nbin
         y(nint+i) = x(i)
      enddo
      do i=1,nint
         y(i) = x(nbin+i)
      enddo
      
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)
      i14 = y(14)
      i15 = y(15)
      i16 = y(16)
      i21 = y(17)
      i22 = y(18)
      i23 = y(19)
      i24 = y(20)
      b17 = y(21)
      b18 = y(22)
      b19 = y(23)
      b20 = y(24)

      f = 0.1d0*b17 + 0.2d0*b18 + 0.3d0*b19 + 0.4d0*b20
     /         + i21 + i22 + i23 + i24

      g(1) = i21*i1 + i22*i2 + i23*i3 + i24*i4 - 9.0d0

      g(2) = i21*i5 + i22*i6 + i23*i7 + i24*i8 - 7.0d0

      g(3) = i21*i9 + i22*i10 + i23*i11 + i24*i12 - 12.0d0

      g(4) = i21*i13 + i22*i14 + i23*i15 + i24*i16 - 11.0d0

      g(5) = -(-330.0d0*i1 - 360.0d0*i5 - 385.0d0*i9
     /       - 415.0d0*i13 + 1700.0d0*b17)

      g(6) = -(-330.0d0*i2 - 360.0d0*i6 - 385.0d0*i10
     /       - 415.0d0*i14 + 1700.0d0*b18)

      g(7) = -(-330.0d0*i3 - 360.0d0*i7 - 385.0d0*i11
     /       - 415.0d0*i15 + 1700.0d0*b19)

      g(8) = -(-330.0d0*i4 - 360.0d0*i8 - 385.0d0*i12
     /       - 415.0d0*i16 + 1700.0d0*b20)

      g(9) = -(330.0d0*i1 + 360.0d0*i5 + 385.0d0*i9
     /       + 415.0d0*i13 - 1900.0d0*b17)

      g(10) = -(330.0d0*i2 + 360.0d0*i6 + 385.0d0*i10
     /       + 415.0d0*i14 - 1900.0d0*b18)

      g(11) = -(330.0d0*i3 + 360.0d0*i7 + 385.0d0*i11
     /       + 415.0d0*i15 - 1900.0d0*b19)

      g(12) = -(330.0d0*i4 + 360.0d0*i8 + 385.0d0*i12
     /       + 415.0d0*i16 - 1900.0d0*b20)

      g(13) = -(-i1 - i5 - i9 - i13 + b17)

      g(14) = -(-i2 - i6 - i10 - i14 + b18)

      g(15) = -(-i3 - i7 - i11 - i15 + b19)

      g(16) = -(-i4 - i8 - i12 - i16 + b20)

      g(17) = -(i1 + i5 + i9 + i13 - 5.0d0*b17)         

      g(18) = -(i2 + i6 + i10 + i14 - 5.0d0*b18)

      g(19) = -(i3 + i7 + i11 + i15 - 5.0d0*b19)

      g(20) = -(i4 + i8 + i12 + i16 - 5.0d0*b20)

      g(21) = -b17 + i21

      g(22) = -b18 + i22

      g(23) = -b19 + i23

      g(24) = -b20 + i24

      g(25) = 15.0d0*b17 - i21

      g(26) = 12.0d0*b18 - i22

      g(27) = 9.0d0*b19 - i23

      g(28) = 6.0d0*b20 - i24

      g(29) = i21 + i22 + i23 + i24 - 8.0d0

      g(30) = b17 - b18

      g(31) = b18 - b19

      g(32) = b19 - b20

      g(33) = i21 - i22

      g(34) = i22 - i23  

      g(35) = i23 - i24

  999 continue
      return
      end

      subroutine ex1265( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:13
*  
*  Equation counts
*     Total       E       G       L       N       X
*        75      31       6      38       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       131      31     100       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       347     297      50       0
*
*  Solve m using MINLP minimizing objvar;

      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax),
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, b26, b27, b28, b29, b30,
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40,
     /        b41, b42, b43, b44, b45, b46, b47, b48, b49, b50,
     /        b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, b67, b68, b69, b70,
     /        b71, b72, b73, b74, b75, b76, b77, b78, b79, b80,
     /        b81, b82, b83, b84, b85, b86, b87, b88, b89, b90,
     /        b91, b92, b93, b94, b95, b96, b97, b98, b99,b100,
     /       b101,b102,b103,b104,b105,x106,x107,x108,x109,x110,
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1265'
         pref  = '\cite{MINLPLib}'
         fex   = 10.3d0
         ncont = 30
         nint  = 0
         nbin  = 100
         n     = ncont + nbin + nint
         m     = 74
         me    = 30
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         xu(26) = 15.0d0            
         xu(27) = 12.0d0            
         xu(28) = 9.0d0             
         xu(29) = 6.0d0             
         xu(30) = 6.0d0     
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin 
         y(i) = x(ncont+i) 
      enddo 

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      b26 = y(1)
      b27 = y(2)
      b28 = y(3)
      b29 = y(4)
      b30 = y(5)
      b31 = y(6)
      b32 = y(7)
      b33 = y(8)
      b34 = y(9)
      b35 = y(10)
      b36 = y(11)
      b37 = y(12)
      b38 = y(13)
      b39 = y(14)
      b40 = y(15)
      b41 = y(16)
      b42 = y(17)
      b43 = y(18)
      b44 = y(19)
      b45 = y(20)
      b46 = y(21)
      b47 = y(22)
      b48 = y(23)
      b49 = y(24)
      b50 = y(25)
      b51 = y(26)
      b52 = y(27)
      b53 = y(28)
      b54 = y(29)
      b55 = y(30)
      b56 = y(31)
      b57 = y(32)
      b58 = y(33)
      b59 = y(34)
      b60 = y(35)
      b61 = y(36)
      b62 = y(37)
      b63 = y(38)
      b64 = y(39)
      b65 = y(40)
      b66 = y(41)
      b67 = y(42)
      b68 = y(43)
      b69 = y(44)
      b70 = y(45)
      b71 = y(46)
      b72 = y(47)
      b73 = y(48)
      b74 = y(49)
      b75 = y(50)
      b76 = y(51)
      b77 = y(52)
      b78 = y(53)
      b79 = y(54)
      b80 = y(55)
      b81 = y(56)
      b82 = y(57)
      b83 = y(58)
      b84 = y(59)
      b85 = y(60)
      b86 = y(61)
      b87 = y(62)
      b88 = y(63)
      b89 = y(64)
      b90 = y(65)
      b91 = y(66)
      b92 = y(67)
      b93 = y(68)
      b94 = y(69)
      b95 = y(70)
      b96 = y(71)
      b97 = y(72)
      b98 = y(73)
      b99 = y(74)
      b100 = y(75)
      b101 = y(76)
      b102 = y(77)
      b103 = y(78)
      b104 = y(79)
      b105 = y(80)
      x106 = x(26)
      x107 = x(27)
      x108 = x(28)
      x109 = x(29)
      x110 = x(30)
      b111 = y(81)
      b112 = y(82)
      b113 = y(83)
      b114 = y(84)
      b115 = y(85)
      b116 = y(86)
      b117 = y(87)
      b118 = y(88)
      b119 = y(89)
      b120 = y(90)
      b121 = y(91)
      b122 = y(92)
      b123 = y(93)
      b124 = y(94)
      b125 = y(95)
      b126 = y(96)
      b127 = y(97)
      b128 = y(98)
      b129 = y(99)
      b130 = y(100)
      
      f = 0.1d0*b101 + 0.2d0*b102 + 0.3d0*b103 + 0.4d0*b104 + 0.5d0*b105
     /    + x106 + x107 + x108 + x109 + x110       

      e2 = x106*x1 + x107*x2 + x108*x3 + x109*x4 + x110*x5 - 12.0d0     

      e3 = x106*x6 + x107*x7 + x108*x8 + x109*x9 + x110*x10 - 6.0d0     

      e4 = x106*x11 + x107*x12 + x108*x13 + x109*x14 + x110*x15 - 15.0d0

      e5 = x106*x16 + x107*x17 + x108*x18 + x109*x19 + x110*x20 - 6.0d0 

      e6 = x106*x21 + x107*x22 + x108*x23 + x109*x24 + x110*x25 - 9.0d0 

      e7 = -330.0d0*x1 - 360.0d0*x6 - 370.0d0*x11 - 415.0d0*x16 
     /      - 435.0d0*x21 + 1800.0d0*b101 

      e8 = -330.0d0*x2 - 360.0d0*x7 - 370.0d0*x12 - 415.0d0*x17 
     /      - 435.0d0*x22 + 1800.0d0*b102 

      e9 = -330.0d0*x3 - 360.0d0*x8 - 370.0d0*x13 - 415.0d0*x18
     /      - 435.0d0*x23 + 1800.0d0*b103 

      e10 = -330.0d0*x4 - 360.0d0*x9 - 370.0d0*x14 - 415.0d0*x19 
     /      - 435.0d0*x24 + 1800.0d0*b104

      e11 = -330.0d0*x5 - 360.0d0*x10 - 370.0d0*x15 - 415.0d0*x20 
     /       - 435.0d0*x25 + 1800.0d0*b105    

      e12 = 330.0d0*x1 + 360.0d0*x6 + 370.0d0*x11 + 415.0d0*x16 
     /       + 435.0d0*x21 - 2000.0d0*b101

      e13 = 330.0d0*x2 + 360.0d0*x7 + 370.0d0*x12 + 415.0d0*x17 
     /       + 435.0d0*x22 - 2000.0d0*b102

      e14 = 330.0d0*x3 + 360.0d0*x8 + 370.0d0*x13 + 415.0d0*x18
     /       + 435.0d0*x23 - 2000.0d0*b103

      e15 = 330.0d0*x4 + 360.0d0*x9 + 370.0d0*x14 + 415.0d0*x19 
     /       + 435.0d0*x24 - 2000.0d0*b104

      e16 = 330.0d0*x5 + 360.0d0*x10 + 370.0d0*x15 + 415.0d0*x20 
     /       + 435.0d0*x25 - 2000.0d0*b105          

      e17 = -x1 - x6 - x11 - x16 - x21 + b101 

      e18 = -x2 - x7 - x12 - x17 - x22 + b102 

      e19 = -x3 - x8 - x13 - x18 - x23 + b103 

      e20 = -x4 - x9 - x14 - x19 - x24 + b104 

      e21 = -x5 - x10 - x15 - x20 - x25 + b105

      e22 = x1 + x6 + x11 + x16 + x21 - 5.0d0*b101                     

      e23 = x2 + x7 + x12 + x17 + x22 - 5.0d0*b102                     

      e24 = x3 + x8 + x13 + x18 + x23 - 5.0d0*b103                     

      e25 = x4 + x9 + x14 + x19 + x24 - 5.0d0*b104                     

      e26 = x5 + x10 + x15 + x20 + x25 - 5.0d0*b105                    

      e27 = b101 - x106                      

      e28 = b102 - x107                      

      e29 = b103 - x108                      

      e30 = b104 - x109                      

      e31 = b105 - x110                      

      e32 = -15.0d0*b101 + x106                   

      e33 = -12.0d0*b102 + x107                   

      e34 = -9.0d0*b103 + x108                    

      e35 = -6.0d0*b104 + x109                    

      e36 = -6.0d0*b105 + x110                    

      e37 = x106 + x107 + x108 + x109 + x110 - 10.0d0                

      e38 = -b101 + b102                      

      e39 = -b102 + b103                      

      e40 = -b103 + b104                      

      e41 = -b104 + b105                      

      e42 = -x106 + x107                      

      e43 = -x107 + x108                      

      e44 = -x108 + x109                      

      e45 = -x109 + x110                      

      e46 = x1 - b26 - 2.0d0*b27 - 4.0d0*b28         

      e47 = x2 - b29 - 2.0d0*b30 - 4.0d0*b31         

      e48 = x3 - b32 - 2.0d0*b33 - 4.0d0*b34         

      e49 = x4 - b35 - 2.0d0*b36 - 4.0d0*b37         

      e50 = x5 - b38 - 2.0d0*b39 - 4.0d0*b40         

      e51 = x6 - b41 - 2.0d0*b42 - 4.0d0*b43         

      e52 = x7 - b44 - 2.0d0*b45 - 4.0d0*b46         

      e53 = x8 - b47 - 2.0d0*b48 - 4.0d0*b49         

      e54 = x9 - b50 - 2.0d0*b51 - 4.0d0*b52         

      e55 = x10 - b53 - 2.0d0*b54 - 4.0d0*b55        

      e56 = x11 - b56 - 2.0d0*b57 - 4.0d0*b58        

      e57 = x12 - b59 - 2.0d0*b60 - 4.0d0*b61        

      e58 = x13 - b62 - 2.0d0*b63 - 4.0d0*b64        

      e59 = x14 - b65 - 2.0d0*b66 - 4.0d0*b67        

      e60 = x15 - b68 - 2.0d0*b69 - 4.0d0*b70        

      e61 = x16 - b71 - 2.0d0*b72 - 4.0d0*b73        

      e62 = x17 - b74 - 2.0d0*b75 - 4.0d0*b76        

      e63 = x18 - b77 - 2.0d0*b78 - 4.0d0*b79        

      e64 = x19 - b80 - 2.0d0*b81 - 4.0d0*b82        

      e65 = x20 - b83 - 2.0d0*b84 - 4.0d0*b85        

      e66 = x21 - b86 - 2.0d0*b87 - 4.0d0*b88        

      e67 = x22 - b89 - 2.0d0*b90 - 4.0d0*b91        

      e68 = x23 - b92 - 2.0d0*b93 - 4.0d0*b94        

      e69 = x24 - b95 - 2.0d0*b96 - 4.0d0*b97        

      e70 = x25 - b98 - 2.0d0*b99 - 4.0d0*b100       

      e71 = x106 - b111 - 2.0d0*b112 - 4.0d0*b113 - 8.0d0*b114 

      e72 = x107 - b115 - 2.0d0*b116 - 4.0d0*b117 - 8.0d0*b118 

      e73 = x108 - b119 - 2.0d0*b120 - 4.0d0*b121 - 8.0d0*b122 

      e74 = x109 - b123 - 2.0d0*b124 - 4.0d0*b125 - 8.0d0*b126 

      e75 = x110 - b127 - 2.0d0*b128 - 4.0d0*b129 - 8.0d0*b130

      g(1) = e46
      g(2) = e47
      g(3) = e48
      g(4) = e49
      g(5) = e50
      g(6) = e51
      g(7) = e52
      g(8) = e53
      g(9) = e54
      g(10) = e55
      g(11) = e56
      g(12) = e57
      g(13) = e58
      g(14) = e59
      g(15) = e60
      g(16) = e61
      g(17) = e62
      g(18) = e63
      g(19) = e64
      g(20) = e65
      g(21) = e66
      g(22) = e67
      g(23) = e68
      g(24) = e69
      g(25) = e70
      g(26) = e71
      g(27) = e72
      g(28) = e73
      g(29) = e74
      g(30) = e75
      
      g(31) = e2
      g(32) = e3
      g(33) = e4
      g(34) = e5
      g(35) = e6
      g(36) = -e7
      g(37) = -e8
      g(38) = -e9
      g(39) = -e10
      g(40) = -e11
      g(41) = -e12
      g(42) = -e13
      g(43) = -e14
      g(44) = -e15
      g(45) = -e16
      g(46) = -e17
      g(47) = -e18
      g(48) = -e19
      g(49) = -e20
      g(50) = -e21
      g(51) = -e22
      g(52) = -e23
      g(53) = -e24
      g(54) = -e25
      g(55) = -e26
      g(56) = -e27
      g(57) = -e28
      g(58) = -e29
      g(59) = -e30
      g(60) = -e31
      g(61) = -e32
      g(62) = -e33
      g(63) = -e34
      g(64) = -e35
      g(65) = -e36
      g(66) = e37
      g(67) = -e38
      g(68) = -e39
      g(69) = -e40
      g(70) = -e41
      g(71) = -e42
      g(72) = -e43
      g(73) = -e44
      g(74) = -e45

  999 continue
      return
      end

      subroutine ex1265a( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:18
*  
*  Equation counts
*     Total       E       G       L       N       X
*        45       1       6      38       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        36       1       5      30       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       222     172      50       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /        i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20,
     /        i21, i22, i23, i24, i25, b26, b27, b28, b29, b30, i31, 
     /        i32, i33, i34, i35
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1265A'
         pref  = '\cite{MINLPLib}'
         fex   = 10.3d0
         ncont = 0
         nint  = 30
         nbin  = 5
         n     = ncont + nbin + nint
         m     = 44
         me    = 0
         do i=1,nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i=nbin+1,nbin+nint
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         xu(nbin+26) = 15.0d0
         xu(nbin+27) = 12.0d0
         xu(nbin+28) = 9.0d0
         xu(nbin+29) = 6.0d0
         xu(nbin+30) = 6.0d0
         goto 999       
      endif
      
      do i=1,nbin
         y(nint+i) = x(i)
      enddo
      do i=1,nint
         y(i) = x(nbin+i)
      enddo
      
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)
      i14 = y(14)
      i15 = y(15)
      i16 = y(16)
      i17 = y(17)
      i18 = y(18)
      i19 = y(19)
      i20 = y(20)
      i21 = y(21)
      i22 = y(22)
      i23 = y(23)
      i24 = y(24)
      i25 = y(25)
      b26 = y(31)
      b27 = y(32)
      b28 = y(33)
      b29 = y(34)
      b30 = y(35)
      i31 = y(26)
      i32 = y(27)
      i33 = y(28)
      i34 = y(29)
      i35 = y(30)

      f = -(-0.1d0*b26 - 0.2d0*b27 - 0.3d0*b28 - 0.4d0*b29 
     /    - 0.5d0*b30 - i31 - i32 - i33 - i34 - i35)

      g(1) = i31*i1 + i32*i2 + i33*i3 + i34*i4 + i35*i5 - 12.0d0
 
      g(2) = i31*i6 + i32*i7 + i33*i8 + i34*i9 + i35*i10 - 6.0d0
 
      g(3) = i31*i11 + i32*i12 + i33*i13 + i34*i14 + i35*i15 - 15.0d0
 
      g(4) = i31*i16 + i32*i17 + i33*i18 + i34*i19 + i35*i20 - 6.0d0
 
      g(5) = i31*i21 + i32*i22 + i33*i23 + i34*i24 + i35*i25 - 9.0d0
 
      g(6) = -(- 330.0d0*i1 - 360.0d0*i6 - 370.0d0*i11
     /       - 415.0d0*i16 - 435.0d0*i21 + 1800.0d0*b26)
 
      g(7) = -(- 330.0d0*i2 - 360.0d0*i7 - 370.0d0*i12
     /       - 415.0d0*i17 - 435.0d0*i22 + 1800.0d0*b27)
 
      g(8) = -(- 330.0d0*i3 - 360.0d0*i8 - 370.0d0*i13
     /       - 415.0d0*i18 - 435.0d0*i23 + 1800.0d0*b28)
 
      g(9) = -(- 330.0d0*i4 - 360.0d0*i9 - 370.0d0*i14
     /       - 415.0d0*i19 - 435.0d0*i24 + 1800.0d0*b29)
 
      g(10) = -(- 330.0d0*i5 - 360.0d0*i10 - 370.0d0*i15
     /        - 415.0d0*i20 - 435.0d0*i25 + 1800.0d0*b30)
 
      g(11) = -(330.0d0*i1 + 360.0d0*i6 + 370.0d0*i11
     /        + 415.0d0*i16 + 435.0d0*i21 - 2000.0d0*b26)
 
      g(12) = -(330.0d0*i2 + 360.0d0*i7 + 370.0d0*i12
     /        + 415.0d0*i17 + 435.0d0*i22 - 2000.0d0*b27)
 
      g(13) = -(330.0d0*i3 + 360.0d0*i8 + 370.0d0*i13
     /        + 415.0d0*i18 + 435.0d0*i23 - 2000.0d0*b28)
 
      g(14) = -(330.0d0*i4 + 360.0d0*i9 + 370.0d0*i14 
     /        + 415.0d0*i19 + 435.0d0*i24 - 2000.0d0*b29)
 
      g(15) = -(330.0d0*i5 + 360.0d0*i10 + 370.0d0*i15
     /        + 415.0d0*i20 + 435.0d0*i25 - 2000.0d0*b30)
         
      g(16) = -(- i1 - i6 - i11 - i16 - i21 + b26)
 
      g(17) = -(- i2 - i7 - i12 - i17 - i22 + b27)         

      g(18) = -(- i3 - i8 - i13 - i18 - i23 + b28)

      g(19) = -(- i4 - i9 - i14 - i19 - i24 + b29)

      g(20) = -(- i5 - i10 - i15 - i20 - i25 + b30)

      g(21) = -(i1 + i6 + i11 + i16 + i21 - 5.0d0*b26)

      g(22) = -(i2 + i7 + i12 + i17 + i22 - 5.0d0*b27)

      g(23) = -(i3 + i8 + i13 + i18 + i23 - 5.0d0*b28)

      g(24) = -(i4 + i9 + i14 + i19 + i24 - 5.0d0*b29)

      g(25) = -(i5 + i10 + i15 + i20 + i25 - 5.0d0*b30)

      g(26) = -b26 + i31

      g(27) = -b27 + i32

      g(28) = -b28 + i33

      g(29) = -b29 + i34

      g(30) = -b30 + i35

      g(31) = 15.0d0*b26 - i31

      g(32) = 12.0d0*b27 - i32

      g(33) = 9.0d0*b28 - i33

      g(34) = 6.0d0*b29 - i34 

      g(35) = 6.0d0*b30 + i35

      g(36) = i31 + i32 + i33 + i34 + i35 - 10.0d0

      g(37) = b26 - b27

      g(38) = b27 - b28

      g(39) = b28 - b29

      g(40) = b29 - b30 

      g(41) = i31 - i32

      g(42) = i32 - i33 

      g(43) = i33 - i34

      g(44) = i34 - i35 

  999 continue
      return
      end

      subroutine ex1266( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:20
*  
*  Equation counts
*     Total       E       G       L       N       X
*        96      43       7      46       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       181      43     138       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       476     404      72       0
*
*  Solve m using MINLP minimizing objvar;

      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1266'
         pref  = '\cite{MINLPLib}'
         fex   = 16.3d0
         ncont = 42
         nint  = 0
         nbin  = 138
         n     = ncont + nbin + nint
         m     = 95
         me    = 42
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 5.0d0
         enddo
         xu(37) = 15.0d0            
         xu(38) = 12.0d0            
         xu(39) = 8.0d0            
         xu(40) = 7.0d0             
         xu(41) = 4.0d0             
         xu(42) = 2.0d0     
         x(1)  = 1.0d0 
         x(7) = 2.0d0 
         x(14) = 2.0d0 
         x(20) = 1.0d0 
         x(26) = 2.0d0 
         x(31) = 1.0d0 
         x(151) = 8.0d0 
         x(152) = 7.0d0 
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin 
         y(i) = x(ncont+i) 
      enddo 

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      b37 = y(1)
      b38 = y(2)
      b39 = y(3)
      b40 = y(4)
      b41 = y(5)
      b42 = y(6)
      b43 = y(7)
      b44 = y(8)
      b45 = y(9)
      b46 = y(10)
      b47 = y(11)
      b48 = y(12)
      b49 = y(13)
      b50 = y(14)
      b51 = y(15)
      b52 = y(16)
      b53 = y(17)
      b54 = y(18)
      b55 = y(19)
      b56 = y(20)
      b57 = y(21)
      b58 = y(22)
      b59 = y(23)
      b60 = y(24)
      b61 = y(25)
      b62 = y(26)
      b63 = y(27)
      b64 = y(28)
      b65 = y(29)
      b66 = y(30)
      b67 = y(31)
      b68 = y(32)
      b69 = y(33)
      b70 = y(34)
      b71 = y(35)
      b72 = y(36)
      b73 = y(37)
      b74 = y(38)
      b75 = y(39)
      b76 = y(40)
      b77 = y(41)
      b78 = y(42)
      b79 = y(43)
      b80 = y(44)
      b81 = y(45)
      b82 = y(46)
      b83 = y(47)
      b84 = y(48)
      b85 = y(49)
      b86 = y(50)
      b87 = y(51)
      b88 = y(52)
      b89 = y(53)
      b90 = y(54)
      b91 = y(55)
      b92 = y(56)
      b93 = y(57)
      b94 = y(58)
      b95 = y(59)
      b96 = y(60)
      b97 = y(61)
      b98 = y(62)
      b99 = y(63)
      b100 = y(64)
      b101 = y(65)
      b102 = y(66)
      b103 = y(67)
      b104 = y(68)
      b105 = y(69)
      b106 = y(70)
      b107 = y(71)
      b108 = y(72)
      b109 = y(73)
      b110 = y(74)
      b111 = y(75)
      b112 = y(76)
      b113 = y(77)
      b114 = y(78)
      b115 = y(79)
      b116 = y(80)
      b117 = y(81)
      b118 = y(82)
      b119 = y(83)
      b120 = y(84)
      b121 = y(85)
      b122 = y(86)
      b123 = y(87)
      b124 = y(88)
      b125 = y(89)
      b126 = y(90)
      b127 = y(91)
      b128 = y(92)
      b129 = y(93)
      b130 = y(94)
      b131 = y(95)
      b132 = y(96)
      b133 = y(97)
      b134 = y(98)
      b135 = y(99)
      b136 = y(100)
      b137 = y(101)
      b138 = y(102)
      b139 = y(103)
      b140 = y(104)
      b141 = y(105)
      b142 = y(106)
      b143 = y(107)
      b144 = y(108)
      b145 = y(109)
      b146 = y(110)
      b147 = y(111)
      b148 = y(112)
      b149 = y(113)
      b150 = y(114)
      x151 = x(37)
      x152 = x(38)
      x153 = x(39)
      x154 = x(40)
      x155 = x(41)
      x156 = x(42)
      b157 = y(115)
      b158 = y(116)
      b159 = y(117)
      b160 = y(118)
      b161 = y(119)
      b162 = y(120)
      b163 = y(121)
      b164 = y(122)
      b165 = y(123)
      b166 = y(124)
      b167 = y(125)
      b168 = y(126)
      b169 = y(127)
      b170 = y(128)
      b171 = y(129)
      b172 = y(130)
      b173 = y(131)
      b174 = y(132)
      b175 = y(133)
      b176 = y(134)
      b177 = y(135)
      b178 = y(136)
      b179 = y(137)
      b180 = y(138)

      f = 0.1d0*b145 + 0.2d0*b146 + 0.3d0*b147 + 0.4d0*b148
     /     + 0.5d0*b149 + x151 + x152 + x153 + x154 + x155 + x156      

      e2 = x151*x1 + x152*x2 + x153*x3 + x154*x4 + x155*x5 + x156*x6
     /      - 8.0d0                                

      e3 = x151*x7 + x152*x8 + x153*x9 + x154*x10 + x155*x11 + x156*x12
     /      - 16.0d0

      e4 = x151*x13 + x152*x14 + x153*x15 + x154*x16 + x155*x17 
     /      + x156*x18 - 12.0d0

      e5 = x151*x19 + x152*x20 + x153*x21 + x154*x22 + x155*x23 
     /      + x156*x24 - 7.0d0

      e6 = x151*x25 + x152*x26 + x153*x27 + x154*x28 + x155*x29 
     /       + x156*x30 - 14.0d0

      e7 = x151*x31 + x152*x32 + x153*x33 + x154*x34 + x155*x35 
     /      + x156*x36 - 16.0d0

      e8 = -330.0d0*x1 - 360.0d0*x7 - 380.0d0*x13 - 430.0d0*x19 
     /      - 490.0d0*x25 - 530.0d0*x31 + 2100.0d0*b145  

      e9 = -330.0d0*x2 - 360.0d0*x8 - 380.0d0*x14 - 430.0d0*x20 
     /      - 490.0d0*x26 - 530.0d0*x32 + 2100.0d0*b146  

      e10 = -330.0d0*x3 - 360.0d0*x9 - 380.0d0*x15 - 430.0d0*x21 
     /       - 490.0d0*x27 - 530.0d0*x33 + 2100.0d0*b147    

      e11 = -330.0d0*x4 - 360.0d0*x10 - 380.0d0*x16 - 430.0d0*x22 
     /       - 490.0d0*x28 - 530.0d0*x34 + 2100.0d0*b148    

      e12 = -330.0d0*x5 - 360.0d0*x11 - 380.0d0*x17 - 430.0d0*x23 
     /       - 490.0d0*x29 - 530.0d0*x35 + 2100.0d0*b149  

      e13 = -330.0d0*x6 - 360.0d0*x12 - 380.0d0*x18 - 430.0d0*x24 
     /       - 490.0d0*x30 - 530.0d0*x36 + 2100.0d0*b150   

      e14 = 330.0d0*x1 + 360.0d0*x7 + 380.0d0*x13 + 430.0d0*x19 
     /       + 490.0d0*x25 + 530.0d0*x31 - 2200.0d0*b145   

      e15 = 330.0d0*x2 + 360.0d0*x8 + 380.0d0*x14 + 430.0d0*x20 
     /       + 490.0d0*x26 + 530.0d0*x32 - 2200.0d0*b146         

      e16 = 330.0d0*x3 + 360.0d0*x9 + 380.0d0*x15 + 430.0d0*x21 
     /      + 490.0d0*x27 + 530.0d0*x33 - 2200.0d0*b147  

      e17 = 330.0d0*x4 + 360.0d0*x10 + 380.0d0*x16 + 430.0d0*x22 
     /      + 490.0d0*x28 + 530.0d0*x34 - 2200.0d0*b148      

      e18 = 330.0d0*x5 + 360.0d0*x11 + 380.0d0*x17 + 430.0d0*x23 
     /      + 490.0d0*x29 + 530.0d0*x35 - 2200.0d0*b149        

      e19 = 330.0d0*x6 + 360.0d0*x12 + 380.0d0*x18 + 430.0d0*x24 
     /      + 490.0d0*x30 + 530.0d0*x36 - 2200.0d0*b150      

      e20 = -x1 - x7 - x13 - x19 - x25 - x31 + b145  

      e21 = -x2 - x8 - x14 - x20 - x26 - x32 + b146  

      e22 = -x3 - x9 - x15 - x21 - x27 - x33 + b147  

      e23 = -x4 - x10 - x16 - x22 - x28 - x34 + b148 

      e24 = -x5 - x11 - x17 - x23 - x29 - x35 + b149 

      e25 = -x6 - x12 - x18 - x24 - x30 - x36 + b150 

      e26 = x1 + x7 + x13 + x19 + x25 + x31 - 5.0d0*b145

      e27 = x2 + x8 + x14 + x20 + x26 + x32 - 5.0d0*b146

      e28 = x3 + x9 + x15 + x21 + x27 + x33 - 5.0d0*b147

      e29 = x4 + x10 + x16 + x22 + x28 + x34 - 5.0d0*b148   

      e30 = x5 + x11 + x17 + x23 + x29 + x35 - 5.0d0*b149   

      e31 = x6 + x12 + x18 + x24 + x30 + x36 - 5.0d0*b150   

      e32 = b145 - x151                             

      e33 = b146 - x152                             

      e34 = b147 - x153                             

      e35 = b148 - x154                             

      e36 = b149 - x155                             

      e37 = b150 - x156                             

      e38 = -15*b145 + x151                          

      e39 = -12*b146 + x152                          

      e40 = -8*b147 + x153                           

      e41 = -7*b148 + x154                           

      e42 = -4*b149 + x155                           

      e43 = -2*b150 + x156                           

      e44 = x151 + x152 + x153 + x154 + x155 + x156 - 16.0d0       

      e45 = -b145 + b146                             

      e46 = -b146 + b147                             

      e47 = -b147 + b148                             

      e48 = -b148 + b149                             

      e49 = -b149 + b150                             

      e50 = -x151 + x152                             

      e51 = -x152 + x153                             

      e52 = -x153 + x154                             

      e53 = -x154 + x155                             

      e54 = -x155 + x156                             

      e55 = x1 - b37 - 2.0d0*b38 - 4.0d0*b39                

      e56 = x2 - b40 - 2.0d0*b41 - 4.0d0*b42                

      e57 = x3 - b43 - 2.0d0*b44 - 4.0d0*b45                

      e58 = x4 - b46 - 2.0d0*b47 - 4.0d0*b48                

      e59 = x5 - b49 - 2.0d0*b50 - 4.0d0*b51                

      e60 = x6 - b52 - 2.0d0*b53 - 4.0d0*b54                

      e61 = x7 - b55 - 2.0d0*b56 - 4.0d0*b57                

      e62 = x8 - b58 - 2.0d0*b59 - 4.0d0*b60                

      e63 = x9 - b61 - 2.0d0*b62 - 4.0d0*b63                

      e64 = x10 - b64 - 2.0d0*b65 - 4.0d0*b66               

      e65 = x11 - b67 - 2.0d0*b68 - 4.0d0*b69               

      e66 = x12 - b70 - 2.0d0*b71 - 4.0d0*b72               

      e67 = x13 - b73 - 2.0d0*b74 - 4.0d0*b75               

      e68 = x14 - b76 - 2.0d0*b77 - 4.0d0*b78               

      e69 = x15 - b79 - 2.0d0*b80 - 4.0d0*b81               

      e70 = x16 - b82 - 2.0d0*b83 - 4.0d0*b84               

      e71 = x17 - b85 - 2.0d0*b86 - 4.0d0*b87               

      e72 = x18 - b88 - 2.0d0*b89 - 4.0d0*b90               

      e73 = x19 - b91 - 2.0d0*b92 - 4.0d0*b93               

      e74 = x20 - b94 - 2.0d0*b95 - 4.0d0*b96               

      e75 = x21 - b97 - 2.0d0*b98 - 4.0d0*b99               

      e76 = x22 - b100 - 2.0d0*b101 - 4.0d0*b102            

      e77 = x23 - b103 - 2.0d0*b104 - 4.0d0*b105            

      e78 = x24 - b106 - 2.0d0*b107 - 4.0d0*b108            

      e79 = x25 - b109 - 2.0d0*b110 - 4.0d0*b111            

      e80 = x26 - b112 - 2.0d0*b113 - 4.0d0*b114            

      e81 = x27 - b115 - 2.0d0*b116 - 4.0d0*b117            

      e82 = x28 - b118 - 2.0d0*b119 - 4.0d0*b120            

      e83 = x29 - b121 - 2.0d0*b122 - 4.0d0*b123            

      e84 = x30 - b124 - 2.0d0*b125 - 4.0d0*b126            

      e85 = x31 - b127 - 2.0d0*b128 - 4.0d0*b129            

      e86 = x32 - b130 - 2.0d0*b131 - 4.0d0*b132            

      e87 = x33 - b133 - 2.0d0*b134 - 4.0d0*b135            

      e88 = x34 - b136 - 2.0d0*b137 - 4.0d0*b138            

      e89 = x35 - b139 - 2.0d0*b140 - 4.0d0*b141            

      e90 = x36 - b142 - 2.0d0*b143 - 4.0d0*b144            

      e91 = x151 - b157 - 2.0d0*b158 - 4.0d0*b159 - 8.0d0*b160  

      e92 = x152 - b161 - 2.0d0*b162 - 4.0d0*b163 - 8.0d0*b164  

      e93 = x153 - b165 - 2.0d0*b166 - 4.0d0*b167 - 8.0d0*b168  

      e94 = x154 - b169 - 2.0d0*b170 - 4.0d0*b171 - 8.0d0*b172  

      e95 = x155 - b173 - 2.0d0*b174 - 4.0d0*b175 - 8.0d0*b176  

      e96 = x156 - b177 - 2.0d0*b178 - 4.0d0*b179 - 8.0d0*b180

      g(43) = e2
      g(44) = e3
      g(45) = e4
      g(46) = e5
      g(47) = e6
      g(48) = e7
      g(49) = -e8
      g(50) = -e9
      g(51) = -e10
      g(52) = -e11
      g(53) = -e12
      g(54) = -e13
      g(55) = -e14
      g(56) = -e15
      g(57) = -e16
      g(58) = -e17
      g(59) = -e18
      g(60) = -e19
      g(61) = -e20
      g(62) = -e21
      g(63) = -e22
      g(64) = -e23
      g(65) = -e24
      g(66) = -e25
      g(67) = -e26
      g(68) = -e27
      g(69) = -e28
      g(70) = -e29
      g(71) = -e30
      g(72) = -e31
      g(73) = -e32
      g(74) = -e33
      g(75) = -e34
      g(76) = -e35
      g(77) = -e36
      g(78) = -e37
      g(79) = -e38
      g(80) = -e39
      g(81) = -e40
      g(82) = -e41
      g(83) = -e42
      g(84) = -e43
      g(85) = e44
      g(86) = -e45
      g(87) = -e46
      g(88) = -e47
      g(89) = -e48
      g(90) = -e49
      g(91) = -e50
      g(92) = -e51
      g(93) = -e52
      g(94) = -e53
      g(95) = -e54
      g(1) = e55
      g(2) = e56
      g(3) = e57
      g(4) = e58
      g(5) = e59
      g(6) = e60
      g(7) = e61
      g(8) = e62
      g(9) = e63
      g(10) = e64
      g(11) = e65
      g(12) = e66
      g(13) = e67
      g(14) = e68
      g(15) = e69
      g(16) = e70
      g(17) = e71
      g(18) = e72
      g(19) = e73
      g(20) = e74
      g(21) = e75
      g(22) = e76
      g(23) = e77
      g(24) = e78
      g(25) = e79
      g(26) = e80
      g(27) = e81
      g(28) = e82
      g(29) = e83
      g(30) = e84
      g(31) = e85
      g(32) = e86
      g(33) = e87
      g(34) = e88
      g(35) = e89
      g(36) = e90
      g(37) = e91
      g(38) = e92
      g(39) = e93
      g(40) = e94
      g(41) = e95
      g(42) = e96
 
  999 continue
      return
      end

      subroutine ex1266a( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:32
*  
*  Equation counts
*     Total       E       G       L       N       X
*        54       1       7      46       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        49       1       6      42       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       302     230      72       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, i5, i6, i7, i8, i9, 
     /        i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20,
     /        i21, i22, i23, i24, i25, i26, i27, i28, i29, i30, i31, 
     /        i32, i33, i34, i35, i36, b37, b38, b39, b40, b41, b42,
     /        i43, i44, i45, i46, i47, i48
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX1266A'
         pref  = '\cite{MINLPLib}'
         fex   = 16.3d0
         ncont = 0
         nint  = 42
         nbin  = 6
         n     = ncont + nbin + nint
         m     = 53
         me    = 0
         do i=1,nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         do i=nbin+1,nbin+nint
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 5.0d0
         enddo
         x(nbin+1)   = 1.0D0
         x(nbin+7)   = 2.0D0
         x(nbin+14)  = 2.0D0
         x(nbin+20)  = 1.0D0
         x(nbin+26)  = 2.0D0
         x(nbin+31)  = 1.0D0         
         xu(nbin+37) = 15.0D0
         x(nbin+37)  = 8.0D0
         xu(nbin+38) = 12.0D0
         x(nbin+38)  = 7.0D0
         xu(nbin+39) = 8.0D0
         xu(nbin+40) = 7.0D0
         xu(nbin+41) = 4.0D0
         xu(nbin+42) = 2.0D0
         goto 999       
      endif
      
      do i=1,nbin
         y(nint+i) = x(i)
      enddo
      do i=1,nint
         y(i) = x(nbin+i)
      enddo
      
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)
      i10 = y(10)
      i11 = y(11)
      i12 = y(12)
      i13 = y(13)
      i14 = y(14)
      i15 = y(15)
      i16 = y(16)
      i17 = y(17)
      i18 = y(18)
      i19 = y(19)
      i20 = y(20)
      i21 = y(21)
      i22 = y(22)
      i23 = y(23)
      i24 = y(24)
      i25 = y(25)
      i26 = y(26)
      i27 = y(27)
      i28 = y(28)
      i29 = y(29)
      i30 = y(30)
      i31 = y(31)
      i32 = y(32)
      i33 = y(33)
      i34 = y(34)
      i35 = y(35)
      i36 = y(36)
      b37 = y(43)
      b38 = y(44)
      b39 = y(45)
      b40 = y(46)
      b41 = y(47)
      b42 = y(48)
      i43 = y(37)
      i44 = y(38)
      i45 = y(39)
      i46 = y(40)
      i47 = y(41)
      i48 = y(42)
  
      f = -(- 0.1d0*b37 - 0.2d0*b38 - 0.3d0*b39 - 0.4d0*b40
     /         - 0.5d0*b41 - i43 - i44 - i45 - i46 - i47 - i48)

      g(1) = i43*i1 + i44*i2 + i45*i3 + i46*i4 + i47*i5 + i48*i6
     /       - 8.0d0
 
      g(2) = i43*i7 + i44*i8 + i45*i9 + i46*i10 + i47*i11 + i48*i12
     /       - 16.0d0
 
      g(3) = i43*i13 + i44*i14 + i45*i15 + i46*i16 + i47*i17
     /       + i48*i18 - 12.0d0
 
      g(4) = i43*i19 + i44*i20 + i45*i21 + i46*i22 + i47*i23 
     /       + i48*i24 - 7.0d0
 
      g(5) = i43*i25 + i44*i26 + i45*i27 + i46*i28 + i47*i29
     /       + i48*i30 - 14.0d0
 
      g(6) = i43*i31 + i44*i32 + i45*i33 + i46*i34 + i47*i35
     /       + i48*i36 - 16.0d0
 
      g(7) = -(- 330.0d0*i1 - 360.0d0*i7 - 380.0d0*i13
     /         - 430.0d0*i19 - 490.0d0*i25 - 530.0d0*i31
     /         + 2100.0d0*b37)
 
      g(8) = -(- 330.0d0*i2 - 360.0d0*i8 - 380.0d0*i14
     /         - 430.0d0*i20 - 490.0d0*i26 - 530.0d0*i32
     /         + 2100.0d0*b38)
 
      g(9) = -(- 330.0d0*i3 - 360.0d0*i9 - 380.0d0*i15
     /         - 430.0d0*i21 - 490.0d0*i27 - 530.0d0*i33
     /         + 2100.0d0*b39)
 
      g(10) = -(- 330.0d0*i4 - 360.0d0*i10 - 380.0d0*i16
     /         - 430.0d0*i22 - 490.0d0*i28 - 530.0d0*i34
     /         + 2100.0d0*b40)
 
      g(11) = -(- 330.0d0*i5 - 360.0d0*i11 - 380.0d0*i17
     /         - 430.0d0*i23 - 490.0d0*i29 - 530.0d0*i35
     /         + 2100.0d0*b41)
 
      g(12) = -(- 330.0d0*i6 - 360.0d0*i12 - 380.0d0*i18
     /         - 430.0d0*i24 - 490.0d0*i30 - 530.0d0*i36
     /         + 2100.0d0*b42)
 
      g(13) = -(330.0d0*i1 + 360.0d0*i7 + 380.0d0*i13
     /         + 430.0d0*i19 + 490.0d0*i25 + 530.0d0*i31
     /         - 2200.0d0*b37)
 
      g(14) = -(330.0d0*i2 + 360.0d0*i8 + 380.0d0*i14
     /         + 430.0d0*i20 + 490.0d0*i26 + 530.0d0*i32
     /         - 2200.0d0*b38)
 
      g(15) = -(330.0d0*i3 + 360.0d0*i9 + 380.0d0*i15
     /         + 430.0d0*i21 + 490.0d0*i27 + 530.0d0*i33
     /         - 2200.0d0*b39)
 
      g(16) = -(330.0d0*i4 + 360.0d0*i10 + 380.0d0*i16
     /         + 430.0d0*i22 + 490.0d0*i28 + 530.0d0*i34
     /         - 2200.0d0*b40)
 
      g(17) = -(330.0d0*i5 + 360.0d0*i11 + 380.0d0*i17
     /         + 430.0d0*i23 + 490.0d0*i29 + 530.0d0*i35
     /         - 2200.0d0*b41)         
 
      g(18) = -(330.0d0*i6 + 360.0d0*i12 + 380.0d0*i18
     /         + 430.0d0*i24 + 490.0d0*i30 + 530.0d0*i36
     /         - 2200.0d0*b42)
 
      g(19) = -(- i1 - i7 - i13 - i19 - i25 - i31 + b37)
 
      g(20) = -(- i2 - i8 - i14 - i20 - i26 - i32 + b38)
 
      g(21) = -(- i3 - i9 - i15 - i21 - i27 - i33 + b39)
 
      g(22) = -(- i4 - i10 - i16 - i22 - i28 - i34 + b40)

      g(23) = -(- i5 - i11 - i17 - i23 - i29 - i35 + b41)

      g(24) = -(- i6 - i12 - i18 - i24 - i30 - i36 + b42)

      g(25) = -(i1 + i7 + i13 + i19 + i25 + i31 - 5.0d0*b37)

      g(26) = -(i2 + i8 + i14 + i20 + i26 + i32 - 5.0d0*b38)

      g(27) = -(i3 + i9 + i15 + i21 + i27 + i33 - 5.0d0*b39)

      g(28) = -(i4 + i10 + i16 + i22 + i28 + i34 - 5.0d0*b40)

      g(29) = -(i5 + i11 + i17 + i23 + i29 + i35 - 5.0d0*b41)

      g(30) = -(i6 + i12 + i18 + i24 + i30 + i36 - 5.0d0*b42)

      g(31) = -b37 + i43

      g(32) = -b38 + i44

      g(33) = -b39 + i45

      g(34) = -b40 + i46  

      g(35) = -b41 + i47

      g(36) = -b42 + i48

      g(37) = -(- 15.0d0*b37 + i43)

      g(38) = -(- 12.0d0*b38 + i44)

      g(39) = -(- 8.0d0*b39 + i45)

      g(40) = -(- 7.0d0*b40 + i46)

      g(41) = -(- 4.0d0*b41 + i47)

      g(42) = -(- 2.0d0*b42 + i48)

      g(43) = i43 + i44 + i45 + i46 + i47 + i48 - 16.0d0

      g(44) = -(- b37 + b38)

      g(45) = -(- b38 + b39)

      g(46) = -(- b39 + b40)

      g(47) = -(- b40 + b41)

      g(48) = -(- b41 + b42)

      g(49) = -(- i43 + i44)

      g(50) = -(- i44 + i45)

      g(51) = -(- i45 + i46)

      g(52) = -(- i46 + i47)

      g(53) = -(- i47 + i48)

  999 continue
      return
      end

      subroutine ex3(  mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:06:38
*  
*  Equation counts
*     Total       E       G       L       N       X
*        32      18       2      12       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        33      25       8       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       100      95       5       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), b1, b2, b3, b4, b5, b6, b7, b8, x9, x10, x11,
     /        x12, x13, x14, x15, x16, x17, x18, x19, x20, x21, x22,
     /        x23, x24, x25, x26, x27, x28, x29, x30, x31, x32,
     /        e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12,
     /        e13, e14, e15, e16, e17, e18, e19, e20, e21, e22,
     /        e23, e24, e25, e26, e27, e28, e29, e30, e31
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX3'
         pref  = '\cite{MINLPLib}'
         fex   = 68.01d0
         ncont = 24
         nint  = 0
         nbin  = 8
         n     = ncont + nbin + nint
         m     = 31
         me    = 17
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xu(2)  = 2.0d0   
         xu(4)  = 2.0d0   
         xu(8)  = 2.0d0   
         xu(9)  = 1.0d0   
         xu(13) = 1.0d0   
         xu(16) = 2.0d0   
         xu(17) = 2.0d0   
         xu(18) = 2.0d0   
         xu(19) = 2.0d0   
         xu(20) = 2.0d0   
         xu(21) = 2.0d0   
         xu(24) = 2.0d0   
         x(1) = 2.0d0     
         x(2) = 1.5d0  
         x(5) = 0.75d0 
         x(6) = 0.5d0  
         x(7) = 0.5d0  
         x(8) = 0.75d0 
         x(10) = 1.5d0  
         x(11) = 1.34d0 
         x(12) = 2.0d0    
         x(17) = 0.75d0 
         x(19) = 1.5d0  
         x(22) = 1.7d0 
         x(23) = 1.5d0 
         x(24) = 0.5d0     
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      b1  = y(1)
      b2  = y(2)
      b3  = y(3)
      b4  = y(4)
      b5  = y(5)
      b6  = y(6)
      b7  = y(7)
      b8  = y(8)
      x9  = x(1)
      x10 = x(2)
      x11 = x(3)
      x12 = x(4)
      x13 = x(5)
      x14 = x(6)
      x15 = x(7)
      x16 = x(8)
      x17 = x(9)
      x18 = x(10)
      x19 = x(11)
      x20 = x(12)
      x21 = x(13)
      x22 = x(14)
      x23 = x(15)
      x24 = x(16)
      x25 = x(17)
      x26 = x(18)
      x27 = x(19)
      x28 = x(20)
      x29 = x(21)
      x30 = x(22)
      x31 = x(23)
      x32 = x(24)

      f = -(-8.0d0*b1 - 6.0d0*b2 - 10.0d0*b3 - 6.0d0*b4 - 7.0d0*b5 
     /      - 4.0d0*b6 - 5.0d0*b7 - 5.0d0*b8 - x9 + 10.0d0*x10 
     /      - x11 + 15.0d0*x12 + 40.0d0*x16 - 15.0d0*x17 - 15.0d0*x21 
     /      - 80.0d0*x24 + 65.0d0*x25 - 25.0d0*x26 + 60.0d0*x27 
     /      - 35.0d0*x28 + 80.0d0*x29 + 35.0d0*x32 - 122.0d0)

      e1 = dexp(x10) - x9 - 1.0d0

      e2 = dexp(0.833333333333333d0*x12) - x11 - 1.0d0

      e3 = -x15 + 1.5d0*x16 + x17                          

      e4 = 1.25d0*x19 - x20 + 1.25d0*x21                    

      e5 = x22 - 20.d0*x23                                  

      e6 = dexp(0.666666666666667d0*x27) - x26 - 1.0d0

      e7 = dexp(x29) - x28 - 1.0d0  
      
      e8 = dexp(x25) - x17 - x24 - 1.0d0 

      e9 = x20 - x26 - x28

      e10 = -x16 - x23 + x24 - x32                       

      e11 = x18 - x19 - x22                          

      e12 = x10 + x12 - x13 - x18

      e13 = x13 - x14 - x15                           

      e14 = -x27 - x29 + x30

      e15 = -x21 + x30 - x31                             

      e16 = x17 - 0.8d0*x24

      e17 = x17 - 0.4d0*x24

      e18 = x19 - 5.0d0*x21                            

      e19 = x19 - 2.0d0*x21

      e20 = -10.0d0*b8 + x9                                  

      e21 = -10.0d0*b1 + x11

      e22 = -10.0d0*b2 + x16                                 

      e23 = -10.0d0*b3 + x19 + x21

      e24 = -10.0d0*b4 + x22                            

      e25 = -10.0d0*b5 + x26                                 

      e26 = -10.0d0*b6 + x28                                 

      e27 = -10.0d0*b7 + x17 + x24

      e28 = b1 + b8 - 1.0d0                        

      e29 = b3 + b4 - 1.0d0                              

      e30 = -b3 + b5 + b6                                

      e31 = b2 - b7       

      g(1)  = e1
      g(2)  = e2
      g(3)  = e3
      g(4)  = e4
      g(5)  = e5
      g(6)  = e6
      g(7)  = e7
      g(8)  = e8
      g(9)  = e9
      g(10) = e10
      g(11) = e11
      g(12) = e12
      g(13) = e13
      g(14) = e14
      g(15) = e15
      g(16) = e28
      g(17) = e30
      g(18) = -e16
      g(19) = e17
      g(20) = -e18
      g(21) = e19
      g(22) = -e20
      g(23) = -e21
      g(24) = -e22
      g(25) = -e23
      g(26) = -e24
      g(27) = -e25
      g(28) = -e26
      g(29) = -e27
      g(30) = -e29
      g(31) = -e31
 
  999 continue
      return
      end
 

      subroutine ex4(  mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:06:44
*  
*  Equation counts
*     Total       E       G       L       N       X
*        31       1       2      28       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        37      12      25       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       237     110     127       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /     g(mmax), sqr, b1, b2, b3, b4, b5, b6, b7, b8, b9, b10,
     /     b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /     b21, b22, b23, b24, b25, x26, x27, x28, x29, x30,
     /     x32, x33, x34, x35, x36, x37,  e1,  e2,  e3,  e4,
     /      e5,  e6,  e7,  e8,  e9, e10, e11, e12, e13, e14,
     /     e15, e16, e17, e18, e19, e20, e21, e22, e23, e24,
     /     e25, e26, e27, e28, e29, e30
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'EX4'
         pref  = '\cite{MINLPLib}'
         fex   = -8.064136d0  
         ncont = 11
         nint  = 0
         nbin  = 25
         n     = ncont + nbin + nint
         m     = 30
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d4
            x(i)  = 0.0d0
            xu(i) = 1.0d4
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         xl(1) = 2.0d0  
         x(1)  = 3.0d0
         xu(1) = 4.5d0                                   
         xl(2) = 0.0d0
         xu(2) = 8.0d0                                                  
         xl(3) = 3.0d0  
         x(3)  = 8.0d0
         xu(3) = 9.0d0                                     
         xl(4) = 0.0d0
         x(4)  = 4.0d0
         xu(4) = 5.0d0                                                  
         xl(5) = 4.0d0  
         x(5)  = 4.5d0        
         xu(5) = 10.0d0              
         xl(6) = 0.0d0
         xl(7) = 0.0d0
         xl(8) = 0.0d0
         xl(9) = 0.0d0
         xl(10) = 0.0d0
         xl(11) = 0.0d0        
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)
      x26 = x(1)
      x27 = x(2)
      x28 = x(3)
      x29 = x(4)
      x30 = x(5)
      x32 = x(6)
      x33 = x(7)
      x34 = x(8)
      x35 = x(9)
      x36 = x(10)
      x37 = x(11)

      f = -((-0.6d0*sqr(x26)) - 0.1d0*sqr(x29) + b1 + 0.2d0*b2 + b3 
     /      + 0.2d0*b4 + 0.9d0*b5 + 0.9d0*b6 + 0.1d0*b7 + 0.8d0*b8 + b9 
     /      + 0.4d0*b10 + b11 + 0.3d0*b12 + 0.1d0*b13 + 0.3d0*b14 
     /      + 0.5d0*b15 + 0.9d0*b16 + 0.8d0*b17 + 0.1d0*b18 + 0.9d0*b19
     /      + b20 + b21 + b22 + 0.2d0*b23 + 0.7d0*b24 + 0.7d0*b25 
     /      + 0.9d0*x27 + 0.5d0*x28 - x30 - 1000.0d0*x32 - 1000.0d0*x33
     /      - 1000.0d0*x34 - 1000.0d0*x35 - 1000.0d0*x36 - 1000.0d0*x37)

      e1 = 9.57d0*sqr(x26 - 2.26d0) + 2.74d0*sqr(x27 - 5.15d0) 
     /     + 9.75d0*sqr(x28 - 4.03d0) + 3.96d0*sqr(x29 - 1.74d0) 
     /     + 8.67d0*sqr(x30 - 4.74d0) + 1000.0d0*b1 - x32 
     /     - 1077.839848d0

      e2 = 8.38d0*sqr(x26 - 5.51d0) + 3.93d0*sqr(x27 - 9.01d0) 
     /     + 5.18d0*sqr(x28 - 3.84d0) + 5.2d0*sqr(x29 - 1.47d0) 
     /     + 7.82d0*sqr(x30 - 9.92d0) + 1000.0d0*b2 - x32 
     /     - 1175.970966d0 

      e3 = 9.81d0*sqr(x26 - 4.06d0) + 0.04d0*sqr(x27 - 1.8d0) 
     /     + 4.21d0*sqr(x28 - 0.71) + 7.38d0*sqr(x29 - 9.09) 
     /     + 4.11d0*sqr(x30 - 8.13) + 1000.0d0*b3 - x32
     /     - 1201.822621d0

      e4 = 7.41d0*sqr(x26 - 6.3d0) + 6.08d0*sqr(x27 - 0.11d0) 
     /     + 5.46d0*sqr(x28 - 4.08d0) + 4.86d0*sqr(x29 - 7.29d0) 
     /     + 1.48d0*sqr(x30 - 4.24d0) + 1000.0d0*b4 - x32 
     /     - 1143.953331d0

      e5 = 9.96d0*sqr(x26 - 2.81d0) + 9.13d0*sqr(x27 - 1.65d0) 
     /     + 2.95d0*sqr(x28 - 8.08d0) + 8.25d0*sqr(x29 - 3.99d0) 
     /     + 3.58d0*sqr(x30 - 3.51d0) + 1000.0d0*b5 - x32 
     /     - 1154.389533d0                         

      e6 = 9.39d0*sqr(x26 - 4.29d0) + 4.27d0*sqr(x27 - 9.49d0) 
     /     + 5.09d0*sqr(x28 - 2.24d0) + 1.81d0*sqr(x29 - 9.78d0) 
     /     + 7.58d0*sqr(x30 - 1.52d0) + 1000.0d0*b6 - x32 
     /     - 1433.317653d0                         

      e7 = 1.88d0*sqr(x26 - 9.76d0) + 7.2d0*sqr(x27 - 3.64d0) 
     /     + 6.65d0*sqr(x28 - 6.62d0) + 1.74d0*sqr(x29 - 3.66d0) 
     /     + 2.86d0*sqr(x30 - 9.08d0) + 1000.0d0*b7 - x32 
     /     - 1109.07636d0 

      e8 = 4.01d0*sqr(x26 - 1.37d0) + 2.67d0*sqr(x27 - 6.99d0) 
     /     + 4.86d0*sqr(x28 - 7.19d0) + 2.55d0*sqr(x29 - 3.03d0) 
     /     + 6.91d0*sqr(x30 - 3.39d0) + 1000.0d0*b8 - x32 
     /     - 1041.595916d0                         

      e9 = 4.18d0*sqr(x26 - 8.89d0) + 1.92d0*sqr(x27 - 8.29d0) 
     /     + 2.6d0*sqr(x28 - 6.05d0) + 7.15d0*sqr(x29 - 7.48d0) 
     /     + 2.86d0*sqr(x30 - 4.09d0) + 1000.0d0*b9 - x32 
     /     - 1144.062266d0                         

      e10 = 7.81d0*sqr(x26 - 7.42d0) + 2.14d0*sqr(x27 - 4.6d0) 
     /     + 9.63d0*sqr(x28 - 0.3d0) + 7.61d0*sqr(x29 - 0.97d0) 
     /     + 9.17d0*sqr(x30 - 8.77d0) + 1000.0d0*b10 - x32 
     /     - 1099.834164d0

      e11 = 8.96d0*sqr(x26 - 1.54d0) + 3.47d0*sqr(x27 - 7.06d0) 
     /      + 5.49d0*sqr(x28 - 0.01d0) + 4.73*sqr(x29 - 1.23d0) 
     /      + 9.43d0*sqr(x30 - 3.11d0) + 1000.0d0*b11 - x32 
     /      - 1149.179125d0                      

      e12 = 9.94d0*sqr(x26 - 7.74d0) + 1.63d0*sqr(x27 - 4.4d0) 
     /      + 1.23d0*sqr(x28 - 7.93d0) + 4.33d0*sqr(x29 - 5.95d0) 
     /      + 7.08d0*sqr(x30 - 4.88d0) + 1000.0d0*b12 - x32 
     /      - 1123.807402d0                       

      e13 = 0.31d0*sqr(x26 - 9.94d0) + 5.0d0*sqr(x27 - 5.21d0) 
     /      + 0.16d0*sqr(x28 - 8.58d0) + 2.52d0*sqr(x29 - 0.13d0) 
     /      + 3.08d0*sqr(x30 - 4.57) + 1000.0d0*b13 - x32 
     /      - 1027.221972d0  

      e14 = 6.02d0*sqr(x26 - 9.54d0) + 0.92d0*sqr(x27 - 1.57d0) 
     /      + 7.47d0*sqr(x28 - 9.66d0) + 9.74d0*sqr(x29 - 5.24d0) 
     /      + 1.76d0*sqr(x30 - 7.9d0) + 1000.0d0*b14 - x32 
     /      - 1089.926827d0                       

      e15 = 5.06d0*sqr(x26 - 7.46d0) + 4.52d0*sqr(x27 - 8.81d0) 
     /      + 1.89d0*sqr(x28 - 1.67d0) + 1.22d0*sqr(x29 - 6.47d0) 
     /      + 9.05d0*sqr(x30 - 1.81d0) + 1000.0d0*b15 - x32 
     /      - 1293.076557d0                      

      e16 = 5.92d0*sqr(x26 - 0.56d0) + 2.56d0*sqr(x27 - 8.1d0) 
     /      + 7.74d0*sqr(x28 - 0.19d0) + 6.96d0*sqr(x29 - 6.11d0) 
     /      + 5.18d0*sqr(x30 - 6.4d0) + 1000.0d0*b16 - x32 
     /      - 1174.31702d0                         

      e17 = 6.45d0*sqr(x26 - 3.86) + 1.52d0*sqr(x27 - 6.68d0) 
     /      + 0.06d0*sqr(x28 - 6.42d0) + 5.34d0*sqr(x29 - 7.29d0) 
     /      + 8.47d0*sqr(x30 - 4.66d0) + 1000.0d0*b17 - x32 
     /      - 1125.102783d0                      

      e18 = 1.04d0*sqr(x26 - 2.98d0) + 1.36d0*sqr(x27 - 2.98d0) 
     /      + 5.99d0*sqr(x28 - 3.03d0) + 8.1d0*sqr(x29 - 0.02d0) 
     /      + 5.22d0*sqr(x30 - 0.67) + 1000.0d0*b18 - x32 
     /      - 1222.841697d0                       

      e19 = 1.4d0*sqr(x26 - 3.61d0) + 1.35d0*sqr(x27 - 7.62d0) 
     /      + 0.59d0*sqr(x28 - 1.79d0) + 8.58d0*sqr(x29 - 7.8d0) 
     /      + 1.21d0*sqr(x30 - 9.81d0) + 1000.0d0*b19 - x32
     /       - 1050.485931d0                        

      e20 = 6.68d0*sqr(x26 - 5.68d0) + 9.48d0*sqr(x27 - 4.24d0) 
     /      + 1.6d0*sqr(x28 - 4.17d0) + 6.74d0*sqr(x29 - 6.75d0) 
     /      + 8.92d0*sqr(x30 - 1.08d0) + 1000.0d0*b20 - x32 
     /      - 1361.197344d0                       

      e21 = 1.95d0*sqr(x26 - 5.48d0) + 0.46d0*sqr(x27 - 3.74d0) 
     /      + 2.9d0*sqr(x28 - 3.34d0) + 1.79d0*sqr(x29 - 6.22d0) 
     /      + 0.99d0*sqr(x30 - 7.94d0) + 1000.0d0*b21 - x32 
     /      - 1040.326419d0                       

      e22 = 5.18d0*sqr(x26 - 8.13d0) + 5.1d0*sqr(x27 - 8.72d0) 
     /      + 8.81d0*sqr(x28 - 3.93d0) + 3.27d0*sqr(x29 - 8.8d0) 
     /      + 9.63d0*sqr(x30 - 8.56d0) + 1000.0d0*b22 - x32
     /      - 1161.851799d0                        

      e23 = 1.47d0*sqr(x26 - 1.37d0) + 5.71d0*sqr(x27 - 0.54d0) 
     /      + 6.95d0*sqr(x28 - 1.55d0) + 1.42d0*sqr(x29 - 5.56d0) 
     /      + 3.49d0*sqr(x30 - 5.85d0) + 1000.0d0*b23 - x32 
     /      - 1066.858266d0                      

      e24 = 5.4d0*sqr(x26 - 8.79d0) + 3.12d0*sqr(x27 - 5.04d0) 
     /      + 5.37d0*sqr(x28 - 4.83d0) + 6.1d0*sqr(x29 - 6.94d0) 
     /      + 3.71d0*sqr(x30 - 0.38d0) + 1000.0d0*b24 - x32 
     /      - 1340.580732d0                       

      e25 = 6.32d0*sqr(x26 - 2.66d0) + 0.81d0*sqr(x27 - 4.19d0) 
     /      + 6.12d0*sqr(x28 - 6.49d0) + 6.73d0*sqr(x29 - 8.04d0) 
     /      + 7.93d0*sqr(x30 - 1.66d0) + 1000.0d0*b25 - x32 
     /      - 1407.519966d0                      

      e26 = x26 - x27 + x28 + x29 + x30 - x33 - 10.0d0

      e27 = 0.6d0*x26 - 0.9d0*x27 - 0.5d0*x28 + 0.1d0*x29 + x30 
     /      - x34 + 0.64d0                                

      e28 = x26 - x27 + x28 - x29 + x30 + x35 - 0.69d0     

      e29 = 0.157d0*x26 + 0.05d0*x27 - x36 - 1.5d0      

      e30 = 0.25d0*x27 + 1.05d0*x29 - 0.3d0*x30 - x37 - 4.5d0 

      g(1) = -e1
      g(2) = -e2
      g(3) = -e3
      g(4) = -e4
      g(5) = -e5
      g(6) = -e6
      g(7) = -e7
      g(8) = -e8
      g(9) = -e9
      g(10) = -e10
      g(11) = -e11
      g(12) = -e12
      g(13) = -e13
      g(14) = -e14
      g(15) = -e15
      g(16) = -e16
      g(17) = -e17
      g(18) = -e18
      g(19) = -e19
      g(20) = -e20
      g(21) = -e21
      g(22) = -e22
      g(23) = -e23
      g(24) = -e24
      g(25) = -e25
      g(26) = -e26
      g(27) = -e27
      g(28) = e28
      g(29) = -e29
      g(30) = e30

  999 continue
      return
      end
 

      subroutine fac1(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:39
*  
*  Equation counts
*     Total       E       G       L       N       X
*        19      11       2       6       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        23      17       6       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        75      59      16       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, b17, b18, b19, b20,
     /        b21, b22,
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9,  e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FAC1'
         pref  = '\cite{MINLPLib}'
         fex   =  160912600.0d0
         ncont = 16
         nint  = 0
         nbin  = 6
         n     = ncont + nbin + nint
         m     = 18
         me    = 10
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 3.0d3
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      b17 = y(1)
      b18 = y(2)
      b19 = y(3)
      b20 = y(4)
      b21 = y(5)
      b22 = y(6)

      f = 50.0d0*DMAX1(x1 + x2 + x3 + x4 + x9 + x10 + x11 + x12,
     /                                               1.0D-4)**2.5d0
     /    + 70.0d0*DMAX1(x5 + x6 + x7 + x8 + x13 + x14 + x15 + x16, 
     /                                               1.0D-4)**2.5d0 
     /    + 10.0d0*x1 + 15.0d0*x2 + 20.0d0*x3 + 10.0d0*x4 + 5.0d0*x5  
     /    + 5.0d0*x6 + 30.0d0*x7 + 10.0d0*x8 + 25.0d0*x9 + 20.0d0*x10 
     /    + 15.0d0*x11 + 20.0d0*x12 + 30.0d0*x13 + 10.0d0*x14 
     /    + 10.0d0*x15 + 30.0d0*x16 + 2000.0d0*b21 + 2500.0d0*b22

      e2 = x1 + x3 + x5 + x7 - 100.0d0     

      e3 = x2 + x4 + x6 + x8 - 200.0d0     

      e4 = x9 + x11 + x13 + x15 - 150.0d0  

      e5 = x10 + x12 + x14 + x16 - 120.0d0 

      e6 = x1 + x9 - 120.0d0*b17             

      e7 = x2 + x10 - 140.0d0*b17            

      e8 = x3 + x11 - 130.0d0*b18            

      e9 = x4 + x12 - 180.0d0*b18            

      e10 = x5 + x13 - 120.0d0*b19           

      e11 = x6 + x14 - 140.0d0*b19           

      e12 = x7 + x15 - 130.0d0*b20           

      e13 = x8 + x16 - 180.0d0*b20           

      e14 = 260.0d0*b17 + 310.0d0*b18 - 2500.0d0*b21 

      e15 = 260.0d0*b19 + 310.0d0*b20 - 3200.0d0*b22 

      e16 = 260.0d0*b17 + 310.0d0*b18 - 50.0d0*b21   

      e17 = 260.0d0*b19 + 310.0d0*b20 - 50.0d0*b22   

      e18 = b17 + b19 - 1.0d0             

      e19 = b18 + b20 - 1.0d0 

      g(1) = e6
      g(2) = e7
      g(3) = e8
      g(4) = e9
      g(5) = e10
      g(6) = e11
      g(7) = e12
      g(8) = e13
      g(9) = e18
      g(10) = e19
      g(11) = -e2
      g(12) = -e3
      g(13) = -e4
      g(14) = -e5
      g(15) = -e14
      g(16) = -e15
      g(17) = e16
      g(18) = e17

  999 continue
      return
      end
 

      subroutine fac2(  mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:45
*  
*  Equation counts
*     Total       E       G       L       N       X
*        34      22       3       9       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        67      55      12       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       217     163      54       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), eps, 
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19,x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FAC2'
         pref  = '\cite{MINLPLib}'
         fex   = 331837500.0d0
         ncont = 54
         nint  = 0
         nbin  = 12
         n     = ncont + nbin + nint
         m     = 33
         me    = 21
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d3
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      end if
      
      do i=1,nbin
         y(i) = x(ncont+i)
      end do     
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      b55 = y(1)
      b56 = y(2)
      b57 = y(3)
      b58 = y(4)
      b59 = y(5)
      b60 = y(6)
      b61 = y(7)
      b62 = y(8)
      b63 = y(9)
      b64 = y(10)
      b65 = y(11)
      b66 = y(12)          
      
      eps = 1.0d-8

      f = 276.28d0*DMAX1(x1 + x2 + x3 + x4 + x5 + x6 + x19 + x20 + x21 
     /     + x22 + x23 + x24 + x37 + x38 + x39 + x40 + x41 + x42,
     /           eps)**2.5d0 + 792.912d0*DMAX1(x7 + x8 + x9 + x10 
     /     + x11 + x12 + x25 + x26 + x27 + x28 + x29 + x30 + x43 + x44 
     /     + x45 + x46 + x47 + x48,eps)**2.5d0
     /     + 991.679d0*DMAX1(x13 + x14 + x15 + x16 + x17 + x18 + x31 
     /     + x32 + x33 + x34 + x35 + x36 + x49 + x50 + x51 + x52 + x53 
     /     + x54,eps)**2.5d0 + 115.274d0*x1 + 98.5559d0*x2 
     /     + 142.777d0*x3 + 33.9886d0*x4 + 163.087d0*x5 + 10.4376d0*x6 
     /     + 234.406d0*x7 + 142.066d0*x8 + 50.6436d0*x9 + 123.61d0*x10 
     /     + 242.356d0*x11 + 135.071d0*x12 + 10.7347d0*x13 
     /     + 56.0272d0*x14 + 14.912d0*x15 + 169.218d0*x16 
     /     + 209.028d0*x17 + 259.29d0*x18 + 165.41d0*x19 + 40.7497d0*x20
     /     + 124.907d0*x21 + 18.495d0*x22 + 95.2789d0*x23 
     /     + 251.899d0*x24 + 114.185d0*x25 + 37.8148d0*x26 
     /     + 10.5547d0*x27 + 52.5162d0*x28 
      f = f
     /     + 37.4727d0*x29 + 254.843d0*x30 + 266.645d0*x31 
     /     + 136.583d0*x32 + 15.092d0*x33 + 194.101d0*x34 + 78.768d0*x35
     /     + 120.36d0*x36 + 257.318d0*x37 + 172.747d0*x38 
     /     + 142.813d0*x39 + 251.331d0*x40 + 15.9113d0*x41 
     /     + 48.8251d0*x42 + 289.116d0*x43 + 129.705d0*x44 
     /     + 275.621d0*x45 + 20.2235d0*x46 + 253.789d0*x47 
     /     + 56.7474d0*x48 + 201.646d0*x49 + 164.573d0*x50 
     /     + 295.157d0*x51 + 151.474d0*x52 + 221.794d0*x53 
     /     + 278.304d0*x54 + 2481400.0d0*b64 + 2156460.0d0*b65 
     /     + 2097730.0d0*b66

      e2 = x1 + x3 + x5 + x7 + x9 + x11 + x13 + x15 + x17 - 60.0d0
      
      e3 = x2 + x4 + x6 + x8 + x10 + x12 + x14 + x16 + x18 - 60.0d0    

      e4 = x19 + x21 + x23 + x25 + x27 + x29 + x31 + x33 + x35 - 60.0d0

      e5 = x20 + x22 + x24 + x26 + x28 + x30 + x32 + x34 + x36 - 60.0d0

      e6 = x37 + x39 + x41 + x43 + x45 + x47 + x49 + x51 + x53 - 60.0d0

      e7 = x38 + x40 + x42 + x44 + x46 + x48 + x50 + x52 + x54 - 60.0d0

      e8 = x1 + x19 + x37 - 60.0d0*b55                  

      e9 = x2 + x20 + x38 - 60.0d0*b55                  

      e10 = x3 + x21 + x39 - 60.0d0*b56                 

      e11 = x4 + x22 + x40 - 60.0d0*b56                 

      e12 = x5 + x23 + x41 - 60.0d0*b57                 

      e13 = x6 + x24 + x42 - 60.0d0*b57                 

      e14 = x7 + x25 + x43 - 60.0d0*b58                 

      e15 = x8 + x26 + x44 - 60.0d0*b58                 

      e16 = x9 + x27 + x45 - 60.0d0*b59                 

      e17 = x10 + x28 + x46 - 60.0d0*b59                

      e18 = x11 + x29 + x47 - 60.0d0*b60                

      e19 = x12 + x30 + x48 - 60.0d0*b60                

      e20 = x13 + x31 + x49 - 60.0d0*b61                

      e21 = x14 + x32 + x50 - 60.0d0*b61                

      e22 = x15 + x33 + x51 - 60.0d0*b62                

      e23 = x16 + x34 + x52 - 60.0d0*b62                

      e24 = x17 + x35 + x53 - 60.0d0*b63                

      e25 = x18 + x36 + x54 - 60.0d0*b63                

      e26 = 120.0d0*b55 + 120.0d0*b56 + 120.0d0*b57 - 2749.5d0*b64

      e27 = 120.0d0*b58 + 120.0d0*b59 + 120.0d0*b60 - 2872.94d0*b65

      e28 = 120.0d0*b61 + 120.0d0*b62 + 120.0d0*b63 - 2508.06d0*b66

      e29 = 120.0d0*b55 + 120.0d0*b56 + 120.0d0*b57 - 50.0d0*b64    

      e30 = 120.0d0*b58 + 120.0d0*b59 + 120.0d0*b60 - 50.0d0*b65    

      e31 = 120.0d0*b61 + 120.0d0*b62 + 120.0d0*b63 - 50.0d0*b66    

      e32 = b55 + b58 + b61 - 1.0d0                   

      e33 = b56 + b59 + b62 - 1.0d0                   

      e34 = b57 + b60 + b63 - 1.0d0 

      g(1) = e8
      g(2) = e9
      g(3) = e10
      g(4) = e11
      g(5) = e12
      g(6) = e13
      g(7) = e14
      g(8) = e15
      g(9) = e16
      g(10) = e17
      g(11) = e18
      g(12) = e19
      g(13) = e20
      g(14) = e21
      g(15) = e22
      g(16) = e23
      g(17) = e24
      g(18) = e25
      g(19) = e32
      g(20) = e33
      g(21) = e34     
      g(22) = -e2
      g(23) = -e3
      g(24) = -e4
      g(25) = -e5
      g(26) = -e6
      g(27) = -e7
      g(28) = -e26
      g(29) = -e27
      g(30) = -e28
      g(31) = e29      
      g(32) = e30
      g(33) = e31
           
  999 continue
      return
      end
 

      subroutine fac3(  mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:47
*  
*  Equation counts
*     Total       E       G       L       N       X
*        34      22       3       9       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        67      55      12       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       217     163      54       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr,
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19,x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FAC3'
         pref  = '\cite{MINLPLib}'
         fex   = 31982310.0d0    
         ncont = 54
         nint  = 0
         nbin  = 12
         n     = ncont + nbin + nint
         m     = 33
         me    = 21
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d3
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      b55 = y(1)
      b56 = y(2)
      b57 = y(3)
      b58 = y(4)
      b59 = y(5)
      b60 = y(6)
      b61 = y(7)
      b62 = y(8)
      b63 = y(9)
      b64 = y(10)
      b65 = y(11)
      b66 = y(12)

      f = 276.28d0*sqr(x1 + x2 + x3 + x4 + x5 + x6 + x19 + x20 
     /     + x21 + x22 + x23 + x24 + x37 + x38 + x39 + x40 + x41 + x42)
     /     + 792.912d0*sqr(x7 + x8 + x9 + x10 + x11 + x12 + x25 + x26 
     /     + x27 + x28 + x29 + x30 + x43 + x44 + x45 + x46 + x47 + x48)
     /     + 991.679d0*sqr(x13 + x14 + x15 + x16 + x17 + x18 + x31 
     /     + x32 + x33 + x34 + x35 + x36 + x49 + x50 + x51 + x52 + x53 
     /     + x54) + 115.274d0*x1 + 98.5559d0*x2 + 142.777d0*x3 
     /     + 33.9886d0*x4 + 163.087d0*x5 + 10.4376d0*x6 + 234.406d0*x7 
     /     + 142.066d0*x8 + 50.6436d0*x9 + 123.61d0*x10 + 242.356d0*x11
     /     + 135.071d0*x12 + 10.7347d0*x13 + 56.0272d0*x14 
     /     + 14.912d0*x15 + 169.218d0*x16 + 209.028d0*x17 + 259.29d0*x18
     /     + 165.41d0*x19 + 40.7497d0*x20 + 124.907d0*x21 + 18.495d0*x22
      f = f
     /     + 95.2789d0*x23 + 251.899d0*x24 + 114.185d0*x25 
     /     + 37.8148d0*x26 + 10.5547d0*x27 + 52.5162d0*x28 
     /     + 37.4727d0*x29 + 254.843d0*x30 + 266.645d0*x31 
     /     + 136.583d0*x32 + 15.092*x33 + 194.101d0*x34 + 78.768d0*x35 
     /     + 120.36d0*x36 + 257.318d0*x37 + 172.747d0*x38 
     /     + 142.813d0*x39 + 251.331d0*x40 + 15.9113d0*x41 
     /     + 48.8251d0*x42 + 289.116d0*x43 + 129.705d0*x44 
     /     + 275.621d0*x45 + 20.2235d0*x46 + 253.789d0*x47 
     /     + 56.7474d0*x48 + 201.646d0*x49 + 164.573d0*x50 
     /     + 295.157d0*x51 + 151.474d0*x52 + 221.794d0*x53 
     /     + 278.304d0*x54 + 2481400.0d0*b64 + 2156460.0d0*b65 
     /     + 2097730.0d0*b66

      e2 = x1 + x3 + x5 + x7 + x9 + x11 + x13 + x15 + x17 - 60.0d0      

      e3 = x2 + x4 + x6 + x8 + x10 + x12 + x14 + x16 + x18 - 60.0d0  

      e4 = x19 + x21 + x23 + x25 + x27 + x29 + x31 + x33 + x35 - 60.0d0 

      e5 = x20 + x22 + x24 + x26 + x28 + x30 + x32 + x34 + x36 - 60.0d0 

      e6 = x37 + x39 + x41 + x43 + x45 + x47 + x49 + x51 + x53 - 60.0d0

      e7 = x38 + x40 + x42 + x44 + x46 + x48 + x50 + x52 + x54 - 60.0d0

      e8 = x1 + x19 + x37 - 60.0d0*b55         

      e9 = x2 + x20 + x38 - 60.0d0*b55         

      e10 = x3 + x21 + x39 - 60.0d0*b56        

      e11 = x4 + x22 + x40 - 60.0d0*b56        

      e12 = x5 + x23 + x41 - 60.0d0*b57        

      e13 = x6 + x24 + x42 - 60.0d0*b57        

      e14 = x7 + x25 + x43 - 60.0d0*b58        

      e15 = x8 + x26 + x44 - 60.0d0*b58        

      e16 = x9 + x27 + x45 - 60.0d0*b59        

      e17 = x10 + x28 + x46 - 60.0d0*b59       

      e18 = x11 + x29 + x47 - 60.0d0*b60       

      e19 = x12 + x30 + x48 - 60.0d0*b60       

      e20 = x13 + x31 + x49 - 60.0d0*b61       

      e21 = x14 + x32 + x50 - 60.0d0*b61       

      e22 = x15 + x33 + x51 - 60.0d0*b62       

      e23 = x16 + x34 + x52 - 60.0d0*b62       

      e24 = x17 + x35 + x53 - 60.0d0*b63       

      e25 = x18 + x36 + x54 - 60.0d0*b63       

      e26 = 120.0d0*b55 + 120.0d0*b56 + 120.0d0*b57 - 2749.5d0*b64   

      e27 = 120.0d0*b58 + 120.0d0*b59 + 120.0d0*b60 - 2872.94d0*b65  

      e28 = 120.0d0*b61 + 120.0d0*b62 + 120.0d0*b63 - 2508.06d0*b66   

      e29 = 120.0d0*b55 + 120.0d0*b56 + 120.0d0*b57 - 50.0d0*b64       

      e30 = 120.0d0*b58 + 120.0d0*b59 + 120.0d0*b60 - 50.0d0*b65 

      e31 = 120.0d0*b61 + 120.0d0*b62 + 120.0d0*b63 - 50.0d0*b66   

      e32 = b55 + b58 + b61 - 1.0d0          

      e33 = b56 + b59 + b62 - 1.0d0          

      e34 = b57 + b60 + b63 - 1.0d0                   

      g(1) = e8
      g(2) = e9
      g(3) = e10
      g(4) = e11
      g(5) = e12
      g(6) = e13
      g(7) = e14
      g(8) = e15
      g(9) = e16
      g(10) = e17
      g(11) = e18
      g(12) = e19
      g(13) = e20
      g(14) = e21
      g(15) = e22
      g(16) = e23
      g(17) = e24
      g(18) = e25
      g(19) = e32
      g(20) = e33
      g(21) = e34
      g(22) = -e2
      g(23) = -e3
      g(24) = -e4
      g(25) = -e5
      g(26) = -e6
      g(27) = -e7
      g(28) = -e26
      g(29) = -e27
      g(30) = -e28
      g(31) = e29
      g(32) = e30
      g(33) = e31
      
  999 continue
      return
      end
 

      subroutine feedtray(  mode,     m,     me,  mmax, ncont,  
     /                      nbin,  nint,   nmax,     x,    xl,
     /                        xu,     f,      g,  pnam,  pref,
     /                       fex )    

*  MINLP written by GAMS Convert at 05/14/01 17:28:54
*  
*  Equation counts
*     Total       E       G       L       N       X
*        92      84       1       7       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        98      91       7       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       451     169     282       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr,
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /        b91, b92, b93, b94, b95, b96, b97
      double precision
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FEEDTRAY'
         pref  = '\cite{MINLPLib}'
         fex   = -13.4059977245d0
         ncont = 90
         nint  = 0
         nbin  = 7
         n     = ncont + nbin + nint
         m     = 91
         me    = 83
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d6
         enddo
         do i = 54,62
            xl(i) = -1.0d6
         enddo
         do i = 70,81
            xl(i) = -1.0d6
         enddo
         do i = 1,36
            xu(i) = 1.0d0
         enddo
         x(1) = 0.4d0  
         x(2) = 0.6d0  
         x(3) = 0.4625d0     
         x(4) = 0.5375d0     
         x(5) = 0.525d0
         x(6) = 0.475d0
         x(7) = 0.5875d0     
         x(8) = 0.4125d0     
         x(9) = 0.65d0 
         x(10) = 0.35d0
         x(11) = 0.7125d0    
         x(12) = 0.2875d0    
         x(13) = 0.775d0     
         x(14) = 0.225d0     
         x(15) = 0.8375d0    
         x(16) = 0.1625d0   
         x(17) = 0.9d0 
         x(18) = 0.1d0 
         x(19) = 0.2d0 
         x(20) = 0.8d0 
         x(21) = 0.3d0 
         x(22) = 0.7d0 
         x(23) = 0.4d0 
         x(24) = 0.6d0 
         x(25) = 0.5d0 
         x(26) = 0.5d0 
         x(27) = 0.6d0 
         x(28) = 0.4d0 
         x(29) = 0.7d0 
         x(30) = 0.3d0 
         x(31) = 0.8d0 
         x(32) = 0.2d0 
         x(33) = 0.9d0 
         x(34) = 0.1d0 
         x(35) = 1.0d0   
         x(37) = 40.0d0  
         x(38) = 127.0d0 
         x(39) = 127.0d0 
         x(40) = 127.0d0 
         x(41) = 127.0d0 
         x(42) = 127.0d0 
         x(43) = 27.0d0  
         x(44) = 27.0d0  
         x(45) = 27.0d0  
         x(46) = 87.0d0  
         x(47) = 87.0d0  
         x(48) = 87.0d0  
         x(49) = 87.0d0  
         x(50) = 87.0d0  
         x(51) = 87.0d0  
         x(52) = 87.0d0  
         x(53) = 87.0d0  
         do i = 54,62
            xl(i) = 345.0d0
            xu(i) = 390.0d0
         enddo
         x(54) = 380.0d0 
         x(55) = 375.0d0 
         x(56) = 372.5d0     
         x(57) = 370.0d0 
         x(58) = 367.5d0     
         x(59) = 365.0d0 
         x(60) = 362.5d0     
         x(61) = 360.0d0 
         x(62) = 355.0d0 
         do i = 63,69
            x(i)  = 14.2857142857143d0
            xu(i) = 100.0d0
         enddo
         xl(70) = 0.1d0  
         x(70)  = 0.45d0
         xu(70) = 0.95d0            
         xl(71) = 50d0
         x(71)  = 60.0d0
         xu(71) = 80d0               
         xl(72) = 20d0
         x(72)  = 40.0d0
         xu(72) = 50d0               
         do i = 73,81
            xl(i) = -1.5d0
            xu(i) = -0.496714536653818d0
         enddo
         x(73) = -0.954871459437791             
         x(74) = -0.972170917937763             
         x(75) = -0.977321724319633             
         x(76) = -0.982151492959225             
         x(77) = -0.986662793667597             
         x(78) = -0.990858232660528             
         x(79) = -0.994740453837617             
         x(80) = -0.998312139997537             
         x(81) = -1.01209290612999              
         do i = 82,90
            xu(i) = 0.151822697193183d0 
         enddo
         x(82) = 0.0971285302367615             
         x(83) = 0.0755763285867959             
         x(84) = 0.0644929360644884             
         x(85) = 0.0538822972811403             
         x(86) = 0.0437417989462674             
         x(87) = 0.0340688284351046             
         x(88) = 0.0248607738701702             
         x(89) = 0.0161150242028288      
         x(90) = 0.01d0       
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      x73 = x(73)
      x74 = x(74)
      x75 = x(75)
      x76 = x(76)
      x77 = x(77)
      x78 = x(78)
      x79 = x(79)
      x80 = x(80)
      x81 = x(81)
      x82 = x(82)
      x83 = x(83)
      x84 = x(84)
      x85 = x(85)
      x86 = x(86)
      x87 = x(87)
      x88 = x(88)
      x89 = x(89)
      x90 = x(90)
      b91 = y(1)
      b92 = y(2)
      b93 = y(3)
      b94 = y(4)
      b95 = y(5)
      b96 = y(6)
      b97 = y(7)

      f =  50.0d0*x70 - x71

      e1 = -48.9d0*x1*dexp((562.2d0*(1.33213d0*(1.0d0 
     /     - 0.00177872643187478d0*x54)**1.5d0 
     /     + 0.012420366417645d0*x54 
     /     - 2.62863d0*(1.0d0 - 0.00177872643187478*x54)**3 
     /     - 3.33399d0*(1.0d0 - 0.00177872643187478*x54)**6) 
     /     - 3925.690806)/x54) + 1.2d0*x19              

      e2 = - 41d0*x2*dexp((591.8d0*(1.38091d0*(1.0d0 
     /     - 0.00168976005407232d0*x54)**1.5d0 
     /     + 0.0123117100371747d0*x54
     /     - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x54)**3 
     /     - 2.79168*(1.0d0 - 0.00168976005407232d0*x54)**6) 
     /     - 4311.896226d0)/x54) + 1.2d0*x20 

      e3 = - 48.9d0*x3*dexp((562.2d0*(1.33213d0*(1.0d0 
     /     - 0.00177872643187478d0*x55)**1.5d0 
     /     + 0.012420366417645d0*x55 
     /     - 2.62863d0*(1.0d0 - 0.00177872643187478*x55)**3 
     /     - 3.33399d0*(1.0d0 - 0.00177872643187478*x55)**6) 
     /     - 3925.690806d0)/x55) + 1.12d0*x21         

      e4 = - 41.0d0*x4*dexp((591.8d0*(1.38091d0*(1.0d0 
     /     - 0.00168976005407232d0*x55)**1.5d0 
     /     + 0.0123117100371747d0*x55
     /     - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x55)**3 
     /     - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x55)**6) 
     /     - 4311.896226d0)/x55) + 1.12d0*x22  

      e5 = -48.9d0*x5*dexp((562.2d0*(1.33213d0*(1.0d0 
     /     - 0.00177872643187478d0*x56)**1.5d0 
     /     + 0.012420366417645d0*x56 
     /     - 2.62863d0*(1.0d0 - 0.00177872643187478*x56)**3 
     /     - 3.33399d0*(1.0d0 - 0.00177872643187478*x56)**6) 
     /     - 3925.690806d0)/x56) + 1.11333333333333d0*x23   

      e6 = -41.0d0*x6*dexp((591.8d0*(1.38091d0*(1.0d0 
     /     - 0.00168976005407232d0*x56)**1.5d0 
     /     + 0.0123117100371747d0*x56
     /     - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x56)**3 
     /     - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x56)**6) 
     /     - 4311.896226d0)/x56)+ 1.11333333333333d0*x24   

      e7 = -48.9d0*x7*dexp((562.2d0*(1.33213d0*(1.0d0 
     /     - 0.00177872643187478*x57)**1.5d0 + 0.012420366417645d0*x57 
     /     - 2.62863d0*(1.0d0 - 0.00177872643187478*x57)**3 
     /     - 3.33399d0*(1.0d0 - 0.00177872643187478*x57)**6) 
     /     - 3925.690806d0)/x57) + 1.10666666666667d0*x25   

      e8 = -41.0d0*x8*dexp((591.8d0*(1.38091d0*(1.0d0 
     /     - 0.00168976005407232d0*x57)**1.5d0 
     /     + 0.0123117100371747d0*x57 
     /     - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x57)**3 
     /     - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x57)**6) 
     /     - 4311.896226d0)/x57) + 1.10666666666667d0*x26   

      e9 = -48.9d0*x9*dexp((562.2d0*(1.33213d0*(1.0d0 
     /     - 0.00177872643187478d0*x58)**1.5d0 + 0.012420366417645d0*x58
     /     - 2.62863d0*(1.0d0 - 0.00177872643187478d0*x58)**3 
     /     - 3.33399d0*(1.0d0 - 0.00177872643187478d0*x58)**6) 
     /     - 3925.690806d0)/x58) + 1.1d0*x27          

      e10 = -41d0*x10*dexp((591.8d0*(1.38091d0*(1.0d0 
     /      - 0.00168976005407232d0*x58)**1.5d0 
     /      + 0.0123117100371747d0*x58 - 2.83433d0*(1.0d0 
     /      - 0.00168976005407232d0*x58)**3 
     /      - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x58)**6) 
     /      - 4311.896226d0)/x58) + 1.1d0*x28  

      e11 = -48.9d0*x11*dexp((562.2d0*(1.33213d0*(1.0d0 
     /      - 0.00177872643187478*x59)**1.5d0 
     /      + 0.012420366417645d0*x59 - 2.62863d0*(1.0d0 
     /      - 0.00177872643187478*x59)**3 -       
     /      3.33399d0*(1.0d0 - 0.00177872643187478*x59)**6) 
     /      - 3925.690806D0)/x59) + 1.09333333333333d0*x29  

      e12 = -41d0*x12*dexp((591.8d0*(1.38091*(1.0d0 
     /      - 0.00168976005407232d0*x59)**1.5d0 
     /      + 0.0123117100371747d0*x59 - 2.83433d0*(1.0d0 
     /      - 0.00168976005407232d0*x59)**3 - 2.79168*(1.0d0 
     /      - 0.00168976005407232d0*x59)**6) - 4311.896226d0)/x59) 
     /       + 1.09333333333333d0*x30  

      e13 = -48.9d0*x13*dexp((562.2d0*(1.33213d0*(1.0d0 
     /      - 0.00177872643187478d0*x60)**1.5d0 
     /      + 0.012420366417645d0*x60 - 2.62863d0*(1.0d0 
     /      - 0.00177872643187478d0*x60)**3 - 3.33399d0*(1.0d0 
     /      - 0.00177872643187478*x60)**6) - 3925.690806d0)/x60) 
     /       + 1.08666666666667d0*x31  

      e14 = -41d0*x14*dexp((591.8d0*(1.38091*(1.0d0 
     /      - 0.00168976005407232d0*x60)**1.5d0 
     /      + 0.0123117100371747d0*x60 - 2.83433d0*(1.0d0 
     /      - 0.00168976005407232d0*x60)**3 - 2.79168D0*(1.0d0 
     /      - 0.00168976005407232d0*x60)**6) - 4311.896226d0)/x60)  
     /       + 1.08666666666667d0*x32  

      e15 = -48.9d0*x15*dexp((562.2d0*(1.33213d0*(1.0d0 
     /      - 0.00177872643187478d0*x61)**1.5d0 
     /      + 0.012420366417645d0*x61 - 2.62863d0*(1.0d0 
     /      - 0.00177872643187478d0*x61)**3 - 3.33399d0*(1.0d0 
     /      - 0.00177872643187478d0*x61)**6) - 3925.690806d0)/x61) 
     /      + 1.08d0*x33 

      e16 = -41d0*x16*dexp((591.8d0*(1.38091d0*(1.0d0 
     /      - 0.00168976005407232d0*x61)**1.5d0 
     /      + 0.0123117100371747d0*x61 - 2.83433d0*(1.0d0 
     /      - 0.00168976005407232d0*x61)**3 - 2.79168d0*(1.0d0 
     /      - 0.00168976005407232d0*x61)**6) - 4311.896226d0)/x61) 
     /      + 1.08d0*x34 

      e17 = -48.9d0*x17*dexp((562.2d0*(1.33213d0*(1.0d0 
     /      - 0.00177872643187478d0*x62)**1.5d0   
     /      + 0.012420366417645d0*x62 - 2.62863d0*(1.0d0 
     /      - 0.00177872643187478d0*x62)**3 - 3.33399d0*(1.0d0 
     /      - 0.00177872643187478*x62)**6) - 3925.690806d0)/x62) 
     /      + 1.05d0*x35 

      e18 = -41d0*x18*dexp((591.8d0*(1.38091*(1.0d0 
     /      - 0.00168976005407232d0*x62)**1.5d0  
     /      + 0.0123117100371747d0*x62 - 2.83433d0*(1.0d0 
     /      - 0.00168976005407232d0*x62)**3 - 2.79168d0*(1.0d0 
     /      - 0.00168976005407232d0*x62)**6) - 4311.896226d0)/x62) 
     /      + 1.05d0*x36 

      e19 = -x1 - x2 + x19 + x20   

      e20 = -x3 - x4 + x21 + x22   

      e21 = -x5 - x6 + x23 + x24   

      e22 = -x7 - x8 + x25 + x26   

      e23 = -x9 - x10 + x27 + x28  

      e24 = -x11 - x12 + x29 + x30 

      e25 = -x13 - x14 + x31 + x32 

      e26 = -x15 - x16 + x33 + x34 

      e27 = -x17 - x18 + x35 + x36 

      e28 = x38*x3 + x47*x21 - x39*x5 - x46*x19 - 0.7d0*x63 

      e29 = x38*x4 + x47*x22 - x39*x6 - x46*x20 - 0.3d0*x63 

      e30 = x39*x5 + x48*x23 - x40*x7 - x47*x21 - 0.7d0*x64 

      e31 = x39*x6 + x48*x24 - x40*x8 - x47*x22 - 0.3d0*x64 

      e32 = x40*x7 + x49*x25 - x41*x9 - x48*x23 - 0.7d0*x65 

      e33 = x40*x8 + x49*x26 - x41*x10 - x48*x24 - 0.3d0*x65

      e34 = x41*x9 + x50*x27 - x42*x11 - x49*x25 - 0.7d0*x66

      e35 = x41*x10 + x50*x28 - x42*x12 - x49*x26 - 0.3d0*x66     

      e36 = x42*x11 + x51*x29 - x43*x13 - x50*x27 - 0.7d0*x67     

      e37 = x42*x12 + x51*x30 - x43*x14 - x50*x28 - 0.3d0*x67     

      e38 = x43*x13 + x52*x31 - x44*x15 - x51*x29 - 0.7d0*x68     

      e39 = x43*x14 + x52*x32 - x44*x16 - x51*x30 - 0.3d0*x68     

      e40 = x44*x15 + x53*x33 - x45*x17 - x52*x31 - 0.7d0*x69     

      e41 = x44*x16 + x53*x34 - x45*x18 - x52*x32 - 0.3d0*x69     

      e42 = x37*x1 + x46*x19 - x38*x3

      e43 = x37*x2 + x46*x20 - x38*x4

      e44 = (x45 + x71)*x17 - x53*x33

      e45 = (x45 + x71)*x18 - x53*x34

      e46 =    x38 - x39 - x46 + x47 - x63                

      e47 =    x39 - x40 - x47 + x48 - x64                

      e48 =    x40 - x41 - x48 + x49 - x65                

      e49 =    x41 - x42 - x49 + x50 - x66                

      e50 =    x42 - x43 - x50 + x51 - x67                

      e51 =    x43 - x44 - x51 + x52 - x68                

      e52 =    x44 - x45 - x52 + x53 - x69                

      e53 =    x37 - x38 + x46       

      e54 =    x45 - x53 + x71       

      e55 = -x70*x71 + x45         

      e56 =    x37 - x72             

      e57 = -3.13659116407937d-5*(x1*(x54*(x54*(0.23695d0 
     / + x54*(1.7825d-8*x54 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x54)**1.5d0
     / + 0.012420366417645d0*x54 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x54)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x54)**6) + 8.314d0*x54
     / *(1.998195d0*(1.0d0 - 0.00177872643187478d0*x54)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x54) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x54)**5  
     / - 6.98273d0) - 46242.079590558d0) + x2*(x54*(x54*(0.25625d0 
     / + x54*(1.22775d-8*x54 - 9.21666666666667d-5)) - 24.35d0)      
     / + 4920.2252d0*(1.38091d0*(1.0d0 
     / - 0.00168976005407232d0*x54)**1.5d0 
     / + 0.0123117100371747d0*x54 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x54)**3 - 2.79168d0*(1.0d0 
     / - 0.00168976005407232d0*x54)**6) + 8.314d0*x54*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x54)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x54) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x54)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x73        

      e58 = -3.13659116407937d-5*(x3*(x55*(x55*(0.23695d0 
     / + x55*(1.7825d-8*x55 - 0.000100566666666667d0)) - 33.92d0)
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x55)**1.5d0
     / + 0.012420366417645d0*x55 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x55)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x55)**6) + 8.314d0*x55*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x55)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x55) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x55)**5  
     / - 6.98273d0) - 46242.079590558d0) + x4*(x55*(x55*(0.25625d0
     / + x55*(1.22775d-8*x55 - 9.21666666666667d-5)) - 24.35d0) 
     / + 4920.2252d0*(1.38091d0*(1.0d0-0.00168976005407232d0*x55)**1.5d0
     / + 0.0123117100371747d0*x55 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x55)**3 - 2.79168d0*(1.0d0 
     / - 0.00168976005407232d0*x55)**6) + 8.314d0*x55*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x55)**0.5d0
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x55) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x55)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x74        

      e59 = -3.13659116407937d-5*(x5*(x56*(x56*(0.23695d0 
     / + x56*(1.7825d-8*x56 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x56)**1.5d0
     / + 0.012420366417645d0*x56 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x56)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x56)**6) + 8.314d0*x56
     / *(1.998195d0*(1.0d0 - 0.00177872643187478d0*x56)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x56) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x56)**5  
     / - 6.98273d0) - 46242.079590558d0) + x6*(x56*(x56
     / *(0.25625d0 + x56*(1.22775d-8*x56 - 9.21666666666667d-5)) 
     / - 24.35d0) + 4920.2252d0*(1.38091*(1.0d0 
     / - 0.00168976005407232d0*x56)**1.5d0+0.0123117100371747d0*x56
     / - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x56)**3 
     / - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x56)**6) + 8.314d0*x56
     / *(2.071365d0*(1.0d0 - 0.00168976005407232d0*x56)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x56) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x56)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x75        

      e60 = -3.13659116407937d-5*(x7*(x57*(x57*(0.23695d0 
     / + x57*(1.7825d-8*x57 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x57)**1.5d0
     / + 0.012420366417645d0*x57 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x57)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x57)**6) + 8.314d0*x57*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x57)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x57) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x57)**5  
     / - 6.98273d0) - 46242.079590558d0) + x8*(x57*(x57*(0.25625d0 
     / + x57*(1.22775d-8*x57 - 9.21666666666667d-5)) - 24.35d0) 
     / + 4920.2252d0*(1.38091d0*(1.0d0-0.00168976005407232d0*x57)**1.5d0
     / + 0.0123117100371747d0*x57 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x57)**3 - 2.79168d0*(1.0d0 
     / - 0.00168976005407232d0*x57)**6) + 8.314d0*x57*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x57)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x57) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x57)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x76        

      e61 = -3.13659116407937d-5*(x9*(x58*(x58*(0.23695d0 
     / + x58*(1.7825d-8*x58 - 0.000100566666666667d0)) - 33.92d0)
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x58)**1.5d0
     / + 0.012420366417645d0*x58 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x58)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x58)**6) + 8.314d0*x58*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x58)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x58) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x58)**5  
     / - 6.98273d0) - 46242.079590558d0) + x10*(x58*(x58
     / *(0.25625d0 + x58*(1.22775e-8*x58 - 9.21666666666667d-5)) 
     / - 24.35d0) + 4920.2252d0*(1.38091*(1.0d0 
     / - 0.00168976005407232d0*x58)**1.5d0+0.0123117100371747d0*x58 
     / - 2.83433d0*(1.0d0 - 0.00168976005407232d0*x58)**3 
     / - 2.79168d0*(1.0d0 - 0.00168976005407232d0*x58)**6) 
     / + 8.314d0*x58*(2.071365d0*(1d0-0.00168976005407232d0*x58)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x58) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x58)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x77        

      e62 = -3.13659116407937d-5*(x11*(x59*(x59*(0.23695d0 
     / + x59*(1.7825d-8*x59 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1.0d0-0.00177872643187478d0*x59)**1.5d0
     / + 0.012420366417645d0*x59 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x59)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x59)**6) + 8.314d0*x59
     / *(1.998195d0*(1.0d0 - 0.00177872643187478d0*x59)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x59) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x59)**5  
     / - 6.98273d0) - 46242.079590558d0) + x12*(x59*(x59
     / *(0.25625d0 + x59*(1.22775e-8*x59 - 9.21666666666667d-5)) 
     / - 24.35d0) + 4920.2252d0*(1.38091*(1.0d0 
     / - 0.00168976005407232d0*x59)**1.5d0 + 0.0123117100371747d0*x59 
     / - 2.83433d0*(1.0d0-0.00168976005407232d0*x59)**3-2.79168d0*(1.0d0
     / - 0.00168976005407232d0*x59)**6) + 8.314d0*x59
     / *(2.071365d0*(1.0d0 - 0.00168976005407232d0*x59)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x59) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x59)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x78        

      e63 = -3.13659116407937d-5*(x13*(x60*(x60*(0.23695d0 
     / + x60*(1.7825d-8*x60 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1d0 - 0.00177872643187478d0*x60)**1.5d0
     / + 0.012420366417645d0*x60 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x60)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x60)**6) + 8.314d0*x60*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x60)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x60) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x60)**5  
     / - 6.98273d0) - 46242.079590558d0) + x14*(x60*(x60
     / *(0.25625d0 + x60*(1.22775e-8*x60 - 9.21666666666667d-5)) 
     / - 24.35d0) + 4920.2252d0*(1.38091*(1.0d0 - 0.00168976005407232d0
     / *x60)**1.5d0 + 0.0123117100371747d0*x60 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x60)**3 - 2.79168d0*(1.0d0 
     / - 0.00168976005407232d0*x60)**6) + 8.314d0*x60*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x60)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x60) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x60)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x79        

      e64 = -3.13659116407937d-5*(x15*(x61*(x61*(0.23695d0 
     / + x61*(1.7825d-8*x61 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1d0 - 0.00177872643187478d0*x61)**1.5d0
     / + 0.012420366417645d0*x61 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x61)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x61)**6) + 8.314d0*x61*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x61)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x61)
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x61)**5  
     / - 6.98273d0) - 46242.079590558d0) + x16*(x61*(x61
     / *(0.25625d0 + x61*(1.22775e-8*x61 - 9.21666666666667d-5))
     / - 24.35d0) + 4920.2252d0*(1.38091*(1.0d0 - 0.00168976005407232d0
     / *x61)**1.5d0 + 0.0123117100371747d0*x61 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x61)**3 - 2.79168d0*(1.0d0
     / - 0.00168976005407232d0*x61)**6) + 8.314d0*x61*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x61)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x61)
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x61)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x80        

      e65 = -3.13659116407937d-5*(x17*(x62*(x62*(0.23695d0 
     / + x62*(1.7825d-8*x62 - 0.000100566666666667d0)) - 33.92d0) 
     / + 4674.1308d0*(1.33213d0*(1d0 - 0.00177872643187478d0*x62)**1.5d0
     / + 0.012420366417645d0*x62 - 2.62863d0*(1.0d0 
     / - 0.00177872643187478d0*x62)**3 - 3.33399d0*(1.0d0 
     / - 0.00177872643187478d0*x62)**6) + 8.314d0*x62*(1.998195d0
     / *(1.0d0 - 0.00177872643187478d0*x62)**0.5d0 
     / - 7.88589d0*sqr(1.0d0 - 0.00177872643187478d0*x62) 
     / - 20.00394d0*(1.0d0 - 0.00177872643187478d0*x62)**5  
     / - 6.98273d0) - 46242.079590558d0) + x18*(x62*(x62*(0.25625d0
     / + x62*(1.22775e-8*x62 - 9.21666666666667d-5)) - 24.35d0) 
     / + 4920.2252d0*(1.38091*(1.0d0 - 0.00168976005407232d0*x62)**1.5d0
     / + 0.0123117100371747d0*x62 - 2.83433d0*(1.0d0 
     / - 0.00168976005407232d0*x62)**3 - 2.79168d0*(1.0d0 
     / - 0.00168976005407232d0*x62)**6) + 8.314d0*x62*(2.071365d0
     / *(1.0d0 - 0.00168976005407232d0*x62)**0.5d0 
     / - 8.50299d0*sqr(1.0d0 - 0.00168976005407232d0*x62) 
     / - 16.75008d0*(1.0d0 - 0.00168976005407232d0*x62)**5  
     / - 7.28607d0) - 55570.3234397208d0)) + x81        

      e66 = -3.13659116407937d-5*(x19*(x54*(x54*(0.23695d0 
     /      + x54*(1.7825d-8*x54 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x20*(x54*(x54*(0.25625d0 
     /      + x54*(1.22775d-8*x54 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x82 

      e67 = -3.13659116407937d-5*(x21*(x55*(x55*(0.23695d0 
     /      + x55*(1.7825d-8*x55 - 0.000100566666666667d0)) - 33.92d0)
     /      - 13603.886229474d0) + x22*(x55*(x55*(0.25625d0 
     /      + x55*(1.22775d-8*x55 - 9.21666666666667d-5)) - 24.35d0)
     /      - 19721.2182167568d0)) + x83 

      e68 = -3.13659116407937d-5*(x23*(x56*(x56*(0.23695d0 
     /      + x56*(1.7825d-8*x56 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x24*(x56*(x56*(0.25625d0 
     /      + x56*(1.22775d-8*x56 - 9.21666666666667d-5)) - 24.35d0)
     /      - 19721.2182167568d0)) + x84 

      e69 = -3.13659116407937d-5*(x25*(x57*(x57*(0.23695d0 
     /      + x57*(1.7825d-8*x57 - 0.000100566666666667d0)) - 33.92d0)
     /      - 13603.886229474d0) + x26*(x57*(x57*(0.25625d0 
     /      + x57*(1.22775d-8*x57 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x85 

      e70 = -3.13659116407937d-5*(x27*(x58*(x58*(0.23695d0 
     /      + x58*(1.7825d-8*x58 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x28*(x58*(x58*(0.25625d0 
     /      + x58*(1.22775d-8*x58 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x86 

      e71 = -3.13659116407937d-5*(x29*(x59*(x59*(0.23695d0 
     /      + x59*(1.7825d-8*x59 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x30*(x59*(x59*(0.25625d0 
     /      + x59*(1.22775d-8*x59 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x87 

      e72 = -3.13659116407937d-5*(x31*(x60*(x60*(0.23695d0 
     /      + x60*(1.7825d-8*x60 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x32*(x60*(x60*(0.25625d0 
     /      + x60*(1.22775d-8*x60 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x88 

      e73 = -3.13659116407937d-5*(x33*(x61*(x61*(0.23695d0 
     /      + x61*(1.7825d-8*x61 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x34*(x61*(x61*(0.25625d0 
     /      + x61*(1.22775d-8*x61 - 9.21666666666667d-5)) - 24.35d0)
     /      - 19721.2182167568d0)) + x89 

      e74 = -3.13659116407937d-5*(x35*(x62*(x62*(0.23695d0 
     /      + x62*(1.7825d-8*x62 - 0.000100566666666667d0)) - 33.92d0) 
     /      - 13603.886229474d0) + x36*(x62*(x62*(0.25625d0 
     /      + x62*(1.22775d-8*x62 - 9.21666666666667d-5)) - 24.35d0) 
     /      - 19721.2182167568d0)) + x90 

      e75 = x38*x74 + x47*x83 - x39*x75 - x46*x82 
     /      + 0.999444137682208d0*x63            

      e76 = x39*x75 + x48*x84 - x40*x76 - x47*x83 
     /      + 0.999444137682208d0*x64            

      e77 = x40*x76 + x49*x85 - x41*x77 - x48*x84 
     /      + 0.999444137682208d0*x65            

      e78 = x41*x77 + x50*x86 - x42*x78 - x49*x85 
     /      + 0.999444137682208d0*x66            

      e79 = x42*x78 + x51*x87 - x43*x79 - x50*x86 
     /      + 0.999444137682208d0*x67            

      e80 = x43*x79 + x52*x88 - x44*x80 - x51*x87 
     /      + 0.999444137682208d0*x68            

      e81 = x44*x80 + x53*x89 - x45*x81 - x52*x88 
     /      + 0.999444137682208d0*x69            

      e82 = x17 - 0.95d0          

      e83 = x63 + x64 + x65 + x66 + x67 + x68 + x69 - 100.0d0  

      e84 = b91 + b92 + b93 + b94 + b95 + b96 + b97 - 1.00d0 

      e85 = x63 - 100.0d0*b91         

      e86 = x64 - 100.0d0*b92         

      e87 = x65 - 100.0d0*b93         

      e88 = x66 - 100.0d0*b94         

      e89 = x67 - 100.0d0*b95         

      e90 = x68 - 100.0d0*b96         

      e91 = x69 - 100.0d0*b97                   

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = e5
      g(6) = e6
      g(7) = e7
      g(8) = e8
      g(9) = e9
      g(10) = e10
      g(11) = e11
      g(12) = e12
      g(13) = e13
      g(14) = e14
      g(15) = e15
      g(16) = e16
      g(17) = e17
      g(18) = e18
      g(19) = e19
      g(20) = e20
      g(21) = e21
      g(22) = e22
      g(23) = e23
      g(24) = e24
      g(25) = e25
      g(26) = e26
      g(27) = e27
      g(28) = e28
      g(29) = e29
      g(30) = e30
      g(31) = e31
      g(32) = e32
      g(33) = e33
      g(34) = e34
      g(35) = e35
      g(36) = e36
      g(37) = e37
      g(38) = e38
      g(39) = e39
      g(40) = e40
      g(41) = e41
      g(42) = e42
      g(43) = e43
      g(44) = e44
      g(45) = e45
      g(46) = e46
      g(47) = e47
      g(48) = e48
      g(49) = e49
      g(50) = e50
      g(51) = e51
      g(52) = e52
      g(53) = e53
      g(54) = e54
      g(55) = e55
      g(56) = e56
      g(57) = e57
      g(58) = e58
      g(59) = e59
      g(60) = e60
      g(61) = e61
      g(62) = e62
      g(63) = e63
      g(64) = e64
      g(65) = e65
      g(66) = e66
      g(67) = e67
      g(68) = e68
      g(69) = e69
      g(70) = e70
      g(71) = e71
      g(72) = e72
      g(73) = e73
      g(74) = e74
      g(75) = e75
      g(76) = e76
      g(77) = e77
      g(78) = e78
      g(79) = e79
      g(80) = e80
      g(81) = e81
      g(82) = e83
      g(83) = e84
      g(84) = e82
      g(85) = -e85
      g(86) = -e86
      g(87) = -e87
      g(88) = -e88
      g(89) = -e89
      g(90) = -e90
      g(91) = -e91

  999 continue
      return
      end
 

      subroutine feedtray2(  mode,     m,     me,  mmax, ncont,  
     /                       nbin,  nint,   nmax,     x,    xl,
     /                         xu,     f,      g,  pnam,  pref,
     /                        fex )    

*  MINLP written by GAMS Convert at 04/25/01 17:47:55
*  
*  Equation counts
*     Total       E       G       L       N       X
*       284       7     114     163       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        88      52      36       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*      1627     685     942       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /        b31, b32, b33, b34, b35, b36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70, 
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80, 
     /        x81, x82, x83, x84, x85, x86, x87
      double precision 
     /           e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /          e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /          e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /          e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /          e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /          e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /          e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /          e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /          e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /          e91, e92, e93, e94, e95, e96, e97, e98,     e100
      double precision 
     /         e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /         e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /         e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /         e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /         e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /         e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /         e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /         e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /         e181,e182,e183,e184,e185,e186,e187,e188,e189,e190,
     /         e191,e192,e193,e194,e195,e196,e197,e198,e199,e200,
     /         e201,e202,e203,e204,e205,e206,e207,e208,e209,e210,
     /         e211,e212,e213,e214,e215,e216,e217,e218,e219,e220,
     /         e221,e222,e223,e224,e225,e226,e227,e228,e229,e230,
     /         e231,e232,e233,e234,e235,e236,e237,e238,e239,e240,
     /         e241,e242,e243,e244,e245,e246,e247,e248,e249,e250,
     /         e251,e252,e253,e254,e255,e256,e257,e258,e259,e260,
     /         e261,e262,e263,e264,e265,e266,e267,e268,e269,e270,
     /         e271,e272,e273,e274,e275,e276,e277,e278,e279,e280,
     /         e281,e282,e283,e284
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FEEDTRAY2'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0
         ncont = 51
         nint  = 0
         nbin  = 36
         n     = ncont + nbin + nint
         m     = 283
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i=49,51
            xl(i) = 1.0d-6
            x(i)  = 1.0d0
            xu(i) = 100.0d0
         enddo   
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x37 = x( 1)
      x38 = x( 2)
      x39 = x(3)
      x40 = x(4)
      x41 = x(5)
      x42 = x(6)
      x43 = x(7)
      x44 = x(8)
      x45 = x(9)
      x46 = x(10)
      x47 = x(11)
      x48 = x(12)
      x49 = x(13)
      x50 = x(14)
      x51 = x(15)
      x52 = x(16)
      x53 = x(17)
      x54 = x(18)
      x55 = x(19)
      x56 = x(20)
      x57 = x(21)
      x58 = x(22)
      x59 = x(23)
      x60 = x(24)
      x61 = x(25)
      x62 = x(26)
      x63 = x(27)
      x64 = x(28)
      x65 = x(29)
      x66 = x(30)
      x67 = x(31)
      x68 = x(32)
      x69 = x(33)
      x70 = x(34)
      x71 = x(35)
      x72 = x(36)
      x73 = x(37)
      x74 = x(38)
      x75 = x(39)
      x76 = x(40)
      x77 = x(41)
      x78 = x(42)
      x79 = x(43)
      x80 = x(44)
      x81 = x(45)
      x82 = x(46)
      x83 = x(47)
      x84 = x(48)
      x85 = x(49)
      x86 = x(50)
      x87 = x(51)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)
      b26 = y(26)
      b27 = y(27)
      b28 = y(28)
      b29 = y(29)
      b30 = y(30)
      b31 = y(31)
      b32 = y(32)
      b33 = y(33)
      b34 = y(34)
      b35 = y(35)
      b36 = y(36)

      f =  x85/x87 + 1.0d0

      e1 = x87*x61 + 1000.0d0*b1 - 1000.024d0 

      e2 = x87*x63 + 1000.0d0*b2 - 1000.024d0 

      e3 = x87*x65 + 1000.0d0*b3 - 1000.024d0 

      e4 = x87*x67 + 1000.0d0*b4 - 1000.024d0 

      e5 = x87*x69 + 1000.0d0*b5 - 1000.024d0 

      e6 = x87*x71 + 1000.0d0*b6 - 1000.024d0 

      e7 = x87*x73 + 1000.0d0*b7 - 1000.024d0 

      e8 = x87*x75 + 1000.0d0*b8 - 1000.024d0 

      e9 = x87*x77 + 1000.0d0*b9 - 1000.024d0 

      e10 = x87*x79 + 1000.0d0*b10 - 1000.024d0

      e11 = x87*x81 + 1000.0d0*b11 - 1000.024d0

      e12 = x87*x83 + 1000.0d0*b12 - 1000.024d0

      e13 = (100.0d0*b14 + 100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x39 
     /      + x86*x63 - (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x41 
     /      - x86*x61 - 80.0d0*b14 - 1000.0d0*b2 + 1000.0d0*b26 
     /      - 1000.0d0

      e14 = (100.0d0*b14 + 100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x40 
     /      + x86*x64 - (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x42 
     /      - x86*x62 - 20.0d0*b14 - 1000.0d0*b2 + 1000.0d0*b26 
     /      - 1000.0d0

      e15 = (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 
     /      + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x41 + x86*x65 
     /      - (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x43 - x86*x63 - 80.0d0*b15 
     /      - 1000.0d0*b3 + 1000.0d0*b27 - 1000.0d0   

      e16 = (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 
     /      + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x42 + x86*x66 
     /      - (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23
     /      + 100.0d0*b24 + x85)*x44 - x86*x64 - 20.0d0*b15 
     /      - 1000.0d0*b3 + 1000.0d0*b27 - 1000.0d0                

      e17 = (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x43 + x86*x67 - (100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x45 
     /      - x86*x65 - 80.0d0*b16 - 1000.0d0*b4 + 1000.0d0*b28 
     /      - 1000.0d0 

      e18 = (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x44 + x86*x68 - (100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x46 
     /      - x86*x66 - 20.0d0*b16 - 1000.0d0*b4 + 1000.0d0*b28 
     /      - 1000.0d0 

      e19 = (100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 
     /      + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x45 + x86*x69 - (100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x47 - x86*x67 - 80.0d0*b17 
     /      - 1000.0d0*b5 + 1000.0d0*b29 - 1000.0d0          

      e20 = (100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 
     /      + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x46 + x86*x70 - (100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x48 - x86*x68 - 20.0d0*b17 
     /      - 1000.0d0*b5 + 1000.0d0*b29 - 1000.0d0          

      e21 = (100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x47 
     /      + x86*x71 - (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x49 
     /      - x86*x69 - 80.0d0*b18 - 1000.0d0*b6 + 1000.0d0*b30 
     /      - 1000.0d0   

      e22 = (100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x48 
     /      + x86*x72 - (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x50 
     /      - x86*x70 - 20.0d0*b18 - 1000.0d0*b6 + 1000.0d0*b30
     /      - 1000.0d0   

      e23 = (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x49 + x86*x73 
     /      - (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x51 - x86*x71 - 80.0d0*b19 
     /      - 1000.0d0*b7 + 1000.0d0*b31 - 1000.0d0

      e24 = (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x50 + x86*x74 
     /      - (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23
     /      + 100.0d0*b24 + x85)*x52 - x86*x72 - 20.0d0*b19 
     /      - 1000.0d0*b7 + 1000.0d0*b31 - 1000.0d0

      e25 = (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x51 + x86*x75 - (100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x53 
     /      - x86*x73 - 80.0d0*b20 - 1000.0d0*b8 + 1000.0d0*b32 
     /      - 1000.0d0

      e26 = (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x52 + x86*x76 - (100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x54 
     /      - x86*x74 - 20.0d0*b20 - 1000.0d0*b8 + 1000.0d0*b32 
     /      - 1000.0d0

      e27 = (100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x53 + x86*x77 - (100.0d0*b22 + 100.0d0*b23
     /      + 100.0d0*b24 + x85)*x55 - x86*x75 - 80.0d0*b21 
     /      - 1000.0d0*b9 + 1000.0d0*b33 - 1000.0d0

      e28 = (100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x54 + x86*x78 - (100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x56 - x86*x76 - 20.0d0*b21 
     /      - 1000.0d0*b9 + 1000.0d0*b33 - 1000.0d0

      e29 = (100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x55 
     /      + x86*x79 - (100.0d0*b23 + 100.0d0*b24 + x85)*x57 - x86*x77
     /      - 80.0d0*b22 - 1000.0d0*b10 + 1000.0d0*b34 - 1000.0d0  

      e30 = (100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x56 
     /      + x86*x80 - (100.0d0*b23 + 100.0d0*b24 + x85)*x58 - x86*x78
     /      - 20.0d0*b22 - 1000.0d0*b10 + 1000.0d0*b34 - 1000.0d0     

      e31 = (100.0d0*b23 + 100.0d0*b24 + x85)*x57 + x86*x81 
     /      - (100.0d0*b24 + x85)*x59 - x86*x79 - 80.0d0*b23
     /      - 1000.0d0*b11 + 1000.0d0*b35 - 1000.0d0      

      e32 = (100.0d0*b23 + 100.0d0*b24 + x85)*x58 + x86*x82
     /      - (100.0d0*b24 + x85)*x60 - x86*x80 - 20.0d0*b23
     /      - 1000.0d0*b11 + 1000.0d0*b35 - 1000.0d0      

      e33 = x86*x61 - (100.0d0 + x85)*x39 + 80.0d0*x37            

      e34 = x86*x62 - (100.0d0 + x85)*x40 + 80.0d0*x38            

      e35 = (100.0d0*b14 + 100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 +
     /      100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x39 + x86*x63 - (100.0d0*b15 + 100.0d0*b16 
     /      + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 
     /      + 100.0d0*b21 + 100.0d0*b22 + 100*b23 + 100.0d0*b24 
     /      + x85)*x41 - x86*x61 - 80.0d0*b14 - 1000.0d0*b2 
     /      + 1000.0d0*b26 - 1000.0d0

      e36 = (100.0d0*b14 + 100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x40 
     /      + x86*x64 - (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x42
     /      - x86*x62 - 20.0d0*b14 - 1000.0d0*b2 + 1000.0d0*b26     
     /       - 1000.0d0

      e37 = (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 
     /      + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x41 + x86*x65 
     /      - (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x43 - x86*x63 - 80.0d0*b15 
     /      - 1000.0d0*b3 + 1000.0d0*b27 - 1000.0d0                

      e38 = (100.0d0*b15 + 100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 
     /      + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x42 + x86*x66 
     /      - (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x44 - x86*x64 - 20.0d0*b15 
     /      - 1000.0d0*b3 + 1000.0d0*b27 - 1000.0d0                

      e39 = (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x43 + x86*x67 - (100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x45 
     /      - x86*x65 - 80.0d0*b16 - 1000.0d0*b4 + 1000.0d0*b28 
     /      - 1000.0d0            

      e40 = (100.0d0*b16 + 100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x44 + x86*x68 - (100.0d0*b17 
     /      + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x46 
     /      - x86*x66 - 20.0d0*b16 - 1000.0d0*b4 + 1000.0d0*b28 
     /      - 1000.0d0            

      e41 = (100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 
     /      + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x45 + x86*x69 - (100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x47 - x86*x67 - 80.0d0*b17 
     /      - 1000.0d0*b5 + 1000.0d0*b29 - 1000.0d0          

      e42 = (100.0d0*b17 + 100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 
     /      + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x46 + x86*x70 - (100.0d0*b18 + 100.0d0*b19 
     /      + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23
     /      + 100.0d0*b24 + x85)*x48 - x86*x68 - 20.0d0*b17 
     /      - 1000.0d0*b5 + 1000.0d0*b29 - 1000.0d0          

      e43 = (100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x47 
     /      + x86*x71 - (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x49 
     /      - x86*x69 - 80.0d0*b18 - 1000.0d0*b6 + 1000.0d0*b30 
     /      - 1000.0d0   

      e44 = (100.0d0*b18 + 100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x48 
     /      + x86*x72 - (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x50
     /      - x86*x70 - 20.0d0*b18 - 1000.0d0*b6 + 1000.0d0*b30 
     /      - 1000.0d0   

      e45 = (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x49 + x86*x73 
     /      - (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23
     /      + 100.0d0*b24 + x85)*x51 - x86*x71 - 80.0d0*b19 
     /      - 1000.0d0*b7 + 1000.0d0*b31 - 1000.0d0

      e46 = (100.0d0*b19 + 100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 
     /      + 100.0d0*b23 + 100.0d0*b24 + x85)*x50 + x86*x74 
     /      - (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x52 - x86*x72 - 20.0d0*b19 
     /      - 1000.0d0*b7 + 1000.0d0*b31 - 1000.0d0

      e47 = (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x51 + x86*x75 - (100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x53 
     /      - x86*x73 - 80.0d0*b20 - 1000.0d0*b8 + 1000.0d0*b32 
     /      - 1000.0d0

      e48 = (100.0d0*b20 + 100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x52 + x86*x76 - (100.0d0*b21 
     /      + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x54 
     /      - x86*x74 - 20.0d0*b20 - 1000.0d0*b8 + 1000.0d0*b32 
     /      - 1000.0d0

      e49 = (100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x53 + x86*x77 - (100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x55 - x86*x75 - 80.0d0*b21 
     /      - 1000.0d0*b9 + 1000.0d0*b33 - 1000.0d0

      e50 = (100.0d0*b21 + 100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 
     /      + x85)*x54 + x86*x78 - (100.0d0*b22 + 100.0d0*b23 
     /      + 100.0d0*b24 + x85)*x56 - x86*x76 - 20.0d0*b21 
     /      - 1000.0d0*b9 + 1000.0d0*b33 - 1000.0d0

      e51 = (100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x55 
     /      + x86*x79 - (100.0d0*b23 + 100.0d0*b24 + x85)*x57 
     /      - x86*x77 - 80.0d0*b22 - 1000.0d0*b10 + 1000.0d0*b34 
     /      - 1000.0d0            

      e52 = (100.0d0*b22 + 100.0d0*b23 + 100.0d0*b24 + x85)*x56 
     /      + x86*x80 - (100.0d0*b23 + 100.0d0*b24 + x85)*x58 - x86*x78
     /      - 20.0d0*b22 - 1000.0d0*b10 + 1000.0d0*b34 - 1000.0d0    

      e53 = (100.0d0*b23 + 100.0d0*b24 + x85)*x57 + x86*x81 
     /      - (100.0d0*b24 + x85)*x59 - x86*x79 - 80.0d0*b23
     /      - 1000.0d0*b11 + 1000.0d0*b35 - 1000.0d0      

      e54 = (100.0d0*b23 + 100.0d0*b24 + x85)*x58 + x86*x82 
     /      - (100.0d0*b24 + x85)*x60 - x86*x80 - 20.0d0*b23 
     /      - 1000.0d0*b11 + 1000.0d0*b35 - 1000.0d0      

      e55 = x85*x39 + x87*x63 - x86*x61 + 1000.0d0*b2 - 1000.0d0

      e56 = x85*x40 + x87*x64 - x86*x62 + 1000.0d0*b2 - 1000.0d0

      e57 = x85*x41 + x87*x65 - x86*x63 + 1000.0d0*b3 - 1000.0d0

      e58 = x85*x42 + x87*x66 - x86*x64 + 1000.0d0*b3 - 1000.0d0

      e59 = x85*x43 + x87*x67 - x86*x65 + 1000.0d0*b4 - 1000.0d0

      e60 = x85*x44 + x87*x68 - x86*x66 + 1000.0d0*b4 - 1000.0d0

      e61 = x85*x45 + x87*x69 - x86*x67 + 1000.0d0*b5 - 1000.0d0

      e62 = x85*x46 + x87*x70 - x86*x68 + 1000.0d0*b5 - 1000.0d0

      e63 = x85*x47 + x87*x71 - x86*x69 + 1000.0d0*b6 - 1000.0d0

      e64 = x85*x48 + x87*x72 - x86*x70 + 1000.0d0*b6 - 1000.0d0

      e65 = x85*x49 + x87*x73 - x86*x71 + 1000.0d0*b7 - 1000.0d0

      e66 = x85*x50 + x87*x74 - x86*x72 + 1000.0d0*b7 - 1000.0d0

      e67 = x85*x51 + x87*x75 - x86*x73 + 1000.0d0*b8 - 1000.0d0

      e68 = x85*x52 + x87*x76 - x86*x74 + 1000.0d0*b8 - 1000.0d0

      e69 = x85*x53 + x87*x77 - x86*x75 + 1000.0d0*b9 - 1000.0d0

      e70 = x85*x54 + x87*x78 - x86*x76 + 1000.0d0*b9 - 1000.0d0

      e71 = x85*x55 + x87*x79 - x86*x77 + 1000.0d0*b10 - 1000.0d0

      e72 = x85*x56 + x87*x80 - x86*x78 + 1000.0d0*b10 - 1000.0d0

      e73 = x85*x57 + x87*x81 - x86*x79 + 1000.0d0*b11 - 1000.0d0

      e74 = x85*x58 + x87*x82 - x86*x80 + 1000.0d0*b11 - 1000.0d0

      e75 = x85*x59 + x87*x83 - x86*x81 + 1000.0d0*b12 - 1000.0d0

      e76 = x85*x60 + x87*x84 - x86*x82 + 1000.0d0*b12 - 1000.0d0

      e77 = x85*x39 + x87*x63 - x86*x61 - 1000.0d0*b2 + 1000.0d0

      e78 = x85*x40 + x87*x64 - x86*x62 - 1000.0d0*b2 + 1000.0d0

      e79 = x85*x41 + x87*x65 - x86*x63 - 1000.0d0*b3 + 1000.0d0

      e80 = x85*x42 + x87*x66 - x86*x64 - 1000.0d0*b3 + 1000.0d0

      e81 = x85*x43 + x87*x67 - x86*x65 - 1000.0d0*b4 + 1000.0d0

      e82 = x85*x44 + x87*x68 - x86*x66 - 1000.0d0*b4 + 1000.0d0

      e83 = x85*x45 + x87*x69 - x86*x67 - 1000.0d0*b5 + 1000.0d0

      e84 = x85*x46 + x87*x70 - x86*x68 - 1000.0d0*b5 + 1000.0d0

      e85 = x85*x47 + x87*x71 - x86*x69 - 1000.0d0*b6 + 1000.0d0

      e86 = x85*x48 + x87*x72 - x86*x70 - 1000.0d0*b6 + 1000.0d0

      e87 = x85*x49 + x87*x73 - x86*x71 - 1000.0d0*b7 + 1000.0d0

      e88 = x85*x50 + x87*x74 - x86*x72 - 1000.0d0*b7 + 1000.0d0

      e89 = x85*x51 + x87*x75 - x86*x73 - 1000.0d0*b8 + 1000.0d0

      e90 = x85*x52 + x87*x76 - x86*x74 - 1000.0d0*b8 + 1000.0d0

      e91 = x85*x53 + x87*x77 - x86*x75 - 1000.0d0*b9 + 1000.0d0

      e92 = x85*x54 + x87*x78 - x86*x76 - 1000.0d0*b9 + 1000.0d0

      e93 = x85*x55 + x87*x79 - x86*x77 - 1000.0d0*b10 + 1000.0d0 

      e94 = x85*x56 + x87*x80 - x86*x78 - 1000.0d0*b10 + 1000.0d0 

      e95 = x85*x57 + x87*x81 - x86*x79 - 1000.0d0*b11 + 1000.0d0 

      e96 = x85*x58 + x87*x82 - x86*x80 - 1000.0d0*b11 + 1000.0d0 

      e97 = x85*x59 + x87*x83 - x86*x81 - 1000.0d0*b12 + 1000.0d0 

      e98 = x85*x60 + x87*x84 - x86*x82 - 1000.0d0*b12 + 1000.0d0 

      e100 = b13 + b14 + b15 + b16 + b17 + b18 + b19 + b20 + b21 
     /       + b22 + b23 + b24 - 1.0d0

      e101 = b1 + b2 + b3 + b4 + b5 + b6 + b7 + b8 + b9 + b10 + b11 
     /       + b12 - 1.0d0

      e102 = b25 + b26 + b27 + b28 + b29 + b30 + b31 + b32 + b33 + b34 
     /       + b35 + b36 - 12.0d0 

      e103 = b1 + 2.0d0*b2 + 3.0d0*b3 + 4.0d0*b4 + 5.0d0*b5 + 6.0d0*b6 
     /       + 7.0d0*b7 + 8.0d0*b8 + 9.0d0*b9 + 10.0d0*b10
     /       + 11.0d0*b11 + 12.0d0*b12 - 12.0d0    

      e104 = -b1 - 2.0d0*b2 - 3.0d0*b3 - 4.0d0*b4 - 5.0d0*b5 - 6.0d0*b6 
     /       - 7.0d0*b7 - 8.0d0*b8 - 9.0d0*b9 - 10.0d0*b10 - 11.0d0*b11 
     /       - 12.0d0*b12 + b13 + 2.0d0*b14 + 3.0d0*b15 + 4.0d0*b16 
     /       + 5.0d0*b17 + 6.0d0*b18 + 7.0d0*b19 + 8.0d0*b20 + 9.0d0*b21
     /       + 10.0d0*b22 + 11.0d0*b23 + 12.0d0*b24  

      e105 = b1 - b25                  

      e106 = b2 - b26                  

      e107 = b3 - b27                  

      e108 = b4 - b28                  

      e109 = b5 - b29                  

      e110 = b6 - b30                  

      e111 = b7 - b31                  

      e112 = b8 - b32                  

      e113 = b9 - b33                  

      e114 = b10 - b34                 

      e115 = b11 - b35                 

      e116 = b12 - b36                 

      e117 = b13 - b25                 

      e118 = b14 - b26                 

      e119 = b15 - b27                 

      e120 = b16 - b28                 

      e121 = b17 - b29                 

      e122 = b18 - b30                 

      e123 = b19 - b31                 

      e124 = b20 - b32                 

      e125 = b21 - b33                 

      e126 = b22 - b34                 

      e127 = b23 - b35                 

      e128 = b24 - b36                 

      e129 = -b1 - b2 - b3 - b4 - b5 - b6 - b7 - b8 - b9 - b10 - b11 
     /       - b12 + b25           

      e130 = -b2 - b3 - b4 - b5 - b6 - b7 - b8 - b9 - b10 - b11 - b12 
     /       + b26     

      e131 = -b3 - b4 - b5 - b6 - b7 - b8 - b9 - b10 - b11 - b12 + b27

      e132 = -b4 - b5 - b6 - b7 - b8 - b9 - b10 - b11 - b12 + b28      

      e133 = -b5 - b6 - b7 - b8 - b9 - b10 - b11 - b12 + b29            

      e134 = -b6 - b7 - b8 - b9 - b10 - b11 - b12 + b30 

      e135 = -b7 - b8 - b9 - b10 - b11 - b12 + b31      

      e136 = -b8 - b9 - b10 - b11 - b12 + b32           

      e137 = -b9 - b10 - b11 - b12 + b33

      e138 = -b10 - b11 - b12 + b34     

      e139 = -b11 - b12 + b35           

      e140 = -b12 + b36                 

      e141 = -b25 - x61 - x62           

      e142 = -b26 - x63 - x64           

      e143 = -b27 - x65 - x66           

      e144 = -b28 - x67 - x68           

      e145 = -b29 - x69 - x70           

      e146 = -b30 - x71 - x72           

      e147 = -b31 - x73 - x74           

      e148 = -b32 - x75 - x76           

      e149 = -b33 - x77 - x78           

      e150 = -b34 - x79 - x80           

      e151 = -b35 - x81 - x82           

      e152 = -b36 - x83 - x84           

      e153 = b25 - x61 - x62           

      e154 = b26 - x63 - x64           

      e155 = b27 - x65 - x66           

      e156 = b28 - x67 - x68           

      e157 = b29 - x69 - x70           

      e158 = b30 - x71 - x72           

      e159 = b31 - x73 - x74           

      e160 = b32 - x75 - x76           

      e161 = b33 - x77 - x78           

      e162 = b34 - x79 - x80           

      e163 = b35 - x81 - x82           

      e164 = b36 - x83 - x84           

      e165 = -b25 - x37 - x38           

      e166 = -b26 - x39 - x40           

      e167 = -b27 - x41 - x42           

      e168 = -b28 - x43 - x44           

      e169 = -b29 - x45 - x46           

      e170 = -b30 - x47 - x48           

      e171 = -b31 - x49 - x50           

      e172 = -b32 - x51 - x52           

      e173 = -b33 - x53 - x54           

      e174 = -b34 - x55 - x56           

      e175 = -b35 - x57 - x58           

      e176 = -b36 - x59 - x60           

      e177 = b25 - x37 - x38           

      e178 = b26 - x39 - x40           

      e179 = b27 - x41 - x42           

      e180 = b28 - x43 - x44           

      e181 = b29 - x45 - x46           

      e182 = b30 - x47 - x48           

      e183 = b31 - x49 - x50           

      e184 = b32 - x51 - x52           

      e185 = b33 - x53 - x54           

      e186 = b34 - x55 - x56           

      e187 = b35 - x57 - x58           

      e188 = b36 - x59 - x60           

      e189 = -b25 - x61 - x62 + 2.0d0

      e190 = -b26 - x63 - x64 + 2.0d0

      e191 = -b27 - x65 - x66 + 2.0d0

      e192 = -b28 - x67 - x68 + 2.0d0

      e193 = -b29 - x69 - x70 + 2.0d0

      e194 = -b30 - x71 - x72 + 2.0d0

      e195 = -b31 - x73 - x74 + 2.0d0

      e196 = -b32 - x75 - x76 + 2.0d0

      e197 = -b33 - x77 - x78 + 2.0d0

      e198 = -b34 - x79 - x80 + 2.0d0

      e199 = -b35 - x81 - x82 + 2.0d0

      e200 = -b36 - x83 - x84 + 2.0d0

      e201 = b25 - x61 - x62 + 2.0d0

      e202 = b26 - x63 - x64 + 2.0d0

      e203 = b27 - x65 - x66 + 2.0d0

      e204 = b28 - x67 - x68 + 2.0d0

      e205 = b29 - x69 - x70 + 2.0d0

      e206 = b30 - x71 - x72 + 2.0d0

      e207 = b31 - x73 - x74 + 2.0d0

      e208 = b32 - x75 - x76 + 2.0d0

      e209 = b33 - x77 - x78 + 2.0d0

      e210 = b34 - x79 - x80 + 2.0d0

      e211 = b35 - x81 - x82 + 2.0d0

      e212 = b36 - x83 - x84 + 2.0d0

      e213 = -b25 - x37 - x38 + 2.0d0

      e214 = -b26 - x39 - x40 + 2.0d0

      e215 = -b27 - x41 - x42 + 2.0d0

      e216 = -b28 - x43 - x44 + 2.0d0

      e217 = -b29 - x45 - x46 + 2.0d0

      e218 = -b30 - x47 - x48 + 2.0d0

      e219 = -b31 - x49 - x50 + 2.0d0

      e220 = -b32 - x51 - x52 + 2.0d0

      e221 = -b33 - x53 - x54 + 2.0d0

      e222 = -b34 - x55 - x56 + 2.0d0

      e223 = -b35 - x57 - x58 + 2.0d0

      e224 = -b36 - x59 - x60 + 2.0d0

      e225 = b25 - x37 - x38 + 2.0d0

      e226 = b26 - x39 - x40 + 2.0d0

      e227 = b27 - x41 - x42 + 2.0d0

      e228 = b28 - x43 - x44 + 2.0d0

      e229 = b29 - x45 - x46 + 2.0d0

      e230 = b30 - x47 - x48 + 2.0d0

      e231 = b31 - x49 - x50 + 2.0d0

      e232 = b32 - x51 - x52 + 2.0d0

      e233 = b33 - x53 - x54 + 2.0d0

      e234 = b34 - x55 - x56 + 2.0d0

      e235 = b35 - x57 - x58 + 2.0d0

      e236 = b36 - x59 - x60 + 2.0d0

      e237 = (x37 + 5.13435d0*x38)*x61 - x37 + 1000.0d0*b25 - 1000.0d0 

      e238 = (x37 + 5.13435d0*x38)*x62 - 5.13435*x38 + 1000.0d0*b25 
     /       - 1000.0d0            

      e239 = (x39 + 5.13435d0*x40)*x63 - x39 + 1000.0d0*b26 - 1000.0d0 
      
      e240 = (x39 + 5.13435d0*x40)*x64 - 5.13435*x40 + 1000.0d0*b26 
     /       - 1000.0d0            

      e241 = (x41 + 5.13435d0*x42)*x65 - x41 + 1000.0d0*b27 - 1000.0d0

      e242 = (x41 + 5.13435d0*x42)*x66 - 5.13435*x42 + 1000.0d0*b27 
     /       - 1000.0d0            

      e243 = (x43 + 5.13435d0*x44)*x67 - x43 + 1000.0d0*b28 - 1000.0d0

      e244 = (x43 + 5.13435d0*x44)*x68 - 5.13435*x44 + 1000.0d0*b28 
     /       - 1000.0d0            

      e245 = (x45 + 5.13435d0*x46)*x69 - x45 + 1000.0d0*b29 - 1000.0d0

      e246 = (x45 + 5.13435d0*x46)*x70 - 5.13435*x46 + 1000.0d0*b29 
     /       - 1000.0d0            

      e247 = (x47 + 5.13435d0*x48)*x71 - x47 + 1000.0d0*b30 - 1000.0d0

      e248 = (x47 + 5.13435d0*x48)*x72 - 5.13435*x48 + 1000.0d0*b30 
     /       - 1000.0d0            

      e249 = (x49 + 5.13435d0*x50)*x73 - x49 + 1000.0d0*b31 - 1000.0d0

      e250 = (x49 + 5.13435d0*x50)*x74 - 5.13435*x50 + 1000.0d0*b31 
     /       - 1000.0d0            

      e251 = (x51 + 5.13435d0*x52)*x75 - x51 + 1000.0d0*b32 - 1000.0d0

      e252 = (x51 + 5.13435d0*x52)*x76 - 5.13435*x52 + 1000.0d0*b32 
     /       - 1000.0d0            

      e253 = (x53 + 5.13435d0*x54)*x77 - x53 + 1000.0d0*b33 - 1000.0d0

      e254 = (x53 + 5.13435d0*x54)*x78 - 5.13435*x54 + 1000.0d0*b33 
     /       - 1000.0d0            

      e255 = (x55 + 5.13435d0*x56)*x79 - x55 + 1000.0d0*b34 - 1000.0d0

      e256 = (x55 + 5.13435d0*x56)*x80 - 5.13435*x56 + 1000.0d0*b34 
     /       - 1000.0d0            

      e257 = (x57 + 5.13435d0*x58)*x81 - x57 + 1000.0d0*b35 - 1000.0d0

      e258 = (x57 + 5.13435d0*x58)*x82 - 5.13435*x58 + 1000.0d0*b35
     /        - 1000.0d0            

      e259 = (x59 + 5.13435d0*x60)*x83 - x59 + 1000.0d0*b36 - 1000.0d0

      e260 = (x59 + 5.13435d0*x60)*x84 - 5.13435*x60 + 1000.0d0*b36 
     /       - 1000.0d0            

      e261 = (x37 + 5.13435d0*x38)*x61 - x37 - 1000.0d0*b25 + 1000.0d0 

      e262 = (x37 + 5.13435d0*x38)*x62 - 5.13435*x38 - 1000.0d0*b25 
     /       + 1000.0d0           

      e263 = (x39 + 5.13435d0*x40)*x63 - x39 - 1000.0d0*b26 + 1000.0d0 

      e264 = (x39 + 5.13435d0*x40)*x64 - 5.13435*x40 - 1000.0d0*b26 
     /       + 1000.0d0           

      e265 = (x41 + 5.13435d0*x42)*x65 - x41 - 1000.0d0*b27 + 1000.0d0 

      e266 = (x41 + 5.13435d0*x42)*x66 - 5.13435*x42 - 1000.0d0*b27 
     /       + 1000.0d0           

      e267 = (x43 + 5.13435d0*x44)*x67 - x43 - 1000.0d0*b28 + 1000.0d0 

      e268 = (x43 + 5.13435d0*x44)*x68 - 5.13435*x44 - 1000.0d0*b28 
     /       + 1000.0d0           

      e269 = (x45 + 5.13435d0*x46)*x69 - x45 - 1000.0d0*b29 + 1000.0d0 

      e270 = (x45 + 5.13435d0*x46)*x70 - 5.13435*x46 - 1000.0d0*b29 
     /       + 1000.0d0           

      e271 = (x47 + 5.13435d0*x48)*x71 - x47 - 1000.0d0*b30 + 1000.0d0 

      e272 = (x47 + 5.13435d0*x48)*x72 - 5.13435*x48 - 1000.0d0*b30 
     /       + 1000.0d0           

      e273 = (x49 + 5.13435d0*x50)*x73 - x49 - 1000.0d0*b31 + 1000.0d0 

      e274 = (x49 + 5.13435d0*x50)*x74 - 5.13435*x50 - 1000.0d0*b31 
     /       + 1000.0d0           

      e275 = (x51 + 5.13435d0*x52)*x75 - x51 - 1000.0d0*b32 + 1000.0d0 

      e276 = (x51 + 5.13435d0*x52)*x76 - 5.13435*x52 - 1000.0d0*b32 
     /       + 1000.0d0           

      e277 = (x53 + 5.13435d0*x54)*x77 - x53 - 1000.0d0*b33 + 1000.0d0 

      e278 = (x53 + 5.13435d0*x54)*x78 - 5.13435*x54 - 1000.0d0*b33 
     /       + 1000.0d0           

      e279 = (x55 + 5.13435d0*x56)*x79 - x55 - 1000.0d0*b34 + 1000.0d0 

      e280 = (x55 + 5.13435d0*x56)*x80 - 5.13435*x56 - 1000.0d0*b34 
     /       + 1000.0d0           

      e281 = (x57 + 5.13435d0*x58)*x81 - x57 - 1000.0d0*b35 + 1000.0d0 

      e282 = (x57 + 5.13435d0*x58)*x82 - 5.13435*x58 - 1000.0d0*b35 
     /       + 1000.0d0           

      e283 = (x59 + 5.13435d0*x60)*x83 - x59 - 1000.0d0*b36 + 1000.0d0 

      e284 = (x59 + 5.13435d0*x60)*x84 - 5.13435*x60 - 1000.0d0*b36 
     /       + 1000.0d0  
 
      g(1) = e33
      g(2) = e34
      g(3) = e100
      g(4) = e101
      g(5) = e102
      g(6) = e103
      g(7) = -e1
      g(8) = -e2
      g(9) = -e3
      g(10) = -e4
      g(11) = -e5
      g(12) = -e6
      g(13) = -e7
      g(14) = -e8
      g(15) = -e9
      g(16) = -e10
      g(17) = -e11
      g(18) = -e12
      g(19) = -e13
      g(20) = -e14
      g(21) = -e15
      g(22) = -e16
      g(23) = -e17
      g(24) = -e18
      g(25) = -e19
      g(26) = -e20
      g(27) = -e21
      g(28) = -e22
      g(29) = -e23
      g(30) = -e24
      g(31) = -e25
      g(32) = -e26
      g(33) = -e27
      g(34) = -e28
      g(35) = -e29
      g(36) = -e30
      g(37) = -e31
      g(38) = -e32
      g(39) = e35
      g(40) = e36
      g(41) = e37
      g(42) = e38
      g(43) = e39
      g(44) = e40
      g(45) = e41
      g(46) = e42
      g(47) = e43
      g(48) = e44
      g(49) = e45
      g(50) = e46
      g(51) = e47
      g(52) = e48
      g(53) = e49
      g(54) = e50
      g(55) = e51
      g(56) = e52
      g(57) = e53
      g(58) = e54
      g(59) = -e55
      g(60) = -e56
      g(61) = -e57
      g(62) = -e58
      g(63) = -e59
      g(64) = -e60
      g(65) = -e61
      g(66) = -e62
      g(67) = -e63
      g(68) = -e64
      g(69) = -e65
      g(70) = -e66
      g(71) = -e67
      g(72) = -e68
      g(73) = -e69
      g(74) = -e70
      g(75) = -e71
      g(76) = -e72
      g(77) = -e73
      g(78) = -e74
      g(79) = -e75
      g(80) = -e76
      g(81) = e77
      g(82) = e78
      g(83) = e79
      g(84) = e80
      g(85) = e81
      g(86) = e82
      g(87) = e83
      g(88) = e84
      g(89) = e85
      g(90) = e86
      g(91) = e87
      g(92) = e88
      g(93) = e89
      g(94) = e90
      g(95) = e91
      g(96) = e92
      g(97) = e93
      g(98) = e94
      g(99) = e95
      g(100) = e96
      g(101) = e97
      g(102) = e98
      g(103) = -e105
      g(104) = -e106
      g(105) = -e107
      g(106) = -e108
      g(107) = -e109
      g(108) = -e110
      g(109) = -e111
      g(110) = -e112
      g(111) = -e113
      g(112) = -e114
      g(113) = -e115
      g(114) = -e116
      g(115) = -e117
      g(116) = -e118
      g(117) = -e119
      g(118) = -e120
      g(119) = -e121
      g(120) = -e122
      g(121) = -e123
      g(122) = -e124
      g(123) = -e125
      g(124) = -e126
      g(125) = -e127
      g(126) = -e128
      g(127) = -e129
      g(128) = -e130
      g(129) = -e131
      g(130) = -e132
      g(131) = -e133
      g(132) = -e134
      g(133) = -e135
      g(134) = -e136
      g(135) = -e137
      g(136) = -e138
      g(137) = -e139
      g(138) = -e140
      g(139) = -e141
      g(140) = -e142
      g(141) = -e143
      g(142) = -e144
      g(143) = -e145
      g(144) = -e146
      g(145) = -e147
      g(146) = -e148
      g(147) = -e149
      g(148) = -e150
      g(149) = -e151
      g(150) = -e152
      g(151) = -e153
      g(152) = -e154
      g(153) = -e155
      g(154) = -e156
      g(155) = -e157
      g(156) = -e158
      g(157) = -e159
      g(158) = -e160
      g(159) = -e161
      g(160) = -e162
      g(161) = -e163
      g(162) = -e164
      g(163) = -e165
      g(164) = -e166
      g(165) = -e167
      g(166) = -e168
      g(167) = -e169
      g(168) = -e170
      g(169) = -e171
      g(170) = -e172
      g(171) = -e173
      g(172) = -e174
      g(173) = -e175
      g(174) = -e176
      g(175) = -e177
      g(176) = -e178
      g(177) = -e179
      g(178) = -e180
      g(179) = -e181
      g(180) = -e182
      g(181) = -e183
      g(182) = -e184
      g(183) = -e185
      g(184) = -e186
      g(185) = -e187
      g(186) = -e188
      g(187) = e189
      g(188) = e190
      g(189) = e191
      g(190) = e192
      g(191) = e193
      g(192) = e194
      g(193) = e195
      g(194) = e196
      g(195) = e197
      g(196) = e198
      g(197) = e199
      g(198) = e200
      g(199) = e201
      g(200) = e202
      g(201) = e203
      g(202) = e204
      g(203) = e205
      g(204) = e206
      g(205) = e207
      g(206) = e208
      g(207) = e209
      g(208) = e210
      g(209) = e211
      g(210) = e212
      g(211) = e213
      g(212) = e214
      g(213) = e215
      g(214) = e216
      g(215) = e217
      g(216) = e218
      g(217) = e219
      g(218) = e220
      g(219) = e221
      g(220) = e222
      g(221) = e223
      g(222) = e224
      g(223) = e225
      g(224) = e226
      g(225) = e227
      g(226) = e228
      g(227) = e229
      g(228) = e230
      g(229) = e231
      g(230) = e232
      g(231) = e233
      g(232) = e234
      g(233) = e235
      g(234) = e236
      g(235) = -e237
      g(236) = -e238
      g(237) = -e239
      g(238) = -e240
      g(239) = -e241
      g(240) = -e242
      g(241) = -e243
      g(242) = -e244
      g(243) = -e245
      g(244) = -e246
      g(245) = -e247
      g(246) = -e248
      g(247) = -e249
      g(248) = -e250
      g(249) = -e251
      g(250) = -e252
      g(251) = -e253
      g(252) = -e254
      g(253) = -e255
      g(254) = -e256
      g(255) = -e257
      g(256) = -e258
      g(257) = -e259
      g(258) = -e260
      g(259) = e261
      g(260) = e262
      g(261) = e263
      g(262) = e264
      g(263) = e265
      g(264) = e266
      g(265) = e267
      g(266) = e268
      g(267) = e269
      g(268) = e270
      g(269) = e271
      g(270) = e272
      g(271) = e273
      g(272) = e274
      g(273) = e275
      g(274) = e276
      g(275) = e277
      g(276) = e278
      g(277) = e279
      g(278) = e280
      g(279) = e281
      g(280) = e282
      g(281) = e283
      g(282) = e284

  999 continue
      return
      end
 

      subroutine floudas1( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS1'
         pref  = '\cite{Flou99}'
         fex   = 0.76671801d+1
         ncont = 2
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 5
         me    = 2
         do i=1,ncont
            xl(i) = 0.0001d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         enddo
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(nint+i) = x(ncont+i)
      enddo
 
      f = 2.0d0*x(1) + 3.0d0*x(2) + 1.5D0*y(1) + 2.0d0*y(2) 
     /    - 0.5d0*y(3)

      g(1) = x(1)**2 + y(1) - 1.25d0
 
      g(2) = x(2)**1.5d0 + 1.5d0*y(2) - 3.0d0
 
      g(3) = 1.6d0 - x(1) - y(1)
 
      g(4) = 3.0d0 - 1.333d0*x(2) - y(2)
 
      g(5) = y(1) + y(2) - y(3)

  999 continue
      return
      end

      subroutine floudas2( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS2'
         pref  = '\cite{Flou99}'
         fex   = 0.107654d+1
         ncont = 2
         nint  = 0
         nbin  = 1
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         x(1)  = 0.2d0
         xl(1) = 0.2d0
         xu(1) = 1.0d0
         x(2)  = -1.5d0
         xl(2) = -2.22554d0
         xu(2) = -1.0d0
         xl(3) = 0.0d0
         x(3)  = 1.0d0
         xu(3) = 1.0d0
         goto 999       
      endif

      do i=1,nbin
         y(nint+i) = x(ncont+i)
      enddo
 
      f = -0.7d0*y(1) + 5.0d0*(x(1) - 0.5d0)**2 + 0.8d0

      g(1) = dexp(x(1)-0.2d0) + x(2)
 
      g(2) = -1.0d0 - x(2) - 1.1d0*y(1)
 
      g(3) = 0.2d0 - x(1) + 1.2d0*y(1)

  999 continue
      return
      end

      subroutine floudas3( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS3'
         pref  = '\cite{Flou99}'
         fex   = 0.45795825d+1
         ncont = 3
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0D+7
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo
 
      f = (y(1) - 1.0d0)**2 + (y(2) - 2.0d0)**2 + (y(3) - 1.0d0)**2
     /    - dlog(y(4) + 1.0d0) + (x(1) - 1.0d0)**2 
     /    + (x(2) - 2.0d0)**2 + (x(3) - 3.0d0)**2

      g(1) = 5.0d0 - y(1) - y(2) - y(3) - x(1) - x(2) - x(3)
 
      g(2) = 5.5d0 - y(3)**2 - x(1)**2 - x(2)**2 - x(3)**2
 
      g(3) = 1.2d0 - y(1) - x(1)
 
      g(4) = 1.8d0 - y(2) - x(2)
 
      g(5) = 2.5d0 - y(3) - x(3)
 
      g(6) = 1.2d0 - y(4) - x(1)
 
      g(7) = 1.64d0 - y(2)**2 - x(2)**2
 
      g(8) = 4.25d0 - y(3)**2 - x(3)**2
 
      g(9) = 4.64d0 - y(2)**2 - x(3)**2

  999 continue
      return
      end

      subroutine floudas4( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), xlog
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS4'
         pref  = '\cite{Flou99}'
         fex   = -0.94635942D+0
         ncont = 3
         nint  = 0
         nbin  = 8
         n     = ncont + nbin + nint
         m     = 7
         me    = 3
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.9d0
            xu(i) = 0.999d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo
 
      f = -x(1)*x(2)*x(3)     

      g(1) = xlog(1.0d0 - x(1)) - dlog(0.1d0)*y(1) 
     /       - dlog(0.2d0)*y(2) - dlog(0.15d0)*y(3)
 
      g(2) = xlog(1.0d0 - x(2)) - dlog(0.05d0)*y(4) 
     /       - dlog(0.2d0)*y(5) - dlog(0.15d0)*y(6)
 
      g(3) = xlog(1.0d0 - x(3)) - dlog(0.02d0)*y(7)
     /       - dlog(0.06d0)*y(8)
     
      g(4) = y(1) + y(2) + y(3) - 1.0d0
 
      g(5) = y(4) + y(5) + y(6) - 1.0d0
 
      g(6) = y(7) + y(8) - 1.0d0
 
      g(7) = -(3.0d0*y(1) + y(2) + 2.0d0*y(3) + 3.0d0*y(4) 
     /       + 2.0d0*y(5) + y(6) + 3.0d0*y(7) + 2.0d0*y(8)) + 10.0d0

  999 continue
      return
      end

      subroutine floudas40( mode,     m,     me,  mmax, ncont,  
     /                      nbin,  nint,   nmax,     x,    xl,
     /                        xu,     f,      g,  pnam,  pref,
     /                       fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS40'
         pref  = '\cite{Flou99}'
c         fex   = -0.94347050d0   
         fex   = -0.93159d0
         ncont = 3
         nint  = 0
         nbin  = 8
         n     = ncont + nbin + nint
         m     = 7
         me    = 3
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.9d0
            xu(i) = 0.999d0
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do
 
      f = -x(1)*x(2)*x(3)     

      g(1) = 1.0d0 - x(1) - 0.1d0**y(1)*0.2d0**y(2)*0.15d0**y(3)
 
      g(2) = 1.0d0 - x(2) - 0.05d0**y(4)*0.2d0**y(5)*0.15d0**y(6)
 
      g(3) = 1.0d0 - x(3) - 0.02d0**y(7)*0.06d0**y(8)
     
      g(4) = y(1) + y(2) + y(3) - 1.0d0
 
      g(5) = y(4) + y(5) + y(6) - 1.0d0
 
      g(6) = y(7) + y(8) - 1.0d0
 
      g(7) = -(3.0d0*y(1) + y(2) + 2.0d0*y(3) + 3.0d0*y(4) 
     /       + 2.0d0*y(5) + y(6) + 3.0d0*y(7) + 2.0d0*y(8)) + 10.0d0

  999 continue
      return
      end

      subroutine floudas5( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS5'
         pref  = '\cite{Flou99}'
         fex   = 31.0d+0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i=1,nint
            xl(i) = 1.0d0
            x(i)  = 2.0d0
            xu(i) = 5.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo
 
      f = 7.0d0*y(1) + 10.0d0*y(2)

      g(1) = -24.0d0 - y(1)**1.2D0*y(2)**1.7D0 + 7.0d0*y(1) + 9.0d0*y(2)
 
      g(2) = 5.0d0 + y(1) + 2.0d0*y(2)
 
      g(3) = 1.0d0 + 3.0d0*y(1) - y(2)
 
      g(4) = 11.0d0 - 4.0d0*y(1) + 3.0d0*y(2)

  999 continue
      return
      end

      subroutine floudas6( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FLOUDAS6'
         pref  = '\cite{Flou99}'
         fex   = -17.0d+0
         ncont = 1
         nint  = 1
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         xl(1) = 1.0d0
         x(1)  = 3.0d0
         xu(1) = 10.0d0
         xl(2) = 1.0d0
         x(2)  = 3.0d0
         xu(2) = 6.0d0
         goto 999       
      endif

      y(1) = x(2)
 
      f = 3.0d0*y(1) - 5.0d0*x(1)

      g(1) = 39.0d0 - 2.0d0*y(1)**2 + 2.0d0*y(1)**0.5d0
     /       + 2.0d0*x(1)**0.5D0*y(1)**2 - 11.0d0*y(1) - 8.0d0*x(1)

      g(2) = 3.0d0 + y(1) - x(1)

      g(3) = 24.0d0 - 2.0d0*y(1) - 3.0d0*x(1)

  999 continue
      return
      end
         
      subroutine fstufen( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:35:04
*  
*  Equation counts
*     Total       E       G       L       N       X
*        99      95       4       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       150     102      48       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       319     232      87       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, xlog, 
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10, 
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, 
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, 
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, 
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, 
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, 
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, 
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, 
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, 
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99 
      double precision 
     /         x1,  x2, x3,   x4,  x5,  x6,  x7,  x8,  x9, x10, 
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, 
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30, 
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40, 
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50, 
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60, 
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70, 
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80, 
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90, 
     /        x91, x92, x93, x94, x95, b96, b97, b98, b99, b100,   
     /        b101,b102,b103,b104,b105,b106,b107,b108,b109,b110, 
     /        b111,b112,b113,b114,b115,b116,b117,b118,b119,b120, 
     /        b121,b122,b123,b124,b125,b126,b127,b128,b129,b130, 
     /        b131,b132,b133,b134,b135,b136,b137,b138,b139,b140, 
     /        b141,b142,b143,x145,x146,x147,x148,x149,x150
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = '4STUFEN'
         pref  = '\cite{MINLPLib}'
         fex   = 116329.7d0
c         fex   = fex*1.0d-5
         ncont = 102
         nint  = 0
         nbin  = 48
         n     = ncont + nbin + nint
         m     = 98
         me    = 94
         do i = 1,ncont
            xl(i) = -1.0d7
            x(i)  = 1.0d0
            xu(i) = 1.0d7
         end do
         xl(1) = 10.0d0
         xl(2) = 0.0d0
         xl(3) = 1.0d0 
         xl(4) = 1.0d0 
         xl(5) = 2.0d0 
         xl(6) = 1.0d0 
         xl(7) = 0.1675d0
         xl(8) = 0.0d0
         xl(9) = 0.0d0
         xl(10) = 0.0d0
         xl(11) = 0.0d0
         xl(12) = 5.0d0 
         xl(13) = 5.0d0 
         xl(14) = 5.0d0 
         xl(15) = 5.0d0 
         xl(16) = 1.0d0 
         xl(17) = 1.0d0 
         xl(18) = 1.0d0 
         xl(19) = 1.0d0 
         do i=20,27
            xl(i) = 0.0d0
         end do  
         xl(28) = 0.00001d0 
         xl(29) = 0.00001d0 
         xl(30) = 0.00001d0 
         xl(31) = 0.00001d0 
         xl(32) = 1.0d0 
         xl(33) = 1.0d0 
         xl(34) = 1.0d0 
         xl(35) = 1.0d0 
         xl(36) = 1.0d0 
         xl(37) = 1.0d0 
         xl(38) = 1.0d0 
         xl(39) = 1.0d0 
         xl(40) = 1.0d0 
         xl(41) = 1.0d0 
         xl(42) = 1.0d0 
         xl(43) = 1.0d0 
         xl(44) = 0.01d0 
         xl(45) = 0.01d0 
         xl(46) = 0.01d0 
         xl(47) = 0.01d0 
         xl(48) = 2.0d0 
         xu(48) = 6.0d0 
         xl(49) = 2.0d0
         xu(49) = 6.0d0 
         xl(50) = 2.0d0
         xu(50) = 6.0d0 
         xl(51) = 2.0d0
         xu(51) = 6.0d0 
         xl(52) = 1.26d0
         xu(52) = 6.0d0 
         xl(53) = 1.26d0 
         xu(53) = 6.0d0 
         xl(54) = 1.26d0 
         xu(54) = 6.0d0 
         xl(55) = 1.26d0 
         xu(55) = 6.0d0 
         xl(56) = 1.13d-5 
         xl(57) = 1.13d-5 
         xl(58) = 1.13d-5 
         xl(59) = 1.13d-5 
         xl(60) = 2.9d-7 
         xl(61) = 2.9d-7 
         xl(62) = 2.9d-7 
         xl(63) = 2.9d-7 
         xl(64) = 3.0d-7 
         xl(65) = 3.0d-7 
         xl(66) = 3.0d-7 
         xl(67) = 3.0d-7 
         xl(68) = 3.0d-7 
         xl(69) = 3.0d-7 
         xl(70) = 3.0d-7 
         xl(71) = 3.0d-7 
         xl(72) = 0.05d0 
         xl(73) = 0.05d0 
         xl(74) = 0.05d0 
         xl(75) = 0.05d0  
         do i=76,95
            xl(i) = 0.0d0
         end do  
         do i=145,150
            xl(i) = 0.0d0
         end do           
         x(1) = 36.344d0 
         x(2) = 1763.656d0 
         x(3) = 3.042d0 
         x(4) = 10.808d0 
         x(5) = 216.161d0 
         x(6) = 1.225d0 
         x(7) = 2.542d0 
         x(8) = 1800.0d0 
         x(9) = 241.731d0 
         x(10) = 158.011d0 
         x(11) = 88.847d0 
         x(13) = 18.176d0 
         x(14) = 26.048d0 
         x(15) = 43.416d0 
         x(16) = 241.731d0 
         x(17) = 158.011d0 
         x(18) = 88.847d0 
         x(19) = 36.344d0 
         x(20) = 18.176d0 
         x(21) = 26.048d0 
         x(22) = 43.416d0 
         x(23) = 100.0d0 
         x(24) = 1558.269d0 
         x(25) = 83.72d0 
         x(26) = 69.163d0 
         x(27) = 52.503d0 
         x(28) = 2.956d0 
         x(29) = 3.317d0 
         x(30) = 3.737d0 
         x(31) = 4.248d0 
         x(32) = 176.503d0 
         x(33) = 10.861d0 
         x(34) = 11.542d0 
         x(35) = 17.256d0 
         x(40) = 176.572d0 
         x(41) = 154.169d0 
         x(42) = 119.85d0 
         x(43) = 60.852d0 
         x(44) = 147.804d0 
         x(45) = 165.863d0 
         x(46) = 186.858d0 
         x(47) = 212.397d0 
         x(48) = 4.0d0 
         x(49) = 4.0d0 
         x(50) = 4.0d0 
         x(51) = 4.0d0 
         x(52) = 3.0d0 
         x(53) = 3.0d0 
         x(54) = 3.0d0 
         x(55) = 3.0d0 
         x(56) = 2.1769d-5 
         x(57) = 2.1769d-5 
         x(58) = 2.1769d-5 
         x(59) = 2.1769d-5 
         x(60) = 1.299d0 
         x(61) = 1.642d0 
         x(62) = 2.167d0 
         x(63) = 3.069d0 
         x(64) = 1.3d0 
         x(65) = 1.643d0 
         x(66) = 2.169d0 
         x(67) = 3.072d0 
         x(68) = 0.001d0 
         x(69) = 0.001d0 
         x(70) = 0.002d0 
         x(71) = 0.002d0 
         x(72) = 8.825d0 
         x(73) = 0.543d0 
         x(74) = 0.577d0 
         x(75) = 0.863d0 
         x(76) = 1121.796d0 
         x(77) = 1121.796d0 
         x(78) = 1121.796d0 
         x(79) = 1121.796d0 
         x(80) = 198000.0d0*1.0d-5 
         x(81) = 12183.696d0*1.0d-5 
         x(82) = 12947.373d0*1.0d-5 
         x(83) = 19357.594d0*1.0d-5 
         x(84) = 0.2d0 
         x(85) = 0.027d0 
         x(86) = 0.018d0 
         x(87) = 0.01d0 
         x(88) = 1.1d0 
         x(89) = 0.068d0 
         x(90) = 0.072d0 
         x(91) = 0.108d0 
         x(92) = 2.063d0 
         x(93) = 0.15d0 
         x(94) = 0.142d0 
         x(95) = 0.186d0 
         do i=1,ncont
            if (x(i).lt.xl(i)) x(i) = xl(i)
            if (x(i).gt.xu(i)) x(i) = xu(i)
         end do
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      x73 = x(73)
      x74 = x(74)
      x75 = x(75)
      x76 = x(76)
      x77 = x(77)
      x78 = x(78)
      x79 = x(79)
      x80 = x(80)
      x81 = x(81)
      x82 = x(82)
      x83 = x(83)
      x84 = x(84)
      x85 = x(85)
      x86 = x(86)
      x87 = x(87)
      x88 = x(88)
      x89 = x(89)
      x90 = x(90)
      x91 = x(91)
      x92 = x(92)
      x93 = x(93)
      x94 = x(94)
      x95 = x(95)
      x145 = x(96)
      x146 = x(97)
      x147 = x(98)
      x148 = x(99)
      x149 = x(100)
      x150 = x(101)
      b96 = y(1)
      b97 = y(2)
      b98 = y(3)
      b99 = y(4)
      b100 = y(5)
      b101 = y(6)
      b102 = y(7)
      b103 = y(8)
      b104 = y(9)
      b105 = y(10)
      b106 = y(11)
      b107 = y(12)
      b108 = y(13)
      b109 = y(14)
      b110 = y(15)
      b111 = y(16)
      b112 = y(17)
      b113 = y(18)
      b114 = y(19)
      b115 = y(20)
      b116 = y(21)
      b117 = y(22)
      b118 = y(23)
      b119 = y(24)
      b120 = y(25)
      b121 = y(26)
      b122 = y(27)
      b123 = y(28)
      b124 = y(29)
      b125 = y(30)
      b126 = y(31)
      b127 = y(32)
      b128 = y(33)
      b129 = y(34)
      b130 = y(35)
      b131 = y(36)
      b132 = y(37)
      b133 = y(38)
      b134 = y(39)
      b135 = y(40)
      b136 = y(41)
      b137 = y(42)
      b138 = y(43)
      b139 = y(44)
      b140 = y(45)
      b141 = y(46)
      b142 = y(47)
      b143 = y(48)
C  
      f = 3271.22725820856d0 + x145 + x146 + x147 + x148 + x149 + x150 
c      f = f*1.0d-5

      e2 = x8 - 1800.0d0
      
      e3 = x12 - 5.0d0
      
      e4 = x2 - x24 - x25 - x26 - x27
      
      e5 = -(x28*x24 + x29*x25 + x30*x26 + x31*x27)/x2 + x3 
      
      e6 = x1 - x19 
      
      e7 = x23 - 100.0d0
      
      e8 = x9 - x16 
      
      e9 = x13 - x20 
      
      e10 = x5 - x32 - x33 - x34 - x35 
      
      e11 = x6 - x36 - x37 - x38 - x39 
      
      e12 = x7 - x92 - x93 - x94 - x95 
      
      e13 = x4 - x72 - x73 - x74 - x75 
      
      e14 = x10 - x17 
      
      e15 = x14 - x21 
      
      e16 = x11 - x18 
      
      e17 = x15 - x22 
 
      e18 = 2.77777777777778d0*x40
     /        /xlog((x44 - x28)/(x20 - x28)) - x56 
      
      e19 = 2.77777777777778d0*x41
     /        /xlog((x45 - x29)/(x21 - x29)) - x57 
      
      e20 = 2.77777777777778d0*x42
     /        /xlog((x46 - x30)/(x22 - x30)) - x58 
      
      e21 = 2.77777777777778d0*x43
     /       /xlog((x47 - x31)/(x23 - x31)) - x59 
     
      e22 = 50.0d0*x28 - x44 
    
      e23 = 50.0d0*x29 - x45 
    
      e24 = 50.0d0*x30 - x46 
    
      e25 = 50.0d0*x31 - x47 
    
      e26 = x40 - 65.38084341288d0*x48 + 65.38084341288d0*x60 
    
      e27 = x41 - 65.38084341288d0*x49 + 65.38084341288d0*x61 
    
      e28 = x42 - 65.38084341288d0*x50 + 65.38084341288d0*x62 
    
      e29 = x43 - 65.38084341288d0*x51 + 65.38084341288d0*x63 
    
      e30 = - x60 + x64 - x68 
    
      e31 = - x61 + x65 - x69 
    
      e32 = - x62 + x66 - x70 
    
      e33 = - x63 + x67 - x71 
    
      e34 = - 1d-5*(12.09d0*sqr(x44) + 3.66d0*x44 - 0.08d0*x44**3 
     /      + 0.0002592d0*x44**4) + x64 
    
      e35 = - 1d-5*(12.09d0*sqr(x45) + 3.66d0*x45 - 0.08d0*x45**3 
     /      + 0.0002592d0*x45**4) + x65 
    
      e36 = - 1d-5*(12.09d0*sqr(x46) + 3.66d0*x46 - 0.08d0*x46**3 
     /      + 0.0002592d0*x46**4) + x66 
    
      e37 = - 1d-5*(12.09d0*sqr(x47) + 3.66d0*x47 - 0.08d0*x47**3 
     /      + 0.0002592d0*x47**4) + x67 
    
      e38 = - 1d-5*(12.09d0*sqr(x28) + 3.66d0*x28 - 0.08d0*x28**3 
     /      + 0.0002592d0*x28**4) + x68 
    
      e39 = - 1d-5*(12.09d0*sqr(x29) + 3.66d0*x29 - 0.08d0*x29**3 
     /      + 0.0002592d0*x29**4) + x69 
    
      e40 = - 1d-5*(12.09d0*sqr(x30) + 3.66d0*x30 - 0.08d0*x30**3 
     /      + 0.0002592d0*x30**4) + x70 
    
      e41 = - 1d-5*(12.09d0*sqr(x31) + 3.66d0*x31 - 0.08d0*x31**3 
     /      + 0.0002592d0*x31**4) + x71 
    
      e42 = - 1.13572384718704d-1*(7936.50793650794d0*x52)**0.75 + x56 
    
      e43 = - 1.13572384718704d-1*(7936.50793650794d0*x53)**0.75 + x57 
    
      e44 = - 1.13572384718704d-1*(7936.50793650794d0*x54)**0.75 + x58 
    
      e45 = - 1.13572384718704d-1*(7936.50793650794d0*x55)**0.75 + x59 
    
      e46 = - x8 + x16 + x24 
    
      e47 = - x9 + x17 + x25 
    
      e48 = - x10 + x18 + x26 
    
      e49 = - x11 + x19 + x27 
    
      e50 = x12*x8 - (x20*x16 + x28*x24) 
    
      e51 = x13*x9 - (x21*x17 + x29*x25) 
    
      e52 = x14*x10 - (x22*x18 + x30*x26) 
    
      e53 = x15*x11 - (x23*x19 + x31*x27) 
    
      e54 = - 2.77777777777778d-5*x48*x8 + x84 
    
      e55 = - 2.77777777777778d-5*x49*x9 + x85 
    
      e56 = - 2.77777777777778d-5*x50*x10 + x86 
    
      e57 = - 2.77777777777778d-5*x51*x11 + x87 
    
      e58 = - x24/x40 + x72 
    
      e59 = - x25/x41 + x73 
    
      e60 = - x26/x42 + x74 
    
      e61 = - x27/x43 + x75 
    
      e62 = x32 - 20.0d0*x72 
    
      e63 = x33 - 20.0d0*x73 
    
      e64 = x34 - 20.0d0*x74 
    
      e65 = x35 - 20.0d0*x75 
    
      e66 = - 373.932d0*x52 + x76 
    
      e67 = - 373.932d0*x53 + x77 
    
      e68 = - 373.932d0*x54 + x78 
    
      e69 = - 373.932d0*x55 + x79 
    
      e70 = - x32*x76 + x80*1.0d5 
    
      e71 = - x33*x77 + x81*1.0d5 
    
      e72 = - x34*x78 + x82*1.0d5 
    
      e73 = - x35*x79 + x83*1.0d5 
    
      e74 = - 5.55555555555556d-6*x80*1.0d5 + x88 
   
      e75 = - 5.55555555555556d-6*x81*1.0d5 + x89 
    
      e76 = - 5.55555555555556d-6*x82*1.0d5 + x90 
    
      e77 = - 5.55555555555556d-6*x83*1.0d5 + x91 
    
      e78 = - 1.58730158730159d0*x84 - 1.58730158730159d0*x88 + x92 
    
      e79 = - 1.58730158730159d0*x85 - 1.58730158730159d0*x89 + x93 
    
      e80 = - 1.58730158730159d0*x86 - 1.58730158730159d0*x90 + x94 
    
      e81 = - 1.58730158730159d0*x87 - 1.58730158730159d0*x91 + x95 
    
      e82 = x36 - 0.909090909090909d0*x88 
    
      e83 = x37 - 0.909090909090909d0*x89 
    
      e84 = x38 - 0.909090909090909d0*x90 
    
      e85 = x39 - 0.909090909090909d0*x91 
    
      e86 = x32 - b96 - 2.0d0*b100 - 4.0d0*b104 - 8.0d0*b108 
     /      - 16.0d0*b112 - 32.0d0*b116 - 64.0d0*b120 - 128.0d0*b124
    
      e87 = x33 - b97 - 2.0d0*b101 - 4.0d0*b105 - 8.0d0*b109 
     /      - 16.0d0*b113 - 32.0d0*b117 - 64.0d0*b121 - 128.0d0*b125 
    
      e88 = x34 - b98 - 2.0d0*b102 - 4.0d0*b106 - 8.0d0*b110 
     /      - 16.0d0*b114 - 32.0d0*b118 - 64.0d0*b122 - 128.0d0*b126 

      e89 = x35 - b99 - 2.0d0*b103 - 4.0d0*b107 - 8.0d0*b111 
     /      - 16.0d0*b115 - 32.0d0*b119 - 64.0d0*b123 - 128.0d0*b127 

      e90 = x36 - b128 - 2.0d0*b132 - 4.0d0*b136 - 8.0d0*b140 

      e91 = x37 - b129 - 2.0d0*b133 - 4.0d0*b137 - 8.0d0*b141 
      
      e92 = x38 - b130 - 2.0d0*b134 - 4.0d0*b138 - 8.0d0*b142 
  
      e93 = x39 - b131 - 2.0d0*b135 - 4.0d0*b139 - 8.0d0*b143 
  
      e94 = x145 - 5047.03634123606d0
 
      e95 = - 292.07386234005d0*x6 + x146 
  
      e96 = - 2103.94993266178d0*x7 + x149 
  
      e97 = - 45.7380420143865d0*x2 + x147 
  
      e98 = - 4.57380420143865d0*x2*x3 + x148 
  
      e99 = - 764.973851088085d0*x4 + x150 
C
      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = e7
      g(7) = e8
      g(8) = e9
      g(9) = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e18
      g(18) = e19
      g(19) = e20
      g(20) = e21
      g(21) = e22
      g(22) = e23
      g(23) = e24
      g(24) = e25
      g(25) = e26
      g(26) = e27
      g(27) = e28
      g(28) = e29
      g(29) = e30
      g(30) = e31
      g(31) = e32
      g(32) = e33
      g(33) = e34
      g(34) = e35
      g(35) = e36
      g(36) = e37
      g(37) = e38
      g(38) = e39
      g(39) = e40
      g(40) = e41
      g(41) = e42
      g(42) = e43
      g(43) = e44
      g(44) = e45
      g(45) = e46
      g(46) = e47
      g(47) = e48
      g(48) = e49
      g(49) = e50
      g(50) = e51
      g(51) = e52
      g(52) = e53
      g(53) = e54
      g(54) = e55
      g(55) = e56
      g(56) = e57
      g(57) = e58
      g(58) = e59
      g(59) = e60
      g(60) = e61
      g(61) = e62
      g(62) = e63
      g(63) = e64
      g(64) = e65
      g(65) = e66
      g(66) = e67
      g(67) = e68
      g(68) = e69
      g(69) = e70
      g(70) = e71
      g(71) = e72
      g(72) = e73
      g(73) = e74
      g(74) = e75
      g(75) = e76
      g(76) = e77
      g(77) = e78
      g(78) = e79
      g(79) = e80
      g(80) = e81
      g(81) = e86
      g(82) = e87
      g(83) = e88
      g(84) = e89
      g(85) = e90
      g(86) = e91
      g(87) = e92
      g(88) = e93
      g(89) = e94
      g(90) = e95
      g(91) = e96
      g(92) = e97
      g(93) = e98
      g(94) = e99
c      do i=90,94
c         g(i) = g(i)*1.0d-3
c      enddo
      g(95) = e82
      g(96) = e83
      g(97) = e84
      g(98) = e85

  999 continue
      return
      end

      subroutine fuel(  mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:07:24
*  
*  Equation counts
*     Total       E       G       L       N       X
*        16       7       6       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        16      13       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        39      33       6       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), b1, b2, b3, x4, x5, x6, x7, x8, x9, x10, x11,
     /        x12, x13, x14, x15, e2, e3, e4, e5, e6, e7, e8, e9, e10,
     /        e11, e12, e13, e14, e15, e16, sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'FUEL'
         pref  = '\cite{MINLPLib}'
         fex   =  8566.119d0
         ncont = 12
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i=7,11
            xl(i) = 0.0d0
         enddo  
         xl(4)  = 50.0d0 
         x(4)   = 100.0d0 
         xu(4)  = 700.0d0                                    
         xl(5)  = 50.0d0 
         x(5)   = 100.0d0 
         xu(5)  = 700.0d0                                     
         xl(6)  = 50.0d0 
         x(6)   = 100.0d0    
         xu(6)  = 700.0d0                                     
         xu(10) = 4000.0d0   
         xu(11) = 4000.0d0   
         xl(12) = 2000.0d0 
         x(12)  = 2000.0d0
         xu(12) = 4000.0d0
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x4  = x(1)
      x5  = x(2)
      x6  = x(3)
      x7  = x(4)
      x8  = x(5)
      x9  = x(6)
      x10 = x(7)
      x11 = x(8)
      x12 = x(9)
      x13 = x(10)
      x14 = x(11)
      x15 = x(12)
      b1  = y(1)
      b2  = y(2)
      b3  = y(3)

      f = 0.0025d0*sqr(x7) + 6.0d0*x7 + 0.0025d0*sqr(x8) + 6.0d0*x8
     /     + 0.0025d0*sqr(x9) + 6.0d0*x9 + 900.0d0     

      e2 = -100.0d0*b1 + x4                                

      e3 = -100.0d0*b2 + x5                                

      e4 = -100.0d0*b3 + x6                                

      e5 = -500.0d0*b1 + x4                                

      e6 = -500.0d0*b2 + x5                                

      e7 = -500.0d0*b3 + x6                                

      e8 = x10 + x13 - 3500.0d0                         

      e9 = x11 - x13 + x14 - 500.0d0                    

      e10 = x12 - x14 + x15 - 500.0d0                   

      e11 = x4 + x7 - 400.0d0                           

      e12 = x5 + x8 - 900.0d0                           

      e13 = x6 + x9 - 700.0d0                           

      e14 = -(0.005d0*sqr(x4) + x4) - 50.0d0*b1 + x10        

      e15 = -(0.005d0*sqr(x5) + x5) - 50.0d0*b2 + x11        

      e16 = -(0.005d0*sqr(x6) + x6) - 50.0d0*b3 + x12             

      g(1)  = e8
      g(2)  = e9
      g(3)  = e10
      g(4)  = e14
      g(5)  = e15
      g(6)  = e16
      g(7)  = e2
      g(8)  = e3
      g(9)  = e4
      g(10) = -e5
      g(11) = -e6
      g(12) = -e7
      g(13) = e11
      g(14) = e12
      g(15) = e13
      
  999 continue
      return
      end
 

      subroutine gasnet(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:07:30
*  
*  Equation counts
*     Total       E       G       L       N       X
*        70      49      11      10       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        91      81      10       0       0       0       0       0
*  FX     4       4       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       267     137     130       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr,
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, b78, b79, b80,
     /        b81, b82, b83, b84, b85, b86, b87, x88, x89, x90,
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69     
      character*30 pnam, pref
  
      if (mode.eq.0) then
         pnam  = 'GASNET'
         pref  = '\cite{MINLPLib}'
         fex   = 6999382.0d0
         ncont = 80
         nint  = 0
         nbin  = 10
         n     = ncont + nbin + nint
         m     = 69
         me    = 48
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d1
            xu(i) = 1.0d8
         end do
         do i = 1,11
            xl(i) = 2.0d0
            x(i)  = 20.0d0
            xu(i) = 200.0d0
         end do
         do i = 12,33
            xl(i) = 200.0d0
            x(i)  = 500.0d0
            xu(i) = 1000.0d0
         end do
         xl(23) = 500.0d0
         x(23)  = 500.0d0
         xu(23) = 500.0d0
         xl(30) = 600.0d0
         x(30)  = 600.0d0
         xu(30) = 600.0d0
         xl(34) = 300.0d0
         x(34)  = 300.0d0
         xu(34) = 300.0d0
         do i = 35,37
            xl(i) = 4.0d0
            x(i)  = 18.0d0
            xu(i) = 36.0d0
         end do
         do i = 38,45
            xl(i) = 4.0d0
            x(i)  = 10.0d0
            xu(i) = 18.0d0
         end do
         xl(46) = 600.0d0
         x(46)  = 600.0d0
         xu(46) = 600.0d0
         do i = 47,57
            xl(i) = 200.0d0
            x(i)  = 400.0d0
            xu(i) = 600.0d0
         end do
         do i = 58,67
            xl(i) = 1.0d0
            x(i)  = 1.5d0
            xu(i) = 2.0d0
         end do
         do i = 68,77
            xl(i) = 0.0d0
            x(i)  = 1.0d4
            xu(i) = 1.0d8
         enddo
         do i = 78,80
            xl(i) = 0.0d0
            x(i)  = 1.0d6
            xu(i) = 1.0d8
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do	 
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x49 = x(49)
      x50 = x(50)
      x51 = x(51)
      x52 = x(52)
      x53 = x(53)
      x54 = x(54)
      x55 = x(55)
      x56 = x(56)
      x57 = x(57)
      x58 = x(58)
      x59 = x(59)
      x60 = x(60)
      x61 = x(61)
      x62 = x(62)
      x63 = x(63)
      x64 = x(64)
      x65 = x(65)
      x66 = x(66)
      x67 = x(67)
      x68 = x(68)
      x69 = x(69)
      x70 = x(70)
      x71 = x(71)
      x72 = x(72)
      x73 = x(73)
      x74 = x(74)
      x75 = x(75)
      x76 = x(76)
      x77 = x(77)
      x88 = x(78)
      x89 = x(79)
      x90 = x(80)
      b78 = y(1)
      b79 = y(2)
      b80 = y(3)
      b81 = y(4)
      b82 = y(5)
      b83 = y(6)
      b84 = y(7)
      b85 = y(8)
      b86 = y(9)
      b87 = y(10)

      f = x88 + x89 + x90

      e1 = x12 - x24                                

      e2 = x13 - x25                                

      e3 = x14 - x26                                

      e4 = x15 - x27                                

      e5 = x16 - x28                                

      e6 = x17 - x29                                

      e7 = x18 - x30                                

      e8 = x19 - x31                                

      e9 = x20 - x32                                

      e10 = x21 - x33                               

      e11 = x22 - x34                               

      e12 = x1 + x2 + x3 + x4 + x5 + x6 + x7 - 175.0d0

      e13 = x1 + x2 + x3 + x8 + x9 + x10 + x11 - 200.0d0

      e14 = -7.58641d-7*x35**5.33333333333333d0*(sqr(x12) 
     /      - sqr(x24))/sqr(x47) + x1 
     
      e15 = -7.58641d-7*x36**5.33333333333333d0*(sqr(x13) 
     /      - sqr(x25))/sqr(x48) + x2 

      e16 = -7.58641d-7*x37**5.33333333333333d0*(sqr(x14) 
     /      - sqr(x26))/sqr(x49) + x3  

      e17 = -7.58641d-7*x38**5.33333333333333d0*(sqr(x15) 
     /      - sqr(x27))/sqr(x50) + x4  
     
      e18 = -7.58641d-7*x39**5.33333333333333d0*(sqr(x16)
     /      - sqr(x28))/sqr(x51) + x5  
     
      e19 = -7.58641d-7*x40**5.33333333333333d0*(sqr(x17) 
     /      - sqr(x29))/sqr(x52) + x6                       
     /

      e20 = -7.58641d-7*x41**5.33333333333333d0*(sqr(x18) 
     /      - sqr(x30))/sqr(x53) + x7    

      e21 = -7.58641d-7*x42**5.33333333333333d0*(sqr(x19) 
     /      - sqr(x31))/sqr(x54) + x8  

      e22 = -7.58641d-7*x43**5.33333333333333d0*(sqr(x20) 
     /      - sqr(x32))/sqr(x55) + x9 

      e23 = -7.58641d-7*x44**5.33333333333333d0*(sqr(x21) 
     /      - sqr(x33))/sqr(x56) + x10

      e24 = -7.58641d-7*x45**5.33333333333333d0*(sqr(x22) 
     /      - sqr(x34))/sqr(x57) + x11 

      e25 = x46 - 0.005d0*x46*b78 - x47                  

      e26 = x47 - 0.005d0*x47*b79 - x48                  

      e27 = x48 - 0.005d0*x48*b80 - x49                  

      e28 = x49 - 0.005d0*x49*b81 - x50 - x54            

      e29 = x50 - 0.005d0*x50*b82 - x51                  

      e30 = x51 - 0.005d0*x51*b83 - x52                  

      e31 = x52 - 0.005d0*x52*b84 - x53                  

      e32 = x54 - 0.005d0*x54*b85 - x55                  

      e33 = x55 - 0.005d0*x55*b86 - x56                  

      e34 = x56 - 0.005d0*x56*b87 - x57                  

      e35 = -214.9812d0*x47*(x58**0.181587301587302d0 - 1.0d0) + x68

      e36 = -214.9812d0*x48*(x59**0.181587301587302d0 - 1.0d0) + x69

      e37 = -214.9812d0*x49*(x60**0.181587301587302d0 - 1.0d0) + x70

      e38 = -214.9812d0*x50*(x61**0.181587301587302d0 - 1.0d0) + x71

      e39 = -214.9812d0*x54*(x61**0.181587301587302d0 - 1.0d0) + x71

      e40 = -214.9812d0*x51*(x62**0.181587301587302d0 - 1.0d0) + x72

      e41 = -214.9812d0*x52*(x63**0.181587301587302d0 - 1.0d0) + x73

      e42 = -214.9812d0*x53*(x64**0.181587301587302d0 - 1.0d0) + x74

      e43 = -214.9812d0*x55*(x65**0.181587301587302d0 - 1.0d0) + x75

      e44 = -214.9812d0*x56*(x66**0.181587301587302d0 - 1.0d0) + x76

      e45 = -214.9812d0*x57*(x67**0.181587301587302d0 - 1.0d0) + x77

      e46 = x58*x23 - x12                              

      e47 = x59*x24 - x13                              

      e48 = x60*x25 - x14                              

      e49 = x61*x26 - x15                              

      e50 = x61*x26 - x19                              

      e51 = x62*x27 - x16                              

      e52 = x63*x28 - x17                              

      e53 = x64*x29 - x18                              

      e54 = x65*x31 - x20                              

      e55 = x66*x32 - x21                              

      e56 = x67*x33 - x22                              

      e57 = x58 - b78 - 1.0d0               

      e58 = x59 - b79 - 1.0d0               

      e59 = x60 - b80 - 1.0d0               

      e60 = x61 - b81 - 1.0d0               

      e61 = x62 - b82 - 1.0d0               

      e62 = x63 - b83 - 1.0d0               

      e63 = x64 - b84 - 1.0d0               

      e64 = x65 - b85 - 1.0d0               

      e65 = x66 - b86 - 1.0d0               

      e66 = x67 - b87 - 1.0d0               

      e67 = -(870.0d0*x1*x35 + 870.0d0*x2*x36 + 870.0d0*x3*x37 
     /      + 870.0d0*x4*x38 + 870.0d0*x5*x39 + 870.0d0*x6*x40 
     /      + 870.0d0*x7*x41 + 870.0d0*x8*x42 + 870.0d0*x9*x43 
     /      + 870.0d0*x10*x44 + 870.0d0*x11*x45) + x88  

      e68 = -70.0d0*x68 - 70.0d0*x69 - 70.0d0*x70 - 70.0d0*x71 
     /      - 70.0d0*x72 - 70.0d0*x73 - 70.0d0*x74 - 70.0d0*x75      
     /      - 70.0d0*x76 - 70.0d0*x77 - 10000.0d0*b78 - 10000.0d0*b79 
     /      - 10000.0d0*b80 - 10000.0d0*b81 - 10000.0d0*b82 
     /      - 10000.0d0*b83 - 10000.0d0*b84 - 10000.0d0*b85 
     /      - 10000.0d0*b86 - 10000.0d0*b87 + x89      

      e69 = -8.0d0*x68 - 8.0d0*x69 - 8.0d0*x70 - 8.0d0*x71 - 8.0d0*x72 
     /      - 8.0d0*x73 - 8.0d0*x74 - 8.0d0*x75 - 8.0d0*x76 - 8.0d0*x77
     /      + x90                           

      g(1) = e12
      g(2) = e13
      g(3) = e14
      g(4) = e15
      g(5) = e16
      g(6) = e17
      g(7) = e18
      g(8) = e19
      g(9) = e20
      g(10) = e21
      g(11) = e22
      g(12) = e23
      g(13) = e24
      g(14) = e25
      g(15) = e26
      g(16) = e27
      g(17) = e28
      g(18) = e29
      g(19) = e30
      g(20) = e31
      g(21) = e32
      g(22) = e33
      g(23) = e34
      g(24) = e35
      g(25) = e36
      g(26) = e37
      g(27) = e38
      g(28) = e39
      g(29) = e40
      g(30) = e41
      g(31) = e42
      g(32) = e43
      g(33) = e44
      g(34) = e45
      g(35) = e46
      g(36) = e47
      g(37) = e48
      g(38) = e49
      g(39) = e50
      g(40) = e51
      g(41) = e52
      g(42) = e53
      g(43) = e54
      g(44) = e55
      g(45) = e56
      g(46) = e67
      g(47) = e68
      g(48) = e69
      g(49) = e1
      g(50) = e2
      g(51) = e3
      g(52) = e4
      g(53) = e5
      g(54) = e6
      g(55) = e7
      g(56) = e8
      g(57) = e9
      g(58) = e10
      g(59) = e11
      g(60) = -e57
      g(61) = -e58
      g(62) = -e59
      g(63) = -e60
      g(64) = -e61
      g(65) = -e62
      g(66) = -e63
      g(67) = -e64
      g(68) = -e65
      g(69) = -e66
         
  999 continue
      return
      end
 

      subroutine gastrans(  mode,     m,     me,  mmax, ncont,  
     /                      nbin,  nint,   nmax,     x,    xl,
     /                        xu,     f,      g,  pnam,  pref,
     /                       fex )    

*  MINLP written by GAMS Convert at 04/18/01 12:07:36
*  
*  Equation counts
*     Total       E       G       L       N       X
*       150      63      45      42       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       107      86      21       0       0       0       0       0
*  FX     5       5       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       419     374      45       0
*
*  Solve m using MINLP minimizing objvar;

      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr,      
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, b46, b47, b48, b49, b50,
     /        b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /        b61, b62, b63, b64, b65, b66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /        x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /       x101,x102,x103,x104,x105,x106
      double precision 
     /                e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /          e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /          e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /          e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /          e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /          e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /          e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /          e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /          e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /          e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /         e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /         e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /         e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /         e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /         e141,e142,e143,e144,e145,e146,e147,e148,e149,e150

      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GASTRANS'
         pref  = '\cite{MINLPLib}'
         fex   = 89.08584d0
         ncont = 85
         nint  = 0
         nbin  = 21
         n     = ncont + nbin + nint
         m     = 149
         me    = 62
         do i = 1,ncont
            xl(i) = -1.0d5
            x(i)  = 1.0d1
            xu(i) = 1.0d5
         end do
         do i = 66,85
            xl(i) = 1.0d2
            x(i)  = 2.0d3
            xu(i) = 1.0d6
         end do
         
         x(1) = 5.45594117499038d0 
         x(2) = 3.49005882500962d0 
         x(3) = 8.46373378118172d0 
         x(4) = 8.88226621881828d0 
         x(5) = 13.428d0     
         x(6) = 4.8d0  
         x(7) = 0.766d0
         x(8) = -7.138d0
         x(9) = -4.49d0
         xl(10) = 0.0d0
         x(10)  = 22.012d0    
         xl(11) = 0.0d0
         x(12) = 18.1380867287228d0
         x(13) = 3.87391327127718d0
         x(14) = 12.1798336524591d0
         x(15) = 3.44716634754093d0
         x(16) = 13.486d0    
         x(17) = 11.366d0
         x(18) = 12.566d0    
         x(19) = 22.464d0    
         x(20) = 15.616d0    
         x(21) = 2.141d0     
         xl(22) = 0.0d0
         x(22) = 2.141d0     
         x(23) = 2.141d0     
         x(24) = 1.919d0     
         x(27) = -75.3049979497412d0 
         x(28) = -68.3754533453309d0 
         x(29) = 6.90403568495296d0
         x(32) = 10.0403890555214d0
         x(34) = 19.0338757369553d0
         x(35) = 6.17166731394037d0
         x(36) = 8.7272279190673d0 
         x(37) = 1.6114349200345d0 
         x(42) = -14.7474499350948d0 
         x(44) = 1.46180871006652d0
         x(45) = -4.68001962388774d0 
         xl(46) = 0.0d0
         xu(46) = 1.2d0
         xu(47) = -4.034d0   
         xu(48) = -0.222d0
         xl(49) = 0.0d0   
         x(49)  = 0.0d0  
         xu(49) = 0.0d0
         xu(50) = -15.616d0  
         xu(51) = -3.918d0   
         xl(52) = 0.0d0
         xu(52) = 8.4d0
         xu(53) = -5.256d0   
         xu(54) = -6.385d0   
         xl(55) = 0.0d0
         xu(55) = 4.8d0
         xu(56) = -6.848d0   
         xu(57) = -2.12d0    
         xu(58) = -1.919d0   
         xl(59) = 0.0d0
         xu(59) = 0.96d0     
         xl(60) = 0.0d0   
         x(60)  = 0.0d0  
         xu(60) = 0.0d0
         xl(61) = 20.344d0  
         xu(61) = 22.012d0                            
         xl(62) = 0.0d0   
         x(62)  = 0.0d0  
         xu(62) = 0.0d0
         xl(63) = 0.0d0   
         x(63)  = 0.0d0  
         xu(63) = 0.0d0
         xl(64) = 8.87d0  
         x(64)  = 8.946d0     
         xu(64) = 11.594d0                              
         xl(65) = 0.0d0   
         x(65)  = 0.0d0  
         xu(65) = 0.0d0
         xl(66) = 0.0d0
         xl(66) = 4382.44d0  
         xl(67) = 900.0d0  
         xu(67) = 6400.0d0
         xl(68) = 0.0d0
         xu(68) = 4382.44d0  
         xl(69) = 0.0d0
         xu(69) = 4382.44d0  
         xl(70) = 2500d0  
         xu(70) = 4382.44d0                             
         xl(71) = 900d0  
         xu(71) = 6400d0
         xl(72) = 0.0d0
         xu(72) = 5929d0     
         xl(73) = 900.0d0  
         xu(73) = 6400.0d0
         xl(74) = 900.0d0  
         xu(74) = 4382.44d0                              
         xl(75) = 0.0d0
         x(75)  = 900.0d0 
         xu(75) = 5929d0     
         xl(76) = 0.0d0
         xu(76) = 4382.44d0  
         xl(77) = 0.0d0
         xu(77) = 4382.44d0  
         xl(78) = 625.0d0  
         xu(78) = 4382.44d0                              
         xl(79) = 0.0d0
         xu(79) = 4382.44d0 
         xl(80) = 0.0d0
         xu(80) = 3969d0    
         xl(81) = 2500d0  
         xu(81) = 4382.44d0                           
         xl(82) = 0.0d0
         xu(82) = 4382.44d0 
         xl(83) = 0.0d0
         xu(83) = 4382.44d0 
         xl(84) = 0.0d0
         xu(84) = 5929.0d0    
         xl(85) = 0.0d0
         x(85)  = 8.946d0
         xu(85) = 6400.0d0     
         do i = 1,ncont
            if (x(i).lt.xl(i)) x(i) = xl(i) 
            if (x(i).gt.xu(i)) x(i) = xu(i)
         end do                
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      do i=1,nbin
         y(i) = x(ncont+i)
      end do
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x67 = x(46)
      x68 = x(47)
      x69 = x(48)
      x70 = x(49)
      x71 = x(50)
      x72 = x(51)
      x73 = x(52)
      x74 = x(53)
      x75 = x(54)
      x76 = x(55)
      x77 = x(56)
      x78 = x(57)
      x79 = x(58)
      x80 = x(59)
      x81 = x(60)
      x82 = x(61)
      x83 = x(62)
      x84 = x(63)
      x85 = x(64)
      x86 = x(65)
      x87 = x(66)
      x88 = x(67)
      x89 = x(68)
      x90 = x(69)
      x91 = x(70)
      x92 = x(71)
      x93 = x(72)
      x94 = x(73)
      x95 = x(74)
      x96 = x(75)
      x97 = x(76)
      x98 = x(77)
      x99 = x(78)
      x100 = x(79)
      x101 = x(80)
      x102 = x(81)
      x103 = x(82)
      x104 = x(83)
      x105 = x(84)
      x106 = x(85)
      b46 = y(1)
      b47 = y(2)
      b48 = y(3)
      b49 = y(4)
      b50 = y(5)
      b51 = y(6)
      b52 = y(7)
      b53 = y(8)
      b54 = y(9)
      b55 = y(10)
      b56 = y(11)
      b57 = y(12)
      b58 = y(13)
      b59 = y(14)
      b60 = y(15)
      b61 = y(16)
      b62 = y(17)
      b63 = y(18)
      b64 = y(19)
      b65 = y(20)
      b66 = y(21)

      f =  2.28d0*x73 + 2.28d0*x76 + 1.68d0*x80 + 1.68d0*x82 
     /     + 2.28d0*x85

      e2 = -x17 + x18 - x67                             

      e3 = -x6 + x7 - x68                               

      e4 = -x23 + x24 - x69                             

      e5 = -x10 - x11 + x12 + x13 - x70                 

      e6 = -x20 - x71 

      e7 = -x3 - x4 + x5 - x72                          

      e8 = -x1 - x2 + x3 + x4 - x73                     

      e9 = -x7 + x8 - x74                               

      e10 = -x12 - x13 + x14 + x15 - x75                

      e11 = x6 - x76 

      e12 = -x19 + x20 - x77                            

      e13 = -x16 + x17 - x78                            

      e14 = -x24 - x79

      e15 = -x9 - x18 + x19 - x80                       

      e16 = -x22 + x23 - x81                            

      e17 = x10 + x11 - x82                            

      e18 = -x21 + x22 - x83                            

      e19 = -x14 - x15 + x16 + x21 - x84                

      e20 = x1 + x2 - x85                              

      e21 = -x5 - x8 + x9 - x86                         

      e22 = x25*sqr(x1) + 8.99076279639865*x93 - 8.99076279639865*x105

      e23 = x26*sqr(x2) + 8.99076279639865*x93 - 8.99076279639865*x105

      e24 = x27*sqr(x3) + 5.99384186426577*x92 - 5.99384186426577*x93 

      e25 = x28*sqr(x4) + 5.99384186426577*x92 - 5.99384186426577*x93 

      e26 = x29*sqr(x5) - 1.38319427636902*x92 + 1.38319427636902*x106

      e27 = x30*sqr(x6) + 0.0993769948466698*x88 
     /      - 0.0993769948466698*x96

      e28 = x31*sqr(x7) - 0.147352095807131*x88 + 0.147352095807131*x94 

      e29 = x32*sqr(x8) - 0.224905830442463*x94 + 0.224905830442463*x106

      e30 = x33*sqr(x9) + 0.653873657919902*x100 
     /      - 0.653873657919902*x106

      e31 = x34*sqr(x12) - 1.79815255927973*x90 + 1.79815255927973*x95

      e32 = x35*sqr(x13) - 0.0265962529480588*x90 
     /      + 0.0265962529480588*x95                                

      e33 = x36*sqr(x14) - 1.43852204742378*x95 + 1.43852204742378*x104 

      e34 = x37*sqr(x15) - 0.021277002358447*x95 
     /      + 0.021277002358447*x104

      e35 = x38*sqr(x16) + 0.856263123466538*x98 
     /      - 0.856263123466538*x104

      e36 = x39*sqr(x17) + 0.899076279639865*x87 - 0.899076279639865*x98

      e37 = x40*sqr(x18) - 7.19261023711892*x87 + 7.19261023711892*x100 

      e38 = x41*sqr(x19) + 3.59630511855946*x97 - 3.59630511855946*x100 

      e39 = x42*sqr(x20) + 1.43852204742378*x91 - 1.43852204742378*x97

      e40 = x43*sqr(x21) + 0.0509935163731392*x103 
     /      - 0.0509935163731392*x104                              

      e41 = x44*sqr(x23) + 0.0016882734118691*x89 
     /      - 0.0016882734118691*x101                               

      e42 = x45*sqr(x24) - 0.0275751323938619*x89 
     /      + 0.0275751323938619*x99                                

      e43 = -sqr(x10) + 7.19261023711892*x90 - 7.19261023711892*x102

      e44 = -sqr(x11) + 0.106385011792235*x90 - 0.106385011792235*x102

      e45 = -sqr(x22) + 0.00636349209089121*x101 
     /      - 0.00636349209089121*x103                             

      e46 = x25 - 2.0d0*b46 + 1.0d0                   

      e47 = x26 - 2.0d0*b47 + 1.0d0                   

      e48 = x27 - 2.0d0*b48 + 1.0d0                   

      e49 = x28 - 2.0d0*b49 + 1.0d0                   

      e50 = x29 - 2.0d0*b50 + 1.0d0                   

      e51 = x30 - 2.0d0*b51 + 1.0d0                   

      e52 = x31 - 2.0d0*b52 + 1.0d0                   

      e53 = x32 - 2.0d0*b53 + 1.0d0                   

      e54 = x33 - 2.0d0*b54 + 1.0d0                   

      e55 = x34 - 2.0d0*b55 + 1.0d0                   

      e56 = x35 - 2.0d0*b56 + 1.0d0                   

      e57 = x36 - 2.0d0*b57 + 1.0d0                   

      e58 = x37 - 2.0d0*b58 + 1.0d0                   

      e59 = x38 - 2.0d0*b59 + 1.0d0                   

      e60 = x39 - 2.0d0*b60 + 1.0d0                   

      e61 = x40 - 2.0d0*b61 + 1.0d0                   

      e62 = x41 - 2.0d0*b62 + 1.0d0                   

      e63 = x42 - 2.0d0*b63 + 1.0d0                   

      e64 = x43 - 2.0d0*b64 + 1.0d0                   

      e65 = x44 - 2.0d0*b65 + 1.0d0                   

      e66 = x45 - 2.0d0*b66 + 1.0d0                   

      e67 = -5929.0d0*b46 - x93 + x105 + 5929.0d0            

      e68 = -5929.0d0*b47 - x93 + x105 + 5929.0d0            

      e69 = -6400.0d0*b48 - x92 + x93 + 6400.0d0             

      e70 = -6400.0d0*b49 - x92 + x93 + 6400.0d0             

      e71 = -5500.0d0*b50 + x92 - x106 + 5500.0d0            

      e72 = -6400.0d0*b51 - x88 + x96 + 6400.0d0             

      e73 = -5500.0d0*b52 + x88 - x94 + 5500.0d0             

      e74 = -5500.0d0*b53 + x94 - x106 + 5500.0d0            

      e75 = -4382.44d0*b54 - x100 + x106 + 4382.44d0     

      e76 = -4382.44d0*b55 + x90 - x95 + 4382.44d0       

      e77 = -4382.44d0*b56 + x90 - x95 + 4382.44d0       

      e78 = -3482.44*b57 + x95 - x104 + 3482.44      

      e79 = -3482.44*b58 + x95 - x104 + 3482.44      

      e80 = -4382.44d0*b59 - x98 + x104 + 4382.44d0      

      e81 = -4382.44d0*b60 - x87 + x98 + 4382.44d0       

      e82 = -4382.44d0*b61 + x87 - x100 + 4382.44d0      

      e83 = -4382.44d0*b62 - x97 + x100 + 4382.44d0      

      e84 = -4382.44d0*b63 - x91 + x97 + 4382.44d0       

      e85 = -4382.44d0*b64 - x103 + x104 + 4382.44d0     

      e86 = -4382.44d0*b65 - x89 + x101 + 4382.44d0      

      e87 = -4382.44d0*b66 + x89 - x99 + 4382.44d0       

      e88 = -5929.0d0*b46 - x93 + x105                      

      e89 = -5929.0d0*b47 - x93 + x105                      

      e90 = -5029d0*b48 - x92 + x93                       

      e91 = -5029d0*b49 - x92 + x93                       

      e92 = -6400.0d0*b50 + x92 - x106                      

      e93 = -5029.0d0*b51 - x88 + x96                       

      e94 = -5500.0d0*b52 + x88 - x94                       

      e95 = -6400.0d0*b53 + x94 - x106                      

      e96 = -6400.0d0*b54 - x100 + x106                     

      e97 = -3482.44d0*b55 + x90 - x95                    

      e98 = -3482.44d0*b56 + x90 - x95                    

      e99 = -4382.44d0*b57 + x95 - x104                   

      e100 = -4382.44d0*b58 + x95 - x104                  

      e101 = -4382.44d0*b59 - x98 + x104                  

      e102 = -4382.44d0*b60 - x87 + x98                   

      e103 = -4382.44d0*b61 + x87 - x100                  

      e104 = -4382.44d0*b62 - x97 + x100                  

      e105 = -1882.44d0*b63 - x91 + x97                   

      e106 = -4382.44d0*b64 - x103 + x104                 

      e107 = -3969.0d0*b65 - x89 + x101                     

      e108 = -3757.44d0*b66 + x89 - x99                   

      e109 = x1 - 230.881425454383*b46 + 230.881425454383 

      e110 = x2 - 230.881425454383*b47 + 230.881425454383 

      e111 = x3 - 195.858591670881*b48 + 195.858591670881 

      e112 = x4 - 195.858591670881*b49 + 195.858591670881 

      e113 = x5 - 87.2213765084548*b50 + 87.2213765084548 

      e114 = x6 - 25.2192935471771*b51 + 25.2192935471771 

      e115 = x7 - 28.4681669051455*b52 + 28.4681669051455 

      e116 = x8 - 35.1707558553061*b53 + 35.1707558553061 

      e117 = x9 - 53.5309450076729*b54 + 53.5309450076729 

      e118 = x12 - 88.7710296317997*b55 + 88.7710296317997

      e119 = x13 - 10.7961327691767*b56 + 10.7961327691767

      e120 = x14 - 70.7782927092091*b57 + 70.7782927092091

      e121 = x15 - 8.6078966125965*b58 + 8.6078966125965  

      e122 = x16 - 61.2578302162646*b59 + 61.2578302162646

      e123 = x17 - 62.7705970255575*b60 + 62.7705970255575

      e124 = x18 - 177.542059263599*b61 + 177.542059263599

      e125 = x19 - 125.541194051115*b62 + 125.541194051115

      e126 = x20 - 79.3992226757409*b63 + 79.3992226757409

      e127 = x21 - 14.9491145521834*b64 + 14.9491145521834

      e128 = x23 - 2.72006561154535*b65 + 2.72006561154535

      e129 = x24 - 10.9930142912741*b66 + 10.9930142912741

      e130 = x1 - 230.881425454383*b46                 

      e131 = x2 - 230.881425454383*b47                 

      e132 = x3 - 173.61748395652*b48                  

      e133 = x4 - 173.61748395652*b49                  

      e134 = x5 - 94.0874240733678*b50                 

      e135 = x6 - 22.3554670513479*b51                 

      e136 = x7 - 28.4681669051455*b52                 

      e137 = x8 - 37.939390016601*b53                  

      e138 = x9 - 64.6899637554959*b54                 

      e139 = x12 - 79.1325369145847*b55                

      e140 = x13 - 9.62392098452798*b56                

      e141 = x14 - 79.3992226757409*b57                

      e142 = x15 - 9.65635470639685*b58                

      e143 = x16 - 61.2578302162646*b59                

      e144 = x17 - 62.7705970255575*b60                

      e145 = x18 - 177.542059263599*b61                

      e146 = x19 - 125.541194051115*b62                

      e147 = x20 - 52.0377886055166*b63                

      e148 = x21 - 14.9491145521834*b64                

      e149 = x23 - 2.58858207745253*b65                

      e150 = x24 - 10.1789933422708*b66          

      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = e7
      g(7) = e8
      g(8) = e9
      g(9) = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e18
      g(18) = e19
      g(19) = e20
      g(20) = e21
      g(21) = e22
      g(22) = e23
      g(23) = e24
      g(24) = e25
      g(25) = e26
      g(26) = e27
      g(27) = e28
      g(28) = e29
      g(29) = e30
      g(30) = e31
      g(31) = e32
      g(32) = e33
      g(33) = e34
      g(34) = e35
      g(35) = e36
      g(36) = e37
      g(37) = e38
      g(38) = e39
      g(39) = e40
      g(40) = e41
      g(41) = e42
      g(42) = e46
      g(43) = e47
      g(44) = e48
      g(45) = e49
      g(46) = e50
      g(47) = e51
      g(48) = e52
      g(49) = e53
      g(50) = e54
      g(51) = e55
      g(52) = e56
      g(53) = e57
      g(54) = e58
      g(55) = e59
      g(56) = e60
      g(57) = e61
      g(58) = e62
      g(59) = e63
      g(60) = e64
      g(61) = e65
      g(62) = e66  
      g(63) = e43
      g(64) = e44
      g(65) = e45
      g(66) = e67
      g(67) = e68
      g(68) = e69
      g(69) = e70
      g(70) = e71
      g(71) = e72
      g(72) = e73
      g(73) = e74
      g(74) = e75
      g(75) = e76
      g(76) = e77
      g(77) = e78
      g(78) = e79
      g(79) = e80
      g(80) = e81
      g(81) = e82
      g(82) = e83
      g(83) = e84
      g(84) = e85
      g(85) = e86
      g(86) = e87
      g(87) = -e88
      g(88) = -e89
      g(89) = -e90
      g(90) = -e91
      g(91) = -e92
      g(92) = -e93
      g(93) = -e94
      g(94) = -e95
      g(95) = -e96
      g(96) = -e97
      g(97) = -e98
      g(98) = -e99
      g(99) = -e100
      g(100) = -e101
      g(101) = -e102
      g(102) = -e103
      g(103) = -e104
      g(104) = -e105
      g(105) = -e106
      g(106) = -e107
      g(107) = -e108
      g(108) = e109
      g(109) = e110
      g(110) = e111
      g(111) = e112
      g(112) = e113
      g(113) = e114
      g(114) = e115
      g(115) = e116
      g(116) = e117
      g(117) = e118
      g(118) = e119
      g(119) = e120
      g(120) = e121
      g(121) = e122
      g(122) = e123
      g(123) = e124
      g(124) = e125
      g(125) = e126
      g(126) = e127
      g(127) = e128
      g(128) = e129
      g(129) = -e130
      g(130) = -e131
      g(131) = -e132
      g(132) = -e133
      g(133) = -e134
      g(134) = -e135
      g(135) = -e136
      g(136) = -e137
      g(137) = -e138
      g(138) = -e139
      g(139) = -e140
      g(140) = -e141
      g(141) = -e142
      g(142) = -e143
      g(143) = -e144
      g(144) = -e145
      g(145) = -e146
      g(146) = -e147
      g(147) = -e148
      g(148) = -e149
      g(149) = -e150   
      
      do j=66,86
         g(j) = g(j)*10.0d0**(-4)
      end do   

  999 continue
      return
      end
 
   
      subroutine gbd(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:48
*  
*  Equation counts
*     Total       E       G       L       N       X
*         5       1       2       2       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         5       2       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        17      16       1       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), x2, b3, b4, b5, e2, e3, e4, e5, sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GBD'
         pref  = '\cite{MINLPLib}'
         fex   = 2.2d0  
         ncont = 1
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,ncont
            xl(i) = 0.2d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo  
       
      x2 = x(1)
      b3 = y(1)
      b4 = y(2)
      b5 = y(3)

      f = 5.0d0*sqr(x2) + b3 + b4 + b5
                                                          
      e2 = 3.0d0*x2 - b3 - b4          

      e3 = -x2 + 0.1d0*b4 + 0.25d0*b5   

      e4 = b3 + b4 + b5 - 2.0d0      

      e5 = b3 + b4 + 2.0d0*b5 - 2.0d0

      g(1) = -e2
      g(2) = -e3
      g(3) = e4
      g(4) = e5

  999 continue
      return
      end
 
      subroutine gear( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:50
*  
*  Equation counts
*     Total       E       G       L       N       X
*         1       1       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         5       1       0       4       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         5       1       4       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GEAR'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0  
         ncont = 0
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         do i=1,n
            xl(i) = 12.0d0
            x(i)  = 12.0d0
            xu(i) = 60.0d0
         end do
         goto 999       
      end if

      do i=1,nint
         y(i) = x(i)
      end do

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)

      f = sqr(0.14427932477276d0 - i1*i2/(i3*i4)) + 1.0d0

  999 continue
      return
      end

      subroutine gear2( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:53
*  
*  Equation counts
*     Total       E       G       L       N       X
*         5       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        29       5      24       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        33      29       4       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, x2, x3, x4, x5, b6, b7, b8, b9, b10, b11,
     /        b12, b13, b14, b15, b16, b17, b18, b19, b20, b21, b22,
     /        b23, b24, b25, b26, b27, b28, b29
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GEAR2'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0
         ncont = 4
         nint  = 24
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 4
         do i=1,ncont
            xl(i) = 12.0d0
            x(i)  = 12.0d0
            xu(i) = 63.0d0
         enddo
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      b6 = y(1)
      b7 = y(2)
      b8 = y(3)
      b9 = y(4)
      b10 = y(5)
      b11 = y(6)
      b12 = y(7)
      b13 = y(8)
      b14 = y(9)
      b15 = y(10)
      b16 = y(11)
      b17 = y(12)
      b18 = y(13)
      b19 = y(14)
      b20 = y(15)
      b21 = y(16)
      b22 = y(17)
      b23 = y(18)
      b24 = y(19)
      b25 = y(20)
      b26 = y(21)
      b27 = y(22)
      b28 = y(23)
      b29 = y(24)

      f = sqr(0.14427932477276d0 - x2*x3/(x4*x5)) + 1.0d0

      g(1) = x2 - b6 - 2.0d0*b7 - 4.0d0*b8 - 8.0d0*b9 - 16.0d0*b10 
     /       - 32.0d0*b11 

      g(2) = x3 - b12 - 2.0d0*b13 - 4.0d0*b14 - 8.0d0*b15 - 16.0d0*b16 
     /      - 32.0d0*b17 

      g(3) = x4 - b18 - 2.0d0*b19 - 4.0d0*b20 - 8.0d0*b21 - 16.0d0*b22
     /       - 32.0d0*b23 

      g(4) = x5 - b24 - 2.0d0*b25 - 4.0d0*b26 - 8.0d0*b27 - 16.0d0*b28
     /       - 32.0d0*b29

  999 continue
      return
      end

      subroutine gear2a( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:53
*  
*  Equation counts
*     Total       E       G       L       N       X
*         5       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        29       5      24       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        33      29       4       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, x2, x3, x4, x5, b6, b7, b8, b9, b10, b11,
     /        b12, b13, b14, b15, b16, b17, b18, b19, b20, b21, b22,
     /        b23, b24, b25, b26, b27, b28, b29
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GEAR2A'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0
         ncont = 4
         nint  = 0
         nbin  = 24
         n     = ncont + nbin + nint
         m     = 4
         me    = 4
         do i=1,ncont
            xl(i) = 12.0d0
            x(i)  = 12.0d0
            xu(i) = 60.0d0
         enddo
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo

      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      b6 = y(1)
      b7 = y(2)
      b8 = y(3)
      b9 = y(4)
      b10 = y(5)
      b11 = y(6)
      b12 = y(7)
      b13 = y(8)
      b14 = y(9)
      b15 = y(10)
      b16 = y(11)
      b17 = y(12)
      b18 = y(13)
      b19 = y(14)
      b20 = y(15)
      b21 = y(16)
      b22 = y(17)
      b23 = y(18)
      b24 = y(19)
      b25 = y(20)
      b26 = y(21)
      b27 = y(22)
      b28 = y(23)
      b29 = y(24)

      f = sqr(0.14427932477276d0 - x2*x3/(x4*x5)) + 1.0d0

      g(1) = x2 - b6 - 2.0d0*b7 - 4.0d0*b8 - 8.0d0*b9 - 16.0d0*b10 
     /       - 32.0d0*b11 

      g(2) = x3 - b12 - 2.0d0*b13 - 4.0d0*b14 - 8.0d0*b15 - 16.0d0*b16 
     /      - 32.0d0*b17 

      g(3) = x4 - b18 - 2.0d0*b19 - 4.0d0*b20 - 8.0d0*b21 - 16.0d0*b22
     /       - 32.0d0*b23 

      g(4) = x5 - b24 - 2.0d0*b25 - 4.0d0*b26 - 8.0d0*b27 - 16.0d0*b28
     /       - 32.0d0*b29

  999 continue
      return
      end

      subroutine gear3( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:54
*  
*  Equation counts
*     Total       E       G       L       N       X
*         5       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       5       0       4       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        13       9       4       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GEAR3'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0
         ncont = 4
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 4
         do i=1,n
            xl(i) = 12.0d0
            x(i)  = 12.0d0
            xu(i) = 60.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = sqr(0.14427932477276d0 - x(1)*x(2)/(x(3)*x(4))) + 1.0d0

      g(1) = x(1) - y(1)
 
      g(2) = x(2) - y(2)
  
      g(3) = x(3) - y(3)
  
      g(4) = x(4) - y(4)

  999 continue
      return
      end

      subroutine gear4( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 04/27/01 14:45:36
*  
*  Equation counts
*     Total       E       G       L       N       X
*         2       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         7       3       0       4       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         9       5       4       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, x6, x7
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GEAR4'
         pref  = '\cite{MINLPLib}'
         fex   = 1.643428d0
         ncont = 2
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 1
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 2.0d0
         enddo
         do i=ncont+1,n
            xl(i) = 12.0d0
            x(i)  = 40.0d0
            xu(i) = 60.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      i1 = y(1) 
      i2 = y(2) 
      i3 = y(3) 
      i4 = y(4) 
      x6 = x(1) 
      x7 = x(2) 

      f = x6 + x7

      g(1) = -1.0d6*i1*i2/(i3*i4) - x6 + x7 + 144279.32477276d0 
      
  999 continue
      return
      end
  
      subroutine gkocis( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:55
*  
*  Equation counts
*     Total       E       G       L       N       X
*         9       6       0       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        12       9       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        28      26       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit doubleprecision (a-h,o-z)
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      double precision x1, x2, x3, x4, x5, x6, x7, x8, b9, b10, b11,
     /        e2, e3, e4, e5, e7, e8, e9
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'GKOCIS'
         pref  = '\cite{MINLPLib}'
         fex   = -1.923099d0
         ncont = 8
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 8
         me    = 5
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d5
         enddo
         xu(6) = 5.0d0  
         xu(8) = 1.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo    
         goto 999       
      endif

      do i=1,nbin 
         y(i) = x(ncont+i) 
      enddo 

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      b9 = y(1)
      b10 = y(2)
      b11 = y(3)

      f = 1.8d0*x1 + 7.0d0*x5 + x6 + 1.2d0*x7 - 11.0d0*x8 + 3.5d0*b9 
     /    + b10 + 1.5d0*b11                

      e2 = -dlog(1.0d0 + x2) + x6            

      e3 = -1.2d0*dlog(1.0d0 + x3) + x7        

      e4 = -0.9d0*x4 + x8                 

      e5 = -x4 + x5 + x6 + x7           

      e6 = x1 - x2 - x3                

      e7 = x4 - 5.0d0*b9

      e8 = x2 - 5.0d0*b10                  

      e9 = x3 - 5.0d0*b11

      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = -e7
      g(7) = -e8
      g(8) = -e9

  999 continue
      return
      end

      subroutine hilbert100(  mode,     m,     me,  mmax, ncont,  
     /                       nbin,  nint,   nmax,     x,    xl,
     /                         xu,     f,      g,  pnam,  pref,
     /                        fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, j, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), b 
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'HILBERT100'
         pref  = ''
         ncont = 0
         nint  = 100
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 100
         me    = 100
         fex   = 0.0d0
         do i = 1,n
            fex = fex + dble(i)
            xl(i) = -1.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d1
         end do
         goto 999       
      end if

      n = ncont + nbin + nint

      f = 0.0d0
      do i=1,n
         f = f + dble(i)*dexp(x(i)-1.0d0)**2      
      end do
      
      do j=1,m  
         b = 0.0d0
         do i=1,n
            b = b + 1.0d0/dble(i+j-1) 
         end do
         g(j) = -b
         do i=1,n
            g(j) = g(j) + x(i)/dble(i+j-1)
         end do
      end do   
  999 continue
      return
      end
      subroutine hilbert20(  mode,     m,     me,  mmax, ncont,  
     /                       nbin,  nint,   nmax,     x,    xl,
     /                         xu,     f,      g,  pnam,  pref,
     /                        fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, j, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), b 
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'HILBERT20'
         pref  = ''
         ncont = 0
         nint  = 20
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 20
         me    = 20
         fex   = 0.0d0
         do i = 1,n
            fex = fex + dble(i)
            xl(i) = -1.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d1
         end do
         goto 999       
      end if

      n = ncont + nbin + nint

      f = 0.0d0
      do i=1,n
         f = f + dble(i)*dexp(x(i)-1.0d0)**2      
      end do
      
      do j=1,m  
         b = 0.0d0
         do i=1,n
            b = b + 1.0d0/dble(i+j-1) 
         end do
         g(j) = -b
         do i=1,n
            g(j) = g(j) + x(i)/dble(i+j-1)
         end do
      end do   
  999 continue
      return
      end
      subroutine hilbert50(  mode,     m,     me,  mmax, ncont,  
     /                       nbin,  nint,   nmax,     x,    xl,
     /                         xu,     f,      g,  pnam,  pref,
     /                        fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, j, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), b 
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'HILBERT50'
         pref  = ''
         ncont = 0
         nint  = 50
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 50
         me    = 50
         fex   = 0.0d0
         do i = 1,n
            fex = fex + dble(i)
            xl(i) = -1.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d1
         end do
         goto 999       
      end if

      n = ncont + nbin + nint

      f = 0.0d0
      do i=1,n
         f = f + dble(i)*dexp(x(i)-1.0d0)**2      
      end do
      
      do j=1,m  
         b = 0.0d0
         do i=1,n
            b = b + 1.0d0/dble(i+j-1) 
         end do
         g(j) = -b
         do i=1,n
            g(j) = g(j) + x(i)/dble(i+j-1)
         end do
      end do   
  999 continue
      return
      end
      subroutine irap1( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 17
      kp  = 4    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP1'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 218.14d0 
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end

      subroutine irap2( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 19
      kp  = 2    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP2'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 0.31651600d3
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end

      subroutine irap3( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 20
      kp  = 2    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP3'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 0.33661343d3
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end

      subroutine irap4( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 15
      kp  = 3    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP4'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 0.19616428d3
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end

      subroutine irap5( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 15
      kp  = 4    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP5'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 0.18674499d3
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end

      subroutine irap6( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i, j, 
     /        np, kp 
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), r0, r, s, cp
      character*30 pnam, pref   
      common /random_data_array/ ran_num(600)
      double precision ran_num
      common ir
      integer ir

      np  = 17
      kp  = 2    
      r0  = 0.9d0
      
      if (mode.eq.0) then
         pnam  = 'IRAP6'
         pref  = '\cite{Ch92,GHPU12}'
         fex   = 0.23935852d3
         ncont = 0
         nint  = np*kp
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1 + np
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         end do          
         call random_data(ran_num)
         goto 999       
      end if

      ir  = 1
      f   = 0.0d0   
      do i=1,nint   
         r = ran_num(ir)
         ir = ir + 1 
         f  = f + 1.0d1*(1.0d0 + r)*x(i)
      end do

      g(1) = 1.0d0               
      do i=1,np
         s = 1.0d0
         do j=1,kp                          
            r  = ran_num(ir)
            ir = ir + 1       
            r  = 0.99d0 + r*0.008d0 
            s  = s*(1.0d0 - r)**x((j-1)*np+i)
         end do
         g(1) = g(1)*(1.0d0 - s) 
      end do   
      g(1) = g(1) - r0

      do i = 1,np   
         g(1+i) = 0.0d0
         do j=1,kp
            g(1+i) = g(1+i) + x((j-1)*np+i)
         end do           
         g(1+i) = g(1+i) - 1.0d0
      end do          
            
  999 continue
      return
      end


      subroutine kg( mode,     m,     me,  mmax, ncont,  
     /               nbin,  nint,   nmax,     x,    xl,
     /                 xu,     f,      g,  pnam,  pref,
     /                fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'KG'
         pref  = '\cite{KG88}'
         fex   = 103.93766d0
         ncont = 7
         nint  = 0
         nbin  = 2
         n     = ncont + nbin + nint
         m     = 9
         me    = 5
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xu(1) = 20.0d0
         xu(2) = 20.0d0
         xu(7) = 20.0d0
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo
 
      f = 7.5d0*y(1) + 5.5d0*y(2) + 7.0d0*x(5) + 6.0d0*x(6) + 5.0d0*x(7)

      g(1) = x(3) - 0.9d0*(1.0d0 - dexp(-0.5d0*x(5)))*x(1)   
       
      g(2) = x(4) - 0.8d0*(1.0d0 - dexp(-0.5d0*x(6)))*x(2) 
      
      g(3) = x(1) + x(2) - x(7)
     
      g(4) = x(3) + x(4) - 10.0d0
 
      g(5) = y(1) + y(2) - 1.0d0
 
      g(6) = -x(5) + 10.0d0*y(1)
 
      g(7) = -x(6) + 10.0d0*y(2)

      g(8) = -x(1) + 12.0d0*y(1)

      g(9) = -x(2) + 12.0d0*y(2)

  999 continue
      return
      end

      subroutine lichou_1( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, y1, w1
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'LICHOU_1'
         pref  = '\cite{LC94}'
         fex   = -246.0d0
         ncont = 1
         nint  = 1
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 1
         xl(1) = 3.0d0
         x(1)  = 5.0d0
         xu(1) = 5.5d0
         xl(2) = 15.0d0
         x(2)  = 25.0d0
         xu(2) = 25.0d0
         goto 999       
      endif

      x1 = x(1)
      y1 = x(2)
      w1 = y1*0.2d0

      f =  2.0d0*x1**2 + w1**3 - 16.0d0*x1*w1 - 10.0d0*w1

      g(1) = (x1**2 - 6.0d0*x1 + 4.0d0*w1 - 11.0d0)
     /          *((3.25d0*x1 - 3.1d0*w1)**2 + (x1 + w1 - 6.35d0)**2)
     /       *((3.55d0*x1 - 3.3d0*w1)**2 + (x1 + w1 - 6.85d0)**2)
     /       *((3.6d0*x1 - 3.5d0*w1)**2 + (x1 + w1 - 7.1d0)**2)
     /       *((3.8d0*x1 - 4.1d0*w1)**2 + (x1 + w1 - 7.9d0)**2)**2
     
      g(2) = x1*w1 - 3.0d0*w1 - dexp(x1 - 3.0d0) + 1.0d0

  999 continue
      return
      end

      subroutine lichou_2( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, x4, pi
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'LICHOU_2'
         pref  = '\cite{LC94}'
         fex   = 7127.3d0
         ncont = 2
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         xl(1) = 0.0d0
         x(1)  = 1.0d1
         xu(1) = 1.0d6
         xl(2) = 0.0d0
         x(2)  = 1.0d1
         xu(2) = 1.0d6
         xl(3) = 0.0d0
         x(3)  = 1.0d0
         xu(3) = 7.0d0
         xl(4) = 0.0d0
         x(4)  = 1.0d0
         xu(4) = 7.0d0
         goto 999       
      endif

      pi = 3.1415926535897932384d0
      x1 = 1.125d0 + x(3)*0.0625d0
      x2 = 0.625d0 + x(4)*0.0625d0
      x3 = x(1)
      x4 = x(2)

      f = 0.6224d0*x1*x3*x4 + 1.7781d0*x2*x3**2 + 3.1661d0*x1**2*x4 
     /    + 19.84d0*x1**2*x3 

      g(1) = x1 - 0.0193d0*x3
      
      g(2) = x2 - 0.00954d0*x3
      
      g(3) = pi*x3**2*x4 + 4.0d0/3.0d0*pi*x3**3 - 750.0d0*1728.0d0
      
      g(4) = 240.0d0 - x4

  999 continue
      return
      end

      subroutine lichou_3( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), xl(nmax), xu(nmax), y(1000), f, fex, 
     /        g(mmax), eps, d
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'LICHOU_3'
         pref  = '\cite{LC94}'
         fex   = 0.30414d1  
         ncont = 0
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i=1,nint
            xl(i) = 1.0d0
            x(i)  = 5.0d0
            xu(i) = 7.0d0
         enddo   
         goto 999       
      endif

      eps = 1.0d-4
      do i=1,nint
         if (dabs(x(i)-1.0d0).lt.eps) then
            y(i) = 0.1d0
         else  
         if (dabs(x(i)-2.0d0).lt.eps) then
            y(i) = 0.2d0
         else  
         if (dabs(x(i)-3.0d0).lt.eps) then
            y(i) = 0.3d0
         else  
         if (dabs(x(i)-4.0d0).lt.eps) then
            y(i) = 0.5d0
         else  
         if (dabs(x(i)-5.0d0).lt.eps) then
            y(i) = 0.8d0
         else  
         if (dabs(x(i)-6.0d0).lt.eps) then
            y(i) = 1.0d0
         else  
         if (dabs(x(i)-7.0d0).lt.eps) then
            y(i) = 1.2d0
         endif 
         endif 
         endif 
         endif 
         endif 
         endif 
         endif 
      enddo
      
      f = 2.0d0*y(1) + y(2) + dsqrt(2.0d0)*y(3)

      d = 1.5d0*y(1)*y(2) + dsqrt(2.0d0)*y(2)*y(3) + 1.319d0*y(1)*y(3)
      
      g(1) = 1.0d0 - (dsqrt(3.0d0)*y(2) + 1.932d0*y(3))/d
      
      g(2) = 1.0d0 - (0.634d0*y(1) + 2.828d0*y(3))/d
      
      g(3) = 1.0d0 - (0.5d0*y(1) - 2.0d0*y(2))/d
      
      g(4) = 1.0d0 + (0.5d0*y(1) - 2.0d0*y(2))/d

  999 continue
      return
      end

      subroutine m3(  mode,     m,     me,  mmax, ncont,  
     /                nbin,  nint,   nmax,     x,    xl,
     /                  xu,     f,      g,  pnam,  pref,
     /                 fex )    

*  MINLP written by GAMS Convert at 10/26/04 14:09:22
*  
*  Equation counts
*      Total        E        G        L        N        X        C
*         44        1        0       43        0        0        0
*  
*  Variable counts
*                   x        b        i      s1s      s2s       sc       si
*      Total     cont   binary  integer     sos1     sos2    scont     sint
*         27       21        6        0        0        0        0        0
*  FX      2        2        0        0        0        0        0        0
*  
*  Nonzero counts
*      Total    const       NL      DLL
*        157      151        6        0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         b1,  b2,  b3,  b4,  b5,  b6,       x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /        x21, x22, x23, x24, x25, x26, x27,
     /             e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /       e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /       e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /       e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /       e41, e42, e43, e44
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'M3'
         pref  = '\cite{MINLPLib}'
         fex   =  37.8d0
         ncont = 20
         nint  = 0
         nbin  = 6
         n     = ncont + nbin + nint
         m     = 43
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d5
            x(i)  = 0.0d0
            xu(i) = 1.0d5
         enddo
         xl(7) = 2.0d0
         x(7)  = 2.0d0
         xu(7) = 5.4772d0
         xl(8) = 3.0d0
         x(8)  = 3.0d0
         xu(8) = 6.7081d0 
         xl(9) = 3.8d0
         x(9)  = 3.8d0
         xu(9) = 7.5498d0 
         xl(10) = 10.0d0
         x(10)  = 10.0d0
         xu(10) = 10.0d0
         xl(11) = 1.8258d0
         x(11)  = 2.0d0
         xu(11) = 5.0d0
         xl(12) = 2.2361d0
         x(12)  = 2.5d0
         xu(12) = 5.0d0 
         xl(13) = 2.5166d0
         x(13)  = 3.0d0
         xu(13) = 5.0d0
         xl(14) = 5.0d0
         x(14)  = 5.0d0
         xu(14) = 5.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x8 = x(1)
      x9 = x(2)
      x10 = x(3)
      x11 = x(4)
      x12 = x(5)
      x13 = x(6)
      x14 = x(7)
      x15 = x(8)
      x16 = x(9)
      x17 = x(10)
      x18 = x(11)
      x19 = x(12)
      x20 = x(13)
      x21 = x(14)
      x22 = x(15)
      x23 = x(16)
      x24 = x(17)
      x25 = x(18)
      x26 = x(19)
      x27 = x(20)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)

      f = 6.0d0*x10 + 6.0d0*x11 + 6.0d0*x12 + 6.0d0*x13               

      e2 = x22 - x23     

      e3 = 0.5d0*x14 - x17 + x22                                  

      e4 = 0.5d0*x14 - x22 

      e5 = 0.5d0*x18 - x21 + x25                                  

      e6 = 0.5d0*x18 - x25 

      e7 = 0.5d0*x15 - x17 + x23                                  

      e8 = 0.5d0*x15 - x23 

      e9 = 0.5d0*x19 - x21 + x26                                  

      e10 = 0.5d0*x19 - x26

      e11 = 0.5d0*x16 - x17 + x24                                 

      e12 = 0.5d0*x16 - x24

      e13 = 0.5d0*x20 - x21 + x27                                 

      e14 = 0.5d0*x20 - x27

      e15 = -x8 + x22 - x23                                      

      e16 = -x8 - x22 + x23                                      

      e17 = -x9 + x25 - x26                                      

      e18 = -x9 - x25 + x26                                      

      e19 = -10.0d0*b1 - 10.0d0*b2 + 0.5d0*x14 + 0.5d0*x15 - x22 + x23 
      
      e20 = -10.0d0*b1 + 10.0d0*b2 + 0.5d0*x14 + 0.5d0*x15 + x22 - x23 
     /      - 10.0d0

      e21 = 5.0d0*b1 - 5.0d0*b2 + 0.5d0*x18 + 0.5d0*x19 - x25 + x26 
     /      - 5.0d0   

      e22 = 5.0d0*b1 + 5.0d0*b2 + 0.5d0*x18 + 0.5d0*x19 + x25 - x26 
     /      - 10.0d0  

      e23 = -x10 + x22 - x24                                     

      e24 = -x10 - x22 + x24                                     

      e25 = -x11 + x25 - x27                                     

      e26 = -x11 - x25 + x27                                     

      e27 = -10.0d0*b3 - 10.0d0*b4 + 0.5d0*x14 + 0.5d0*x16 - x22 + x24 

      e28 = -10.0d0*b3 + 10.0d0*b4 + 0.5d0*x14 + 0.5d0*x16 + x22 - x24
     /      - 10.0d0

      e29 = 5.0d0*b3 - 5.0d0*b4 + 0.5d0*x18 + 0.5d0*x20 - x25 + x27
     /      - 5.0d0   

      e30 = 5.0d0*b3 + 5.0d0*b4 + 0.5d0*x18 + 0.5d0*x20 + x25 - x27 
     /     - 10.0d0  

      e31 = -x12 + x23 - x24                                     

      e32 = -x12 - x23 + x24                                     

      e33 = -x13 + x26 - x27                                     

      e34 = -x13 - x26 + x27                                     

      e35 = -10.0d0*b5 - 10.0d0*b6 + 0.5d0*x15 + 0.5d0*x16 - x23 + x24 

      e36 = -10.0d0*b5 + 10.0d0*b6 + 0.5d0*x15 + 0.5d0*x16 + x23 - x24 
     /      - 10.0d0

      e37 = 5.0d0*b5 - 5.0d0*b6 + 0.5d0*x19 + 0.5d0*x20 - x26 + x27
     /      - 5.0d0   

      e38 = 5.0d0*b5 + 5.0d0*b6 + 0.5d0*x19 + 0.5d0*x20 + x26 - x27 
     /     - 10.0d0  

      e39 = 10.0d0/x14 - x18    

      e40 = 10.0d0/x18 - x14    

      e41 = 15.0d0/x15 - x19    

      e42 = 15.0d0/x19 - x15    

      e43 = 19.0d0/x16 - x20    

      e44 = 19.0d0/x20 - x16    

      g(1) = -e2
      g(2) = -e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6
      g(6) = -e7
      g(7) = -e8
      g(8) = -e9
      g(9) = -e10
      g(10) = -e11
      g(11) = -e12
      g(12) = -e13
      g(13) = -e14
      g(14) = -e15
      g(15) = -e16
      g(16) = -e17
      g(17) = -e18
      g(18) = -e19
      g(19) = -e20
      g(20) = -e21
      g(21) = -e22
      g(22) = -e23
      g(23) = -e24
      g(24) = -e25
      g(25) = -e26
      g(26) = -e27
      g(27) = -e28
      g(28) = -e29
      g(29) = -e30
      g(30) = -e31
      g(31) = -e32
      g(32) = -e33
      g(33) = -e34
      g(34) = -e35
      g(35) = -e36
      g(36) = -e37
      g(37) = -e38
      g(38) = -e39
      g(39) = -e40
      g(40) = -e41
      g(41) = -e42
      g(42) = -e43
      g(43) = -e44

  999 continue
      return
      end
 

      subroutine m6(  mode,     m,     me,  mmax, ncont,  
     /                nbin,  nint,   nmax,     x,    xl,
     /                  xu,     f,      g,  pnam,  pref,
     /                 fex )    

*  MINLP written by GAMS Convert at 10/26/04 14:09:23
*  
*  Equation counts
*      Total        E        G        L        N        X        C
*        158        1        0      157        0        0        0
*  
*  Variable counts
*                   x        b        i      s1s      s2s       sc       si
*      Total     cont   binary  integer     sos1     sos2    scont     sint
*         87       57       30        0        0        0        0        0
*  FX      2        2        0        0        0        0        0        0
*  
*  Nonzero counts
*      Total    const       NL      DLL
*        635      623       12        0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /             x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87
      double precision
     /           e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /       e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /       e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /       e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /       e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /       e151,e152,e153,e154,e155,e156,e157,e158
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'M6'
         pref  = '\cite{MINLPLib}'
         fex   = 82.2569d0
         ncont = 56
         nint  = 0
         nbin  = 30
         n     = ncont + nbin + nint
         m     = 157
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d5
            x(i)  = 0.0d0
            xu(i) = 1.0d5
         enddo
         xl(31) = 2.8d0
         x(31)  = 3.0d0
         xu(31) = 7.4833d0
         xl(32) = 2.0d0
         x(32)  = 3.0d0
         xu(32) = 6.3246d0
         xl(33) = 1.8d0
         x(33)  = 3.0d0
         xu(33) = 6.d0
         xl(34) = 1.2247d0
         x(34)  = 2.0d0
         xu(34) = 4.899d0
         xl(35) = 2.0d0
         x(35)  = 3.0d0
         xu(35) = 6.3246d0
         xl(36) = 5.0d0
         x(36)  = 7.0d0
         xu(36) = 10.00
         xl(37) = 15.0d0
         x(37)  = 15.0d0
         xu(37) = 15.0d0
         xl(38) = 1.8708d0
         x(38)  = 2.0d0
         xu(38) = 5.0d0
         xl(39) = 1.58110d0
         x(39)  = 2.0d0
         xu(39) = 5.0d0
         xl(40) = 1.5d0
         x(40)  = 3.0d0
         xu(40) = 5.0d0
         xl(41) = 1.2247d0
         x(41)  = 2.0d0
         xu(41) = 4.899d0
         xl(42) = 1.5811d0
         x(42)  = 3.0d0
         xu(42) = 5.0d0
         xl(43) = 2.5d0
         x(43)  = 3.0d0
         xu(43) = 5.0d0
         xl(44) = 5.0d0
         x(44)  = 5.0d0
         xu(44) = 5.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      x32 = x(1)
      x33 = x(2)
      x34 = x(3)
      x35 = x(4)
      x36 = x(5)
      x37 = x(6)
      x38 = x(7)
      x39 = x(8)
      x40 = x(9)
      x41 = x(10)
      x42 = x(11)
      x43 = x(12)
      x44 = x(13)
      x45 = x(14)
      x46 = x(15)
      x47 = x(16)
      x48 = x(17)
      x49 = x(18)
      x50 = x(19)
      x51 = x(20)
      x52 = x(21)
      x53 = x(22)
      x54 = x(23)
      x55 = x(24)
      x56 = x(25)
      x57 = x(26)
      x58 = x(27)
      x59 = x(28)
      x60 = x(29)
      x61 = x(30)
      x62 = x(31)
      x63 = x(32)
      x64 = x(33)
      x65 = x(34)
      x66 = x(35)
      x67 = x(36)
      x68 = x(37)
      x69 = x(38)
      x70 = x(39)
      x71 = x(40)
      x72 = x(41)
      x73 = x(42)
      x74 = x(43)
      x75 = x(44)
      x76 = x(45)
      x77 = x(46)
      x78 = x(47)
      x79 = x(48)
      x80 = x(49)
      x81 = x(50)
      x82 = x(51)
      x83 = x(52)
      x84 = x(53)
      x85 = x(54)
      x86 = x(55)
      x87 = x(56)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)
      b26 = y(26)
      b27 = y(27)
      b28 = y(28)
      b29 = y(29)
      b30 = y(30)

      f = -(-2.4d0*x32 - 2.4d0*x33 - 12.0d0*x50 - 12.0d0*x51 
     /    - 12.0d0*x58 - 12.0d0*x59 - 6.0d0*x60 - 6.0d0*x61)

      e2 = x76 - x77         

      e3 = 0.5d0*x62 - x68 + x76                                    

      e4 = 0.5d0*x62 - x76     

      e5 = 0.5d0*x69 - x75 + x82                                    

      e6 = 0.5d0*x69 - x82     

      e7 = 0.5d0*x63 - x68 + x77                                    

      e8 = 0.5d0*x63 - x77     

      e9 = 0.5d0*x70 - x75 + x83                                    

      e10 = 0.5d0*x70 - x83    

      e11 = 0.5d0*x64 - x68 + x78                                   

      e12 = 0.5d0*x64 - x78    

      e13 = 0.5d0*x71 - x75 + x84                                   

      e14 = 0.5d0*x71 - x84    

      e15 = 0.5d0*x65 - x68 + x79                                   

      e16 = 0.5d0*x65 - x79    

      e17 = 0.5d0*x72 - x75 + x85                                   

      e18 = 0.5d0*x72 - x85    

      e19 = 0.5d0*x66 - x68 + x80                                   

      e20 = 0.5d0*x66 - x80    

      e21 = 0.5d0*x73 - x75 + x86                                   

      e22 = 0.5d0*x73 - x86    

      e23 = 0.5d0*x67 - x68 + x81                                   

      e24 = 0.5d0*x67 - x81    

      e25 = 0.5d0*x74 - x75 + x87                                   

      e26 = 0.5d0*x74 - x87    

      e27 = -x32 + x76 - x77  

      e28 = -x32 - x76 + x77  

      e29 = -x33 + x82 - x83  

      e30 = -x33 - x82 + x83  

      e31 = -15.0d0*b1 - 15.0d0*b2 + 0.5d0*x62 + 0.5d0*x63 - x76 + x77 

      e32 = -15.0d0*b1 + 15.0d0*b2 + 0.5d0*x62 + 0.5d0*x63 + x76 - x77 
     /      - 15.0d0 

      e33 = 5.0d0*b1 - 5.0d0*b2 + 0.5d0*x69 + 0.5d0*x70 - x82 + x83 
     /      - 5.0d0    

      e34 = 5.0d0*b1 + 5.0d0*b2 + 0.5d0*x69 + 0.5d0*x70 + x82 - x83
     /      - 10.0d0   

      e35 = -x34 + x76 - x78  

      e36 = -x34 - x76 + x78  

      e37 = -x35 + x82 - x84  

      e38 = -x35 - x82 + x84  

      e39 = -15.0d0*b3 - 15.0d0*b4 + 0.5d0*x62 + 0.5d0*x64 - x76 + x78 

      e40 = -15.0d0*b3 + 15.0d0*b4 + 0.5d0*x62 + 0.5d0*x64 + x76 - x78 
     /      - 15.0d0 

      e41 = 5.0d0*b3 - 5.0d0*b4 + 0.5d0*x69 + 0.5d0*x71 - x82 + x84
     /      - 5.0d0    

      e42 = 5.0d0*b3 + 5.0d0*b4 + 0.5d0*x69 + 0.5d0*x71 + x82 - x84 
     /      - 10.0d0   

      e43 = -x36 + x76 - x79  

      e44 = -x36 - x76 + x79  

      e45 = -x37 + x82 - x85  

      e46 = -x37 - x82 + x85  

      e47 = -15.0d0*b5 - 15.0d0*b6 + 0.5d0*x62 + 0.5d0*x65 - x76 + x79 

      e48 = -15.0d0*b5 + 15.0d0*b6 + 0.5d0*x62 + 0.5d0*x65 + x76 - x79 
     /      - 15.0d0 

      e49 = 5.0d0*b5 - 5.0d0*b6 + 0.5d0*x69 + 0.5d0*x72 - x82 + x85 
     /      - 5.0d0    

      e50 = 5.0d0*b5 + 5.0d0*b6 + 0.5d0*x69 + 0.5d0*x72 + x82 - x85 
     /      - 10.0d0   

      e51 = -x38 + x76 - x80  

      e52 = -x38 - x76 + x80  

      e53 = -x39 + x82 - x86  

      e54 = -x39 - x82 + x86  

      e55 = -15.0d0*b7 - 15.0d0*b8 + 0.5d0*x62 + 0.5d0*x66 - x76 + x80 

      e56 = -15.0d0*b7 + 15.0d0*b8 + 0.5d0*x62 + 0.5d0*x66 + x76 - x80 
     /      - 15.0d0 

      e57 = 5.0d0*b7 - 5.0d0*b8 + 0.5d0*x69 + 0.5d0*x73 - x82 + x86 
     /      - 5.0d0    

      e58 = 5.0d0*b7 + 5.0d0*b8 + 0.5d0*x69 + 0.5d0*x73 + x82 - x86 
     /      - 10.0d0   

      e59 = -x40 + x76 - x81  

      e60 = -x40 - x76 + x81  

      e61 = -x41 + x82 - x87  

      e62 = -x41 - x82 + x87  

      e63 = -15.0d0*b9 - 15.0d0*b10 + 0.5d0*x62 + 0.5d0*x67 - x76 + x81

      e64 = -15.0d0*b9 + 15.0d0*b10 + 0.5d0*x62 + 0.5d0*x67 + x76 - x81
     /      - 15.0d0

      e65 = 5.0d0*b9 - 5.0d0*b10 + 0.5d0*x69 + 0.5d0*x74 - x82 + x87 
     /      - 5.0d0   

      e66 = 5.0d0*b9 + 5.0d0*b10 + 0.5d0*x69 + 0.5d0*x74 + x82 - x87
     /      - 10.0d0  

      e67 = -x42 + x77 - x78  

      e68 = -x42 - x77 + x78  

      e69 = -x43 + x83 - x84  

      e70 = -x43 - x83 + x84  

      e71 = -15.0d0*b11 - 15.0d0*b12 + 0.5d0*x63 + 0.5d0*x64 - x77 + x78

      e72 = -15.0d0*b11 + 15.0d0*b12 + 0.5d0*x63 + 0.5d0*x64 + x77 - x78
     /     - 15.0d0

      e73 = 5.0d0*b11 - 5.0d0*b12 + 0.5d0*x70 + 0.5d0*x71 - x83 + x84
     /      - 5.0d0  

      e74 = 5.0d0*b11 + 5.0d0*b12 + 0.5d0*x70 + 0.5d0*x71 + x83 - x84 
     /      - 10.0d0 

      e75 = -x44 + x77 - x79  

      e76 = -x44 - x77 + x79  

      e77 = -x45 + x83 - x85  

      e78 = -x45 - x83 + x85  

      e79 = -15.0d0*b13 - 15.0d0*b14 + 0.5d0*x63 + 0.5d0*x65 - x77 + x79

      e80 = -15.0d0*b13 + 15.0d0*b14 + 0.5d0*x63 + 0.5d0*x65 + x77 - x79
     /      - 15.0d0

      e81 = 5.0d0*b13 - 5.0d0*b14 + 0.5d0*x70 + 0.5d0*x72 - x83 + x85 
     /      - 5.0d0  

      e82 = 5.0d0*b13 + 5.0d0*b14 + 0.5d0*x70 + 0.5d0*x72 + x83 - x85 
     /      - 10.0d0 

      e83 = -x46 + x77 - x80  

      e84 = -x46 - x77 + x80  

      e85 = -x47 + x83 - x86  

      e86 = -x47 - x83 + x86  

      e87 = -15.0d0*b15 - 15.0d0*b16 + 0.5d0*x63 + 0.5d0*x66 - x77 + x80

      e88 = -15.0d0*b15 + 15.0d0*b16 + 0.5d0*x63 + 0.5d0*x66 + x77 - x80
     /      - 15.0d0

      e89 = 5.0d0*b15 - 5.0d0*b16 + 0.5d0*x70 + 0.5d0*x73 - x83 + x86
     /      - 5.0d0  

      e90 = 5.0d0*b15 + 5.0d0*b16 + 0.5d0*x70 + 0.5d0*x73 + x83 - x86 
     /      - 10.0d0 

      e91 = -x48 + x77 - x81  

      e92 = -x48 - x77 + x81  

      e93 = -x49 + x83 - x87  

      e94 = -x49 - x83 + x87  

      e95 = -15.0d0*b17 - 15.0d0*b18 + 0.5d0*x63 + 0.5d0*x67 - x77 + x81

      e96 = -15.0d0*b17 + 15.0d0*b18 + 0.5d0*x63 + 0.5d0*x67 + x77 - x81
     /      - 15.0d0

      e97 = 5.0d0*b17 - 5.0d0*b18 + 0.5d0*x70 + 0.5d0*x74 - x83 + x87
     /      - 5.0d0  

      e98 = 5.0d0*b17 + 5.0d0*b18 + 0.5d0*x70 + 0.5d0*x74 + x83 - x87
     /      - 10.0d0 

      e99 = -x50 + x78 - x79  

      e100 = -x50 - x78 + x79 

      e101 = -x51 + x84 - x85 

      e102 = -x51 - x84 + x85 

      e103 = -15.0d0*b19 - 15.0d0*b20 + 0.5d0*x64 + 0.5d0*x65 - x78 
     /       + x79      

      e104 = -15.0d0*b19 + 15.0d0*b20 + 0.5d0*x64 + 0.5d0*x65 + x78 
     /       - x79 - 15.0d0                                   

      e105 = 5.0d0*b19 - 5.0d0*b20 + 0.5d0*x71 + 0.5d0*x72 - x84 + x85 
     /      - 5.0d0 

      e106 = 5.0d0*b19 + 5.0d0*b20 + 0.5d0*x71 + 0.5d0*x72 + x84 - x85
     /       - 10.0d0

      e107 = -x52 + x78 - x80 

      e108 = -x52 - x78 + x80 

      e109 = -x53 + x84 - x86 

      e110 = -x53 - x84 + x86 

      e111 = -15.0d0*b21 - 15.0d0*b22 + 0.5d0*x64 + 0.5d0*x66 - x78 
     /       + x80      

      e112 = -15.0d0*b21 + 15.0d0*b22 + 0.5d0*x64 + 0.5d0*x66 + x78 
     /      - x80 - 15.0d0                                   

      e113 = 5.0d0*b21 - 5.0d0*b22 + 0.5d0*x71 + 0.5d0*x73 - x84 + x86 
     /      - 5.0d0 

      e114 = 5.0d0*b21 + 5.0d0*b22 + 0.5d0*x71 + 0.5d0*x73 + x84 - x86
     /       - 10.0d0

      e115 = -x54 + x78 - x81 

      e116 = -x54 - x78 + x81 

      e117 = -x55 + x84 - x87 

      e118 = -x55 - x84 + x87 

      e119 = -15.0d0*b23 - 15.0d0*b24 + 0.5d0*x64 + 0.5d0*x67 - x78 
     /       + x81      

      e120 = -15.0d0*b23 + 15.0d0*b24 + 0.5d0*x64 + 0.5d0*x67 + x78 
     /       - x81 - 15.0d0                                   

      e121 = 5.0d0*b23 - 5.0d0*b24 + 0.5d0*x71 + 0.5d0*x74 - x84 + x87
     /       - 5.0d0 

      e122 = 5.0d0*b23 + 5.0d0*b24 + 0.5d0*x71 + 0.5d0*x74 + x84 - x87 
     /       - 10.0d0

      e123 = -x56 + x79 - x80 

      e124 = -x56 - x79 + x80 

      e125 = -x57 + x85 - x86 

      e126 = -x57 - x85 + x86 

      e127 = -15.0d0*b25 - 15.0d0*b26 + 0.5d0*x65 + 0.5d0*x66 - x79
     /       + x80      

      e128 = -15.0d0*b25 + 15.0d0*b26 + 0.5d0*x65 + 0.5d0*x66 + x79
     /       - x80 - 15.0d0                                   

      e129 = 5.0d0*b25 - 5.0d0*b26 + 0.5d0*x72 + 0.5d0*x73 - x85 + x86 
     /       - 5.0d0 

      e130 = 5.0d0*b25 + 5.0d0*b26 + 0.5d0*x72 + 0.5d0*x73 + x85 - x86 
     /       - 10.0d0

      e131 = -x58 + x79 - x81 

      e132 = -x58 - x79 + x81 

      e133 = -x59 + x85 - x87 

      e134 = -x59 - x85 + x87 

      e135 = -15.0d0*b27 - 15.0d0*b28 + 0.5d0*x65 + 0.5d0*x67 - x79
     /       + x81      

      e136 = -15.0d0*b27 + 15.0d0*b28 + 0.5d0*x65 + 0.5d0*x67 + x79 
     /      - x81 - 15.0d0                                   

      e137 = 5.0d0*b27 - 5.0d0*b28 + 0.5d0*x72 + 0.5d0*x74 - x85 + x87 
     /       - 5.0d0 

      e138 = 5.0d0*b27 + 5.0d0*b28 + 0.5d0*x72 + 0.5d0*x74 + x85 - x87 
     /       - 10.0d0

      e139 = -x60 + x80 - x81 

      e140 = -x60 - x80 + x81 

      e141 = -x61 + x86 - x87 

      e142 = -x61 - x86 + x87 

      e143 = -15.0d0*b29 - 15.0d0*b30 + 0.5d0*x66 + 0.5d0*x67 - x80
     /       + x81      

      e144 = -15.0d0*b29 + 15.0d0*b30 + 0.5d0*x66 + 0.5d0*x67 + x80 
     /       - x81 - 15.0d0                                   

      e145 = 5.0d0*b29 - 5.0d0*b30 + 0.5d0*x73 + 0.5d0*x74 - x86 + x87 
     /       - 5.0d0 

      e146 = 5.0d0*b29 + 5.0d0*b30 + 0.5d0*x73 + 0.5d0*x74 + x86 - x87 
     /       - 10.0d0

      e147 = 14.0d0/x62 - x69       

      e148 = 14.0d0/x69 - x62       

      e149 = 10.0d0/x63 - x70       

      e150 = 10.0d0/x70 - x63       

      e151 = 9.0d0/x64 - x71        

      e152 = 9.0d0/x71 - x64        

      e153 = 6.0d0/x65 - x72        

      e154 = 6.0d0/x72 - x65        

      e155 = 10.0d0/x66 - x73       

      e156 = 10.0d0/x73 - x66       

      e157 = 25.0d0/x67 - x74       

      e158 = 25.0d0/x74 - x67       

      g(  1) = -e2
      g(  2) = -e3
      g(  3) = -e4
      g(  4) = -e5
      g(  5) = -e6
      g(  6) = -e7
      g(  7) = -e8
      g(  8) = -e9
      g(  9) = -e10
      g( 10) = -e11
      g( 11) = -e12
      g( 12) = -e13
      g( 13) = -e14
      g( 14) = -e15
      g( 15) = -e16
      g( 16) = -e17
      g( 17) = -e18
      g( 18) = -e19
      g( 19) = -e20
      g( 20) = -e21
      g( 21) = -e22
      g( 22) = -e23
      g( 23) = -e24
      g( 24) = -e25
      g( 25) = -e26
      g( 26) = -e27
      g( 27) = -e28
      g( 28) = -e29
      g( 29) = -e30
      g( 30) = -e31
      g( 31) = -e32
      g( 32) = -e33
      g( 33) = -e34
      g( 34) = -e35
      g( 35) = -e36
      g( 36) = -e37
      g( 37) = -e38
      g( 38) = -e39
      g( 39) = -e40
      g( 40) = -e41
      g( 41) = -e42
      g( 42) = -e43
      g( 43) = -e44
      g( 44) = -e45
      g( 45) = -e46
      g( 46) = -e47
      g( 47) = -e48
      g( 48) = -e49
      g( 49) = -e50
      g( 50) = -e51
      g( 51) = -e52
      g( 52) = -e53
      g( 53) = -e54
      g( 54) = -e55
      g( 55) = -e56
      g( 56) = -e57
      g( 57) = -e58
      g( 58) = -e59
      g( 59) = -e60
      g( 60) = -e61
      g( 61) = -e62
      g( 62) = -e63
      g( 63) = -e64
      g( 64) = -e65
      g( 65) = -e66
      g( 66) = -e67
      g( 67) = -e68
      g( 68) = -e69
      g( 69) = -e70
      g( 70) = -e71
      g( 71) = -e72
      g( 72) = -e73
      g( 73) = -e74
      g( 74) = -e75
      g( 75) = -e76
      g( 76) = -e77
      g( 77) = -e78
      g( 78) = -e79
      g( 79) = -e80
      g( 80) = -e81
      g( 81) = -e82
      g( 82) = -e83
      g( 83) = -e84
      g( 84) = -e85
      g( 85) = -e86
      g( 86) = -e87
      g( 87) = -e88
      g( 88) = -e89
      g( 89) = -e90
      g( 90) = -e91
      g( 91) = -e92
      g( 92) = -e93
      g( 93) = -e94
      g( 94) = -e95
      g( 95) = -e96
      g( 96) = -e97
      g( 97) = -e98
      g( 98) = -e99
      g( 99) = -e100
      g(100) = -e101
      g(101) = -e102
      g(102) = -e103
      g(103) = -e104
      g(104) = -e105
      g(105) = -e106
      g(106) = -e107
      g(107) = -e108
      g(108) = -e109
      g(109) = -e110
      g(110) = -e111
      g(111) = -e112
      g(112) = -e113
      g(113) = -e114
      g(114) = -e115
      g(115) = -e116
      g(116) = -e117
      g(117) = -e118
      g(118) = -e119
      g(119) = -e120
      g(120) = -e121
      g(121) = -e122
      g(122) = -e123
      g(123) = -e124
      g(124) = -e125
      g(125) = -e126
      g(126) = -e127
      g(127) = -e128
      g(128) = -e129
      g(129) = -e130
      g(130) = -e131
      g(131) = -e132
      g(132) = -e133
      g(133) = -e134
      g(134) = -e135
      g(135) = -e136
      g(136) = -e137
      g(137) = -e138
      g(138) = -e139
      g(139) = -e140
      g(140) = -e141
      g(141) = -e142
      g(142) = -e143
      g(143) = -e144
      g(144) = -e145
      g(145) = -e146
      g(146) = -e147
      g(147) = -e148
      g(148) = -e149
      g(149) = -e150
      g(150) = -e151
      g(151) = -e152
      g(152) = -e153
      g(153) = -e154
      g(154) = -e155
      g(155) = -e156
      g(156) = -e157
      g(157) = -e158

  999 continue
      return
      end
 

      subroutine m7(  mode,     m,     me,  mmax, ncont,  
     /                nbin,  nint,   nmax,     x,    xl,
     /                  xu,     f,      g,  pnam,  pref,
     /                 fex )    

*  MINLP written by GAMS Convert at 10/26/04 14:09:24
*  
*  Equation counts
*      Total        E        G        L        N        X        C
*        212        1        0      211        0        0        0
*  
*  Variable counts
*                   x        b        i      s1s      s2s       sc       si
*      Total     cont   binary  integer     sos1     sos2    scont     sint
*        115       73       42        0        0        0        0        0
*  FX      2        2        0        0        0        0        0        0
*  
*  Nonzero counts
*      Total    const       NL      DLL
*        867      853       14        0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /        b31, b32, b33, b34, b35, b36, b37, b38, b39, b40,
     /        b41, b42,      x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /        x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /       x101,x102,x103,x104,x105,x106,x107,x108,x109,x110,
     /       x111,x112,x113,x114,x115  
      double precision
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100
      double precision
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /       e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /       e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /       e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /       e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /       e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /       e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /       e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /       e181,e182,e183,e184,e185,e186,e187,e188,e189,e190,
     /       e191,e192,e193,e194,e195,e196,e197,e198,e199,e200,
     /       e201,e202,e203,e204,e205,e206,e207,e208,e209,e210,
     /       e211,e212
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'M7'
         pref  = '\cite{MINLPLib}'
         fex   = 106.7569d0
         ncont = 72
         nint  = 0
         nbin  = 42
         n     = ncont + nbin + nint
         m     = 211
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d-5
            x(i)  = 0.0d0
            xu(i) = 1.0d5
         enddo
         xl(43) = 2.8d0
         x(43)  = 3.0d0
         xu(43) = 7.4833d0
         xl(44) = 2.0d0
         x(44)  = 3.0d0
         xu(44) = 6.3246d0
         xl(45) = 1.8d0
         x(45)  = 3.0d0
         xu(45) = 6.d0
         xl(46) = 1.2247d0
         x(46)  = 2.0d0
         xu(46) = 4.899d0
         xl(47) = 2.0d0
         x(47)  = 3.0d0
         xu(47) = 6.3246d0
         xl(48) = 5.0d0
         x(48)  = 7.0d0
         xu(48) = 10.00
         xl(49) = 5.0d0
         x(49)  = 7.0d0
         xu(49) = 10.00
         xl(50) = 20.0d0
         x(50)  = 20.0d0
         xu(50) = 20.00
         xl(51) = 1.8708d0
         x(51)  = 2.0d0
         xu(51) = 5.0d0
         xl(52) = 1.58110d0
         x(52)  = 2.0d0
         xu(52) = 5.0d0
         xl(53) = 1.5d0
         x(53)  = 3.0d0
         xu(53) = 5.0d0
         xl(54) = 1.2247d0
         x(54)  = 2.0d0
         xu(54) = 4.899d0
         xl(55) = 1.5811d0
         x(55)  = 3.0d0
         xu(55) = 5.0d0
         xl(56) = 2.5d0
         x(56)  = 3.0d0
         xu(56) = 5.0d0
         xl(57) = 2.5d0
         x(57)  = 3.0d0
         xu(57) = 5.0d0
         xl(58) = 5.0d0
         x(58)  = 5.0d0
         xu(58) = 5.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      x44 = x(1)
      x45 = x(2)
      x46 = x(3)
      x47 = x(4)
      x48 = x(5)
      x49 = x(6)
      x50 = x(7)
      x51 = x(8)
      x52 = x(9)
      x53 = x(10)
      x54 = x(11)
      x55 = x(12)
      x56 = x(13)
      x57 = x(14)
      x58 = x(15)
      x59 = x(16)
      x60 = x(17)
      x61 = x(18)
      x62 = x(19)
      x63 = x(20)
      x64 = x(21)
      x65 = x(22)
      x66 = x(23)
      x67 = x(24)
      x68 = x(25)
      x69 = x(26)
      x70 = x(27)
      x71 = x(28)
      x72 = x(29)
      x73 = x(30)
      x74 = x(31)
      x75 = x(32)
      x76 = x(33)
      x77 = x(34)
      x78 = x(35)
      x79 = x(36)
      x80 = x(37)
      x81 = x(38)
      x82 = x(39)
      x83 = x(40)
      x84 = x(41)
      x85 = x(42)
      x86 = x(43)
      x87 = x(44)
      x88 = x(45)
      x89 = x(46)
      x90 = x(47)
      x91 = x(48)
      x92 = x(49)
      x93 = x(50)
      x94 = x(51)
      x95 = x(52)
      x96 = x(53)
      x97 = x(54)
      x98 = x(55)
      x99 = x(56)
      x100 = x(57)
      x101 = x(58)
      x102 = x(59)
      x103 = x(60)
      x104 = x(61)
      x105 = x(62)
      x106 = x(63)
      x107 = x(64)
      x108 = x(65)
      x109 = x(66)
      x110 = x(67)
      x111 = x(68)
      x112 = x(69)
      x113 = x(70)
      x114 = x(71)
      x115 = x(72)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)
      b26 = y(26)
      b27 = y(27)
      b28 = y(28)
      b29 = y(29)
      b30 = y(30)
      b31 = y(31)
      b32 = y(32)
      b33 = y(33)
      b34 = y(34)
      b35 = y(35)
      b36 = y(36)
      b37 = y(37)
      b38 = y(38)
      b39 = y(39)
      b40 = y(40)
      b41 = y(41)
      b42 = y(42)

      f = -(-2.4d0*x44 - 2.4d0*x45 - 7.0d0*x64 - 7.0d0*x65 - 12.0d0*x66
     /   - 12.0d0*x67 - 12.0d0*x76 - 12.0d0*x77 - 6.0d0*x80 - 6.0d0*x81)

      e2 = x102 - x103         

      e3 = 0.5d0*x86 - x93 + x102

      e4 = 0.5d0*x86 - x102      

      e5 = 0.5d0*x94 - x101 + x109

      e6 = 0.5d0*x94 - x109      

      e7 = 0.5d0*x87 - x93 + x103

      e8 = 0.5d0*x87 - x103      

      e9 = 0.5d0*x95 - x101 + x110

      e10 = 0.5d0*x95 - x110     

      e11 = 0.5d0*x88 - x93 + x104

      e12 = 0.5d0*x88 - x104     

      e13 = 0.5d0*x96 - x101 + x111 

      e14 = 0.5d0*x96 - x111     

      e15 = 0.5d0*x89 - x93 + x105

      e16 = 0.5d0*x89 - x105     

      e17 = 0.5d0*x97 - x101 + x112 

      e18 = 0.5d0*x97 - x112     

      e19 = 0.5d0*x90 - x93 + x106

      e20 = 0.5d0*x90 - x106     

      e21 = 0.5d0*x98 - x101 + x113 

      e22 = 0.5d0*x98 - x113     

      e23 = 0.5d0*x91 - x93 + x107

      e24 = 0.5d0*x91 - x107     

      e25 = 0.5d0*x99 - x101 + x114 

      e26 = 0.5d0*x99 - x114     

      e27 = 0.5d0*x92 - x93 + x108

      e28 = 0.5d0*x92 - x108     

      e29 = 0.5d0*x100 - x101 + x115

      e30 = 0.5d0*x100 - x115    

      e31 = -x44 + x102 - x103  

      e32 = -x44 - x102 + x103  

      e33 = -x45 + x109 - x110  

      e34 = -x45 - x109 + x110  

      e35 = -20.0d0*b1 - 20.0d0*b2 + 0.5d0*x86 + 0.5d0*x87 - x102 + x103

      e36 = -20.0d0*b1 + 20.0d0*b2 + 0.5d0*x86 + 0.5d0*x87 + x102 - x103
     /      - 20.0d0  

      e37 = 5.0d0*b1 - 5.0d0*b2 + 0.5d0*x94 + 0.5d0*x95 - x109 + x110 
     /     - 5.0d0  

      e38 = 5.0d0*b1 + 5.0d0*b2 + 0.5d0*x94 + 0.5d0*x95 + x109 - x110 
     /     - 10.0d0    

      e39 = -x46 + x102 - x104  

      e40 = -x46 - x102 + x104  

      e41 = -x47 + x109 - x111  

      e42 = -x47 - x109 + x111  

      e43 = -20.0d0*b3 - 20.0d0*b4 + 0.5d0*x86 + 0.5d0*x88 - x102 + x104

      e44 = -20.0d0*b3 + 20.0d0*b4 + 0.5d0*x86 + 0.5d0*x88 + x102 - x104
     /      - 20.0d0  

      e45 = 5.0d0*b3 - 5.0d0*b4 + 0.5d0*x94 + 0.5d0*x96 - x109 + x111
     /      - 5.0d0  

      e46 = 5.0d0*b3 + 5.0d0*b4 + 0.5d0*x94 + 0.5d0*x96 + x109 - x111 
     /     - 10.0d0    

      e47 = -x48 + x102 - x105  

      e48 = -x48 - x102 + x105  

      e49 = -x49 + x109 - x112  

      e50 = -x49 - x109 + x112  

      e51 = -20.0d0*b5 - 20.0d0*b6 + 0.5d0*x86 + 0.5d0*x89 - x102 + x105

      e52 = -20.0d0*b5 + 20.0d0*b6 + 0.5d0*x86 + 0.5d0*x89 + x102 - x105
     /      - 20.0d0  

      e53 = 5.0d0*b5 - 5.0d0*b6 + 0.5d0*x94 + 0.5d0*x97 - x109 + x112
     /      - 5.0d0  

      e54 = 5.0d0*b5 + 5.0d0*b6 + 0.5d0*x94 + 0.5d0*x97 + x109 - x112
     /      - 10.0d0    

      e55 = -x50 + x102 - x106  

      e56 = -x50 - x102 + x106  

      e57 = -x51 + x109 - x113  

      e58 = -x51 - x109 + x113  

      e59 = -20.0d0*b7 - 20.0d0*b8 + 0.5d0*x86 + 0.5d0*x90 - x102 + x106

      e60 = -20.0d0*b7 + 20.0d0*b8 + 0.5d0*x86 + 0.5d0*x90 + x102 - x106
     /      - 20.0d0  

      e61 = 5.0d0*b7 - 5.0d0*b8 + 0.5d0*x94 + 0.5d0*x98 - x109 + x113
     /      - 5.0d0  

      e62 = 5.0d0*b7 + 5.0d0*b8 + 0.5d0*x94 + 0.5d0*x98 + x109 - x113
     /      - 10.0d0    

      e63 = -x52 + x102 - x107  

      e64 = -x52 - x102 + x107  

      e65 = -x53 + x109 - x114  

      e66 = -x53 - x109 + x114  

      e67 = -20.0d0*b9 - 20.0d0*b10 + 0.5d0*x86 + 0.5d0*x91 - x102
     /      + x107       

      e68 = -20.0d0*b9 + 20.0d0*b10 + 0.5d0*x86 + 0.5d0*x91 + x102 
     /     - x107 - 20.0d0 

      e69 = 5.0d0*b9 - 5.0d0*b10 + 0.5d0*x94 + 0.5d0*x99 - x109 + x114
     /      - 5.0d0 

      e70 = 5.0d0*b9 + 5.0d0*b10 + 0.5d0*x94 + 0.5d0*x99 + x109 - x114
     /      - 10.0d0   

      e71 = -x54 + x102 - x108  

      e72 = -x54 - x102 + x108  

      e73 = -x55 + x109 - x115  

      e74 = -x55 - x109 + x115  

      e75 = -20.0d0*b11 - 20.0d0*b12 + 0.5d0*x86 + 0.5d0*x92 - x102 
     /      + x108      

      e76 = -20.0d0*b11 + 20.0d0*b12 + 0.5d0*x86 + 0.5d0*x92 + x102 
     /      - x108 - 20.0d0

      e77 = 5.0d0*b11 - 5.0d0*b12 + 0.5d0*x94 + 0.5d0*x100 - x109 
     /      + x115 - 5.0d0

      e78 = 5.0d0*b11 + 5.0d0*b12 + 0.5d0*x94 + 0.5d0*x100 + x109 - x115
     /      - 10.0d0 

      e79 = -x56 + x103 - x104  

      e80 = -x56 - x103 + x104  

      e81 = -x57 + x110 - x111  

      e82 = -x57 - x110 + x111  

      e83 = -20.0d0*b13 - 20.0d0*b14 + 0.5d0*x87 + 0.5d0*x88 - x103 
     /      + x104      

      e84 = -20.0d0*b13 + 20.0d0*b14 + 0.5d0*x87 + 0.5d0*x88 + x103 
     /      - x104 - 20.0d0

      e85 = 5.0d0*b13 - 5.0d0*b14 + 0.5d0*x95 + 0.5d0*x96 - x110 + x111 
     /      - 5.0d0

      e86 = 5.0d0*b13 + 5.0d0*b14 + 0.5d0*x95 + 0.5d0*x96 + x110 - x111
     /      - 10.0d0  

      e87 = -x58 + x103 - x105  

      e88 = -x58 - x103 + x105  

      e89 = -x59 + x110 - x112  

      e90 = -x59 - x110 + x112  

      e91 = -20.0d0*b15 - 20.0d0*b16 + 0.5d0*x87 + 0.5d0*x89 - x103 
     /      + x105      

      e92 = -20.0d0*b15 + 20.0d0*b16 + 0.5d0*x87 + 0.5d0*x89 + x103 
     /      - x105 - 20.0d0

      e93 = 5.0d0*b15 - 5.0d0*b16 + 0.5d0*x95 + 0.5d0*x97 - x110 + x112
     /      - 5.0d0

      e94 = 5.0d0*b15 + 5.0d0*b16 + 0.5d0*x95 + 0.5d0*x97 + x110 - x112
     /      - 10.0d0  

      e95 = -x60 + x103 - x106  

      e96 = -x60 - x103 + x106  

      e97 = -x61 + x110 - x113  

      e98 = -x61 - x110 + x113  

      e99 = -20.0d0*b17 - 20.0d0*b18 + 0.5d0*x87 + 0.5d0*x90 - x103 
     /      + x106      

      e100 = -20.0d0*b17 + 20.0d0*b18 + 0.5d0*x87 + 0.5d0*x90 + x103
     /       - x106 - 20.0d0

      e101 = 5.0d0*b17 - 5.0d0*b18 + 0.5d0*x95 + 0.5d0*x98 - x110 + x113
     /       - 5.0d0

      e102 = 5.0d0*b17 + 5.0d0*b18 + 0.5d0*x95 + 0.5d0*x98 + x110 - x113
     /       - 10.0d0 

      e103 = -x62 + x103 - x107 

      e104 = -x62 - x103 + x107 

      e105 = -x63 + x110 - x114 

      e106 = -x63 - x110 + x114 

      e107 = -20.0d0*b19 - 20.0d0*b20 + 0.5d0*x87 + 0.5d0*x91 - x103 
     /       + x107     

      e108 = -20.0d0*b19 + 20.0d0*b20 + 0.5d0*x87 + 0.5d0*x91 + x103 
     /       - x107 - 20.0d0

      e109 = 5.0d0*b19 - 5.0d0*b20 + 0.5d0*x95 + 0.5d0*x99 - x110 + x114
     /       - 5.0d0

      e110 = 5.0d0*b19 + 5.0d0*b20 + 0.5d0*x95 + 0.5d0*x99 + x110 - x114
     /       - 10.0d0 

      e111 = -x64 + x103 - x108 

      e112 = -x64 - x103 + x108 

      e113 = -x65 + x110 - x115 

      e114 = -x65 - x110 + x115 

      e115 = -20.0d0*b21 - 20.0d0*b22 + 0.5d0*x87 + 0.5d0*x92 - x103
     /       + x108     

      e116 = -20.0d0*b21 + 20.0d0*b22 + 0.5d0*x87 + 0.5d0*x92 + x103 
     /       - x108 - 20.0d0

      e117 = 5.0d0*b21 - 5.0d0*b22 + 0.5d0*x95 + 0.5d0*x100 - x110
     /       + x115 - 5.0d0 

      e118 = 5.0d0*b21 + 5.0d0*b22 + 0.5d0*x95 + 0.5d0*x100 + x110 
     /      - x115 - 10.0d0

      e119 = -x66 + x104 - x105 

      e120 = -x66 - x104 + x105 

      e121 = -x67 + x111 - x112 

      e122 = -x67 - x111 + x112 

      e123 = -20.0d0*b23 - 20.0d0*b24 + 0.5d0*x88 + 0.5d0*x89 - x104 
     /       + x105     

      e124 = -20.0d0*b23 + 20.0d0*b24 + 0.5d0*x88 + 0.5d0*x89 + x104
     /       - x105 - 20.0d0

      e125 = 5.0d0*b23 - 5.0d0*b24 + 0.5d0*x96 + 0.5d0*x97 - x111 + x112
     /       - 5.0d0

      e126 = 5.0d0*b23 + 5.0d0*b24 + 0.5d0*x96 + 0.5d0*x97 + x111 - x112
     /       - 10.0d0 

      e127 = -x68 + x104 - x106 

      e128 = -x68 - x104 + x106 

      e129 = -x69 + x111 - x113 

      e130 = -x69 - x111 + x113 

      e131 = -20.0d0*b25 - 20.0d0*b26 + 0.5d0*x88 + 0.5d0*x90 - x104
     /       + x106     

      e132 = -20.0d0*b25 + 20.0d0*b26 + 0.5d0*x88 + 0.5d0*x90 + x104 
     /       - x106 - 20.0d0

      e133 = 5.0d0*b25 - 5.0d0*b26 + 0.5d0*x96 + 0.5d0*x98 - x111 + x113
     /       - 5.0d0

      e134 = 5.0d0*b25 + 5.0d0*b26 + 0.5d0*x96 + 0.5d0*x98 + x111 - x113
     /       - 10.0d0 

      e135 = -x70 + x104 - x107 

      e136 = -x70 - x104 + x107 

      e137 = -x71 + x111 - x114 

      e138 = -x71 - x111 + x114 

      e139 = -20.0d0*b27 - 20.0d0*b28 + 0.5d0*x88 + 0.5d0*x91 - x104 
     /       + x107     

      e140 = -20.0d0*b27 + 20.0d0*b28 + 0.5d0*x88 + 0.5d0*x91 + x104 
     /       - x107 - 20.0d0

      e141 = 5.0d0*b27 - 5.0d0*b28 + 0.5d0*x96 + 0.5d0*x99 - x111 + x114
     /       - 5.0d0

      e142 = 5.0d0*b27 + 5.0d0*b28 + 0.5d0*x96 + 0.5d0*x99 + x111 - x114
     /       - 10.0d0 

      e143 = -x72 + x104 - x108 

      e144 = -x72 - x104 + x108 

      e145 = -x73 + x111 - x115 

      e146 = -x73 - x111 + x115 

      e147 = -20.0d0*b29 - 20.0d0*b30 + 0.5d0*x88 + 0.5d0*x92 - x104 
     /       + x108     

      e148 = -20.0d0*b29 + 20.0d0*b30 + 0.5d0*x88 + 0.5d0*x92 + x104 
     /       - x108 - 20.0d0

      e149 = 5.0d0*b29 - 5.0d0*b30 + 0.5d0*x96 + 0.5d0*x100 - x111
     /       + x115 - 5.0d0 

      e150 = 5.0d0*b29 + 5.0d0*b30 + 0.5d0*x96 + 0.5d0*x100 + x111 
     /      - x115 - 10.0d0

      e151 = -x74 + x105 - x106 

      e152 = -x74 - x105 + x106 

      e153 = -x75 + x112 - x113 

      e154 = -x75 - x112 + x113 

      e155 = -20.0d0*b31 - 20.0d0*b32 + 0.5d0*x89 + 0.5d0*x90 - x105
     /       + x106     

      e156 = -20.0d0*b31 + 20.0d0*b32 + 0.5d0*x89 + 0.5d0*x90 + x105 
     /      - x106 - 20.0d0

      e157 = 5.0d0*b31 - 5.0d0*b32 + 0.5d0*x97 + 0.5d0*x98 - x112
     /       + x113 - 5.0d0

      e158 = 5.0d0*b31 + 5.0d0*b32 + 0.5d0*x97 + 0.5d0*x98 + x112
     /       - x113 - 10.0d0 

      e159 = -x76 + x105 - x107 

      e160 = -x76 - x105 + x107 

      e161 = -x77 + x112 - x114 

      e162 = -x77 - x112 + x114 

      e163 = -20.0d0*b33 - 20.0d0*b34 + 0.5d0*x89 + 0.5d0*x91 
     /       - x105 + x107     

      e164 = -20.0d0*b33 + 20.0d0*b34 + 0.5d0*x89 + 0.5d0*x91 + x105 
     /       - x107 - 20.0d0

      e165 = 5.0d0*b33 - 5.0d0*b34 + 0.5d0*x97 + 0.5d0*x99 - x112
     /       + x114 - 5.0d0

      e166 = 5.0d0*b33 + 5.0d0*b34 + 0.5d0*x97 + 0.5d0*x99 + x112 - x114
     /       - 10.0d0 

      e167 = -x78 + x105 - x108 

      e168 = -x78 - x105 + x108 

      e169 = -x79 + x112 - x115 

      e170 = -x79 - x112 + x115 

      e171 = -20.0d0*b35 - 20.0d0*b36 + 0.5d0*x89 + 0.5d0*x92 - x105 
     /       + x108     

      e172 = -20.0d0*b35 + 20.0d0*b36 + 0.5d0*x89 + 0.5d0*x92 + x105 
     /       - x108 - 20.0d0

      e173 = 5.0d0*b35 - 5.0d0*b36 + 0.5d0*x97 + 0.5d0*x100 - x112 
     /       + x115 - 5.0d0 

      e174 = 5.0d0*b35 + 5.0d0*b36 + 0.5d0*x97 + 0.5d0*x100 + x112
     /       - x115 - 10.0d0

      e175 = -x80 + x106 - x107 

      e176 = -x80 - x106 + x107 

      e177 = -x81 + x113 - x114 

      e178 = -x81 - x113 + x114 

      e179 = -20.0d0*b37 - 20.0d0*b38 + 0.5d0*x90 + 0.5d0*x91 - x106 
     /       + x107     

      e180 = -20.0d0*b37 + 20.0d0*b38 + 0.5d0*x90 + 0.5d0*x91 + x106 
     /       - x107 - 20.0d0

      e181 = 5.0d0*b37 - 5.0d0*b38 + 0.5d0*x98 + 0.5d0*x99 - x113 + x114
     /       - 5.0d0

      e182 = 5.0d0*b37 + 5.0d0*b38 + 0.5d0*x98 + 0.5d0*x99 + x113 - x114
     /       - 10.0d0 

      e183 = -x82 + x106 - x108 

      e184 = -x82 - x106 + x108 

      e185 = -x83 + x113 - x115 

      e186 = -x83 - x113 + x115 

      e187 = -20.0d0*b39 - 20.0d0*b40 + 0.5d0*x90 + 0.5d0*x92 - x106 
     /       + x108     

      e188 = -20.0d0*b39 + 20.0d0*b40 + 0.5d0*x90 + 0.5d0*x92 + x106 
     /       - x108 - 20.0d0

      e189 = 5.0d0*b39 - 5.0d0*b40 + 0.5d0*x98 + 0.5d0*x100 - x113 
     /       + x115 - 5.0d0 

      e190 = 5.0d0*b39 + 5.0d0*b40 + 0.5d0*x98 + 0.5d0*x100 + x113 
     /      - x115 - 10.0d0

      e191 = -x84 + x107 - x108 

      e192 = -x84 - x107 + x108 

      e193 = -x85 + x114 - x115 

      e194 = -x85 - x114 + x115 

      e195 = -20.0d0*b41 - 20.0d0*b42 + 0.5d0*x91 + 0.5d0*x92 - x107 
     /       + x108     

      e196 = -20.0d0*b41 + 20.0d0*b42 + 0.5d0*x91 + 0.5d0*x92 + x107
     /       - x108 - 20.0d0

      e197 = 5.0d0*b41 - 5.0d0*b42 + 0.5d0*x99 + 0.5d0*x100 - x114 
     /       + x115 - 5.0d0 

      e198 = 5.0d0*b41 + 5.0d0*b42 + 0.5d0*x99 + 0.5d0*x100 + x114 
     /       - x115 - 10.0d0

      e199 = 14.0d0/x86 - x94         

      e200 = 14.0d0/x94 - x86         

      e201 = 10.0d0/x87 - x95         

      e202 = 10.0d0/x95 - x87         

      e203 = 9.0d0/x88 - x96          

      e204 = 9.0d0/x96 - x88          

      e205 = 6.0d0/x89 - x97          

      e206 = 6.0d0/x97 - x89          

      e207 = 10.0d0/x90 - x98         

      e208 = 10.0d0/x98 - x90         

      e209 = 25.0d0/x91 - x99         

      e210 = 25.0d0/x99 - x91         

      e211 = 25.0d0/x92 - x100        

      e212 = 25.0d0/x100 - x92        

      g(1) = -e2
      g(2) = -e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6
      g(6) = -e7
      g(7) = -e8
      g(8) = -e9
      g(9) = -e10
      g(10) = -e11
      g(11) = -e12
      g(12) = -e13
      g(13) = -e14
      g(14) = -e15
      g(15) = -e16
      g(16) = -e17
      g(17) = -e18
      g(18) = -e19
      g(19) = -e20
      g(20) = -e21
      g(21) = -e22
      g(22) = -e23
      g(23) = -e24
      g(24) = -e25
      g(25) = -e26
      g(26) = -e27
      g(27) = -e28
      g(28) = -e29
      g(29) = -e30
      g(30) = -e31
      g(31) = -e32
      g(32) = -e33
      g(33) = -e34
      g(34) = -e35
      g(35) = -e36
      g(36) = -e37
      g(37) = -e38
      g(38) = -e39
      g(39) = -e40
      g(40) = -e41
      g(41) = -e42
      g(42) = -e43
      g(43) = -e44
      g(44) = -e45
      g(45) = -e46
      g(46) = -e47
      g(47) = -e48
      g(48) = -e49
      g(49) = -e50
      g(50) = -e51
      g(51) = -e52
      g(52) = -e53
      g(53) = -e54
      g(54) = -e55
      g(55) = -e56
      g(56) = -e57
      g(57) = -e58
      g(58) = -e59
      g(59) = -e60
      g(60) = -e61
      g(61) = -e62
      g(62) = -e63
      g(63) = -e64
      g(64) = -e65
      g(65) = -e66
      g(66) = -e67
      g(67) = -e68
      g(68) = -e69
      g(69) = -e70
      g(70) = -e71
      g(71) = -e72
      g(72) = -e73
      g(73) = -e74
      g(74) = -e75
      g(75) = -e76
      g(76) = -e77
      g(77) = -e78
      g(78) = -e79
      g(79) = -e80
      g(80) = -e81
      g(81) = -e82
      g(82) = -e83
      g(83) = -e84
      g(84) = -e85
      g(85) = -e86
      g(86) = -e87
      g(87) = -e88
      g(88) = -e89
      g(89) = -e90
      g(90) = -e91
      g(91) = -e92
      g(92) = -e93
      g(93) = -e94
      g(94) = -e95
      g(95) = -e96
      g(96) = -e97
      g(97) = -e98
      g(98) = -e99
      g(99) = -e100
      g(100) = -e101
      g(101) = -e102
      g(102) = -e103
      g(103) = -e104
      g(104) = -e105
      g(105) = -e106
      g(106) = -e107
      g(107) = -e108
      g(108) = -e109
      g(109) = -e110
      g(110) = -e111
      g(111) = -e112
      g(112) = -e113
      g(113) = -e114
      g(114) = -e115
      g(115) = -e116
      g(116) = -e117
      g(117) = -e118
      g(118) = -e119
      g(119) = -e120
      g(120) = -e121
      g(121) = -e122
      g(122) = -e123
      g(123) = -e124
      g(124) = -e125
      g(125) = -e126
      g(126) = -e127
      g(127) = -e128
      g(128) = -e129
      g(129) = -e130
      g(130) = -e131
      g(131) = -e132
      g(132) = -e133
      g(133) = -e134
      g(134) = -e135
      g(135) = -e136
      g(136) = -e137
      g(137) = -e138
      g(138) = -e139
      g(139) = -e140
      g(140) = -e141
      g(141) = -e142
      g(142) = -e143
      g(143) = -e144
      g(144) = -e145
      g(145) = -e146
      g(146) = -e147
      g(147) = -e148
      g(148) = -e149
      g(149) = -e150
      g(150) = -e151
      g(151) = -e152
      g(152) = -e153
      g(153) = -e154
      g(154) = -e155
      g(155) = -e156
      g(156) = -e157
      g(157) = -e158
      g(158) = -e159
      g(159) = -e160
      g(160) = -e161
      g(161) = -e162
      g(162) = -e163
      g(163) = -e164
      g(164) = -e165
      g(165) = -e166
      g(166) = -e167
      g(167) = -e168
      g(168) = -e169
      g(169) = -e170
      g(170) = -e171
      g(171) = -e172
      g(172) = -e173
      g(173) = -e174
      g(174) = -e175
      g(175) = -e176
      g(176) = -e177
      g(177) = -e178
      g(178) = -e179
      g(179) = -e180
      g(180) = -e181
      g(181) = -e182
      g(182) = -e183
      g(183) = -e184
      g(184) = -e185
      g(185) = -e186
      g(186) = -e187
      g(187) = -e188
      g(188) = -e189
      g(189) = -e190
      g(190) = -e191
      g(191) = -e192
      g(192) = -e193
      g(193) = -e194
      g(194) = -e195
      g(195) = -e196
      g(196) = -e197
      g(197) = -e198
      g(198) = -e199
      g(199) = -e200
      g(200) = -e201
      g(201) = -e202
      g(202) = -e203
      g(203) = -e204
      g(204) = -e205
      g(205) = -e206
      g(206) = -e207
      g(207) = -e208
      g(208) = -e209
      g(209) = -e210
      g(210) = -e211
      g(211) = -e212

  999 continue
      return
      end
 

      subroutine meanvarx( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:38:57
*  
*  Equation counts
*     Total       E       G       L       N       X
*        45       9      14      22       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        36      22      14       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       111     104       7       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x2, x3, x4, x5, x6, x7, x8, 
     /        x9, x10, x11, x12, x13, x14, x15, x16, x17, x18, x19, 
     /        x20, x21, x22, b23, b24, b25, b26, b27, b28, b29,
     /        b30, b31, b32, b33, b34, b35, b36
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MEANVARX'
         pref  = '\cite{MINLPLib}'
c         fex   = 14.36923d0    
         fex   = 14.1897318d0
         ncont = 21
         nint  = 0
         nbin  = 14
         n     = ncont + nbin + nint
         m     = 44
         me    = 8
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif     

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo
      
      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      x6 = x(5)
      x7 = x(6)
      x8 = x(7)
      x9 = x(8)
      x10 = x(9)
      x11 = x(10)
      x12 = x(11)
      x13 = x(12)
      x14 = x(13)
      x15 = x(14)
      x16 = x(15)
      x17 = x(16)
      x18 = x(17)
      x19 = x(18)
      x20 = x(19)
      x21 = x(20)
      x22 = x(21)   
      b23 = y(1)
      b24 = y(2)
      b25 = y(3)
      b26 = y(4)
      b27 = y(5)
      b28 = y(6)
      b29 = y(7)
      b30 = y(8)
      b31 = y(9)
      b32 = y(10)
      b33 = y(11)
      b34 = y(12)
      b35 = y(13)
      b36 = y(14)

      f = 42.18d0*x2*x2 + 40.36d0*x2*x3 + 21.76d0*x2*x4 
     /    + 10.60d0*x2*x5 + 24.64d0*x2*x6 + 47.68d0*x2*x7 
     /    + 34.82d0*x2*x8 + 70.89d0*x3*x3 + 43.16d0*x3*x4 
     /    + 30.82d0*x3*x5 + 46.48d0*x3*x6 + 47.60d0*x3*x7 
     /    + 25.24d0*x3*x8 + 25.51d0*x4*x4 + 19.20d0*x4*x5 
     /    + 45.26d0*x4*x6 + 26.44d0*x4*x7 +  9.40d0*x4*x8 
     /    + 22.33d0*x5*x5 + 20.64d0*x5*x6 + 20.92d0*x5*x7 
     /    +  2.00d0*x5*x8 + 30.01d0*x6*x6 + 32.72d0*x6*x7 
     /    + 14.40d0*x6*x8 + 42.23d0*x7*x7 + 19.80d0*x7*x8 
     /    + 16.42d0*x8*x8 - 0.06435d0*x2 - 0.0548d0*x3 
     /    - 0.02505d0*x4 - 0.0762d0*x5 - 0.03815d0*x6 
     /    - 0.0927d0*x7 - 0.031d0*x8
     
      g(1) = x2 + x3 + x4 + x5 + x6 + x7 + x8 - 1.0d0

      g(2) = x2 - x9 + x16 - 0.2d0

      g(3) = x3 - x10 + x17 - 0.2d0

      g(4) = x4 - x11 + x18 

      g(5) = x5 - x12 + x19 

      g(6) = x6 - x13 + x20 - 0.2d0

      g(7) = x7 - x14 + x21 - 0.2d0

      g(8) = x8 - x15 + x22 - 0.2d0

      g(9) = x9 + x10 + x11 + x12 + x13 + x14 + x15 - 0.3d0

      g(10) = -(x9 - 0.11d0*b23)

      g(11) = -(x10 - 0.1d0*b24)

      g(12) = -(x11 - 0.07d0*b25)

      g(13) = -(x12 - 0.11d0*b26)

      g(14) = -(x13 - 0.2d0*b27)

      g(15) = -(x14 - 0.1d0*b28)

      g(16) = -(x15 - 0.1d0*b29)

      g(17) = x9 - 0.03d0*b23

      g(18) = x10 - 0.04d0*b24

      g(19) = x11 - 0.04d0*b25 

      g(20) = x12 - 0.03d0*b26

      g(21) = x13 - 0.03d0*b27 

      g(22) = x14 - 0.03d0*b28

      g(23) = x15 - 0.03d0*b29

      g(24) = -(x16 - 0.2d0*b30)

      g(25) = -(x17 - 0.15d0*b31)

      g(26) = -x18

      g(27) = -x19

      g(28) = -(x20 - 0.1d0*b34)

      g(29) = -(x21 - 0.15d0*b35)

      g(30) = -(x22 - 0.2d0*b36)

      g(31) = x16 - 0.02d0*b30

      g(32) = x17 - 0.02d0*b31

      g(33) = x18 - 0.04d0*b32

      g(34) = x19 - 0.04d0*b33

      g(35) = x20 - 0.04d0*b34

      g(36) = x21 - 0.04d0*b35

      g(37) = x22 - 0.04d0*b36

      g(38) = -(b23 + b30) + 1.0d0

      g(39) = -(b24 + b31) + 1.0d0

      g(40) = -(b25 + b32) + 1.0d0

      g(41) = -(b26 + b33) + 1.0d0

      g(42) = -(b27 + b34) + 1.0d0

      g(43) = -(b28 + b35) + 1.0d0

      g(44) = -(b29 + b36) + 1.0d0         

  999 continue
      return
      end

      subroutine mgrid_cycles1( mode,     m,     me,  mmax, ncont,  
     /                          nbin,  nint,   nmax,     x,    xl,
     /                            xu,     f,      g,  pnam,  pref,
     /                           fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MGRID_CYCLES1'
         pref  = '\cite{TGKRO9}'
         fex   = 8.0d0
         ncont = 0
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 0
         do i = 1,nint
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         enddo 
         goto 999       
      endif     

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 2.0d0*y(1)+4.0d0*y(2)+8.0d0*y(3)+16.0d0*y(4)+32.0d0*y(5)
     
      g(1) = 9.0d0 - 16.0d0*0.2d0**(y(5) + y(4) + y(3) + y(2) + y(1))
     /       -8.0d0*0.2d0**(y(5) + y(4) + y(3) + y(2)) 
     /       - 4.0d0*0.2d0**(y(5) + y(4) + y(3))
     /       -2.0d0*0.2d0**(y(5) + y(4))
     /       -1.0d0*0.2d0**y(5)
     
  999 continue
      return
      end

      subroutine mgrid_cycles2( mode,     m,     me,  mmax, ncont,  
     /                          nbin,  nint,   nmax,     x,    xl,
     /                            xu,     f,      g,  pnam,  pref,
     /                           fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MGRID_CYCLES2'
         pref  = '\cite{TGKRO9}'
         fex   = 300.0d0
         ncont = 0
         nint  = 10
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 0
         do i = 1,nint
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 10.0d0
         enddo 
         goto 999       
      endif     

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 2.0d0*y(1) + 4.0d0*y(2) + 8.0d0*y(3) + 16.0d0*y(4) 
     /    + 32.0d0*y(5) + 64.0d0*y(6) + 128.0d0*y(7) + 256.0d0*y(8)
     /    + 512.0d0*y(9) + 1024.0d0*y(10)
     
      g(1) = 9.0d0 
     /       - 512.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6) + y(5) 
     /          + y(4) + y(3) + y(2) + y(1))     
     /       - 256.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6) + y(5)
     /           + y(4) + y(3) + y(2))     
     /       - 128.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6) + y(5)
     /          + y(4) + y(3))
     /       - 64.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6) + y(5) 
     /          + y(4))     
     /       - 32.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6) + y(5)) 
     /       - 16.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7) + y(6))
     /       - 8.0d0*0.2d0**(y(10) + y(9) + y(8) + y(7))
     /       - 4.0d0*0.2d0**(y(10) + y(9) + y(8))
     /       - 2.0d0*0.2d0**(y(10) + y(9))
     /       - 1.0d0*0.2d0**y(10)
     
  999 continue
      return
      end
 
      subroutine minlphix(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 05/01/01 11:21:59
*  
*  Equation counts
*     Total       E       G       L       N       X
*        93      31       0      62       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        85      65      20       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       317     277      40       0
*
*  Solve m using MINLP minimizing objvar;

      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), xdiv,
     /               x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /         x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /         x61, x62, x63, x64, x65, b66, b67, b68, b69, b70,
     /         b71, b72, b73, b74, b75, b76, b77, b78, b79, b80,
     /         b81, b82, b83, b84, b85
      double precision
     /               e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /         e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /         e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /         e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /         e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /         e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /         e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /         e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /         e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /         e91, e92, e93
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MINLPHIX'
         pref  = '\cite{MINLPLib}'
         fex   = 316.6927d0
         ncont = 64
         nint  = 0
         nbin  = 20
         n     = ncont + nbin + nint
         m     = 92
         me    = 30
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d3
         enddo
         xl(29) = 326.0d0
         x(29)  = 326.0d0
         xu(30) = 304.0d0 
         xl(31) = 326.0d0 
         x(31)  = 326.0d0 
         x(32)  = 300.0d0 
         xu(32) = 304.0d0 
         x(33)  = 500.0d0 
         xu(33) = 1000.0d0
         x(34)  = 500.0d0 
         xu(34) = 1000.0d0
         x(35)  = 500.0d0 
         xu(35) = 1000.0d0
         x(36)  = 500.0d0 
         xu(36) = 1000.0d0         
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.5d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      x6 = x(5)
      x7 = x(6)
      x8 = x(7)
      x9 = x(8)
      x10 = x(9)
      x11 = x(10)
      x12 = x(11)
      x13 = x(12)
      x14 = x(13)
      x15 = x(14)
      x16 = x(15)
      x17 = x(16)
      x18 = x(17)
      x19 = x(18)
      x20 = x(19)
      x21 = x(20)
      x22 = x(21)
      x23 = x(22)
      x24 = x(23)
      x25 = x(24)
      x26 = x(25)
      x27 = x(26)
      x28 = x(27)
      x29 = x(28)
      x30 = x(29)
      x31 = x(30)
      x32 = x(31)
      x33 = x(32)
      x34 = x(33)
      x35 = x(34)
      x36 = x(35)
      x37 = x(36)
      x38 = x(37)
      x39 = x(38)
      x40 = x(39)
      x41 = x(40)
      x42 = x(41)
      x43 = x(42)
      x44 = x(43)
      x45 = x(44)
      x46 = x(45)
      x47 = x(46)
      x48 = x(47)
      x49 = x(48)
      x50 = x(49)
      x51 = x(50)
      x52 = x(51)
      x53 = x(52)
      x54 = x(53)
      x55 = x(54)
      x56 = x(55)
      x57 = x(56)
      x58 = x(57)
      x59 = x(58)
      x60 = x(59)
      x61 = x(60)
      x62 = x(61)
      x63 = x(62)
      x64 = x(63)
      x65 = x(64)
      b66 = y(1)
      b67 = y(2)
      b68 = y(3)
      b69 = y(4)
      b70 = y(5)
      b71 = y(6)
      b72 = y(7)
      b73 = y(8)
      b74 = y(9)
      b75 = y(10)
      b76 = y(11)
      b77 = y(12)
      b78 = y(13)
      b79 = y(14)
      b80 = y(15)
      b81 = y(16)
      b82 = y(17)
      b83 = y(18)
      b84 = y(19)
      b85 = y(20)

      f = 0.4d0*((0.003375d0*x30 - 1.15398d0)*x2 + (0.000893d0*x31 
     /    - 0.30630793d0)*x3 + (0.004458d0*x32 - 1.57608132d0)*x4 
     /    + (0.003176d0*x33 - 1.08593792d0)*x5 
     /    + 31.8928571428571d0*x14/xdiv(1.0d0 + x30 - x36 - b82)
     /    + 31.8928571428571d0*x15/xdiv(1.0d0 + x31 - x37 - b83) 
     /    + 31.8928571428571d0*x16/xdiv(1.0d0 + x32 - x34 - b84)
     /    + 31.8928571428571d0*x17/xdiv(1.0d0 + x33 - x35 - b85)
     /    + 151.125d0*b82 + 180.003d0*b83 + 4.2286d0*b84 + 213.42d0*b85
     /    + 31.8928571428571d0*x26/xdiv(1.0d0+x38-b82)
     /    + 31.8928571428571d0*x27/xdiv(1.0d0 + x39 - b83) 
     /    + 31.8928571428571d0*x28/xdiv(1.0d0 + x40 - b84) 
     /    + 31.8928571428571d0*x29/xdiv(1.0d0 + x41 - b85) 
     /    + 31.8928571428571d0*x18/xdiv(421.0d0 - x34) 
     /    + 31.8928571428571d0*x19/xdiv(421.0d0 - x35) 
     /    + 31.8928571428571d0*x20/xdiv(421.0d0 - x36) 
     /    + 31.8928571428571d0*x21/xdiv(421.0d0 - x37)
     /    + 31.8928571428571d0*x22/xdiv(373.0d0 - x34) 
     /    + 31.8928571428571d0*x23/xdiv(373.0d0 - x35) 
     /    + 31.8928571428571d0*x24/xdiv(373.0d0 - x36) 
     /    + 31.8928571428571d0*x25/xdiv(373.0d0 - x37))
      f = f + 12.95216d0*x18 + 12.95216d0*x19 + 12.95216d0*x20 
     /    + 12.95216d0*x21 + 4.75228d0*x22 + 4.75228d0*x23 
     /    + 4.75228d0*x24 + 4.75228d0*x25 + 2.418d0*x26 + 2.418d0*x27 
     /    + 2.418d0*x28 + 2.418d0*x29  + 1.3568d0*b66 + 1.3568d0*b67 
     /    + 1.3568d0*b68 + 1.3568d0*b69 + 1.3568d0*b70 + 1.3568d0*b71
     /    + 1.3568d0*b72 + 1.3568d0*b73 + 1.3568d0*b74 + 1.3568d0*b75
     /    + 1.3568d0*b76 + 1.3568d0*b77 + 1.3568d0*b78 + 1.3568d0*b79 
     /    + 1.3568d0*b80 + 1.3568d0*b81 
                             
      e2 = -(0.666666666666667d0*sqrt((x30 - 305.0d0)*(x30 - 325.0d0))
     /      + 0.333333333333333d0*x30) + x38 - x42 + x46 + 105.0d0  
     
      e3 = -(0.666666666666667d0*sqrt((x31 - 305.0d0)*(x31 - 325.0d0)) 
     /      + 0.333333333333333d0*x31) + x39 - x43 + x47 + 105.0d0    

      e4 = -(0.666666666666667d0*sqrt((x32 - 305.0d0)*(x32 - 325.0d0))
     /      + 0.333333333333333d0*x32) + x40 - x44 + x48 + 105.0d0  

      e5 = -(0.666666666666667d0*sqrt((x33 - 305.0d0)*(x33 - 325.0d0))
     /      + 0.333333333333333d0*x33) + x41 - x45 + x49 + 105.0d0  

      e6 = x30 + x34 + x38 - 1500.0d0*b82                   

      e7 = x31 + x35 + x39 - 1500.0d0*b83                   

      e8 = x32 + x36 + x40 - 1500.0d0*b84                   

      e9 = x33 + x37 + x41 - 1500.0d0*b85                   

      e10 = x42 + x50 + x54 + 1500.0d0*b82 - 1500.0d0         

      e11 = x43 + x51 + x55 + 1500.0d0*b83 - 1500.0d0         

      e12 = x44 + x52 + x56 + 1500.0d0*b84 - 1500.0d0         

      e13 = x45 + x53 + x57 + 1500.0d0*b85 - 1500.0d0         

      e14 = x46 + x58 + x62 + 1500.0d0*b82 - 1500.0d0         

      e15 = x47 + x59 + x63 + 1500.0d0*b83 - 1500.0d0         

      e16 = x48 + x60 + x64 + 1500.0d0*b84 - 1500.0d0         

      e17 = x49 + x61 + x65 + 1500.0d0*b85 - 1500.0d0         

      e18 = 0.9d0*x3 - x5   

      e19 = 0.2d0*x2 - x4   

      e20 = x2 + x3 - 396.0d0

      e21 = x2 - 1500.0d0*b82 

      e22 = x3 - 1500.0d0*b83 

      e23 = x4 - 1500.0d0*b84 

      e24 = x5 - 1500.0d0*b85 

      e25 = x10 - 0.0225d0*x30 - x58 + x62 - 24.7068d0    

      e26 = x11 - 0.013d0*x31 - x59 + x63 - 20.54087d0    

      e27 = x12 - 0.0043d0*x32 - x60 + x64 - 2.239778d0   

      e28 = x13 - 0.0156d0*x33 - x61 + x65 - 29.766048d0  

      e29 = x6 - x10      

      e30 = x7 - x11      

      e31 = x8 - x12      

      e32 = x9 - x13      

      e33 = x10 - x14 - x26                             

      e34 = x11 - x15 - x27                             

      e35 = x12 - x16 - x28                             

      e36 = x13 - x17 - x29                             

      e37 = x6 - x16 - x18 - x22                        

      e38 = x7 - x17 - x19 - x23                        

      e39 = x8 - x14 - x20 - x24                        

      e40 = x9 - x15 - x21 - x25                        

      e41 = x34 - 411.0d0   

      e42 = x35 - 411.0d0   

      e43 = x36 - 411.0d0   

      e44 = x37 - 411.0d0   

      e45 = -x30 + 1500.0d0*b82 - 1158.08d0                  

      e46 = -x31 + 1500.0d0*b83 - 1156.99d0                  

      e47 = -x32 + 1500.0d0*b84 - 1146.46d0                  

      e48 = -x33 + 1500.0d0*b85 - 1158.08d0                  

      e49 = -1.028d0*x30 + x34 - x50 + x54 + 341.95276d0

      e50 = -1.05d0*x31 + x35 - x51 + x55 + 347.9205d0    

      e51 = -1.029d0*x32 + x36 - x52 + x56 + 355.03666d0  

      e52 = -1.005d0*x33 + x37 - x53 + x57 + 334.4486d0

      e53 = -x30 + x36 + 1500.0d0*b66 - 1490.0d0               

      e54 = -x31 + x37 + 1500.0d0*b67 - 1490.0d0               

      e55 = -x32 + x34 + 1500.0d0*b68 - 1490.0d0               

      e56 = -x33 + x35 + 1500.0d0*b69 - 1490.0d0               

      e57 = x34 + 1500.0d0*b74 - 1863.0d0                     

      e58 = x35 + 1500.0d0*b75 - 1863.0d0                     

      e59 = x36 + 1500.0d0*b76 - 1863.0d0                     

      e60 = x37 + 1500.0d0*b77 - 1863.0d0                     

      e61 = x14 - 1500.0d0*b66

      e62 = x15 - 1500.0d0*b67

      e63 = x16 - 1500.0d0*b68

      e64 = x17 - 1500.0d0*b69

      e65 = x18 - 1500.0d0*b70

      e66 = x19 - 1500.0d0*b71

      e67 = x20 - 1500.0d0*b72

      e68 = x21 - 1500.0d0*b73

      e69 = x22 - 1500.0d0*b74

      e70 = x23 - 1500.0d0*b75

      e71 = x24 - 1500.0d0*b76

      e72 = x25 - 1500.0d0*b77

      e73 = x26 - 1500.0d0*b78

      e74 = x27 - 1500.0d0*b79

      e75 = x28 - 1500.0d0*b80

      e76 = x29 - 1500.0d0*b81

      e77 = x6 + x10 - 1500.0d0*b82                         

      e78 = x7 + x11 - 1500.0d0*b83                         

      e79 = x8 + x12 - 1500.0d0*b84                         

      e80 = x9 + x13 - 1500.0d0*b85                         

      e81 = b83 - b85     

      e82 = b82 - b84     

      e83 = b82 + b83 - 1.0d0                             

      e84 = b70 + b74 - 1.0d0                             

      e85 = b71 + b75 - 1.0d0                             

      e86 = b72 + b76 - 1.0d0                             

      e87 = b73 + b77 - 1.0d0                             

      e88 = b66 + b68 - 1.0d0                             

      e89 = b67 + b69 - 1.0d0                             

      e90 = b66 + b68 + b70 + b74 + b78 - 20.0d0*b82        

      e91 = b67 + b69 + b71 + b75 + b79 - 20.0d0*b83        

      e92 = b66 + b68 + b72 + b76 + b80 - 20.0d0*b84        

      e93 = b67 + b69 + b73 + b77 + b81 - 20.0d0*b85

      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e18
      g(6) = e19
      g(7) = e20
      g(8) = e25
      g(9) = e26
      g(10) = e27
      g(11) = e28
      g(12) = e29
      g(13) = e30
      g(14) = e31
      g(15) = e32
      g(16) = e33
      g(17) = e34
      g(18) = e35
      g(19) = e36
      g(20) = e37
      g(21) = e38
      g(22) = e39
      g(23) = e40
      g(24) = e49
      g(25) = e50
      g(26) = e51
      g(27) = e52
      g(28) = e81
      g(29) = e82
      g(30) = e83
      g(31) = -e6
      g(32) = -e7
      g(33) = -e8
      g(34) = -e9
      g(35) = -e10
      g(36) = -e11
      g(37) = -e12
      g(38) = -e13
      g(39) = -e14
      g(40) = -e15
      g(41) = -e16
      g(42) = -e17
      g(43) = -e21
      g(44) = -e22
      g(45) = -e23
      g(46) = -e24
      g(47) = -e41
      g(48) = -e42
      g(49) = -e43
      g(50) = -e44
      g(51) = -e45
      g(52) = -e46
      g(53) = -e47
      g(54) = -e48
      g(55) = -e53
      g(56) = -e54
      g(57) = -e55
      g(58) = -e56
      g(59) = -e57
      g(60) = -e58
      g(61) = -e59
      g(62) = -e60
      g(63) = -e61
      g(64) = -e62
      g(65) = -e63
      g(66) = -e64
      g(67) = -e65
      g(68) = -e66
      g(69) = -e67
      g(70) = -e68
      g(71) = -e69
      g(72) = -e70
      g(73) = -e71
      g(74) = -e72
      g(75) = -e73
      g(76) = -e74
      g(77) = -e75
      g(78) = -e76
      g(79) = -e77
      g(80) = -e78      
      g(81) = -e79
      g(82) = -e80
      g(83) = -e84
      g(84) = -e85
      g(85) = -e86
      g(86) = -e87
      g(87) = -e88
      g(88) = -e89
      g(89) = -e90
      g(90) = -e91
      g(91) = -e92
      g(92) = -e93
 
  999 continue
      return
      end
 
      subroutine mip_ex( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), b1, b2, b3, x1, x2
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MIP_EX'
         pref  = '\cite{GK97}'
         fex   = 3.5d0
         ncont = 2
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 7
         me    = 0
         do i=1,ncont
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 4.0d0
         enddo   
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif     
      
      b1 = x(3)
      b2 = x(4)
      b3 = x(5)
      x1 = x(1)
      x2 = x(2)
      
      f = b1 + 1.5d0*b2 + 0.5d0*b3 + x1**2 + x2**2 
     
      g(1) = -(x1 - 2.0d0)**2 + x2
  
      g(2) = x1 - 2.0d0*b1
  
      g(3) = -x1 + x2 + 4.0d0*(1.0d0 - b2)
  
      g(4) = x1 - 1.0d0 + b1
  
      g(5) = x2 - b2
  
      g(6) = x1 + X2 - 3.0d0*b3
  
      g(7) = b1 + b2 + b3 - 1.0d0
     
  999 continue
      return
      end

      subroutine mitp1( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me, ncont, nint, nbin, n, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MITP1'
         pref  = ''
         fex   = -0.10009690d+5
         ncont = 2
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 0
         do i = 1,n
            xl(i) = -100.0d0
            xu(i) = 100.0d0
         enddo
         xu(1) = 6.0d0
         xu(2) = 10.0d0
         x(1) = -5.0d0
         x(2) = 3.0d0
         x(3) = 5.0d0
         x(4) = -10.0d0
         x(5) = 50.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = 5.0d0*(y(1) - 1)**2 + 0.01d0*y(2)**3 + (y(3) + 0.7d0)**2
     /                + (x(1) - y(1) - 0.33d0)**2 - x(2) + 0.22d0
      
      g(1) = (x(1) + 1.25d0)**2 + 0.5d0*y(3)

  999 continue
      return
      end

      subroutine mitp2( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

      implicit none
      integer m, me, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'MITP2'
         pref  = ''
         fex   = 3.5d0
         ncont = 2
         nint  = 0
         nbin  = 3
         m     = 7
         me    = 0
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 2.0d0
            xu(i) = 4.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      f = y(1) + 1.5d0*y(2) + 0.5d0*y(3) + x(1)**2 + x(2)**2

      g(1) = x(2) - (x(1) - 2.0d0)**2
   
      g(2) = x(1) - 2*y(1)
   
      g(3) = -x(1) + x(2) + 4.0d0*(1.0d0 - y(2))
   
      g(4) = x(1) - (1.0d0 - y(1))
   
      g(5) = x(2) - y(2)
   
      g(6) = x(1) + x(2) - 3.0d0*y(3)
   
      g(7) = y(1) + y(2) + y(3) - 1.0d0

  999 continue
      return
      end

      subroutine NEJI( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /                 g(mmax)
      double precision PI, MUs, MUw, MUcs, Eb, Ec, Sigy, Sigb, Taub,
     /                 Wns, Wew, H, P, d0, dh, d2, d3, ds, As, dw, 
     /                 Kb, Kc, phi, alp, qH, qP, qd0, qdh, qd2, qd3, 
     /                 qds, qAs, qdw, qKb, qKc, qphi,qalp, iht, axis,
     /                 Fy, Wsep, Siga, Ftau, Fsig, rD, mD, Delta
     
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NEJI'
         pref  = ''
         fex   = -0.11111111D+02
         ncont = 2
         nint  = 1
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 6
         me    = 0
         xl(1) = 500.0D0
         x(1)  = 20000.0D0
         xu(1) = 20000.0D0   
         xl(2) = 20.0D0
         x(2)  = 50.0D0
         xu(2) = 100.0D0
         xl(3) = 2.0D0
         x(3)  = 14.0D0
         xu(3) = 14.0D0
         goto 999
      end if

      PI   = 4.0d0*datan(1.0D0)
      MUs  = 0.2d0
      MUw  = 0.2d0
      MUcs = 0.2d0
      Eb   = 21000.0d0
      Ec   = 21000.0d0
      Sigy = 50.0d0
      Sigb = 80.0d0
      Taub = 80.0D0/3.0D0
      Wns  = 1000.0d0
      Wew  = 1732.0d0
      call calc(PI, MUs, MUw, MUcs, Eb, Ec, Sigy, Sigb, Taub, 
     /          Wns, Wew, x(1), x(2), x(3), H, P, d0, dh, d2, 
     /          d3, ds, As, dw, Kb, Kc, phi, alp)
      F    = -iht( X(2), X(3))
      G(1) = 4000.0d0 - axis(PI, MUs, MUw, X(1), alp, d2, P, dw)
      G(2) = Fy(PI, MUs, MUw, Sigy, X(1), alp, d2, P, dw, ds)
      G(3) = Wsep(PI, MUs, MUw, Wns,  X(1), alp, d2, P, dw, phi)
      G(4) = Siga(Wns, X(3), phi, As)
      G(5) = Ftau(PI, MUs, MUw, MUcs, Taub, Wew, X(1), alp, d2, 
     /            P, dw, ds)
      G(6) = Fsig(PI, MUs, MUw, Sigb, Wns, X(1), alp, d2, P, dw,
     /            ds, phi)
  999 continue
      return
      end
      SUBROUTINE calc(PI, MUs, MUw, MUcs, Eb, Ec, Sigy, Sigb, 
     /                Taub, Wns, Wew, X1, X2, X3, H, P, d0, dh,
     /                d2, d3, ds, As, dw, Kb, Kc, phi, alp)
      DOUBLE PRECISION  PI, MUs, MUw, MUcs, Eb, Ec, Sigy, Sigb, Taub, 
     /                  Wns, Wew
      DOUBLE PRECISION  X1, X2, X3, H, P, d0, dh, d2, d3, ds, As, dw,
     /                  Kb, Kc, phi, alp
C
      IF (X3.EQ.2.0d0) THEN
         P  = 0.4d0
         d0 = 4.32d0
         dh = 2.4d0
      ELSE IF (X3.EQ.3.0d0) THEN
         P  = 0.5d0
         d0 = 6.01d0
         dh = 3.4d0
      ELSE IF (X3.EQ.4.0d0) THEN
         P  = 0.7d0
         d0 = 7.66d0
         dh = 4.5d0
      ELSE IF (X3.EQ.5.0d0) THEN
         P  = 0.8d0
         d0 = 8.79d0
         dh = 5.5d0
      ELSE IF (X3.EQ.6.0d0) THEN
         P  = 1.0d0
         d0 = 11.05d0
         dh = 6.6d0
      ELSE IF (X3.EQ.7.0d0) THEN
         P  = (1.0d0 + 1.25d0)/2.0d0
         d0 = (11.05d0 + 14.38d0)/2.0d0
         dh = (6.6d0 + 9.0d0)/2.0d0
      ELSE IF (X3.EQ.8.0d0) THEN
          P = 1.25d0
         d0 = 14.38d0
         dh = 9.0d0
      ELSE IF (X3.EQ.9.0d0) THEN
          P = (1.25d0 +  1.5d0)/2.0d0
         d0 = (14.38d0 + 17.77d0)/2.0d0
         dh = ( 9.0d0 + 11.0d0)/2.0d0
      ELSE IF (X3.EQ.10.0d0) THEN
         P = 1.5d0
         d0 = 17.77d0
         dh = 11.0d0
      ELSE IF (X3.EQ.11.0d0) THEN
          P = (1.5d0 + 1.75)/2.0d0
         d0 = (17.77d0 + 20.03d0)/2.0d0
         dh = (11.0d0 + 13.5d0)/2.0d0
      ELSE IF (X3.EQ.12.0d0) THEN
         P  = 1.75d0
         d0 = 20.03d0
         dh = 13.5d0
      ELSE IF (X3.EQ.13.0d0) THEN
         P  = (1.75d0 + 2.0d0)/2.0d0
         d0 = (20.03d0 + 23.36d0)/2.0d0
         dh = (13.5d0 + 15.5d0)/2.0d0
      ELSE IF (X3.EQ. 14.0d0) THEN
         P  = 2.0d0
         d0 = 23.36d0
         dh = 15.5d0
      END IF
      H   = SQRT(3.0d0)/2.0d0*P
      d2  = X3 - (3.0d0/8.0d0)*H
      d3  = X3 - (17.0d0/24.0d0)*H
      ds  = (d2 + d3)/2.0d0
      As  = (PI/16.0d0)*(d2 + d3)**2
      dw  = (2.0d0*(d0**3 - dh**3))/(3.0d0*(d0**2 - dh**2))
      Kb  = (Eb*As)/(X2 + 1.3d0*X3)
      Kc  = (Ec/X2)*(PI/4d0)*((d0 + 0.1d0*X2)**2 - dh**2)
      phi = Kb/(Kb + Kc)
      alp = PI/180.0d0*30.0d0
      RETURN
      END
      DOUBLE PRECISION FUNCTION Delta( X, rDelta, mDelta )
      DOUBLE PRECISION   X, rDelta, mDelta, Y     
      Y = X*(1.0d0 + rDelta)
      IF (Y.LT.mDelta) THEN
         Delta = mDelta
      ELSE
         Delta = Y
      END IF
      RETURN
      END
      DOUBLE PRECISION FUNCTION iht(X2, X3 )
          DOUBLE PRECISION   X2, X3
          iht = X2/X3
      RETURN
      END         
      DOUBLE PRECISION FUNCTION axis(PI, MUs, MUw, X1, alp, d2, P, dw)
      DOUBLE PRECISION  PI, MUs, MUw, X1, alp, d2, P, dw     
      axis = (2.0d0*X1)/((MUs/dcos(alp))*d2 + P/PI + dw*MUw) 
      RETURN
      END
      DOUBLE PRECISION FUNCTION Fy(PI, MUs, MUw, Sigy, X1, alp, d2, P, 
     /                             dw, ds)
      DOUBLE PRECISION  PI, MUs, MUw, Sigy, X1, alp, d2, P, dw, ds
      Fy = (PI*ds**2*Sigy)/(4.0d0*dsqrt(1.0d0+12.0d0*(1.0d0/ds
     /                      *((d2/dcos(alp))*MUs + P/PI))**2))
     /     - (2.0d0*X1)/((MUs/dcos(alp))*d2 + P/PI + dw*MUw)
      RETURN
      END
      DOUBLE PRECISION FUNCTION Wsep(PI, MUs, MUw, Wns, X1, alp, d2, P, 
     /                               dw, phi)
      DOUBLE PRECISION PI, MUs, MUw, Wns, X1, alp, d2, P, dw, phi
      Wsep = (2.0d0*X1)/((MUs/dcos(alp))*d2 + P/PI 
     /       + dw*MUw)/(1.0d0 - phi) - Wns
      RETURN
      END
      DOUBLE PRECISION FUNCTION Siga(Wns, X3, phi, As)
      DOUBLE PRECISION   Wns, X3, phi, As
      Siga = (0.75d0/9.8d0)*(180.0d0/X3 + 52.0d0) 
     /       - (phi*Wns)/(2.0D0*As)
      RETURN
      END
      DOUBLE PRECISION FUNCTION Ftau(PI, MUs, MUw, MUcs, Taub, Wew, X1,
     /                               alp, d2, P, dw, ds )
      DOUBLE PRECISION PI, MUs, MUw, MUcs, Taub, Wew, X1, 
     /                 alp, d2, P, dw, ds  
      Ftau = PI*ds**2*Taub/4.0d0 - Wew  
     /       + MUcs*(2.0d0*X1)/((MUs/dcos(alp))*d2 + P/PI + dw*MUw)
      RETURN
      END
      DOUBLE PRECISION FUNCTION Fsig(PI, MUs, MUw, Sigb, Wns, X1, alp, 
     /                               d2, P, dw, ds, phi )
      DOUBLE PRECISION PI, MUs, MUw, Sigb, Wns, X1, alp, 
     /                 d2, P, dw, ds, phi
      Fsig = PI*ds**2*Sigb/4.0d0 - (2.0d0*X1)/((MUs/dcos(alp))*d2 
     /       + P/PI + dw*MUw) + phi*Wns
      RETURN
      END

      subroutine nous1(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 06/28/01 19:13:46
*  
*  Equation counts
*     Total       E       G       L       N       X
*        44      42       0       2       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        51      49       2       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       197      75     122       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /              x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, 
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, b50,
     /        b51,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NOUS1'
         pref  = '\cite{MINLPLib}'
         fex   = 1.567072d0  
         ncont = 48
         nint  = 0
         nbin  = 2
         n     = ncont + nbin + nint
         m     = 43
         me    = 41
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d1
            xu(i) = 3.0d2
         end do
         do i=21,26
            xl(i) = 1.0d1
            x(i)  = 5.0d1
            xu(i) = 100.0d0
         end do  
         do i=27,44
            x(i)  = 0.0d0
            xu(i) =  1.0d0
         end do  
         do i=45,48
            xl(i) = 0.85d0
            x(i)  = 0.9d0
            xu(i) = 1.0d0
         end do  
         x(2) = 85.7142857142855 
         x(3) = 57.1428571428572 
         x(4) = 85.7142857142855 
         x(5) = 24.2857142857143 
         x(6) = 32.8571428571428 
         x(7) = 57.142857142857 
         x(8) = 28.5714285714285 
         x(9) = 57.1428571428572 
         x(12) = 24.2857142857143 
         x(13) = 32.8571428571428 
         x(18) = 28.5714285714285 
         x(19) = 77.1428571428574 
         x(20) = 137.142857142857 
         x(21) = 28.5714285714286 
         x(22) = 24.2857142857143 
         x(23) = 24.2857142857143 
         x(24) = 28.5714285714285 
         x(25) = 28.5714285714285 
         x(26) = 28.5714285714285 
         x(27) = 0.5d0 
         x(28) = 0.425d0 
         x(29) = 0.075d0 
         x(30) = 0.333333333333333 
         x(31) = 0.333333333333333 
         x(32) = 0.333333333333333 
         x(33) = 1.0d0 
         x(36) = 0.130434782608696 
         x(37) = 0.739130434782609 
         x(38) = 0.130434782608694 
         x(39) = 0.5d0 
         x(40) = 0.425d0 
         x(41) = 0.075d0 
         x(43) = 0.15d0 
         x(44) = 0.85d0 
         x(46) = 1.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      x6 = x(5)
      x7 = x(6)
      x8 = x(7)
      x9 = x(8)
      x10 = x(9)
      x11 = x(10)
      x12 = x(11)
      x13 = x(12)
      x14 = x(13)
      x15 = x(14)
      x16 = x(15)
      x17 = x(16)
      x18 = x(17)
      x19 = x(18)
      x20 = x(19)
      x21 = x(20)
      x22 = x(21)
      x23 = x(22)
      x24 = x(23)
      x25 = x(24)
      x26 = x(25)
      x27 = x(26)
      x28 = x(27)
      x29 = x(28)
      x30 = x(29)
      x31 = x(30)
      x32 = x(31)
      x33 = x(32)
      x34 = x(33)
      x35 = x(34)
      x36 = x(35)
      x37 = x(36)
      x38 = x(37)
      x39 = x(38)
      x40 = x(39)
      x41 = x(40)
      x42 = x(41)
      x43 = x(42)
      x44 = x(43)
      x45 = x(44)
      x46 = x(45)
      x47 = x(46)
      x48 = x(47)
      x49 = x(48)
      b50 = y(1)
      b51 = y(2)

      f  = (0.0042656d0*x29 - 0.0005719d0*x28 + 0.0093514d0*x46 
     /     + 0.0077308d0*x47 - 0.0139904d0)*x4 + (0.0016371d0*x31 
     /     + 0.0288996d0*x32 + 0.0338147d0*x48 + 0.0373349d0*x49 
     /     - 0.0661588d0)*x5 + 0.23947d0*b50 + 0.75835d0*b51 

      e2 = x2 + x3 + x20 + x21 - 300.0d0                             

      e3 = x6 - x12 - x13      

      e4 = x7 - x11 - x14 - x15

      e5 = x8 - x10 - x16 - x17

      e6 = x9 - x18 - x19      

      e7 = -x10*x40 - 0.333333333333333d0*x2 + x22                    

      e8 = -x10*x41 - 0.333333333333333d0*x2 + x23                    

      e9 =  - x10*x42 - 0.333333333333333d0*x2 + x24                    

      e10 = - x11*x37 - 0.333333333333333d0*x3 + x25                   

      e11 = - x11*x38 - 0.333333333333333d0*x3 + x26                   

      e12 = - x11*x39 - 0.333333333333333d0*x3 + x27                   

      e13 = -(x6*x34 + x7*x37) + x22                                

      e14 = -(x6*x35 + x7*x38) + x23                                

      e15 = -(x6*x36 + x7*x39) + x24                                

      e16 = -(x8*x40 + x9*x43) + x25                                

      e17 = -(x8*x41 + x9*x44) + x26                                

      e18 = -(x8*x42 + x9*x45) + x27                                

      e19 = x22*x46 - x6*x34      

      e20 = x23*x47 - x7*x38      

      e21 = x26*x48 - x8*x41      

      e22 = x27*x49 - x9*x45      

      e23 = x12*x34 + x14*x37 + x16*x40 + x18*x43 
     /      + 0.333333333333333d0*x20 - 30.0d0                          

      e24 = x12*x35 + x14*x38 + x16*x41 + x18*x44 
     /      + 0.333333333333333d0*x20 - 50.0d0 

      e25 = x12*x36 + x14*x39 + x16*x42 + x18*x45 
     /      + 0.333333333333333d0*x20 - 30.0d0    

      e26 = x13*x34 + x15*x37 + x17*x40 + x19*x43
     /      + 0.333333333333333d0*x21 - 70.0d0   

      e27 = x13*x35 + x15*x38 + x17*x41 + x19*x44 
     /      + 0.333333333333333d0*x21 - 50.0d0 

      e28 = x13*x36 + x15*x39 + x17*x42 + x19*x45
     /      + 0.333333333333333d0*x21 - 70.0d0  

      e29 = x4*x28 - x22          

      e30 = x4*x29 - x23          

      e31 = x4*x30 - x24          

      e32 = x5*x31 - x25          

      e33 = x5*x32 - x26          

      e34 = x5*x33 - x27          

      e35 = x34 + x35 + x36 - 1.0d0                                  

      e36 = x37 + x38 + x39 - 1.0d0                                     

      e37 = x40 + x41 + x42 - 1.0d0                                     

      e38 = x43 + x44 + x45 - 1.0d0                                     

      e39 = x28 + x29 + x30 - 1.0d0                                     

      e40 = x31 + x32 + x33 - 1.0d0                                     

      e41 = x36                

      e42 = x43                

      e43 = x4 - 300.0d0*b50       

      e44 = x5 - 300.0d0*b51

      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = e7
      g(7) = e8
      g(8) = e9
      g(9) = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = e15
      g(15) = e16
      g(16) = e17
      g(17) = e18
      g(18) = e19
      g(19) = e20
      g(20) = e21
      g(21) = e22
      g(22) = e23
      g(23) = e24
      g(24) = e25
      g(25) = e26
      g(26) = e27
      g(27) = e28
      g(28) = e29
      g(29) = e30
      g(30) = e31
      g(31) = e32
      g(32) = e33
      g(33) = e34
      g(34) = e35
      g(35) = e36
      g(36) = e37
      g(37) = e38
      g(38) = e39
      g(39) = e40
      g(40) = e41
      g(41) = e42
      g(42) = -e43
      g(43) = -e44

  999 continue
      return
      end
  
      subroutine nous2( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,     xl,  
     /                   xu,     f,      g,  pnam,   pref, 
     /                  fex )    

*  MINLP written by GAMS Convert at 04/23/01 13:00:17
*  
*  Equation counts
*     Total       E       G       L       N       X
*        44      42       0       2       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        51      49       2       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       197      75     122       0
*
*  Solve m using MINLP minimizing objvar;

      implicit double precision(a-h,o-z)
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax),
     /              x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, x16, x17, x18, x19, x20, 
     /        x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, b50,
     /        b51,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NOUS2'
         pref  = '\cite{MINLPLib}'
         fex   = 0.62596741d0
         ncont = 48
         nint  = 0
         nbin  = 2
         n     = ncont + nbin + nint
         m     = 43
         me    = 41
         do i = 1,18
            xl(i) = 0.0d0
            x(i)  = 37.5d0
            xu(i) = 300.0d0
         end do
         x(1) = 150.0d0
         x(2) = 150.0d0
         x(3) = 150.0d0
         x(4) = 150.0d0
         x(5) = 75.0d0
         x(6) = 75.0d0
         x(7) = 75.0d0
         x(8) = 75.0d0 
         do i = 19,20
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do         
         do i = 21,26
            xl(i) = 0.0d0
            x(i)  = 5.0d1
            xu(i) = 100.0d0
         end do
         do i = 27,44
            xl(i) = 0.0d0
            x(i)  = 1.0d0/3.0d0
            xu(i) = 1.0d0
         end do
         do i = 45,ncont
            xl(i) = 0.85d0
            x(i)  = 0.9d0
            xu(i) = 1.0d0
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if

      do i=1,nbin 
         y(i) = x(ncont+i) 
      end do 

      x2 = x(1)
      x3 = x(2)
      x4 = x(3)
      x5 = x(4)
      x6 = x(5)
      x7 = x(6)
      x8 = x(7)
      x9 = x(8)
      x10 = x(9)
      x11 = x(10)
      x12 = x(11)
      x13 = x(12)
      x14 = x(13)
      x15 = x(14)
      x16 = x(15)
      x17 = x(16)
      x18 = x(17)
      x19 = x(18)
      x20 = x(19)
      x21 = x(20)
      x22 = x(21)
      x23 = x(22)
      x24 = x(23)
      x25 = x(24)
      x26 = x(25)
      x27 = x(26)
      x28 = x(27)
      x29 = x(28)
      x30 = x(29)
      x31 = x(30)
      x32 = x(31)
      x33 = x(32)
      x34 = x(33)
      x35 = x(34)
      x36 = x(35)
      x37 = x(36)
      x38 = x(37)
      x39 = x(38)
      x40 = x(39)
      x41 = x(40)
      x42 = x(41)
      x43 = x(42)
      x44 = x(43)
      x45 = x(44)
      x46 = x(45)
      x47 = x(46)
      x48 = x(47)
      x49 = x(48)
      b50 = y(1)
      b51 = y(2)

      f = (0.0042656d0*x29 - 0.0005719d0*x28 + 0.0093514d0*x46 
     /    + 0.0077308d0*x47 - 0.0139904d0)*x4 + (0.0016371d0*x31 
     /    + 0.0288996d0*x32 + 0.0338147d0*x48 + 0.0373349d0*x49 
     /    - 0.0661588d0)*x5 + 0.23947d0*b50 + 0.75835d0*b51   

      e2 = x2 + x3 + x20 + x21 - 300.0d0             

      e3 = x6 - x12 - x13                          

      e4 = x7 - x11 - x14 - x15                    

      e5 = x8 - x10 - x16 - x17                    

      e6 = x9 - x18 - x19                          

      e7 = -x10*x40 - 0.333333333333333d0*x2 + x22    

      e8 = -x10*x41 - 0.333333333333333d0*x2 + x23    

      e9 = -x10*x42 - 0.333333333333333d0*x2 + x24    

      e10 = -x11*x37 - 0.333333333333333d0*x3 + x25   

      e11 = -x11*x38 - 0.333333333333333d0*x3 + x26   

      e12 = -x11*x39 - 0.333333333333333d0*x3 + x27   

      e13 = -(x6*x34 + x7*x37) + x22                

      e14 = -(x6*x35 + x7*x38) + x23                

      e15 = -(x6*x36 + x7*x39) + x24                

      e16 = -(x8*x40 + x9*x43) + x25                

      e17 = -(x8*x41 + x9*x44) + x26                

      e18 = -(x8*x42 + x9*x45) + x27                

      e19 = x22*x46 - x6*x34                          

      e20 = x23*x47 - x7*x38                          

      e21 = x26*x48 - x8*x41                          

      e22 = x27*x49 - x9*x45                          

      e23 = x12*x34 + x14*x37 + x16*x40 + x18*x43 
     /      + 0.333333333333333d0*x20 - 80.0d0                          

      e24 = x12*x35 + x14*x38 + x16*x41 + x18*x44 
     /      + 0.333333333333333d0*x20 - 30.0d0                          

      e25 = x12*x36 + x14*x39 + x16*x42 + x18*x45 
     /      + 0.333333333333333d0*x20 - 20.0d0                          

      e26 = x13*x34 + x15*x37 + x17*x40 + x19*x43
     /      + 0.333333333333333d0*x21 - 20.0d0                          

      e27 = x13*x35 + x15*x38 + x17*x41 + x19*x44 
     /      + 0.333333333333333d0*x21 - 70.0d0                          

      e28 = x13*x36 + x15*x39 + x17*x42 + x19*x45 
     /      + 0.333333333333333d0*x21 - 80.0d0                          

      e29 = x4*x28 - x22                              

      e30 = x4*x29 - x23                              

      e31 = x4*x30 - x24                              

      e32 = x5*x31 - x25                              

      e33 = x5*x32 - x26                              

      e34 = x5*x33 - x27                              

      e35 = x34 + x35 + x36 - 1.0d0                  

      e36 = x37 + x38 + x39 - 1.0d0                  

      e37 = x40 + x41 + x42 - 1.0d0                  

      e38 = x43 + x44 + x45 - 1.0d0                  

      e39 = x28 + x29 + x30 - 1.0d0                  

      e40 = x31 + x32 + x33 - 1.0d0                  

      e41 = x36                                    

      e42 = x43                                    

      e43 = x4 - 300.0d0*b50                           

      e44 = x5 - 300.0d0*b51

      g(1) = e2
      g(2) = e23
      g(3) = e24
      g(4) = e25
      g(5) = e26
      g(6) = e27
      g(7) = e28
      g(8) = e35
      g(9) = e36
      g(10) = e37
      g(11) = e38
      g(12) = e39
      g(13) = e40
      g(14) = e3
      g(15) = e4
      g(16) = e5
      g(17) = e6
      g(18) = e7
      g(19) = e8
      g(20) = e9
      g(21) = e10
      g(22) = e11
      g(23) = e12
      g(24) = e13
      g(25) = e14
      g(26) = e15
      g(27) = e16
      g(28) = e17
      g(29) = e18
      g(30) = e19
      g(31) = e20
      g(32) = e21
      g(33) = e22
      g(34) = e29
      g(35) = e30
      g(36) = e31
      g(37) = e32
      g(38) = e33
      g(39) = e34
      g(40) = e41
      g(41) = e42
      g(42) = -e43
      g(43) = -e44

  999 continue
      return
      end

      subroutine nvs01( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:13
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         4       2       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       2       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        10       3       7       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS01'
         pref  = '\cite{MINLPLib}'
         fex   = 12.46967d0
         ncont = 1
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 1
         xl(1) = 0.0d0
         x(1)  = 100.0d0
         xu(1) = 100.0d0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo   
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = 0.04712385d0*y(2)*dsqrt(900.0d0 + y(1)**2)

      g(1) = 420.169404664517d0*dsqrt(900.0d0 + y(1)**2) 
     /       - x(1)*y(1)*y(2)

      g(2) = -x(1) + 100.0d0

      g(3) = 296087.631843d0*(0.01d0 + 0.0625d0*(y(2)**2))
     /       /(7200.0d0 + y(1)**2) - x(1)

  999 continue
      return
      end

      subroutine nvs02( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:19
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         4       4       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       4       0       5       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        20       4      16       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS02'
         pref  = '\cite{MINLPLib}'
         fex   = 5.964185d0
         ncont = 3
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 3
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         xu(1) = 92.0d0
         x(1)  = 50.0d0
         xl(2) = 90.0d0
         xu(2) = 110.0d0
         x(2)  = 100.0d0      
         xl(3) = 20.0d0
         xu(3) = 25.0d0
         x(3)  = 20.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f =  9.99999999999999D-5*(5.3578547d0*y(3)**2 
     /     + 0.8356891d0*y(1)*y(5) + 37.293239d0*y(1)) + 5.9207859d0
     
      g(1) = -(0.0056858d0*y(2)*y(5) + 0.0006262d0*y(1)*y(4) 
     /       - 0.0022053d0*y(3)*y(5)) + x(1) - 85.334407d0

      g(2) = -(0.0071317d0*y(2)*y(5) + 0.0029955d0*y(1)*y(2) 
     /       + 0.0021813d0*y(3)**2) + x(2) - 80.51249d0

      g(3) = -(0.0047026d0*y(3)*y(5) + 0.0012547d0*y(1)*y(3)
     /       + 0.0019085d0*y(3)*y(4)) + x(3) - 9.300961d0

  999 continue
      return
      end

      subroutine nvs03( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:20
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         7       4       3       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS03'
         pref  = '\cite{MINLPLib}'
         fex   = 16.0d0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = (y(1) - 8.0d0)**2 + (y(2) - 2.0d0)**2
      
      g(1) = -0.1d0*y(1)**2 + y(2)
 
      g(2) = -0.333333333333333d0*y(1) - y(2) + 4.5d0

  999 continue
      return
      end

      subroutine nvs04( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:20
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         1       1       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         3       1       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS04'
         pref  = '\cite{MINLPLib}'
         fex   = 0.72d0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         do i=1,n
            xl(i) = 1.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = (100.0d0*(0.5d0 + y(2) - (0.6d0 + y(1))**2)**2) 
     /    + (0.4d0 - y(1))**2 

  999 continue
      return
      end

      subroutine nvs05( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:20
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*        10       5       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       7       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        31       7      24       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS05'
         pref  = '\cite{MINLPLib}'
         fex   = 5.470934d0
         ncont = 6
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 9
         me    = 4
         do i=1,ncont
            xl(i) = 0.01d0
            x(i)  = 1.0d0
            xu(i) = 1.0d8
         end do
         xl(1) = 0.01d0
         xu(1) = 200.0d0
         xl(2) = 0.01d0
         xu(2) = 200.0d0
         xl(3) = 0.01d0
         xl(4) = 0.01d0
         x(5)  = 2.0d0
         xl(6) = 0.01d0
         do i=ncont+1,n
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      end if

      do i=1,nint
         y(i) = x(ncont+i)
      end do

      f = 1.10471d0*sqr(x(1))*x(2) + 0.04811d0*y(1)*y(2)*(14.0d0 + x(2))

      g(1) = -4243.28147100424d0/(x(1)*x(2)) + x(3)

      g(2) = -dsqrt(0.25d0*sqr(x(2)) + sqr(0.5d0*y(1) + 0.5d0*x(1))) 
     /       + x(5) 

      g(3) = (-0.707213578500707d0*(84000.0d0 + 3000.0d0*x(2))*x(5)/
     /            (x(1)*x(2)*(0.0833333333333333d0*sqr(x(2)) 
     /       + sqr(0.5d0*y(1) + 0.5d0*x(1)))) + x(4))

      g(4) = -0.5d0*x(2)/x(5) + x(6)

      g(5) = -dsqrt(sqr(x(3)) + 2.0d0*x(3)*x(4)*x(6) + sqr(x(4))) 
     /                                                 + 13600.0d0

      g(6) = -504000.0d0/(y(2)*sqr(y(1))) + 30000.0d0

      g(7) = y(2) - x(1) 

      g(8) = 0.0204744897959184d0*dsqrt(1.0d15*y(1)**2*y(2)**6)
     /           *(1.0d0 - 0.0282346219657891d0*y(1)) - 6000.0d0

      g(9) = - 0.21952d0/(y(2)*y(1)**3) + 0.25d0

  999 continue
      return
      end

      subroutine nvs06( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:20
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         1       1       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         3       1       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), g(mmax),
     /       f, fex
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS06'
         pref  = '\cite{MINLPLib}'
         fex   = 1.770312d0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         do i=1,n
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 100.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 0.1d0*(y(1)**2 + (1.0d0 + y(2)**2)/(y(1)**2) 
     /       + (100.0d0 + y(1)**2*y(2)**2)/(y(1)*y(2))**4) + 1.2d0

  999 continue
      return
      end

      subroutine nvs07( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:21
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       1       0       3       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         9       6       3       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS07'
         pref  = '\cite{MINLPLib}'
         fex   = 4.0d0
         ncont = 0
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = 2.0d0*y(2)**2 + y(1) + 5.0d0*y(3)

      g(1) = y(2)*y(3)**2 + 5.0d0*y(3) + 3.0d0*y(1) - 10.0d0
      
      g(2) = y(1) - y(3) - 2.66d0

  999 continue
      return
      end

      subroutine nvs08( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:21
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         4       1       3       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       2       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        13       6       7       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS08'
         pref  = '\cite{MINLPLib}'
         fex   = 23.44973d0 
         ncont = 1
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         xl(1) = 0.01d0
         x(1)  = 1.0d0
         xu(1) = 200.0d0
         xl(2) = 0.0d0
         x(2)  = 1.0d0
         xu(2) = 200.0d0
         xl(3) = 0.0d0
         x(3)  = 1.0d0
         xu(3) = 200.0d0
        goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = (y(1) - 3.0d0)**2 + (y(2) - 2.0d0)**2 + (4.0d0 + x(1))**2

      g(1) =  dsqrt(x(1)) + y(1) + 2.0d0*y(2) - 10.0d0
 
      g(2) =  0.240038406144983d0*y(1)**2 - y(2)
     /           + 0.255036980362153d0*x(1) + 3.0d0
 
      g(3) =  y(2)**2 - 1.0d0/(x(1)**3*dsqrt(x(1))) - 4.0d0*y(1) 
     /           + 12.0d0

  999 continue
      return
      end

      subroutine nvs09( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:21
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         1       1       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        11       1       0      10       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        11       1      10       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS09'
         pref  = '\cite{MINLPLib}'
         fex   = -43.13434d0 
         ncont = 0
         nint  = 10
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         do i=1,n
            xl(i) = 3.0d0
            x(i)  = 5.0d0
            xu(i) = 9.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = (dlog(y(1) - 2.0d0))**2 + (dlog(10.0d0 - y(1)))**2 
     /    + (dlog(y(2) - 2.0d0))**2 + (dlog(10.0d0 - y(2)))**2 
     /    + (dlog(y(3) - 2.0d0))**2 + (dlog(10.0d0 - y(3)))**2
     /    + (dlog(y(4) - 2.0d0))**2 + (dlog(10.0d0 - y(4)))**2
     /    + (dlog(y(5) - 2.0d0))**2 + (dlog(10.0d0 - y(5)))**2
     /    + (dlog(y(6) - 2.0d0))**2 + (dlog(10.0d0 - y(6)))**2
     /    + (dlog(y(7) - 2.0d0))**2 + (dlog(10.0d0 - y(7)))**2 
     /    + (dlog(y(8) - 2.0d0))**2 + (dlog(10.0d0 - y(8)))**2 
     /    + (dlog(y(9) - 2.0d0))**2 + (dlog(10.0d0 - y(9)))**2
     /    + (dlog(y(10)- 2.0d0))**2 + (dlog(10.0d0 - y(10)))**2
     /    - (y(1)*y(2)*y(3)*y(4)*y(5)*y(6)*y(7)*y(8)*y(9)*y(10))**0.2d0
C
  999 continue
      return
      end

      subroutine nvs10( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:13
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         7       1       6       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS10'
         pref  = '\cite{MINLPLib}'
         fex   = -310.8d0 
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 7.0d0*y(1)**2 + 6.0d0*y(2)**2 - 35.0d0*y(1) - 80.4d0*y(2)
      
      g(1) = -9.0d0*y(1)**2 - 10.0d0*y(1)*y(2) - 8.0d0*y(2)**2 
     /       + 583.0d0

      g(2) = -6.0d0*y(1)**2 - 8.0d0*y(1)*y(2) - 6.0d0*y(2)**2 
     /       + 441.0d0


  999 continue
      return
      end

      subroutine nvs11( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:13
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         4       1       3       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       1       0       3       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        13       1      12       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS11'
         pref  = '\cite{MINLPLib}'
         fex   = -431.0d0 
         ncont = 0
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 7.0d0*y(1)**2   + 6.0d0*y(2)**2  - 15.8d0*y(1) - 93.2d0*y(2) 
     /    + 8.0d0*y(3)**2   - 6.0d0*y(3)*y(1) + 4.0d0*y(3)*y(2) 
     /    - 63.0d0*y(3)
      
      g(1) = -9.0d0*y(1)**2 - 10.0d0*y(1)*y(2) - 8.0d0*y(2)**2
     /       - 5.0d0*y(3)**2   - 6.0d0*y(3)*y(1) - 10.0d0*y(3)*y(2)
     /       + 1000.0d0
 
      g(2) = -6.0d0*y(1)**2  - 8.0d0*y(1)*y(2) - 6.0d0*y(2)**2 
     /       - 4.0d0*y(3)**2 - 2.0d0*y(3)*y(1) - 2.0d0*y(3)*y(2) 
     /       + 550.0d0
 
      g(3) = -9.0d0*y(1)**2  - 6.0d0*y(2)**2 - 8.0d0*y(3)**2 
     /       + 2.0d0*y(2)*y(1) + 2.0d0*y(3)*y(2) + 340.0d0


  999 continue
      return
      end

      subroutine nvs12( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:14
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         5       1       4       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         5       1       0       4       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        21       1      20       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS12'
         pref  = '\cite{MINLPLib}'
         fex   = -481.2d0 
         ncont = 0
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 7.0d0*y(1)**2 + 6.0d0*y(2)**2 - 20.0d0*y(1) - 93.2d0*y(2) 
     /    + 8.0d0*y(3)**2 - 6.0d0*y(3)*y(1) + 4.0d0*y(3)*y(2) 
     /    - 67.2d0*y(3) + 6.0d0*y(4)**2 + 2.0d0*y(4)*y(1) 
     /    + 2.0d0*y(4)*y(3) - 36.6d0*y(4)
      
      g(1) = -9.0d0*y(1)**2 - 10.0d0*y(1)*y(2) - 8.0d0*y(2)**2
     /       - 5.0d0*y(3)**2 - 6.0d0*y(3)*y(1) - 10.0d0*y(3)*y(2) 
     /       - 7.0d0*y(4)**2 - 10.0d0*y(4)*y(1) - 6.0d0*y(4)*y(2) 
     /       - 2.0d0*y(4)*y(3) + 1100.0d0

      g(2) = -6.0d0*y(1)**2 - 8.0d0*y(1)*y(2) - 6.0d0*y(2)**2 
     /       - 4.0d0*y(3)**2 - 2.0d0*y(3)*y(1) - 2.0d0*y(3)*y(2) 
     /       - 8.0d0*y(4)**2 + 2.0d0*y(4)*y(1) + 10.0d0*y(4)*y(2) 
     /       + 440.0d0
 
      g(3) = -9.0d0*y(1)**2 - 6.0d0*y(2)**2 - 8.0d0*y(3)**2 
     /       + 2.0d0*y(2)*y(1) + 2.0d0*y(3)*y(2) - 6.0d0*y(4)**2
     /       + 4.0d0*y(4)*y(1) + 4.0d0*y(4)*y(2) - 2.0d0*y(4)*y(3) 
     /       + 310.0d0
 
      g(4) = -8.0d0*y(1)**2 - 4.0d0*y(2)**2 - 9.0d0*y(3)**2 
     /       - 7.0d0*y(4)**2 - 2.0d0*y(2)*y(1) - 2.0d0*y(3)*y(1) 
     /       - 4.0d0*y(3)*y(2) + 6.0d0*y(4)*y(1) + 2.0d0*y(4)*y(2) 
     /       - 2.0d0*y(4)*y(3) + 460.0d0

  999 continue
      return
      end

      subroutine nvs13( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:14
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         6       1       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         6       1       0       5       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        31       1      30       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS13'
         pref  = '\cite{MINLPLib}'
         fex   = -585.2d0 
         ncont = 0
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 5
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo
      
      f = 7.0d0*y(1)**2 + 6.0d0*y(2)**2 + 12.0d0*y(1) - 77.2d0*y(2) 
     /    + 8.0d0*y(3)**2 - 6.0d0*y(3)*y(1) + 4.0d0*y(3)*y(2) 
     /    - 19.2d0*y(3) + 6.0d0*y(4)**2 + 2.0d0*y(4)*y(1) 
     /    + 2.0d0*y(4)*y(3) - 36.6d0*y(4) + 7.0d0*y(5)**2 
     /    - 4.0d0*y(5)*y(1) - 2.0d0*y(5)*y(2) - 6.0d0*y(5)*y(3) 
     /    - 69.4d0*y(5) 
      
      g(1) = -9.0d0*y(1)**2 - 10.0d0*y(1)*y(2) - 8.0d0*y(2)**2
     /       - 5.0d0*y(3)**2 - 6.0d0*y(3)*y(1) - 10.0d0*y(3)*y(2) 
     /       - 7.0d0*y(4)**2 - 10.0d0*y(4)*y(1) - 6.0d0*y(4)*y(2) 
     /       - 2.0d0*y(4)*y(3) - 2.0d0*y(5)*y(2) - 7.0d0*y(5)**2 
     /       + 1430.0d0

      g(2) = -6.0d0*y(1)**2 - 8.0d0*y(1)*y(2) - 6.0d0*y(2)**2 
     /       - 4.0d0*y(3)**2 - 2.0d0*y(3)*y(1) - 2.0d0*y(3)*y(2) 
     /       - 8.0d0*y(4)**2 + 2.0d0*y(4)*y(1) + 10.0d0*y(4)*y(2)
     /       - 2.0d0*y(5)*y(1) - 6.0d0*y(5)*y(2) + 6.0d0*y(5)*y(4) 
     /       + 7.0d0*y(5)**2 + 1150.0d0

      g(3) = -9.0d0*y(1)**2 - 6.0d0*y(2)**2 - 8.0d0*y(3)**2 
     /       + 2.0d0*y(2)*y(1) + 2.0d0*y(3)*y(2) - 6.0d0*y(4)**2
     /       + 4.0d0*y(4)*y(1) + 4.0d0*y(4)*y(2) - 2.0d0*y(4)*y(3)
     /       - 6.0d0*y(5)*y(1) - 2.0d0*y(5)*y(2) + 4.0d0*y(5)*y(4) 
     /       + 6.0d0*y(5)**2 + 850.0 

      g(4) = -8.0d0*y(1)**2 - 4.0d0*y(2)**2 - 9.0d0*y(3)**2 
     /       - 7.0d0*y(4)**2 - 2.0d0*y(2)*y(1) - 2.0d0*y(3)*y(1) 
     /       - 4.0d0*y(3)*y(2) + 6.0d0*y(4)*y(1) + 2.0d0*y(4)*y(2) 
     /       - 2.0d0*y(4)*y(3) - 6.0d0*y(5)*y(1) - 4.0d0*y(5)*y(2) 
     /       - 2.0d0*y(5)*y(3) + 6.0d0*y(5)*y(4) + 6.0d0*y(5)**2 
     /       + 1125.0d0

      g(5) = 2.0d0*y(2)*y(1) - 4.0d0*y(1)**2 - 5.0d0*y(2)**2 
     /       - 6.0d0*y(3)*y(1) - 8.0d0*y(3)**2 - 2.0d0*y(4)*y(1) 
     /       + 6.0d0*y(4)*y(2) - 2.0d0*y(4)*y(3) - 6.0d0*y(4)**2 
     /       - 4.0d0*y(5)*y(1) + 2.0d0*y(5)*y(2) - 6.0d0*y(5)*y(3)
     /       - 8.0d0*y(5)*y(4) - 7.0d0*y(5)**2 + 1030.0d0

  999 continue
      return
      end

      subroutine nvs14( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:17
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         4       4       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       4       0       5       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        20       4      16       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS14'
         pref  = '\cite{MINLPLib}'
         fex   = -40358.15d0 
         ncont = 3
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 3
         xl(1) = 0.0d0
         x(1)  = 46.0d0
         xu(1) = 92.0d0
         xl(2) = 90.0d0
         x(2)  = 100.0d0
         xu(2) = 110.0d0
         xl(3) = 20.0d0
         x(3)  = 23.0d0
         xu(3) = 25.0d0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         ENDDO
         xu(4) = 1.0d1
         x(4)  = 5.0d0
         xu(5) = 2.0d1
         x(5)  = 10.0d0
         xu(6) = 2.0d1
         x(6)  = 10.0d0
        goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = 5.3578547d0*y(3)**2 + 0.8356891d0*y(1)*y(5) 
     /           + 37.293239d0*y(1) - 40792.141d0
      
      g(1) = -(0.0056858d0*y(2)*y(5) + 0.0006262d0*y(1)*y(4)
     /       - 0.0022053d0*y(3)*y(5)) + x(1) - 85.334407d0

      g(2) = -(0.0071317d0*y(2)*y(5) + 0.0029955d0*y(1)*y(2) 
     /           + 0.0021813d0*y(3)**2) + x(2) - 80.51249d0

      g(3) = -(0.0047026d0*y(3)*y(5) + 0.0012547d0*y(1)*y(3)
     /           + 0.0019085d0*y(3)*y(4)) + x(3) - 9.300961d0

  999 continue
      return
      end

      subroutine nvs15( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:17
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         2       1       1       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       1       0       3       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         7       4       3       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS15'
         pref  = '\cite{MINLPLib}'
         fex   = 1.0d0 
         ncont = 0
         nint  = 3
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = 2.0d0*y(1)**2 - 8.0d0*y(1) + 2.0d0*y(2)**2 - 6.0d0*y(2) 
     /    + y(3)**2 - 4.0d0*y(3) + 2.0d0*y(1)*y(2) + 2.0d0*y(1)*y(3) 
     /    + 9.0d0
      
      g(1) = -y(1) - y(2) - 2.0d0*y(3) + 3.0d0

  999 continue
      return
      end

      subroutine nvs16( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:18
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         1       1       0       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         3       1       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS16'
         pref  = '\cite{MINLPLib}'
         fex   = 0.703125d0 
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      f = (1.5d0 - y(1)*(1.0d0 - y(2)))**2 
     /    + (2.25d0 - y(1)*(1.0d0 - y(2)**2))**2 
     /    + (2.625d0 - y(1)*(1.0d0 - y(2)**3))**2 

  999 continue
      return
      end

      subroutine nvs17( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:18
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         8       1       7       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         8       1       0       7       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        57       1      56       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS17'
         pref  = '\cite{MINLPLib}'
         fex   = -1100.4d0 
         ncont = 0
         nint  = 7
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 7
         me    = 0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)

      f =  7.0d0*sqr(i1) + 6.0d0*sqr(i2) + 14.2d0*i1 - 11.6d0*i2 
     /     + 8.0d0*sqr(i3) - 6.0d0*i3*i1 + 4.0d0*i3*i2 + 18.4d0*i3 
     /     + 6.0d0*sqr(i4) + 2.0d0*i4*i1 + 2.0d0*i4*i3 - 24.8d0*i4 
     /     + 7.0d0*sqr(i5) - 4.0d0*i5*i1 - 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /     - 132.8d0*i5 + 4.0d0*sqr(i6) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /     - 4.0d0*i6*i3 - 2.0d0*i6*i4 + 6.0d0*i6*i5 - 84.4d0*i6 
     /     + 6.0d0*sqr(i7) - 2.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3
     /     + 4.0d0*i7*i5 + 4.0d0*i7*i6 - 88.0d0*i7

      g(1) = (-9.0d0*sqr(y(1))) - 10.0d0*y(1)*y(2) - 8.0d0*sqr(y(2)) 
     /       - 5.0d0*sqr(y(3)) - 6.0d0*y(3)*y(1) - 10.0d0*y(3)*y(2)
     /       - 7.0d0*sqr(y(4)) - 10.0d0*y(4)*y(1) 
     /       - 6.0d0*y(4)*y(2) - 2.0d0*y(4)*y(3) - 2.0d0*y(5)*y(2)
     /       - 7.0d0*sqr(y(5)) - 6.0d0*y(6)*y(1) - 2.0d0*y(6)*y(2)
     /       - 2.0d0*y(6)*y(4) - 5.0d0*sqr(y(6)) 
     /       + 6.0d0*i7*i1 + 2.0d0*i7*i2 + 4.0d0*i7*i3 + 2.0d0*i7*i4 
     /       - 4.0d0*i7*i5 + 4.0d0*i7*i6 - 8.0d0*sqr(i7) + 1930.0

      g(2) = -(6.0d0*sqr(i1)) - 6.0d0*i1*i2 - 6.0d0*sqr(i2) 
     /       - 4.0d0*sqr(i3) - 2.0d0*i3*i1 - 2.0d0*i3*i2 - 8.0d0*sqr(i4)
     /       + 2.0d0*i4*i1 + 10.0d0*i4*i2 - 2.0d0*i5*i1 - 6.0d0*i5*i2 
     /       + 6.0d0*i5*i4 + 7.0d0*sqr(i5) - 2.0d0*i6*i2 + 8.0d0*i6*i3 
     /       + 2.0d0*i6*i4 - 4.0d0*i6*i5 - 8.0d0*sqr(i6) - 6.0d0*i7*i1 
     /       - 10.0d0*i7*i2 - 2.0d0*i7*i3 + 10.0d0*i7*i4 - 10.0d0*i7*i5 
     /       - 8.0d0*sqr(i7) + 2940.0d0

      g(3) = (-9.0d0*sqr(i1)) - 6.0d0*sqr(i2) - 8.0d0*sqr(i3) 
     /       + 2.0d0*i2*i1 + 2.0d0*i3*i2 - 6.0d0*sqr(i4) + 4.0d0*i4*i1 
     /       + 4.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 - 2.0d0*i5*i2 
     /       + 4.0d0*i5*i4 + 6.0d0*sqr(i5) + 2.0d0*i6*i1 + 4.0d0*i6*i2 
     /       - 6.0d0*i6*i4 - 2.0d0*i6*i5 - 5.0d0*sqr(i6) + 2.0d0*i7*i2 
     /       - 4.0d0*i7*i3 - 6.0d0*i7*i5 - 4.0d0*i7*i6 - 7.0d0*sqr(i7)
     /       + 1840.0d0

      g(4) = (-8.0d0*sqr(i1)) - 4.0d0*sqr(i2) - 9.0d0*sqr(i3) 
     /       - 7.0d0*sqr(i4) - 2.0d0*i2*i1 - 2.0d0*i3*i1 - 4.0d0*i3*i2 
     /       + 6.0d0*i4*i1 + 2.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 
     /       - 4.0d0*i5*i2 - 2.0d0*i5*i3 + 6.0d0*i5*i4 + 6.0d0*sqr(i5)
     /       - 10.0d0*i6*i1 - 10.0d0*i6*i3 + 4.0d0*i6*i4 - 2.0d0*i6*i5
     /       - 7.0d0*sqr(i6) + 6.0d0*i7*i1 - 2.0d0*i7*i2 - 2.0d0*i7*i3 
     /       + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 6.0d0*sqr(i7) + 1650.0d0

      g(5) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 5.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) - 2.0d0*i4*i1 + 6.0d0*i4*i2 - 2.0d0*i4*i3 
     /       - 6.0d0*sqr(i4) - 4.0d0*i5*i1 + 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /       - 8.0d0*i5*i4 - 7.0d0*sqr(i5) + 4.0d0*i6*i1 - 4.0d0*i6*i2 
     /       + 6.0d0*i6*i3 + 4.0d0*i6*i5 - 7.0d0*sqr(i6) + 4.0d0*i7*i1 
     /       - 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 + 4.0d0*i7*i5 
     /       + 4.0d0*i7*i6 - 8.0d0*sqr(i7) + 1220.0d0

      g(6) = 2.0d0*i2*i1 - 7.0d0*sqr(i1) - 7.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 2.0d0*i3*i2 - 6.0d0*sqr(i3) - 2.0d0*i4*i1 + 2.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 5.0d0*sqr(i4) - 2.0d0*i5*i1 - 4.0d0*i5*i3 
     /       + 2.0d0*i5*i4 - 5.0d0*sqr(i5) + 2.0d0*i6*i1 - 4.0d0*i6*i2
     /       + 4.0d0*i6*i3 + 2.0d0*i6*i4 + 6.0d0*i6*i5 - 9.0d0*sqr(i6) 
     /       + 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 - 4.0d0*i7*i5 
     /       + 8.0d0*i7*i6 - 6.0d0*sqr(i7) + 1020.0d0

      g(7) = (-9.0d0*sqr(i1)) - 4.0d0*i2*i1 - 8.0d0*sqr(i2) 
     /       + 4.0d0*i3*i1 + 2.0d0*i3*i2 - 7.0d0*sqr(i3) + 4.0d0*i4*i1 
     /       + 4.0d0*i4*i3 - 7.0d0*sqr(i4) - 2.0d0*i5*i1 - 12.0d0*i5*i2 
     /       - 4.0d0*i5*i3 - 8.0d0*sqr(i5) - 8.0d0*i6*i1 + 2.0d0*i6*i2 
     /       - 2.0d0*i6*i5 - 6.0d0*sqr(i6) - 4.0d0*i7*i1 - 6.0d0*i7*i2 
     /       - 2.0d0*i7*i3 + 10.0d0*i7*i4 - 2.0d0*i7*i5 + 2.0d0*i7*i6 
     /       - 7.0d0*sqr(i2) + 2740.0d0

  999 continue
      return
      end

      subroutine nvs18( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:18
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         7       1       6       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         7       1       0       6       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        43       1      42       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, i6
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS18'
         pref  = '\cite{MINLPLib}'
         fex   = -778.4d0 
         ncont = 0
         nint  = 6
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 6
         me    = 0
         do i=ncont+1,n
            xl(i) = 1.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)

      f =  7.0d0*sqr(i1) + 6.0d0*sqr(i2) + 0.2d0*i1 - 53.6d0*i2 
     /     + 8.0d0*sqr(i3) - 6.0d0*i3*i1 + 4.0d0*i3*i2 + 4.4d0*i3 
     /     + 6.0d0*sqr(i4) + 2.0d0*i4*i1 + 2.0d0*i4*i3 - 24.8d0*i4 
     /     + 7.0d0*sqr(i5) - 4.0d0*i5*i1 - 2.0d0*i5*i2 - 6.0d0*i5*i3
     /     - 104.8d0*i5 + 4.0d0*sqr(i6) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /     - 4.0d0*i6*i3 - 2.0d0*i6*i4 + 6.0d0*i6*i5 - 56.4d0*i6

      g(1) = (-9.0d0*sqr(i1)) - 10.0d0*i1*i2 - 8.0d0*sqr(i2) 
     /       - 5.0d0*sqr(i3) - 6.0d0*i3*i1 - 10.0d0*i3*i2
     /       - 7.0d0*sqr(i4)- 10.0d0*i4*i1 - 6.0d0*i4*i2 - 2.0d0*i4*i3 
     /       - 2.0d0*i5*i2 - 7.0d0*sqr(i5) - 6.0d0*i6*i1 - 2.0d0*i6*i2 
     /       - 2.0d0*i6*i4 - 5.0d0*sqr(i6) + 1800.0d0

      g(2) = (-6.0d0*sqr(i1)) - 8.0d0*i1*i2 - 6.0d0*sqr(i2)
     /       - 4.0d0*sqr(i3) - 2.0d0*i3*i1 - 2.0d0*i3*i2 - 8.0d0*sqr(i4)
     /       + 2.0d0*i4*i1 + 10.0d0*i4*i2 - 2.0d0*i5*i1 - 6.0d0*i5*i2 
     /       + 6.0d0*i5*i4 + 7.0d0*sqr(i5) - 2.0d0*i6*i2 + 8.0d0*i6*i3 
     /       + 2.0d0*i6*i4 - 4.0d0*i6*i5 - 8.0d0*sqr(i6) + 1520.0d0

      g(3) = (-9.0d0*sqr(i1)) - 6.0d0*sqr(i2) - 8.0d0*sqr(i3) 
     /       + 2.0d0*i2*i1 + 2.0d0*i3*i2 - 6.0d0*sqr(i4) + 4.0d0*i4*i1
     /       + 4.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 - 2.0d0*i5*i2 
     /       + 4.0d0*i5*i4 + 6.0d0*sqr(i5) + 2.0d0*i6*i1 + 4.0d0*i6*i2
     /       - 6.0d0*i6*i4 - 2.0d0*i6*i5 - 5.0d0*sqr(i6) + 1000.0d0

      g(4) = (-8.0d0*sqr(i1)) - 4.0d0*sqr(i2) - 9.0d0*sqr(i3) 
     /       - 7.0d0*sqr(i4) - 2.0d0*i2*i1 - 2.0d0*i3*i1 - 4.0d0*i3*i2
     /       + 6.0d0*i4*i1 + 2.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 
     /       - 4.0d0*i5*i2 - 2.0d0*i5*i3 + 6.0d0*i5*i4 + 6.0d0*sqr(i5)
     /       - 10.0d0*i6*i1 - 10.0d0*i6*i3 + 4.0d0*i6*i4 
     /       - 2.0d0*i6*i5 - 7.0d0*sqr(i6) + 1745.0d0

      g(5) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 5.0d0*sqr(i2) 
     /       - 6.0d0*i3*i1 - 8.0d0*sqr(i3) - 2.0d0*i4*i1 + 6.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 6.0d0*sqr(i4) - 4.0d0*i5*i1 + 2.0d0*i5*i2 
     /       - 6.0d0*i5*i3 - 8.0d0*i5*i4 - 7.0d0*sqr(i5) + 4.0d0*i6*i1 
     /       - 4.0d0*i6*i2 + 6.0d0*i6*i3 + 4.0d0*i6*i5 - 7.0d0*sqr(i6) 
     /       + 1070.0d0

      g(6) = 2.0d0*i2*i1 - 7.0d0*sqr(i1) - 7.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 2.0d0*i3*i2 - 6.0d0*sqr(i3) - 2.0d0*i4*i1 + 2.0d0*i4*i2
     /       - 2.0d0*i4*i3 - 5.0d0*sqr(i4) - 2.0d0*i5*i1 - 4.0d0*i5*i3
     /       + 2.0d0*i5*i4 - 5.0d0*sqr(i5) + 2.0d0*i6*i1 - 4.0d0*i6*i2
     /       + 4.0d0*i6*i3 + 2.0d0*i6*i4 + 6.0d0*i6*i5 - 9.0d0*sqr(i6)
     /       + 990.0d0

  999 continue
      return
      end

      subroutine nvs19( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:18
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         9       1       8       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       1       0       8       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        73       1      72       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7, i8
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS19'
         pref  = '\cite{MINLPLib}'
         fex   = -1098.4d0 
         ncont = 0
         nint  = 8
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 8
         me    = 0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo
 
      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)

      f = 7.0d0*sqr(i1) + 6.0d0*sqr(i2) + 20.2d0*i1 - 8.6d0*i2 
     /    + 8.0d0*sqr(i3) - 6.0d0*i3*i1 + 4.0d0*i3*i2 + 9.4d0*i3 
     /    + 6.0d0*sqr(i4) + 2.0d0*i4*i1 + 2.0d0*i4*i3 - 30.8d0*i4 
     /    + 7.0d0*sqr(i5) - 4.0d0*i5*i1 - 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /    - 126.8d0*i5 + 4.0d0*sqr(i6) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /    - 4.0d0*i6*i3 - 2.0d0*i6*i4 + 6.0d0*i6*i5 - 81.4d0*i6 
     /    + 6.0d0*sqr(i7) - 2.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3
     /    + 4.0d0*i7*i5 + 4.0d0*i7*i6 - 94*i7 + 7.0d0*sqr(i8) 
     /    - 4.0d0*i8*i1 - 2.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4 
     /    - 4.0d0*i8*i5 - 2.0d0*i8*i6 + 4.0d0*i8*i7 - 9.4d0*i8

      g(1) = (-9.0d0*sqr(i1)) - 10.0d0*i1*i2 - 8.0d0*sqr(i2) 
     /       - 5.0d0*sqr(i3) - 6.0d0*i3*i1 - 10.0d0*i3*i2 
     /       - 7.0d0*sqr(i4) - 10.0d0*i4*i1 - 6.0d0*i4*i2 - 2.0d0*i4*i3 
     /       - 2.0d0*i5*i2 - 7.0d0*sqr(i5) - 6.0d0*i6*i1 - 2.0d0*i6*i2 
     /       - 2.0d0*i6*i4 - 5.0d0*sqr(i6) + 6.0d0*i7*i1 + 2.0d0*i7*i2 
     /       + 4.0d0*i7*i3 + 2.0d0*i7*i4 - 4.0d0*i7*i5 + 4.0d0*i7*i6 
     /       - 8.0d0*sqr(i7) - 2.0d0*i8*i1 - 8.0d0*i8*i2 - 2.0d0*i8*i3 
     /       + 6.0d0*i8*i5 - 2.0d0*i8*i7 - 6.0d0*sqr(i8) + 1980.0d0
 
      g(2) = (-6.0d0*sqr(i1)) - 8.0d0*i1*i2 - 6.0d0*sqr(i2) 
     /       - 4.0d0*sqr(i3) - 2.0d0*i3*i1 - 2.0d0*i3*i2 - 8.0d0*sqr(i4)
     /       + 2.0d0*i4*i1 + 10.0d0*i4*i2 - 2.0d0*i5*i1 - 6.0d0*i5*i2 
     /       + 6.0d0*i5*i4 + 7.0d0*sqr(i5) - 2.0d0*i6*i2 + 8.0d0*i6*i3 
     /       + 2.0d0*i6*i4 - 4.0d0*i6*i5 - 8.0d0*sqr(i6) - 6.0d0*i7*i1 
     /       - 10.0d0*i7*i2 - 2.0d0*i7*i3 + 10.0d0*i7*i4 - 10.0d0*i7*i5 
     /       - 8.0d0*sqr(i7) - 2.0d0*i8*i1 - 4.0d0*i8*i2 - 2.0d0*i8*i3 
     /       - 8.0d0*i8*i5 - 8.0d0*i8*i7 - 5.0d0*sqr(i8) + 3180.0d0
 
      g(3) = (-9.0d0*sqr(i1)) - 6.0d0*sqr(i2) - 8.0d0*sqr(i3) 
     /       + 2.0d0*i2*i1 + 2.0d0*i3*i2 - 6.0d0*sqr(i4) + 4.0d0*i4*i1 
     /       + 4.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 - 2.0d0*i5*i2 
     /       + 4.0d0*i5*i4 + 6.0d0*sqr(i5) + 2.0d0*i6*i1 + 4.0d0*i6*i2 
     /       - 6.0d0*i6*i4 - 2.0d0*i6*i5 - 5.0d0*sqr(i6) + 2.0d0*i7*i2 
     /       - 4.0d0*i7*i3 - 6.0d0*i7*i5 - 4.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       - 2.0d0*i8*i1 + 4.0d0*i8*i3 + 2.0d0*i8*i4 - 4.0d0*sqr(i8)
     /       + 1830.0d0
 
      g(4) = (-8.0d0*sqr(i1)) - 4.0d0*sqr(i2) - 9.0d0*sqr(i3) 
     /       - 7.0d0*sqr(i4) - 2.0d0*i2*i1 - 2.0d0*i3*i1 - 4.0d0*i3*i2 
     /       + 6.0d0*i4*i1 + 2.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 
     /       - 4.0d0*i5*i2 - 2.0d0*i5*i3 + 6.0d0*i5*i4 + 6.0d0*sqr(i5) 
     /       - 10.0d0*i6*i1 - 10.0d0*i6*i3 + 4.0d0*i6*i4 - 2.0d0*i6*i5 
     /       - 7.0d0*sqr(i6) + 6.0d0*i7*i1 - 2.0d0*i7*i2 - 2.0d0*i7*i3 
     /       + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 6.0d0*sqr(i7) + 4.0d0*i8*i1 
     /       - 4.0d0*i8*i2 + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 4.0d0*i8*i5 
     /       + 8.0d0*i8*i6 + 6.0d0*i8*i7 - 8.0d0*sqr(i8) + 1610.0d0
 
      g(5) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 5.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) - 2.0d0*i4*i1 + 6.0d0*i4*i2 - 2.0d0*i4*i3 
     /       - 6.0d0*sqr(i4) - 4.0d0*i5*i1 + 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /       - 8.0d0*i5*i4 - 7.0d0*sqr(i5) + 4.0d0*i6*i1 - 4.0d0*i6*i2 
     /       + 6.0d0*i6*i3 + 4.0d0*i6*i5 - 7.0d0*sqr(i6) + 4.0d0*i7*i1 
     /       - 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 + 4.0d0*i7*i5 
     /       + 4.0d0*i7*i6 - 8.0d0*sqr(i7) - 2.0d0*i8*i1 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i6 + 2.0d0*i8*i7 - 4.0d0*sqr(i8) + 1180.0d0
 
      g(6) = 2.0d0*i2*i1 - 7.0d0*sqr(i1) - 7.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 2.0d0*i3*i2 - 6.0d0*sqr(i3) - 2.0d0*i4*i1 + 2.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 5.0d0*sqr(i4) - 2.0d0*i5*i1 - 4.0d0*i5*i3 
     /       + 2.0d0*i5*i4 - 5.0d0*sqr(i5) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /       + 4.0d0*i6*i3 + 2.0d0*i6*i4 + 6.0d0*i6*i5 - 9.0d0*sqr(i6) 
     /       + 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 - 4.0d0*i7*i5 
     /       + 8.0d0*i7*i6 - 6.0d0*sqr(i7) + 4.0d0*i8*i1 + 8.0d0*i8*i2
     /       + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 2.0d0*i8*i5 + 4.0d0*i8*i6 
     /       - 9.0d0*sqr(i8) + 930.0d0
 
      g(7) = (-9.0d0*sqr(i1)) - 4.0d0*i2*i1 - 8.0d0*sqr(i2) 
     /       + 4.0d0*i3*i1 + 2.0d0*i3*i2 - 7.0d0*sqr(i3) + 4.0d0*i4*i1 
     /       + 4.0d0*i4*i3 - 7.0d0*sqr(i4) - 2.0d0*i5*i1 - 12.0d0*i5*i2 
     /       - 4.0d0*i5*i3 - 8.0d0*sqr(i5) - 8.0d0*i6*i1 + 2.0d0*i6*i2 
     /       - 2.0d0*i6*i5 - 6.0d0*sqr(i6) - 4.0d0*i7*i1 - 6.0d0*i7*i2
     /       - 2.0d0*i7*i3 + 10.0d0*i7*i4 - 2.0d0*i7*i5 + 2.0d0*i7*i6 
     /       - 7.0d0*sqr(i7) - 2.0d0*i8*i1 + 2.0d0*i8*i2 + 2.0d0*i8*i3 
     /       + 2.0d0*i8*i4 - 6.0d0*i8*i6 - 2.0d0*i8*i7 - 6.0d0*sqr(i8)
     /       + 2790.0d0
 
      g(8) = 4.0d0*i2*i1 - 7.0d0*sqr(i1) - 8.0d0*sqr(i2) + 4.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) + 4.0d0*i4*i1 + 8.0d0*i4*i2 - 6.0d0*i4*i3 
     /       - 7.0d0*sqr(i4) - 2.0d0*i5*i2 + 2.0d0*i5*i4 - 5.0d0*sqr(i5)
     /       - 2.0d0*i6*i1 - 2.0d0*i6*i2 + 4.0d0*i6*i4 - 4.0d0*i6*i5 
     /       - 7.0d0*sqr(i6) - 2.0d0*i7*i1 + 8.0d0*i7*i2 - 2.0d0*i7*i3 
     /       - 2.0d0*i7*i4 + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       + 2.0d0*i8*i1 - 6.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i5 - 4.0d0*i8*i6 - 6.0d0*sqr(i8) + 910.0d0

  999 continue
      return
      end

      subroutine nvs20( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:19
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         9       1       8       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        17      12       0       5       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        70      54      16       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, x6, x7, x8, x9, 
     /        x10, x11, x12, x13, x14, x15, x16
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS20'
         pref  = '\cite{MINLPLib}'
         fex   = 0.23092217d+3
         ncont = 11
         nint  = 5
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 8
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      x6 = x(1)
      x7 = x(2)
      x8 = x(3)
      x9 = x(4)
      x10 = x(5)
      x11 = x(6)
      x12 = x(7)
      x13 = x(8)
      x14 = x(9)
      x15 = x(10)
      x16 = x(11)

      f = sqr(1.0d0 + sqr(i1) + i1) 
     /    + (1.0d0 + sqr(i1) + i1)*(1.0d0 + sqr(i4) + i4) 
     /    + (1.0d0 + sqr(i1) + i1)*(1.0d0 + sqr(x7) + x7) 
     /    + (1.0d0 + sqr(i1) + i1)*(1.0d0 + sqr(x8) + x8)
     /    + (1.0d0 + sqr(i1) + i1)*(1.0d0 + sqr(x16) + x16) 
     /    + sqr(1.0d0 + sqr(i2) + i2) 
     /    + (1.0d0 + sqr(i2) + i2)*(1.0d0 + sqr(i3) + i3) 
     /    + (1.0d0 + sqr(i2) + i2)*(1.0d0 + sqr(x7) + x7)
     /    + (1.0d0 + sqr(i2) + i2)*(1.0d0 + sqr(x10) + x10) 
     /    + sqr(1.0d0 + sqr(i3) + i3) 
     /    + (1.0d0 + sqr(i3) + i3)*(1.0d0 + sqr(x7) + x7) 
     /    + (1.0d0 + sqr(i3) + i3)*(1.0d0 + sqr(x9) + x9)
     /    + (1.0d0 + sqr(i3) + i3)*(1.0d0 + sqr(x10) + x10) 
     /    + (1.0d0 + sqr(i3) + i3)*(1.0d0 + sqr(x14) + x14) 
     /    + sqr(1.0d0 + sqr(i4) + i4) 
     /    + (1.0d0 + sqr(i4) + i4)*(1.0d0 + sqr(x7) + x7) 
     /    + (1.0d0 + sqr(i4) + i4)*(1.0d0 + sqr(x11) + x11) 
     /    + (1.0d0 + sqr(i4) + i4)*(1.0d0 + sqr(x15) + x15) 
     /    + sqr(1.0d0 + sqr(i5) + i5) 
      f = f
     /    + (1.0d0 + sqr(i5) + i5)*(1.0d0 + sqr(x6) + x6) 
     /    + (1.0d0 + sqr(i5) + i5)*(1.0d0 + sqr(x10) + x10) 
     /    + (1.0d0 + sqr(i5) + i5)*(1.0d0 + sqr(x12) + x12) 
     /    + (1.0d0 + sqr(i5) + i5)*(1.0d0 + sqr(x16) + x16) 
     /    + sqr(1.0d0 + sqr(x6) + x6) 
     /    + (1.0d0 + sqr(x6) + x6)*(1.0d0 + sqr(x8) + x8) 
     /    + (1.0d0 + sqr(x6) + x6)*(1.0d0 + sqr(x15) + x15) 
     /    + sqr(1.0d0 + sqr(x7) + x7) 
     /    + (1.0d0 + sqr(x7) + x7)*(1.0d0 + sqr(x11) + x11) 
     /    + (1.0d0 + sqr(x7) + x7)*(1.0d0 + sqr(x13) + x13) 
     /    + sqr(1.0d0 + sqr(x8) + x8) 
     /    + (1.0d0 + sqr(x8) + x8)*(1.0d0 + sqr(x10) + x10) 
     /    + (1.0d0 + sqr(x8) + x8)*(1.0d0 + sqr(x15) + x15) 
     /    + sqr(1.0d0 + sqr(x9) + x9) 
     /    + (1.0d0 + sqr(x9) + x9)*(1.0d0 + sqr(x12) + x12)
     /    + (1.0d0 + sqr(x9) + x9)*(1.0d0 + sqr(x16) + x16) 
     /    + sqr(1.0d0 + sqr(x10) + x10) 
     /    + (1.0d0 + sqr(x10) + x10)*(1.0d0 + sqr(x14) + x14) 
     /    + sqr(1.0d0 + sqr(x11) + x11) 
      f = f
     /    + (1.0d0 + sqr(x11) + x11)*(1.0d0 + sqr(x13) + x13) 
     /    + sqr(1.0d0 + sqr(x12) + x12) 
     /    + (1.0d0 + sqr(x12) + x12)*(1.0d0 + sqr(x14) + x14) 
     /    + sqr(1.0d0 + sqr(x13) + x13) 
     /    + (1.0d0 + sqr(x13) + x13)*(1.0d0 + sqr(x14) + x14) 
     /    + sqr(1.0d0 + sqr(x14) + x14) 
     /    + sqr(1.0d0 + sqr(x15) + x15) 
     /    + sqr(1.0d0 + sqr(x16) + x16)

      g(1) = 0.22d0*i1 + 0.2d0*i2 + 0.19d0*i3 + 0.25d0*i4 
     /       + 0.15d0*i5 + 0.11d0*x6 + 0.12d0*x7 + 0.13d0*x8 
     /       + x9 - 2.5d0
 
      g(2) = -1.46d0*i1 - 1.3d0*i3 + 1.82d0*i4 - 1.15d0*i5 
     /       + 0.8d0*x7 + x10 - 1.1d0
 
      g(3) = 1.29d0*i1 - 0.89d0*i2 - 1.16d0*i5 - 0.96d0*x6 
     /       - 0.49d0*x8 + x11 + 3.1d0
 
      g(4) = -1.1d0*i1 - 1.06d0*i2 + 0.95d0*i3 - 0.54d0*i4 
     /       - 1.78d0*x6 - 0.41d0*x7 + x12 + 3.5d0
 
      g(5) = -1.43d0*i4 + 1.51d0*i5 + 0.59d0*x6 - 0.33d0*x7 
     /       - 0.43d0*x8 + x13 - 1.3d0
 
      g(6) = -1.72d0*i2 - 0.33d0*i3 + 1.62d0*i5 + 1.24d0*x6
     /       + 0.21d0*x7 - 0.26d0*x8 + x14 - 2.1d0
 
      g(7) = 1.12d0*i1 + 0.31d0*i4 + 1.12d0*x7 - 0.36d0*x9 + x15 
     /       - 2.3d0
 
      g(8) = 0.45d0*i2 + 0.26d0*i3 - 1.1d0*i4 + 0.58d0*i5 - 1.03d0*x7
     /       + 0.1d0*x8 + x16 + 1.5d0

  999 continue
      return
      end

      subroutine nvs21( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:19
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       2       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         4       2       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         8       1       7       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS21'
         pref  = '\cite{MINLPLib}'
         fex   = -5.684783d0
         ncont = 1
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         xl(1) = 0.0d0
         x(1)  = 0.1d0
         xu(1) = 0.2d0
         xl(2) = 0.0d0
         x(2)  = 1.0d0
         xu(2) = 200.0d0
         xl(3) = 0.0d0
         x(3)  = 1.0d0
         xu(3) = 200.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      f = -0.00201d0*y(1)**4*y(2)*sqr(x(1))

      g(1) = -sqr(y(1))*y(2) + 675.0d0

      g(2) = -0.1d0*sqr(y(1))*sqr(x(1)) + 0.419d0

  999 continue
      return
      end

      subroutine nvs22( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:19
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*        10       5       5       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         9       5       0       4       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        31       7      24       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, x5, x6, x7, x8
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS22'
         pref  = '\cite{MINLPLib}'
         fex   = 6.05822d0
         ncont = 4
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 9
         me    = 4
         do i=1,ncont
            xl(i) = 1.0d-2
            x(i)  = 1.0d0
            xu(i) = 1.0d5
         enddo
         do i=ncont+1,n
            xl(i) = 1.0d0
            x(i)  = 2.0d0
            xu(i) = 200.0d0
         enddo
         xu(7) = 20.0d0
         xu(8) = 20.0d0
         goto 999       
      endif

      do i=1,nint
         y(i) = x(ncont+i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      x5 = x(1)
      x6 = x(2)
      x7 = x(3)
      x8 = x(4)

      f = 1.10471d0*i3**2*i4 + 0.04811d0*i1*i2*(14.0d0 + i4)  

      g(1) = -4243.28147100424d0/(i3*i4) + x5

      g(2) = -dsqrt(0.25d0*sqr(i4) + sqr(0.5d0*i1 + 0.5d0*i3)) + x7 

      g(3) = -0.707213578500707d0*(84000.0d0 + 3000.0d0*i4)*x7/
     /                   (i3*i4*(0.0833333333333333d0*sqr(i4) 
     /       + sqr(0.5d0*i1 + 0.5d0*i3))) + x6

      g(4) = -0.5d0*i4/x7 + x8 

      g(5) = -dsqrt(sqr(x5) + 2.0d0*x5*x6*x8 + sqr(x6)) 
     /       + 13600.0d0

      g(6) = -504000.0d0/(i2*sqr(i1)) + 30000.0d0

      g(7) = i2 - i3 

      g(8) = 0.0204744897959184d0*dsqrt(1.0d+13*i1*i2**3*i1*i2**3)
     /       *(1.0d0 - 0.0282346219657891d0*i1) - 6000.0d0

       g(9) = -2.1952d0/(i2*i1**3) + 0.25d0         

  999 continue
      return
      end

      subroutine nvs23( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:19
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*        10       1       9       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        10       1       0       9       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        91       1      90       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7, i8, i9
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS23'
         pref  = '\cite{MINLPLib}'
         fex   = -1125.2d0
         ncont = 0
         nint  = 9
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 9
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)
      i7 = y(7)
      i8 = y(8)
      i9 = y(9)

      f = 7.0d0*sqr(i1) + 6.0d0*sqr(i2) + 24.4d0*i1 - 0.2d0*i2 
     /    + 8.0d0*sqr(i3) - 6.0d0*i3*i1 + 4.0d0*i3*i2 + i3 
     /    + 6.0d0*sqr(i4) + 2.0d0*i4*i1 + 2.0d0*i4*i3 - 39.2d0*i4 
     /    + 7.0d0*sqr(i5) - 4.0d0*i5*i1 - 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /    - 118.4d0*i5 + 4.0d0*sqr(i6) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /    - 4.0d0*i6*i3 - 2.0d0*i6*i4 + 6.0d0*i6*i5 - 73*i6 
     /    + 6.0d0*sqr(i7) - 2.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3 
     /    + 4.0d0*i7*i5 + 4.0d0*i7*i6 - 110.8d0*i7 + 7.0d0*sqr(i8)
     /    - 4.0d0*i8*i1 - 2.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4 
     /    - 4.0d0*i8*i5 - 2.0d0*i8*i6 + 4.0d0*i8*i7 - 17.8d0*i8 
     /    + 8.0d0*sqr(i9) - 2.0d0*i9*i1 - 4.0d0*i9*i2 + 4.0d0*i9*i3 
     /    + 4.0d0*i9*i4 - 4.0d0*i9*i5 - 4.0d0*i9*i6 + 8.0d0*i9*i7 
     /    + 4.0d0*i9*i8 - 29.4d0*i9

      g(1) = (-9.0d0*sqr(i1)) - 10.0d0*i1*i2 - 8.0d0*sqr(i2) 
     /       - 5.0d0*sqr(i3) - 6.0d0*i3*i1 - 10.0d0*i3*i2 
     /       - 7.0d0*sqr(i4) 
     /       - 10.0d0*i4*i1 - 6.0d0*i4*i2 - 2.0d0*i4*i3 - 2.0d0*i5*i2 
     /       - 7.0d0*sqr(i5) - 6.0d0*i6*i1 - 2.0d0*i6*i2 - 2.0d0*i6*i4
     /       - 5.0d0*sqr(i6) + 6.0d0*i7*i1 + 2.0d0*i7*i2 + 4.0d0*i7*i3
     /       + 2.0d0*i7*i4 - 4.0d0*i7*i5 + 4.0d0*i7*i6 - 8.0d0*sqr(i7)
     /       - 2.0d0*i8*i1 - 8.0d0*i8*i2 - 2.0d0*i8*i3 + 6.0d0*i8*i5 
     /       - 2.0d0*i8*i7 - 6.0d0*sqr(i8) + 2.0d0*i9*i3 - 4.0d0*i9*i4
     /       + 8.0d0*i9*i5 + 4.0d0*i9*i6 - 6.0d0*i9*i8 - 6.0d0*sqr(i9)
     /       + 1850.0d0

      g(2) = (-6.0d0*sqr(i1)) - 8.0d0*i1*i2 - 6.0d0*sqr(i2) 
     /       - 4.0d0*sqr(i3) - 2.0d0*i3*i1 - 2.0d0*i3*i2 - 8.0d0*sqr(i4)
     /       + 2.0d0*i4*i1 + 10.0d0*i4*i2 - 2.0d0*i5*i1 - 6.0d0*i5*i2 
     /       + 6.0d0*i5*i4 + 7.0d0*sqr(i5) - 2.0d0*i6*i2 + 8.0d0*i6*i3 
     /       + 2.0d0*i6*i4 - 4.0d0*i6*i5 - 8.0d0*sqr(i6) - 6.0d0*i7*i1 
     /       - 10.0d0*i7*i2 - 2.0d0*i7*i3 + 10.0d0*i7*i4 - 10.0d0*i7*i5 
     /       - 8.0d0*sqr(i7) - 2.0d0*i8*i1 - 4.0d0*i8*i2 - 2.0d0*i8*i3 
     /       - 8.0d0*i8*i5 - 8.0d0*i8*i7 - 5.0d0*sqr(i8) - 2.0d0*i9*i1 
     /       - 2.0d0*i9*i2 + 4.0d0*i9*i6 + 2.0d0*i9*i7 - 6.0d0*sqr(i9) 
     /       + 3170.0d0

      g(3) = (-9.0d0*sqr(i1)) - 6.0d0*sqr(i2) - 8.0d0*sqr(i3) 
     /       + 2.0d0*i2*i1 + 2.0d0*i3*i2 - 6.0d0*sqr(i4) + 4.0d0*i4*i1
     /       + 4.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 - 2.0d0*i5*i2 
     /       + 4.0d0*i5*i4 + 6.0d0*sqr(i5) + 2.0d0*i6*i1 + 4.0d0*i6*i2 
     /       - 6.0d0*i6*i4 - 2.0d0*i6*i5 - 5.0d0*sqr(i6) + 2.0d0*i7*i2 
     /       - 4.0d0*i7*i3 - 6.0d0*i7*i5 - 4.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       - 2.0d0*i8*i1 + 4.0d0*i8*i3 + 2.0d0*i8*i4 - 4.0d0*sqr(i8) 
     /       + 10.0d0*i9*i1 + 6.0d0*i9*i2 - 4.0d0*i9*i3 - 10.0d0*i9*i4 
     /       + 8.0d0*i9*i5 - 6.0d0*i9*i6 - 2.0d0*i9*i7 - 8.0d0*sqr(i9) 
     /       + 1770.0d0

      g(4) = (-8.0d0*sqr(i1)) - 4.0d0*sqr(i2) - 9.0d0*sqr(i3) 
     /       - 7.0d0*sqr(i4) - 2.0d0*i2*i1 - 2.0d0*i3*i1 - 4.0d0*i3*i2 
     /       + 6.0d0*i4*i1 + 2.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 
     /       - 4.0d0*i5*i2 - 2.0d0*i5*i3 + 6.0d0*i5*i4 + 6.0d0*sqr(i5) 
     /       - 10.0d0*i6*i1 - 10.0d0*i6*i3 + 4.0d0*i6*i4 - 2.0d0*i6*i5 
     /       - 7.0d0*sqr(i6) + 6.0d0*i7*i1 - 2.0d0*i7*i2 - 2.0d0*i7*i3 
     /       + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 6.0d0*sqr(i7) + 4.0d0*i8*i1 
     /       - 4.0d0*i8*i2 + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 4.0d0*i8*i5 
     /       + 8.0d0*i8*i6 + 6.0d0*i8*i6 - 8.0d0*sqr(i8) - 4.0d0*i9*i1 
     /       + 4.0d0*i9*i2 + 6.0d0*i9*i3 - 2.0d0*i9*i4 + 2.0d0*i9*i6 
     /       + 8.0d0*i9*i7 - 4.0d0*i9*i8 - 10.0d0*sqr(i9) + 1460.0d0

      g(5) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 5.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) - 2.0d0*i4*i1 + 6.0d0*i4*i2 - 2.0d0*i4*i3
     /       - 6.0d0*sqr(i4) - 4.0d0*i5*i1 + 2.0d0*i5*i2 - 6.0d0*i5*i3
     /       - 8.0d0*i5*i4 - 7.0d0*sqr(i5) + 4.0d0*i6*i1 - 4.0d0*i6*i2
     /       + 6.0d0*i6*i3 + 4.0d0*i6*i5 - 7.0d0*sqr(i6) + 4.0d0*i7*i1
     /       - 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 + 4.0d0*i7*i5 
     /       + 4.0d0*i7*i6 - 8.0d0*sqr(i7) - 2.0d0*i8*i1 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i6 + 2.0d0*i8*i7 - 4.0d0*sqr(i8) - 2.0d0*i9*i2
     /       + 4.0d0*i9*i3 + 4.0d0*i9*i4 - 2.0d0*i9*i5 + 2.0d0*i9*i6 
     /       + 6.0d0*i9*i7 - 6.0d0*i9*i8 - 7.0d0*sqr(i9) + 1140.0d0

      g(6) = 2.0d0*i2*i1 - 7.0d0*sqr(i1) - 7.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 2.0d0*i3*i2 - 6.0d0*sqr(i3) - 2.0d0*i4*i1 + 2.0d0*i4*i2
     /       - 2.0d0*i4*i3 - 5.0d0*sqr(i4) - 2.0d0*i5*i1 - 4.0d0*i5*i3
     /       + 2.0d0*i5*i4 - 5.0d0*sqr(i5) + 2.0d0*i6*i1 - 4.0d0*i6*i2
     /       + 4.0d0*i6*i3 + 2.0d0*i6*i4 + 6.0d0*i6*i5 - 9.0d0*sqr(i6)
     /       + 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 - 4.0d0*i7*i5 
     /       + 8.0d0*i7*i6 - 5.0d0*sqr(i7) + 4.0d0*i8*i1 + 8.0d0*i8*i2
     /       + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 2.0d0*i8*i5 + 4.0d0*i8*i6 
     /       - 9.0d0*sqr(i8) - 4.0d0*i9*i1 + 2.0d0*i9*i4 + 6.0d0*i9*i5 
     /       - 4.0d0*i9*i6 - 2.0d0*i9*i7 + 2.0d0*i9*i8 - 6.0d0*sqr(i9) 
     /       + 940.0d0

      g(7) = (-9.0d0*sqr(i1)) - 4.0d0*i2*i1 - 8.0d0*sqr(i2) +4.0d0*i3*i1
     /       + 2.0d0*i3*i2 - 7.0d0*sqr(i3) + 4.0d0*i4*i1 + 4.0d0*i4*i3 
     /       - 7.0d0*sqr(i4) - 2.0d0*i5*i1 - 12.0d0*i5*i2 - 4.0d0*i5*i3 
     /       - 8.0d0*sqr(i5) - 8.0d0*i6*i1 + 2.0d0*i6*i2 - 2.0d0*i6*i5 
     /       - 6.0d0*sqr(i6) - 4.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3 
     /       + 10.0d0*i7*i4 - 2.0d0*i7*i5 + 2.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       - 2.0d0*i8*i1 + 2.0d0*i8*i2 + 2.0d0*i8*i3 + 2.0d0*i8*i4
     /       - 6.0d0*i8*i6 - 2.0d0*i8*i7 - 6.0d0*sqr(i8) + 4.0d0*i9*i1 
     /       + 2.0d0*i9*i2 + 4.0d0*i9*i3 + 4.0d0*i9*i4 + 2.0d0*i9*i5 
     /       - 2.0d0*i9*i6 - 8.0d0*sqr(i9) + 2720.0d0

      g(8) = 4.0d0*i2*i1 - 7.0d0*sqr(i1) - 8.0d0*sqr(i2) + 4.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) + 4.0d0*i4*i1 + 8.0d0*i4*i2 - 6.0d0*i4*i3
     /       - 7.0d0*sqr(i4) - 2.0d0*i5*i2 + 2.0d0*i5*i4 - 5.0d0*sqr(i5)
     /       - 2.0d0*i6*i1 - 2.0d0*i6*i2 + 4.0d0*i6*i4 - 4.0d0*i6*i5 
     /       - 7.0d0*sqr(i6) - 2.0d0*i7*i1 + 8.0d0*i7*i2 - 2.0d0*i7*i3 
     /       - 2.0d0*i7*i4 + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       + 2.0d0*i8*i1 - 6.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i5 - 4.0d0*i8*i6 - 6.0d0*sqr(i8) + 4.0d0*i9*i1
     /       - 6.0d0*i9*i2 + 2.0d0*i9*i3 - 2.0d0*i9*i4 + 2.0d0*i9*i5 
     /       + 6.0d0*i9*i6 + 2.0d0*i9*i7 - 4.0d0*i9*i8 - 6.0d0*sqr(i9) 
     /       + 870.0d0

      g(9) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 7.0d0*sqr(i2) + 8.0d0*i3*i1 
     /       - 4.0d0*i3*i2 - 9.0d0*sqr(i3) - 2.0d0*i4*i1 - 4.0d0*i4*i2
     /       - 2.0d0*i4*i3 - 6.0d0*sqr(i4) + 4.0d0*i5*i1 + 2.0d0*i5*i2
     /       + 4.0d0*i5*i3 + 6.0d0*i5*i4 - 6.0d0*sqr(i5) + 4.0d0*i6*i3
     /       - 6.0d0*i6*i4 - 7.0d0*sqr(i6) - 2.0d0*i7*i2 - 4.0d0*i7*i3
     /       + 4.0d0*i7*i5 + 8.0d0*i7*i6 - 7.0d0*sqr(i7) + 2.0d0*i8*i2
     /       - 4.0d0*i8*i3 + 2.0d0*i8*i4 + 2.0d0*i8*i5 + 6.0d0*i8*i7
     /       - 7.0d0*sqr(i8) + 4.0d0*i9*i1 + 2.0d0*i9*i2 - 10.0d0*i9*i3
     /       + 2.0d0*i9*i5 + 2.0d0*i9*i6 - 8.0d0*i9*i8 - 6.0d0*sqr(i9)
     /       + 670.0d0

  999 continue
      return
      end

      subroutine nvs24( mode,     m,     me,  mmax, ncont,  
     /                  nbin,  nint,   nmax,     x,    xl,
     /                    xu,     f,      g,  pnam,  pref,
     /                   fex )    

*  MINLP written by GAMS Convert at 07/24/02 13:01:20
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*        11       1      10       0       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        11       1       0      10       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       111       1     110       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr, i1, i2, i3, i4, i5, i6, i7, i8, i9,
     /        i10
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'NVS24'
         pref  = '\cite{MINLPLib}'
         fex   = -1033.2d0
         ncont = 0
         nint  = 10
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 10
         me    = 0
         do i=1,n
            xl(i) = 0.0d0
            x(i)  = 100.0d0
            xu(i) = 200.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      i1  = y(1)
      i2  = y(2)
      i3  = y(3)
      i4  = y(4)
      i5  = y(5)
      i6  = y(6)
      i7  = y(7)
      i8  = y(8)
      i9  = y(9)
      i10 = y(10)

      f = 7.0d0*sqr(i1) + 6.0d0*sqr(i2) + 37.6d0*i1 + 19.6d0*i2 
     /    + 8.0d0*sqr(i3) - 6.0d0*i3*i1 + 4.0d0*i3*i2 - 5.6d0*i3 
     /    + 6.0d0*sqr(i4) + 2.0d0*i4*i1 + 2.0d0*i4*i3 - 26*i4 
     /    + 7.0d0*sqr(i5) - 4.0d0*i5*i1 - 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /    - 125*i5 + 4.0d0*sqr(i6) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /    - 4.0d0*i6*i3 - 2.0d0*i6*i4 + 6.0d0*i6*i5 - 79.6d0*i6 
     /    + 6.0d0*sqr(i7) - 2.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3 
     /    + 4.0d0*i7*i5 + 4.0d0*i7*i6 - 104.2d0*i7 + 7.0d0*sqr(i8) 
     /    - 4.0d0*i8*i1 - 2.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4 
     /    - 4.0d0*i8*i5 - 2.0d0*i8*i6 + 4.0d0*i8*i7 - 4.6d0*i8 
     /    + 8.0d0*sqr(i9) - 2.0d0*i9*i1 - 4.0d0*i9*i2 + 4.0d0*i9*i3 
     /    + 4.0d0*i9*i4 - 4.0d0*i9*i5 - 4.0d0*i9*i6 + 8.0d0*i9*i7 
     /    + 4.0d0*i9*i8 - 22.8d0*i9 + 6.0d0*sqr(i10) - 4.0d0*i10*i1 
     /    - 6.0d0*i10*i2 + 2.0d0*i10*i3 - 4.0d0*i10*i4 + 2.0d0*i10*i5 
     /    + 2.0d0*i10*i6 - 2.0d0*i10*i7 - 4.0d0*i10*i8 - 2.0d0*i10*i9 
     /    + 9.0d0*i10

      g(1) = (-9.0d0*sqr(i1)) - 10.0d0*i1*i2 - 8.0d0*sqr(i2)
     /       - 5.0d0*sqr(i3) - 6.0d0*i3*i1 - 10.0d0*i3*i2 
     /       - 7.0d0*sqr(i4) - 10.0d0*i4*i1 
     /       - 6.0d0*i4*i2 - 2.0d0*i4*i3 - 2.0d0*i5*i2 - 7.0d0*sqr(i5) 
     /       - 6.0d0*i6*i1 - 2.0d0*i6*i2 - 2.0d0*i6*i4 - 5.0d0*sqr(i6) 
     /       + 6.0d0*i7*i1 + 2.0d0*i7*i2 + 4.0d0*i7*i3 + 2.0d0*i7*i4 
     /       - 4.0d0*i7*i5 + 4.0d0*i7*i6 - 8.0d0*sqr(i7) - 2.0d0*i8*i1
     /       - 6.0d0*i8*i2 - 2.0d0*i8*i3 + 6.0d0*i8*i5 - 2.0d0*i8*i7 
     /       - 6.0d0*sqr(i8) + 2.0d0*i9*i3 - 4.0d0*i9*i4 + 8.0d0*i9*i5 
     /       + 4.0d0*i9*i6 - 6.0d0*i9*i8 - 6.0d0*sqr(i9) + 2.0d0*i10*i1 
     /       + 2.0d0*i10*i2 - 2.0d0*i10*i4 + 2.0d0*i10*i5 - 2.0d0*i10*i6
     /       - 2.0d0*i10*i8 - 6.0d0*i10*i9 - 8.0d0*sqr(i10) + 1930.0d0
    
      g(2) = (-6.0d0*sqr(i1)) - 8.0d0*i1*i2 - 6.0d0*sqr(i2) 
     /       - 2.0d0*i3*i1 - 2.0d0*i3*i2 - 8.0d0*sqr(i4) + 2.0d0*i4*i1 
     /       + 10.0d0*i4*i2 - 2.0d0*i5*i1 - 6.0d0*i5*i2 + 6.0d0*i5*i4 
     /       + 7.0d0*sqr(i5) - 2.0d0*i6*i2 + 8.0d0*i6*i3 + 2.0d0*i6*i4 
     /       - 4.0d0*i6*i5 - 8.0d0*sqr(i6) - 6.0d0*i7*i1 
     /       - 10.0d0*i7*i2 - 4.0d0*sqr(i3) - 2.0d0*i7*i3 + 10.0d0*i7*i4
     /       - 10.0d0*i7*i5 - 8.0d0*sqr(i7) 
     /       - 2.0d0*i8*i1 - 4.0d0*i8*i2 - 2.0d0*i8*i3 - 8.0d0*i8*i5 
     /       - 8.0d0*i8*i7 - 5.0d0*sqr(i8) - 2.0d0*i9*i1 - 2.0d0*i9*i2 
     /       + 4.0d0*i9*i6 + 2.0d0*i9*i7 - 6.0d0*sqr(i9) + 4.0d0*i10*i1 
     /       - 2.0d0*i10*i3 + 4.0d0*i10*i4 + 6.0d0*i10*i6 - 2.0d0*i10*i7
     /       - 2.0d0*i10*i8 - 6.0d0*sqr(i10) + 3140.0d0
    
      g(3) = (-9.0d0*sqr(i1)) - 6.0d0*sqr(i2) - 8.0d0*sqr(i3) 
     /       + 2.0d0*i3*i2 - 6.0d0*sqr(i4) + 4.0d0*i4*i1 + 4.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 6.0d0*i5*i1 - 2.0d0*i5*i2 + 4.0d0*i5*i4 
     /       + 6.0d0*sqr(i5) + 2.0d0*i6*i1 + 4.0d0*i6*i2 - 6.0d0*i6*i4 
     /       - 2.0d0*i6*i5 - 5.0d0*sqr(i6) + 2.0d0*i7*i2 - 4.0d0*i7*i3
     /       - 6.0d0*i7*i5 - 4.0d0*i7*i6 - 7.0d0*sqr(i7) - 2.0d0*i8*i1 
     /       + 4.0d0*i8*i3 + 2.0d0*i8*i4 - 4.0d0*sqr(i8) + 2.0d0*i2*i1 
     /       + 6.0d0*i9*i2 - 4.0d0*i9*i3 - 10.0d0*i9*i4 + 8.0d0*i9*i5 
     /       - 6.0d0*i9*i6 - 2.0d0*i9*i7 - 8.0d0*sqr(i9) + 10.0d0*i9*i1 
     /       - 4.0d0*i10*i2 + 2.0d0*i10*i3 + 4.0d0*i10*i4 + 6.0d0*i10*i5
     /       + 2.0d0*i10*i7 - 2.0d0*i10*i8 + 2.0d0*i10*i9 
     /       - 7.0d0*sqr(i10) + 4.0d0*i10*i6 + 1600.0d0
    
      g(4) = (-8.0d0*sqr(i1)) - 4.0d0*sqr(i2) - 9.0d0*sqr(i3) 
     /      - 7.0d0*sqr(i4) - 2.0d0*i2*i1 - 2.0d0*i3*i1 - 4.0d0*i3*i2 
     /      + 6.0d0*i4*i1 + 2.0d0*i4*i2 - 2.0d0*i4*i3 - 6.0d0*i5*i1 
     /      - 4.0d0*i5*i2 - 2.0d0*i5*i3 + 6.0d0*i5*i4 + 6.0d0*sqr(i5) 
     /      - 10.0d0*i6*i1 - 10.0d0*i6*i3 + 4.0d0*i6*i4 - 2.0d0*i6*i5 
     /      - 7.0d0*sqr(i6) + 6.0d0*i7*i1 - 2.0d0*i7*i2 - 2.0d0*i7*i3 
     /      + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 6.0d0*sqr(i7) + 4.0d0*i8*i1 
     /      - 4.0d0*i8*i2 + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 4.0d0*i8*i5 
     /      + 8.0d0*i8*i6 + 6.0d0*i8*i6 - 8.0d0*sqr(i8) - 4.0d0*i9*i1 
     /      + 4.0d0*i9*i2 + 6.0d0*i9*i3 - 2.0d0*i9*i4 + 2.0d0*i9*i6 
     /      + 8.0d0*i9*i7 - 4.0d0*i9*i8 - 10.0d0*sqr(i9) + 8.0d0*i10*i1 
     /      + 4.0d0*i10*i2 + 2.0d0*i10*i3 + 2.0d0*i10*i4 + 4.0d0*i10*i6 
     /      - 6.0d0*sqr(i10) + 1260.0d0
    
      g(5) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 5.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) - 2.0d0*i4*i1 + 6.0d0*i4*i2 - 2.0d0*i4*i3 
     /       - 6.0d0*sqr(i4) - 4.0d0*i5*i1 + 2.0d0*i5*i2 - 6.0d0*i5*i3 
     /       - 8.0d0*i5*i4 - 7.0d0*sqr(i5) + 4.0d0*i6*i1 - 4.0d0*i6*i2 
     /       + 6.0d0*i6*i3 + 4.0d0*i6*i5 - 7.0d0*sqr(i6) + 4.0d0*i7*i1 
     /       - 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 + 4.0d0*i7*i5 
     /       + 4.0d0*i7*i6 - 8.0d0*sqr(i7) - 2.0d0*i8*i1 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i6 + 2.0d0*i8*i7 - 4.0d0*sqr(i8) - 2.0d0*i9*i2 
     /       + 4.0d0*i9*i3 + 4.0d0*i9*i4 - 2.0d0*i9*i5 + 2.0d0*i9*i6 
     /       + 6.0d0*i9*i7 - 6.0d0*i9*i8 - 7.0d0*sqr(i9) - 6.0d0*i10*i3 
     /       - 2.0d0*i10*i4 - 4.0d0*i10*i5 - 4.0d0*i10*i9 
     /       - 8.0d0*sqr(i10) + 2.0d0*i10*i8 + 1430.0d0
    
      g(6) = 2.0d0*i2*i1 - 7.0d0*sqr(i1) - 7.0d0*sqr(i2) - 6.0d0*i3*i1 
     /       - 2.0d0*i3*i2 - 6.0d0*sqr(i3) - 2.0d0*i4*i1 + 2.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 5.0d0*sqr(i4) - 2.0d0*i5*i1 - 4.0d0*i5*i3 
     /       + 2.0d0*i5*i4 - 5.0d0*sqr(i5) + 2.0d0*i6*i1 - 4.0d0*i6*i2 
     /       + 4.0d0*i6*i3 + 2.0d0*i6*i4 + 6.0d0*i6*i5 - 9.0d0*sqr(i6) 
     /       + 4.0d0*i7*i2 - 4.0d0*i7*i3 + 4.0d0*i7*i4 - 4.0d0*i7*i5 
     /       + 8.0d0*i7*i6 - 6.0d0*sqr(i7) + 4.0d0*i8*i1 + 8.0d0*i8*i2
     /       + 2.0d0*i8*i3 - 4.0d0*i8*i4 - 2.0d0*i8*i5 + 4.0d0*i8*i6 
     /       - 9.0d0*sqr(i8) - 4.0d0*i9*i1 + 2.0d0*i9*i4 + 6.0d0*i9*i5 
     /       - 4.0d0*i9*i6 - 2.0d0*i9*i7 + 2.0d0*i9*i8 - 6.0d0*sqr(i9) 
     /       + 2.0d0*i10*i1 - 2.0d0*i10*i5 - 4.0d0*i10*i6 + 2.0d0*i10*i7
     /       + 2.0d0*i10*i8 + 6.0d0*i10*i9 - 5.0d0*sqr(i10) + 1020.0d0
    
      g(7) = (-9.0d0*sqr(i1)) - 4.0d0*i2*i1 - 8.0d0*sqr(i2)       
     /       + 2.0d0*i3*i2 - 7.0d0*sqr(i3) + 4.0d0*i4*i1 + 4.0d0*i4*i3 
     /       - 7.0d0*sqr(i4) - 2.0d0*i5*i1 - 12.0d0*i5*i2 - 4.0d0*i5*i3 
     /       - 8.0d0*sqr(i5) - 8.0d0*i6*i1 + 2.0d0*i6*i2 - 2.0d0*i6*i5 
     /       - 6.0d0*sqr(i6) - 4.0d0*i7*i1 - 6.0d0*i7*i2 - 2.0d0*i7*i3 
     /       + 10.0d0*i7*i4 - 2.0d0*i7*i5 + 2.0d0*i7*i6 + 4.0d0*i3*i1 
     /       - 2.0d0*i8*i1 + 2.0d0*i8*i2 + 2.0d0*i8*i3 + 2.0d0*i8*i4 
     /       - 6.0d0*i8*i6 - 2.0d0*i8*i7 - 6.0d0*sqr(i8) + 4.0d0*i9*i1 
     /       + 2.0d0*i9*i2 + 4.0d0*i9*i3 + 4.0d0*i9*i4 + 2.0d0*i9*i5 
     /       - 2.0d0*i9*i6 - 9.0d0*sqr(i9) + 6.0d0*i10*i1 - 6.0d0*i10*i3
     /       + 10.0d0*i10*i4 + 6.0d0*i10*i6 - 8.0d0*i10*i7 
     /       - 4.0d0*i10*i9 - 8.0d0*sqr(i10) + 2860.0d0 - 7.0d0*sqr(i7) 
    
      g(8) = 4.0d0*i2*i1 - 7.0d0*sqr(i1) - 8.0d0*sqr(i2) + 4.0d0*i3*i1 
     /       - 8.0d0*sqr(i3) + 4.0d0*i4*i1 + 8.0d0*i4*i2 - 6.0d0*i4*i3 
     /       - 7.0d0*sqr(i4) - 2.0d0*i5*i2 + 2.0d0*i5*i4 - 5.0d0*sqr(i5)
     /        - 2.0d0*i6*i1 - 2.0d0*i6*i2 + 4.0d0*i6*i4 - 4.0d0*i6*i5 
     /       - 7.0d0*sqr(i6) - 2.0d0*i7*i1 + 8.0d0*i7*i2 - 2.0d0*i7*i3 
     /       - 2.0d0*i7*i4 + 6.0d0*i7*i5 + 2.0d0*i7*i6 - 7.0d0*sqr(i7) 
     /       + 2.0d0*i8*i1 - 6.0d0*i8*i2 + 6.0d0*i8*i3 + 4.0d0*i8*i4
     /       + 2.0d0*i8*i5 - 4.0d0*i8*i6 - 6.0d0*sqr(i8) + 4.0d0*i9*i1 
     /       - 6.0d0*i9*i2 + 2.0d0*i9*i3 - 2.0d0*i9*i4 + 2.0d0*i9*i5 
     /       + 6.0d0*i9*i6 + 2.0d0*i9*i7 - 4.0d0*i9*i8 - 6.0d0*sqr(i9) 
     /       - 2.0d0*i10*i1 - 2.0d0*i10*i2 - 4.0d0*i10*i3 + 4.0d0*i10*i5
     /       + 4.0d0*i10*i6 + 2.0d0*i10*i8 - 4.0d0*i10*i9
     /       - 6.0d0*sqr(i10) + 880.0d0
    
      g(9) = 2.0d0*i2*i1 - 4.0d0*sqr(i1) - 7.0d0*sqr(i2) + 8.0d0*i3*i1 
     /       - 4.0d0*i3*i2 - 9.0d0*sqr(i3) - 2.0d0*i4*i1 - 4.0d0*i4*i2 
     /       - 2.0d0*i4*i3 - 6.0d0*sqr(i4) + 4.0d0*i5*i1 + 2.0d0*i5*i2 
     /       + 4.0d0*i5*i3 + 6.0d0*i5*i4 - 6.0d0*sqr(i5) + 4.0d0*i6*i3 
     /       - 6.0d0*i6*i4 - 7.0d0*sqr(i6) - 2.0d0*i7*i2 - 4.0d0*i7*i3 
     /       + 4.0d0*i7*i5 + 8.0d0*i7*i6 - 7.0d0*sqr(i7) + 2.0d0*i8*i2 
     /       - 4.0d0*i8*i3 + 2.0d0*i8*i4 + 2.0d0*i8*i5 + 6.0d0*i8*i7
     /       - 7.0d0*sqr(i8) + 4.0d0*i9*i1 + 2.0d0*i9*i2 - 10.0d0*i9*i3 
     /       + 2.0d0*i9*i5 + 2.0d0*i9*i6 - 8.0d0*i9*i8 - 6.0d0*sqr(i9) 
     /       + 2.0d0*i10*i1 + 2.0d0*i10*i2 + 4.0d0*i10*i3 + 8.0d0*i10*i4
     /       - 4.0d0*i10*i5 - 2.0d0*i10*i6 + 2.0d0*i10*i7 - 2.0d0*i10*i8
     /       + 2.0d0*i10*i9 - 8.0d0*sqr(i10) + 700.0d0
    
      g(10) = 6.0d0*i2*i1 - 7.0d0*sqr(i1) - 6.0d0*sqr(i2) - 10.0d0*i3*i1
     /        + 6.0d0*i3*i2 - 8.0d0*sqr(i3) + 4.0d0*i4*i1 + 2.0d0*i4*i2 
     /        + 2.0d0*i4*i3 - 8.0d0*sqr(i4) - 2.0d0*i5*i1 + 2.0d0*i5*i2 
     /        + 8.0d0*i5*i4 - 4.0d0*sqr(i5) + 4.0d0*i6*i1 + 2.0d0*i6*i3 
     /        - 4.0d0*i6*i4 + 2.0d0*i6*i5 - 2.0d0*sqr(i6) - 2.0d0*i7*i1 
     /        + 2.0d0*i7*i2 - 4.0d0*i7*i3 + 2.0d0*i7*i4 + 2.0d0*i7*i5 
     /        + 2.0d0*i7*i6 - 6.0d0*sqr(i7) - 2.0d0*i8*i1 + 2.0d0*i8*i2 
     /        - 6.0d0*i8*i3 + 6.0d0*i8*i4 - 2.0d0*i8*i5 + 2.0d0*i8*i6 
     /        - 4.0d0*i8*i7 - 5.0d0*sqr(i8) + 4.0d0*i9*i1 - 4.0d0*i9*i2 
     /        - 10.0d0*i9*i4 + 6.0d0*i9*i5 - 2.0d0*i9*i6 + 2.0d0*i9*i7 
     /        + 4.0d0*i9*i8 - 6.0d0*sqr(i9) + 2.0d0*i10*i2 
     /        - 4.0d0*i10*i3 + 2.0d0*i10*i4 - 2.0d0*i10*i5 
     /        + 2.0d0*i10*i6 + 4.0d0*i10*i7 
     /        - 6.0d0*i10*i8 + 2.0d0*i10*i9 - 7.0d0*sqr(i10) + 360.0d0

  999 continue
      return
      end

      subroutine oaer( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:40:26
*  
*  Equation counts
*     Total       E       G       L       N       X
*         8       4       0       4       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        10       7       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        26      24       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, x4, x5, x6, b7, b8, b9
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'OAER'
         pref  = '\cite{MINLPLib}'
         fex   = -1.923099d0    
         ncont = 6
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 7
         me    = 3
         do i=1,ncont
            xl(i) = 0.0d0
            x(i)  = 5.0d0
            xu(i) = 10.0D0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo
 
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)        
      b7 = y(1)
      b8 = y(2)
      b9 = y(3)  

      f = 1.8d0*x1 + 1.8d0*x2 + 7.0d0*x3 + x4 + 1.2d0*x5 - 11.0d0*x6
     /       + 3.5d0*b7 + b8 + 1.5d0*b9

      g(1) = -dlog(1.0d0 + x1) + x4

      g(2) = -1.2d0*dlog(1.0d0 + x2) + x5

      g(3) = -0.9d0*x3 - 0.9d0*x4 - 0.9d0*x5 + x6 

      g(4) = -(x6 - b7)

      g(5) = -(x4 - 1.111111d0*b8)

      g(6) = -(x5 - 1.111111d0*b9)

      g(7) = -(b8 + b9) + 1.0d0

  999 continue
      return
      end

      subroutine optprloc( mode,     m,     me,  mmax, ncont,  
     /                     nbin,  nint,   nmax,     x,    xl,
     /                       xu,     f,      g,  pnam,  pref,
     /                      fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), b(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), sqr,
     /         x1,  x2,  x3,  x4,  x5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30
      character*30 pnam, pref

*  MINLP written bb GAMS Convert at 04/17/01 16:35:06
*  
*  Equation counts
*      Total        E        G        L        N        X        C
*         31        1       28        2        0        0        0
*  
*  Variable counts
*                   x        b        i      s1s      s2s       sc       si
*      Total     cont   binarb  integer     sos1     sos2    scont     sint
*         31        6       25        0        0        0        0        0
*  FX      0        0        0        0        0        0        0        0
*  
*  Nonzero counts
*      Total    const       NL      DLL
*        201       74      127        0
*
*  Source: 
*  Duran, M A, and Grossmann, I E, An Outer-Approximation Algorithm 
*  for a Class of Mixed-Integer Nonlinear Programs. Mathematical 
*  Programming 36 (1986), 307-339

      if (mode.eq.0) then
         pnam  = 'OPTPRLOC'
         pref  = '\cite{DG}'
         fex   = -8.0641d0
         ncont = 5
         nint  = 0
         nbin  = 25
         n     = ncont + nbin + nint
         m     = 30
         me    = 0
         xl(1) = 2.0d0
         x(1)  = 2.0d0
         xu(1) = 4.5d0
         xl(2) = 0.0d0
         x(2)  = 0.0d0
         xu(2) = 8.0d0
         xl(3) = 3.0d0
         x(3)  = 3.0d0
         xu(3) = 9.0d0
         xl(4) = 0.0d0
         x(4)  = 0.0d0
         xu(4) = 5.0d0
         xl(5) = 4.0d0
         x(5)  = 4.0d0
         xu(5) = 10.d0
         do i=ncont+1,n
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      x1  = x(1)
      x2  = x(2)
      x3  = x(3)
      x4  = x(4)
      x5  = x(5)
      b6  = x(6)
      b7  = x(7)
      b8  = x(8)
      b9  = x(9)
      b10 = x(10)
      b11 = x(11)
      b12 = x(12)
      b13 = x(13)
      b14 = x(14)
      b15 = x(15)
      b16 = x(16)
      b17 = x(17)
      b18 = x(18)
      b19 = x(19)
      b20 = x(20)
      b21 = x(21)
      b22 = x(22)
      b23 = x(23)
      b24 = x(24)
      b25 = x(25)
      b26 = x(26)
      b27 = x(27)
      b28 = x(28)
      b29 = x(29)
      b30 = x(30)

      f = -(0.6d0*sqr(x1) + 0.1d0*sqr(x4)) + 0.9d0*x2 + 0.5d0*x3 - x5 
     /    + b6 + 0.2d0*b7 + b8 + 0.2d0*b9 + 0.9d0*b10 + 0.9d0*b11 
     /    + 0.1d0*b12 + 0.8d0*b13 + b14 + 0.4d0*b15 + b16
     /    + 0.3d0*b17 + 0.1d0*b18 + 0.3d0*b19 + 0.5d0*b20 + 0.9d0*b21
     /    + 0.8d0*b22 + 0.1d0*b23 + 0.9d0*b24 + b25 + b26 + b27 
     /    + 0.2d0*b28 + 0.7d0*b29 + 0.7d0*b30 
      f = -f
      
      g(1) = -(9.57d0*sqr((-2.26d0) + x1) + 2.74d0*sqr((-5.15d0) + x2) 
     /       + 9.75d0*sqr((-4.03d0) + x3) + 3.96d0*sqr((-1.74d0) + x4) 
     /       + 8.67d0*sqr((-4.74d0) + x5)) - 1000.0d0*b6 + 1077.83985d0

      g(2) = -(8.38d0*sqr((-5.51d0) + x1) + 3.93d0*sqr((-9.01d0) + x2) 
     /       + 5.18d0*sqr((-3.84d0) + x3) + 5.2d0*sqr((-1.47d0) + x4) 
     /       + 7.82d0*sqr((-9.92d0) + x5)) - 1000.0d0*b7 + 1175.971d0
      
      g(3) = -(9.81d0*sqr((-4.06d0) + x1) + 0.04d0*sqr((-1.8d0) + x2)
     /       + 4.21d0*sqr((-0.71d0) + x3) + 7.38d0*sqr((-9.09d0) + x4) 
     /       + 4.11d0*sqr((-8.13d0) + x5)) - 1000d0*b8 + 1201.8226d0

      g(4) = -(7.41d0*sqr((-6.3d0) + x1) + 6.08d0*sqr((-0.11d0) + x2) 
     /       + 5.46d0*sqr((-4.08d0) + x3) + 4.86d0*sqr((-7.29d0) + x4) 
     /       + 1.48d0*sqr((-4.24d0) + x5)) - 1000.0d0*b9 + 1143.9533d0

      g(5) = -(9.96d0*sqr((-2.81d0) + x1) + 9.13d0*sqr((-1.65) + x2) 
     /       + 2.95d0*sqr((-8.08d0) + x3) + 8.25d0*sqr((-3.99) + x4) 
     /       + 3.58d0*sqr((-3.51d0) + x5)) - 1000.0d0*b10 + 1154.3895d0 

      g(6) = -(9.39d0*sqr((-4.29d0) + x1) + 4.27d0*sqr((-9.49d0) + x2) 
     /       + 5.09d0*sqr((-2.24d0) + x3) + 1.81d0*sqr((-9.78d0) + x4) 
     /       + 7.58d0*sqr((-1.52d0) + x5)) - 1000.0d0*b11 + 1433.3177d0

      g(7) =  -(1.88d0*sqr((-9.76d0) + x1) + 7.2d0*sqr((-3.64d0) + x2) 
     /        + 6.65d0*sqr((-6.62d0) + x3) + 1.74d0*sqr((-3.66d0) + x4) 
     /        + 2.86d0*sqr((-9.08d0) + x5)) - 1000.0d0*b12 + 1109.0764d0

      g(8) =  -(4.01d0*sqr((-1.37d0) + x1) + 2.67d0*sqr((-6.99d0) + x2) 
     /        + 4.86d0*sqr((-7.19d0) + x3) + 2.55d0*sqr((-3.03d0) + x4) 
     /        + 6.91d0*sqr((-3.39d0) + x5)) - 1000.0d0*b13 + 1041.5959d0

      g(9) = -(4.18d0*sqr((-8.89d0) + x1) + 1.92d0*sqr((-8.29d0) + x2) 
     /       + 2.6d0*sqr((-6.05d0) + x3) + 7.15d0*sqr((-7.48d0) + x4) 
     /       + 2.86d0*sqr((-4.09d0) + x5)) - 1000.0d0*b14 + 1144.0623d0

      g(10) = -(7.81d0*sqr((-7.42d0) + x1) + 2.14d0*sqr((-4.6d0) + x2) 
     /        + 9.63d0*sqr((-0.3d0) + x3) + 7.61d0*sqr((-0.97d0) + x4) 
     /        + 9.17d0*sqr((-8.77d0) + x5)) - 1000.0d0*b15 + 1099.8341d0

      g(11) = -(8.96d0*sqr((-1.54d0) + x1) + 3.47d0*sqr((-7.06d0) + x2) 
     /        + 5.49d0*sqr((-0.01d0) + x3) + 4.73d0*sqr((-1.23d0) + x4) 
     /        + 9.43d0*sqr((-3.11d0) + x5)) - 1000.0d0*b16 + 1149.179d0

      g(12) = -(9.94d0*sqr((-7.74d0) + x1) + 1.63d0*sqr((-4.4d0) + x2) 
     /        + 1.23d0*sqr((-7.93d0) + x3) + 4.33d0*sqr((-5.95d0) + x4) 
     /        + 7.08d0*sqr((-4.88d0) + x5)) - 1000.0d0*b17 + 1123.807d0

      g(13) = -(0.31d0*sqr((-9.94d0) + x1) + 5.0d0*sqr((-5.21d0) + x2) 
     /        + 0.16d0*sqr((-8.58d0) + x3) + 2.52d0*sqr((-0.13d0) + x4) 
     /        + 3.08d0*sqr((-4.57d0) + x5)) - 1000.0d0*b18 + 1027.2219d0

      g(14) = -(6.02d0*sqr((-9.54d0) + x1) + 0.92d0*sqr((-1.57d0) + x2) 
     /        + 7.47d0*sqr((-9.66d0) + x3) + 9.74d0*sqr((-5.24d0) + x4) 
     /        + 1.76d0*sqr((-7.9d0) + x5)) - 1000.0d0*b19 + 1089.9268d0

      g(15) = -(5.06d0*sqr((-7.46d0) + x1) + 4.52d0*sqr((-8.81d0) + x2) 
     /        + 1.89d0*sqr((-1.67d0) + x3) + 1.22d0*sqr((-6.47d0) + x4) 
     /        + 9.05d0*sqr((-1.81d0) + x5)) - 1000.0d0*b20 + 1293.076d0

      g(16) = -(5.92d0*sqr((-0.56d0) + x1) + 2.56d0*sqr((-8.1d0) + x2) 
     /        + 7.74d0*sqr((-0.19d0) + x3) + 6.96d0*sqr((-6.11d0) + x4) 
     /        + 5.18d0*sqr((-6.4d0) + x5)) - 1000.0d0*b21 + 1174.317d0

      g(17) = -(6.45d0*sqr((-3.86d0) + x1) + 1.52d0*sqr((-6.68d0) + x2) 
     /        + 0.06d0*sqr((-6.42d0) + x3) + 5.34d0*sqr((-7.29d0) + x4) 
     /        + 8.47d0*sqr((-4.66d0) + x5)) - 1000.0d0*b22 + 1125.1028d0

      g(18) = -(1.04d0*sqr((-2.98d0) + x1) + 1.36d0*sqr((-2.98d0) + x2) 
     /        + 5.99d0*sqr((-3.03d0) + x3) + 8.1d0*sqr((-0.02d0) + x4) 
     /        + 5.22d0*sqr((-0.67d0) + x5)) - 1000.0d0*b23 + 1222.8417d0

      g(19) = -(1.4d0*sqr((-3.61d0) + x1) + 1.35d0*sqr((-7.62d0) + x2) 
     /        + 0.59d0*sqr((-1.79d0) + x3) + 8.58d0*sqr((-7.8d0) + x4) 
     /        + 1.21d0*sqr((-9.81d0) + x5)) - 1000.0d0*b24 + 1050.4859d0

      g(20) = -(6.68d0*sqr((-5.68d0) + x1) + 9.48d0*sqr((-4.24d0) + x2) 
     /        + 1.6d0*sqr((-4.17d0) + x3) + 6.74d0*sqr((-6.75d0) + x4) 
     /        + 8.92d0*sqr((-1.08d0) + x5)) - 1000.0d0*b25 + 1361.1973d0

      g(21) = -(1.95d0*sqr((-5.48d0) + x1) + 0.46d0*sqr((-3.74d0) + x2) 
     /        + 2.9d0*sqr((-3.34d0) + x3) + 1.79d0*sqr((-6.22d0) + x4) 
     /        + 0.99d0*sqr((-7.94d0) + x5)) - 1000.0d0*b26 + 1040.3264d0

      g(22) = -(5.18d0*sqr((-8.13d0) + x1) + 5.1d0*sqr((-8.72d0) + x2) 
     /        + 8.81d0*sqr((-3.93d0) + x3) + 3.27d0*sqr((-8.8d0) + x4) 
     /        + 9.63d0*sqr((-8.56d0) + x5)) - 1000.0d0*b27 + 1161.8518d0
     
      g(23) = -(1.47d0*sqr((-1.37d0) + x1) + 5.71d0*sqr((-0.54d0) + x2) 
     /        + 6.95d0*sqr((-1.55d0) + x3) + 1.42d0*sqr((-5.56d0) + x4) 
     /        + 3.49d0*sqr((-5.85d0) + x5)) - 1000.0d0*b28 + 1066.8582d0

      g(24) = -(5.4d0*sqr((-8.79d0) + x1) + 3.12d0*sqr((-5.04d0) + x2) 
     /        + 5.37d0*sqr((-4.83d0) + x3) + 6.1d0*sqr((-6.94d0) + x4) 
     /        + 3.71d0*sqr((-0.38d0) + x5)) - 1000.0d0*b29 + 1340.5807d0

      g(25) = -(6.32d0*sqr((-2.66d0) + x1) + 0.81d0*sqr((-4.19d0) + x2) 
     /        + 6.12d0*sqr((-6.49d0) + x3) + 6.73d0*sqr((-8.04d0) + x4) 
     /        + 7.93d0*sqr((-1.66d0) + x5)) - 1000.0d0*b30 + 1407.52d0

      g(26) = -x1 + x2 - x3 - x4 - x5 + 10.0d0

      g(27) = -0.6d0*x1 + 0.9d0*x2 + 0.5d0*x3 - 0.1d0*x4 - x5 - 0.64d0

      g(28) = -(-x1 + x2 - x3 + x4 - x5) - 0.69d0

      g(29) = -0.157d0*x1 - 0.05d0*x2 + 1.5d0
      
      g(30) = -(-0.25d0*x2 - 1.05d0*x4 + 0.3d0*x5) -4.5d0

  999 continue
      return
      end
 
      subroutine ortez(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:40:30
*  
*  Equation counts
*     Total       E       G       L       N       X
*        75      25      18      32       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        88      70      18       0       0       0       0       0
*  FX     1       1       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       269     215      54       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax),
     /          x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48, b49, b50,
     /         b51, b52, b53, b54, b55, b56, b57, b58, b59, b60,
     /         b61, b62, b63, b64, b65, b66, x67, x68, x69, x70,
     /         x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /         x81, x82, x83, x84, x85, x86, x87,
     /          e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /         e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /         e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /         e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /         e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /         e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /         e61, e62, e63, e64 ,e65, e66, e67, e68, e69, e70,
     /         e71, e72, e73, e74
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ORTEZ'
         pref  = '\cite{MINLPLib}'
c         fex   = -9532.039d0
         fex   = -10205.4969d0
         ncont = 69
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 74
         me    = 24
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         xl(1) = 1.0d-3                                     
         x(1)  = 254.0d0                                             
         xu(1) = 254.001d0                                             
         xl(2) = 1.0d-3                                     
         x(2)  = 254.0d0                                             
         xu(2) = 254.001d0                                             
         xl(3) = 1.0d-3                                     
         x(3)  = 254.0d0                                             
         xu(3) = 254.001d0                                             
         xl(85) = 254.0d0                                     
         x(85)  = 254.0d0                                     
         xu(85) = 254.0d0                                     
         x(86)  = 254.0d0                                             
         x(87)  = 254.0d0                                             
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x67 = x(49)
      x68 = x(50)
      x69 = x(51)
      x70 = x(52)
      x71 = x(53)
      x72 = x(54)
      x73 = x(55)
      x74 = x(56)
      x75 = x(57)
      x76 = x(58)
      x77 = x(59)
      x78 = x(60)
      x79 = x(61)
      x80 = x(62)
      x81 = x(63)
      x82 = x(64)
      x83 = x(65)
      x84 = x(66)
      x85 = x(67)
      x86 = x(68)
      x87 = x(69)
      b49 = y(1)
      b50 = y(2)
      b51 = y(3)
      b52 = y(4)
      b53 = y(5)
      b54 = y(6)
      b55 = y(7)
      b56 = y(8)
      b57 = y(9)
      b58 = y(10)
      b59 = y(11)
      b60 = y(12)
      b61 = y(13)
      b62 = y(14)
      b63 = y(15)
      b64 = y(16)
      b65 = y(17)
      b66 = y(18)
      
      f = -300.544d0*x22 - 225.408d0*x23 - 150.272d0*x24 - 300.544d0*x25
     /     - 225.408d0*x26 - 150.272d0*x27 - 300.544d0*x28 
     /     - 225.408d0*x29 - 150.272d0*x30 - 2.66666666666667d0*x31 
     /     - 4.0d0*x32 - 5.33333333333333d0*x33 - 2.66666666666667d0*x34
     /     - 4.0d0*x35 - 5.33333333333333d0*x36 - 2.66666666666667d0*x37
     /     - 4.0d0*x38 - 5.33333333333333d0*x39 + 1.33333333333333d0*x67
     /     + x68 + x69 + 1.33333333333333d0*x70 + x71 + x72  
     /     + 1.33333333333333d0*x73 + x74 + x75 + 1.33333333333333d0*x76
     /     + x77 + x78 + 1.33333333333333d0*x79 + x80 + x81 
     /     + 1.33333333333333d0*x82 + x83 + x84

      e1 = b58 + b61 + b64 - 1.0d0                 

      e2 = b59 + b62 + b65 - 1.0d0                 

      e3 = b60 + b63 + b66 - 1.0d0                 

      e4 = x4 + x5 + x6 + x13 + x14 + x15 - 1.0d0  

      e5 = x7 + x8 + x9 + x16 + x17 + x18 - 1.0d0  

      e6 = x10 + x11 + x12 + x19 + x20 + x21 - 1.0d0

      e7 = -3.16363636363636*x4 - 3.16363636363636*x5 
     /     - 3.16363636363636*x6 + 56.3636363636364*b58 + 43.2d0*b61
     /     + 33.8181818181818*b64 - x85 + x86       

      e8 = -3.16363636363636*x7 - 3.16363636363636*x8 
     /     - 3.16363636363636*x9 + 56.3636363636364*b59 + 43.2d0*b62 
     /     + 33.8181818181818*b65 - x86 + x87       

      e9 = -6.353d0*x40*x1**0.172d0 + x22 + x23 + x24  

      e10 = -6.353d0*x41*x2**0.172d0 + x25 + x26 + x27 

      e11 = -6.353d0*x42*x3**0.172d0 + x28 + x29 + x30 

      e12 = -0.32d0*x43*x1**0.617d0 + x31 + x32 + x33  

      e13 = -0.3d02*x44*x2**0.617d0 + x34 + x35 + x36  

      e14 = -0.32d0*x45*x3**0.617d0 + x37 + x38 + x39  

      e15 = x22 + x31 - 50*b58                    

      e16 = x25 + x34 - 50.0d0*b59                    

      e17 = x28 + x37 - 50.0d0*b60                    

      e18 = x23 + x32 - 50.0d0*b61                    

      e19 = x26 + x35 - 50.0d0*b62                    

      e20 = x29 + x38 - 50.0d0*b63                    

      e21 = x24 + x33 - 50.0d0*b64                    

      e22 = x27 + x36 - 50.0d0*b65                    

      e23 = x30 + x39 - 50.0d0*b66                    

      e24 = x4 + x13 - b58                        

      e25 = x7 + x16 - b59                        

      e26 = x10 + x19 - b60                       

      e27 = x5 + x14 - b61                        

      e28 = x8 + x17 - b62                        

      e29 = x11 + x20 - b63                       

      e30 = x6 + x15 - b64                        

      e31 = x9 + x18 - b65                        

      e32 = x12 + x21 - b66                       

      e33 = -200.0d0*b52 + x85                         

      e34 = -200.0d0*b53 + x86                         

      e35 = -200.0d0*b54 + x87                         

      e36 = -200.0d0*b55 + x85                         

      e37 = -200.0d0*b56 + x86                         

      e38 = -200.0d0*b57 + x87                         

      e39 = -x40 + b52                             

      e40 = -x41 + b53                             

      e41 = -x42 + b54                             

      e42 = -x43 + b55                             

      e43 = -x44 + b56                             

      e44 = -x45 + b57                             

      e45 = -x46 + b49                             

      e46 = -x47 + b50                             

      e47 = -x48 + b51                             

      e48 = x85*(1.0d0 - x46) - x1 + 0.001d0            

      e49 = x86*(.0d01 - x47) - x2 + 0.001d0          

      e50 = x87*(1.0d0 - x48) - x3 + 0.001d0          

      e51 = 508.0d0*b49 + x85 - 200.0d0                 

      e52 = 508.0d0*b50 + x86 - 200.0d0                 

      e53 = 508.0d0*b51 + x87 - 200.0d0                 

      e54 = 508.0d0*b49 + x85 - 708.0d0                 

      e55 = 508.0d0*b50 + x86 - 708.0d0                 

      e56 = 508.0d0*b51 + x87 - 708.0d0                 

      e57 = -81.9d0*x40*x4 + x67                     

      e58 = -81.9d0*x41*x7 + x70                     

      e59 = -81.9d0*x42*x10 + x73                    

      e60 = -81.9d0*x40*x5 + x68                     

      e61 = -81.9d0*x41*x8 + x71                     

      e62 = -81.9d0*x42*x11 + x74                    

      e63 = -54.6d0*x40*x6 + x69                     

      e64 = -54.6d0*x41*x9 + x72                     

      e65 = -54.6d0*x42*x12 + x75                    

      e66 = -136.62d0*x40*x13 + x76                  

      e67 = -136.62d0*x41*x16 + x79                  

      e68 = -136.62d0*x42*x19 + x82                  

      e69 = -136.62d0*x40*x14 + x77                  

      e70 = -136.62d0*x41*x17 + x80                  

      e71 = -136.62d0*x42*x20 + x83                  

      e72 = -91.08d0*x40*x15 + x78                   

      e73 = -91.08d0*x41*x18 + x81                   

      e74 = -91.08d0*x42*x21 + x84                   

      g(1) = e4
      g(2) = e5
      g(3) = e6
      g(4) = e45
      g(5) = e46
      g(6) = e47
      g(7) = e57
      g(8) = e58
      g(9) = e59
      g(10) = e60
      g(11) = e61
      g(12) = e62
      g(13) = e63
      g(14) = e64
      g(15) = e65
      g(16) = e66
      g(17) = e67
      g(18) = e68
      g(19) = e69
      g(20) = e70
      g(21) = e71
      g(22) = e72
      g(23) = e73
      g(24) = e74
      g(25) = -e1
      g(26) = -e2
      g(27) = -e3
      g(28) = -e7
      g(29) = -e8
      g(30) = -e9
      g(31) = -e10
      g(32) = -e11
      g(33) = -e12
      g(34) = -e13
      g(35) = -e14
      g(36) = -e15
      g(37) = -e16
      g(38) = -e17
      g(39) = -e18
      g(40) = -e19
      g(41) = -e20
      g(42) = -e21
      g(43) = -e22
      g(44) = -e23
      g(45) = -e24
      g(46) = -e25
      g(47) = -e26
      g(48) = -e27
      g(49) = -e28
      g(50) = -e29
      g(51) = -e30
      g(52) = -e31
      g(53) = -e32
      g(54) = e33
      g(55) = e34
      g(56) = e35
      g(57) = e36
      g(58) = e37
      g(59) = e38
      g(60) = e39
      g(61) = e40
      g(62) = e41
      g(63) = e42
      g(64) = e43
      g(65) = e44
      g(66) = e48
      g(67) = e49
      g(68) = e50
      g(69) = e51
      g(70) = e52
      g(71) = e53
      g(72) = -e54
      g(73) = -e55
      g(74) = -e56

  999 continue
      return
      end
 
      subroutine parallel(  mode,     m,     me,  mmax, ncont,  
     /                      nbin,  nint,   nmax,     x,    xl,
     /                        xu,     f,      g,  pnam,  pref,
     /                       fex )    

*  MINLP written by GAMS Convert at 05/14/01 17:28:57
*  
*  Equation counts
*     Total       E       G       L       N       X
*       116      82       5      29       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       206     181      25       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       752     597     155       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /        x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /       x101,x102,x103,x104,x105,x106,x107,x108,x109,x110,
     /       x111,x112,x113,x114,x115,x116,x117,x118,x119,x120,
     /       x121,x122,x123,x124,x125,x126,x127,x128,x129,x130,
     /       x131,x132,x133,x134,x135,x136,x137,x138,x139,x140,
     /       x141,x142,x143,x144,x145,x146,x147,x148,x149,x150,
     /       x151,x152,x153,x154,x155,x156,x157,x158,x159,x160,
     /       x161,x162,x163,x164,x165,x166,x167,x168,x169,x170,
     /       x171,x172,x173,x174,x175,x176,x177,x178,x179,x180
      double precision
     /       x181,x182,x183,x184,x185,x186,x187,x188,x189,x190,
     /       x191,x192,x193,x194,x195,x196,x197,x198,x199,x200,
     /       x201,x202,x203,x204,x205,
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /       e111,e112,e113,e114,e115
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'PARALLEL'
         pref  = '\cite{MINLPLib}'
c         fex   = 924.2955d0      
c         fex   = 21729.0d0
         fex   = 0.84056139D3
         ncont = 180
         nint  = 0
         nbin  = 25
         n     = ncont + nbin + nint
         m     = 115
         me    = 81
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d2
            xu(i) = 1.0d4
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         xl(26) = 1.0d0 
         x(26)  = 690.0d0  
         xu(26) = 690.0d0   
         xl(ncont+1) = 1.0d0
         x(ncont+1)  = 1.0d0
         xu(ncont+1) = 1.0d0
         xl(ncont+7) = 1.0d0
         x(ncont+7)  = 1.0d0
         xu(ncont+7) = 1.0d0
         xl(ncont+13) = 1.0d0
         x(ncont+13)  = 1.0d0
         xu(ncont+13) = 1.0d0
         xl(ncont+19) = 1.0d0
         x(ncont+19)  = 1.0d0
         xu(ncont+19) = 1.0d0
         xl(ncont+25) = 1.0d0
         x(ncont+25)  = 1.0d0
         xu(ncont+25) = 1.0d0
         goto 999       
      end if

      do i=1,nbin
         y(i) = x(i)
      end do   
      
      x26 = x(1)
      x27 = x(2)
      x28 = x(3)
      x29 = x(4)
      x30 = x(5)
      x31 = x(6)
      x32 = x(7)
      x33 = x(8)
      x34 = x(9)
      x35 = x(10)
      x36 = x(11)
      x37 = x(12)
      x38 = x(13)
      x39 = x(14)
      x40 = x(15)
      x41 = x(16)
      x42 = x(17)
      x43 = x(18)
      x44 = x(19)
      x45 = x(20)
      x46 = x(21)
      x47 = x(22)
      x48 = x(23)
      x49 = x(24)
      x50 = x(25)
      x51 = x(26)
      x52 = x(27)
      x53 = x(28)
      x54 = x(29)
      x55 = x(30)
      x56 = x(31)
      x57 = x(32)
      x58 = x(33)
      x59 = x(34)
      x60 = x(35)
      x61 = x(36)
      x62 = x(37)
      x63 = x(38)
      x64 = x(39)
      x65 = x(40)
      x66 = x(41)
      x67 = x(42)
      x68 = x(43)
      x69 = x(44)
      x70 = x(45)
      x71 = x(46)
      x72 = x(47)
      x73 = x(48)
      x74 = x(49)
      x75 = x(50)
      x76 = x(51)
      x77 = x(52)
      x78 = x(53)
      x79 = x(54)
      x80 = x(55)
      x81 = x(56)
      x82 = x(57)
      x83 = x(58)
      x84 = x(59)
      x85 = x(60)
      x86 = x(61)
      x87 = x(62)
      x88 = x(63)
      x89 = x(64)
      x90 = x(65)
      x91 = x(66)
      x92 = x(67)
      x93 = x(68)
      x94 = x(69)
      x95 = x(70)
      x96 = x(71)
      x97 = x(72)
      x98 = x(73)
      x99 = x(74)
      x100 = x(75)
      x101 = x(76)
      x102 = x(77)
      x103 = x(78)
      x104 = x(79)
      x105 = x(80)
      x106 = x(81)
      x107 = x(82)
      x108 = x(83)
      x109 = x(84)
      x110 = x(85)
      x111 = x(86)
      x112 = x(87)
      x113 = x(88)
      x114 = x(89)
      x115 = x(90)
      x116 = x(91)
      x117 = x(92)
      x118 = x(93)
      x119 = x(94)
      x120 = x(95)
      x121 = x(96)
      x122 = x(97)
      x123 = x(98)
      x124 = x(99)
      x125 = x(100)
      x126 = x(101)
      x127 = x(102)
      x128 = x(103)
      x129 = x(104)
      x130 = x(105)
      x131 = x(106)
      x132 = x(107)
      x133 = x(108)
      x134 = x(109)
      x135 = x(110)
      x136 = x(111)
      x137 = x(112)
      x138 = x(113)
      x139 = x(114)
      x140 = x(115)
      x141 = x(116)
      x142 = x(117)
      x143 = x(118)
      x144 = x(119)
      x145 = x(120)
      x146 = x(121)
      x147 = x(122)
      x148 = x(123)
      x149 = x(124)
      x150 = x(125)
      x151 = x(126)
      x152 = x(127)
      x153 = x(128)
      x154 = x(129)
      x155 = x(130)
      x156 = x(131)
      x157 = x(132)
      x158 = x(133)
      x159 = x(134)
      x160 = x(135)
      x161 = x(136)
      x162 = x(137)
      x163 = x(138)
      x164 = x(139)
      x165 = x(140)
      x166 = x(141)
      x167 = x(142)
      x168 = x(143)
      x169 = x(144)
      x170 = x(145)
      x171 = x(146)
      x172 = x(147)
      x173 = x(148)
      x174 = x(149)
      x175 = x(150)
      x176 = x(151)
      x177 = x(152)
      x178 = x(153)
      x179 = x(154)
      x180 = x(155)
      x181 = x(156)
      x182 = x(157)
      x183 = x(158)
      x184 = x(159)
      x185 = x(160)
      x186 = x(161)
      x187 = x(162)
      x188 = x(163)
      x189 = x(164)
      x190 = x(165)
      x191 = x(166)
      x192 = x(167)
      x193 = x(168)
      x194 = x(169)
      x195 = x(170)
      x196 = x(171)
      x197 = x(172)
      x198 = x(173)
      x199 = x(174)
      x200 = x(175)
      x201 = x(176)
      x202 = x(177)
      x203 = x(178)
      x204 = x(179)
      x205 = x(180)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)

      f = 1013.33333333333d0*x26/x51 + 1013.33333333333d0*x27/x51
     /     + 1013.33333333333d0*x28/x51 + 1013.33333333333d0*x29/x51 
     /     + 1013.33333333333d0*x30/x51 + 781.25d0*x31/x51 
     /     + 781.25d0*x32/x51 + 781.25d0*x33/x51 + 781.25d0*x34/x51 
     /     + 781.25d0*x35/x51 + 962.5d0*x36/x51 + 962.5d0*x37/x51
     /     + 962.5d0*x38/x51 + 962.5d0*x39/x51 + 962.5d0*x40/x51 
     /     + 937.5d0*x41/x51 + 937.5d0*x42/x51 + 937.5d0*x43/x51 
     /     + 937.5d0*x44/x51 + 937.5d0*x45/x51 + 923.203125d0*x46/x51 
     /     + 923.203125d0*x47/x51 + 923.203125d0*x48/x51 
     /     + 923.203125d0*x49/x51 + 923.203125d0*x50/x51 
     /     - 1406.25d0*x82/x51 - 1406.25d0*x83/x51 - 1406.25d0*x84/x51
     /     - 1406.25d0*x85/x51 - 1406.25d0*x86/x51 - 4331.25d0*x87/x51
     /     - 4331.25d0*x88/x51 - 4331.25d0*x89/x51 - 4331.25d0*x90/x51
     /     - 4331.25d0*x91/x51 - 3375d0*x92/x51 - 3375d0*x93/x51 
     /     - 3375d0*x94/x51 - 3375d0*x95/x51 - 3375d0*x96/x51 
     /     - 4154.4140625d0*x97/x51 - 4154.4140625d0*x98/x51 
     /     - 4154.4140625d0*x99/x51 - 4154.4140625d0*x100/x51 
     /     - 4154.4140625d0*x101/x51 - 1824d0*x102/x51 - 1824d0*x103/x51
     /     - 1824d0*x104/x51 - 1824d0*x105/x51 - 1824d0*x106/x51
     /     - 2598.75d0*x112/x51 - 2598.75d0*x113/x51
      f = f 
     /     - 2598.75d0*x114/x51 - 2598.75d0*x115/x51
     /     - 2598.75d0*x116/x51 - 1687.5d0*x117/x51 - 1687.5d0*x118/x51
     /     - 1687.5d0*x119/x51 - 1687.5d0*x120/x51 - 1687.5d0*x121/x51
     /     - 2492.6484375d0*x122/x51 - 2492.6484375d0*x123/x51 
     /     - 2492.6484375d0*x124/x51 - 2492.6484375d0*x125/x51
     /     - 2492.6484375d0*x126/x51 - 4560.0d0*x127/x51 
     /     - 4560.0d0*x128/x51 - 4560d0*x129/x51 - 4560d0*x130/x51 
     /     - 4560d0*x131/x51 - 2109.375d0*x132/x51 - 2109.375d0*x133/x51
     /     - 2109.375d0*x134/x51 - 2109.375d0*x135/x51 
     /     - 2109.375d0*x136/x51 - 1687.5d0*x142/x51 - 1687.5d0*x143/x51
     /     - 1687.5d0*x144/x51 - 1687.5d0*x145/x51 - 1687.5d0*x146/x51 
     /     - 4985.296875d0*x147/x51 - 4985.296875d0*x148/x51 
     /     - 4985.296875d0*x149/x51 - 4985.296875d0*x150/x51 
     /     - 4985.296875d0*x151/x51 - 3648d0*x152/x51 - 3648d0*x153/x51 
     /     - 3648d0*x154/x51 - 3648d0*x155/x51 - 3648d0*x156/x51 
     /     - 1406.25d0*x157/x51 - 1406.25d0*x158/x51 
     /     - 1406.25d0*x159/x51 - 1406.25d0*x160/x51 
     /     - 1406.25d0*x161/x51 - 1732.5d0*x162/x51 - 1732.5d0*x163/x51 
     /     - 1732.5d0*x164/x51 - 1732.5d0*x165/x51 -  1732.5d0*x166/x51
      f = f 
     /     - 4154.4140625d0*x172/x51 - 4154.4140625d0*x173/x51 
     /     - 4154.4140625d0*x174/x51 - 4154.4140625d0*x175/x51 
     /     - 4154.4140625d0*x176/x51 - 4560d0*x177/x51 - 4560d0*x178/x51
     /     - 4560d0*x179/x51 - 4560d0*x180/x51 - 4560d0*x181/x51 
     /     - 2109.375d0*x182/x51 - 2109.375d0*x183/x51 
     /     - 2109.375d0*x184/x51 - 2109.375d0*x185/x51 
     /     - 2109.375d0*x186/x51 - 5197.5d0*x187/x51 
     /     - 5197.5d0*x188/x51 - 5197.5d0*x189/x51 - 5197.5d0*x190/x51 
     /     - 5197.5d0*x191/x51 - 4218.75d0*x192/x51 - 4218.75d0*x193/x51
     /     - 4218.75d0*x194/x51 - 4218.75d0*x195/x51 
     /     - 4218.75d0*x196/x51 
     /     - 2500d0*x72/x51 - 2500d0*x73/x51  - 2500d0*x74/x51 
     /     - 2500d0*x75/x51 - 2500d0*x76/x51
     /     + 3d0*x72 + 3d0*x73 + 3d0*x74 + 3d0*x75 + 3d0*x76
      f = f
     /     + 2.63768115942029d0*x52 + 2.63768115942029d0*x53 
     /     + 2.63768115942029d0*x54 + 2.63768115942029d0*x55 
     /     + 2.63768115942029d0*x56 + 2.81449275362319d0*x57    
     /     + 2.81449275362319d0*x58 + 2.81449275362319d0*x59
     /     + 2.81449275362319d0*x60 + 2.81449275362319d0*x61 
     /     + 2.88405797101449d0*x62 + 2.88405797101449d0*x63    
     /     + 2.88405797101449d0*x64 + 2.88405797101449d0*x65 
     /     + 2.88405797101449d0*x66 + 2.88405797101449d0*x67 
     /     + 2.88405797101449d0*x68 + 2.88405797101449d0*x69    
     /     + 2.88405797101449d0*x70 + 2.88405797101449d0*x71 
     /     + 100000d0*x202 + 100000d0*x203 + 100000d0*x204 
     /     + 100000d0*x205
c      f = f*1.0d-8
      
      e1 = -x26 - x27 - x28 - x29 - x30 - x31 - x32 - x33 - x34 - x35
     /      - x36 - x37 - x38 - x39 - x40 - x41 - x42 - x43 - x44 - x45
     /      - x46 - x47 - x48 - x49 - x50 + x51  

      e2 = -(x52/x51 + x53/x51 + x54/x51 + x55/x51 + x56/x51) - x202
     /      + 0.483091787439614d0                        

      e3 = -(x57/x51 + x58/x51 + x59/x51 + x60/x51 + x61/x51) - x203
     /      + 0.193236714975845d0                        

      e4 = -(x62/x51 + x63/x51 + x64/x51 + x65/x51 + x66/x51) - x204   
     /      + 0.144927536231884d0

      e5 = -(x67/x51 + x68/x51 + x69/x51 + x70/x51 + x71/x51) - x205   
     /      + 0.144927536231884d0                        

      e6 = -1.33333333333333d0*x26 + x52 + 2.66666666666667d0*x102  
     /      + 6.66666666666667d0*x127 + 5.33333333333333d0*x152 
     /      + 6.66666666666667d0*x177                       

      e7 = -1.33333333333333d0*x27 + x53 + 2.66666666666667d0*x103   
     /      + 6.66666666666667d0*x128 + 5.33333333333333d0*x153 
     /      + 6.66666666666667d0*x178                       

      e8 = -1.33333333333333d0*x28 + x54 + 2.66666666666667d0*x104 
     /      + 6.66666666666667d0*x129 + 5.33333333333333d0*x154 
     /      + 6.66666666666667d0*x179

      e9 = -1.33333333333333d0*x29 + x55 + 2.66666666666667d0*x105 
     /      + 6.66666666666667d0*x130 + 5.33333333333333d0*x155 
     /      + 6.66666666666667d0*x180                       

      e10 = -1.33333333333333d0*x30 + x56 + 2.66666666666667d0*x106  
     /       + 6.66666666666667d0*x131 + 5.33333333333333d0*x156 
     /       + 6.66666666666667d0*x181                      
        
      e11 = -1.04166666666667d0*x31 + x57 + 2.08333333333333d0*x82 
     /      + 3.125d0*x132 + 2.08333333333333d0*x157 + 3.125d0*x182 

      e12 = -1.04166666666667d0*x32 + x58 + 2.08333333333333d0*x83 
     /       + 3.125d0*x133 + 2.08333333333333d0*x158 + 3.125d0*x183  

      e13 = -1.04166666666667d0*x33 + x59 + 2.08333333333333d0*x84 
     /       + 3.125d0*x134 + 2.08333333333333d0*x159 + 3.125d0*x184   

      e14 = -1.04166666666667d0*x34 + x60 + 2.08333333333333d0*x85 
     /       + 3.125d0*x135 + 2.08333333333333d0*x160 + 3.125d0*x185  

      e15 = -1.04166666666667d0*x35 + x61 + 2.08333333333333d0*x86 
     /       + 3.125d0*x136 + 2.08333333333333d0*x161 + 3.125d0*x186  

      e16 = -1.25d0*x36 + x62 + 6.25d0*x87 + 3.75d0*x112 + 2.5d0*x162
     /       + 7.5d0*x187                                

      e17 = -1.25d0*x37 + x63 + 6.25d0*x88 + 3.75d0*x113 + 2.5d0*x163
     /       + 7.5d0*x188                                

      e18 = -1.25d0*x38 + x64 + 6.25d0*x89 + 3.75d0*x114 + 2.5d0*x164 
     /       + 7.5d0*x189                                

      e19 = -1.25d0*x39 + x65 + 6.25d0*x90 + 3.75d0*x115 + 2.5d0*x165 
     /       + 7.5d0*x190                                

      e20 = -1.25d0*x40 + x66 + 6.25d0*x91 + 3.75d0*x116 + 2.5d0*x166
     /       + 7.5d0*x191                                

      e21 = -1.25d0*x41 + x67 + 5d0*x92 + 2.5d0*x117 + 2.5d0*x142 
     /       + 6.25d0*x192  

      e22 = -1.25d0*x42 + x68 + 5d0*x93 + 2.5d0*x118 + 2.5d0*x143
     /       + 6.25d0*x193  

      e23 = -1.25d0*x43 + x69 + 5d0*x94 + 2.5d0*x119 + 2.5d0*x144 
     /       + 6.25d0*x194  

      e24 = -1.25d0*x44 + x70 + 5d0*x95 + 2.5d0*x120 + 2.5d0*x145 
     /       + 6.25d0*x195  

      e25 = -1.25d0*x45 + x71 + 5d0*x96 + 2.5d0*x121 + 2.5d0*x146 
     /       + 6.25d0*x196  

      e26 = -1.21875d0*x46 + x72 + 6.09375d0*x97 + 3.65625d0*x122 
     /       + 7.3125d0*x147 + 6.09375d0*x172      

      e27 = -1.21875d0*x47 + x73 + 6.09375d0*x98 + 3.65625d0*x123 
     /       + 7.3125d0*x148 + 6.09375d0*x173               

      e28 = -1.21875d0*x48 + x74 + 6.09375d0*x99 + 3.65625d0*x124 
     /       + 7.3125d0*x149 + 6.09375d0*x174                

      e29 = -1.21875d0*x49 + x75 + 6.09375d0*x100 + 3.65625d0*x125
     /       + 7.3125d0*x150 + 6.09375d0*x175          

      e30 = -1.21875d0*x50 + x76 + 6.09375d0*x101 + 3.65625d0*x126 
     /       + 7.3125d0*x151 + 6.09375d0*x176  

      e31 = b1 + b6 + b11 + b16 - 1.0d0                  

      e32 = b2 + b7 + b12 + b17 - 1.0d0                   

      e33 = b3 + b8 + b13 + b18 - 1.0d0                   

      e34 = b4 + b9 + b14 + b19 - 1.0d0                   

      e35 = b1 + b2 + b3 + b4 + b5 - 1.0d0                

      e36 = b6 + b7 + b8 + b9 + b10 - 1.0d0               

      e37 = b11 + b12 + b13 + b14 + b15 - 1.0d0           

      e38 = b16 + b17 + b18 + b19 + b20 - 1.0d0           

      e39 = b21 + b22 + b23 + b24 + b25 - 1.0d0           

      e41 = -256.0d0*b1 + x26                               

      e42 = -256.0d0*b6 + x27                               

      e43 = -256.0d0*b11 + x28                              

      e44 = -256.0d0*b16 + x29                              

      e45 = -256.0d0*b21 + x30                              

      e46 = -131.0d0*b2 + x31                               

      e47 = -131.0d0*b7 + x32                               

      e48 = -131.0d0*b12 + x33                              

      e49 = -131.0d0*b17 + x34                              

      e50 = -131.0d0*b22 + x35                              

      e51 = -86.0d0*b3 + x36                                

      e52 = -86.0d0*b8 + x37                                

      e53 = -86.0d0*b13 + x38                               

      e54 = -86.0d0*b18 + x39                               

      e55 = -86.0d0*b23 + x40                               

      e56 = -85.0d0*b4 + x41                                

      e57 = -85.0d0*b9 + x42                                

      e58 = -85.0d0*b14 + x43                               

      e59 = -85.0d0*b19 + x44                               

      e60 = -85.0d0*b24 + x45                               

      e61 = -690.0d0*b5 + x46                               

      e62 = -690.0d0*b10 + x47                              

      e63 = -690.0d0*b15 + x48                              

      e64 = -690.0d0*b20 + x49                              

      e65 = -690.0d0*b25 + x50                              

      e66 = -b1 + x77 + x102 + x127 + x152 + x177       

      e67 = -b6 + x78 + x103 + x128 + x153 + x178       

      e68 = -b11 + x79 + x104 + x129 + x154 + x179      

      e69 = -b16 + x80 + x105 + x130 + x155 + x180      

      e70 = -b21 + x81 + x106 + x131 + x156 + x181      

      e71 = -b2 + x82 + x107 + x132 + x157 + x182       

      e72 = -b7 + x83 + x108 + x133 + x158 + x183       

      e73 = -b12 + x84 + x109 + x134 + x159 + x184      

      e74 = -b17 + x85 + x110 + x135 + x160 + x185      

      e75 = -b22 + x86 + x111 + x136 + x161 + x186      

      e76 = -b3 + x87 + x112 + x137 + x162 + x187       

      e77 = -b8 + x88 + x113 + x138 + x163 + x188       

      e78 = -b13 + x89 + x114 + x139 + x164 + x189      

      e79 = -b18 + x90 + x115 + x140 + x165 + x190      

      e80 = -b23 + x91 + x116 + x141 + x166 + x191      

      e81 = -b4 + x92 + x117 + x142 + x167 + x192       

      e82 = -b9 + x93 + x118 + x143 + x168 + x193       

      e83 = -b14 + x94 + x119 + x144 + x169 + x194      

      e84 = -b19 + x95 + x120 + x145 + x170 + x195      

      e85 = -b24 + x96 + x121 + x146 + x171 + x196      

      e86 = -b5 + x97 + x122 + x147 + x172 + x197       

      e87 = -b10 + x98 + x123 + x148 + x173 + x198      

      e88 = -b15 + x99 + x124 + x149 + x174 + x199      

      e89 = -b20 + x100 + x125 + x150 + x175 + x200     

      e90 = -b25 + x101 + x126 + x151 + x176 + x201     

      e91 = -b21 + x77 + x82 + x87 + x92 + x97          

      e92 = -b1 + x78 + x83 + x88 + x93 + x98           

      e93 = -b6 + x79 + x84 + x89 + x94 + x99           

      e94 = -b11 + x80 + x85 + x90 + x95 + x100         

      e95 = -b16 + x81 + x86 + x91 + x96 + x101         

      e96 = -b22 + x102 + x107 + x112 + x117 + x122     

      e97 = -b2 + x103 + x108 + x113 + x118 + x123      

      e98 = -b7 + x104 + x109 + x114 + x119 + x124      

      e99 = -b12 + x105 + x110 + x115 + x120 + x125     

      e100 = -b17 + x106 + x111 + x116 + x121 + x126    

      e101 = -b23 + x127 + x132 + x137 + x142 + x147    

      e102 = -b3 + x128 + x133 + x138 + x143 + x148     

      e103 = -b8 + x129 + x134 + x139 + x144 + x149     

      e104 = -b13 + x130 + x135 + x140 + x145 + x150    

      e105 = -b18 + x131 + x136 + x141 + x146 + x151    

      e106 = -b24 + x152 + x157 + x162 + x167 + x172    
      
      e107 = -b4 + x153 + x158 + x163 + x168 + x173     

      e108 = -b9 + x154 + x159 + x164 + x169 + x174     

      e109 = -b14 + x155 + x160 + x165 + x170 + x175    

      e110 = -b19 + x156 + x161 + x166 + x171 + x176    

      e111 = -b25 + x177 + x182 + x187 + x192 + x197    

      e112 = -b5 + x178 + x183 + x188 + x193 + x198     

      e113 = -b10 + x179 + x184 + x189 + x194 + x199    

      e114 = -b15 + x180 + x185 + x190 + x195 + x200    

      e115 = -b20 + x181 + x186 + x191 + x196 + x201      

      g(1) = e1
      g(2) = e6
      g(3) = e7
      g(4) = e8
      g(5) = e9
      g(6) = e10
      g(7) = e11
      g(8) = e12
      g(9) = e13
      g(10) = e14
      g(11) = e15
      g(12) = e16
      g(13) = e17
      g(14) = e18
      g(15) = e19
      g(16) = e20
      g(17) = e21
      g(18) = e22
      g(19) = e23
      g(20) = e24
      g(21) = e25
      g(22) = e26
      g(23) = e27
      g(24) = e28
      g(25) = e29
      g(26) = e30     
      g(27) = e35
      g(28) = e36
      g(29) = e37
      g(30) = e38
      g(31) = e39  
      g(32) = e66
      g(33) = e67
      g(34) = e68
      g(35) = e69
      g(36) = e70
      g(37) = e71
      g(38) = e72
      g(39) = e73
      g(40) = e74
      g(41) = e75
      g(42) = e76
      g(43) = e77
      g(44) = e78
      g(45) = e79
      g(46) = e80
      g(47) = e81
      g(48) = e82
      g(49) = e83
      g(50) = e84
      g(51) = e85
      g(52) = e86
      g(53) = e87
      g(54) = e88
      g(55) = e89
      g(56) = e90
      g(57) = e91
      g(58) = e92
      g(59) = e93
      g(60) = e94
      g(61) = e95
      g(62) = e96
      g(63) = e97
      g(64) = e98
      g(65) = e99
      g(66) = e100
      g(67) = e101
      g(68) = e102
      g(69) = e103
      g(70) = e104
      g(71) = e105
      g(72) = e106
      g(73) = e107
      g(74) = e108
      g(75) = e109
      g(76) = e110
      g(77) = e111
      g(78) = e112
      g(79) = e113
      g(80) = e114
      g(81) = e115
      g(82) = -e2
      g(83) = -e3
      g(84) = -e4
      g(85) = -e5     
      g(86) = e31
      g(87) = e32
      g(88) = e33
      g(89) = e34
      g(91) = -e41
      g(92) = -e42
      g(93) = -e43
      g(94) = -e44
      g(95) = -e45
      g(96) = -e46
      g(97) = -e47
      g(98) = -e48
      g(99) = -e49
      g(100) = -e50
      g(101) = -e51
      g(102) = -e52
      g(103) = -e53
      g(104) = -e54
      g(105) = -e55
      g(106) = -e56
      g(107) = -e57
      g(108) = -e58
      g(109) = -e59
      g(110) = -e60
      g(111) = -e61
      g(112) = -e62
      g(113) = -e63
      g(114) = -e64
      g(115) = -e65 

C      do i=91,115
C         g(i) = g(i)*1.0d-3
C      end do    

  999 continue
      return
      end
 

      subroutine prob02( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), i1, i2, i3, i4, i5, i6
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'PROB02'
         pref  = '\cite{MINLPLib}'
         fex   = 11.22350d4
         ncont = 0
         nint  = 6
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 8
         me    = 0
         do i=1,n
            xl(i) = 1.0d0
            x(i)  = 50.0d0
            xu(i) = 100.0d0
         enddo
        goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo

      i1 = y(1)
      i2 = y(2)
      i3 = y(3)
      i4 = y(4)
      i5 = y(5)
      i6 = y(6)

      f = -(- 8000.0d0*i1 + 330.0d0*i2 + 360.0d0*i3 + 370.0d0*i4 
     /      + 415.0d0*i5 + 435.0d0*i6)

      g(1) = -(330.0d0*i2 + 360.0d0*i3 + 370.0d0*i4 + 415.0d0*i5 
     /       + 435.0d0*i6) + 8000.0d0
 
      g(2) = 330.0d0*i2 + 360.0d0*i3 + 370.0d0*i4 + 415.0d0*i5 
     /       + 435.0d0*i6 - 7700.0d0
 
      g(3) = -(i2 + i3 + i4 + i5 + i6) + 20.0d0
 
      g(4) = i1*i2 - 60.0d0
 
      g(5) = i1*i3 - 30.0d0
 
      g(6) = i1*i4 - 75.0d0
 
      g(7) = i1*i5 - 30.0d0
 
      g(8) = i1*i6 - 100.0d0

  999 continue
      return
      end
 
      subroutine prob03(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )   

*  MINLP written by GAMS Convert at 07/02/03 17:54:25
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         2       1       0       1       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       1       0       2       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         5       3       2       0
*
*  Solve m using MINLP minimizing objvar;
      
      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), i1, i2, e2
      character*30 pnam, pref
      if (mode.eq.0) then
         pnam  = 'PROB03'
         pref  = '\cite{MINLPLib}'
         fex   = 10.0d0
         ncont = 0
         nint  = 2
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 1
         me    = 0
         do i = 1,nint
            xl(i) = 1.0d0
            x(i)  = 2.0d0
            xu(i) = 5.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo   
      
      i1 = y(1)
      i2 = y(2)

      f = 3.0d0*i1 + 2.0d0*i2

      e2 = -i1*i2 + 3.5d0 

      g(1) = -e2

  999 continue
      return
      end
 
 
      subroutine prob10(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    
*  MINLP written by GAMS Convert at 07/02/03 17:54:36
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       0       2       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       2       0       1       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*         7       5       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, x2, i3, e1, e2
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'PROB10'
         pref  = '\cite{MINLPLib}'
         fex   =  3.44550379433d0
         ncont = 1
         nint  = 1
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         xl(1) = 0.0d0
         x(1)  = 5.0d0
         xu(1) = 1.0d1
         xl(2) = 0.0d0
         x(2)  = 5.0d0
         xu(2) = 1.0d1
         goto 999       
      endif

      x2 = x(1)
      i3 = x(2)

      f = 1.1d0*(sqr(2*x2 - 10.0d0) + sqr(i3 - 5.0d0)) 
     /    + dsin(sqr(2.0d0*x2 - 10.0d0) + sqr(i3 - 5.0d0)) 

      e1 = 0.7d0*x2 + i3 - 7.0d0 
      
      e2 = 2.5d0*x2 + i3 - 19.0d0   

      g(1) = -e1
	
      g(2) = -e2

  999 continue
      return
      end
 

      subroutine procsel(  mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/18/01 15:19:45
*  
*  Equation counts
*     Total       E       G       L       N       X
*         8       5       0       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        11       8       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        26      24       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), x1, x2, x3, x4, x5, x6, x7, b8, b9, b10, e1, 
     /        e2, e3, e4, e5, e6, e7
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'PROCSEL'
         pref  = '\cite{MINLPLib}'
         fex   = -1.923099d0
         ncont = 7
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 7
         me    = 4
         do i = 1,ncont
            xl(i) = 0.0d1
            x(i)  = 1.0d0
            xu(i) = 1.0d2
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xu(7) = 1.0d0     
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      b8 = y(1)
      b9 = y(2)
      b10 = y(3)

      f =  1.8d0*x1 + 1.8d0*x2 + x3 + 1.2d0*x4 + 7.0d0*x5 - 11.0d0*x7 
     /     + 3.5d0*b8 + b9 + 1.5d0*b10 
     
      e1 = -0.9d0*x6 + x7                      

      e2 = dexp(x3) - x1 - 1.0d0                  

      e3 = dexp(0.833333333333333d0*x4) - x2 - 1.0d0    

      e4 = -x3 - x4 - x5 + x6                

      e5 = x7 - 2.0d0*b8                        

      e6 = x3 - 4.0d0*b9                        

      e7 = x4 - 5.0d0*b10 

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = -e5
      g(6) = -e6
      g(7) = -e7

  999 continue
      return
      end
  
      subroutine pump(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:40:33
*  
*  Equation counts
*     Total       E       G       L       N       X
*        35      14       0      21       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        25      16       3       6       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        94      58      36       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), power, sqr,
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /        x11, x12, x13, x14, x15, i16, i17, i18, i19, i20,
     /        i21, b22, b23, b24,  
     /              e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'PUMP'
         pref  = '\cite{MINLPLib}'
         fex   = 134263.6d0 
c         fex = fex*1.0d-8
         ncont = 15
         nint  = 6
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 34
         me    = 13
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0d0
         end do
         x(1) = 30.0d0
         xu(1) = 80.0d0  
         xu(2) = 25.0d0  
         xu(3) = 45.0d0  
         x(4) = 2950.0d0
         xu(4) = 2950.0d0
         x(5) = 2950.0d0
         xu(5) = 2950.0d0
         x(6) = 2950.0d0
         xu(6) = 2950.0d0                 
         x(7) = 400.0d0
         xu(7) = 400.0d0 
         xu(8) = 400.0d0 
         xu(9) = 400.0d0 
         x(10) = 150.0d0
         xu(10) = 350.0d0
         xu(11) = 350.0d0
         xu(12) = 350.0d0
         x(13) = 0.33d0
         xu(13) = 1.0d0  
         x(14) = 0.33d0
         xu(14) = 1.0d0  
         x(15) = 0.33d0
         xu(15) = 1.0d0  
         do i = ncont+nbin+1,n
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 3.0d0
         end do
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      
      do i=1,nint
         y(i) = x(ncont+nbin+i)
      end do   
      do i=1,nbin
         y(nint+i) = x(ncont+i)
      end do   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      i16 = y(1)
      i17 = y(2)
      i18 = y(3)
      i19 = y(4)
      i20 = y(5)
      i21 = y(6)
      b22 = y(7)
      b23 = y(8)
      b24 = y(9)

      f = (6329.03d0 + 1800.0d0*x1)*i16*i19*b22 
     /    + (2489.31d0 + 1800.0d0*x2)*i17*i20*b23 
     /    + (3270.27d0 + 1800.0d0*x3)*i18*i21*b24
c      f = f*1.0d-8

      e2 = -(19.9d0*power(0.000338983050847458d0*x4,3) 
     /     + 0.161d0*sqr(0.000338983050847458d0*x4)*x10 
     /     - 1.90169491525424d-7*x4*sqr(x10)) + x1   

      e3 = -(1.21d0*power(0.000338983050847458d0*x5,3) 
     /     + 0.0644d0*sqr(0.000338983050847458d0*x5)*x11
     /     - 1.91186440677966d-7*x5*sqr(x11)) + x2

      e4 = -(6.52d0*power(0.000338983050847458d0*x6,3) 
     /     + 0.102d0*sqr(0.000338983050847458d0*x6)*x12 
     /     - 7.86440677966102d-8*x6*sqr(x12)) + x3 

      e5 = -(0.00023593220338983d0*x4*x10 
     /     + 629.0d0*sqr(0.000338983050847458d0*x4) 
     /     - 0.0116d0*sqr(x10)) + x7                                

      e6 = -(0.001d0*x5*x11 + 215.0d0*sqr(0.000338983050847458d0*x5) 
     /     - 0.115d0*sqr(x11)) + x8 

      e7 = -(0.000179661016949153d0*x6*x12 
     /     + 361.0d0*sqr(0.000338983050847458d0*x6) 
     /     - 0.00946d0*sqr(x12)) + x9                         

      e8 = x13 + x14 + x15 - 1.0d0

      e9 = -0.00285714285714286d0*x10*i16 + x13           

      e10 = -0.00285714285714286d0*x11*i17 + x14          

      e11 = -0.00285714285714286d0*x12*i18 + x15          

      e12 = -0.0025d0*x7*i19 + b22                        

      e13 = -0.0025d0*x8*i20 + b23                        

      e14 = -0.0025d0*x9*i21 + b24                        

      e15 = 0.000338983050847458d0*x4 - b22              

      e16 = 0.000338983050847458d0*x5 - b23              

      e17 = 0.000338983050847458d0*x6 - b24              

      e18 = 0.0125d0*x1 - b22                            

      e19 = 0.04d0*x2 - b23                              

      e20 = 0.0222222222222222d0*x3 - b24                

      e21 = 0.0025d0*x7 - b22                            

      e22 = 0.0025d0*x8 - b23                            

      e23 = 0.0025d0*x9 - b24                            

      e24 = 0.00285714285714286d0*x10 - b22              

      e25 = 0.00285714285714286d0*x11 - b23              

      e26 = 0.00285714285714286d0*x12 - b24              

      e27 = x13 - b22                                  

      e28 = x14 - b23                                  

      e29 = x15 - b24                                  

      e30 = i16 - 3.0d0*b22                                

      e31 = i17 - 3.0d0*b23                                

      e32 = i18 - 3.0d0*b24                                

      e33 = i19 - 3.0d0*b22                                

      e34 = i20 - 3.0d0*b23                                

      e35 = i21 - 3.0d0*b24 
      
      g(1) = e2
      g(2) = e3
      g(3) = e4
      g(4) = e5
      g(5) = e6
      g(6) = e7
      g(7) = e8
      g(8) = e9
      g(9) = e10
      g(10) = e11
      g(11) = e12
      g(12) = e13
      g(13) = e14
      g(14) = -e15
      g(15) = -e16
      g(16) = -e17
      g(17) = -e18
      g(18) = -e19
      g(19) = -e20
      g(20) = -e21
      g(21) = -e22
      g(22) = -e23
      g(23) = -e24
      g(24) = -e25
      g(25) = -e26
      g(26) = -e27
      g(27) = -e28
      g(28) = -e29
      g(29) = -e30
      g(30) = -e31
      g(31) = -e32
      g(32) = -e33
      g(33) = -e34
      g(34) = -e35

  999 continue
      return
      end
 
      subroutine qip1( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref,
     /                  fex )    

      implicit none
      integer m, me, ncont, nint, nbin, n, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax)
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'QIP1'
         pref  = ''
         fex   = -20.0d0
         ncont = 0
         nint  = 4
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 4
         me    = 0
         do i = 1,n
            xl(i) = -1.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nint
         y(i) = x(i)
      enddo
      
      f = y(1)*(-y(1) + 2.0d0*y(2)) + y(2)*(2.0d0*y(1) - y(2) 
     /    + 2.0d0*y(3)) + y(3)*(2.0d0*y(2) - y(3) + 2.0d0*y(4)) 
     /    + y(4)*(2.0d0*y(3) - y(4)) + 6.0d0*y(1) + 8.0d0*y(2) 
     /    + 4.0d0*y(3) - 2.0d0*y(4)

      g(1) = 1.0d0 - y(1)*y(2) - y(3)*y(4)

      g(2) = 1.0d0 + y(1)*y(2) + y(3)*y(4)

      g(3) = 2.0d0 - y(1) - y(2) - y(3) - y(4)

      g(4) = 3.0d0 + y(1) + y(2) + y(3) + y(4)

  999 continue
      return
      end

      subroutine rastrigin( mode,     m,     me,  mmax, ncont,  
     /                      nbin,  nint,   nmax,     x,    xl,
     /                        xu,     f,      g,  pnam,  pref,
     /                       fex )    

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, g(1), fex, pi
      character*30 pnam, pref
         
      pi = 3.14159265359d0   
      if (mode.eq.0) then 
         pnam  = 'RASTRIGIN'
         pref  = '\cite{HS81}'
         fex   = -1.9689
         ncont = 1
         nint  = 1
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 0
         me    = 0
         xl(1) = -1.0d2  
         x(1)  = 1.0d1
         xu(1) = 1.0d2  
         xl(2) = -1.0d2      
         x(2)  = 1.0d1
         xu(2) = 1.0d2    
         goto 999       
      end if

      f = x(1)**2 + x(2)**2 - dcos(5.0d0*pi*x(1)) 
     /                             - dcos(5.0d0*pi*x(2))

  999 continue
      return
      end
   
      subroutine ravem(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:40:35
*  
*  Equation counts
*     Total       E       G       L       N       X
*       187      26     135      26       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       113      59      54       0       0       0       0       0
*  FX     1       0       1       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       611     583      28       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none 
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /          x1,  x2,  x3,  x4,  x5,  x6,  x7,  x8,  x9, x10,
     /         x11, x12, x13, x14, x15, x16, x17, x18, x19, x20,
     /         x21, x22, x23, x24, x25, x26, x27, x28, x29, x30,
     /         x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /         x41, x42, x43, x44, x45, x46, x47, x48,      x50,
     /         x51, x52, x53, x54, x55, x56, x57, x58, x59, b60,
     /         b61, b62, b63, b64,b 65, b66, b67, b68, b69, b70,
     /         b71, b72, b73, b74,b 75, b76, b77, b78, b79, b80,
     /         b81, b82, b83, b84,b 85, b86, b87, b88, b89, b90,
     /         b91, b92, b93, b94,b 95, b96, b97, b98, b99,b100,
     /        b101,b102,b103,b104,b105,b106,b107,b108,b109,b110,
     /        b111,b112,b113
      double precision
     /          e1  ,e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /         e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /         e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /         e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /         e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /         e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /         e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /         e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /         e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /         e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /        e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /        e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /        e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /        e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,
     /        e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,
     /        e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,
     /        e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,
     /        e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,
     /        e181,e182,e183,e184,e185,e186
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'RAVEM'
         pref  = '\cite{MINLPLib}'
         fex   = 269590.2d0
         ncont = 58
         nint  = 0
         nbin  = 54
         n     = ncont + nbin + nint
         m     = 186
         me    = 25
         do i = 1,ncont
            xl(i) = -1.0d2
            x(i)  = 1.0d0
            xu(i) = 1.0d2
         enddo
         do i=1,6
            xl(i) = 5.7037824746562d0
            x(i)  = 6.0d0
            xu(i) = 8.1605182474775d0
         enddo  
         do i=7,12
            xl(i) = 4.45966260231685d0
            x(i)  = 5.0d0
            xu(i) = 6.09365548800453d0
         enddo  
         do i=13,18
            xl(i) = 3.74950407593037d0
            x(i)  = 5.0d0
            xu(i) = 6.93674281585539d0
         enddo  
         do i=19,24
            xl(i) = 4.49144142065975d0
            x(i)  = 5.0d0
            xu(i) = 6.87958440201544d0
         enddo  
         do i=25,30
            xl(i) = 3.14988295338125d0
            x(i)  = 5.0d0
            xu(i) = 6.61295573876149d0
         enddo  
         do i=31,36
            xl(i) = 3.04452243772342d0
            x(i)  = 5.0d0            
            xu(i) = 6.65644085070123d0
         enddo  
         do i=37,48
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.38629436111989d0
         enddo  
         do i=49,53
            xl(i) = 4.60517018598809d0
            x(i)  = 5.0d0
            xu(i) = 9.61580548008435d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         xl(112) = 0.0d0
         x(112)  = 0.0d0
         xu(112) = 0.0d0
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      x28 = x(28)
      x29 = x(29)
      x30 = x(30)
      x31 = x(31)
      x32 = x(32)
      x33 = x(33)
      x34 = x(34)
      x35 = x(35)
      x36 = x(36)
      x37 = x(37)
      x38 = x(38)
      x39 = x(39)
      x40 = x(40)
      x41 = x(41)
      x42 = x(42)
      x43 = x(43)
      x44 = x(44)
      x45 = x(45)
      x46 = x(46)
      x47 = x(47)
      x48 = x(48)
      x50 = x(49)
      x51 = x(50)
      x52 = x(51)
      x53 = x(52)
      x54 = x(53)
      x55 = x(54)
      x56 = x(55)
      x57 = x(56)
      x58 = x(57)
      x59 = x(58)
      b60 = y(1)
      b61 = y(2)
      b62 = y(3)
      b63 = y(4)
      b64 = y(5)
      b65 = y(6)
      b66 = y(7)
      b67 = y(8)
      b68 = y(9)
      b69 = y(10)
      b70 = y(11)
      b71 = y(12)
      b72 = y(13)
      b73 = y(14)
      b74 = y(15)
      b75 = y(16)
      b76 = y(17)
      b77 = y(18)
      b78 = y(19)
      b79 = y(20)
      b80 = y(21)
      b81 = y(22)
      b82 = y(23)
      b83 = y(24)
      b84 = y(25)
      b85 = y(26)
      b86 = y(27)
      b87 = y(28)
      b88 = y(29)
      b89 = y(30)
      b90 = y(31)
      b91 = y(32)
      b92 = y(33)
      b93 = y(34)
      b94 = y(35)
      b95 = y(36)
      b96 = y(37)
      b97 = y(38)
      b98 = y(39)
      b99 = y(40)
      b100 = y(41)
      b101 = y(42)
      b102 = y(43)
      b103 = y(44)
      b104 = y(45)
      b105 = y(46)
      b106 = y(47)
      b107 = y(48)
      b108 = y(49)
      b109 = y(50)
      b110 = y(51)
      b111 = y(52)
      b112 = y(53)
      b113 = y(54)

      f  = 250.0d0*(dexp(0.6d0*x1 + x37 + x43) 
     /    + dexp(0.6d0*x2 + x38 + x44) + dexp(0.6d0*x3 + x39 + x45) 
     /    + dexp(0.6d0*x4 + x40 + x46) + dexp(0.6d0*x5 + x41 + x47) 
     /    + dexp(0.6d0*x6 + x42 + x48)) 
     /    + 150.0d0*(dexp(0.5d0*x50) + dexp(0.5d0*x51) + dexp(0.5d0*x52)
     /    + dexp(0.5d0*x53) + dexp(0.5d0*x54))

      e1 = x1 - x7 + x37 - 2.06686275947298   

      e2 = x2 - x8 + x38 - 0.693147180559945  

      e3 = x3 - x9 + x39 - 1.64865862558738   

      e4 = x4 - x10 + x40 - 1.58923520511658  

      e5 = x5 - x11 + x41 - 1.80828877117927  

      e6 = x6 - x12 + x42 - 1.43508452528932  

      e7 = x1 - x13 + x37 + 0.356674943938732

      e8 = x2 - x14 + x38 + 0.22314355131421 

      e9 = x3 - x15 + x39 + 0.105360515657826

      e10 = x4 - x16 + x40 - 1.22377543162212 

      e11 = x5 - x17 + x41 - 0.741937344729377

      e12 = x6 - x18 + x42 - 0.916290731874155

      e13 = x1 - x19 + x37 + 0.356674943938732               

      e14 = x2 - x20 + x38 - 0.955511445027436

      e15 = x3 - x21 + x39 - 0.470003629245736

      e16 = x4 - x22 + x40 - 1.28093384546206 

      e17 = x5 - x23 + x41 - 1.16315080980568 

      e18 = x6 - x24 + x42 - 1.06471073699243 

      e19 = x1 - x25 + x37 - 1.54756250871601 

      e20 = x2 - x26 + x38 - 0.832909122935104

      e21 = x3 - x27 + x39 - 0.470003629245736

      e22 = x4 - x28 + x40 - 0.993251773010283

      e23 = x5 - x29 + x41 - 0.182321556793955

      e24 = x6 - x30 + x42 - 0.916290731874155

      e25 = x1 - x31 + x37 - 0.182321556793955

      e26 = x2 - x32 + x38 - 1.28093384546206 

      e27 = x3 - x33 + x39 - 0.8754687373539  

      e28 = x4 - x34 + x40 - 1.50407739677627 

      e29 = x5 - x35 + x41 - 0.470003629245736

      e30 = x6 - x36 + x42 - 0.741937344729377

      e31 = x7 + x43 + x55 - 1.85629799036563 

      e32 = x8 + x44 + x55 - 1.54756250871601 

      e33 = x9 + x45 + x55 - 2.11625551480255 

      e34 = x10 + x46 + x55 - 1.3609765531356 

      e35 = x11 + x47 + x55 - 0.741937344729377               

      e36 = x12 + x48 + x55 - 0.182321556793955               

      e37 = x13 + x43 + x56 - 1.91692261218206

      e38 = x14 + x44 + x56 - 1.85629799036563

      e39 = x15 + x45 + x56 - 1.87180217690159

      e40 = x16 + x46 + x56 - 1.48160454092422

      e41 = x17 + x47 + x56 - 0.832909122935104               

      e42 = x18 + x48 + x56 - 1.16315080980568

      e43 = x19 + x43 + x57                     

      e44 = x20 + x44 + x57 - 1.84054963339749

      e45 = x21 + x45 + x57 - 1.68639895357023

      e46 = x22 + x46 + x57 - 2.47653840011748

      e47 = x23 + x47 + x57 - 1.7404661748405 

      e48 = x24 + x48 + x57 - 1.82454929205105

      e49 = x25 + x43 + x58 - 1.16315080980568

      e50 = x26 + x44 + x58 - 1.09861228866811

      e51 = x27 + x45 + x58 - 1.25276296849537

      e52 = x28 + x46 + x58 - 1.19392246847243

      e53 = x29 + x47 + x58 - 1.02961941718116

      e54 = x30 + x48 + x58 - 1.22377543162212

      e55 = x31 + x43 + x59 - 0.741937344729377               

      e56 = x32 + x44 + x59 - 0.916290731874155               

      e57 = x33 + x45 + x59 - 1.43508452528932

      e58 = x34 + x46 + x59 - 1.28093384546206

      e59 = x35 + x47 + x59 - 1.30833281965018

      e60 = x36 + x48 + x59 - 0.78845736036427

      e61 = 250000.0d0*dexp(x55) + 150000.0d0*dexp(x56) 
     /      + 180000.0d0*dexp(x57) + 160000.0d0*dexp(x58) 
     /      + 120000.0d0*dexp(x59) - 6000.0d0         

      e62 =  - x8 + x50 - 10.0d0*b108 + 7.69741490700595            

      e63 =  - x9 + x51 - 10.0d0*b109 + 7.69741490700595            

      e64 =  - x10 + x52 - 10.0d0*b110 + 7.69741490700595           

      e65 =  - x11 + x53 - 10.0d0*b111 + 7.69741490700595           

      e66 =  - x12 + x54 - 10.0d0*b112 + 7.69741490700595           

      e67 =  - x14 + x50 - 10.0d0*b108 + 7.69741490700595           

      e68 =  - x15 + x51 - 10.0d0*b109 + 7.69741490700595           

      e69 =  - x16 + x52 - 10.0d0*b110 + 7.69741490700595           

      e70 =  - x17 + x53 - 10.0d0*b111 + 7.69741490700595           

      e71 =  - x18 + x54 - 10.0d0*b112 + 7.69741490700595           

      e72 =  - x20 + x50 - 10.0d0*b108 + 7.69741490700595           

      e73 =  - x21 + x51 - 10.0d0*b109 + 7.69741490700595           

      e74 =  - x22 + x52 - 10.0d0*b110 + 7.69741490700595           

      e75 =  - x23 + x53 - 10.0d0*b111 + 7.69741490700595           

      e76 =  - x24 + x54 - 10.0d0*b112 + 7.69741490700595           

      e77 =  - x26 + x50 - 10.0d0*b108 + 7.69741490700595           

      e78 =  - x27 + x51 - 10.0d0*b109 + 7.69741490700595           

      e79 =  - x28 + x52 - 10.0d0*b110 + 7.69741490700595           

      e80 =  - x29 + x53 - 10.0d0*b111 + 7.69741490700595           

      e81 =  - x30 + x54 - 10.0d0*b112 + 7.69741490700595           

      e82 =  - x32 + x50 - 10.0d0*b108 + 7.69741490700595           

      e83 =  - x33 + x51 - 10.0d0*b109 + 7.69741490700595           

      e84 =  - x34 + x52 - 10.0d0*b110 + 7.69741490700595           

      e85 =  - x35 + x53 - 10.0d0*b111 + 7.69741490700595           

      e86 =  - x36 + x54 - 10.0d0*b112 + 7.69741490700595           

      e87 =  - x7 + x50 - 10.0d0*b108 + 7.69741490700595            

      e88 =  - x8 + x51 - 10.0d0*b109 + 7.69741490700595            

      e89 =  - x9 + x52 - 10.0d0*b110 + 7.69741490700595            

      e90 =  - x10 + x53 - 10.0d0*b111 + 7.69741490700595           

      e91 =  - x11 + x54 - 10.0d0*b112 + 7.69741490700595           

      e92 =  - x13 + x50 - 10.0d0*b108 + 7.69741490700595           

      e93 =  - x14 + x51 - 10.0d0*b109 + 7.69741490700595           

      e94 =  - x15 + x52 - 10.0d0*b110 + 7.69741490700595           

      e95 =  - x16 + x53 - 10.0d0*b111 + 7.69741490700595           

      e96 =  - x17 + x54 - 10.0d0*b112 + 7.69741490700595           

      e97 =  - x19 + x50 - 10.0d0*b108 + 7.69741490700595           

      e98 =  - x20 + x51 - 10.0d0*b109 + 7.69741490700595           

      e99 =  - x21 + x52 - 10.0d0*b110 + 7.69741490700595           

      e100 =  - x22 + x53 - 10.0d0*b111 + 7.69741490700595          

      e101 =  - x23 + x54 - 10.0d0*b112 + 7.69741490700595          

      e102 =  - x25 + x50 - 10.0d0*b108 + 7.69741490700595          

      e103 =  - x26 + x51 - 10.0d0*b109 + 7.69741490700595          

      e104 =  - x27 + x52 - 10.0d0*b110 + 7.69741490700595          

      e105 =  - x28 + x53 - 10.0d0*b111 + 7.69741490700595          

      e106 =  - x29 + x54 - 10.0d0*b112 + 7.69741490700595          

      e107 =  - x31 + x50 - 10.0d0*b108 + 7.69741490700595          

      e108 =  - x32 + x51 - 10.0d0*b109 + 7.69741490700595          

      e109 =  - x33 + x52 - 10.0d0*b110 + 7.69741490700595          

      e110 =  - x34 + x53 - 10.0d0*b111 + 7.69741490700595          

      e111 =  - x35 + x54 - 10.0d0*b112 + 7.69741490700595          

      e112 = x37 - 0.693147180559945*b66 - 1.09861228866811*b72 
     /        - 1.38629436111989*b78               

      e113 = x38 - 0.693147180559945*b67 - 1.09861228866811*b73 
     /        - 1.38629436111989*b79               

      e114 = x39 - 0.693147180559945*b68 - 1.09861228866811*b74 
     /        - 1.38629436111989*b80               

      e115 = x40 - 0.693147180559945*b69 - 1.09861228866811*b75 
     /        - 1.38629436111989*b81               

      e116 = x41 - 0.693147180559945*b70 - 1.09861228866811*b76 
     /        - 1.38629436111989*b82               

      e117 = x42 - 0.693147180559945*b71 - 1.09861228866811*b77 
     /        - 1.38629436111989*b83               

      e118 = x43 - 0.693147180559945*b90 - 1.09861228866811*b96 
     /        - 1.38629436111989*b102              

      e119 = x44 - 0.693147180559945*b91 - 1.09861228866811*b97 
     /        - 1.38629436111989*b103              

      e120 = x45 - 0.693147180559945*b92 - 1.09861228866811*b98 
     /        - 1.38629436111989*b104              

      e121 = x46 - 0.693147180559945*b93 - 1.09861228866811*b99 
     /        - 1.38629436111989*b105              

      e122 = x47 - 0.693147180559945*b94 - 1.09861228866811*b100
     /        - 1.38629436111989*b106              

      e123 = x48 - 0.693147180559945*b95 - 1.09861228866811*b101
     /        - 1.38629436111989*b107              

      e124 = b60 + b66 + b72 + b78 - 1.0d0       

      e125 = b61 + b67 + b73 + b79 - 1.0d0       

      e126 = b62 + b68 + b74 + b80 - 1.0d0       

      e127 = b63 + b69 + b75 + b81 - 1.0d0       

      e128 = b64 + b70 + b76 + b82 - 1.0d0       

      e129 = b65 + b71 + b77 + b83 - 1.0d0       

      e130 = b84 + b90 + b96 + b102 - 1.0d0      

      e131 = b85 + b91 + b97 + b103 - 1.0d0      

      e132 = b86 + b92 + b98 + b104 - 1.0d0      

      e133 = b87 + b93 + b99 + b105 - 1.0d0      

      e134 = b88 + b94 + b100 + b106 - 1.0d0     

      e135 = b89 + b95 + b101 + b107 - 1.0d0     

      e136 = b108 + b109 + b110 + b111 + b112 + b113 - 1.0d0     

      e137 = x7 - x8 - 0.693147180559945*b108   

      e138 = x8 - x9 - 0.693147180559945*b109   

      e139 = x9 - x10 - 0.693147180559945*b110  

      e140 = x10 - x11 - 0.693147180559945*b111 

      e141 = x11 - x12 - 0.693147180559945*b112 

      e142 = x13 - x14 - 0.693147180559945*b108 

      e143 = x14 - x15 - 0.693147180559945*b109 

      e144 = x15 - x16 - 0.693147180559945*b110 

      e145 = x16 - x17 - 0.693147180559945*b111 

      e146 = x17 - x18 - 0.693147180559945*b112 

      e147 = x19 - x20 - 0.693147180559945*b108 

      e148 = x20 - x21 - 0.693147180559945*b109 

      e149 = x21 - x22 - 0.693147180559945*b110 

      e150 = x22 - x23 - 0.693147180559945*b111 

      e151 = x23 - x24 - 0.693147180559945*b112 

      e152 = x25 - x26 - 0.693147180559945*b108 

      e153 = x26 - x27 - 0.693147180559945*b109 

      e154 = x27 - x28 - 0.693147180559945*b110 

      e155 = x28 - x29 - 0.693147180559945*b111 

      e156 = x29 - x30 - 0.693147180559945*b112 

      e157 = x31 - x32 - 0.693147180559945*b108 

      e158 = x32 - x33 - 0.693147180559945*b109 

      e159 = x33 - x34 - 0.693147180559945*b110 

      e160 = x34 - x35 - 0.693147180559945*b111 

      e161 = x35 - x36 - 0.693147180559945*b112 

      e162 = x7 - x8 + 0.693147180559945*b108   

      e163 = x8 - x9 + 0.693147180559945*b109   

      e164 = x9 - x10 + 0.693147180559945*b110  

      e165 = x10 - x11 + 0.693147180559945*b111 

      e166 = x11 - x12 + 0.693147180559945*b112 

      e167 = x13 - x14 + 0.693147180559945*b108 

      e168 = x14 - x15 + 0.693147180559945*b109 

      e169 = x15 - x16 + 0.693147180559945*b110 

      e170 = x16 - x17 + 0.693147180559945*b111 

      e171 = x17 - x18 + 0.693147180559945*b112 

      e172 = x19 - x20 + 0.693147180559945*b108 

      e173 = x20 - x21 + 0.693147180559945*b109 

      e174 = x21 - x22 + 0.693147180559945*b110 

      e175 = x22 - x23 + 0.693147180559945*b111 

      e176 = x23 - x24 + 0.693147180559945*b112 

      e177 = x25 - x26 + 0.693147180559945*b108 

      e178 = x26 - x27 + 0.693147180559945*b109 

      e179 = x27 - x28 + 0.693147180559945*b110 

      e180 = x28 - x29 + 0.693147180559945*b111 

      e181 = x29 - x30 + 0.693147180559945*b112 

      e182 = x31 - x32 + 0.693147180559945*b108 

      e183 = x32 - x33 + 0.693147180559945*b109 

      e184 = x33 - x34 + 0.693147180559945*b110 

      e185 = x34 - x35 + 0.693147180559945*b111 

      e186 = x35 - x36 + 0.693147180559945*b112 

      g(1) = e112
      g(2) = e113
      g(3) = e114
      g(4) = e115
      g(5) = e116
      g(6) = e117
      g(7) = e118
      g(8) = e119
      g(9) = e120
      g(10) = e121
      g(11) = e122
      g(12) = e123
      g(13) = e124
      g(14) = e125
      g(15) = e126
      g(16) = e127
      g(17) = e128
      g(18) = e129
      g(19) = e130
      g(20) = e131
      g(21) = e132
      g(22) = e133
      g(23) = e134
      g(24) = e135
      g(25) = e136
      g(26) = e1
      g(27) = e2
      g(28) = e3
      g(29) = e4
      g(30) = e5
      g(31) = e6
      g(32) = e7
      g(33) = e8
      g(34) = e9
      g(35) = e10
      g(36) = e11
      g(37) = e12
      g(38) = e13
      g(39) = e14
      g(40) = e15
      g(41) = e16
      g(42) = e17
      g(43) = e18
      g(44) = e19
      g(45) = e20
      g(46) = e21
      g(47) = e22
      g(48) = e23
      g(49) = e24
      g(50) = e25
      g(51) = e26
      g(52) = e27
      g(53) = e28
      g(54) = e29
      g(55) = e30
      g(56) = e31
      g(57) = e32
      g(58) = e33
      g(59) = e34
      g(60) = e35
      g(61) = e36
      g(62) = e37
      g(63) = e38
      g(64) = e39
      g(65) = e40
      g(66) = e41
      g(67) = e42
      g(68) = e43
      g(69) = e44
      g(70) = e45
      g(71) = e46
      g(72) = e47
      g(73) = e48
      g(74) = e49
      g(75) = e50
      g(76) = e51
      g(77) = e52
      g(78) = e53
      g(79) = e54
      g(80) = e55
      g(81) = e56
      g(82) = e57
      g(83) = e58
      g(84) = e59
      g(85) = e60
      g(86) = -e61
      g(87) = e62
      g(88) = e63
      g(89) = e64
      g(90) = e65
      g(91) = e66
      g(92) = e67
      g(93) = e68
      g(94) = e69
      g(95) = e70
      g(96) = e71
      g(97) = e72
      g(98) = e73
      g(99) = e74
      g(100) = e75
      g(101) = e76
      g(102) = e77
      g(103) = e78
      g(104) = e79
      g(105) = e80
      g(106) = e81
      g(107) = e82
      g(108) = e83
      g(109) = e84
      g(110) = e85
      g(111) = e86
      g(112) = e87
      g(113) = e88
      g(114) = e89
      g(115) = e90
      g(116) = e91
      g(117) = e92
      g(118) = e93
      g(119) = e94
      g(120) = e95
      g(121) = e96
      g(122) = e97
      g(123) = e98
      g(124) = e99
      g(125) = e100
      g(126) = e101
      g(127) = e102
      g(128) = e103
      g(129) = e104
      g(130) = e105
      g(131) = e106
      g(132) = e107
      g(133) = e108
      g(134) = e109
      g(135) = e110
      g(136) = e111
      g(137) = -e137
      g(138) = -e138
      g(139) = -e139
      g(140) = -e140
      g(141) = -e141
      g(142) = -e142
      g(143) = -e143
      g(144) = -e144
      g(145) = -e145
      g(146) = -e146
      g(147) = -e147
      g(148) = -e148
      g(149) = -e149
      g(150) = -e150
      g(151) = -e151
      g(152) = -e152
      g(153) = -e153
      g(154) = -e154
      g(155) = -e155
      g(156) = -e156
      g(157) = -e157
      g(158) = -e158
      g(159) = -e159
      g(160) = -e160
      g(161) = -e161
      g(162) = e162
      g(163) = e163
      g(164) = e164
      g(165) = e165
      g(166) = e166
      g(167) = e167
      g(168) = e168
      g(169) = e169
      g(170) = e170
      g(171) = e171
      g(172) = e172
      g(173) = e173
      g(174) = e174
      g(175) = e175
      g(176) = e176
      g(177) = e177
      g(178) = e178
      g(179) = e179
      g(180) = e180
      g(181) = e181
      g(182) = e182
      g(183) = e183
      g(184) = e184
      g(185) = e185
      g(186) = e186
 
  999 continue
      return
      end
 
      subroutine sep1( mode,     m,     me,  mmax, ncont,  
     /                 nbin,  nint,   nmax,     x,    xl,
     /                   xu,     f,      g,  pnam,  pref, 
     /                  fex )    

*  MINLP written by GAMS Convert at 04/17/01 16:41:11
*  
*  Equation counts
*     Total       E       G       L       N       X
*        32      23       5       4       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        30      28       2       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        99      87      12       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11,
     /        x12, x13, x14, x15, x16, x17, x18, x19, x20, x21,
     /        x22, x23, x24, x25, x26, x27, b28, b29, e1, e2, e3, e4, 
     /        e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, 
     /        e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, 
     /        e28, e29, e30, e31
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SEP1'
         pref  = '\cite{MINLPLib}'
c         fex   = -510.081d0
         fex   = -532.125d0
         ncont = 27
         nint  = 0
         nbin  = 2
         n     = ncont + nbin + nint
         m     = 31
         me    = 22
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 1.0D0
            xu(i) = 50.0d0
         enddo
         do i = 25,ncont
            x(i)  = 0.0D0
            xu(i) = 1.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin 
         y(i) = x(ncont+i) 
      enddo 

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      x8 = x(8)
      x9 = x(9)
      x10 = x(10)
      x11 = x(11)
      x12 = x(12)
      x13 = x(13)
      x14 = x(14)
      x15 = x(15)
      x16 = x(16)
      x17 = x(17)
      x18 = x(18)
      x19 = x(19)
      x20 = x(20)
      x21 = x(21)
      x22 = x(22)
      x23 = x(23)
      x24 = x(24)
      x25 = x(25)
      x26 = x(26)
      x27 = x(27)
      b28 = y(1)
      b29 = y(2)

      f = -(35.0d0*x1 + 30.0d0*x4 - 10.0d0*x5 - 8.0d0*x6 - x9 - x10 
     /     - 4.0d0*x11 - 4.0d0*x12 - 50.0d0*b28 - 2.0d0*b29)

      e1 = -0.55d0*x5 - 0.5d0*x6 + x7     

      e2 = -0.45d0*x5 - 0.5d0*x6 + x8     

      e3 = -x25*x7 + x9               

      e4 = -x25*x8 + x10              

      e5 = -x26*x7 + x11              

      e6 = -x26*x8 + x12              

      e7 = -x27*x7 + x13              

      e8 = -x27*x8 + x14              

      e9 = -x7 + x9 + x11 + x13 + x15 

      e10 = -x8 + x10 + x12 + x14 + x16       

      e11 = -0.85d0*x9 + x17            

      e12 = -0.2d0*x10 + x18            

      e13 = -0.15d0*x9 + x19            

      e14 = -0.8d0*x10 + x20            

      e15 = -0.975d0*x11 + x21          

      e16 = -0.05d0*x12 + x22           

      e17 = -0.025d0*x11 + x23          

      e18 = -0.95d0*x12 + x24           

      e19 = x1 - x13 - x17 - x21     

      e20 = x2 - x14 - x18 - x22     

      e21 = x3 - x15 - x19 - x23     

      e22 = x4 - x16 - x20 - x24     

      e23 = x9 + x10 - 2.5d0*b29       

      e24 = x9 + x10 - 25.0d0*b29        

      e25 = x11 + x12 - 2.5d0*b28      

      e26 = x11 + x12 - 25.0d0*b28       

      e27 = x1 - 4.0d0*x2                

      e28 = -3.0d0*x3 + x4                

      e29 = x1 + x2 - 15.0d0           

      e30 = x3 + x4 - 18.0d0           

      e31 = b28 + b29 - 1.0d0          

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = e5
      g(6) = e6
      g(7) = e7
      g(8) = e8
      g(9) = e9
      g(10) = e10
      g(11) = e11
      g(12) = e12
      g(13) = e13
      g(14) = e14
      g(15) = e15
      g(16) = e16
      g(17) = e17
      g(18) = e18
      g(19) = e19
      g(20) = e20
      g(21) = e21
      g(22) = e22
      g(23) = e23
      g(24) = -e24
      g(25) = e25
      g(26) = -e26
      g(27) = e27
      g(28) = e28
      g(29) = -e29
      g(30) = -e30
      g(31) = e31
  

  999 continue
      return
      end

      subroutine sloppy(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, j, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), u(3), v(2), eps 
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SLOPPY'
         pref  = ''
         ncont = 0
         nint  = 6
         nbin  = 0
         n     = ncont + nbin + nint
         m     = 3
         me    = 0
         fex   = 0.0d0
         do i = 1,n
            xl(i) = -1111.0d0
            x(i)  = -2.0d0
            xu(i) = 1111.0d0
         end do
         x(4) = 3.0d0
         x(5) = 1.0d0
         x(6) = 4.0d0
         goto 999       
      end if    
      
      eps = 1.0d-8

      u(1) = dmax1(dsqrt(x(1)**2 + x(2)**2),eps)
      u(2) = dmax1(dsqrt(x(3)**2 + x(4)**2),eps)
      u(3) = dmax1(dsqrt(x(5)**2 + x(6)**2),eps)
C
      v(1) = x(1)/u(1)**3 + x(3)/u(2)**3 + x(5)/u(3)**3
      v(2) = x(2)/u(1)**3 + x(4)/u(2)**3 + x(6)/u(3)**3
C
      f = dsqrt(v(1)**2 + v(2)**2)
C
      g(1) = 1111.0d0**2 - x(1)**2 - x(2)**2
      g(2) = 1111.0d0**2 - x(3)**2 - x(4)**2
      g(3) = 1111.0d0**2 - x(5)**2 - x(6)**2

  999 continue
      return
      end
      subroutine spectra2(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 04/27/01 14:52:58
*  
*  Equation counts
*     Total       E       G       L       N       X
*        73      10      33      30       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        70      40      30       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       409     169     240       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), 
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, b25, b26, b27, b28, b29, b30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /             x62, x63, x64, x65, x66, x67, x68, x69, x70, 
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPECTRA2'
         pref  = '\cite{MINLPLib}'
         fex   = 13.97831d0
         ncont = 39
         nint  = 0
         nbin  = 30
         n     = ncont + nbin + nint
         m     = 72
         me    = 9
         do i = 1,ncont
            xl(i) = -1.0d3
            x(i)  = 0.0d0
            xu(i) = 1.0d3
         enddo
         do i = 1,30
            xl(i)  = 0.0d0
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x31 = x(1)
      x32 = x(2)
      x33 = x(3)
      x34 = x(4)
      x35 = x(5)
      x36 = x(6)
      x37 = x(7)
      x38 = x(8)
      x39 = x(9)
      x40 = x(10)
      x41 = x(11)
      x42 = x(12)
      x43 = x(13)
      x44 = x(14)
      x45 = x(15)
      x46 = x(16)
      x47 = x(17)
      x48 = x(18)
      x49 = x(19)
      x50 = x(20)
      x51 = x(21)
      x52 = x(22)
      x53 = x(23)
      x54 = x(24)
      x55 = x(25)
      x56 = x(26)
      x57 = x(27)
      x58 = x(28)
      x59 = x(29)
      x60 = x(30)
      x62 = x(31)
      x63 = x(32)
      x64 = x(33)
      x65 = x(34)
      x66 = x(35)
      x67 = x(36)
      x68 = x(37)
      x69 = x(38)
      x70 = x(39)
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y( 4)
      b5 = y( 5)
      b6 = y( 6)
      b7 = y( 7)
      b8 = y( 8)
      b9 = y( 9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      b25 = y(25)
      b26 = y(26)
      b27 = y(27)
      b28 = y(28)
      b29 = y(29)
      b30 = y(30)

      f =  x62 + x63 + x64 + x65 + x66 + x67 + x68 + x69 + 2.0d0*x70
	
      e1 = -((5.02d0 + (-0.0003d0*x31) - 0.0007d0*x32 - 0.0066d0*x33 
     /      - 0.0044d0*x34 - 0.0208d0*x35 - 0.0518d0*x36 - 0.0036d0*x37
     /      - 0.0507d0*x38 - 0.0905d0*x39 - 0.0016d0*x40)*(5.02d0
     /      + (-0.0003d0*x31) - 0.0007d0*x32 - 0.0066d0*x33 
     /      - 0.0044d0*x34 - 0.0208d0*x35 - 0.0518d0*x36 - 0.0036d0*x37 
     /      - 0.0507d0*x38 - 0.0905d0*x39 - 0.0016d0*x40) + (0.97d0
     /      + (-0.0003d0*x41) - 0.0007d0*x42 - 0.0066d0*x43 
     /      - 0.0044d0*x44 - 0.0208d0*x45 - 0.0518d0*x46 - 0.0036d0*x47
     /      - 0.0507d0*x48 - 0.0905d0*x49 - 0.0016d0*x50)*(0.97d0 
     /      + (-0.0003d0*x41) - 0.0007d0*x42 - 0.0066d0*x43 
     /      - 0.0044d0*x44 - 0.0208d0*x45 - 0.0518d0*x46 - 0.0036d0*x47 
     /      - 0.0507d0*x48 - 0.0905d0*x49 - 0.0016d0*x50) 
     /      + (-0.0003d0*x51 - 0.0007d0*x52 - 0.0066d0*x53 
     /      - 0.0044d0*x54 - 0.0208d0*x55 - 0.0518d0*x56 - 0.0036d0*x57
     /      - 0.0507d0*x58 - 0.0905d0*x59 - 0.0016d0*x60)*(-0.0003d0*x51
     /      - 0.0007d0*x52 - 0.0066d0*x53 - 0.0044d0*x54 - 0.0208d0*x55 
     /      - 0.0518d0*x56 - 0.0036d0*x57 - 0.0507d0*x58 - 0.0905d0*x59
     /      - 0.0016d0*x60)) + x62                    

      e2 = -((2.04d0 + (-0.0764d0*x31) - 0.0003d0*x32 - 0.0789d0*x33 
     /      - 0.0186d0*x34 - 0.0605d0*x35 - 0.1656d0*x36 - 0.0035d0*x37
     /      - 0.0361d0*x38 - 0.06d0*x39 - 0.0209d0*x40)*(2.04d0    
     /      + (-0.0764d0*x31) - 0.0003d0*x32 - 0.0789d0*x33 
     /      - 0.0186d0*x34 - 0.0605d0*x35 - 0.1656d0*x36 - 0.0035d0*x37
     /      - 0.0361d0*x38 - 0.06d0*x39 - 0.0209d0*x40) + (3.51d0 
     /      + (-0.0764d0*x41) - 0.0003d0*x42 - 0.0789d0*x43 
     /      - 0.0186d0*x44 - 0.0605d0*x45 - 0.1656d0*x46 - 0.0035d0*x47 
     /      - 0.0361d0*x48 - 0.06d0*x49 - 0.0209d0*x50)*(3.51d0
     /      + (-0.0764d0*x41) - 0.0003d0*x42 - 0.0789d0*x43 
     /      - 0.0186d0*x44 - 0.0605d0*x45 - 0.1656d0*x46 - 0.0035d0*x47
     /      - 0.0361d0*x48 - 0.06d0*x49 - 0.0209d0*x50) + (2.2d0
     /      + (-0.0764d0*x51) - 0.0003d0*x52 - 0.0789d0*x53 
     /      - 0.0186d0*x54 - 0.0605d0*x55 - 0.1656d0*x56 - 0.0035d0*x57 
     /      - 0.0361d0*x58 - 0.06d0*x59 - 0.0209d0*x60)*(2.2d0
     /      + (-0.0764d0*x51) - 0.0003d0*x52 - 0.0789d0*x53 
     /      - 0.0186d0*x54 - 0.0605d0*x55 - 0.1656d0*x56 - 0.0035d0*x57 
     /      - 0.0361d0*x58 - 0.06d0*x59 - 0.0209d0*x60)) + x63    
     
      e3 = -((3.53d0 + (-0.0318d0*x31) - 0.0004d0*x32 - 0.0275d0*x33 
     /      - 0.018d0*x34 - 0.0601d0*x35 - 0.1491d0*x36 - 0.0032d0*x37 
     /      - 0.0433d0*x38 - 0.0754d0*x39 - 0.0063d0*x40)*(3.53d0
     /      + (-0.0318d0*x31) - 0.0004d0*x32 - 0.0275d0*x33 
     /      - 0.018d0*x34 - 0.0601d0*x35 - 0.1491d0*x36 - 0.0032d0*x37 
     /     - 0.0433d0*x38 - 0.0754d0*x39 - 0.0063d0*x40) + (3.51d0
     /     + (-0.0318d0*x41) - 0.0004d0*x42 - 0.0275d0*x43 - 0.018d0*x44
     /     - 0.0601d0*x45 - 0.1491d0*x46 - 0.0032d0*x47 - 0.0433d0*x48 
     /     - 0.0754d0*x49 - 0.0063d0*x50)*(3.51 + (-0.0318d0*x41) 
     /     - 0.0004d0*x42 - 0.0275d0*x43 - 0.018d0*x44 - 0.0601d0*x45 
     /     - 0.1491d0*x46 - 0.0032d0*x47 - 0.0433d0*x48 - 0.0754d0*x49 
     /     - 0.0063d0*x50) + (0.8d0 + (-0.0318d0*x51) - 0.0004d0*x52 
     /     - 0.0275d0*x53 - 0.018d0*x54 - 0.0601d0*x55 - 0.1491d0*x56
     /     - 0.0032d0*x57 - 0.0433d0*x58 - 0.0754d0*x59 - 0.0063d0*x60)
     /     *(0.8d0 + (-0.0318d0*x51) - 0.0004d0*x52 - 0.0275d0*x53 
     /     - 0.018d0*x54 - 0.0601d0*x55 - 0.1491d0*x56 - 0.0032d0*x57 
     /     - 0.0433d0*x58 - 0.0754d0*x59 - 0.0063d0*x60)) + x64 

      e4 = -((7.02d0 + (-0.0007d0*x31) - 0.0009d0*x32 - 0.0043d0*x33 
     /     - 0.0179d0*x34 - 0.0604d0*x35 - 0.1385d0*x36 - 0.0051d0*x37
     /     - 0.0635d0*x38 - 0.1098d0*x39 - 0.001d0*x40)*(7.02d0      
     /     + (-0.0007d0*x31) - 0.0009d0*x32 - 0.0043d0*x33 
     /     - 0.0179d0*x34 - 0.0604d0*x35 - 0.1385d0*x36 - 0.0051d0*x37 
     /     - 0.0635d0*x38 - 0.1098d0*x39 - 0.001d0*x40) + (3.51d0
     /     + (-0.0007d0*x41) - 0.0009d0*x42 - 0.0043d0*x43 
     /     - 0.0179d0*x44 - 0.0604d0*x45 - 0.1385d0*x46 - 0.0051d0*x47 
     /     - 0.0635d0*x48 - 0.1098d0*x49 - 0.001d0*x50)*(3.51d0
     /     + (-0.0007d0*x41) - 0.0009d0*x42 - 0.0043d0*x43 
     /     - 0.0179d0*x44 - 0.0604d0*x45 - 0.1385d0*x46 - 0.0051d0*x47 
     /     - 0.0635d0*x48 - 0.1098d0*x49 - 0.001d0*x50) + (-0.0007d0*x51
     /     - 0.0009d0*x52 - 0.0043d0*x53 - 0.0179d0*x54 - 0.0604d0*x55
     /     - 0.1385d0*x56 - 0.0051d0*x57 - 0.0635d0*x58 - 0.1098d0*x59 
     /     - 0.001d0*x60)*(-0.0007d0*x51 - 0.0009d0*x52 
     /     - 0.0043d0*x53 - 0.0179d0*x54 - 0.0604d0*x55 - 0.1385d0*x56 
     /     - 0.0051d0*x57 - 0.0635d0*x58 - 0.1098d0*x59 - 0.001d0*x60)) 
     /     + x65      
     
      e5 = -((-0.0534d0*x31 - 0.0005d0*x32 - 0.0704d0*x33 - 0.0351d0*x34
     /      - 0.0981d0*x35 - 0.2389d0*x36 - 0.0015d0*x37 - 0.0048d0*x38
     /      - 0.0038d0*x39 - 0.0132d0*x40)*(-0.0534d0*x31 - 0.0005d0*x32
     /      - 0.0704d0*x33 - 0.0351d0*x34 - 0.0981d0*x35 - 0.2389d0*x36
     /      - 0.0015d0*x37 - 0.0048d0*x38 - 0.0038d0*x39 - 0.0132d0*x40)
     /      + (7d0 + (-0.0534d0*x41) - 0.0005d0*x42 - 0.0704d0*x43 
     /      - 0.0351d0*x44 - 0.0981d0*x45 - 0.2389d0*x46 - 0.0015d0*x47 
     /      - 0.0048d0*x48 - 0.0038d0*x49 - 0.0132d0*x50)*(7d0
     /      + (-0.0534d0*x41) - 0.0005d0*x42 - 0.0704d0*x43 
     /      - 0.0351d0*x44 - 0.0981d0*x45 - 0.2389d0*x46 - 0.0015d0*x47 
     /      - 0.0048d0*x48 - 0.0038d0*x49 - 0.0132d0*x50) + (1.4d0
     /      + (-0.0534d0*x51) - 0.0005d0*x52 - 0.0704d0*x53 
     /      - 0.0351d0*x54 - 0.0981d0*x55 - 0.2389d0*x56 - 0.0015d0*x57 
     /      - 0.0048d0*x58 - 0.0038d0*x59 - 0.0132d0*x60)*(1.4d0
     /      + (-0.0534d0*x51) - 0.0005d0*x52 - 0.0704d0*x53
     /      - 0.0351d0*x54 - 0.0981d0*x55 - 0.2389d0*x56 - 0.0015d0*x57
     /      - 0.0048d0*x58 - 0.0038d0*x59 - 0.0132d0*x60)) + x66     

      e6 = -((10.16d0 + (-0.0773d0*x31) - 0.0009d0*x32 - 0.0683d0*x33 
     /      - 0.0024d0*x34 - 0.0025d0*x35 - 0.0248d0*x36 - 0.0094d0*x37
     /      - 0.0891d0*x38 - 0.1443d0*x39 - 0.0203d0*x40)*(10.16d0
     /      + (-0.0773d0*x31) - 0.0009d0*x32 - 0.0683d0*x33 
     /      - 0.0024d0*x34 - 0.0025d0*x35 - 0.0248d0*x36 - 0.0094d0*x37 
     /      - 0.0891d0*x38 - 0.1443d0*x39 - 0.0203d0*x40) 
     /      + (-0.0773d0*x41 - 0.0009d0*x42 - 0.0683d0*x43 
     /      - 0.0024d0*x44 - 0.0025d0*x45 - 0.0248d0*x46 - 0.0094d0*x47 
     /      - 0.0891d0*x48 - 0.1443d0*x49 - 0.0203d0*x50)*(-0.0773d0*x41
     /      - 0.0009d0*x42 - 0.0683d0*x43 - 0.0024d0*x44 - 0.0025d0*x45
     /      - 0.0248d0*x46 - 0.0094d0*x47 - 0.0891d0*x48 - 0.1443d0*x49 
     /      - 0.0203d0*x50) + (2.2 + (-0.0773d0*x51) - 0.0009d0*x52 
     /      - 0.0683d0*x53 - 0.0024d0*x54 - 0.0025d0*x55 - 0.0248d0*x56 
     /      - 0.0094d0*x57 - 0.0891d0*x58 - 0.1443d0*x59 - 0.0203d0*x60)
     /      *(2.2d0 + (-0.0773d0*x51) - 0.0009d0*x52 - 0.0683d0*x53 
     /      - 0.0024d0*x54 - 0.0025d0*x55 - 0.0248d0*x56 - 0.0094d0*x57
     /      - 0.0891d0*x58 - 0.1443d0*x59 - 0.0203d0*x60)) + x67  

      e7 = -((1.04d0 + (-0.0536d0*x31) - 0.0005d0*x32 - 0.0842d0*x33
     /      - 0.0108d0*x34 - 0.0394d0*x35 - 0.1122d0*x36 - 0.0015d0*x37
     /      - 0.0213d0*x38 - 0.042d0*x39 - 0.0139d0*x40)*(1.04d0
     /      + (-0.0536d0*x31) - 0.0005d0*x32 - 0.0842d0*x33 
     /      - 0.0108d0*x34 - 0.0394d0*x35 - 0.1122d0*x36 - 0.0015d0*x37
     /      - 0.0213d0*x38 - 0.042d0*x39 - 0.0139d0*x40) + (2.01d0 
     /      + (-0.0536d0*x41) - 0.0005d0*x42 - 0.0842d0*x43 
     /      - 0.0108d0*x44 - 0.0394d0*x45 - 0.1122d0*x46 - 0.0015d0*x47 
     /      - 0.0213d0*x48 - 0.042d0*x49 - 0.0139d0*x50)*(2.01d0
     /      + (-0.0536d0*x41) - 0.0005d0*x42 - 0.0842d0*x43 
     /      - 0.0108d0*x44 - 0.0394d0*x45 - 0.1122d0*x46 - 0.0015d0*x47
     /      - 0.0213d0*x48 - 0.042d0*x49 - 0.0139d0*x50) + (1.4d0
     /      + (-0.0536d0*x51) - 0.0005d0*x52 - 0.0842d0*x53 
     /      - 0.0108d0*x54 - 0.0394d0*x55 - 0.1122d0*x56 - 0.0015d0*x57
     /      - 0.0213d0*x58 - 0.042d0*x59 - 0.0139d0*x60)*(1.4d0
     /      + (-0.0536d0*x51) - 0.0005d0*x52 - 0.0842d0*x53 
     /      - 0.0108d0*x54 - 0.0394d0*x55 - 0.1122d0*x56 - 0.0015d0*x57 
     /      - 0.0213d0*x58 - 0.042d0*x59 - 0.0139d0*x60)) + x68     

      e8 = -((2.04d0 + (-0.032d0*x31) - 0.0003d0*x32 - 0.0309d0*x33 
     /      - 0.0052d0*x34 - 0.0221d0*x35 - 0.0633d0*x36 - 0.0024d0*x37
     /      - 0.031d0*x38 - 0.0574d0*x39 - 0.0057d0*x40)*(2.04d0
     /      + (-0.032d0*x31) - 0.0003d0*x32 - 0.0309d0*x33 
     /      - 0.0052d0*x34 - 0.0221d0*x35 - 0.0633d0*x36 - 0.0024d0*x37
     /      - 0.031d0*x38 - 0.0574d0*x39 - 0.0057d0*x40) + (0.97d0
     /      + (-0.032d0*x41) - 0.0003d0*x42 - 0.0309d0*x43 
     /      - 0.0052d0*x44 - 0.0221d0*x45 - 0.0633d0*x46 
     /      - 0.0024d0*x47 - 0.031d0*x48 - 0.0574d0*x49 - 0.0057d0*x50)
     /      *(0.97d0 + (-0.032d0*x41) - 0.0003d0*x42 - 0.0309d0*x43 
     /      - 0.0052d0*x44 - 0.0221d0*x45 - 0.0633d0*x46 - 0.0024d0*x47
     /      - 0.031d0*x48 - 0.0574d0*x49 - 0.0057d0*x50) + (0.8d0
     /      + (-0.032d0*x51) - 0.0003d0*x52 - 0.0309d0*x53 
     /      - 0.0052d0*x54 - 0.0221d0*x55 - 0.0633d0*x56 - 0.0024d0*x57 
     /      - 0.031d0*x58 - 0.0574d0*x59 - 0.0057d0*x60)*(0.8d0
     /      + (-0.032d0*x51) - 0.0003d0*x52 - 0.0309d0*x53 
     /      - 0.0052d0*x54 - 0.0221d0*x55 - 0.0633d0*x56 - 0.0024d0*x57 
     /      - 0.031d0*x58 - 0.0574d0*x59 - 0.0057d0*x60)) + x69     

      e9 = x31          

      e10 = x32         

      e11 = x33         

      e12 = x34         

      e13 = x35         

      e14 = x36         

      e15 = x37         

      e16 = x38         

      e17 = x39         

      e18 = x40         

      e19 = x41         

      e20 = x42         

      e21 = x43         

      e22 = x44         

      e23 = x45         

      e24 = x46         

      e25 = x47         

      e26 = x48         

      e27 = x49         

      e28 = x50         

      e29 = x51         

      e30 = x52         

      e31 = x53         

      e32 = x54         

      e33 = x55         

      e34 = x56         

      e35 = x57         

      e36 = x58         

      e37 = x59         

      e38 = x60         

      e39 = -1000d0*b1 + x31    

      e40 = -1000d0*b2 + x32    

      e41 = -1000d0*b3 + x33    

      e42 = -1000d0*b4 + x34    

      e43 = -1000d0*b5 + x35    

      e44 = -1000d0*b6 + x36    

      e45 = -1000d0*b7 + x37    

      e46 = -1000d0*b8 + x38    

      e47 = -1000d0*b9 + x39    

      e48 = -1000d0*b10 + x40   

      e49 = -1000d0*b11 + x41   

      e50 = -1000d0*b12 + x42   

      e51 = -1000d0*b13 + x43   

      e52 = -1000d0*b14 + x44   

      e53 = -1000d0*b15 + x45   

      e54 = -1000d0*b16 + x46   

      e55 = -1000d0*b17 + x47   

      e56 = -1000d0*b18 + x48   

      e57 = -1000d0*b19 + x49   

      e58 = -1000d0*b20 + x50   

      e59 = -1000d0*b21 + x51   

      e60 = -1000d0*b22 + x52   

      e61 = -1000d0*b23 + x53   

      e62 = -1000d0*b24 + x54   

      e63 = -1000d0*b25 + x55   

      e64 = -1000d0*b26 + x56   

      e65 = -1000d0*b27 + x57   

      e66 = -1000d0*b28 + x58   

      e67 = -1000d0*b29 + x59   

      e68 = -1000d0*b30 + x60   

      e69 = b1 + b2 + b3 + b4 + b5 + b6 + b7 + b8 + b9 + b10 

      e70 = b11 + b12 + b13 + b14 + b15 + b16 + b17 + b18 + b19 + b20  

      e71 = b21 + b22 + b23 + b24 + b25 + b26 + b27 + b28 + b29 + b30 

      e72 = -b1 - b2 - b3 - b4 - b5 - b6 - b7 - b8 - b9 - b10 - b11 
     /       - b12 - b13 - b14 - b15 - b16 - b17 - b18 - b19 - b20 - b21
     /       - b22 - b23 - b24 - b25 - b26 - b27 - b28 - b29 - b30 + x70

      g(1) = e1
      g(2) = e2
      g(3) = e3
      g(4) = e4
      g(5) = e5
      g(6) = e6
      g(7) = e7
      g(8) = e8
      g(9) = e72
      g(10) = e9
      g(11) = e10
      g(12) = e11
      g(13) = e12
      g(14) = e13
      g(15) = e14
      g(16) = e15
      g(17) = e16
      g(18) = e17
      g(19) = e18
      g(20) = e19
      g(21) = e20
      g(22) = e21
      g(23) = e22
      g(24) = e23
      g(25) = e24
      g(26) = e25
      g(27) = e26
      g(28) = e27
      g(29) = e28
      g(30) = e29
      g(31) = e30
      g(32) = e31
      g(33) = e32
      g(34) = e33
      g(35) = e34
      g(36) = e35
      g(37) = e36
      g(38) = e37
      g(39) = e38
      g(40) = -e39
      g(41) = -e40
      g(42) = -e41
      g(43) = -e42
      g(44) = -e43
      g(45) = -e44
      g(46) = -e45
      g(47) = -e46
      g(48) = -e47
      g(49) = -e48
      g(50) = -e49
      g(51) = -e50
      g(52) = -e51
      g(53) = -e52
      g(54) = -e53
      g(55) = -e54
      g(56) = -e55
      g(57) = -e56
      g(58) = -e57
      g(59) = -e58
      g(60) = -e59
      g(61) = -e60
      g(62) = -e61
      g(63) = -e62
      g(64) = -e63
      g(65) = -e64
      g(66) = -e65
      g(67) = -e66
      g(68) = -e67
      g(69) = -e68
      g(70) = e69
      g(71) = e70
      g(72) = e71
         
      do i=40,59
         g(i) = 0.001d0*g(i)
      end do   
     
  999 continue
      return
      end
 

      subroutine splitf1( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i, j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF1'
         pref  = '\cite{ELS11}'
         fex   = -0.16045d4 
         ncont = 3
         nint  = 0
         nbin  = 9
         n     = ncont + nbin + nint
         m     = 9
         me    = 3
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         end do 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      
      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 600.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      end do
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      end do      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      end do      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         end do
         g(2*ncont+i) = (q - sum)/q
      end do      
            
  999 continue
      return
      end

      subroutine splitf2( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF2'
         pref  = '\cite{ELS11}'
         fex   = -0.18d4 
         ncont = 6
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100
            x(i) = 1
         enddo 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 600.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      enddo
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      enddo      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      enddo      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         enddo
         g(2*ncont+i) = (q - sum)/q
      enddo      
            
  999 continue
      return
      end

      subroutine splitf3( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF3'
         pref  = '\cite{ELS11}'
         fex   = -0.25082919d4  
         ncont = 6
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         end do 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      
      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q    = 900.0d0
      ms   = nbin/ncont
      f    = 0.0d0
      do i=1,ncont
         f = f - x(i)
      end do
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         end do
         g(j) = sum - 1.0d0
      end do      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      end do      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         end do
         g(2*ncont+i) = (q - sum)/q
      end do      
            
  999 continue
      return
      end

      subroutine splitf4( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF4'
         pref  = '\cite{ELS11}'
         fex   =  -0.26265882d4  
         ncont = 6
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         enddo 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 1000.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      enddo
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      enddo      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      enddo      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         enddo
         g(2*ncont+i) = (q - sum)/q
      enddo      
            
  999 continue
      return
      end

      subroutine splitf5( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF5'
         pref  = '\cite{ELS11}'
         fex   = -0.28045d4  
         ncont = 6
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         enddo 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 1200.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      enddo
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      enddo      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      enddo      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         enddo
         g(2*ncont+i) = (q - sum)/q
      enddo      
            
  999 continue
      return
      end

      subroutine splitf6( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF6'
         pref  = '\cite{ELS11}'
         fex   = -0.30995d4  
         ncont = 6
         nint  = 0
         nbin  = 18
         n     = ncont + nbin + nint
         m     = 15
         me    = 6
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         enddo 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 1500.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      enddo
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      enddo      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      enddo      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         enddo
         g(2*ncont+i) = (q - sum)/q
      enddo      
            
  999 continue
      return
      end

      subroutine splitf7( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF7'
         pref  = '\cite{ELS11}'
         fex   = -0.26161669D+04
c         fex   = -0.25806D4   
         ncont = 9
         nint  = 0
         nbin  = 27
         n     = ncont + nbin + nint
         m     = 21
         me    = 9
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         end do 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      
      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q    = 900.0d0
      ms   = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      end do
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         end do
         g(j) = sum - 1.0d0
      end do      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      end do      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         end do
         g(2*ncont+i) = (q - sum)/q
      end do      
            
  999 continue
      return
      end

      subroutine splitf8( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, ms, i,
     /        j, mode
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF8'
         pref  = '\cite{ELS11}'
         fex   = -0.30406261d4  
         ncont = 9
         nint  = 0
         nbin  = 27
         n     = ncont + nbin + nint
         m     = 21
         me    = 9
         do i = 1,ncont
            xl(i) = 0.0D0
            x(i)  = 1.0d0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
         enddo 
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0D0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo 
         goto 999       
      endif
      
      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 1200.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      enddo
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      enddo      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      enddo      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         enddo
         g(2*ncont+i) = (q - sum)/q
      enddo      
            
  999 continue
      return
      end

      subroutine splitf9( mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, j, mode, ms
      double precision x(nmax), y(1000), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), c(3), aj, bj, q, sum
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPLITF9'
         pref  = '\cite{ELS11}'
         fex   = -0.34045d4
         ncont = 9
         nint  = 0
         nbin  = 27
         n     = ncont + nbin + nint
         m     = 21
         me    = 9
         do i = 1,ncont
            xl(i) = 0.0D0
            xu(i) = 1000.0d0 - dble(i)*100.0d0
            x(i) = 1.0d0
         end do 
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         end do
         goto 999       
      end if
      
      do i=1,nbin
         y(i) = x(ncont+i)
      end do   

      c(1) = 50.0d0
      c(2) = 10.0d0
      c(3) = 5.0d0
      q = 1500.0d0
      ms = nbin/ncont
      f = 0.0d0
      do i=1,ncont
         f = f - x(i)
      end do
      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + y((j-1)*ms+i)
         enddo
         g(j) = sum - 1.0d0
      end do      
      do j=1,ncont
         sum = 0.0d0
         do i=1,ms
            sum = sum + c(i)*y((j-1)*ms+i)
         enddo
         aj = 100.0d0 - dble(j)*10.0d0
         bj = (1.0d0 - aj)/(1000.0d0 - dble(j)*100.0d0) 
         g(ncont+j) = (aj + bj*x(j) - sum)/aj
      end do      
      do i=1,ms
         sum = 0.0d0
         do j=1,ncont
            sum = sum + x(j)*y((j-1)*ms+i)
         end do
         g(2*ncont+i) = (q - sum)/q
      end do      
            
  999 continue
      return
      end

      subroutine spring( mode,     m,     me,  mmax, ncont,  
     /                   nbin,  nint,   nmax,     x,    xl,
     /                     xu,     f,      g,  pnam,  pref,
     /                    fex )    

*  MINLP written by GAMS Convert at 04/27/01 14:53:07
*  
*  Equation counts
*     Total       E       G       L       N       X
*         9       6       0       3       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        18       6      11       1       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        44      30      14       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me,ncont, nint, nbin, n, nmax, mmax, mode, i
      double precision x(nmax), xl(nmax), xu(nmax), f, fex, 
     /        g(mmax), x1, x2, x3, i4, x5, x6, b7, b8, b9, b10, b11, 
     /        b12, b13, b14, b15, b16, b17
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'SPRING'
         pref  = '\cite{MINLPLib}'
         fex   = 0.8462457d0  
         ncont = 5
         nint  = 1
         nbin  = 11
         n     = ncont + nbin + nint
         m     = 8
         me    = 5
         xl(1)  = 0.414d0
         x(1)   = 0.5d0
         xu(1)  = 10.0d0
         xl(2)  = 0.207d0
         x(2)   = 100.0d0
         xu(2)  = 100.0d0
         xl(3)  = 0.00178571428571429d0 
         x(3)   = 0.002d0 
         xu(3)  = 0.02d0
         xl(4)  = 1.1d0 
         x(4)   = 1.5d0 
         xu(4)  = 10.0d0
         xl(5)  = 1.0d0 
         x(5)   = 1.0d0
         xu(5)  = 10.0d0
         do i=ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xl(n) = 1.0d0
         x(n)  = 1.0d0
         xu(n) = 10.0d0
         goto 999       
      endif
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      i4 = x(17)
      x5 = x(4)
      x6 = x(5)
      b7 = x(6)
      b8 = x(7)
      b9 = x(8)
      b10 = x(9)
      b11 = x(10)
      b12 = x(11)
      b13 = x(12)
      b14 = x(13)
      b15 = x(14)
      b16 = x(15)
      b17 = x(16)
      
      f = (1.570796327d0 + 0.7853981635d0*i4)*x1*x2**2

      g(1) = - x1/x2 + x5

      g(2) = - ((4.0d0*x5 - 1.0d0)/(4.0d0*x5 - 4.0d0) + 0.615d0/x5) + x6

      g(3) = -6.95652173913044d-7*i4*x5**3/x2 + x3

      g(4) = x2 - 0.207d0*b7 - 0.225D0*b8 - 0.244d0*b9 - 0.263d0*b10 
     /       - 0.283d0*b11 - 0.307d0*b12 - 0.331d0*b13 - 0.362d0*b14 
     /       - 0.394d0*b15 - 0.4375d0*b16 - 0.5d0*b17

      g(5) = b7 + b8 + b9 + b10 + b11 + b12 + b13 + b14 + b15 
     /       + b16 + b17 - 1.0d0

      g(6) = -2546.47908913782d0*x6*x5/x2**2 + 189000.0d0

      g(7) = -(2.1d0 + 1.05d0*i4)*x2 - 1000.0d0*x3 + 14.0d0

      g(8) = -x1 - x2 + 3.0d0

  999 continue
      return
      end

      subroutine st_e13(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 11:35:05
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         3       1       0       2       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         3       2       1       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
* 
*  Nonzero counts
*     Total   const      NL     DLL
*         7       6       1       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, mode
      double precision x(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), x2, b1, e1, e2
     /        
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E13'
         pref  = '\cite{MINLPLib}'
         fex   = 0.22360680D+1
         ncont = 1
         nint  = 0
         nbin  = 1
         n     = ncont + nbin + nint
         m     = 2
         me    = 0
         xl(1) = 0.0d0
         x(1)  = 1.0d0
         xu(1) = 1.6d0
         xl(2) = 0.0d0
         x(2)  = 0.0d0
         xu(2) = 1.0d0
         goto 999       
      endif

      b1 = x(2)
      x2 = x(1)

      f =  b1 + 2.0D0*x2

      g(1) = x2*x2 + b1 - 1.25d0 
      g(2) = -b1 - x2 + 1.6d0

  999 continue
      return
      end
  
      subroutine st_e14(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 16:26:45
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*        14       5       0       9       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        12       8       4       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        40      23      17       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), power,
     /         x1,  x2,  x3,  x4,  x5,  x6,  x7,  b8,  b9, b10,
     /        b11,
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E14'
         pref  = '\cite{MINLPLib}'
         fex   = 4.57958240244d0
         ncont = 7
         nint  = 0
         nbin  = 4
         n     = ncont + nbin + nint
         m     = 13
         me    = 4
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         xu(1) = 10.0d0
         xu(2) = 10.0d0 
         xu(3) = 10.0d0 
         xu(4) = 1.0d0  
         xu(5) = 1.0d0  
         xu(6) = 1.0d0  
         xu(7) = 1.0d0  
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      x5 = x(5)
      x6 = x(6)
      x7 = x(7)
      b8 = y(1)
      b9 = y(2)
      b10 = y(3)
      b11 = y(4)

      f = power(x4 - 1.0d0,2) + power(x5 - 2.0d0,2) 
     /    + power(x6 - 1.0d0,2) - dlog(1.0d0 + x7) 
     /    + power(x1 - 1.0d0,2) + power(x2 - 2.0d0,2)
     /    + power(x3 - 3.0d0,2)

      e1 = x1 + x2 + x3 + b8 + b9 + b10 - 5.0d0        

      e2 = power(x6,2) + power(x1,2) + power(x2,2) + power(x3,2) - 5.5d0

      e3 = x1 + b8 - 1.2d0                           

      e4 = x2 + b9 - 1.8d0                           

      e5 = x3 + b10 - 2.5d0                          

      e6 = x1 + b11 - 1.2d0                          

      e7 = power(x5,2) + power(x2,2) - 1.64d0 

      e8 = power(x6,2) + power(x3,2) - 4.25d0           

      e9 = power(x5,2) + power(x3,2) - 4.64d0           

      e10 = x4 - b8

      e11 = x5 - b9

      e12 = x6 - b10                                 

      e13 = x7 - b11                                 

      g(1) = e10
      g(2) = e11
      g(3) = e12
      g(4) = e13
      g(5) = -e1
      g(6) = -e2
      g(7) = -e3
      g(8) = -e4
      g(9) = -e5
      g(10) = -e6
      g(11) = -e7
      g(12) = -e8
      g(13) = -e9

  999 continue
      return
      end
    
      subroutine st_e15(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 11:44:36
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         6       3       0       3       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         6       3       3       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        17      15       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), power, x1, x2, b3, b4, b5, e2, e3, e4, e5, e6

      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E15'
         pref  = '\cite{MINLPLib}'
c ... our best solution:   fex = 3.1950d0         
         fex   = 7.66718006883d0
         ncont = 2
         nint  = 0
         nbin  = 3
         n     = ncont + nbin + nint
         m     = 5
         me    = 2
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         xu(1) = 10.0d0                                              
         xu(2) = 10.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo                                     
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo 
  
      x1 = x(1)
      x2 = x(2)
      b3 = y(1)
      b4 = y(2)
      b5 = y(3)

      f = 2.0d0*x1 + 3.0d0*x2 + 1.5d0*b3 + 2.0d0*b4 - 0.5d0*b5   
                                            
      e2 = power(x1,2) + b3 - 1.25d0 

      e3 = x2**1.5 + 1.5*b4 - 3.0d0    

      e4 = x1 + b3 - 1.6d0        

      e5 = 1.333d0*x2 + b4 - 3.0d0    

      e6 = -b3 - b4 + b5              

      g(1) = e2
      g(2) = e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6

  999 continue
      return
      end
    
      subroutine st_e27(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 11:35:05
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         7       1       0       6       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*         5       3       2       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        17      15       2       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), sqr, b1, b2, x3, x4, e1, e2, e3, e4, e5, e6
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E27'
         pref  = '\cite{MINLPLib}'
         fex   = 2.0d0
         ncont = 2
         nint  = 0
         nbin  = 2
         n     = ncont + nbin + nint
         m     = 6
         me    = 0
         do i = 1,ncont
            xl(i) = -1.0d6
            x(i)  = 1.0d0
            xu(i) = 1.0d6
         enddo
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         xu(3) = 6.0d0 
         xu(4) = 5.0d0                                      
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      b1 = y(1)
      b2 = y(2)
      x3 = x(1)
      x4 = x(2)

      f  = (4.0d0*x3 - sqr(x3) - sqr(x4) + 2.0d0*x4) +2.0d0*b1 
     /     + 2.0d0*b2 + 2.0d0

      e1 = -x3 + 3.0d0*x4 - 5.0d0                           

      e2 = 2.0d0*x3 - x4 - 5.0d0                           

      e3 = -2.0d0*x3 + x4                                 

      e4 = x3 - 3*x4                                 

      e5 = -6.0d0*b1 + x3                                 

      e6 = -5.0d0*b2 + x4                                 

      g(1) = -e1
      g(2) = -e2
      g(3) = -e3
      g(4) = -e4
      g(5) = -e5
      g(6) = -e6

  999 continue
      return
      end
 
      subroutine st_e29(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 12:08:43
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*         8       3       0       5       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*        12       4       8       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*        31      25       6       0
*
*  Solve m using MINLP minimizing objvar;

      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /        g(mmax), x1, x2, x3, b4, b5, b6, b7, b8, b9, b10, b11,
     /        e2, e3, e4, e5, e6, e7, e8, xlog
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E29'
         pref  = '\cite{MINLPLib}'
         fex   = -0.9434705d0    
         ncont = 3
         nint  = 0
         nbin  = 8
         n     = ncont + nbin + nint
         m     = 7
         me    = 2
         do i = 1,ncont
            xl(i) = 0.0d0
            x(i)  = 0.5d0
            xu(i) = 1.0d0
         enddo
         xu(1) = 0.997d0
         xu(2) = 0.9985d0                                             
         xu(3) = 0.9988d0                                            
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   

      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      b4 = y(1)
      b5 = y(2)
      b6 = y(3)
      b7 = y(4)
      b8 = y(5)
      b9 = y(6)
      b10 = y(7)
      b11 = y(8)

      f  = -x1*x2*x3  

      e2 = -xlog(1.0d0 - x1) - 2.30258509299405d0*b4 
     /     - 1.6094379124341d0*b5 - 1.89711998488588d0*b6       

      e3 = -xlog(1.0d0 - x2) - 2.99573227355399d0*b7 
     /     - 1.6094379124341d0*b8 - 1.89711998488588d0*b9      

      e4 = -xlog(1.0d0 - x3) - 3.91202300542815d0*b10 
     /     - 2.81341071676004d0*b11   

      e5 = -b4 - b5 - b6 + 1.0d0    

      e6 = -b7 - b8 - b9 + 1.0d0    

      e7 = -b10 - b11 + 1.0d0       

      e8 = 3.0d0*b4 + b5 + 2.0d0*b6 + 3.0d0*b7 + 2.0d0*b8 + b9 
     /     + 3.0d0*b10 + 2.0d0*b11 - 10.0d0              

      g(1) = e2
      g(2) = e3
      g(3) = -e4
      g(4) = -e5
      g(5) = -e6
      g(6) = -e7
      g(7) = -e8

  999 continue
      return
      end
  
      subroutine st_e31(  mode,     m,     me,  mmax, ncont,  
     /                    nbin,  nint,   nmax,     x,    xl,
     /                      xu,     f,      g,  pnam,  pref,
     /                     fex )    

*  MINLP written by GAMS Convert at 08/29/02 11:35:05
*  
*  Equation counts
*     Total       E       G       L       N       X       C
*       136      82      28      26       0       0       0
*  
*  Variable counts
*                 x       b       i     s1s     s2s      sc      si
*     Total    cont  binary integer    sos1    sos2   scont    sint
*       113      89      24       0       0       0       0       0
*  FX     0       0       0       0       0       0       0       0
*  
*  Nonzero counts
*     Total   const      NL     DLL
*       314     300      14       0
*
*  Solve m using MINLP minimizing objvar;

      implicit none
      integer m, me, n, ncont, nint, nbin, nmax, mmax, i, mode
      double precision x(nmax), y(nmax), xl(nmax), xu(nmax), f, fex,
     /       g(mmax), sqr,
     /         b1,  b2,  b3,  b4,  b5,  b6,  b7,  b8,  b9, b10,
     /        b11, b12, b13, b14, b15, b16, b17, b18, b19, b20,
     /        b21, b22, b23, b24, x25, x26, x27, x28, x29, x30,
     /        x31, x32, x33, x34, x35, x36, x37, x38, x39, x40,
     /        x41, x42, x43, x44, x45, x46, x47, x48, x49, x50,
     /        x51, x52, x53, x54, x55, x56, x57, x58, x59, x60,
     /        x61, x62, x63, x64, x65, x66, x67, x68, x69, x70,
     /        x71, x72, x73, x74, x75, x76, x77, x78, x79, x80,
     /        x81, x82, x83, x84, x85, x86, x87, x88, x89, x90,
     /        x91, x92, x93, x94, x95, x96, x97, x98, x99,x100,
     /       x101,x102,x103,x104,x105,x106,x107,x108,x109,x110,
     /       x111,x112
      double precision
     /         e1,  e2,  e3,  e4,  e5,  e6,  e7,  e8,  e9, e10,
     /        e11, e12, e13, e14, e15, e16, e17, e18, e19, e20,
     /        e21, e22, e23, e24, e25, e26, e27, e28, e29, e30,
     /        e31, e32, e33, e34, e35, e36, e37, e38, e39, e40,
     /        e41, e42, e43, e44, e45, e46, e47, e48, e49, e50,
     /        e51, e52, e53, e54, e55, e56, e57, e58, e59, e60,
     /        e61, e62, e63, e64, e65, e66, e67, e68, e69, e70,
     /        e71, e72, e73, e74, e75, e76, e77, e78, e79, e80,
     /        e81, e82, e83, e84, e85, e86, e87, e88, e89, e90,
     /        e91, e92, e93, e94, e95, e96, e97, e98, e99,e100,
     /       e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,
     /       e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,
     /       e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,
     /       e131,e132,e133,e134,e135
      character*30 pnam, pref

      if (mode.eq.0) then
         pnam  = 'ST_E31'
         pref  = '\cite{MINLPLib}'
         fex   = -2.0d0    
         ncont = 88
         nint  = 0
         nbin  = 24
         n     = ncont + nbin + nint
         m     = 135
         me    = 81
         do i = 1,10
            xl(i) = -1.0d0
            x(i)  = 1.0d0
            xu(i) = 1.0d0
         enddo
         do i = 11,73
            xl(i) = -3.0d0
            x(i)  = 1.0d0
            xu(i) = 3.0d0
         enddo
         do i = 74,ncont
            xl(i) = -6.0d0
            x(i)  = 1.0d0
            xu(i) = 6.0d0
         enddo
         xl(11) = -1.0d4
         xl(12) = -1.0d4
         xl(13) = -1.0d4
         xl(21) = -1.0d4
         xl(9) = -1.0d4
         xl(11) = 0.0d0
         xl(12) = 0.0d0
         xl(39) = 0.0d0
         xl(41) = 0.0d0
         xl(43) = 0.0d0
         xl(45) = 0.0d0
         xl(47) = 0.0d0
         xl(49) = 0.0d0
         xl(51) = 0.0d0
         xl(53) = 0.0d0
         xl(55) = 0.0d0
         xl(57) = 0.0d0
         xl(59) = 0.0d0
         do i=61,73
            xl(i) = 0.0d0
         enddo   
         xl(78) = 0.0d0
         xl(79) = 0.0d0
         xl(80) = 0.0d0
         xl(81) = 0.0d0
         xl(85) = 0.0d0
         xl(86) = 0.0d0
         xl(87) = 0.0d0
         xl(88) = 0.0d0
         do i = ncont+1,ncont+nbin
            xl(i) = 0.0d0
            x(i)  = 0.0d0
            xu(i) = 1.0d0
         enddo
         goto 999       
      endif

      do i=1,nbin
         y(i) = x(ncont+i)
      enddo   
      
      b1 = y(1)
      b2 = y(2)
      b3 = y(3)
      b4 = y(4)
      b5 = y(5)
      b6 = y(6)
      b7 = y(7)
      b8 = y(8)
      b9 = y(9)
      b10 = y(10)
      b11 = y(11)
      b12 = y(12)
      b13 = y(13)
      b14 = y(14)
      b15 = y(15)
      b16 = y(16)
      b17 = y(17)
      b18 = y(18)
      b19 = y(19)
      b20 = y(20)
      b21 = y(21)
      b22 = y(22)
      b23 = y(23)
      b24 = y(24)
      x25 = x(1)
      x26 = x(2)
      x27 = x(3)
      x28 = x(4)
      x29 = x(5)
      x30 = x(6)
      x31 = x(7)
      x32= x(8)
      x33 = x(9)
      x34 = x(10)
      x35 = x(11)
      x36 = x(12)
      x37 = x(13)
      x38 = x(14)
      x39 = x(15)
      x40 = x(16)
      x41 = x(17)
      x42 = x(18)
      x43 = x(19)
      x44 = x(20)
      x45 = x(21)
      x46 = x(22)
      x47 = x(23)
      x48 = x(24)
      x49 = x(25)
      x50 = x(26)
      x51 = x(27)
      x52 = x(28)
      x53 = x(29)
      x54 = x(30)
      x55 = x(31)
      x56 = x(32)
      x57 = x(33)
      x58 = x(34)
      x59 = x(35)
      x60 = x(36)
      x61 = x(37)
      x62 = x(38)
      x63 = x(39)
      x64 = x(40)
      x65 = x(41)
      x66 = x(42)
      x67 = x(43)
      x68 = x(44)
      x69 = x(45)
      x70 = x(46)
      x71 = x(47)
      x72 = x(48)
      x73 = x(49)
      x74 = x(50)
      x75 = x(51)
      x76 = x(52)
      x77 = x(53)
      x78 = x(54)
      x79 = x(55)
      x80 = x(56)
      x81 = x(57)
      x82 = x(58)
      x83 = x(59)
      x84 = x(60)
      x85 = x(61)
      x86 = x(62)
      x87 = x(63)
      x88 = x(64)
      x89 = x(65)
      x90 = x(66)
      x91 = x(67)
      x92 = x(68)
      x93 = x(69)
      x94 = x(70)
      x95 = x(71)
      x96 = x(72)
      x97 = x(73)
      x98 = x(74)
      x99 = x(75)
      x100 = x(76)
      x101 = x(77)
      x102 = x(78)
      x103 = x(79)
      x104 = x(80)
      x105 = x(81)
      x106 = x(82)
      x107 = x(83)
      x108 = x(84)
      x109 = x(85)
      x110 = x(86)
      x111 = x(87)
      x112 = x(88)
      
      f = -x112 

      e1 = -x36*x31 - x25 + x27                  

      e2 = -x36*x32 - x26 + x28                  

      e3 = (-x37*x31) - x35*x33 - x25 + x29        

      e4 = (-x37*x32) - x35*x34 - x26 + x30        

      e5 = sqr(x31) + sqr(x32) - 1.0d0               

      e6 = x32 + x33                            

      e7 = -x31 + x34                            

      e8 = -x36 + x112                           

      e9 = -x35 + x112                           

      e10 = -x25 - x50                           

      e11 = -x25 + x39 - 1.0d0                     

      e12 = -x25 + 0.8944d0*x40 - 0.4472d0*x52 - 1.0d0 

      e13 = -x25 - 0.8944d0*x41 - 0.4772d0*x53 - 1.0d0 

      e14 = -x27 - x54                           

      e15 = -x27 + x43 - 1.0d0                     

      e16 = -x27 + 0.8944d0*x44 - 0.4472d0*x56 - 1.0d0 

      e17 = -x27 - 0.8944d0*x45 - 0.4772d0*x57 - 1.0d0 

      e18 = -x29 - x58                           

      e19 = -x29 + x47 - 1.0d0                     

      e20 = -x29 + 0.8944d0*x48 - 0.4472d0*x60 - 1.0d0 

      e21 = -x29 - 0.8944d0*x49 - 0.4772d0*x61 - 1.0d0 

      e22 = -x26 + x38 - 1.0d0                     

      e23 = -x26 + x51                           

      e24 = -x26 + 0.4472d0*x40 + 0.8944d0*x52       

      e25 = -x26 + 0.4772d0*x41 - 0.8944d0*x53       

      e26 = -x28 + x42 - 1.0d0                     

      e27 = -x28 + x55                           

      e28 = -x28 + 0.4472d0*x44 + 0.8944d0*x56       

      e29 = -x28 + 0.4772d0*x45 - 0.8944d0*x57       

      e30 = -x30 + x46 - 1.0d0                     

      e31 = -x30 + x59                           

      e32 = -x30 + 0.4472d0*x48 + 0.8944d0*x60       

      e33 = -x30 + 0.4772d0*x49 - 0.8944d0*x61       

      e34 = -3.5d0*b1 - x62                        

      e35 = -3.5d0*b3 - x64                        

      e36 = -3.5d0*b5 - x66                        

      e37 = -3.5d0*b7 - x68                        

      e38 = -3.5d0*b9 - x70                        

      e39 = -3.5d0*b11 - x72                       

      e40 = -3.5d0*b13 - x74                       

      e41 = -3.5d0*b15 - x76                       

      e42 = -3.5d0*b17 - x78              