C*********************************************
C                                            *
C   PROGRAM   : PCOMP                        *
C   MODULE    : PL (LARGE COMPILER)          *
C   ABSTRACT  : FORTRAN PRECOMPILER          *
C   KEY WORD  : AUTOMATIC DIFFERENTIATION    *
C   SOURCE    : PCOMP 2.3 by M.LIEPELT       *
C               PCOMP 3.0 by M.DOBMANN       *
C   COPYRIGHT : C.TRASSL, K.SCHITTKOWSKI     *
C               MATHEMATISCHES INSTITUT,     *
C               UNIVERSITAET BAYREUTH,       *
C               D-95440 BAYREUTH, GERMANY    *
C   DATE      : JUNE 8, 1999                 *
C   VERSION   : 5.5                          *
C                                            *
C*********************************************
C
C
C
      SUBROUTINE YYPAR (INPUT,WA,LWA,IWA,LIWA,PLWA,PLIWA,MODE,IERR,LNUM,
     1                  DBGFIL,DBGLVL)
C
      PARAMETER (MAXCOLS=128)
      INTEGER INPUT
      INTEGER LWA,LIWA,PLWA,PLIWA,MODE,IERR,LNUM
      INTEGER IWA(LIWA)
      DOUBLE PRECISION WA(LWA)
C ------------------------------------------------------
      INTEGER DBGFIL,DBGLVL
      LOGICAL DEBUG
      INTEGER PSLVL
      LOGICAL PSCHK
C ------------------------------------------------------
      INTEGER INFOLI(15)
      INTEGER VEK3(3),VEK4(4),VEK5(5),VEK7(7)
      INTEGER IHELP1,IHELP2,IHELP3,IHELP4,IHELP5,IPOL
C  
      DOUBLE PRECISION HELP3,HELP4,HELP6
      INTEGER IIS,VIS,IIC,VIC,IRC,VRC,IVA,VVA,IFN,VPF,IV
      PARAMETER (IIS=1,VIS=2,IIC=3,VIC=4,IRC=5,VRC=6,IVA=7,VVA=8)
      PARAMETER (IFN=9,VPF=14,IV=15)
C
      INTEGER ADD,SUB,MULT,DIV,POWER,ASSIGN
      INTEGER RELOP,AND,OR,NOT,INUM,RNUM,SUM,PROD,IF
      INTEGER ENDIF,STDRD,EXTERN,INDEX,REAL,INT
      INTEGER CONINT,LININT,SPLINE,VAR,FUNC,GOTO,CONTIN
      INTEGER UMINUS,INDVAR,ENDSUM,ENDPRD,BEQ,BRA
      PARAMETER (ADD=43,SUB=45,MULT=42,DIV=47,POWER=94)
      PARAMETER (ASSIGN=61,RELOP=258)
      PARAMETER (AND=259,OR=260,NOT=261,INUM=262,RNUM=263)
      PARAMETER (SUM=265,PROD=266,IF=268)
      PARAMETER (ENDIF=271,STDRD=272,EXTERN=273)
      PARAMETER (INDEX=276,REAL=277,INT=278,CONINT=280)
      PARAMETER (LININT=281,SPLINE=282,VAR=283,FUNC=285)
      PARAMETER (GOTO=287,CONTIN=289,UMINUS=290)
      PARAMETER (INDVAR=291,ENDSUM=292,ENDPRD=293,BEQ=294,BRA=295)
C
      INTEGER YYEXCA(0:17),YYACT(0:531),YYPACT(0:387),YYPGO(0:55)
      INTEGER YYR1(0:138),YYR2(0:138),YYCHK(0:387),YYDEF(0:387)
      CHARACTER*10 YYTNAM(0:44)
      INTEGER YYTVAL(0:44)
      CHARACTER*100 YYREDS(0:138)
      INTEGER YYRLEN(0:138)
C
      INTEGER YYMDEP,YYERRC,YYLAST,YYFLAG,YYACPT
      INTEGER YYABRT
      PARAMETER (YYMDEP=150,YYERRC=256)
      PARAMETER (YYLAST=532,YYFLAG=-3000,YYACPT=0,YYABRT=31)
C
      INTEGER YYV(0:YYMDEP-1),YYS(0:YYMDEP-1)
      INTEGER YYPV,YYPS,YYSTAT,YYTMP,YYNERR,YYERRF,YYCHAR
      INTEGER YYPVT,YYXPV,YYXPS,YYXSTA,YYXN,YYVAL,YYXI,YYXLEN
C
      INTEGER S1,S2,S3,S4,S5,S6,S7,S8,S9,S10
      INTEGER S12,S14
      INTEGER PC,PC1,PC2,DIM
C
      INTEGER IVAL
      DOUBLE PRECISION FVAL
      INTEGER I,J,YYLEX
C
C      CHARACTER STAR*5,CONT*1,LINE*66
      CHARACTER STAR*5,CONT*1,LINE*MAXCOLS
      INTEGER   LPOS,SPOS
      LOGICAL   EOF
C
      INTEGER MAXSYM
      PARAMETER (MAXSYM=2000)
      INTEGER YYLVAL
      CHARACTER*20 SYMNAM(MAXSYM)
      INTEGER SYMTYP(MAXSYM),SYMREF(MAXSYM),SYMEND
C
      INTEGER OIFLAG,FUFLAG,SPFLAG
      INTEGER MAXSTD,MAXEXT
      PARAMETER (MAXSTD=17,MAXEXT=2)
      INTEGER STDTYP(MAXSTD),EXTTYP(MAXEXT)
C
      INTEGER GRAD,HESS
      PARAMETER (GRAD=1,HESS=2)
C
      INTEGER MAXMAR
      PARAMETER (MAXMAR=100)
      INTEGER MARKST(MAXMAR,2),GOTOST(MAXMAR,2)
      INTEGER MC,GC
C
      INTEGER GETIWA
      DOUBLE PRECISION GETWA
C
      DATA STDTYP /1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1/
      DATA EXTTYP /2,0/
C
      DATA (YYEXCA(I),I=0,17)
     1           /-1,1,0,-1,-2,0,-1,109,257,27,
     2           -2,36,-1,111,257,26,-2,37/
      DATA (YYACT(I),I=0,99)
     O           /39,207,210,108,17,18,19,20,21,22,
     1           23,24,25,26,27,5,72,103,366,362,
     2           73,368,385,306,110,377,376,363,356,354,
     3           336,333,332,331,327,304,288,112,286,75,
     4           74,216,113,215,112,134,131,133,130,113,
     5           209,380,379,371,370,116,369,360,359,358,
     6           89,348,347,115,346,345,344,343,116,341,
     7           324,321,318,314,313,309,308,307,279,258,
     8           256,241,229,174,172,237,173,114,175,132,
     9           218,212,204,152,147,146,142,138,106,105/
      DATA (YYACT(I),I=100,199)
     O           /95,92,70,151,68,66,63,58,56,54,
     1           52,50,47,46,45,44,202,199,177,178,
     2           174,172,196,173,144,175,140,136,96,93,
     3           381,329,284,243,249,176,239,167,170,217,
     4           107,104,60,250,312,160,266,174,172,267,
     5           173,176,175,174,172,337,173,174,175,98,
     6           338,101,175,303,214,174,172,334,173,301,
     7           175,299,176,87,297,224,225,226,227,228,
     8           85,261,100,335,373,233,248,235,219,220,
     9           221,222,174,172,86,173,242,175,240,176/
      DATA (YYACT(I),I=200,299)
     O           /238,84,236,83,82,176,232,365,234,176,
     1           252,254,253,310,165,174,172,176,173,166,
     2           175,268,165,163,269,164,192,166,190,193,
     3           99,191,187,262,263,188,317,165,163,271,
     4           164,273,166,275,176,277,185,311,364,186,
     5           350,280,282,283,156,287,247,157,285,168,
     6           213,169,211,161,150,290,109,176,111,148,
     7           294,208,125,124,126,122,123,90,88,367,
     8           352,351,127,128,129,125,124,126,122,123,
     9           293,278,276,274,295,127,128,129,149,255/
      DATA (YYACT(I),I=300,399)
     O           /319,272,320,149,322,305,323,165,163,162,
     1           164,257,166,145,141,137,330,206,94,91,
     2           203,158,302,65,62,231,340,316,174,172,
     3           230,173,184,175,80,298,255,174,172,183,
     4           173,182,175,181,153,97,76,386,250,251,
     5           250,251,250,251,174,172,383,173,34,175,
     6           174,172,300,173,81,175,382,174,172,374,
     7           173,35,175,375,372,378,174,172,296,173,
     8           176,175,355,174,172,292,173,387,175,176,
     9           174,172,291,173,205,175,270,174,172,353/
      DATA (YYACT(I),I=400,499)
     O           /173,189,175,229,174,172,176,173,171,175,
     1           174,172,176,173,342,175,315,165,163,176,
     2           164,339,166,328,326,325,174,172,176,173,
     3           259,175,246,174,172,176,173,245,175,244,
     4           174,172,176,173,201,175,200,198,197,176,
     5           195,264,165,163,265,164,176,166,194,223,
     6           165,163,176,164,159,166,155,154,143,139,
     7           135,79,78,77,49,48,43,42,176,41,
     8           40,28,64,180,179,176,121,120,119,118,
     9           117,384,176,361,357,349,281,102,71,69/
      DATA (YYACT(I),I=500,531)
     O           /67,61,59,57,55,289,260,53,51,16,
     1           38,15,37,14,36,13,12,11,33,10,
     2           32,9,31,8,30,7,29,6,4,3,
     3           2,1/
      DATA (YYPACT(I),I=0,99)
     O           /-3000,-3000,-271,-3000,-3000,471,-3000,-3000,-3000,
     O            -3000,
     1           -3000,-3000,-3000,-3000,-3000,-3000,-3000,470,469,467,
     2           466,-149,-150,-151,-152,465,464,-153,-3000,-154,
     3           -155,-156,-157,-120,61,61,60,-160,-162,-248,
     4           -3000,-3000,-3000,-3000,306,463,462,461,-3000,-3000,
     5           324,-3000,143,-3000,142,-3000,140,-3000,133,-3000,
     6           15,-3000,56,-134,-3000,55,-135,-3000,305,-3000,
     7           -3000,-3000,121,-3000,-272,-121,-165,-3000,-3000,-3000,
     8           -3000,-166,-122,4,23,-216,23,-217,460,-136,
     9           52,459,-137,51,458,-139,50,-170,259,254/
      DATA (YYPACT(I),I=100,199)
     O           /23,-171,304,457,456,213,280,454,-112,219,
     1           265,-3000,-3,-3,398,23,23,-3000,-3000,-3000,
     2           -3000,-3000,-3000,-3000,-3000,-3000,303,301,299,292,
     3           205,191,391,187,185,-3000,448,440,-141,-3000,
     4           438,437,-146,-3000,436,434,-147,279,-3000,-172,
     5           -3000,384,276,10,-3000,-3000,218,-173,216,-3000,
     6           -221,-123,-174,-3,-3,-3,-3,418,-3000,-3000,
     7           -3000,-3000,23,23,23,23,23,362,57,290,
     8           285,-3,23,-3,23,141,-179,139,-126,-3000,
     9           137,-183,135,-129,-3000,-3000,429,-3000,-3000,427/
      DATA (YYPACT(I),I=200,299)
     O           /-3000,-3000,422,212,-3000,-3000,125,93,10,10,
     1           78,-184,270,-185,420,-3000,-3000,-3000,120,172,
     2           172,-3000,-3000,-3000,115,115,57,57,57,-3000,
     3           23,23,410,105,180,355,23,260,23,252,
     4           23,251,23,250,-3000,-3000,-3000,-186,23,-3000,
     5           10,10,-3000,41,91,23,-229,211,-231,-3000,
     6           -3000,-221,348,341,-3000,-3,-3000,23,-3000,-3,
     7           -3000,334,113,325,110,318,108,312,102,-232,
     8           295,-246,-3000,-116,-3000,368,-187,-188,-189,203,
     9           -113,-190,-191,375,286,195,-192,23,-3000,23/
      DATA (YYPACT(I),I=300,387)
     O           /-193,23,-3000,23,-194,-3000,415,414,-233,413,
     1           -3000,-131,-221,-234,-235,-3000,-3000,-3000,-236,123,
     2           173,-237,111,150,411,-3000,-3000,-195,-3000,-3000,
     3           404,-197,-198,-199,-200,-3000,-202,-203,-3000,-3000,
     4           -248,206,-3000,240,239,389,-238,372,-239,-3000,
     5           -205,-3000,-3000,-3000,-206,-3000,-207,-251,-240,204,
     6           163,-253,11,-208,-210,-211,364,144,-3000,363,
     7           -241,-242,-3000,10,-248,-3000,-212,-213,89,356,
     8           346,-3000,-3000,-3000,-247,337,-3000,-248/
      DATA (YYPGO(I),I=0,55)
     O           /0,531,530,529,528,527,526,525,524,523,
     1           522,521,520,519,518,517,358,516,515,514,
     2           513,512,511,510,509,0,508,507,3,506,
     3           505,24,504,2,503,502,501,500,159,499,
     4           498,497,1,496,495,494,493,491,490,489,
     5           488,487,486,484,483,482/
      DATA (YYR1(I),I=0,99)
     O           /0,1,2,2,4,4,4,4,4,4,
     1           4,4,4,4,4,5,6,6,26,7,
     2           8,8,27,29,27,27,28,28,30,30,
     3           31,31,31,31,31,31,31,31,9,10,
     4           10,32,32,32,32,32,11,12,12,34,
     5           34,34,34,34,13,13,14,14,35,35,
     6           35,35,15,17,16,16,36,36,36,36,
     7           20,21,21,37,37,38,38,22,23,23,
     8           39,24,24,25,25,40,40,41,43,44,
     9           40,40,40,47,45,45,46,46,33,33/
      DATA (YYR1(I),I=100,138)
     O           /33,33,33,33,33,33,33,33,33,33,
     1           53,33,54,33,42,42,42,42,42,48,
     2           48,49,49,49,50,50,50,51,51,51,
     3           52,18,19,19,55,55,55,55,3/
      DATA (YYR2(I),I=0,99)
     O           /0,5,4,0,4,4,4,4,4,4,
     1           4,4,4,4,5,4,4,0,9,4,
     2           4,0,13,1,16,21,3,2,7,0,
     3           7,7,7,7,6,5,3,3,5,4,
     4           0,9,23,15,35,19,4,4,0,9,
     5           23,15,35,19,21,33,4,0,7,9,
     6           9,11,7,7,4,0,7,9,9,11,
     7           5,4,0,19,7,7,1,5,4,0,
     8           7,7,21,4,0,9,15,1,1,1,
     9           29,7,7,1,21,0,6,1,7,7/
      DATA (YYR2(I),I=100,138)
     O           /7,7,7,6,5,2,2,2,2,2,
     1           1,19,1,19,7,7,5,6,7,3,
     2           3,3,9,13,3,9,13,3,9,13,
     3           9,7,4,0,7,9,9,11,4/
      DATA (YYCHK(I),I=0,99)
     O           /-3000,-1,-2,-3,-4,286,-5,-7,-9,-11,
     1           -13,-15,-17,-18,-20,-22,-24,275,276,277,
     2           278,279,280,281,282,283,284,285,10,-6,
     3           -8,-10,-12,-14,-16,-16,-19,-21,-23,-25,
     4           10,10,10,10,264,264,264,264,10,10,
     5           264,-26,264,-27,264,-32,264,-34,264,-35,
     6           262,-36,263,45,-55,263,45,-37,264,-39,
     7           264,-40,264,268,288,287,40,10,10,10,
     8           10,40,61,61,61,40,61,40,263,45,
     9           262,263,45,263,263,45,263,40,-38,-38/
      DATA (YYCHK(I),I=100,199)
     O           /61,40,-41,289,262,264,264,262,-28,262,
     1           -31,264,40,45,-33,40,45,-48,-49,-50,
     2           -51,-52,265,266,263,262,264,272,273,274,
     3           264,262,-33,264,262,10,263,263,45,10,
     4           263,263,45,10,263,263,45,264,10,44,
     5           10,-33,264,40,10,10,41,44,41,10,
     6           257,44,44,43,45,42,47,-31,262,264,
     7           -31,10,43,45,42,47,94,-33,-33,-53,
     8           -54,40,40,40,40,41,44,41,44,10,
     9           41,44,41,44,10,10,263,10,10,263/
      DATA (YYCHK(I),I=200,299)
     O           /10,10,263,41,264,10,41,-42,261,40,
     1           -33,44,264,44,-28,264,262,262,264,-31,
     2           -31,-31,-31,41,-33,-33,-33,-33,-33,41,
     3           40,40,-31,-33,-31,-33,61,264,61,262,
     4           61,264,61,262,10,10,10,44,61,41,
     5           259,260,-42,-33,-42,258,264,41,264,10,
     6           -29,61,-33,-33,41,44,41,44,41,44,
     7           41,-33,41,-33,41,-33,41,-33,41,264,
     8           -33,-43,-42,-42,41,-33,267,44,267,-30,
     9           -28,44,44,-31,-33,-31,44,61,10,61/
      DATA (YYCHK(I),I=300,387)
     O           /44,61,10,61,267,10,269,264,264,264,
     1           10,44,257,264,264,41,41,41,264,-33,
     2           -33,264,-33,-33,264,10,10,267,10,262,
     3           -28,267,267,267,44,10,267,44,10,10,
     4           -25,264,10,264,264,264,264,264,264,-44,
     5           44,41,41,10,267,10,267,-45,264,264,
     6           264,-46,270,267,44,44,271,268,10,264,
     7           264,264,10,40,-25,10,267,267,-42,264,
     8           264,41,10,10,-47,269,10,-25/
      DATA (YYDEF(I),I=0,99)
     O           /3,-2,0,1,2,0,17,21,40,48,
     1           57,65,65,133,72,79,84,0,0,0,
     2           0,0,0,0,0,0,0,0,138,4,
     3           5,6,7,8,9,10,11,12,13,14,
     4           15,19,38,46,0,0,0,0,70,77,
     5           0,16,0,20,0,39,0,47,0,56,
     6           0,64,0,0,132,0,0,71,76,78,
     7           76,83,0,87,0,0,0,62,63,131,
     8           81,0,0,0,0,0,0,0,0,0,
     9           0,0,0,0,0,0,0,0,0,0/
      DATA (YYDEF(I),I=100,199)
     O           /0,0,0,0,0,0,0,0,0,-2,
     1           0,-2,0,0,0,0,0,105,106,107,
     2           108,109,110,112,119,120,121,124,127,0,
     3           0,0,0,0,0,58,0,0,0,66,
     4           0,0,0,134,0,0,0,0,74,0,
     5           80,0,0,0,91,92,0,0,0,18,
     6           0,0,0,0,0,0,0,0,36,37,
     7           35,41,0,0,0,0,0,0,104,0,
     8           0,0,0,0,0,0,0,0,0,49,
     9           0,0,0,0,59,60,0,67,68,0/
      DATA (YYDEF(I),I=200,299)
     O           /135,136,0,0,75,85,0,0,0,0,
     1           0,0,0,0,0,26,27,23,0,30,
     2           31,32,33,34,98,99,100,101,102,103,
     3           0,0,0,0,0,0,0,0,0,0,
     4           0,0,0,0,61,69,137,0,0,88,
     5           0,0,116,0,0,0,0,0,0,22,
     6           29,0,0,0,122,0,125,0,128,0,
     7           130,0,0,0,0,0,0,0,0,0,
     8           0,0,114,115,117,118,0,0,0,0,
     9           0,0,0,0,0,0,0,0,43,0/
      DATA (YYDEF(I),I=300,387)
     O           /0,0,51,0,0,86,0,0,0,0,
     1           24,0,0,0,0,123,126,129,0,0,
     2           0,0,0,0,0,84,54,0,82,28,
     3           0,0,0,0,0,45,0,0,53,73,
     4           89,0,25,0,0,0,0,0,0,95,
     5           0,111,113,42,0,50,0,97,0,0,
     6           0,0,0,0,0,0,0,0,84,0,
     7           0,0,90,0,96,55,0,0,0,0,
     8           0,93,44,52,0,0,84,94/
C
      DATA YYV    /YYMDEP*0/
      DATA YYS    /YYMDEP*0/
C
      DATA YYTNAM /
     1  'RANGE','RELOP','AND','OR','NOT','INUM','RNUM','ID',
     2  'SUM','PROD','IN','IF','THEN','ELSE','ENDIF','STANDARD',
     3  'EXTERN','INTERP','PARAM','INDEX','REAL','INT','TABLE',
     4  'CONINT','LININT','SPLINE','VAR','INFUNC','FUNC','END','GOTO',
     5  'LABEL','CONTINUE','+','-','*','/','UMINUS','^','(',')',',','=',
     6  '-newline-','-unknown-'/
C
      DATA YYTVAL /
     1  257,258,259,260,261,262,263,264,265,266,
     2  267,268,269,270,271,272,273,274,275,276,
     3  277,278,279,280,281,282,283,284,285,286,
     4  287,288,289,43,45,42,47,290,94,40,
     5  41,44,61,10,-1/
C
      DATA (YYRLEN(I),I=0,138) /
     1     19,38,57,32,49,49,47,53,49,69,
     2     69,62,55,51,39,23,57,32,36,23,
     3     57,32,69,40,54,89,20,22,28,22,
     4     32,32,32,32,27,23,15,13,21,54,
     5     31,35,59,48,79,57,23,63,34,38,
     6     62,51,82,60,50,70,57,32,34,38,
     7     39,43,39,39,81,40,42,46,46,50,
     8     24,66,35,54,37,22,20,25,60,33,
     9     35,28,52,18,19,23,34,9,28,44,
     O     76,26,21,52,68,25,26,22,20,20,
     1     20,20,20,19,15,13,17,24,22,29,
     2     10,36,11,37,38,37,27,31,28,13,
     3     13,15,32,45,28,41,50,24,41,54,
     4     44,39,60,33,35,39,39,43,21/
C
      CALL INIRED(YYREDS)
C
      DEBUG=((DBGLVL .EQ. 2) .OR. (DBGLVL .EQ. 3))
      PSLVL=0
      LNUM=0
C      LPOS=67
      LPOS=122
      SPOS=2
      EOF=.FALSE.
      IERR=0
      PC=0
      MC=0
      GC=0
      SYMEND=0
      FUFLAG=0
      SPFLAG=0
C
      PSCHK=.FALSE.
      S10=0
      S14=0
      OIFLAG=0
C
      STAR=' '
      CONT=' '
      LINE=' '
      YYLVAL=0
      IPOL=0
C
      SYMNAM(1)=' '
      SYMTYP(1)=0
      SYMREF(1)=0
C
      DO 5 I=1,MAXMAR
        GOTOST(I,1)=0
        MARKST(I,1)=0
        GOTOST(I,2)=0
        MARKST(I,2)=0
 5    CONTINUE   
C
      DO 6 I=1,15
        INFOLI(I)=15
 6    CONTINUE   
      INFOLI(6)=0
      INFOLI(8)=0
      INFOLI(10)=0
      INFOLI(11)=0
      INFOLI(12)=0
      INFOLI(13)=0
C
C ignore leading '\n'!
C
      YYCHAR=YYLEX(INPUT,LNUM,STAR,CONT,LINE,LPOS,SPOS,EOF,YYLVAL,
     1             LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,MAXSYM,SYMNAM,
     2             SYMTYP,SYMREF,SYMEND,IERR,DBGFIL,DBGLVL)
C
C Initialize externals - yyparse may be called more than once
C
      YYPV=-1
      YYPS=-1
      YYSTAT=0
      YYTMP=0
      YYVAL=0
      YYNERR=0
      YYERRF=0
      YYCHAR=-1
C
C yystack:
C
 10   YYXPV=YYPV
      YYXPS=YYPS
      YYXSTA=YYSTAT
      IF (DEBUG) THEN
      IF (YYCHAR .EQ. 0) THEN
      WRITE(DBGFIL,'(A,I3,A)') 'YYPAR: State ',YYXSTA,
     1                         ', token end-of-file'
      ELSE IF (YYCHAR .LT. 0) THEN
      WRITE(DBGFIL,'(A,I3,A)') 'YYPAR: State ',YYXSTA,', token -none-'
      ELSE
      YYXI=-1
 101  YYXI=YYXI+1
      IF ((YYTVAL(YYXI) .NE. YYCHAR) .AND.
     1    (YYTVAL(YYXI) .NE. -1)) GO TO 101
      WRITE(DBGFIL,'(A,I3,A,A)') 'YYPAR: State ',YYXSTA,', token ',
     1                           YYTNAM(YYXI)
      ENDIF
      ENDIF
C
C top of for(;;) loop while no reductions done
C
C yy_stack: put a state and value onto the stacks
C
 20   YYXPS=YYXPS+1
      IF (YYXPS .GE. YYMDEP) THEN
        IERR=30
        GO TO 9999
      ENDIF
      YYS(YYXPS)=YYXSTA
      YYXPV=YYXPV+1
      YYV(YYXPV)=YYVAL
C
C yy_newstate: we have a new state - find out what to do
C
 30   YYXN=YYPACT(YYXSTA)
      IF (YYXN .LE. YYFLAG) GO TO 40
      YYTMP=0
      IF (YYCHAR .LT. 0) YYTMP=1
      IF (YYCHAR .LT. 0) THEN
        YYCHAR=YYLEX(INPUT,LNUM,STAR,CONT,LINE,LPOS,SPOS,EOF,YYLVAL,
     1               LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,MAXSYM,SYMNAM,
     2               SYMTYP,SYMREF,SYMEND,IERR,DBGFIL,DBGLVL)
        IF (YYCHAR .LT. 0) YYCHAR=0
      ENDIF
      IF (DEBUG .AND. YYTMP.NE.0) THEN
      IF (YYCHAR .EQ. 0) THEN
      WRITE(DBGFIL,'(A)') 'YYPAR: Received token end-of-file'
      ELSE IF (YYCHAR .LT. 0) THEN
      WRITE(DBGFIL,'(A)') 'YYPAR: Received token -none-'
      ELSE
      YYXI=-1
 301  YYXI=YYXI+1
      IF ((YYTVAL(YYXI) .NE. YYCHAR) .AND.
     1    (YYTVAL(YYXI) .NE. -1)) GO TO 301
      WRITE(DBGFIL,'(A,A)') 'YYPAR: Received token ',YYTNAM(YYXI)
      ENDIF
      ENDIF
      YYXN=YYXN+YYCHAR
      IF ((YYXN .LT. 0) .OR. (YYXN .GE. YYLAST)) GO TO 40
      YYXN=YYACT(YYXN)
      IF (YYCHK(YYXN) .EQ. YYCHAR) THEN
        YYCHAR=-1
        YYVAL=YYLVAL
        YYXSTA=YYXN
        IF (YYERRF .GT. 0) YYERRF=YYERRF-1
        GO TO 20
      ENDIF
C
C yydefault:
C
 40   YYXN=YYDEF(YYXSTA)
      IF (YYXN .EQ. -2) THEN
        YYTMP=0
        IF (YYCHAR .LT. 0) YYTMP=1
        IF (YYCHAR .LT. 0) THEN
          YYCHAR=YYLEX(INPUT,LNUM,STAR,CONT,LINE,LPOS,SPOS,EOF,YYLVAL,
     1                 LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,MAXSYM,SYMNAM,
     2                 SYMTYP,SYMREF,SYMEND,IERR,DBGFIL,DBGLVL)
          IF (YYCHAR .LT. 0) YYCHAR=0
        ENDIF
      IF (DEBUG .AND. YYTMP.NE.0) THEN
      IF (YYCHAR .EQ. 0) THEN
      WRITE(DBGFIL,'(A)') 'YYPAR: Received token end-of-file'
      ELSE IF (YYCHAR .LT. 0) THEN
      WRITE(DBGFIL,'(A)') 'YYPAR: Received token -none-'
      ELSE
      YYXI=-1
 401  YYXI=YYXI+1
      IF ((YYTVAL(YYXI) .NE. YYCHAR) .AND.
     1    (YYTVAL(YYXI) .NE. -1)) GO TO 401
      WRITE(DBGFIL,'(A,A)') 'YYPAR: Received token ',YYTNAM(YYXI)
      ENDIF
      ENDIF
C
C look through exception table
C
        YYXI=0
 41     IF ((YYEXCA(YYXI) .NE. -1) .OR. (YYEXCA(YYXI+1) .NE.
     1     YYXSTA)) THEN
          YYXI=YYXI+2
          GO TO 41
        ENDIF
 42     YYXI=YYXI+2
        IF ((YYEXCA(YYXI) .GE. 0) .AND. (YYEXCA(YYXI) .NE.
     1     YYCHAR)) GO TO 42
        YYXN=YYEXCA(YYXI+1)
        IF (YYXN .LT. 0) THEN
          IERR=YYACPT
          GO TO 9999
        ENDIF
      ENDIF
C
C check for syntax error
C
      IF (YYXN .EQ. 0) THEN
C
C have an error, switch( yyerrflag )
C
        GO TO (50,51,52,53) YYERRF+1
C
C case 0: new error
C
 50     YYNERR=YYNERR+1
        IF (IERR .EQ. 0) IERR=YYABRT
        GO TO 51
C
C yyerrlab: get globals into registers.
C           we have a user generated syntax type error
C
C501    YYXPV=YYPV
C       YYXPS=YYPS
C       YYXSTA=YYSTAT
C       YYNERR=YYNERR+1
C
C skip_init:
C case 1:
C case 2: incompletely recovered error. try again...
C
 51     CONTINUE
 52     YYERRF=3
C
C find state where "error" is a legal shift action
C
 521    IF (YYXPS .GE. 0) THEN
          YYXN=YYPACT(YYS(YYXPS))+YYERRC
          IF ((YYXN .GE. 0) .AND. (YYXN .LT. YYLAST)) THEN
            IF (YYCHK(YYACT(YYXN)) .EQ. YYERRC) THEN
C
C simulate shift of "error"
C
              YYXSTA=YYACT(YYXN)
              GO TO 20
            ENDIF
          ENDIF
C
C current state has no shift on "error", pop stack
C
          IF (DEBUG) THEN
          IF (YYXPS .GT. 0) THEN
          WRITE(DBGFIL,'(A,I3,A,I3)') 'YYPAR: Error recovery pops '//
     1      'state ',YYS(YYXPS),', uncovers state ',YYS(YYXPS-1)
          ELSE
          WRITE(DBGFIL,'(A,I3)') 'YYPAR: Error recovery pops '//
     1      'state ',YYS(YYXPS)
          ENDIF
          ENDIF
          YYXPS=YYXPS-1
          YYXPV=YYXPV-1
          GO TO 521
        ENDIF
C
C there is no state on stack with "error"
C as a valid shift, give up.
C
        IF (IERR .EQ. 0) IERR=YYABRT
        GO TO 9999
C
C case 3: no shift yet; eat a token
C
 53     IF (DEBUG) THEN
        IF (YYCHAR .EQ. 0) THEN
        WRITE(DBGFIL,'(A,A)') 'YYPAR: Error recovery discards token ',
     1                        'end-of-file'
        ELSE IF (YYCHAR .LT. 0) THEN
        WRITE(DBGFIL,'(A,A)') 'YYPAR: Error recovery discards token ',
     1                        '-none-'
        ELSE
        YYXI=-1
 531    YYXI=YYXI+1
        IF ((YYTVAL(YYXI) .NE. YYCHAR) .AND.
     1      (YYTVAL(YYXI) .NE. -1)) GO TO 531
        WRITE(DBGFIL,'(A,A)') 'YYPAR: Error recovery discards token ',
     1                        YYTNAM(YYXI)
        ENDIF
        ENDIF
        IF (YYCHAR .EQ. 0) THEN
          IF (IERR .EQ. 0) IERR=YYABRT
          GO TO 9999
        ENDIF
        YYCHAR=-1
        GO TO 30
C
C /* end if( yy_n == 0 ) */
C
      ENDIF
C
C reduction by production yy_n
C put stack tops, etc. so things right after switch.
C
      YYTMP=YYXN
      YYPVT=YYXPV
      IF (DEBUG) WRITE(DBGFIL,'(A,I3,A,A,A)') 
     1  'YYPAR: Reduce by (',YYXN,') "',YYREDS(YYXN)(1:YYRLEN(YYXN)),'"'
C
C Look in goto table for next state.
C If yyr2[ yy_n ] doesn't have the low order bit
C set, then there is no action to be done for
C this reduction. So, no saving & unsaving of
C registers done. The only difference between the
C code just after the if and the body of the if is
C the goto yy_stack in the body. This way the test
C can be made before the choice of what to do is needed.
C
C length of production doubled with extra bit.
C
      YYXLEN=YYR2(YYXN)
      IF (MOD(YYXLEN,2) .EQ. 0) THEN
        YYXLEN=YYXLEN/2
        YYXPV=YYXPV-YYXLEN
        YYVAL=YYV(YYXPV+1)
        YYXN=YYR1(YYXN)
        YYXPS=YYXPS-YYXLEN
        YYXSTA=YYPGO(YYXN)+YYS(YYXPS)+1
        IF (YYXSTA .GE. YYLAST) THEN
          YYXSTA=YYACT(YYPGO(YYXN))
        ELSE
          YYXSTA=YYACT(YYXSTA)
          IF (YYCHK(YYXSTA) .NE. -YYXN) YYXSTA=YYACT(YYPGO(YYXN))
        ENDIF
        GO TO 20
      ENDIF
      YYXLEN=YYXLEN/2
      YYXPV=YYXPV-YYXLEN
      YYVAL=YYV(YYXPV+1)
      YYXN=YYR1(YYXN)
      YYXPS=YYXPS-YYXLEN
      YYXSTA=YYPGO(YYXN)+YYS(YYXPS)+1
      IF (YYXSTA .GE. YYLAST) THEN
        YYXSTA=YYACT(YYPGO(YYXN))
      ELSE
        YYXSTA=YYACT(YYXSTA)
        IF (YYCHK(YYXSTA) .NE. -YYXN) YYXSTA=YYACT(YYPGO(YYXN))
      ENDIF
C
C save until reenter driver code
C
      YYSTAT=YYXSTA
      YYPS=YYXPS
      YYPV=YYXPV
C
C code supplied by user is placed in this switch
C
C module : declaration_blocks endmodule {}
C
      IF (YYTMP .EQ. 1) THEN
        IF (GC .NE. 0) THEN
          IF (MC .EQ.0) THEN
            IERR=58
            LNUM=GOTOST(1,1)
            GO TO 9999
          ENDIF
          DO 1010 I=1,GC
            IERR=58
            DO 1000 J=1,MC
              IF (GOTOST(I,1) .EQ. MARKST(J,1)) THEN
                IERR=0
                 CALL PUT1(MARKST(J,2),0.0D0,VPF,GOTOST(I,2)+2,LIWA,
     1               PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
              ENDIF
 1000       CONTINUE
            IF (IERR .NE. 0) THEN
              LNUM=GOTOST(I,1)
              GO TO 9999        
            ENDIF
 1010     CONTINUE
          DO 1020 I=1,GC
            GOTOST(I,1)=0
            GOTOST(I,2)=0
 1020     CONTINUE   
          DO 1030 I=1,MC
            MARKST(I,1)=0
            MARKST(I,2)=0
 1030     CONTINUE   
          MC=0
          GC=0
        ENDIF
        DO 1040 I=1,IWA(14)
          IF (GETIWA(VPF,I,0,IWA,LIWA,INFOLI) .EQ. -ASSIGN) THEN
            CALL PUT1(ASSIGN,0.0D0,VPF,I,LIWA,PLIWA,IWA,LWA,
     1          PLWA,WA,INFOLI,IERR)
            IHELP1=GETIWA(VPF,I+1,0,IWA,LIWA,INFOLI)+IWA(10)
            CALL PUT1(IHELP1,0.0D0,
     1               VPF,I+1,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          ELSE IF (GETIWA(VPF,I,0,IWA,LIWA,INFOLI) .EQ. -FUNC) THEN
            CALL PUT1(FUNC,0.0D0,VPF,I,LIWA,PLIWA,IWA,LWA,
     1          PLWA,WA,INFOLI,IERR)
            IHELP1=GETIWA(VPF,I+1,0,IWA,LIWA,INFOLI)+IWA(10)
            CALL PUT1(IHELP1,0.0D0,
     1          VPF,I+1,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          ELSE IF (GETIWA(VPF,I,0,IWA,LIWA,INFOLI) .EQ. -FUNC-128) THEN
            CALL PUT1(FUNC+128,0.0D0,VPF,I,LIWA,PLIWA,IWA,LWA,
     1          PLWA,WA,INFOLI,IERR)
            IHELP1=GETIWA(VPF,I+1,0,IWA,LIWA,INFOLI)+IWA(10)
            CALL PUT1(IHELP1,0.0D0,
     1          VPF,I+1,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          ENDIF
 1040   CONTINUE
        GO TO 9999
C
C declaration_block : function_head stmts {}
C
      ELSE IF (YYTMP .EQ. 14) THEN
         CALL PUT1(-1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1             IERR)
         IF (IERR .NE. 0) GO TO 9999       
         PC=IWA(14)
C
C param_declaration : ID '=' INUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 18) THEN
        S1=YYV(YYPVT-3)        
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=INT
        VEK4(1)=0
        VEK4(2)=0
        VEK4(3)=0
        VEK4(4)=IWA(4)
        CALL PUT4(VEK4,IIC,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999 
        ENDIF
        SYMREF(S1)=IWA(3)
C
C index_declaration : ID '=' index_delimiter RANGE index_delimiter '\n'
C                     {}
C
      ELSE IF (YYTMP .EQ. 22) THEN
        S1=YYV(YYPVT-5)
        S3=YYV(YYPVT-3)
        S5=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=INDEX
        IHELP1=GETIWA(VIC,S3,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(VIC,S5,0,IWA,LIWA,INFOLI)
        IF (IHELP1 .LT. IHELP2) THEN
          VEK5(1)=1
          VEK5(2)=IHELP2-IHELP1+1
          VEK5(3)=IHELP1
          VEK5(4)=IHELP2
          VEK5(5)=IWA(2)+1
          CALL PUT5(VEK5,IIS,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF 
          DO 1100 I=IHELP1,IHELP2
            CALL PUT1(I,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1                IERR)
 1100     CONTINUE
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF           
        ELSE
          VEK5(1)=1
          VEK5(2)=IHELP1-IHELP2+1
          VEK5(3)=IHELP2
          VEK5(4)=IHELP1
          VEK5(5)=IWA(2)+1
          CALL PUT5(VEK5,IIS,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF 
          DO 1110 I=IHELP1,IHELP2,-1
            CALL PUT1(I,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1                IERR)
 1110     CONTINUE
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF           
        ENDIF
        SYMREF(S1)=IWA(1)
C
C index_declaration : ID '=' INUM ',' INUM {} opt_inum '\n'
C
      ELSE IF (YYTMP .EQ. 23) THEN
        S1=YYV(YYPVT-4)
        S3=YYV(YYPVT-2)
        S5=YYV(YYPVT)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          GO TO 9999
        ENDIF
        SYMTYP(S1)=INDEX
        IHELP1=GETIWA(VIC,S3,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(VIC,S5,0,IWA,LIWA,INFOLI)
        VEK5(1)=2
        VEK5(2)=2
        VEK5(3)=MIN(IHELP1,IHELP2)
        VEK5(4)=MAX(IHELP1,IHELP2)
        VEK5(5)=IWA(2)+1
        CALL PUT5(VEK5,IIS,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999       
        SYMREF(S1)=IWA(1)
        CALL PUT1(IHELP1,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        CALL PUT1(IHELP2,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        IF (IERR .NE. 0) GO TO 9999       
C
C index_declaration : ID '=' ind_expr ',' 
C                     ID '=' index_delimiter RANGE index_delimiter '\n'
C                     {}
C
      ELSE IF (YYTMP .EQ. 25) THEN
        S1=YYV(YYPVT-9)
        S5=YYV(YYPVT-5)
        S7=YYV(YYPVT-3)
        S9=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=INDEX
        VEK5(1)=3
        VEK5(5)=IWA(2)+1
        IF (SYMTYP(S5) .EQ. 0) THEN
          SYMTYP(S5)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          SYMREF(S5)=IWA(15)
        ELSE IF (SYMTYP(S5) .NE. INDVAR) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        CALL PUT1(-1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(VIC,S7,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(VIC,S9,0,IWA,LIWA,INFOLI)
        IF (IHELP1 .LT. IHELP2) THEN
          DO 1200 I=IHELP1,IHELP2
            CALL PUT1(I,0.0D0,IV,SYMREF(S5),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1               INFOLI,IERR)
            CALL EVALCA(LIWA,IWA,LWA,WA,INFOLI,PC,IVAL,FVAL,IERR)
            IF (IERR .NE. 0) THEN
              LNUM=LNUM-1
              GO TO 9999
            ENDIF
            CALL PUT1(IVAL,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) THEN
              LNUM=LNUM-1
              GO TO 9999
            ENDIF
            IF (I .EQ. IHELP1) THEN
              VEK5(2)=1
              VEK5(3)=IVAL
              VEK5(4)=IVAL
            ELSE
              VEK5(2)=VEK5(2)+1
              VEK5(3)=MIN(IVAL,VEK5(3))
              VEK5(4)=MAX(IVAL,VEK5(4))
            ENDIF
 1200     CONTINUE
          CALL PUT5(VEK5,IIS,0,LIWA,PLIWA,IWA,INFOLI,IERR)  
        ELSE
          DO 1210 I=IHELP1,IHELP2,-1
            CALL PUT1(I,0.0D0,IV,SYMREF(S5),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1          INFOLI,IERR)
            CALL EVALCA(LIWA,IWA,LWA,WA,INFOLI,PC,IVAL,FVAL,IERR)
            IF (IERR .NE. 0) THEN
              LNUM=LNUM-1
              GO TO 9999
            ENDIF
            CALL PUT1(IVAL,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) THEN
              LNUM=LNUM-1
              GO TO 9999
            ENDIF
            IF (I .EQ. IHELP1) THEN
              VEK5(2)=1
              VEK5(3)=IVAL
              VEK5(4)=IVAL
            ELSE
              VEK5(2)=VEK5(2)+1
              VEK5(3)=MIN(IVAL,VEK5(3))
              VEK5(4)=MAX(IVAL,VEK5(4))
            ENDIF
 1210     CONTINUE
          CALL PUT5(VEK5,IIS,0,LIWA,PLIWA,IWA,INFOLI,IERR)  
        ENDIF
        SYMREF(S1)=IWA(1)
        CALL UNVPF(PC,LIWA,PLIWA,IWA,INFOLI)
C
C index_delimiter : ID {}
C
      ELSE IF (YYTMP .EQ. 26) THEN
        S1 = YYV(YYPVT)
        IF (SYMTYP(S1) .NE. INT) THEN
          IERR=8
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IIC,SYMREF(S1),4,IWA,LIWA,INFOLI)
        YYVAL = IHELP1
C
C opt_inum : opt_inum ',' INUM {}
C
      ELSE IF (YYTMP .EQ. 28) THEN
        S3=YYV(YYPVT)
        IHELP1=GETIWA(VIC,S3,0,IWA,LIWA,INFOLI)
        CALL PUT1(IHELP1,0.0D0,VIS,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1           IERR)  
        IF (IERR .NE. 0) GO TO 9999
        VEK5(1)=GETIWA(IIS,IWA(1),1,IWA,LIWA,INFOLI)
        VEK5(5)=GETIWA(IIS,IWA(1),5,IWA,LIWA,INFOLI)
        VEK5(2)=GETIWA(IIS,IWA(1),2,IWA,LIWA,INFOLI)+1
        IHELP2=GETIWA(IIS,IWA(1),3,IWA,LIWA,INFOLI)
        IHELP3=GETIWA(IIS,IWA(1),4,IWA,LIWA,INFOLI)
        VEK5(3)=MIN(IHELP1,IHELP2)
        VEK5(4)=MAX(IHELP1,IHELP3)
        CALL PUT5(VEK5,IIS,IWA(1),LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : ind_expr '+' ind_expr {}
C
      ELSE IF (YYTMP .EQ. 30) THEN
        CALL PUT1(ADD+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1           IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : ind_expr '-' ind_expr {}
C
      ELSE IF (YYTMP .EQ. 31) THEN
        CALL PUT1(SUB+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1           IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : ind_expr '*' ind_expr {}
C
      ELSE IF (YYTMP .EQ. 32) THEN
        CALL PUT1(MULT+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : ind_expr '/' ind_expr {}
C
      ELSE IF (YYTMP .EQ. 33) THEN
        CALL PUT1(DIV+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1           IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : '-' ind_expr %prec UMINUS {}
C
      ELSE IF (YYTMP .EQ. 35) THEN
        CALL PUT1(UMINUS+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : INUM {}
C
      ELSE IF (YYTMP .EQ. 36) THEN
        CALL PUT1(INUM+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(YYV(YYPVT),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C ind_expr : ID {}
C
      ELSE IF (YYTMP .EQ. 37) THEN
        S1=YYV(YYPVT)
        IF (SYMTYP(S1) .EQ. 0) THEN
          SYMTYP(S1)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S1)=IWA(15)
        ELSE IF ((SYMTYP(S1) .NE. INDVAR) .AND.
     1           (SYMTYP(S1) .NE. FUNC)) THEN
          IERR=8
          GO TO 9999
        ELSE IF ((SYMTYP(S1) .EQ. FUNC) .AND. 
     1          (GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI) .NE. -2)) THEN
          IERR=59
          GO TO 9999
        ENDIF
        IF (SYMTYP(S1) .EQ. INDVAR) THEN
          CALL PUT1(INDVAR+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ELSE IF (SYMTYP(S1) .EQ. FUNC) THEN
          CALL PUT1(-(FUNC+128),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(SYMREF(S1)-IWA(10),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,
     1              PLWA,WA,INFOLI,IERR)
        ENDIF
        IF (IERR .NE. 0) GO TO 9999
C
C real_head : REAL '\n' {}
C
      ELSE IF (YYTMP .EQ. 38) THEN 
        PSCHK=.FALSE.
C real_declaration : ID '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 41) THEN
        CALL CASE41(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C real_declaration : ID '(' ID ')' '=' expr ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 42) THEN
        CALL CASE42(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C real_declaration : ID '(' INUM ')' '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 43) THEN
        CALL CASE43(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C real_declaration : ID '(' ID ',' ID ')' '=' expr ','
C                    ID IN ID ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 44) THEN
        CALL CASE44(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999

C
C real_declaration : ID '(' INUM ',' INUM ')' '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 45) THEN
        CALL CASE45(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C integer_declaration : ID '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 49) THEN
        CALL CASE49(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999

C
C integer_declaration : ID '(' ID ')' '=' expr ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 50) THEN
        CALL CASE50(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C integer_declaration : ID '(' INUM ')' '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 51) THEN
        CALL CASE51(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C integer_declaration : ID '(' ID ',' ID ')' '=' expr ','
C                       ID IN ID ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 52) THEN
        CALL CASE52(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C integer_declaration : ID '(' INUM ',' INUM ')' '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 53) THEN
        CALL CASE53(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,PC)
        IF (IERR .NE. 0) GO TO 9999
C
C table_head : TABLE ID '(' ID ')' ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 54) THEN
        CALL CASE54(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1                  LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,S9)
        IF (IERR .NE. 0) GO TO 9999
C
C table_head : TABLE ID '(' ID ',' ID ')' ',' ID IN ID ',' ID IN ID '\n'
C              {}
C
      ELSE IF (YYTMP .EQ. 55) THEN
        S1=YYV(YYPVT-14)
        S3=YYV(YYPVT-12)
        S5=YYV(YYPVT-10)
        S8=YYV(YYPVT-7)
        S10=YYV(YYPVT-5)
        S12=YYV(YYPVT-3)
        S14=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=REAL
        SYMREF(S1)=IWA(5)+1
        IF (SYMTYP(S3) .EQ. 0) THEN
          SYMTYP(S3)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          SYMREF(S3)=IWA(15)
        ELSE IF (SYMTYP(S3) .NE. INDVAR) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IF (SYMTYP(S5) .EQ. 0) THEN
          SYMTYP(S5)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          SYMREF(S5)=IWA(15)
        ELSE IF (SYMTYP(S5) .NE. INDVAR) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IF ((SYMTYP(S10) .NE. INDEX) .OR. 
     1      (SYMTYP(S14) .NE. INDEX)) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IIS,SYMREF(S10),3,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IIS,SYMREF(S14),3,IWA,LIWA,INFOLI)
        IF ((S3 .NE. S8) .OR. (S5 .NE. S12) .OR. 
     1      (IHELP1 .LE. 0) .OR. (IHELP2 .LE. 0)) THEN
          IERR=33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        VEK4(1)=2
        VEK4(2)=GETIWA(IIS,SYMREF(S10),4,IWA,LIWA,INFOLI)
        VEK4(3)=GETIWA(IIS,SYMREF(S14),4,IWA,LIWA,INFOLI)
        VEK4(4)=IWA(6)+1
        CALL PUT4(VEK4,IRC,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IRC,IWA(5),2,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IRC,IWA(5),3,IWA,LIWA,INFOLI)
        DO 1800 I=1,IHELP1*IHELP2
          CALL PUT1(0,0.0D0,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
 1800   CONTINUE
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C table_declaration : INUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 58) THEN
        S1=YYV(YYPVT-2)
        S2=YYV(YYPVT-1)
        IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IIS,SYMREF(S9),4,IWA,LIWA,INFOLI)
        IF ((IHELP1 .LT. 1) .OR.
     1      (IHELP1 .GT. IHELP2)) THEN
          IERR = 33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP3=GETIWA(IRC,IWA(5),4,IWA,LIWA,INFOLI)
        HELP4=GETWA(VRC,S2,WA,LWA,INFOLI)
        CALL PUT1(0,HELP4,VRC,IHELP3+IHELP1-1,LIWA,PLIWA,IWA,LWA,PLWA,
     1            WA,INFOLI,IERR)
C
C table_declaration : INUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 59) THEN
        S1=YYV(YYPVT-3)
        S3=YYV(YYPVT-1)
        IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IIS,SYMREF(S9),4,IWA,LIWA,INFOLI)
        IF ((IHELP1 .LT. 1) .OR.
     1      (IHELP1 .GT. IHELP2)) THEN
          IERR = 33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP3=GETIWA(IRC,IWA(5),4,IWA,LIWA,INFOLI)
        HELP4=GETWA(VRC,S3,WA,LWA,INFOLI)
        CALL PUT1(0,-HELP4,VRC,IHELP3+IHELP1-1,LIWA,PLIWA,IWA,LWA,PLWA,
     1            WA,INFOLI,IERR)
C
C table_declaration : INUM INUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 60) THEN
        S1=YYV(YYPVT-3)
        S2=YYV(YYPVT-2)
        S3=YYV(YYPVT-1)
        IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(VIC,S2,0,IWA,LIWA,INFOLI)
        IHELP3=GETIWA(IIS,SYMREF(S10),4,IWA,LIWA,INFOLI)
        IHELP4=GETIWA(IIS,SYMREF(S14),4,IWA,LIWA,INFOLI)
        IF ((IHELP1 .LT. 1) .OR. (IHELP1 .GT. IHELP3) .OR.
     1      (IHELP2 .LT. 1) .OR. (IHELP2 .GT. IHELP4)) THEN
          IERR = 33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP5=GETIWA(IRC,IWA(5),4,IWA,LIWA,INFOLI)
        HELP6=GETWA(VRC,S3,WA,LWA,INFOLI)
        CALL PUT1(0,HELP6,VRC,IHELP5+(IHELP1-1)*IHELP4+IHELP2-1,LIWA,
     1            PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
C
C table_declaration : INUM INUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 61) THEN
        S1=YYV(YYPVT-4)
        S2=YYV(YYPVT-3)
        S4=YYV(YYPVT-1)
        IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(VIC,S2,0,IWA,LIWA,INFOLI)
        IHELP3=GETIWA(IIS,SYMREF(S10),4,IWA,LIWA,INFOLI)
        IHELP4=GETIWA(IIS,SYMREF(S14),4,IWA,LIWA,INFOLI)
        IF ((IHELP1 .LT. 1) .OR. (IHELP1 .GT. IHELP3) .OR.
     1      (IHELP2 .LT. 1) .OR. (IHELP2 .GT. IHELP4)) THEN
          IERR = 33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP5=GETIWA(IRC,IWA(5),4,IWA,LIWA,INFOLI)
        HELP6=GETWA(VRC,S4,WA,LWA,INFOLI)
        CALL PUT1(0,-HELP6,VRC,IHELP5+(IHELP1-1)*IHELP4+IHELP2-1,LIWA,
     1            PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
C
C con_interpolation_head : CONINT ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 62) THEN
        IF (SPFLAG .GT. 0) THEN
          IHELP1=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
          DIM=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)/5-1
          CALL SPLNES(WA(IHELP1),DIM,IERR,LNUM)
          IF (IERR .NE. 0) GO TO 9999
          SPFLAG=0
        ENDIF
        S2=YYV(YYPVT-1)
        IPOL=S2
        IF (SYMTYP(S2) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S2)=CONINT
        SYMREF(S2)=IWA(5)+1
        VEK4(1)=1
        VEK4(2)=0
        VEK4(3)=0
        VEK4(4)=IWA(6)+1
        CALL PUT4(VEK4,IRC,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C lin_interpolation_head : LININT ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 63) THEN
        IF (SPFLAG .GT. 0) THEN
          IHELP1=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
          DIM=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)/5-1
          CALL SPLNES(WA(IHELP1),DIM,IERR,LNUM)
          IF (IERR .NE. 0) GO TO 9999
          SPFLAG=0
        ENDIF
        S2=YYV(YYPVT-1)
        IPOL=S2
        IF (SYMTYP(S2) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S2)=LININT
        SYMREF(S2)=IWA(5)+1
        VEK4(1)=1
        VEK4(2)=0
        VEK4(3)=0
        VEK4(4)=IWA(6)+1
        CALL PUT4(VEK4,IRC,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C interpolation_declaration : RNUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 66) THEN
        S1=YYV(YYPVT-2)
        S2=YYV(YYPVT-1)
        IHELP1=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 2 ) THEN
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
          HELP4=GETWA(VRC,S2,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 1 ) THEN
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
          HELP4=GETWA(VRC,S2,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,IWA(6),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
        ENDIF
        IF (IHELP1 .GT. 0) THEN
          HELP4=GETWA(VRC,IWA(6)-3,WA,LWA,INFOLI)
          IF (HELP3 .LE. HELP4) THEN
            IERR= 63
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
        ENDIF
        VEK4(1)=1
        VEK4(2)=2+IHELP1
        VEK4(3)=0
        VEK4(4)=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        CALL PUT4(VEK4,IRC,SYMREF(IPOL),LIWA,PLIWA,IWA,INFOLI,IERR)
C
C interpolation_declaration : RNUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 67) THEN
        S1=YYV(YYPVT-3)
        S3=YYV(YYPVT-1)
        IHELP1=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 2 ) THEN
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S3,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 1 ) THEN
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S3,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,IWA(6),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE
          HELP3=GETWA(VRC,S1,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S3,WA,LWA,INFOLI)
          CALL PUT1(0,HELP4,VRC,IWA(6),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ENDIF
        IF (IHELP1 .GT. 0) THEN
          HELP4=GETWA(VRC,IWA(6)-3,WA,LWA,INFOLI)
          IF (HELP3 .LE. HELP4) THEN
            IERR= 63
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
        ENDIF
        VEK4(1)=1
        VEK4(2)=2+IHELP1
        VEK4(3)=0
        VEK4(4)=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        CALL PUT4(VEK4,IRC,SYMREF(IPOL),LIWA,PLIWA,IWA,INFOLI,IERR)
C
C interpolation_declaration : '-' RNUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 68) THEN
        S2=YYV(YYPVT-2)
        S3=YYV(YYPVT-1)
        IHELP1=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 2 ) THEN
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          HELP4=GETWA(VRC,S3,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 1 ) THEN
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          HELP4=GETWA(VRC,S3,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,IWA(6),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,S2,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ENDIF
        IF (IHELP1 .GT. 0) THEN
          HELP4=GETWA(VRC,IWA(6)-3,WA,LWA,INFOLI)
          IF (HELP3 .LE. HELP4) THEN
            IERR= 63
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
        ENDIF
        VEK4(1)=1
        VEK4(2)=2+IHELP1
        VEK4(3)=0
        VEK4(4)=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        CALL PUT4(VEK4,IRC,SYMREF(IPOL),LIWA,PLIWA,IWA,INFOLI,IERR)
C
C interpolation_declaration : '-' RNUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 69) THEN
        S2=YYV(YYPVT-3)
        S4=YYV(YYPVT-1)
        IHELP1=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 2 ) THEN
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S4,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE IF ( ((IHELP1+2)-(IWA(6)-IHELP2)-1) .EQ. 1 ) THEN
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S4,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,IWA(6),LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(0,HELP4,VRC,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
        ELSE
          HELP3=-GETWA(VRC,S2,WA,LWA,INFOLI)
          HELP4=-GETWA(VRC,S4,WA,LWA,INFOLI)
          CALL PUT1(0,HELP3,VRC,S2,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(0,HELP4,VRC,S4,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ENDIF
        IF (IHELP1 .GT. 0) THEN
          HELP4=GETWA(VRC,IWA(6)-3,WA,LWA,INFOLI)
          IF (HELP3 .LE. HELP4) THEN
            IERR= 63
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
        ENDIF
        VEK4(1)=1
        VEK4(2)=2+IHELP1
        VEK4(3)=0
        VEK4(4)=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
        CALL PUT4(VEK4,IRC,SYMREF(IPOL),LIWA,PLIWA,IWA,INFOLI,IERR)
C
C variable_head : VAR '\n' {}
C
      ELSE IF (YYTMP .EQ. 70) THEN
        OIFLAG=1
C
C variable_declaration : ID '(' ID ')' ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 73) THEN
        S1=YYV(YYPVT-8)
        S3=YYV(YYPVT-6)
        S6=YYV(YYPVT-3)
        S8=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=VAR
        SYMREF(S1)=IWA(7)+1
        IF (SYMTYP(S3) .EQ. 0) THEN
          SYMTYP(S3)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          SYMREF(S3)=IWA(15)
        ELSE IF (SYMTYP(S3) .NE. INDVAR) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IF (SYMTYP(S8) .NE. INDEX) THEN
          IERR=8
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IIS,SYMREF(S8),1,IWA,LIWA,INFOLI)
        IF ((S3 .NE. S6) .OR. (IHELP1 .NE. 1)) THEN
          IERR=33
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        VEK3(1)=1
        VEK3(2)=GETIWA(IIS,SYMREF(S8),2,IWA,LIWA,INFOLI)
        VEK3(3)=IWA(8)+1
        CALL PUT3(VEK3,IVA,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IVA,IWA(7),2,IWA,LIWA,INFOLI)
        DO 2100 I=1,IHELP1
          CALL PUT1(0,0.0D0,VVA,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1              IERR)
 2100   CONTINUE
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C variable_declaration : ID opt_id '\n' {}
C
      ELSE IF (YYTMP .EQ. 74) THEN
        S1=YYV(YYPVT-2)
        S2=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=VAR
        SYMREF(S1)=S2
        VEK3(1)=0
        VEK3(2)=0
        VEK3(3)=IWA(8)+S2-IWA(7)
        CALL PUT3(VEK3,IVA,S2,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IVA,S2,3,IWA,LIWA,INFOLI)
        CALL PUT1(0,0.0D0,VVA,IHELP1,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1           IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C opt_id : opt_id ',' ID {}
C
      ELSE IF (YYTMP .EQ. 75) THEN
        S1=YYV(YYPVT-2)
        S3=YYV(YYPVT)
        IF (SYMTYP(S3) .NE. 0) THEN
          IERR=4
          GO TO 9999
        ENDIF
        IF (OIFLAG .EQ. 1) THEN
          CALL PUT1(0,0.0D0,VVA,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1             IERR)
          IF (IERR .NE. 0) GO TO 9999
          VEK3(1)=0
          VEK3(2)=0
          VEK3(3)=IWA(8)
          CALL PUT3(VEK3,IVA,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMTYP(S3)=VAR
          SYMREF(S3)=IWA(7)
          YYVAL=S1
        ELSE IF (OIFLAG .EQ. 2) THEN
          VEK7(1)=-2
          VEK7(2)=0
          VEK7(3)=0
          VEK7(4)=IWA(11)+1
          VEK7(5)=IWA(12)+1
          VEK7(6)=0
          VEK7(7)=IWA(12)+1
          CALL PUT7(VEK7,IFN,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMTYP(S3)=FUNC
          SYMREF(S3)=IWA(9)
          IWA(11)=IWA(11)+1
          IF (MODE .GE. GRAD) THEN
            IWA(12)=IWA(12)+1
          ENDIF
          IF (MODE .EQ. HESS) THEN
            IWA(13)=IWA(13)+1
          ENDIF
          IF (IWA(6)+IWA(8)+IWA(11)+IWA(12)*IWA(8)+
     1        IWA(13)*IWA(8)*IWA(8) .GT. LWA) THEN
            IERR=32
            GO TO 9999
          ENDIF
          YYVAL=S1
        ENDIF
C
C opt_id : /* empty */ {}
C
      ELSE IF (YYTMP .EQ. 76) THEN
        IF (OIFLAG .EQ. 1) THEN
          VEK3(1)=0
          VEK3(2)=0
          VEK3(3)=0
          CALL PUT3(VEK3,IVA,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          CALL PUT1(0,0.0D0,VVA,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1             IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          YYVAL=IWA(7)
        ELSE IF (OIFLAG .EQ. 2) THEN
          VEK7(1)=0
          VEK7(2)=0
          VEK7(3)=0
          VEK7(4)=0
          VEK7(5)=0
          VEK7(6)=0
          VEK7(7)=0
          CALL PUT7(VEK7,IFN,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) THEN
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          IWA(11)=IWA(11)+1
          IF (MODE .GE. GRAD) THEN
            IWA(12)=IWA(12)+1
          ENDIF
          IF (MODE .EQ. HESS) THEN
            IWA(13)=IWA(13)+1
          ENDIF
          IF (IWA(6)+IWA(8)+IWA(11)+IWA(12)*IWA(8)+
     1        IWA(13)*IWA(8)*IWA(8) .GT. LWA) THEN
            IERR=32
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          YYVAL=IWA(9)
        ENDIF
C
C infunc_head : INFUNC '\n' {}
C
      ELSE IF (YYTMP .EQ. 77) THEN
        OIFLAG=2
C
C infunc_declaration : ID opt_id '\n' {}
C
      ELSE IF (YYTMP .EQ. 80) THEN
        S1=YYV(YYPVT-2)
        S2=YYV(YYPVT-1)
        IF (SYMTYP(S1) .NE. 0) THEN
          IERR=4
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        SYMTYP(S1)=FUNC
        SYMREF(S1)=S2
        VEK7(1)=-2
        VEK7(2)=0
        VEK7(3)=0
        VEK7(4)=IWA(11)
        VEK7(5)=IWA(12)
        VEK7(6)=0
        VEK7(7)=IWA(12)
        CALL PUT7(VEK7,IFN,S2,LIWA,PLIWA,IWA,INFOLI,IERR)
C
C function_head : FUNC ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 81) THEN
        PSCHK=.TRUE.
        IF (SPFLAG .GT. 0) THEN
          IHELP1=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
          DIM=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)/5-1
          CALL SPLNES(WA(IHELP1),DIM,IERR,LNUM)
          IF (IERR .NE. 0) GO TO 9999
          SPFLAG=0
        ENDIF
        IF (GC .NE. 0) THEN
          IF (MC .EQ.0) THEN
            IERR=58
            LNUM=GOTOST(1,1)
            GO TO 9999
          ENDIF
          DO 2210 I=1,GC
            IERR=58
            DO 2200 J=1,MC
              IF (GOTOST(I,1) .EQ. MARKST(J,1)) THEN
                IERR=0
                 CALL PUT1(MARKST(J,2),0.0D0,VPF,GOTOST(I,2)+2,LIWA,
     1               PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
              ENDIF
 2200       CONTINUE
            IF (IERR .NE. 0) THEN 
              LNUM=GOTOST(I,1)
              GO TO 9999
            ENDIF
 2210     CONTINUE
          DO 2220 I=1,GC
            GOTOST(I,1)=0
            GOTOST(I,2)=0
 2220     CONTINUE   
          DO 2230 I=1,MC
            MARKST(I,1)=0
            MARKST(I,2)=0
 2230     CONTINUE   
          MC=0
          GC=0
        ENDIF
        FUFLAG=0
        S2=YYV(YYPVT-1)
        IF (SYMTYP(S2) .NE. 0) THEN
          IERR=4
          GO TO 9999
        ENDIF
        DO 2240 I=1,SYMEND
          IF ((SYMTYP(I) .EQ. FUNC) .AND. (SYMREF(I) .GT. IWA(10))) THEN
            SYMREF(I)=SYMREF(I)+1
          ENDIF
 2240   CONTINUE
        SYMTYP(S2)=FUNC
        VEK7(1)=0
        VEK7(2)=0
        VEK7(3)=0
        VEK7(4)=0
        VEK7(5)=0
        VEK7(6)=0
        VEK7(7)=0
        CALL PUT7(VEK7,IFN,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        IWA(10)=IWA(10)+1
        SYMREF(S2)=IWA(10)
        DO 2250 I=IWA(9)-1,IWA(10),-1
          VEK7(1)=GETIWA(IFN,I,1,IWA,LIWA,INFOLI)
          VEK7(2)=GETIWA(IFN,I,2,IWA,LIWA,INFOLI)
          VEK7(3)=GETIWA(IFN,I,3,IWA,LIWA,INFOLI)
          VEK7(4)=GETIWA(IFN,I,4,IWA,LIWA,INFOLI)+1
          VEK7(5)=GETIWA(IFN,I,5,IWA,LIWA,INFOLI)+1
          VEK7(6)=GETIWA(IFN,I,6,IWA,LIWA,INFOLI)
          VEK7(7)=GETIWA(IFN,I,7,IWA,LIWA,INFOLI)+1
          CALL PUT7(VEK7,IFN,I+1,LIWA,PLIWA,IWA,INFOLI,IERR)
 2250   CONTINUE
        VEK7(1)=0
        VEK7(2)=0
        VEK7(3)=0
        VEK7(4)=IWA(11)-(IWA(9)-IWA(10))+1
        VEK7(5)=IWA(12)-(IWA(9)-IWA(10))+1
        VEK7(6)=PC+1
        VEK7(7)=IWA(12)-(IWA(9)-IWA(10))+1
        CALL PUT7(VEK7,IFN,IWA(10),LIWA,PLIWA,IWA,INFOLI,IERR)
        IWA(11)=IWA(11)+1
        IF (MODE .GE. GRAD) THEN
          IWA(12)=IWA(12)+1
        ENDIF
        IF (MODE .EQ. HESS) THEN
          IWA(13)=IWA(13)+1
        ENDIF
        IF (IWA(6)+IWA(8)+IWA(11)+IWA(12)*IWA(8)+
     1      IWA(13)*IWA(8)*IWA(8) .GT. LWA) THEN
          IERR=32
          GO TO 9999
        ENDIF
C
C function_head : FUNC ID '(' ID ')' ',' ID IN ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 82) THEN
        PSCHK=.TRUE.
        IF (SPFLAG .GT. 0) THEN
          IHELP1=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
          DIM=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)/5-1
          CALL SPLNES(WA(IHELP1),DIM,IERR,LNUM)
          IF (IERR .NE. 0) GO TO 9999
          SPFLAG=0
        ENDIF
        IF (GC .NE. 0) THEN
          IF (MC .EQ.0) THEN
            IERR=58
            LNUM=GOTOST(1,1)
            GO TO 9999
          ENDIF
          DO 2310 I=1,GC
            IERR=58
            DO 2300 J=1,MC
              IF (GOTOST(I,1) .EQ. MARKST(J,1)) THEN
                IERR=0
                 CALL PUT1(MARKST(J,2),0.0D0,VPF,GOTOST(I,2)+2,LIWA,
     1               PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
              ENDIF
 2300       CONTINUE
            IF (IERR .NE. 0) THEN 
              LNUM=GOTOST(I,1)
              GO TO 9999
            ENDIF
 2310     CONTINUE
          DO 2320 I=1,GC
            GOTOST(I,1)=0
            GOTOST(I,2)=0
 2320     CONTINUE   
          DO 2330 I=1,MC
            MARKST(I,1)=0
            MARKST(I,2)=0
 2330     CONTINUE   
          MC=0
          GC=0
        ENDIF
        FUFLAG=0
        S2=YYV(YYPVT-8)
        S4=YYV(YYPVT-6)
        S7=YYV(YYPVT-3)
        S9=YYV(YYPVT-1)
        IF (SYMTYP(S2) .NE. 0) THEN
          IERR=4
          GO TO 9999
        ENDIF
        DO 2340 I=1,SYMEND
          IF ((SYMTYP(I) .EQ. FUNC) .AND. (SYMREF(I) .GT. IWA(10))) THEN
            SYMREF(I)=SYMREF(I)+1
          ENDIF
 2340   CONTINUE
        IF (SYMTYP(S4) .EQ. 0) THEN
          SYMTYP(S4)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S4)=IWA(15)
        ELSE IF (SYMTYP(S4) .NE. INDVAR) THEN
          IERR=8
          GO TO 9999
        ENDIF
        IF (SYMTYP(S9) .NE. INDEX) THEN
          IERR=8
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(IIS,SYMREF(S9),1,IWA,LIWA,INFOLI)
        IHELP2=GETIWA(IIS,SYMREF(S9),3,IWA,LIWA,INFOLI)
        IF ((S4 .NE. S7) .OR. (IHELP1 .NE. 1) .OR. (IHELP2 .NE. 1)) THEN
          IERR=33
          GO TO 9999
        ENDIF
        SYMTYP(S2)=FUNC
        VEK7(1)=0
        VEK7(2)=0
        VEK7(3)=0
        VEK7(4)=0
        VEK7(5)=0
        VEK7(6)=0
        VEK7(7)=0
        CALL PUT7(VEK7,IFN,0,LIWA,PLIWA,IWA,INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        IWA(10)=IWA(10)+1
        SYMREF(S2)=IWA(10)
        DO 2350 I=IWA(9)-1,IWA(10),-1
          VEK7(1)=GETIWA(IFN,I,1,IWA,LIWA,INFOLI)
          VEK7(2)=GETIWA(IFN,I,2,IWA,LIWA,INFOLI)
          VEK7(3)=GETIWA(IFN,I,3,IWA,LIWA,INFOLI)
          VEK7(4)=GETIWA(IFN,I,4,IWA,LIWA,INFOLI)+
     1            GETIWA(IIS,SYMREF(S9),2,IWA,LIWA,INFOLI)
          VEK7(5)=GETIWA(IFN,I,5,IWA,LIWA,INFOLI)+
     1            GETIWA(IIS,SYMREF(S9),2,IWA,LIWA,INFOLI)
          VEK7(6)=GETIWA(IFN,I,6,IWA,LIWA,INFOLI)
          VEK7(7)=GETIWA(IFN,I,7,IWA,LIWA,INFOLI)+
     1            GETIWA(IIS,SYMREF(S9),2,IWA,LIWA,INFOLI)
          CALL PUT7(VEK7,IFN,I+1,LIWA,PLIWA,IWA,INFOLI,IERR)
 2350   CONTINUE
        VEK7(1)=1
        VEK7(2)=SYMREF(S4)
        VEK7(3)=GETIWA(IIS,SYMREF(S9),2,IWA,LIWA,INFOLI)
        VEK7(4)=IWA(11)-(IWA(9)-IWA(10))+1
        VEK7(5)=IWA(12)-(IWA(9)-IWA(10))+1
        VEK7(6)=PC+1
        VEK7(7)=IWA(12)-(IWA(9)-IWA(10))+1
        CALL PUT7(VEK7,IFN,IWA(10),LIWA,PLIWA,IWA,INFOLI,IERR)
        IWA(11)=IWA(11)+GETIWA(IFN,IWA(10),3,IWA,LIWA,INFOLI)
        IF (MODE .GE. GRAD) THEN
          IWA(12)=IWA(12)+GETIWA(IFN,IWA(10),3,IWA,LIWA,INFOLI)
        ENDIF
        IF (MODE .EQ. HESS) THEN
          IWA(13)=IWA(13)+GETIWA(IFN,IWA(10),3,IWA,LIWA,INFOLI)
        ENDIF
        IF (IWA(6)+IWA(8)+IWA(11)+IWA(12)*IWA(8)+
     1      IWA(13)*IWA(8)*IWA(8) .GT. LWA) THEN
          IERR=32
          GO TO 9999
        ENDIF
C
C
C stmt : ID '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 85) THEN
        S1=YYV(YYPVT-3)
        IF (SYMTYP(S1) .EQ. 0) THEN
          SYMTYP(S1)=FUNC
          VEK7(1)=-1
          VEK7(2)=0
          VEK7(3)=0
          VEK7(4)=IWA(11)+1
          VEK7(5)=IWA(12)+1
          VEK7(6)=0
          VEK7(7)=IWA(12)+1
          CALL PUT7(VEK7,IFN,0,LIWA,PLIWA,IWA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S1)=IWA(9)
          FUFLAG=0
          IWA(11)=IWA(11)+1
          IF (MODE .GE. GRAD) THEN
            IWA(12)=IWA(12)+1
          ENDIF
          IF (MODE .EQ. HESS) THEN
            IWA(13)=IWA(13)+1
          ENDIF
          IF (IWA(6)+IWA(8)+IWA(11)+IWA(12)*IWA(8)+
     1        IWA(13)*IWA(8)*IWA(8) .GT. LWA) THEN
            IERR=32
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. FUNC) THEN
          IF (GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI) .GT. 0) THEN
            IERR=35
            GO TO 9999
          ENDIF
          IF ((GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI) .EQ. -2) .AND.
     1        (FUFLAG .EQ. 1)) THEN
            IERR=59
            LNUM=LNUM-1
            GO TO 9999
          ENDIF
          FUFLAG=0
        ELSE
          IERR=8
          GO TO 9999
        ENDIF
        IF (GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI) .LE. -1) THEN
          CALL PUT1(-ASSIGN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(SYMREF(S1)-IWA(10),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,
     1              PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          CALL PUT1(ASSIGN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,
     1              PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ENDIF
        PC=IWA(14)
C
C stmt : ID '(' ID ')' '=' expr '\n' {}
C
      ELSE IF (YYTMP .EQ. 86) THEN
        S1=YYV(YYPVT-6)
        S3=YYV(YYPVT-4)
        IF (SYMTYP(S1) .EQ. FUNC) THEN
          IF (GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI) .NE. 1) THEN
            IERR=35
            GO TO 9999
          ENDIF
        ELSE
          IERR=8
          GO TO 9999
        ENDIF
        IF (SYMTYP(S3) .NE. INDVAR) THEN
          IERR=8
          GO TO 9999
        ELSE IF (GETIWA(IFN,SYMREF(S1),2,IWA,LIWA,INFOLI) .NE. 
     1           SYMREF(S3)) THEN
          IERR=33
          GO TO 9999
        ENDIF
        CALL PUT1(ASSIGN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,
     1            PLWA,WA,INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        PC=IWA(14)
        FUFLAG=0
C
C stmt : IF {} '(' logic_expr ')' THEN '\n' stmts opt_else_if
C        opt_else ENDIF '\n'
C
      ELSE IF (YYTMP .EQ. 87) THEN
        CALL PUT1(IF+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C stmt : IF '(' logic_expr ')' {} THEN '\n' stmts opt_else_if
C        opt_else ENDIF '\n'
C
      ELSE IF (YYTMP .EQ. 88) THEN
        FUFLAG=0
        S1=YYV(YYPVT-3)
        CALL PUT1(BEQ,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(-100,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        YYV(YYPVT-3)=IWA(14)
C
C stmt : IF '(' logic_expr ')' THEN '\n' stmts {} opt_else_if
C        opt_else ENDIF '\n'
C
      ELSE IF (YYTMP .EQ. 89) THEN
        FUFLAG=0
        CALL PUT1(BRA,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(-200,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C stmt : IF '(' logic_expr ')' THEN '\n' stmts opt_else_if
C        opt_else ENDIF '\n' {}
C
      ELSE IF (YYTMP .EQ. 90) THEN
        CALL PUT1(ENDIF+128,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        FUFLAG=0
        S1=YYV(YYPVT-12)
        PC1=S1
 2400   IF ((GETIWA(VPF,PC1,0,IWA,LIWA,INFOLI) .NE. -100) .AND. 
     1       (PC1 .LT. IWA(14))) THEN
          PC1=PC1+1
          GO TO 2400
        ENDIF
        PC2=PC1+1
 2410   IF ((GETIWA(VPF,PC2,0,IWA,LIWA,INFOLI).NE. -200) .AND. 
     1      (PC2 .LT. IWA(14))) THEN
          PC2=PC2+1
          GO TO 2410
        ENDIF
        IF (PC2 .LT. IWA(14)) THEN
          CALL PUT1(PC2+1,0.0D0,VPF,PC1,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
          CALL PUT1(IWA(14)+1,0.0D0,VPF,PC2,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          PC1=PC1+1
          GO TO 2400
        ELSE IF (GETIWA(VPF,PC1-1,0,IWA,LIWA,INFOLI) .EQ. BEQ) THEN
          CALL PUT1(IWA(14)+1,0.0D0,VPF,PC1,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ENDIF
C
C stmt : MARKE CONTINUE '\n' {}
C
      ELSE IF (YYTMP .EQ. 91) THEN
        S1=YYV(YYPVT-2)
        IF (MC .GT. 0) THEN
          IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
          DO 2500 I=1,MC
            IF (MARKST(I,1) .EQ. IHELP1) THEN
              IERR=57
              LNUM=IHELP1
            ENDIF
 2500     CONTINUE
          IF (IERR .NE. 0) GO TO 9999
        ENDIF
        MC=MC+1
        IF (MC .GT. MAXMAR) THEN
          IERR=32
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(VIC,S1,0,IWA,LIWA,INFOLI)
        MARKST(MC,1)=IHELP1
        MARKST(MC,2)=IWA(14)+1
        CALL PUT1(CONTIN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        CALL PUT1(IHELP1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C stmt : GOTO INUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 92) THEN
        S2=YYV(YYPVT-1)
        GC=GC+1
        IF (GC .GT. MAXMAR) THEN
          IERR=32
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
        IHELP1=GETIWA(VIC,S2,0,IWA,LIWA,INFOLI)
        GOTOST(GC,1)=IHELP1
        GOTOST(GC,2)=IWA(14)+1
        CALL PUT1(GOTO,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        CALL PUT1(IHELP1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        CALL PUT1(0,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,
     1            IERR)
        IF (IERR .NE. 0) THEN
          LNUM=LNUM-1
          GO TO 9999
        ENDIF
C
C opt_else_if : opt_else_if ELSE IF '(' logic_expr ')' {}
C               THEN stmts '\n'
C
      ELSE IF (YYTMP .EQ. 93) THEN
        FUFLAG=0
        CALL PUT1(BEQ,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(-100,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C opt_else_if : opt_else_if ELSE IF '(' logic_expr ')'
C               THEN stmts '\n' {}
C
      ELSE IF (YYTMP .EQ. 94) THEN
        CALL PUT1(BRA,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(-200,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C opt_else : /* empty */ {}
C
      ELSE IF (YYTMP .EQ. 97) THEN
        CALL UNVPF(IWA(14)-2,LIWA,PLIWA,IWA,INFOLI)
C
C expr : expr '+' expr {}
C
      ELSE IF (YYTMP .EQ. 98) THEN
        CALL PUT1(ADD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C expr : expr '-' expr {}
C
      ELSE IF (YYTMP .EQ. 99) THEN
        CALL PUT1(SUB,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C expr : expr '*' expr {}
C
      ELSE IF (YYTMP .EQ. 100) THEN
        CALL PUT1(MULT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C expr : expr '/' expr {}
C
      ELSE IF (YYTMP .EQ. 101) THEN
        FUFLAG=1
        CALL PUT1(DIV,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C expr : expr '^' expr {}
C
      ELSE IF (YYTMP .EQ. 102) THEN
        FUFLAG=1
        IHELP1=GETIWA(VPF,IWA(14),0,IWA,LIWA,INFOLI)
        IF (IHELP1 .EQ. UMINUS) THEN
          IHELP1=GETIWA(VPF,IWA(14)-2,0,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. INUM) THEN
            CALL PUT1(POWER+128,0.0D0,VPF,IWA(14)-2,LIWA,PLIWA,IWA,LWA,
     1                PLWA,WA,INFOLI,IERR)
            IHELP2=GETIWA(VPF,IWA(14)-1,0,IWA,LIWA,INFOLI)
            IHELP3=-GETIWA(VIC,IHELP2,0,IWA,LIWA,INFOLI)
            CALL PUT1(IHELP3,0.0D0,VPF,IWA(14)-1,LIWA,PLIWA,IWA,LWA,
     1                PLWA,WA,INFOLI,IERR)
            CALL UNVPF(IWA(14)-1,LIWA,PLIWA,IWA,INFOLI)
          ELSE
            CALL PUT1(POWER,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ENDIF
        ELSE
          IHELP1=GETIWA(VPF,IWA(14)-1,0,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. INUM) THEN
            CALL PUT1(POWER+128,0.0D0,VPF,IWA(14)-1,LIWA,PLIWA,IWA,LWA,
     1                PLWA,WA,INFOLI,IERR)
            IHELP2=GETIWA(VPF,IWA(14),0,IWA,LIWA,INFOLI)
            IHELP3=GETIWA(VIC,IHELP2,0,IWA,LIWA,INFOLI)
            CALL PUT1(IHELP3,0.0D0,VPF,IWA(14),LIWA,PLIWA,IWA,LWA,PLWA,
     1                WA,INFOLI,IERR)
          ELSE
            CALL PUT1(POWER,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ENDIF
        ENDIF
C
C expr : '-' expr %prec UMINUS {}
C
      ELSE IF (YYTMP .EQ. 104) THEN
        CALL PUT1(UMINUS,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C expr : SUM {} '(' expr ',' ID IN ID ')'
C
      ELSE IF (YYTMP .EQ. 110) THEN
        FUFLAG=1
        CALL PUT1(SUM,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(0,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(0,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        YYV(YYPVT)=IWA(14)-2
        PSLVL=PSLVL+1
C
C expr : SUM '(' expr ',' ID IN ID ')' {}
C
      ELSE IF (YYTMP .EQ. 111) THEN
        FUFLAG=1
        S1=YYV(YYPVT-8)
        S6=YYV(YYPVT-3)
        S8=YYV(YYPVT-1)
        IF (SYMTYP(S6) .EQ. 0) THEN
          SYMTYP(S6)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S6)=IWA(15)
        ELSE IF (SYMTYP(S6) .NE. INDVAR) THEN
          IERR=8
          GO TO 9999
        ENDIF
        IF (SYMTYP(S8) .NE. INDEX) THEN
          IERR=8
          GO TO 9999
        ENDIF
        CALL PUT1(SYMREF(S6),0.0D0,VPF,S1+1,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(SYMREF(S8),0.0D0,VPF,S1+2,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(ENDSUM,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        PSLVL=PSLVL-1
C
C expr : PROD {} '(' expr ',' ID IN ID ')'
C
      ELSE IF (YYTMP .EQ. 112) THEN
        FUFLAG=1
        CALL PUT1(PROD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(0,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(0,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        YYV(YYPVT)=IWA(14)-2
        PSLVL=PSLVL+1
C
C expr : PROD '(' expr ',' ID IN ID ')' {}
C
      ELSE IF (YYTMP .EQ. 113) THEN
        FUFLAG=1
        S1=YYV(YYPVT-8)
        S6=YYV(YYPVT-3)
        S8=YYV(YYPVT-1)
        IF (SYMTYP(S6) .EQ. 0) THEN
          SYMTYP(S6)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S6)=IWA(15)
        ELSE IF (SYMTYP(S6) .NE. INDVAR) THEN
          IERR=8
          GO TO 9999
        ENDIF
        IF (SYMTYP(S8) .NE. INDEX) THEN
          IERR=8
          GO TO 9999
        ENDIF
        CALL PUT1(SYMREF(S6),0.0D0,VPF,S1+1,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(SYMREF(S8),0.0D0,VPF,S1+2,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(ENDPRD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
        PSLVL=PSLVL+1
C
C logic_expr : logic_expr AND logic_expr {}
C
      ELSE IF (YYTMP .EQ. 114) THEN
        CALL PUT1(AND,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C logic_expr : logic_expr OR logic_expr {}
C
      ELSE IF (YYTMP .EQ. 115) THEN
        CALL PUT1(OR,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C logic_expr : NOT logic_expr {}
C
      ELSE IF (YYTMP .EQ. 116) THEN
        CALL PUT1(NOT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C logic_expr : expr RELOP expr {}
C
      ELSE IF (YYTMP .EQ. 118) THEN
        CALL PUT1(RELOP,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(YYV(YYPVT-1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C number : RNUM {}
C
      ELSE IF (YYTMP .EQ. 119) THEN
        FUFLAG=1
        CALL PUT1(RNUM,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(YYV(YYPVT),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C number : INUM {}
C
      ELSE IF (YYTMP .EQ. 120) THEN
        CALL PUT1(INUM,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(YYV(YYPVT),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C identifier : ID {}
C
      ELSE IF (YYTMP .EQ. 121) THEN
        S1=YYV(YYPVT)
        IF (SYMTYP(S1) .EQ. 0) THEN
          IF (PSLVL.EQ.0 .AND. PSCHK) THEN
            IERR=7
            GOTO 9999
          ENDIF
          SYMTYP(S1)=INDVAR
          CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
          SYMREF(S1)=IWA(15)
        ENDIF
        IF (SYMTYP(S1) .EQ. INDVAR) THEN
          CALL PUT1(INDVAR,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
        ELSE IF (SYMTYP(S1) .EQ. REAL) THEN
          FUFLAG=1
          IHELP1=GETIWA(IRC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 0) THEN
            CALL PUT1(REAL,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. INT) THEN
          IHELP1=GETIWA(IIC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 0) THEN
            CALL PUT1(INT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. VAR) THEN
          FUFLAG=1
          IHELP1=GETIWA(IVA,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 0) THEN
            CALL PUT1(VAR,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. FUNC) THEN
          IHELP1=GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. -2) THEN
            CALL PUT1(-FUNC,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1)-IWA(10),0.0D0,VPF,0,LIWA,PLIWA,IWA,
     1                LWA,PLWA,WA,INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE IF (IHELP1 .EQ. -1) THEN
            FUFLAG=1
            CALL PUT1(-FUNC,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1)-IWA(10),0.0D0,VPF,0,LIWA,PLIWA,IWA,
     1                LWA,PLWA,WA,INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE IF (IHELP1 .EQ. 0) THEN
            FUFLAG=1
            CALL PUT1(FUNC,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,
     1                LWA,PLWA,WA,INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE
          IERR=8
          GO TO 9999
        ENDIF
C
C identifier : ID '(' ind_expr ')' {}
C
      ELSE IF (YYTMP .EQ. 122) THEN
        S1=YYV(YYPVT-3)
        IF (SYMTYP(S1) .EQ. REAL) THEN
          FUFLAG=1
          IHELP1=GETIWA(IRC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 1) THEN
            CALL PUT1(REAL,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. INT) THEN
          IHELP1=GETIWA(IIC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 1) THEN
            CALL PUT1(INT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. VAR) THEN
          FUFLAG=1
          IHELP1=GETIWA(IVA,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 1) THEN
            CALL PUT1(VAR,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. FUNC) THEN
          FUFLAG=1
          IHELP1=GETIWA(IFN,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 1) THEN
            CALL PUT1(FUNC,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. 0) THEN
          IERR=7
          GO TO 9999
        ELSE
          IERR=8
          GO TO 9999
        ENDIF
C
C identifier : ID '(' ind_expr ',' ind_expr ')' {}
C
      ELSE IF (YYTMP .EQ. 123) THEN
        S1=YYV(YYPVT-5)
        IF (SYMTYP(S1) .EQ. REAL) THEN
          FUFLAG=1
          IHELP1=GETIWA(IRC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 2) THEN
            CALL PUT1(REAL,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. INT) THEN
          IHELP1=GETIWA(IIC,SYMREF(S1),1,IWA,LIWA,INFOLI)
          IF (IHELP1 .EQ. 2) THEN
            CALL PUT1(INT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1                INFOLI,IERR)
            IF (IERR .NE. 0) GO TO 9999
          ELSE
            IERR=35
            GO TO 9999
          ENDIF
        ELSE IF (SYMTYP(S1) .EQ. 0) THEN
          IERR=7
          GO TO 9999
        ELSE
          IERR=8
          GO TO 9999
        ENDIF
C
C standard_function : STDRD {}
C
      ELSE IF (YYTMP .EQ. 124) THEN
        FUFLAG=1
        S1=YYV(YYPVT)
        IF (STDTYP(S1) .EQ. 0) THEN
          CALL PUT1(STDRD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C standard_function : STDRD '(' expr ')' {}
C
      ELSE IF (YYTMP .EQ. 125) THEN
        FUFLAG=1
        S1=YYV(YYPVT-3)
        IF (STDTYP(S1) .EQ. 1) THEN
          CALL PUT1(STDRD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C standard_function : STDRD '(' expr ',' expr ')' {}
C
      ELSE IF (YYTMP .EQ. 126) THEN
        FUFLAG=1
        S1=YYV(YYPVT-5)
        IF (STDTYP(S1) .EQ. 2) THEN
          CALL PUT1(STDRD,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C extern_function : EXTERN {}
C
      ELSE IF (YYTMP .EQ. 127) THEN
        FUFLAG=1
        S1=YYV(YYPVT)
        IF (EXTTYP(S1) .EQ. 0) THEN
          CALL PUT1(EXTERN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C extern_function : EXTERN '(' ind_expr ')' {}
C
      ELSE IF (YYTMP .EQ. 128) THEN
        FUFLAG=1
        S1=YYV(YYPVT-3)
        IF (EXTTYP(S1) .EQ. 1) THEN
          CALL PUT1(EXTERN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C extern_function : EXTERN '(' ind_expr ',' ind_expr ')' {}
C
      ELSE IF (YYTMP .EQ. 129) THEN
        FUFLAG=1
        S1=YYV(YYPVT-5)
        IF (EXTTYP(S1) .EQ. 2) THEN
          CALL PUT1(EXTERN,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          CALL PUT1(S1,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
          IF (IERR .NE. 0) GO TO 9999
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
C
C interpolation_function : INTERP '(' expr ')' {}
C
      ELSE IF (YYTMP .EQ. 130) THEN
        FUFLAG=1
        S1=YYV(YYPVT-3)
        IF (SYMTYP(S1) .EQ. CONINT) THEN
          CALL PUT1(CONINT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ELSE IF (SYMTYP(S1) .EQ. LININT) THEN
          CALL PUT1(LININT,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ELSE IF (SYMTYP(S1) .EQ. SPLINE) THEN
          CALL PUT1(SPLINE,0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1              INFOLI,IERR)
        ELSE
          IERR=36
          GO TO 9999
        ENDIF
        CALL PUT1(SYMREF(S1),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(0,0.0D0,IV,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        CALL PUT1(IWA(15),0.0D0,VPF,0,LIWA,PLIWA,IWA,LWA,PLWA,WA,
     1            INFOLI,IERR)
        IF (IERR .NE. 0) GO TO 9999
C
C spl_interpolation_head : SPLINE ID '\n' {}
C
      ELSE IF (YYTMP .EQ. 131) THEN
        IF (SPFLAG .GT. 0) THEN
          IHELP1=GETIWA(IRC,SYMREF(IPOL),4,IWA,LIWA,INFOLI)
          DIM=GETIWA(IRC,SYMREF(IPOL),2,IWA,LIWA,INFOLI)/5-1
          CALL SPLNES(WA(IHELP1),DIM,IERR,LNUM)
          IF (IERR .NE. 0) GO TO 9999
          SPFLAG=0
        ENDIF
        CALL CAS131(YYV,YYPVT,SYMTYP,SYMREF,MAXSYM,IERR,LNUM,
     1              LIWA,PLIWA,IWA,INFOLI,IPOL,SPFLAG)
        IF (IERR .NE. 0) GO TO 9999
C
C spline_declaration : RNUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 134) THEN
        CALL CAS134(YYV,YYPVT,SYMREF,MAXSYM,IERR,LNUM,
     1              LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IPOL)
        IF (IERR .NE. 0) GO TO 9999
C
C spline_declaration : RNUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 135) THEN
        CALL CAS135(YYV,YYPVT,SYMREF,MAXSYM,IERR,LNUM,
     1              LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IPOL)
        IF (IERR .NE. 0) GO TO 9999
C
C spline_declaration : '-' RNUM RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 136) THEN
        CALL CAS136(YYV,YYPVT,SYMREF,MAXSYM,IERR,LNUM,
     1              LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IPOL)
        IF (IERR .NE. 0) GO TO 9999
C
C spline_declaration : '-' RNUM '-' RNUM '\n' {}
C
      ELSE IF (YYTMP .EQ. 137) THEN
        CALL CAS137(YYV,YYPVT,SYMREF,MAXSYM,IERR,LNUM,
     1              LIWA,PLIWA,IWA,LWA,PLWA,WA,INFOLI,IPOL)
        IF (IERR .NE. 0) GO TO 9999
C
C
C
      ELSE
        IERR=26
        WRITE(*,*) 'YYPAR (2833) : unknown state ',YYTMP
        GO TO 9999
      ENDIF
C
C reset registers in driver code
C
      GO TO 10
 9999 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE INIRED (YYREDS)
      CHARACTER*100 YYREDS(0:138)
C
      YYREDS(0)='-no such reduction-'
      YYREDS(1)='module : declaration_blocks end_module'
      YYREDS(2)='declaration_blocks : declaration_blocks '//
     &  'declaration_block'
      YYREDS(3)='declaration_blocks : /* empty */'
      YYREDS(4)='declaration_block : param_head param_declarations'
      YYREDS(5)='declaration_block : index_head index_declarations'
      YYREDS(6)='declaration_block : real_head real_declarations'
      YYREDS(7)='declaration_block : integer_head integer_declarations'
      YYREDS(8)='declaration_block : table_head table_declarations'
      YYREDS(9)='declaration_block : con_interpolation_head '//
     &  'interpolation_declarations'
      YYREDS(10)='declaration_block : lin_interpolation_head '//
     &  'interpolation_declarations'
      YYREDS(11)='declaration_block : spl_interpolation_head '//
     &  'spline_declarations'
      YYREDS(12)='declaration_block : variable_head '//
     &  'variable_declarations'
      YYREDS(13)='declaration_block : infunc_head infunc_declarations'
      YYREDS(14)='declaration_block : function_head stmts'
      YYREDS(15)='param_head : PARAM ''-newline-'''
      YYREDS(16)='param_declarations : param_declarations '//
     &  'param_declaration'
      YYREDS(17)='param_declarations : /* empty */'
      YYREDS(18)='param_declaration : ID ''='' INUM ''-newline-'''
      YYREDS(19)='index_head : INDEX ''-newline-'''
      YYREDS(20)='index_declarations : index_declarations '//
     &  'index_declaration'
      YYREDS(21)='index_declarations : /* empty */'
      YYREDS(22)='index_declaration : ID ''='' index_delimiter '//
     &  'RANGE index_delimiter ''-newline-'''
      YYREDS(23)='index_declaration : ID ''='' INUM '','' INUM'
      YYREDS(24)='index_declaration : ID ''='' INUM '','' INUM '//
     &  'opt_inum ''-newline-'''
      YYREDS(25)='index_declaration : ID ''='' ind_expr '','' ID '//
     &  '''='' index_delimiter RANGE index_delimiter ''-newline-'''
      YYREDS(26)='index_delimiter : ID'
      YYREDS(27)='index_delimiter : INUM'
      YYREDS(28)='opt_inum : opt_inum '','' INUM'
      YYREDS(29)='opt_inum : /* empty */'
      YYREDS(30)='ind_expr : ind_expr ''+'' ind_expr'
      YYREDS(31)='ind_expr : ind_expr ''-'' ind_expr'
      YYREDS(32)='ind_expr : ind_expr ''*'' ind_expr'
      YYREDS(33)='ind_expr : ind_expr ''/'' ind_expr'
      YYREDS(34)='ind_expr : ''('' ind_expr '')'''
      YYREDS(35)='ind_expr : ''-'' ind_expr'
      YYREDS(36)='ind_expr : INUM'
      YYREDS(37)='ind_expr : ID'
      YYREDS(38)='real_head : REAL ''-newline-'''
      YYREDS(39)='real_declarations : real_declarations '//
     &  'real_declaration'
      YYREDS(40)='real_declarations : /* empty */'
      YYREDS(41)='real_declaration : ID ''='' expr ''-newline-'''
      YYREDS(42)='real_declaration : ID ''('' ID '')'' ''='' expr '//
     &  ''','' ID IN ID ''-newline-'''
      YYREDS(43)='real_declaration : ID ''('' INUM '')'' ''='' expr '//
     &  '''-newline-'''
      YYREDS(44)='real_declaration : ID ''('' ID '','' ID '')'' '//
     &  '''='' expr '','' IDIN ID '','' ID IN ID ''-newline-'''
      YYREDS(45)='real_declaration : ID ''('' INUM '','' INUM '')'' '//
     &  '''='' expr ''-newline-'''
      YYREDS(46)='integer_head : INT ''-newline-'''
      YYREDS(47)='integer_declarations : integer_declarations '//
     &  'integer_declaration'
      YYREDS(48)='integer_declarations : /* empty */'
      YYREDS(49)='integer_declaration : ID ''='' expr ''-newline-'''
      YYREDS(50)='integer_declaration : ID ''('' ID '')'' ''='' '//
     &  'expr '','' ID IN ID ''-newline-'''
      YYREDS(51)='integer_declaration : ID ''('' INUM '')'' ''='' '//
     &  'expr ''-newline-'''
      YYREDS(52)='integer_declaration : ID ''('' ID '','' ID '')'' '//
     &  '''='' expr '','' ID IN ID '','' ID IN ID ''-newline-'''
      YYREDS(53)='integer_declaration : ID ''('' INUM '','' INUM '//
     &  ''')'' ''='' expr ''-newline-'''
      YYREDS(54)='table_head : TABLE ID ''('' ID '')'' '','' ID IN '//
     &  'ID ''-newline-'''
      YYREDS(55)='table_head : TABLE ID ''('' ID '','' ID '')'' '//
     &  ''','' ID IN ID '','' ID IN ID ''-newline-'''
      YYREDS(56)='table_declarations : table_declarations '//
     &  'table_declaration'
      YYREDS(57)='table_declarations : /* empty */'
      YYREDS(58)='table_declaration : INUM RNUM ''-newline-'''
      YYREDS(59)='table_declaration : INUM ''-'' RNUM ''-newline-'''
      YYREDS(60)='table_declaration : INUM INUM RNUM ''-newline-'''
      YYREDS(61)='table_declaration : INUM INUM ''-'' RNUM '//
     & '''-newline-'''
      YYREDS(62)='con_interpolation_head : CONINT ID ''-newline-'''
      YYREDS(63)='lin_interpolation_head : LININT ID ''-newline-'''
      YYREDS(64)='interpolation_declarations : '//
     &  'interpolation_declarations interpolation_declaration'
      YYREDS(65)='interpolation_declarations : /* empty */'
      YYREDS(66)='interpolation_declaration : RNUM RNUM ''-newline-'''
      YYREDS(67)='interpolation_declaration : RNUM ''-'' RNUM '//
     &  '''-newline-'''
      YYREDS(68)='interpolation_declaration : ''-'' RNUM RNUM '//
     &  '''-newline-'''
      YYREDS(69)='interpolation_declaration : ''-'' RNUM ''-'' RNUM '//
     &  '''-newline-'''
      YYREDS(70)='variable_head : VAR ''-newline-'''
      YYREDS(71)='variable_declarations : variable_declarations '//
     &  'variable_declaration'
      YYREDS(72)='variable_declarations : /* empty */'
      YYREDS(73)='variable_declaration : ID ''('' ID '')'' '','' ID '//
     &  'IN ID ''-newline-'''
      YYREDS(74)='variable_declaration : ID opt_id ''-newline-'''
      YYREDS(75)='opt_id : opt_id '','' ID'
      YYREDS(76)='opt_id : /* empty */'
      YYREDS(77)='infunc_head : INFUNC ''-newline-'''
      YYREDS(78)='infunc_declarations : infunc_declarations '//
     &  'infunc_declaration'
      YYREDS(79)='infunc_declarations : /* empty */'
      YYREDS(80)='infunc_declaration : ID opt_id ''-newline-'''
      YYREDS(81)='function_head : FUNC ID ''-newline-'''
      YYREDS(82)='function_head : FUNC ID ''('' ID '')'' '','' ID '//
     &  'IN ID ''-newline-'''
      YYREDS(83)='stmts : stmts stmt'
      YYREDS(84)='stmts : /* empty */'
      YYREDS(85)='stmt : ID ''='' expr ''-newline-'''
      YYREDS(86)='stmt : ID ''('' ID '')'' ''='' expr ''-newline-'''
      YYREDS(87)='stmt : IF'
      YYREDS(88)='stmt : IF ''('' logic_expr '')'''
      YYREDS(89)='stmt : IF ''('' logic_expr '')'' THEN '//
     &  '''-newline-'' stmts'
      YYREDS(90)='stmt : IF ''('' logic_expr '')'' THEN '//
     &  '''-newline-'' stmts opt_else_if opt_else ENDIF ''-newline-'''
      YYREDS(91)='stmt : LABEL CONTINUE ''-newline-'''
      YYREDS(92)='stmt : GOTO INUM ''-newline-'''
      YYREDS(93)='opt_else_if : opt_else_if ELSE IF ''('' '//
     &  'logic_expr '')'''
      YYREDS(94)='opt_else_if : opt_else_if ELSE IF ''('' '//
     &  'logic_expr '')'' THEN ''-newline-'' stmts'
      YYREDS(95)='opt_else_if : /* empty */'
      YYREDS(96)='opt_else : ELSE ''-newline-'' stmts'
      YYREDS(97)='opt_else : /* empty */'
      YYREDS(98)='expr : expr ''+'' expr'
      YYREDS(99)='expr : expr ''-'' expr'
      YYREDS(100)='expr : expr ''*'' expr'
      YYREDS(101)='expr : expr ''/'' expr'
      YYREDS(102)='expr : expr ''^'' expr'
      YYREDS(103)='expr : ''('' expr '')'''
      YYREDS(104)='expr : ''-'' expr'
      YYREDS(105)='expr : number'
      YYREDS(106)='expr : identifier'
      YYREDS(107)='expr : standard_function'
      YYREDS(108)='expr : extern_function'
      YYREDS(109)='expr : interpolation_function'
      YYREDS(110)='expr : SUM'
      YYREDS(111)='expr : SUM ''('' expr '','' ID IN ID '')'''
      YYREDS(112)='expr : PROD'
      YYREDS(113)='expr : PROD ''('' expr '','' ID IN ID '')'''
      YYREDS(114)='logic_expr : logic_expr AND logic_expr'
      YYREDS(115)='logic_expr : logic_expr OR logic_expr'
      YYREDS(116)='logic_expr : NOT logic_expr'
      YYREDS(117)='logic_expr : ''('' logic_expr '')'''
      YYREDS(118)='logic_expr : expr RELOP expr'
      YYREDS(119)='number : RNUM'
      YYREDS(120)='number : INUM'
      YYREDS(121)='identifier : ID'
      YYREDS(122)='identifier : ID ''('' ind_expr '')'''
      YYREDS(123)='identifier : ID ''('' ind_expr '','' ind_expr '')'''
      YYREDS(124)='standard_function : STANDARD'
      YYREDS(125)='standard_function : STANDARD ''('' expr '')'''
      YYREDS(126)='standard_function : STANDARD ''('' expr '','' '//
     &  'expr '')'''
      YYREDS(127)='extern_function : EXTERN'
      YYREDS(128)='extern_function : EXTERN ''('' ind_expr '')'''
      YYREDS(129)='extern_function : EXTERN ''('' ind_expr '','' '//
     &  'ind_expr '')'''
      YYREDS(130)='interpolation_function : INTERP ''('' expr '')'''
      YYREDS(131)='spl_interpolation_head : SPLINE ID ''-newline-'''
      YYREDS(132)='spline_declarations : spline_declarations '//
     &  'spline_declaration'
      YYREDS(133)='spline_declarations : /* empty */'
      YYREDS(134)='spline_declaration : RNUM RNUM ''-newline-'''
      YYREDS(135)='spline_declaration : RNUM ''-'' RNUM ''-newline-'''
      YYREDS(136)='spline_declaration : ''-'' RNUM RNUM ''-newline-'''
      YYREDS(137)='spline_declaration : ''-'' RNUM ''-'' RNUM '//
     &  '''-newline-'''
      YYREDS(138)='end_module : END ''-newline-'''
      RETURN
      END
