C*********************************************
C                                            *
C   PROGRAM   : PCOMP                        *
C   MODULE    : G (FORTRAN CODE GENERATOR)   *
C   ABSTRACT  : FORTRAN PRECOMPILER          *
C   KEY WORD  : AUTOMATIC DIFFERENTIATION    *
C   SOURCE    : PCOMP 2.3 by M.LIEPELT       *
C               PCOMP 3.0 by M.DOBMANN       *
C   COPYRIGHT : C.TRASSL, K.SCHITTKOWSKI     *
C               MATHEMATISCHES INSTITUT,     *
C               UNIVERSITAET BAYREUTH,       *
C               D-95440 BAYREUTH, GERMANY    *
C   DATE      : JUNE 8, 1999                 *
C   VERSION   : 5.5                          *
C                                            *
C*********************************************
C                                                                      
C
C
      SUBROUTINE SYMPRP (SYMFIL,WA,LWA,IWA,LIWA,UWA,UIWA,IERR,MODE,
     /                   NVAR,NFUNC)
      INTEGER SYMFIL
      INTEGER LWA,LIWA
      DOUBLE PRECISION WA(LWA)
      INTEGER IWA(LIWA)
      INTEGER UWA,UIWA
      INTEGER IERR,MODE,NVAR,NFUNC
C
C**********************************************************************
C
C   S Y M P R P   -   LOAD INTERMEDIATE CODE GENERATED BY SYMINP FROM
C                     SYMFIL INTO WORKING ARRAYS.
C
C   PARAMETERS:
C      SYMFIL    - INPUT DEVICE; THE INTERMEDIATE CODE GENERATED BY
C                  SYMINP WAS WRITTEN TO THIS FILE AND IS NOW LOADED.
C      WA(LWA)   - REAL WORKING ARRAY, REQUIRED BY SYMPRP. ON RETURN,
C                  WA() CONTAINS THE INTERMEDIATE CODE.
C      IWA(LIWA) - INTEGER WORKING ARRAY, CF. WA().
C      UWA,UIWA  - INDICATE THE ACTUAL SPACE OF WA() AND IWA() THAT
C                  HAS BEEN USED BY THE SUBROUTINE.
C      IERR      - THE PARAMETER SHOWS THE REASON FOR TERMINATING THE
C                  SUBROUTINE. ON RETURN IERR COULD CONTAIN THE FOLLOW-
C                  ING VALUES:
C                  IERR = 0 : SUCCESSFUL TERMINATION.
C                  IERR > 0 : AN ERROR HAS BEEN DETECTED. FOR FURTHER
C                             INFORMATION CF. SUBROUTINE SYMERR.
C      MODE      - THE PARAMETER IS USED FOR THE RESERVATION OF SPACE
C                  FOR THE HESSIAN MATRIX
C      NVAR      - ON RETURN, NVAR CONTAINS THE NUMBER OF VARIABLES ON
C                  FUNCTION INPUT FILE
C      NFUNC     - ON RETURN, NFUNC CONTAINS THE NUMBER OF FUNCTIONS ON
C                  INPUT FILE
C
C**********************************************************************
C
      INTEGER I,PWA,PIWA,PX,PIX
C
      INTEGER GSMDEP,GETIWA,HILF
      PARAMETER (GSMDEP=10)
C
      INTEGER HSMDEP
      PARAMETER (HSMDEP=10)
C
      INTEGER GRAD,HESS
      PARAMETER (GRAD=1,HESS=2)
C
      INTEGER IFN
      PARAMETER (IFN=9)
      INTEGER INFOLI(15)
C
      DO 10 I=1,15
        READ(SYMFIL,'(I6)',ERR=100) IWA(I)
 10   CONTINUE
      PIWA=IWA(1)*5+IWA(2)+IWA(3)*4+IWA(4)+IWA(5)*4+IWA(7)*3+
     1     IWA(9)*7+IWA(14)+15
      PWA=IWA(6)
      IF (MODE .EQ. GRAD) THEN
        PX=IWA(8)+IWA(11)+IWA(12)*IWA(8)+GSMDEP*IWA(8)+HSMDEP+1
      ELSE IF (MODE .EQ. HESS) THEN
        PX=IWA(8)+IWA(11)+IWA(12)*IWA(8)+IWA(13)*IWA(8)*IWA(8)+
     1     GSMDEP*IWA(8)+HSMDEP*IWA(8)*IWA(8)
      ELSE
        IERR=61
        RETURN
      ENDIF
      IF (MODE .NE. HESS) THEN
        IWA(13)=0
      ENDIF
      PIX=IWA(15)
      IF ((PWA+PX .GT. LWA) .OR. (PIWA+PIX .GT. LIWA)) THEN
        IERR=32
        RETURN
      ENDIF
      DO 20 I=16,PIWA
        READ(SYMFIL,'(I6)',ERR=100) IWA(I)
 20   CONTINUE
C
      NVAR=IWA(8)
      NFUNC=IWA(10)
      INFOLI(1)=15
      INFOLI(2)=IWA(1)*5+INFOLI(1)
      INFOLI(3)=IWA(2)+INFOLI(2)
      INFOLI(4)=IWA(3)*4+INFOLI(3)
      INFOLI(5)=IWA(4)+INFOLI(4)
      INFOLI(7)=IWA(5)*4+INFOLI(5)
      INFOLI(9)=IWA(7)*3+INFOLI(7)
      INFOLI(14)=IWA(9)*7+INFOLI(9)
      INFOLI(15)=IWA(14)+INFOLI(14)
C
      INFOLI(6)=0
      INFOLI(8)=IWA(6)+INFOLI(6)
      INFOLI(11)=IWA(8)+INFOLI(8)
      INFOLI(12)=IWA(11)+INFOLI(11)
      INFOLI(13)=IWA(12)+INFOLI(12)
C
      DO 50 I=1,IWA(9)
        HILF=GETIWA(IFN,I,1,IWA,LIWA,INFOLI)
        IF (HILF.EQ.1) THEN
          NFUNC=NFUNC + GETIWA(IFN,I,3,IWA,LIWA,INFOLI)-1
        ENDIF
   50 CONTINUE
C
      DO 30 I=1,PWA
        READ(SYMFIL,'(D24.17)',ERR=100) WA(I)
 30   CONTINUE
      IERR=0
      UWA=PWA+PX
      UIWA=PIWA+PIX
      RETURN
 100  IERR=26
      RETURN
      END
C
C
C
C     INTEGER FUNCTION GETIWA(FELD,DIM1,DIM2,IWA,LIWA,INFOLI)
C
C     INTEGER FELD,DIM1,DIM2,LIWA
C     INTEGER IWA(LIWA),INFOLI(15)
C
C     INTEGER IIS,VIS,IIC,VIC,IRC,IVA,IFN,VPF,IV
C     INTEGER LIIS,LVIS,LIIC,LVIC,LIRC,LIVA,LIFN,LVPF,LIV
C
C     PARAMETER (IIS=1,VIS=2,IIC=3,VIC=4,IRC=5,IVA=7,IFN=9,VPF=14,IV=15)
C
C     LIIS=INFOLI(1)
C     LVIS=INFOLI(2)
C     LIIC=INFOLI(3)
C     LVIC=INFOLI(4)
C     LIRC=INFOLI(5)
C     LIVA=INFOLI(7)
C     LIFN=INFOLI(9)
C     LVPF=INFOLI(14)
C     LIV =INFOLI(15)
C
C
C     IF (FELD .EQ. IIS) THEN
C       IF (IWA(1) .GT. 1) THEN
C         GETIWA=IWA(LIIS+IWA(1)*(DIM2-1)+DIM1)
C       ELSE
C         GETIWA=IWA(LIIS+DIM2)
C       ENDIF
C
C     ELSE IF (FELD .EQ. VIS) THEN
C       GETIWA=IWA(INFOLI(2)+DIM1)
C 
C     ELSE IF (FELD .EQ. IIC) THEN
C       IF (IWA(3) .GT. 1) THEN
C         GETIWA=IWA(LIIC+IWA(3)*(DIM2-1)+DIM1)
C       ELSE
C         GETIWA=IWA(LIIC+DIM2)
C       ENDIF
C
C     ELSE IF (FELD .EQ. VIC) THEN
C       GETIWA=IWA(INFOLI(4)+DIM1)
C 
C     ELSE IF (FELD .EQ. IRC) THEN
C       IF (IWA(5) .GT. 1) THEN
C         GETIWA=IWA(LIRC+IWA(5)*(DIM2-1)+DIM1)
C       ELSE
C         GETIWA=IWA(LIRC+DIM2)
C       ENDIF
C
C     ELSE IF (FELD .EQ. IVA) THEN
C       IF (IWA(7) .GT. 1) THEN
C         GETIWA=IWA(LIVA+IWA(7)*(DIM2-1)+DIM1)
C       ELSE
C         GETIWA=IWA(LIVA+DIM2)
C       ENDIF
C
C     ELSE IF (FELD .EQ. IFN) THEN
C       IF (IWA(9) .GT. 1) THEN
C         GETIWA=IWA(LIFN+IWA(9)*(DIM2-1)+DIM1)
C       ELSE
C         GETIWA=IWA(LIFN+DIM2)
C       ENDIF
C
C     ELSE IF (FELD .EQ. VPF) THEN
C       GETIWA=IWA(INFOLI(14)+DIM1)
C 
C     ELSE IF (FELD .EQ. IV) THEN
C       GETIWA=IWA(INFOLI(15)+DIM1)
C 
C     ENDIF
C     RETURN
C     END
C
C
C
      SUBROUTINE SYMFOR (XFIL,WA,LWA,IWA,LIWA,IERR)
      INTEGER XFIL
      INTEGER LWA,LIWA
      DOUBLE PRECISION WA(LWA)
      INTEGER IWA(LIWA)
      INTEGER IERR
C
C**********************************************************************
C
C   S Y M F O R   -   GENERATE EXECUTABLE FORTRAN CODE FOR EVALUATION
C                     OF FUNCTIONS AND GRADIENTS. 
C                                                                      
C   PARAMETERS:                                                         
C      XFIL      - OUTPUT DEVICE; THE EXECUTABLE FORTRAN CODE GENERATED
C                  BY SYMFOR IS WRITTEN TO THIS FILE.
C      WA(LWA)   - REAL WORKING ARRAY, CONTAINS THE INTERMEDIATE CODE
C                  GENERATED BY SYMINP.
C      IWA(LIWA) - INTEGER WORKING ARRAY, CF. WA(LWA). 
C      IERR      - THE PARAMETER SHOWS THE REASON FOR TERMINATING THE 
C                  SUBROUTINE. ON RETURN IERR COULD CONTAIN THE FOLLOW-
C                  ING VALUES:
C                  IERR = 0 : SUCCESSFUL TERMINATION.
C                  IERR > 0 : AN ERROR HAS BEEN DETECTED. FOR FURTHER
C                             INFORMATION CF. SUBROUTINE SYMERR.
C                                                                       
C**********************************************************************
C
C     INTEGER PIIS,PVIS,PIIC,PVIC,PIRC,PVRC,PIVA,PVVA,PIFN,PXFN,PVFN
      INTEGER PIIS,PVIS,PIIC,PVIC,PIRC,PIVA,PIFN
C     INTEGER PVGR,PVPF,PIV,LIIS,LVIS,LIIC,LVIC,LIRC,LVRC,LIVA,LVVA
      INTEGER PVPF,PIV,LIIS,LVIS,LIIC,LVIC,LIRC,LVRC,LIVA
C     INTEGER LIFN,LVFN,LVGR,LVPF,LIV
      INTEGER LIFN,LVPF,LIV
      INTEGER PVQD,LVQD
      INTEGER PIP,LIP,MAXVIP
C
      INTEGER MPIIS,MPVIS,MPIIC,MPVIC,MPIRC,MPVRC,MPIVA,MPVVA,MPIFN
      INTEGER MPXFN,MPVFN,MPVPF,MPIV
C
      INTEGER MAXVQD
C
      INTEGER MAXXC,MAXLC,MAXIC
      LOGICAL EXCALL
C
      PIIS=IWA(1)
      PVIS=IWA(2)
      PIIC=IWA(3)
      PVIC=IWA(4)
      PIRC=IWA(5)
C      PVRC=IWA(6)
      PIVA=IWA(7)
C      PVVA=IWA(8)
      PIFN=IWA(9)
C     PXFN=IWA(10)
C      PVFN=IWA(11)
C     PVGR=IWA(12)
      PVPF=IWA(14)
      PIV=IWA(15)
      PIP=0
      LIIS=16
      LVIS=LIIS+PIIS*5
      LIIC=LVIS+PVIS
      LVIC=LIIC+PIIC*4
      LIRC=LVIC+PVIC
      LVRC=1
      LIVA=LIRC+PIRC*4
C      LVVA=LVRC+PVRC
      LIFN=LIVA+PIVA*3
C      LVFN=LVVA+PVVA
C     LVGR=LVFN+PVFN
      LVPF=LIFN+PIFN*7
      LIV=LVPF+PVPF
      MAXVIP=50
      LIP=LIV+MAXVIP
      LVQD=LIP+PIV
      IF ((LIWA-5+1) .LT. LVQD) THEN
         IERR=65
         RETURN
      ENDIF
      MAXVQD=(LIWA-LVQD+1)/5
C
            MPIIS=MAX(1,IWA(1))
            MPVIS=MAX(1,IWA(2))
            MPIIC=MAX(1,IWA(3))
            MPVIC=MAX(1,IWA(4))
            MPIRC=MAX(1,IWA(5))
            MPVRC=MAX(1,IWA(6))
            MPIVA=MAX(1,IWA(7))
            MPVVA=MAX(1,IWA(8))
            MPIFN=MAX(1,IWA(9))
            MPXFN=MAX(1,IWA(10))
            MPVFN=MAX(1,IWA(11))
            MPVPF=MAX(1,IWA(14))
            MPIV =MAX(1,IWA(15))
      CALL REVCDE(MPIIS,MPIIC,MPVIC,MPIRC,MPIVA,MPVVA,MPIFN,MPXFN,MPVPF,
     1            IWA(LIIS),IWA(LIIC),IWA(LVIC),IWA(LIRC),IWA(LIVA),
     2            IWA(LIFN),IWA(LVPF),IWA(LIP),MAXVIP,PIP,MAXVQD,
     3            IWA(LVQD),PVQD,MAXXC,MAXLC,MAXIC,EXCALL,IERR)
C
c      CALL REVCDE(PIIS,PIIC,PVIC,PIRC,PIVA,PVVA,PIFN,PXFN,PVPF,
c     1            IWA(LIIS),IWA(LIIC),IWA(LVIC),IWA(LIRC),IWA(LIVA),
c     2            IWA(LIFN),IWA(LVPF),IWA(LIP),MAXVIP,PIP,MAXVQD,
c     3            IWA(LVQD),PVQD,MAXXC,MAXLC,MAXIC,EXCALL,IERR)
      IF (IERR .NE. 0) THEN
        RETURN
      ENDIF
C
      CALL FORCDE(XFIL,MPVIS,MPVIC,MPVRC,MPVVA,MPIFN,MPXFN,MPVFN,MPIV,
     1            IWA(LVIS),IWA(LVIC),WA(LVRC),MAXVQD,IWA(LVQD),MAXXC,
     2            MAXLC,MAXIC,EXCALL,IERR,IWA(LIP),MAXVIP,PIP)
C
c      CALL FORCDE(XFIL,PVIS,PVIC,PVRC,PVVA,PIFN,PXFN,PVFN,PIV,
c     1            IWA(LVIS),IWA(LVIC),WA(LVRC),MAXVQD,IWA(LVQD),MAXXC,
c     2            MAXLC,MAXIC,EXCALL,IERR,IWA(LIP),MAXVIP,PIP)
      RETURN
      END
C
C
C
      SUBROUTINE REVCDE (PIIS,PIIC,PVIC,PIRC,PIVA,PVVA,PIFN,PXFN,PVPF,
     1                   IINDEX,IICONS,VICONS,IRCONS,IVARI,IFUNC,VPFX,
     2                   VIP,MAXVIP,PIP,MAXVQD,VQD,PVQD,MAXXC,MAXLC,
     3                   MAXIC,EXCALL,IERR)
      INTEGER PIIS,PIIC,PVIC,PIRC,PIVA,PVVA,PIFN,PXFN,PVPF
      INTEGER IINDEX(PIIS,5),IICONS(PIIC,4),VICONS(PVIC)
      INTEGER IRCONS(PIRC,4),IVARI(PIVA,3),IFUNC(PIFN,7),VPFX(PVPF)
      INTEGER MAXVQD
      INTEGER VQD(MAXVQD,5)
      INTEGER PVQD
      INTEGER MAXXC,MAXLC,MAXIC
      LOGICAL EXCALL
      INTEGER IERR
      INTEGER PIP,MAXVIP
      INTEGER VIP(MAXVIP)
C
      INTEGER ADD,SUB,MULT,DIV,POWER,ASSIGN
      INTEGER RELOP,AND,OR,NOT,INUM,RNUM,SUM,PROD,IF
      INTEGER ENDIF,STDRD,EXTERN,REAL,INT
      INTEGER CONINT,LININT,SPLINE,VAR,FUNC,GOTO,CONTIN
      INTEGER UMINUS,INDVAR,ENDSUM,ENDPRD,BEQ,BRA,LABEL,VECTOR,ACTIVE
      PARAMETER (ADD=43,SUB=45,MULT=42,DIV=47,POWER=94)
      PARAMETER (ASSIGN=61,RELOP=258)
      PARAMETER (AND=259,OR=260,NOT=261,INUM=262,RNUM=263)
      PARAMETER (SUM=265,PROD=266,IF=268)
      PARAMETER (ENDIF=271,STDRD=272,EXTERN=273)
      PARAMETER (REAL=277,INT=278,CONINT=280)
      PARAMETER (LININT=281,SPLINE=282,VAR=283,FUNC=285)
      PARAMETER (GOTO=287,CONTIN=289,UMINUS=290)
      PARAMETER (INDVAR=291,ENDSUM=292,ENDPRD=293,BEQ=294,BRA=295)
      PARAMETER (LABEL=296,VECTOR=297,ACTIVE=298)
C
      INTEGER MAXSTD,MAXEXT
      PARAMETER (MAXSTD=17,MAXEXT=1)
      INTEGER STDTYP(MAXSTD),EXTTYP(MAXEXT)
C
      INTEGER LSMDEP,RSMDEP,XSMDEP,ISMDEP
      PARAMETER (LSMDEP=10,RSMDEP=40,XSMDEP=10,ISMDEP=10)
      INTEGER LSTACK(LSMDEP),RSTACK(RSMDEP)
      INTEGER XSTACK(XSMDEP),ISTACK(ISMDEP)
      INTEGER LTOS,RTOS,XTOS,ITOS
      INTEGER DIM,FC,K,LC,PC,QC,QC1,QC2,X,XC,IC
C
      DATA STDTYP /1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1/
      DATA EXTTYP /0/
C
      QC=2
      FC=1
      MAXXC=0
      MAXLC=0
      MAXIC=0
      EXCALL=.FALSE.
C
 1    LC=0
      XC=PVVA
      LTOS=0
      RTOS=0
      XTOS=0
      PC=IFUNC(FC,6)
      IC=0
      ITOS=0
C
      ISTACK(1)=0
      XSTACK(1)=0
C------------------------------------------------------------
      IF (IFUNC(FC,1) .EQ. 1) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=VECTOR
        VQD(QC,2)=IFUNC(FC,2)
        VQD(QC,3)=IFUNC(FC,3)
        VQD(QC,4)=0
        VQD(QC,5)=0
C*******************************************************
C That's really bad - change the parser YYPAR!
C*******************************************************
        DO 7 K=1,PIIS
          IF ((IINDEX(K,1) .EQ. 1) .AND.
     1        (IINDEX(K,3) .EQ. 1) .AND.
     2        (IINDEX(K,4) .EQ. IFUNC(FC,3))) THEN
            VQD(QC,4)=IINDEX(K,5)
          ENDIF
 7      CONTINUE
C*******************************************************
        RTOS=RTOS+1
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RSTACK(RTOS)=QC
      ENDIF
C------------------------------------------------------------
      QC=QC+1
      IF (QC .GT. MAXVQD) THEN
        IERR=32
        RETURN
      ENDIF
C
      IF (IFUNC(FC,1) .LE. 0) THEN
        VQD(QC,1)=ACTIVE
        VQD(QC,2)=IFUNC(FC,4)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=0
      ELSE
        VQD(QC,1)=ACTIVE
        VQD(QC,2)=-IFUNC(FC,2)
        VQD(QC,3)=IFUNC(FC,4)-1
        VQD(QC,4)=0
        VQD(QC,5)=0
      ENDIF
C------------------------------------------------------------
C
 2    X=VPFX(PC)
 10   IF (X .EQ. -1) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=-1
        VQD(QC,2)=0
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=0
C------------------------------------------------------------
        IF (IFUNC(FC,1) .EQ. 1) THEN
          VQD(QC,2)=QC
          VQD(RSTACK(RTOS),5)=QC
          RTOS=RTOS-1
        ENDIF
C------------------------------------------------------------
        FC=FC+1
        IF (FC .GT. PXFN) THEN
C       IF (FC .GT. PIFN) THEN
          PVQD=QC
          RETURN
        ELSE
          GO TO 1
        ENDIF
      ENDIF
C
 20   IF (X .EQ. ADD+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=ADD+128
        VQD(QC,2)=0
        VQD(QC,3)=ISTACK(ITOS-1)
        VQD(QC,4)=ISTACK(ITOS)
        VQD(QC,5)=IC
        ISTACK(ITOS-1)=IC
        ITOS=ITOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 30   IF (X .EQ. SUB+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=SUB+128
        VQD(QC,2)=0
        VQD(QC,3)=ISTACK(ITOS-1)
        VQD(QC,4)=ISTACK(ITOS)
        VQD(QC,5)=IC
        ISTACK(ITOS-1)=IC
        ITOS=ITOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 40   IF (X .EQ. MULT+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=MULT+128
        VQD(QC,2)=0
        VQD(QC,3)=ISTACK(ITOS-1)
        VQD(QC,4)=ISTACK(ITOS)
        VQD(QC,5)=IC
        ISTACK(ITOS-1)=IC
        ITOS=ITOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 50   IF (X .EQ. DIV+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=DIV+128
        VQD(QC,2)=0
        VQD(QC,3)=ISTACK(ITOS-1)
        VQD(QC,4)=ISTACK(ITOS)
        VQD(QC,5)=IC
        ISTACK(ITOS-1)=IC
        ITOS=ITOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 60   IF (X .EQ. UMINUS+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=UMINUS+128
        VQD(QC,2)=0
        VQD(QC,3)=ISTACK(ITOS)
        VQD(QC,4)=0
        VQD(QC,5)=IC
        ISTACK(ITOS)=IC
        PC=PC+1
        GO TO 2
      ENDIF
 70   IF (X .EQ. INUM+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=INUM+128
        VQD(QC,2)=VICONS(VPFX(PC+1))
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=IC
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IC
        PC=PC+2
        GO TO 2
      ENDIF
 80   IF (X .EQ. FUNC+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=FUNC+128
        VQD(QC,2)=IFUNC(VPFX(PC+1),4)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=IC
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IC
        PC=PC+2
        GO TO 2
      ENDIF
 85   IF (X .EQ. INDVAR+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        IC=IC+1
        VQD(QC,1)=INDVAR+128
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=IC
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IC
        PC=PC+2
        GO TO 2
      ENDIF
 90   IF (X .EQ. ADD) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=ADD
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=XC
        XSTACK(XTOS-1)=XC
        XTOS=XTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 100  IF (X .EQ. SUB) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=SUB
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=XC
        XSTACK(XTOS-1)=XC
        XTOS=XTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 110  IF (X .EQ. MULT) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=MULT
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=XC
        XSTACK(XTOS-1)=XC
        XTOS=XTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 120  IF (X .EQ. DIV) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=DIV
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=XC
        XSTACK(XTOS-1)=XC
        XTOS=XTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 130  IF (X .EQ. POWER) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=POWER
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=XC
        XSTACK(XTOS-1)=XC
        XTOS=XTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 135  IF (X .EQ. POWER+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=POWER+128
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=XSTACK(XTOS)
        VQD(QC,4)=0
        VQD(QC,5)=XC
        XSTACK(XTOS)=XC
        PC=PC+2
        GO TO 2
      ENDIF
 140  IF (X .EQ. UMINUS) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=UMINUS
        VQD(QC,2)=0
        VQD(QC,3)=XSTACK(XTOS)
        VQD(QC,4)=0
        VQD(QC,5)=XC
        XSTACK(XTOS)=XC
        PC=PC+1
        GO TO 2
      ENDIF
 150  IF (X .EQ. RNUM) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=RNUM
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XC
        XTOS=XTOS+1
        IF (XTOS .GT. XSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        XSTACK(XTOS)=XC
        PC=PC+2
        GO TO 2
      ENDIF
 160  IF (X .EQ. INUM) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=INUM
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XC
        XTOS=XTOS+1
        IF (XTOS .GT. XSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        XSTACK(XTOS)=XC
        PC=PC+2
        GO TO 2
      ENDIF
 170  IF (X .EQ. INDVAR) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC,1)=INDVAR
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XC
        XTOS=XTOS+1
        IF (XTOS .GT. XSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        XSTACK(XTOS)=XC
        PC=PC+2
        GO TO 2
      ENDIF
 180  IF (X .EQ. REAL) THEN
        DIM=IRCONS(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=REAL
          VQD(QC,2)=IRCONS(VPFX(PC+1),4)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=REAL
          VQD(QC,2)=IRCONS(VPFX(PC+1),4)-1
          VQD(QC,3)=ISTACK(ITOS)
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-1
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 2) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=INUM+128
          VQD(QC,2)=1
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=IC
          ITOS=ITOS+1
          IF (ITOS .GT. ISMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=SUB+128
          VQD(QC,2)=0
          VQD(QC,3)=ISTACK(ITOS-2)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=IC
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=INUM+128
          VQD(QC,2)=IRCONS(VPFX(PC+1),3)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=IC
          ITOS=ITOS+1
          IF (ITOS .GT. ISMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=MULT+128
          VQD(QC,2)=0
          VQD(QC,3)=ISTACK(ITOS-1)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=IC
          ITOS=ITOS-1
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=REAL
          VQD(QC,2)=IRCONS(VPFX(PC+1),4)-1
          VQD(QC,3)=ISTACK(ITOS-1)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ITOS=ITOS-3
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 190  IF (X .EQ. INT) THEN
        DIM=IICONS(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=INT
          VQD(QC,2)=IICONS(VPFX(PC+1),4)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=INT
          VQD(QC,2)=IICONS(VPFX(PC+1),4)-1
          VQD(QC,3)=ISTACK(ITOS)
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-1
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 2) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=INUM+128
          VQD(QC,2)=1
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=IC
          ITOS=ITOS+1
          IF (ITOS .GT. ISMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=SUB+128
          VQD(QC,2)=0
          VQD(QC,3)=ISTACK(ITOS-2)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=IC
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=INUM+128
          VQD(QC,2)=IICONS(VPFX(PC+1),3)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=IC
          ITOS=ITOS+1
          IF (ITOS .GT. ISMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          IC=IC+1
          VQD(QC,1)=MULT+128
          VQD(QC,2)=0
          VQD(QC,3)=ISTACK(ITOS-1)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=IC
          ITOS=ITOS-1
          ISTACK(ITOS)=IC
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=INT
          VQD(QC,2)=IICONS(VPFX(PC+1),4)-1
          VQD(QC,3)=ISTACK(ITOS-1)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          ITOS=ITOS-3
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 200  IF (X .EQ. VAR) THEN
        DIM=IVARI(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=IVARI(VPFX(PC+1),3)
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          IC=IC+1
          VQD(QC,1)=VAR
          VQD(QC,2)=IVARI(VPFX(PC+1),3)-1
          VQD(QC,3)=ISTACK(ITOS)
          VQD(QC,4)=IC
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-1
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 210  IF (X .EQ. FUNC) THEN
        DIM=IFUNC(VPFX(PC+1),1)
        IF (DIM .LE. 0) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          VQD(QC,1)=FUNC
          VQD(QC,2)=IFUNC(VPFX(PC+1),4)
          VQD(QC,3)=IFUNC(VPFX(PC+1),1)
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          QC=QC+1
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          XC=XC+1
          IC=IC+1
          VQD(QC,1)=FUNC
          VQD(QC,2)=IFUNC(VPFX(PC+1),4)-1
          VQD(QC,3)=ISTACK(ITOS)
          VQD(QC,4)=IC
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-1
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 220  IF (X .EQ. STDRD) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        DIM=STDTYP(VPFX(PC+1))
        IF (DIM .EQ. 0) THEN
          VQD(QC,1)=STDRD
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          VQD(QC,1)=STDRD
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=XSTACK(XTOS)
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 2) THEN
          VQD(QC,1)=STDRD
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=XSTACK(XTOS-1)
          VQD(QC,4)=XSTACK(XTOS)
          VQD(QC,5)=XC
          XTOS=XTOS-1
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 230  IF (X .EQ. EXTERN) THEN
        EXCALL=.TRUE.
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        DIM=EXTTYP(VPFX(PC+1))
        IF (DIM .EQ. 0) THEN
          VQD(QC,1)=EXTERN
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 1) THEN
          VQD(QC,1)=EXTERN
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=ISTACK(ITOS)
          VQD(QC,4)=0
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-1
          PC=PC+2
          GO TO 2
        ELSE IF (DIM .EQ. 2) THEN
          VQD(QC,1)=EXTERN
          VQD(QC,2)=VPFX(PC+1)
          VQD(QC,3)=ISTACK(ITOS-1)
          VQD(QC,4)=ISTACK(ITOS)
          VQD(QC,5)=XC
          XTOS=XTOS+1
          IF (XTOS .GT. XSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          XSTACK(XTOS)=XC
          ITOS=ITOS-2
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 240  IF (X .EQ. SUM) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=SUM+128
        VQD(QC-1,2)=0
        VQD(QC-1,3)=0
        VQD(QC-1,4)=0
        VQD(QC-1,5)=XC
        XTOS=XTOS+1
        IF (XTOS .GT. XSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        XSTACK(XTOS)=XC
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IC
        VQD(QC,1)=SUM
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=IINDEX(VPFX(PC+2),2)
        VQD(QC,4)=IINDEX(VPFX(PC+2),5)
        RTOS=RTOS+1
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RSTACK(RTOS)=QC
        PC=PC+3
        GO TO 2
      ENDIF
 250  IF (X .EQ. ENDSUM) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=ADD
        VQD(QC-1,2)=0
        VQD(QC-1,3)=XSTACK(XTOS-1)
        VQD(QC-1,4)=XSTACK(XTOS)
        VQD(QC-1,5)=XC
        VQD(QC,1)=ENDSUM
        VQD(QC,2)=XC-XSTACK(XTOS-1)
        VQD(QC,3)=IC-ISTACK(ITOS)
        VQD(QC,4)=0
        VQD(QC,5)=RSTACK(RTOS)
        VQD(RSTACK(RTOS),5)=QC
        XC=XC+VQD(QC,2)*(VQD(RSTACK(RTOS),3)-1)
        IC=IC+VQD(QC,3)*(VQD(RSTACK(RTOS),3)-1)
        ITOS=ITOS-1
        XTOS=XTOS-1
        XSTACK(XTOS)=XC
        RTOS=RTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 260  IF (X .EQ. PROD) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=PROD+128
        VQD(QC-1,2)=0
        VQD(QC-1,3)=0
        VQD(QC-1,4)=0
        VQD(QC-1,5)=XC
        XTOS=XTOS+1
        IF (XTOS .GT. XSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        XSTACK(XTOS)=XC
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IC
        VQD(QC,1)=PROD
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=IINDEX(VPFX(PC+2),2)
        VQD(QC,4)=IINDEX(VPFX(PC+2),5)
        RTOS=RTOS+1
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RSTACK(RTOS)=QC
        PC=PC+3
        GO TO 2
      ENDIF
 270  IF (X .EQ. ENDPRD) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=MULT
        VQD(QC-1,2)=0
        VQD(QC-1,3)=XSTACK(XTOS-1)
        VQD(QC-1,4)=XSTACK(XTOS)
        VQD(QC-1,5)=XC
        VQD(QC,1)=ENDPRD
        VQD(QC,2)=XC-XSTACK(XTOS-1)
        VQD(QC,3)=IC-ISTACK(ITOS)
        VQD(QC,4)=0
        VQD(QC,5)=RSTACK(RTOS)
        VQD(RSTACK(RTOS),5)=QC
        XC=XC+VQD(QC,2)*(VQD(RSTACK(RTOS),3)-1)
        IC=IC+(VQD(RSTACK(RTOS),3)-1)*VQD(QC,3)
        ITOS=ITOS-1
        XTOS=XTOS-1
        XSTACK(XTOS)=XC
        RTOS=RTOS-1
        PC=PC+1
        GO TO 2
      ENDIF
 280  IF (X .EQ. RELOP) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        LC=LC+1
        VQD(QC,1)=RELOP
        VQD(QC,2)=VPFX(PC+1)
        VQD(QC,3)=XSTACK(XTOS-1)
        VQD(QC,4)=XSTACK(XTOS)
        VQD(QC,5)=LC
        LTOS=LTOS+1
        IF (LTOS .GT. LSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        LSTACK(LTOS)=LC
        XTOS=XTOS-2
        IF (XC .GT. MAXXC) MAXXC=XC
        IF (IC .GT. MAXIC) MAXIC=IC
        XC=PVVA
        PC=PC+2
        GO TO 2
      ENDIF
 290  IF (X .EQ. AND) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        LC=LC+1
        VQD(QC,1)=AND
        VQD(QC,2)=0
        VQD(QC,3)=LSTACK(LTOS-1)
        VQD(QC,4)=LSTACK(LTOS)
        VQD(QC,5)=LC
        LTOS=LTOS-1
        LSTACK(LTOS)=LC
        PC=PC+1
        GO TO 2
      ENDIF
 300  IF (X .EQ. OR) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        LC=LC+1
        VQD(QC,1)=OR   
        VQD(QC,2)=0          
        VQD(QC,3)=LSTACK(LTOS-1)
        VQD(QC,4)=LSTACK(LTOS)
        VQD(QC,5)=LC
        LTOS=LTOS-1
        LSTACK(LTOS)=LC
        PC=PC+1
        GO TO 2
      ENDIF
 310  IF (X .EQ. NOT) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        LC=LC+1
        VQD(QC,1)=NOT
        VQD(QC,2)=0
        VQD(QC,3)=LSTACK(LTOS)
        VQD(QC,4)=0
        VQD(QC,5)=LC
        LSTACK(LTOS)=LC
        PC=PC+1
        GO TO 2
      ENDIF
 320  IF (X .EQ. BEQ) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=BEQ
        VQD(QC,2)=0
        VQD(QC,3)=LSTACK(LTOS)
        VQD(QC,4)=0
        VQD(QC,5)=0
        LTOS=LTOS-1
        IF (LC .GT. MAXLC) MAXLC=LC
        LC=0
        PC=PC+2
        GO TO 2
      ENDIF
 330  IF (X .EQ. BRA) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC-1,1)=BRA
        VQD(QC-1,2)=0
        VQD(QC-1,3)=0
        VQD(QC-1,4)=0
        VQD(QC-1,5)=0
        VQD(QC,1)=LABEL
        VQD(QC,2)=QC
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=0
        PC=PC+2
        GO TO 2
      ENDIF
 340  IF (X .EQ. CONTIN) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=CONTIN
        VQD(QC,2)=0
        VQD(QC,3)=VPFX(PC+1)
        VQD(QC,4)=0
        VQD(QC,5)=0
        PC=PC+2
        GO TO 2
      ENDIF
 350  IF (X .EQ. GOTO) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=GOTO
        VQD(QC,2)=0
        VQD(QC,3)=VPFX(PC+1)
        VQD(QC,4)=0
        VQD(QC,5)=0
        PC=PC+3
        GO TO 2
      ENDIF
 360  IF (X .EQ. ASSIGN) THEN
        IF (IFUNC(VPFX(PC+1),1) .LE. 0) THEN
          QC=QC+2
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          VQD(QC-1,1)=ASSIGN
          VQD(QC-1,2)=IFUNC(VPFX(PC+1),4)
          VQD(QC-1,3)=XSTACK(XTOS)
          VQD(QC-1,4)=0
          VQD(QC-1,5)=0
          IF (IFUNC(VPFX(PC+1),1) .EQ. -2) VQD(QC-1,4)=-2
          XTOS=XTOS-1
          IF (XC .GT. MAXXC) MAXXC=XC
          IF (IC .GT. MAXIC) MAXIC=IC
          XC=PVVA
          IC=0
          VQD(QC,1)=LABEL
          VQD(QC,2)=QC
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=0
          PC=PC+2
          GO TO 2
        ELSE
          QC=QC+2
          IF (QC .GT. MAXVQD) THEN
            IERR=32
            RETURN
          ENDIF
          VQD(QC-1,1)=ASSIGN
          VQD(QC-1,2)=-IFUNC(VPFX(PC+1),2)
          VQD(QC-1,3)=XSTACK(XTOS)
          VQD(QC-1,4)=IFUNC(VPFX(PC+1),4)-1
          VQD(QC-1,5)=0
          XTOS=XTOS-1
          IF (XC .GT. MAXXC) MAXXC=XC
          IF (IC .GT. MAXIC) MAXIC=IC
          XC=PVVA
          IC=0
          VQD(QC,1)=LABEL
          VQD(QC,2)=QC
          VQD(QC,3)=0
          VQD(QC,4)=0
          VQD(QC,5)=0
          PC=PC+2
          GO TO 2
        ENDIF
      ENDIF
 365  IF (X .EQ. -ASSIGN) THEN
        IERR=27
        RETURN
      ENDIF
 370  IF (X .EQ. IF+128) THEN
        RTOS=RTOS+1
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RSTACK(RTOS)=QC+1
        PC=PC+1
        GO TO 2
      ENDIF
 380  IF (X .EQ. ENDIF+128) THEN
        QC=QC+1
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        VQD(QC,1)=LABEL
        VQD(QC,2)=QC
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=0
        QC1=RSTACK(RTOS)
        RTOS=RTOS-1
 381    IF (QC1 .LT. QC) THEN
          IF (VQD(QC1,1) .NE. BEQ) THEN
            QC1=QC1+1
            GO TO 381
          ENDIF
        ENDIF
        QC2=QC1+1
 382    IF (QC2 .LT. QC) THEN
          IF (VQD(QC2,1) .NE. BRA) THEN
            QC2=QC2+1
            GO TO 382
          ENDIF
        ENDIF
        IF (QC2 .LT. QC) THEN
          VQD(QC1,2)=QC2+1
          VQD(QC2,2)=QC
          QC1=QC1+1
          GO TO 381
        ELSE
          IF (VQD(QC1,1) .EQ. BEQ) VQD(QC1,2)=QC
          PC=PC+1
          GO TO 2
        ENDIF
      ENDIF
 390  IF (X .EQ. CONINT) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=CONINT
        VQD(QC-1,2)=IRCONS(VPFX(PC+1),4)
        VQD(QC-1,3)=IRCONS(VPFX(PC+1),2)
        VQD(QC-1,4)=VPFX(PC+2)
        VQD(QC-1,5)=XC
        VQD(QC,1)=CONINT+128
        VQD(QC,2)=0
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XSTACK(XTOS)
        XSTACK(XTOS)=XC
        PIP=PIP+1
        IF (PIP .GT. MAXVIP) THEN
          IERR=64
          RETURN
        ENDIF
        VIP(PIP)=VPFX(PC+2)
        PC=PC+3
        GO TO 2
      ENDIF
 400  IF (X .EQ. LININT) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=LININT
        VQD(QC-1,2)=IRCONS(VPFX(PC+1),4)
        VQD(QC-1,3)=IRCONS(VPFX(PC+1),2)
        VQD(QC-1,4)=VPFX(PC+2)
        VQD(QC-1,5)=XC
        VQD(QC,1)=LININT+128
        VQD(QC,2)=0
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XSTACK(XTOS)
        XSTACK(XTOS)=XC
        PIP=PIP+1
        IF (PIP .GT. MAXVIP) THEN
          IERR=64
          RETURN
        ENDIF
        VIP(PIP)=VPFX(PC+2)
        PC=PC+3
        GO TO 2
      ENDIF
 410  IF (X .EQ. SPLINE) THEN
        QC=QC+2
        IF (QC .GT. MAXVQD) THEN
          IERR=32
          RETURN
        ENDIF
        XC=XC+1
        VQD(QC-1,1)=SPLINE
        VQD(QC-1,2)=IRCONS(VPFX(PC+1),4)
        VQD(QC-1,3)=IRCONS(VPFX(PC+1),2)
        VQD(QC-1,4)=VPFX(PC+2)
        VQD(QC-1,5)=XC
        VQD(QC,1)=SPLINE+128
        VQD(QC,2)=0
        VQD(QC,3)=0
        VQD(QC,4)=0
        VQD(QC,5)=XSTACK(XTOS)
        XSTACK(XTOS)=XC
        PIP=PIP+1
        IF (PIP .GT. MAXVIP) THEN
          IERR=64
          RETURN
        ENDIF
        VIP(PIP)=VPFX(PC+2)
        PC=PC+3
        GO TO 2
      ENDIF
C
      IERR=26
      WRITE(*,*) 'REVCDE (4866) : unknown token ',X
      RETURN 
      END 
C
C
C
      SUBROUTINE FORCDE (XFIL,PVIS,PVIC,PVRC,PVVA,PIFN,PXFN,PVFN,PIV,
     1                   VINDEX,VICONS,VRCONS,MAXVQD,VQD,MAXXC,MAXLC,
     2                   MAXIC,EXCALL,IERR,VIP,MAXVIP,PIP)
      INTEGER XFIL
      INTEGER PVIS,PVIC,PVRC,PVVA,PIFN,PXFN,PVFN,PIV
      INTEGER VINDEX(PVIS),VICONS(PVIC)
      DOUBLE PRECISION VRCONS(PVRC)
      INTEGER MAXVQD
      INTEGER VQD(MAXVQD,5)
      INTEGER MAXXC,MAXLC,MAXIC
      LOGICAL EXCALL
      INTEGER IERR
      INTEGER MAXVIP,PIP
      INTEGER VIP(MAXVIP)
C
      INTEGER ADD,SUB,MULT,DIV,POWER,ASSIGN
      INTEGER RELOP,AND,OR,NOT,INUM,RNUM,SUM,PROD,IF
      INTEGER ENDIF,STDRD,EXTERN,REAL,INT
      INTEGER CONINT,LININT,SPLINE,VAR,FUNC,GOTO,CONTIN
      INTEGER UMINUS,INDVAR,ENDSUM,ENDPRD,BEQ,BRA,LABEL,VECTOR,ACTIVE
      PARAMETER (ADD=43,SUB=45,MULT=42,DIV=47,POWER=94)
      PARAMETER (ASSIGN=61,RELOP=258)
      PARAMETER (AND=259,OR=260,NOT=261,INUM=262,RNUM=263)
      PARAMETER (SUM=265,PROD=266,IF=268)
      PARAMETER (ENDIF=271,STDRD=272,EXTERN=273)
      PARAMETER (REAL=277,INT=278,CONINT=280)
      PARAMETER (LININT=281,SPLINE=282,VAR=283,FUNC=285)
      PARAMETER (GOTO=287,CONTIN=289,UMINUS=290)
      PARAMETER (INDVAR=291,ENDSUM=292,ENDPRD=293,BEQ=294,BRA=295)
      PARAMETER (LABEL=296,VECTOR=297,ACTIVE=298)
C
      INTEGER MAXSTD,MAXEXT
      PARAMETER (MAXSTD=17,MAXEXT=1)
C
      CHARACTER*6 STDNAM(MAXSTD)
      INTEGER STDTYP(MAXSTD),EXTTYP(MAXEXT)
      INTEGER STDLEN(MAXSTD)
      CHARACTER*4 RELNAM(6)
C
      INTEGER FUNMOD,GRAMOD
      PARAMETER (FUNMOD=0,GRAMOD=1)
C
      INTEGER I,J,K,MODE
      INTEGER AQC,FC,FCOFS,QC,X
      INTEGER DIM,EXT
C     INTEGER B
C
C     INTEGER OFS,IOFS
      INTEGER OFS
C
      CHARACTER*30 S1,S2,S3,S4,S5,S6,S7,S8,S9,S10
      INTEGER SLEN1,SLEN2,SLEN3,SLEN4,SLEN5,SLEN6,SLEN7,SLEN8,SLEN9
      INTEGER SLEN10
C
      DATA STDNAM /'DABS','DSQRT','DEXP','DLOG','DLOG10',
     1             'DSIN','DCOS','DTAN','DASIN','DACOS','DATAN',
     2             'DSINH','DCOSH','DTANH','DASINH','DACOSH','DATANH'/
      DATA STDTYP /1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1/
      DATA STDLEN /4,5,4,4,6,4,4,4,5,5,5,5,5,5,6,6,6/
      DATA EXTTYP /0/
      DATA RELNAM /'.EQ.','.NE.','.LT.','.LE.','.GT.','.GE.'/
C
      OFS=0
C     IOFS=0
      MODE=FUNMOD
 2    IF (MODE .EQ. FUNMOD) THEN 
        WRITE(XFIL,'(A)') 'C*********************************'
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(A)') 'C   P C O M P     (Version 5.5)'
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(A)') 'C*********************************'
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(6X,A)') 'SUBROUTINE XFUN (X,N,F,M,ACTIVE,IERR)'
        WRITE(XFIL,'(6X,A)') 'INTEGER N,M'
        WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION X(N),F(M)'
        WRITE(XFIL,'(6X,A)') 'LOGICAL ACTIVE(M)' 
        WRITE(XFIL,'(6X,A)') 'INTEGER IERR'
        WRITE(XFIL,'(A)') 'C'
C
        IF (MAXXC .GT. PVVA) THEN
          CALL ITOA(PVVA+1,S1,SLEN1)
          CALL ITOA(MAXXC,S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION XAUX('//S1(1:SLEN1)//
     1               ':'//S2(1:SLEN2)//')'
        ENDIF
C
        IF (MAXIC .GT. 0) THEN
          CALL ITOA(MAXIC,S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'INTEGER IAUX(1:'//S1(1:SLEN1)//')'
        ENDIF
C
        IF (PXFN .LT. PIFN) THEN
          CALL ITOA(PVFN-(PIFN-PXFN)+1,S1,SLEN1)
          CALL ITOA(PVFN,S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION VFUNC('//S1(1:SLEN1)//
     1           ':'//S2(1:SLEN2)//')'
        ENDIF
      ELSE 
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(A)') 'C'
        WRITE(XFIL,'(6X,A)') 
     1      'SUBROUTINE XGRA (X,N,F,M,DF,MMAX,ACTIVE,IERR)'
        WRITE(XFIL,'(6X,A)') 'INTEGER N,M,MMAX'
        WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION X(N),F(M),DF(MMAX,N)'
        WRITE(XFIL,'(6X,A)') 'LOGICAL ACTIVE(M)' 
        WRITE(XFIL,'(6X,A)') 'INTEGER IERR'
        WRITE(XFIL,'(A)') 'C'
C
        CALL ITOA(PVVA,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION DFHELP('//
     1                        S1(1:SLEN1)//')'
        WRITE(XFIL,'(A)') 'C'
C
        IF (MAXXC .GT. PVVA) THEN
          CALL ITOA(PVVA+1,S1,SLEN1)
          CALL ITOA(MAXXC,S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION XAUX('//S1(1:SLEN1)//
     1               ':'//S2(1:SLEN2)//'),YAUX('//S1(1:SLEN1)//
     2               ':'//S2(1:SLEN2)//')'
        ENDIF
        IF (EXCALL) THEN
          CALL ITOA(PVVA,S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION Z(1:'//S1(1:SLEN1)//')'
        ENDIF
C
        IF (MAXIC .GT. 0) THEN
          CALL ITOA(MAXIC,S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'INTEGER IAUX(1:'//S1(1:SLEN1)//')'
        ENDIF
C
        IF (PXFN .LT. PIFN) THEN
          CALL ITOA(PVFN-(PIFN-PXFN)+1,S1,SLEN1)
          CALL ITOA(PVFN,S2,SLEN2)
          CALL ITOA(PVVA,S3,SLEN3)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION VFUNC('//S1(1:SLEN1)//
     1           ':'//S2(1:SLEN2)//'),VGRAD('//S1(1:SLEN1)//
     2           ':'//S2(1:SLEN2)//','//S3(1:SLEN3)//')'
        ENDIF
      ENDIF
C
      IF (MAXLC .GT. 0) THEN
        CALL ITOA(MAXLC,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'LOGICAL LAUX(1:'//S1(1:SLEN1)//')'
      ENDIF
      IF (EXCALL) WRITE(XFIL,'(6X,A)') 'INTEGER EXTPAR(2)'
C---------------------------------------------------------------
C     DO 10 I=0,PIV-1
      DO 10 I=0,PIV
        CALL ITOA(I,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'INTEGER I'//S1(1:SLEN1)//',IX'//
     1          S1(1:SLEN1)
 10   CONTINUE
      IF (MODE .EQ. GRAMOD) THEN
        WRITE(XFIL,'(6X,A)') 'INTEGER INIT1,INIT2'
C
        IF (PIP .GT. 0) THEN
          DO 15 I=1,PIP
          CALL ITOA(VIP(I),S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION IR'//S1(1:SLEN1)
 15       CONTINUE
        ENDIF
C
      ENDIF
C---------------------------------------------------------------
      WRITE(XFIL,'(6X,A)') 'INTEGER I,OFS,IOFS'
      WRITE(XFIL,'(A)') 'C'
C
      CALL ITOA(PVRC,S3,SLEN3)
      IF (PVIS .GT. 0) THEN
        CALL ITOA(PVIS,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'INTEGER VINDEX('//S1(1:SLEN1)//')'
      ENDIF
      IF (PVIC .GT. 0) THEN
        CALL ITOA(PVIC,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'INTEGER VICONS('//S1(1:SLEN1)//')'
      ENDIF
      IF (PVRC .GT. 0) THEN
        CALL ITOA(PVRC,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'DOUBLE PRECISION VRCONS('//
     1          S1(1:SLEN1)//')'
      ENDIF
      IF (PVIS .GT. 0) CALL IDATA(XFIL,VINDEX,PVIS,'VINDEX')
      IF (PVIC .GT. 0) CALL IDATA(XFIL,VICONS,PVIC,'VICONS')
      IF (PVRC .GT. 0) CALL FDATA(XFIL,VRCONS,PVRC,'VRCONS')
      WRITE(XFIL,'(A)') 'C'
C
C-----------------------------------------------------------------------
C     IF (MODE .EQ. GRAMOD) THEN
C       B=1
C       WRITE(XFIL,'(6X,A)') 'DO 1 INIT1=1,MMAX'
C       WRITE(XFIL,'(6X,A)') 'DO 1 INIT2=1,N'
C       WRITE(XFIL,'(6X,A)') 'DF(INIT1,INIT2)=0.0D0'
C       WRITE(XFIL,'(I5,1X,A)') B,'CONTINUE'
C       IF (PXFN .LT. PIFN) THEN
C         B=2
C         CALL ITOA(PVFN-(PIFN-PXFN)+1,S1,SLEN1)
C         CALL ITOA(PVFN,S2,SLEN2)
C         WRITE(XFIL,'(6X,A)') 'DO 2 INIT1='//S1(1:SLEN1)//','//
C    1                                        S2(1:SLEN2)
C         WRITE(XFIL,'(6X,A)') 'DO 2 INIT2=1,N'
C         WRITE(XFIL,'(6X,A)') 'VGRAD(INIT1,INIT2)=0.0D0'
C         WRITE(XFIL,'(I5,1X,A)') B,'CONTINUE'
C       ENDIF
C     ENDIF
      IF (MODE.EQ.GRAMOD) THEN
        CALL ITOA(PVFN-(PIFN-PXFN),S1,SLEN1)
        CALL ITOA(PVVA,S3,SLEN3)
        WRITE(XFIL,'(6X,A)') 'CALL XINI(DF,1,MMAX,'//
     &    S3(1:SLEN3)//')'
        IF (PXFN.LT.PIFN) THEN
          CALL ITOA(PVFN-(PIFN-PXFN)+1,S1,SLEN1)
          CALL ITOA(PVFN,S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'CALL XINI(VGRAD,'//S1(1:SLEN1)//','//
     &      S2(1:SLEN2)//','//S3(1:SLEN3)//')'
        ENDIF
      ENDIF
C-----------------------------------------------------------------------
C    
C     DO 20 I=0,PIV-1
      DO 20 I=0,PIV
        CALL ITOA(I,S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'IX'//S1(1:SLEN1)//'=0'
 20   CONTINUE
      CALL ITOA(PVVA,S1,SLEN1)
      CALL ITOA(PVFN-(PIFN-PXFN),S2,SLEN2)
      WRITE(XFIL,'(6X,A)') 'IF (N .NE. '//S1(1:SLEN1)//') THEN'
      WRITE(XFIL,'(6X,A)') 'IERR=43'
      WRITE(XFIL,'(6X,A)') 'RETURN'
      WRITE(XFIL,'(6X,A)') 'ENDIF'
      WRITE(XFIL,'(6X,A)') 'IF (M .NE. '//S2(1:SLEN2)//') THEN'
      WRITE(XFIL,'(6X,A)') 'IERR=44'
      WRITE(XFIL,'(6X,A)') 'RETURN'
      WRITE(XFIL,'(6X,A)') 'ENDIF'
      WRITE(XFIL,'(6X,A)') 'OFS=0'
C
      WRITE(XFIL,'(6X,A)') 'IOFS=0'
C----------------------------------------------------------------
      K=1
      QC=3
C----------------------------------------------------------------
 100  X=VQD(QC,1)
C
      IF (X .EQ. ACTIVE) THEN
        IF (VQD(QC,2) .GE. 0) THEN
          CALL ITOA(VQD(QC,2),S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'IF (ACTIVE('//S1(1:SLEN1)//')) THEN'
        ELSE
          CALL ITOA(VQD(QC,3),S1,SLEN1)
          CALL ITOA(-VQD(QC,2)-1,S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'IF (ACTIVE('//S1(1:SLEN1)//'+IX'//
     1                         S2(1:SLEN2)//')) THEN'
        ENDIF
        QC=QC+1
        GO TO 100
C
      ELSE IF (X .EQ. -1) THEN
        WRITE(XFIL,'(6X,A)') 'ENDIF'
C----------------------------------------------------------------
        IF (VQD(QC,2) .GT. 0) THEN
          WRITE(XFIL,'(I5,1X,A)') VQD(QC,2),'CONTINUE'
        ENDIF
C----------------------------------------------------------------
        K=K+1
        IF (K .LE. PXFN) THEN 
          QC=QC+1
          GO TO 100
        ELSE
          WRITE(XFIL,'(6X,A)') 'RETURN'
          WRITE(XFIL,'(6X,A)') 'END'
          IF (MODE .EQ. FUNMOD) THEN
            MODE=GRAMOD
            GO TO 2
          ELSE
C-----------------------------------------------------------------------
            WRITE(XFIL,'(A)') 'C'
            WRITE(XFIL,'(A)') 'C'
            WRITE(XFIL,'(A)') 'C'
            WRITE(XFIL,'(A)') '      SUBROUTINE XINI (G,ML,MU,N)'
            WRITE(XFIL,'(A)') '      INTEGER ML,MU,N'
            WRITE(XFIL,'(A)') '      DOUBLE PRECISION G(ML:MU,N)'
            WRITE(XFIL,'(A)') 'C'
            WRITE(XFIL,'(A)') '      INTEGER I,J'
            WRITE(XFIL,'(A)') 'C'
            WRITE(XFIL,'(A)') '      DO 20 I=ML,MU'
            WRITE(XFIL,'(A)') '      DO 10 J=1,N'
            WRITE(XFIL,'(A)') '      G(I,J)=0.0D0'
            WRITE(XFIL,'(A)') '   10 CONTINUE'
            WRITE(XFIL,'(A)') '   20 CONTINUE'
            WRITE(XFIL,'(A)') '      RETURN'
            WRITE(XFIL,'(A)') '      END'
C-----------------------------------------------------------------------
            RETURN
          ENDIF
        ENDIF
C
      ELSE IF (X .EQ. ADD+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEI(OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEI(OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//'+'//
     1        S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. SUB+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEI(OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEI(OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//'-'//
     1        S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. MULT+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEI(OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEI(OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//'*'//
     1        S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. DIV+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEI(OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEI(OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//' .EQ. 0.0D0) THEN'
        WRITE(XFIL,'(6X,A)') 'IERR=9'
        WRITE(XFIL,'(6X,A)') 'RETURN'
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//'/'//
     1        S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. UMINUS+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEI(OFS,VQD(QC,3),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=-'//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. INUM+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL ITOA(VQD(QC,2),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. FUNC+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL ITOA(VQD(QC,2),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=IDNINT(VFUNC('//
     1        S2(1:SLEN2)//'))'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. INDVAR+128) THEN
        CALL MAKEI(OFS,VQD(QC,5),S1,SLEN1)
        CALL ITOA(VQD(QC,2)-1,S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=IX'//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. VAR) THEN
        CALL MAKEI(OFS,VQD(QC,4),S1,SLEN1)
        CALL ITOA(VQD(QC,2),S2,SLEN2)
        CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
        IF (VQD(QC,2) .NE. 0) THEN
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//
     1          '+'//S3(1:SLEN3)
        ELSE
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S3(1:SLEN3)
        ENDIF
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S4,SLEN4)
        CALL ITOA(PVVA,S5,SLEN5)
        WRITE(XFIL,'(6X,A)') 'IF (('//S1(1:SLEN1)//' .GT. '
     1        //S5(1:SLEN5)//') .OR. ('//S3(1:SLEN3)//' .LE. 0)) THEN'
        WRITE(XFIL,'(6X,A)') 'IERR=33'
        WRITE(XFIL,'(6X,A)') 'RETURN'
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(6X,A)') S4(1:SLEN4)//'=X('//S1(1:SLEN1)//')'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. ADD) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'+'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. SUB) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'-'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. MULT) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'*'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. DIV) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//' .EQ. 0.0D0) THEN'
        WRITE(XFIL,'(6X,A)') 'IERR=9'
        WRITE(XFIL,'(6X,A)') 'RETURN'
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'/'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. POWER) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') 'IF ('//S2(1:SLEN2)//' .LE. 0.0D0) THEN'
        WRITE(XFIL,'(6X,A)') 'IERR=9'
        WRITE(XFIL,'(6X,A)') 'RETURN'
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'**'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. POWER+128) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL ITOA(VQD(QC,2),S3,SLEN3)
        IF (VQD(QC,2) .LT. 0) THEN
          WRITE(XFIL,'(6X,A)') 'IF ('//S2(1:SLEN2)
     1                         //' .EQ. 0.0D0) THEN'
          WRITE(XFIL,'(6X,A)') 'IERR=9'
          WRITE(XFIL,'(6X,A)') 'RETURN'
          WRITE(XFIL,'(6X,A)') 'ENDIF'
        ENDIF
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'**'//'('//S3(1:SLEN3)//')'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. UMINUS) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            '-'//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. RNUM) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL FTOA(VRCONS(VQD(QC,2)),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. REAL) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        IF (VQD(QC,3) .EQ. 0) THEN
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//
     1            S2(1:SLEN2)//')'
        ELSE IF (VQD(QC,4) .EQ. 0) THEN
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//
     1            S2(1:SLEN2)//'+'//S3(1:SLEN3)//')'
        ELSE
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
          CALL MAKEI(OFS,VQD(QC,4),S4,SLEN4)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//
     1            S2(1:SLEN2)//'+'//S3(1:SLEN3)//'+'//S4(1:SLEN4)//')'
        ENDIF
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. INUM) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL ITOA(VICONS(VQD(QC,2)),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=DBLE('//
     1            S2(1:SLEN2)//')'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. INT) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        IF (VQD(QC,3) .EQ. 0) THEN
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=DBLE(VICONS('//
     1            S2(1:SLEN2)//'))'
        ELSE IF (VQD(QC,4) .EQ. 0) THEN
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=DBLE(VICONS('//
     1            S2(1:SLEN2)//'+'//S3(1:SLEN3)//'))'
        ELSE
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
          CALL MAKEI(OFS,VQD(QC,4),S4,SLEN4)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=DBLE(VICONS('//
     1            S2(1:SLEN2)//'+'//S3(1:SLEN3)//'+'//S4(1:SLEN4)//'))'
        ENDIF
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. INDVAR) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL ITOA(VQD(QC,2)-1,S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=DBLE(IX'//
     1            S2(1:SLEN2)//')'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. FUNC) THEN
        IF (VQD(QC,4) .EQ. 0) THEN
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEX(PVVA,OFS,VQD(QC,5),S4,SLEN4)
          IF (VQD(QC,3) .EQ. 0) THEN
            WRITE(XFIL,'(6X,A)') S4(1:SLEN4)//'=F('//S2(1:SLEN2)//')'
          ELSE
            WRITE(XFIL,'(6X,A)') S4(1:SLEN4)//'=VFUNC('//
     1                           S2(1:SLEN2)//')'
          ENDIF
        ELSE
          CALL MAKEI(OFS,VQD(QC,4),S1,SLEN1)
          CALL ITOA(VQD(QC,2),S2,SLEN2)
          CALL MAKEI(OFS,VQD(QC,3),S3,SLEN3)
          IF (VQD(QC,2) .NE. 0) THEN
            WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)//
     1            '+'//S3(1:SLEN3)
          ELSE
            WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S3(1:SLEN3)
          ENDIF
          CALL MAKEX(PVVA,OFS,VQD(QC,5),S4,SLEN4)
          CALL ITOA(PVFN-(PIFN-PXFN),S5,SLEN5)
          WRITE(XFIL,'(6X,A)') 'IF (('//S1(1:SLEN1)//' .GT. '//
     1          S5(1:SLEN5)//') .OR. ('//S3(1:SLEN3)//' .LE. 0)) THEN'
          WRITE(XFIL,'(6X,A)') 'IERR=33'
          WRITE(XFIL,'(6X,A)') 'RETURN'
          WRITE(XFIL,'(6X,A)') 'ENDIF'
          WRITE(XFIL,'(6X,A)') S4(1:SLEN4)//'=F('//S1(1:SLEN1)//')'
        ENDIF
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. STDRD) THEN
        DIM=STDTYP(VQD(QC,2))
C
        IF (DIM .EQ. 0) THEN 
          CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
          S2=STDNAM(VQD(QC,2))
          SLEN2=STDLEN(VQD(QC,2))
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)
C
        ELSE IF (DIM .EQ. 1) THEN
          CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
          S2=STDNAM(VQD(QC,2))
          SLEN2=STDLEN(VQD(QC,2))
          CALL MAKEX(PVVA,OFS,VQD(QC,3),S3,SLEN3)
C----------------------------------------------------------------------
          IF (VQD(QC,2) .EQ. 2) THEN
            WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)
     1                         //' .LT. 0.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR=53'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
C
          ELSE IF ((VQD(QC,2) .EQ. 4) .OR. (VQD(QC,2) .EQ. 5)) THEN
            WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)
     1                           //' .LE. 0.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR=52'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
C
          ELSE IF (VQD(QC,2) .EQ. 9) THEN
            WRITE(XFIL,'(6X,A)') 'IF (DABS('//S3(1:SLEN3)//
     1                            ') .GT. 1.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR = 54'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
C 
          ELSE IF(VQD(QC,2) .EQ. 10) THEN
            WRITE(XFIL,'(6X,A)') 'IF (DABS('//S3(1:SLEN3)//
     1                            ') .GT. 1.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR = 55'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
C
          ELSE IF(VQD(QC,2) .EQ. 16) THEN
            WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//
     1                            ' .LT. 1.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR = 56'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
C
          ELSE IF(VQD(QC,2) .EQ. 17) THEN
            WRITE(XFIL,'(6X,A)') 'IF (DABS('//S3(1:SLEN3)//
     1                            ') .GE. 1.0D0) THEN'
            WRITE(XFIL,'(6X,A)') 'IERR = 51'
            WRITE(XFIL,'(6X,A)') 'RETURN'
            WRITE(XFIL,'(6X,A)') 'ENDIF'
          ENDIF
C----------------------------------------------------------------------
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'('//S3(1:SLEN3)//')'
C
        ELSE IF (DIM .EQ. 2) THEN
          CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
          S2=STDNAM(VQD(QC,2))
          SLEN2=STDLEN(VQD(QC,2))
          CALL MAKEX(PVVA,OFS,VQD(QC,3),S3,SLEN3)
          CALL MAKEX(PVVA,OFS,VQD(QC,4),S4,SLEN4)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'('//S3(1:SLEN3)//
     2            ','//S4(1:SLEN4)//')'
C
        ELSE
          IERR=26
          WRITE(*,*) ' FORCDE (5149) : illegal dimension ',DIM
          RETURN
        ENDIF
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. EXTERN) THEN
        EXT=VQD(QC,2)
        IF (EXTTYP(EXT) .EQ. 1) THEN
          CALL MAKEI(OFS,VQD(QC,3),S1,SLEN1)
          WRITE(XFIL,'(6X,A)') 'EXTPAR(1)='//S1(1:SLEN1)
        ELSE IF (EXTTYP(EXT) .EQ. 2) THEN
          CALL MAKEI(OFS,VQD(QC,3),S1,SLEN1)
          CALL MAKEI(OFS,VQD(QC,4),S2,SLEN2)
          WRITE(XFIL,'(6X,A)') 'EXTPAR(1)='//S1(1:SLEN1)
          WRITE(XFIL,'(6X,A)') 'EXTPAR(2)='//S2(1:SLEN2)
        ENDIF
        CALL ITOA(EXT,S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') 'CALL EXTFUN('//S1(1:SLEN1)//',X,N,'
     1            //S2(1:SLEN2)//',EXTPAR)'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. SUM+128) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=0.0D0'
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. PROD+128) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=1.0D0'
        QC=QC+1 
        GO TO 100
C
      ELSE IF ((X .EQ. SUM) .OR. (X.EQ. PROD) .OR. (X .EQ. VECTOR)) THEN
        CALL ITOA(VQD(QC,2)-1,S2,SLEN2)
        CALL ITOA(VQD(QC,3)-1,S3,SLEN3)
        CALL ITOA(VQD(QC,4),S4,SLEN4)
        CALL ITOA(VQD(QC,5),S5,SLEN5)
C-----------------------------------------------------
        IF (X .NE. VECTOR) OFS=OFS+1
C-----------------------------------------------------
        WRITE(XFIL,'(6X,A)') 'DO '//S5(1:SLEN5)//' I'//S2(1:SLEN2)//
     1                     '=0,'//S3(1:SLEN3)
        WRITE(XFIL,'(6X,A)') 'IX'//S2(1:SLEN2)//'=VINDEX('//
     1                     S4(1:SLEN4)//'+I'//S2(1:SLEN2)//')'
        QC=QC+1 
        GO TO 100
C
      ELSE IF ((X .EQ. ENDSUM) .OR. (X .EQ. ENDPRD)) THEN
        CALL ITOA(VQD(QC,2),S1,SLEN1)
        CALL ITOA(VQD(QC,2)*VQD(VQD(QC,5),3),S2,SLEN2)
C-----------------------------------------------------
        OFS=OFS-1
C-----------------------------------------------------
        WRITE(XFIL,'(6X,A)') 'OFS=OFS+'//S1(1:SLEN1)
C
        CALL ITOA(VQD(QC,3),S3,SLEN3)
        CALL ITOA(VQD(QC,3)*VQD(VQD(QC,5),3),S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'IOFS=IOFS+'//S3(1:SLEN3)
C
        WRITE(XFIL,'(I5,1X,A)') QC,'CONTINUE' 
        WRITE(XFIL,'(6X,A)') 'OFS=OFS-'//S2(1:SLEN2)
C
        WRITE(XFIL,'(6X,A)') 'IOFS=IOFS-'//S4(1:SLEN4)
C
        QC=QC+1 
        GO TO 100
C----------------------------------------------------------------------
      ELSE IF (X .EQ. RELOP) THEN
        CALL MAKEL(VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        CALL MAKEX(PVVA,OFS,VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//RELNAM(VQD(QC,2))//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. AND) THEN
        CALL MAKEL(VQD(QC,5),S1,SLEN1)
        CALL MAKEL(VQD(QC,3),S2,SLEN2)
        CALL MAKEL(VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'.AND.'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. OR) THEN
        CALL MAKEL(VQD(QC,5),S1,SLEN1)
        CALL MAKEL(VQD(QC,3),S2,SLEN2)
        CALL MAKEL(VQD(QC,4),S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            S2(1:SLEN2)//'.OR.'//S3(1:SLEN3)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. NOT) THEN
        CALL MAKEL(VQD(QC,5),S1,SLEN1)
        CALL MAKEL(VQD(QC,3),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//
     1            '.NOT.'//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. BEQ) THEN
        CALL MAKEL(VQD(QC,3),S1,SLEN1)
        CALL ITOA(VQD(QC,2),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') 'IF (.NOT.'//S1(1:SLEN1)//')'//
     1            ' GO TO '//S2(1:SLEN2)
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. BRA) THEN
        CALL ITOA(VQD(QC,2),S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'GO TO '//S1(1:SLEN1) 
        QC=QC+1 
        GO TO 100
C
      ELSE IF ((X .EQ. IF+128) .OR. (X .EQ. ENDIF+128)) THEN
        QC=QC+1 
        GO TO 100
C
      ELSE IF (X .EQ. CONTIN) THEN
        WRITE(XFIL,'(1X,I4,1X,A)') VQD(QC,3),'CONTINUE'
        QC=QC+1
        GO TO 100
C
      ELSE IF (X .EQ. GOTO) THEN
        CALL ITOA(VQD(QC,3),S1,SLEN1)
        WRITE(XFIL,'(6X,A)') 'GO TO '//S1(1:SLEN1) 
        QC=QC+1
        GO TO 100
C
      ELSE IF (X .EQ. CONINT) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC+1,5),S2,SLEN2)
        CALL ITOA(VQD(QC,3),S3,SLEN3)
        CALL ITOA(VQD(QC,2),S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//'.EQ.0) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=0.0D0'
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.LT.VRCONS('//S4(1:SLEN4)//')) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=0.0D0'
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-2,S3,SLEN3)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-1,S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.GE.VRCONS('//S3(1:SLEN3)//')) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S4(1:SLEN4)//')'
        WRITE(XFIL,'(6X,A)') 'ELSE'
        CALL ITOA(QC,S5,SLEN5)
        CALL ITOA(VQD(QC,4),S6,SLEN6)
        CALL ITOA(VQD(QC,2),S3,SLEN3)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-4,S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'DO '//S5(1:SLEN5)//' I'//S6(1:SLEN6)//
     1                     '='//S3(1:SLEN3)//','//S4(1:SLEN4)//',2'
        WRITE(XFIL,'(6X,A)') 'IF (('//S2(1:SLEN2)//'.GE.VRCONS(I'//
     1              S6(1:SLEN6)//')) .AND.'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'    ('//S2(1:SLEN2)//'.LT.VRCONS(I'//
     1              S6(1:SLEN6)//'+2))) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS(I'//
     1              S6(1:SLEN6)//'+1)'
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(I5,1X,A)') QC,'CONTINUE' 
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        QC=QC+2
        GO TO 100
C
      ELSE IF (X .EQ. LININT) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC+1,5),S2,SLEN2)
        CALL ITOA(VQD(QC,3),S3,SLEN3)
        CALL ITOA(VQD(QC,2),S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//'.EQ.0) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=0.0D0'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S5,SLEN5)
        WRITE(XFIL,'(6X,A)') 'IR'//S5(1:SLEN5)//'=0.0D0'
        ENDIF
C
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.LT.VRCONS('//S4(1:SLEN4)//')) THEN'
        CALL ITOA(VQD(QC,2)+1,S3,SLEN3)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S3(1:SLEN3)//')'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S5,SLEN5)
        WRITE(XFIL,'(6X,A)') 'IR'//S5(1:SLEN5)//'=0.0D0'
        ENDIF
C
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-2,S3,SLEN3)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-1,S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.GE.VRCONS('//S3(1:SLEN3)//')) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S4(1:SLEN4)//')'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S5,SLEN5)
        WRITE(XFIL,'(6X,A)') 'IR'//S5(1:SLEN5)//'=0.0D0'
        ENDIF
C
        WRITE(XFIL,'(6X,A)') 'ELSE'
        CALL ITOA(QC,S5,SLEN5)
        CALL ITOA(VQD(QC,4),S6,SLEN6)
        CALL ITOA(VQD(QC,2),S3,SLEN3)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-4,S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'DO '//S5(1:SLEN5)//' I'//S6(1:SLEN6)//
     1                     '='//S3(1:SLEN3)//','//S4(1:SLEN4)//',2'
        WRITE(XFIL,'(6X,A)') 'IF (('//S2(1:SLEN2)//'.GE.VRCONS(I'//
     1              S6(1:SLEN6)//')) .AND.'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'    ('//S2(1:SLEN2)//'.LT.VRCONS(I'//
     1              S6(1:SLEN6)//'+2))) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=((VRCONS(I'//S6(1:SLEN6)//
     1    '+3)-VRCONS(I'//S6(1:SLEN6)//'+1))/'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'      (VRCONS(I'//S6(1:SLEN6)//
     1                          '+2)-VRCONS(I'//S6(1:SLEN6)//')))*'
        J=2
        WRITE(XFIL,'(5X,I1,A)') J,'      ('//S2(1:SLEN2)//'-VRCONS(I'//
     1              S6(1:SLEN6)//'))+VRCONS(I'//S6(1:SLEN6)//'+1)'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S7,SLEN7)
        WRITE(XFIL,'(6X,A)') 'IR'//S7(1:SLEN7)//'=(VRCONS(I'//
     1         S6(1:SLEN6)//'+3)-VRCONS(I'//S6(1:SLEN6)//'+1))/'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'      (VRCONS(I'//S6(1:SLEN6)//
     1                          '+2)-VRCONS(I'//S6(1:SLEN6)//'))'
        ENDIF
C
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(I5,1X,A)') QC,'CONTINUE' 
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        QC=QC+2
        GO TO 100
C
      ELSE IF (X .EQ. SPLINE) THEN
        CALL MAKEX(PVVA,OFS,VQD(QC,5),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC+1,5),S2,SLEN2)
        CALL ITOA(VQD(QC,3),S3,SLEN3)
        CALL ITOA(VQD(QC,2),S4,SLEN4)
C
        CALL ITOA(VQD(QC,2)+1,S5,SLEN5)
        CALL ITOA(VQD(QC,2)+2,S6,SLEN6)
        CALL ITOA(VQD(QC,2)+3,S7,SLEN7)
        CALL ITOA(VQD(QC,2)+4,S8,SLEN8)
C
        WRITE(XFIL,'(6X,A)') 'IF ('//S3(1:SLEN3)//'.EQ.20) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S5(1:SLEN5)//')'//
     1  '+VRCONS('//S6(1:SLEN6)//')*'//S2(1:SLEN2)//'+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS('//S7(1:SLEN7)//')*'//
     1    S2(1:SLEN2)//'**2+VRCONS('//S8(1:SLEN8)//')*'//
     2    S2(1:SLEN2)//'**3'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S10,SLEN10)
        WRITE(XFIL,'(6X,A)') 'IR'//S10(1:SLEN10)//'=VRCONS('//
     1   S6(1:SLEN6)//')+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  2*VRCONS('//S7(1:SLEN7)//')*'//
     1    S2(1:SLEN2)//'+3*VRCONS('//S8(1:SLEN8)//')*'//
     2    S2(1:SLEN2)//'**2'
        ENDIF
C
        CALL ITOA(VQD(QC,2)+15,S9,SLEN9)
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.LT.VRCONS('//S9(1:SLEN9)//')) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S5(1:SLEN5)//')'//
     1  '+VRCONS('//S6(1:SLEN6)//')*'//S2(1:SLEN2)//'+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS('//S7(1:SLEN7)//')*'//
     1    S2(1:SLEN2)//'**2+VRCONS('//S8(1:SLEN8)//')*'//
     2    S2(1:SLEN2)//'**3'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S10,SLEN10)
        WRITE(XFIL,'(6X,A)') 'IR'//S10(1:SLEN10)//'=VRCONS('//
     1   S6(1:SLEN6)//')+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  2*VRCONS('//S7(1:SLEN7)//')*'//
     1    S2(1:SLEN2)//'+3*VRCONS('//S8(1:SLEN8)//')*'//
     2    S2(1:SLEN2)//'**2'
        ENDIF
C
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-5,S9,SLEN9)
        WRITE(XFIL,'(6X,A)') 'ELSE IF ('//S2(1:SLEN2)//
     1            '.GE.VRCONS('//S9(1:SLEN9)//')) THEN'
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-9,S5,SLEN5)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-8,S6,SLEN6)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-7,S7,SLEN7)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-6,S8,SLEN8)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-10,S9,SLEN9)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS('//S5(1:SLEN5)//')+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS('//S6(1:SLEN6)//')*('//
     1    S2(1:SLEN2)//'-VRCONS('//S9(1:SLEN9)//'))+'
        J=2
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS('//S7(1:SLEN7)//')*('//
     1    S2(1:SLEN2)//'-VRCONS('//S9(1:SLEN9)//'))**2+'
        J=3
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS('//S8(1:SLEN8)//')*('//
     1    S2(1:SLEN2)//'-VRCONS('//S9(1:SLEN9)//'))**3'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S10,SLEN10)
        WRITE(XFIL,'(6X,A)') 'IR'//S10(1:SLEN10)//'=VRCONS('//
     1    S6(1:SLEN6)//')+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  2*VRCONS('//S7(1:SLEN7)//')*('//
     1    S2(1:SLEN2)//'-VRCONS('//S9(1:SLEN9)//'))+'
        WRITE(XFIL,'(5X,I1,A)') J,'  3*VRCONS('//S8(1:SLEN8)//')*('//
     1    S2(1:SLEN2)//'-VRCONS('//S9(1:SLEN9)//'))**2'
        ENDIF
C
        WRITE(XFIL,'(6X,A)') 'ELSE'
        CALL ITOA(QC,S5,SLEN5)
        CALL ITOA(VQD(QC,4),S6,SLEN6)
        CALL ITOA(VQD(QC,2)+15,S3,SLEN3)
        CALL ITOA(VQD(QC,2)+VQD(QC,3)-10,S4,SLEN4)
        WRITE(XFIL,'(6X,A)') 'DO '//S5(1:SLEN5)//' I'//S6(1:SLEN6)//
     1                     '='//S3(1:SLEN3)//','//S4(1:SLEN4)//',5'
        WRITE(XFIL,'(6X,A)') 'IF (('//S2(1:SLEN2)//'.GE.VRCONS(I'//
     1              S6(1:SLEN6)//')) .AND.'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'    ('//S2(1:SLEN2)//'.LT.VRCONS(I'//
     1              S6(1:SLEN6)//'+5))) THEN'
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=VRCONS(I'//S6(1:SLEN6)//
     1    '+1)+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS(I'//S6(1:SLEN6)//'+2)*'//
     1     '('//S2(1:SLEN2)//'-VRCONS(I'//S6(1:SLEN6)//'))+'
        J=2
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS(I'//S6(1:SLEN6)//'+3)*'//
     1     '('//S2(1:SLEN2)//'-VRCONS(I'//S6(1:SLEN6)//'))**2+'
        J=3
        WRITE(XFIL,'(5X,I1,A)') J,'  VRCONS(I'//S6(1:SLEN6)//'+4)*'//
     1     '('//S2(1:SLEN2)//'-VRCONS(I'//S6(1:SLEN6)//'))**3'
C
        IF (MODE .EQ. GRAMOD) THEN
        CALL ITOA(VQD(QC,4),S10,SLEN10)
        WRITE(XFIL,'(6X,A)') 'IR'//S10(1:SLEN10)//'=VRCONS(I'//
     1     S6(1:SLEN6)//'+2)+'
        J=1
        WRITE(XFIL,'(5X,I1,A)') J,'  2*VRCONS(I'//S6(1:SLEN6)//'+3)*'//
     1     '('//S2(1:SLEN2)//'-VRCONS(I'//S6(1:SLEN6)//'))+'
        J=2
        WRITE(XFIL,'(5X,I1,A)') J,'  3*VRCONS(I'//S6(1:SLEN6)//'+4)*'//
     1     '('//S2(1:SLEN2)//'-VRCONS(I'//S6(1:SLEN6)//'))**2'
        ENDIF
C
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        WRITE(XFIL,'(I5,1X,A)') QC,'CONTINUE' 
        WRITE(XFIL,'(6X,A)') 'ENDIF'
        QC=QC+2
        GO TO 100
C
      ELSE IF (X .EQ. ASSIGN) THEN
        CALL MAKEF(PIFN,PXFN,PVFN,VQD(QC,2),VQD(QC,4),S1,SLEN1)
        CALL MAKEX(PVVA,OFS,VQD(QC,3),S2,SLEN2)
        WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'='//S2(1:SLEN2)
        IF (MODE .EQ. GRAMOD) THEN
C
          CALL ITOA(QC,S1,SLEN1)
          CALL ITOA(PVVA,S2,SLEN2)
          CALL MAKEY(PIFN,PXFN,PVFN,PVVA,OFS,VQD(QC,2),1,VQD(QC,4),
     1               S3,SLEN3)
          S3=S3(1:SLEN3-3)//',I)'
          CALL ITOA(PVVA+1,S4,SLEN4)
          CALL ITOA(VQD(QC,3)-1,S5,SLEN5)
          WRITE(XFIL,'(6X,A)') 'DO '//S1(1:SLEN1)//' I=1,'//S2(1:SLEN2)
          WRITE(XFIL,'(6X,A)') 'DFHELP(I)='//S3(1:SLEN3) 
          WRITE(XFIL,'(6X,A)') S3(1:SLEN3)//'=0.0D0' 
          WRITE(XFIL,'(I5,1X,A)') QC,'CONTINUE'
C
          IF (PVVA+1 .LT. VQD(QC,3)) THEN
            CALL ITOA(VQD(QC+1,2),S1,SLEN1)
            WRITE(XFIL,'(6X,A)') 'DO '//S1(1:SLEN1)//' I='
     1            //S4(1:SLEN4)//','//S5(1:SLEN5)
            WRITE(XFIL,'(6X,A)') 'YAUX(I)=0.0D0' 
            WRITE(XFIL,'(I5,1X,A)') VQD(QC+1,2),'CONTINUE'
          ENDIF
C
          CALL MAKEY(PIFN,PXFN,PVFN,PVVA,OFS,VQD(QC,2),VQD(QC,3),
     1              VQD(QC,4),S1,SLEN1)
          WRITE(XFIL,'(6X,A)') S1(1:SLEN1)//'=1.0D0'
C
          AQC=QC
C-----------------------------------------------------------------
          FC=VQD(QC,2)
          FCOFS=VQD(QC,4)
C-----------------------------------------------------------------
          QC=QC-1
 200      IF (QC .GT. 2) THEN 
            IF (VQD(QC,5) .GT. 0) THEN
              CALL FORDF (XFIL,PVVA,PIFN,PXFN,PVFN,MAXVQD,VQD,
     1                    QC,FC,FCOFS,OFS,IERR)
              IF (IERR .NE. 0) RETURN
              QC=QC-1
              GO TO 200
            ENDIF  
          ENDIF  
          QC=AQC+1
C -------------------------
        ELSE
C -------------------------
C   no CONTINUE in XFUN 
C -------------------------
          QC=QC+1
C -------------------------
        ENDIF
        QC=QC+1
        GO TO 100
C
      ELSE IF (X .EQ. LABEL) THEN
        WRITE(XFIL,'(I5,1X,A)') VQD(QC,2),'CONTINUE'
        QC=QC+1
        GO TO 100
C
      ELSE
        IERR=26
        WRITE(*,*) ' FORCDE (5296) : unknown opcode ',X
      ENDIF
      END

