C*********************************************
C                                            *
C   PROGRAM   : PCOMP                        *
C   MODULE    : EV (EVALUATION)              *
C   ABSTRACT  : FORTRAN PRECOMPILER          *
C   KEY WORD  : AUTOMATIC DIFFERENTIATION    *
C   SOURCE    : PCOMP 2.3 by M.LIEPELT       *
C               PCOMP 3.0 by M.DOBMANN       *
C   COPYRIGHT : C.TRASSL, K.SCHITTKOWSKI     *
C               MATHEMATISCHES INSTITUT,     *
C               UNIVERSITAET BAYREUTH,       *
C               D-95440 BAYREUTH, GERMANY    *
C   DATE      : JUNE 8, 1999                 *
C   VERSION   : 5.5                          *
C                                            *
C*********************************************
C
C
C
      SUBROUTINE EVAL (START,IVAL,FVAL,MODE,PVVA,PVVAHE,MPIIS,MPVIS,
     1                 MPIIC,MPVIC,MPIRC,MPVRC,MPIVA,MPVVA,MPIFN,MPVFN,
     1                 MPVHE,MPVPF,MPIV,IINDEX,VINDEX,IICONS,VICONS,
     2                 IRCONS,VRCONS,IVARI,VVARI,IFUNC,VFUNC,VGRAD,
     3                 VHESS,VPFX,VINDVA,GSTACK,HSTACK,DFVAR,MVAR,IERR)
      INTEGER START,IVAL
      DOUBLE PRECISION FVAL
      INTEGER MODE
      INTEGER PVVA,PVVAHE
      INTEGER MPIIS,MPVIS,MPIIC,MPVIC,MPIRC,MPVRC,MPIVA,MPVVA,MPIFN
      INTEGER MPVFN,MPVHE,MPVPF,MPIV
      INTEGER IINDEX(MPIIS,5),VINDEX(MPVIS),IICONS(MPIIC,4)
      INTEGER VICONS(MPVIC),IRCONS(MPIRC,4),IVARI(MPIVA,3)
      INTEGER IFUNC(MPIFN,7),VPFX(MPVPF),VINDVA(MPIV)
      DOUBLE PRECISION VRCONS(MPVRC),VVARI(MPVVA),VFUNC(MPVFN)
      DOUBLE PRECISION VGRAD(MPVFN,MPVVA),VHESS(MPVHE,PVVAHE*PVVAHE)
      DOUBLE PRECISION GSTACK(MPVVA,10),HSTACK(PVVAHE*PVVAHE,10)
      INTEGER MVAR
      INTEGER DFVAR(*) 
      INTEGER IERR
C
      INTEGER ADD,SUB,MULT,DIV,POWER,ASSIGN
      INTEGER RELOP,AND,OR,NOT,INUM,RNUM,SUM,PROD,IF
      INTEGER ENDIF,STDRD,EXTERN,REAL,INT
      INTEGER CONINT,LININT,SPLINE,VAR,FUNC,GOTO,CONTIN
      INTEGER UMINUS,INDVAR,ENDSUM,ENDPRD,BEQ,BRA
      PARAMETER (ADD=43,SUB=45,MULT=42,DIV=47,POWER=94)
      PARAMETER (ASSIGN=61,RELOP=258)
      PARAMETER (AND=259,OR=260,NOT=261,INUM=262,RNUM=263)
      PARAMETER (SUM=265,PROD=266,IF=268)
      PARAMETER (ENDIF=271,STDRD=272,EXTERN=273)
      PARAMETER (REAL=277,INT=278,CONINT=280)
      PARAMETER (LININT=281,SPLINE=282,VAR=283,FUNC=285)
      PARAMETER (GOTO=287,CONTIN=289,UMINUS=290)
      PARAMETER (INDVAR=291,ENDSUM=292,ENDPRD=293,BEQ=294,BRA=295)
C
      INTEGER MAXEXT
      PARAMETER (MAXEXT=2)
C
      INTEGER EXTTYP(MAXEXT)
      INTEGER EXT
      INTEGER EXTPAR(2)
C
      INTEGER ISMDEP,FSMDEP,GSMDEP,HSMDEP,RSMDEP
      PARAMETER (ISMDEP=10,FSMDEP=10,GSMDEP=10,HSMDEP=10,RSMDEP=40)
      INTEGER ISTACK(ISMDEP),RSTACK(RSMDEP)
      DOUBLE PRECISION FSTACK(FSMDEP)
      INTEGER ITOS,FTOS,GTOS,HTOS,RTOS
C
      INTEGER PC,X,DIM,I,J,HELP
      DOUBLE PRECISION Z,Z1,Z2,STEIG
      DOUBLE PRECISION X0,B,C,D
C
      INTEGER NOGRAD,GRAD,HESS
      PARAMETER (NOGRAD=0,GRAD=1,HESS=2)
C
      DATA EXTTYP /2,0/
C
      PC=START
      ITOS=0
      FTOS=0
      GTOS=0
      RTOS=0
      HTOS=0
      IF ((MODE .EQ. HESS) .AND. (PVVAHE .NE. PVVA)) THEN
        IERR=59
        RETURN
      ENDIF 
      IF (MVAR .EQ. 0) MODE = NOGRAD
C
      ISTACK(1)=0
      FSTACK(1)=0.0D0
C
      STEIG=0.0D0
      X0=0.0D0
      B=0.0D0
      C=0.0D0
      D=0.0D0
C
 1    X=VPFX(PC)
C10   IF (X .EQ. -1) THEN
      IF (X .EQ. -1) THEN
        IF (ITOS .GT. 0) IVAL=ISTACK(ITOS)
        IF (FTOS .GT. 0) FVAL=FSTACK(FTOS)
        RETURN
      ENDIF
C20   IF (X .EQ. ADD+128) THEN
      IF (X .EQ. ADD+128) THEN
        ISTACK(ITOS-1)=ISTACK(ITOS-1)+ISTACK(ITOS)
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C30   IF (X .EQ. SUB+128) THEN
      IF (X .EQ. SUB+128) THEN
        ISTACK(ITOS-1)=ISTACK(ITOS-1)-ISTACK(ITOS)
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C40   IF (X .EQ. MULT+128) THEN
      IF (X .EQ. MULT+128) THEN
        ISTACK(ITOS-1)=ISTACK(ITOS-1)*ISTACK(ITOS)
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C50   IF (X .EQ. DIV+128) THEN
      IF (X .EQ. DIV+128) THEN
        IF (ISTACK(ITOS) .EQ. 0) THEN
          IERR=9
          RETURN
        ENDIF
        ISTACK(ITOS-1)=ISTACK(ITOS-1)/ISTACK(ITOS)
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C60   IF (X .EQ. UMINUS+128) THEN
      IF (X .EQ. UMINUS+128) THEN
        ISTACK(ITOS)=-ISTACK(ITOS)
        PC=PC+1
        GO TO 1
      ENDIF
C70   IF (X .EQ. INUM+128) THEN
      IF (X .EQ. INUM+128) THEN
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=VICONS(VPFX(PC+1))
        PC=PC+2
        GO TO 1
      ENDIF
C80   IF (X .EQ. INDVAR+128) THEN
      IF (X .EQ. INDVAR+128) THEN
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=VINDVA(VPFX(PC+1))
        PC=PC+2
        GO TO 1
      ENDIF
C85   IF (X .EQ. FUNC+128) THEN
      IF (X .EQ. FUNC+128) THEN
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        ISTACK(ITOS)=IDNINT(VFUNC(IFUNC(VPFX(PC+1),4)))
        PC=PC+2
        GO TO 1
      ENDIF
C90   IF (X .EQ. ADD) THEN
      IF (X .EQ. ADD) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 92 I=1,MVAR
              DO 91 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)+
     2            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 91           CONTINUE
 92         CONTINUE
            HTOS=HTOS-1
          ENDIF
          DO 93 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=GSTACK(DFVAR(I),GTOS-1)+
     1                              GSTACK(DFVAR(I),GTOS)
 93       CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)+FSTACK(FTOS)
        FTOS=FTOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C100  IF (X .EQ. SUB) THEN
      IF (X .EQ. SUB) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 102 I=1,MVAR
              DO 101 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)-
     2            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 101          CONTINUE
 102        CONTINUE
            HTOS=HTOS-1
          ENDIF
          DO 103 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=GSTACK(DFVAR(I),GTOS-1)-
     1                              GSTACK(DFVAR(I),GTOS)
 103      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)-FSTACK(FTOS)
        FTOS=FTOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C110  IF (X .EQ. MULT) THEN
      IF (X .EQ. MULT) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 112 I=1,MVAR
              DO 111 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1           HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)*FSTACK(FTOS)+
     2           HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)*FSTACK(FTOS-1)+
     3           GSTACK(DFVAR(I),GTOS-1)*GSTACK(DFVAR(J),GTOS)+
     4           GSTACK(DFVAR(J),GTOS-1)*GSTACK(DFVAR(I),GTOS)
 111          CONTINUE
 112        CONTINUE
            HTOS=HTOS-1
          ENDIF
          DO 113 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=FSTACK(FTOS)*GSTACK(DFVAR(I),GTOS-1)
     1                             +FSTACK(FTOS-1)*GSTACK(DFVAR(I),GTOS)
 113      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)*FSTACK(FTOS)
        FTOS=FTOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C120  IF (X .EQ. DIV) THEN
      IF (X .EQ. DIV) THEN
        IF (FSTACK(FTOS) .EQ. 0.0D0) THEN
          IERR=9
          RETURN
        ENDIF
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            Z1=FSTACK(FTOS)**2
            Z2=FSTACK(FTOS)**3
            DO 122 I=1,MVAR
              DO 121 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)/
     2            FSTACK(FTOS)-GSTACK(DFVAR(I),GTOS-1)*
     3            GSTACK(DFVAR(J),GTOS)/Z1-
     4            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)*
     5            FSTACK(FTOS-1)/Z1-GSTACK(DFVAR(J),GTOS-1)*
     6            GSTACK(DFVAR(I),GTOS)/Z1+2*FSTACK(FTOS-1)*
     7            GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)/Z2
 121          CONTINUE
 122        CONTINUE
            HTOS=HTOS-1
          ENDIF
          Z=FSTACK(FTOS)**2
          DO 123 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=GSTACK(DFVAR(I),GTOS-1)/FSTACK(FTOS)
     1                           -FSTACK(FTOS-1)/Z*GSTACK(DFVAR(I),GTOS)
 123      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)/FSTACK(FTOS)
        FTOS=FTOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C130  IF (X .EQ. POWER) THEN
      IF (X .EQ. POWER) THEN
        IF (FSTACK(FTOS-1) .LE. 0.0D0) THEN
          IERR=47
          RETURN
        ENDIF
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            Z=DLOG(FSTACK(FTOS-1))*FSTACK(FTOS-1)**FSTACK(FTOS)
            Z1=FSTACK(FTOS-1)**(FSTACK(FTOS)-1.0D0)
            Z2=FSTACK(FTOS-1)**(FSTACK(FTOS)-2.0D0)*FSTACK(FTOS)*
     1         (FSTACK(FTOS)-1.0D0)
            DO 132 I=1,MVAR
              DO 131 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1           Z*DLOG(FSTACK(FTOS-1))*GSTACK(DFVAR(I),GTOS)*
     2           GSTACK(DFVAR(J),GTOS)+Z1*DLOG(FSTACK(FTOS-1))*
     3           FSTACK(FTOS)*GSTACK(DFVAR(J),GTOS-1)*
     4           GSTACK(DFVAR(I),GTOS)+Z1*GSTACK(DFVAR(I),GTOS)*
     5           GSTACK(DFVAR(J),GTOS-1)+Z*
     6           HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     7           Z1*GSTACK(DFVAR(I),GTOS-1)*GSTACK(DFVAR(J),GTOS)+Z1*
     8           FSTACK(FTOS)*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)+
     9           Z1*FSTACK(FTOS)*DLOG(FSTACK(FTOS-1))*
     O           GSTACK(DFVAR(I),GTOS-1)*GSTACK(DFVAR(J),GTOS)+
     O           Z2*GSTACK(DFVAR(I),GTOS-1)*GSTACK(DFVAR(J),GTOS-1)
 131          CONTINUE
 132        CONTINUE
            HTOS=HTOS-1
          ENDIF
          Z1=FSTACK(FTOS)*FSTACK(FTOS-1)**(FSTACK(FTOS)-1.0D0)
          Z2=FSTACK(FTOS-1)**FSTACK(FTOS)*DLOG(FSTACK(FTOS-1))
          DO 133 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=Z1*GSTACK(DFVAR(I),GTOS-1)+
     1                              Z2*GSTACK(DFVAR(I),GTOS)
 133      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)**FSTACK(FTOS)
        FTOS=FTOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C135  IF (X .EQ. POWER+128) THEN
      IF (X .EQ. POWER+128) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            IF ((VPFX(PC+1) .LT. 2) .AND. 
     1          (FSTACK(FTOS) .EQ. 0.0D0)) THEN
              IERR=47
              RETURN
            ENDIF
            Z1=VPFX(PC+1)*FSTACK(FTOS)**(VPFX(PC+1)-1)
            IF (FSTACK(FTOS).NE.0.0D0) THEN
            Z2=VPFX(PC+1)*(VPFX(PC+1)-1)*FSTACK(FTOS)**(VPFX(PC+1)-2)
            ELSE
            Z2=VPFX(PC+1)*(VPFX(PC+1)-1)
            ENDIF
            DO 137 I=1,MVAR
              DO 136 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1            Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)+
     2            Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 136          CONTINUE
 137        CONTINUE
          ENDIF
          IF ((VPFX(PC+1) .LT. 1) .AND. (FSTACK(FTOS) .EQ. 0.0D0)) THEN
            IERR=47
            RETURN
          ENDIF
          Z=VPFX(PC+1)*FSTACK(FTOS)**(VPFX(PC+1)-1)
          DO 138 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 138      CONTINUE
        ENDIF
        IF ((VPFX(PC+1) .LT. 0) .AND. (FSTACK(FTOS) .EQ. 0.0D0)) THEN
          IERR=47
          RETURN
        ENDIF
        FSTACK(FTOS)=FSTACK(FTOS)**VPFX(PC+1)
        PC=PC+2
        GO TO 1
      ENDIF
C140  IF (X .EQ. UMINUS) THEN
      IF (X .EQ. UMINUS) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 142 I=1,MVAR
              DO 141 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1            -HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 141          CONTINUE
 142        CONTINUE
          ENDIF
          DO 143 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=-GSTACK(DFVAR(I),GTOS)
 143      CONTINUE
        ENDIF
        FSTACK(FTOS)=-FSTACK(FTOS)
        PC=PC+1
        GO TO 1
      ENDIF
C150  IF (X .EQ. RNUM) THEN
      IF (X .EQ. RNUM) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 152 I=1,MVAR
              DO 151 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 151          CONTINUE
 152        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 153 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 153      CONTINUE
        ENDIF
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        FSTACK(FTOS)=VRCONS(VPFX(PC+1))
        PC=PC+2
        GO TO 1
      ENDIF
C160  IF (X .EQ. INUM) THEN
      IF (X .EQ. INUM) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 162 I=1,MVAR
              DO 161 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 161          CONTINUE
 162        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 163 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 163      CONTINUE
        ENDIF
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        FSTACK(FTOS)=DBLE(VICONS(VPFX(PC+1)))
        PC=PC+2
        GO TO 1
      ENDIF
C170  IF (X .EQ. INDVAR) THEN
      IF (X .EQ. INDVAR) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 172 I=1,MVAR
              DO 171 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 171          CONTINUE
 172        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 173 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 173      CONTINUE
        ENDIF
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        FSTACK(FTOS)=DBLE(VINDVA(VPFX(PC+1)))
        PC=PC+2
        GO TO 1
      ENDIF
C180  IF (X .EQ. REAL) THEN
      IF (X .EQ. REAL) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 182 I=1,MVAR
              DO 181 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 181          CONTINUE
 182        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 183 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 183      CONTINUE
        ENDIF
        DIM=IRCONS(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4))
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 1) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS) .LT. 0) .OR. (ISTACK(ITOS) .GT.
     1         IRCONS(VPFX(PC+1),2))) THEN
            IERR=33
            RETURN
          ENDIF
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4)+ISTACK(ITOS)-1)
          ITOS=ITOS-1
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 2) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS-1) .LE. 0) .OR. (ISTACK(ITOS) .LT. 0) .OR.
     1        (ISTACK(ITOS-1) .GT. IRCONS(VPFX(PC+1),2)) .OR.
     2        (ISTACK(ITOS) .GT. IRCONS(VPFX(PC+1),3))) THEN
            IERR=33
            RETURN
          ENDIF
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4)+(ISTACK(ITOS-1)-1)*
     1                        IRCONS(VPFX(PC+1),3)+ISTACK(ITOS)-1)
          ITOS=ITOS-2
          PC=PC+2
          GO TO 1
        ENDIF
      ENDIF
C190  IF (X .EQ. INT) THEN
      IF (X .EQ. INT) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 192 I=1,MVAR
              DO 191 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 191          CONTINUE
 192        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 193 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 193      CONTINUE
        ENDIF
        DIM=IICONS(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          FSTACK(FTOS)=DBLE(VICONS(IICONS(VPFX(PC+1),4)))
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 1) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS) .LT. 0) .OR. (ISTACK(ITOS) .GT.
     1        IICONS(VPFX(PC+1),2))) THEN
            IERR=33
            RETURN
          ENDIF
          FSTACK(FTOS)=DBLE(VICONS(IICONS(VPFX(PC+1),4)+ISTACK(ITOS)-1))
          ITOS=ITOS-1
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 2) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS-1) .LE. 0) .OR. (ISTACK(ITOS) .LT. 0) .OR.
     1        (ISTACK(ITOS-1) .GT. IICONS(VPFX(PC+1),2)) .OR.
     2        (ISTACK(ITOS) .GT. IICONS(VPFX(PC+1),3))) THEN
            IERR=33
            RETURN
          ENDIF
          FSTACK(FTOS)=DBLE(VICONS(IICONS(VPFX(PC+1),4)+(ISTACK(ITOS-1)
     1                 -1)*IICONS(VPFX(PC+1),3)+ISTACK(ITOS)-1))
          ITOS=ITOS-2
          PC=PC+2
          GO TO 1
        ENDIF
      ENDIF
C200  IF (X .EQ. VAR) THEN
      IF (X .EQ. VAR) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 202 I=1,MVAR
              DO 201 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 201          CONTINUE
 202        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 203 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 203      CONTINUE
        ENDIF
        DIM=IVARI(VPFX(PC+1),1)
        IF (DIM .EQ. 0) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          FSTACK(FTOS)=VVARI(IVARI(VPFX(PC+1),3))
          IF (MODE .GE. GRAD) GSTACK(IVARI(VPFX(PC+1),3),GTOS)=1.0D0
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 1) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS) .LE. 0) .OR. (ISTACK(ITOS) .GT.
     1        IVARI(VPFX(PC+1),2))) THEN
            IERR=33
            RETURN
          ENDIF
          FSTACK(FTOS)=VVARI(IVARI(VPFX(PC+1),3)+ISTACK(ITOS)-1)
          IF (MODE .GE. GRAD) GSTACK(IVARI(VPFX(PC+1),3)
     1                        +ISTACK(ITOS)-1,GTOS)=1.0D0
          ITOS=ITOS-1
          PC=PC+2
          GO TO 1
        ENDIF
      ENDIF
C210  IF (X .EQ. FUNC) THEN
      IF (X .EQ. FUNC) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
        ENDIF
        DIM=IFUNC(VPFX(PC+1),1)
        IF (DIM .LE. 0) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              DO 212 I=1,MVAR
                DO 211 J=1,MVAR
                 HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1             VHESS(IFUNC(VPFX(PC+1),7),(DFVAR(I)-1)*PVVA+DFVAR(J))
 211            CONTINUE
 212          CONTINUE 
            ENDIF
            DO 213 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=VGRAD(IFUNC(VPFX(PC+1),5),DFVAR(I))
 213        CONTINUE
          ENDIF
          FSTACK(FTOS)=VFUNC(IFUNC(VPFX(PC+1),4))
          PC=PC+2
          GO TO 1
        ELSE IF (DIM .EQ. 1) THEN
          FTOS=FTOS+1
          IF (FTOS .GT. FSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          IF ((ISTACK(ITOS) .LE. 0) .OR. (ISTACK(ITOS) .GT.
     1        IFUNC(VPFX(PC+1),3))) THEN
            IERR=33
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              DO 215 I=1,MVAR
                DO 214 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              VHESS(IFUNC(VPFX(PC+1),7)+ISTACK(ITOS)-1,
     2                      (DFVAR(I)-1)*PVVA+DFVAR(J))
 214            CONTINUE
 215          CONTINUE
            ENDIF
            DO 216 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=VGRAD(IFUNC(VPFX(PC+1),5)+
     1                                    ISTACK(ITOS)-1,DFVAR(I))
 216        CONTINUE
          ENDIF
          FSTACK(FTOS)=VFUNC(IFUNC(VPFX(PC+1),4)+ISTACK(ITOS)-1)
          ITOS=ITOS-1
          PC=PC+2
          GO TO 1
        ENDIF
      ENDIF
C220  IF (X .EQ. STDRD) THEN
      IF (X .EQ. STDRD) THEN
        IF (VPFX(PC+1) .EQ. 1) THEN
        Z=DSIGN(1.0D0,FSTACK(FTOS))
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              DO 2202 I=1,MVAR
                DO 2201 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 2201           CONTINUE
 2202         CONTINUE
            ENDIF
            DO 2203 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2203       CONTINUE
          ENDIF
          FSTACK(FTOS)=DABS(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 2) THEN
          IF (FSTACK(FTOS) .LT. 0.0D0) THEN
            IERR=53
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (FSTACK(FTOS) .EQ. 0.0D0) THEN
              IERR=9
              RETURN
            ENDIF
            IF (MODE .EQ. HESS) THEN
              Z1=-0.25D0/DSQRT((FSTACK(FTOS)**3))
              Z2=0.5D0/DSQRT(FSTACK(FTOS))
              DO 2205 I=1,MVAR
                DO 2204 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z2*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z1*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2204           CONTINUE
 2205         CONTINUE
            ENDIF
            Z=0.5D0/DSQRT(FSTACK(FTOS))
            DO 2206 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2206       CONTINUE
          ENDIF
          FSTACK(FTOS)=DSQRT(FSTACK(FTOS))
          PC=PC+2
        GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 3) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
            Z=DEXP(FSTACK(FTOS))
              DO 2208 I=1,MVAR
                DO 2207 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2207           CONTINUE
 2208         CONTINUE
            ENDIF
            Z=DEXP(FSTACK(FTOS))
            DO 2209 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2209       CONTINUE
          ENDIF
          FSTACK(FTOS)=DEXP(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 4) THEN
          IF (FSTACK(FTOS) .LE. 0.0D0) THEN
            IERR=52
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/FSTACK(FTOS)
              Z2=1.0D0/(FSTACK(FTOS)**2)
              DO 2211 I=1,MVAR
                DO 2210 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)-
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2210           CONTINUE
 2211         CONTINUE
            ENDIF
            Z=1.0D0/FSTACK(FTOS)
            DO 2212 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2212       CONTINUE
          ENDIF
          FSTACK(FTOS)=DLOG(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 5) THEN
          IF (FSTACK(FTOS) .LE. 0.0D0) THEN
            IERR=52
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
            Z1=1.0D0/(FSTACK(FTOS)*DLOG(10.0D0))
            Z2=1.0D0/((FSTACK(FTOS)**2)*DLOG(10.0D0))
              DO 2214 I=1,MVAR
                DO 2213 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)-
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2213           CONTINUE
 2214         CONTINUE
            ENDIF
            Z=1.0D0/(FSTACK(FTOS)*DLOG(10.0D0))
            DO 2215 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2215       CONTINUE
          ENDIF
          FSTACK(FTOS)=DLOG10(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 6) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=DSIN(FSTACK(FTOS))
              Z2=DCOS(FSTACK(FTOS))
              DO 2217 I=1,MVAR
                DO 2216 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z2*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)-
     2              Z1*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2216           CONTINUE
 2217         CONTINUE
            ENDIF
            Z=DCOS(FSTACK(FTOS))
            DO 2218 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2218       CONTINUE
          ENDIF
          FSTACK(FTOS)=DSIN(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 7) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=-DSIN(FSTACK(FTOS))
              Z2=-DCOS(FSTACK(FTOS))
              DO 2220 I=1,MVAR
                DO 2219 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2219           CONTINUE
 2220         CONTINUE
            ENDIF
            Z=-DSIN(FSTACK(FTOS))
            DO 2221 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2221       CONTINUE
          ENDIF
          FSTACK(FTOS)=DCOS(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 8) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/DCOS(FSTACK(FTOS))**2
              Z2=2.0D0*DSIN(FSTACK(FTOS))/DCOS(FSTACK(FTOS))**3
              DO 2223 I=1,MVAR
                DO 2222 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2222           CONTINUE
 2223         CONTINUE
            ENDIF
            Z=1.0D0/DCOS(FSTACK(FTOS))**2
            DO 2224 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2224       CONTINUE
          ENDIF 
          FSTACK(FTOS)=DTAN(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 9) THEN
           IF (MODE .GE. GRAD) THEN
            IF (DABS(FSTACK(FTOS)) .GE. 1.0D0) THEN
              IERR = 54
              RETURN
            ENDIF
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/DSQRT(1.0D0-FSTACK(FTOS)**2)
              Z2=FSTACK(FTOS)/DSQRT((1.0D0-FSTACK(FTOS)**2)**3)
              DO 2226 I=1,MVAR
                DO 2225 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2225           CONTINUE
 2226         CONTINUE
            ENDIF
            Z=1.0D0/DSQRT(1.0D0-FSTACK(FTOS)**2)
            DO 2227 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2227       CONTINUE
          ENDIF
          IF (DABS(FSTACK(FTOS)) .GT. 1.0D0) THEN
            IERR = 54
            RETURN
          ENDIF
          FSTACK(FTOS)=DASIN(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 10) THEN
          IF (MODE .GE. GRAD) THEN
            IF (DABS(FSTACK(FTOS)) .GE. 1.0D0) THEN
              IERR = 55
              RETURN
            ENDIF
            IF (MODE .EQ. HESS) THEN
              Z1=-1.0D0/DSQRT(1.0D0-FSTACK(FTOS)**2)
              Z2=-FSTACK(FTOS)/DSQRT((1.0D0-FSTACK(FTOS)**2)**3)
              DO 2229 I=1,MVAR
                DO 2228 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2228           CONTINUE
 2229         CONTINUE
            ENDIF
            Z=-1.0D0/DSQRT(1.0D0-FSTACK(FTOS)**2)
            DO 2230 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2230       CONTINUE
          ENDIF
          IF (DABS(FSTACK(FTOS)) .GT. 1.0D0) THEN
            IERR = 55
            RETURN
          ENDIF
          FSTACK(FTOS)=DACOS(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 11) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/(1.0D0+FSTACK(FTOS)**2)
              Z2=-2.0D0*FSTACK(FTOS)/((1.0D0+FSTACK(FTOS)**2)**2)
              DO 2232 I=1,MVAR
                DO 2231 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2231           CONTINUE
 2232         CONTINUE
            ENDIF
            Z=1.0D0/(1.0D0+FSTACK(FTOS)**2)
            DO 2233 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2233       CONTINUE
          ENDIF
          FSTACK(FTOS)=DATAN(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 12) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=DCOSH(FSTACK(FTOS))
              Z2=DSINH(FSTACK(FTOS))
              DO 2235 I=1,MVAR
                DO 2234 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2234           CONTINUE
 2235         CONTINUE
            ENDIF
            Z=DCOSH(FSTACK(FTOS))
            DO 2236 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2236       CONTINUE
          ENDIF
          FSTACK(FTOS)=DSINH(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 13) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=DSINH(FSTACK(FTOS))
              Z2=DCOSH(FSTACK(FTOS))
              DO 2238 I=1,MVAR
                DO 2237 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2237           CONTINUE
 2238         CONTINUE
            ENDIF
            Z=DSINH(FSTACK(FTOS))
            DO 2239 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2239       CONTINUE
          ENDIF
          FSTACK(FTOS)=DCOSH(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 14) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/DCOSH(FSTACK(FTOS))**2
              Z2=-2.0D0*DSINH(FSTACK(FTOS))/DCOSH(FSTACK(FTOS))**3
              DO 2241 I=1,MVAR
                DO 2240 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2240           CONTINUE
 2241         CONTINUE
            ENDIF
            Z=1.0D0/DCOSH(FSTACK(FTOS))**2
            DO 2242 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2242       CONTINUE
          ENDIF
          FSTACK(FTOS)=DTANH(FSTACK(FTOS))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 15) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/DSQRT(1.0D0+FSTACK(FTOS)**2)
              Z2=-FSTACK(FTOS)/DSQRT((1.0D0+FSTACK(FTOS)**2)**3)
              DO 2244 I=1,MVAR
                DO 2243 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2243           CONTINUE
 2244         CONTINUE
            ENDIF
            Z=1.0D0/DSQRT(1.0D0+FSTACK(FTOS)**2)
            DO 2245 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2245       CONTINUE
          ENDIF
          FSTACK(FTOS)=DLOG(FSTACK(FTOS)+DSQRT(1.0D0+FSTACK(FTOS)**2))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 16) THEN
          IF (MODE .GE. GRAD) THEN
            IF (FSTACK(FTOS) .LE. 1.0D0) THEN
              IERR = 56
              RETURN
            ENDIF
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/DSQRT(FSTACK(FTOS)**2-1.0D0)
              Z2=-FSTACK(FTOS)/DSQRT((FSTACK(FTOS)**2-1.0D0)**3)
              DO 2247 I=1,MVAR
                DO 2246 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2246           CONTINUE
 2247         CONTINUE
            ENDIF
            Z=1.0D0/DSQRT(FSTACK(FTOS)**2-1.0D0)
            DO 2248 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2248       CONTINUE
          ENDIF
          IF (FSTACK(FTOS) .LT. 1.0D0) THEN
            IERR = 56
            RETURN
          ENDIF
          FSTACK(FTOS)=DLOG(FSTACK(FTOS)+DSQRT(FSTACK(FTOS)**2-1.0D0))
          PC=PC+2
          GOTO 1
C
        ELSE IF (VPFX(PC+1) .EQ. 17) THEN
          IF (DABS(FSTACK(FTOS)) .GE. 1.0D0) THEN
            IERR = 51
            RETURN
          ENDIF
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              Z1=1.0D0/(1.0D0-FSTACK(FTOS)**2)
              Z2=2.0D0*FSTACK(FTOS)/((1.0D0-FSTACK(FTOS)**2)**2)
              DO 2250 I=1,MVAR
                DO 2249 J=1,MVAR
                  HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1              Z1*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2              Z2*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)
 2249           CONTINUE
 2250         CONTINUE
            ENDIF
            Z=1.0D0/(1.0D0-FSTACK(FTOS)**2)
            DO 2251 I=1,MVAR
              GSTACK(DFVAR(I),GTOS)=Z*GSTACK(DFVAR(I),GTOS)
 2251       CONTINUE
          ENDIF
          FSTACK(FTOS)=0.5D0*DLOG((1.0D0+FSTACK(FTOS))/
     1                            (1.0D0-FSTACK(FTOS)))
          PC=PC+2
          GOTO 1
        ENDIF
      ENDIF
C230  IF (X .EQ. EXTERN) THEN
      IF (X .EQ. EXTERN) THEN
        EXT=VPFX(PC+1)
        IF (EXTTYP(EXT) .EQ. 1) THEN
          EXTPAR(1)=ISTACK(ITOS)
          ITOS=ITOS-1
        ELSE IF (EXTTYP(EXT) .EQ. 2) THEN
          EXTPAR(1)=ISTACK(ITOS-1)
          EXTPAR(2)=ISTACK(ITOS)
          ITOS=ITOS-2
        ENDIF
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        CALL EXTFUN(EXT,VVARI,PVVA,FSTACK(FTOS),EXTPAR)
        IF (MODE .GE. GRAD) THEN
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          CALL EXTGRA(EXT,VVARI,PVVA,GSTACK(1,GTOS),EXTPAR)
        ENDIF
        IF (MODE .EQ. HESS) THEN
          HTOS=HTOS+1
          IF (HTOS .GT. HSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          CALL EXTHES(EXT,VVARI,PVVA,HSTACK(1,HTOS),EXTPAR)
        ENDIF
        PC=PC+2
        GO TO 1
      ENDIF
C240  IF (X .EQ. SUM) THEN
      IF (X .EQ. SUM) THEN
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RTOS=RTOS+4
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 242 I=1,MVAR
              DO 241 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 241          CONTINUE
 242        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 243 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 243      CONTINUE
        ENDIF
        FSTACK(FTOS)=0.0D0
        RSTACK(RTOS)=IINDEX(VPFX(PC+2),2)
        RSTACK(RTOS-1)=IINDEX(VPFX(PC+2),5)
        RSTACK(RTOS-2)=VPFX(PC+1)
        RSTACK(RTOS-3)=PC+3
        VINDVA(VPFX(PC+1))=VINDEX(RSTACK(RTOS-1))
        PC=PC+3
        GO TO 1
      ENDIF
C250  IF (X .EQ. ENDSUM) THEN
      IF (X .EQ. ENDSUM) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 252 I=1,MVAR
              DO 251 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)+
     2            HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 251          CONTINUE
 252        CONTINUE
            HTOS=HTOS-1
          ENDIF
          DO 253 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=GSTACK(DFVAR(I),GTOS-1)+
     1                              GSTACK(DFVAR(I),GTOS)
 253      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)+FSTACK(FTOS)
        FTOS=FTOS-1
        RSTACK(RTOS)=RSTACK(RTOS)-1
        IF (RSTACK(RTOS) .GT. 0) THEN
          RSTACK(RTOS-1)=RSTACK(RTOS-1)+1
          VINDVA(RSTACK(RTOS-2))=VINDEX(RSTACK(RTOS-1))
          PC=RSTACK(RTOS-3)
        ELSE
          RTOS=RTOS-4
          PC=PC+1
        ENDIF
        GO TO 1
      ENDIF
C260  IF (X .EQ. PROD) THEN
      IF (X .EQ. PROD) THEN
        FTOS=FTOS+1
        IF (FTOS .GT. FSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        RTOS=RTOS+4
        IF (RTOS .GT. RSMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            HTOS=HTOS+1
            IF (HTOS .GT. HSMDEP) THEN
              IERR=24
              RETURN
            ENDIF
            DO 262 I=1,MVAR
              DO 261 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 261          CONTINUE
 262        CONTINUE
          ENDIF
          GTOS=GTOS+1
          IF (GTOS .GT. GSMDEP) THEN
            IERR=24
            RETURN
          ENDIF
          DO 263 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 263      CONTINUE
        ENDIF
        FSTACK(FTOS)=1.0D0
        RSTACK(RTOS)=IINDEX(VPFX(PC+2),2)
        RSTACK(RTOS-1)=IINDEX(VPFX(PC+2),5)
        RSTACK(RTOS-2)=VPFX(PC+1)
        RSTACK(RTOS-3)=PC+3
        VINDVA(VPFX(PC+1))=VINDEX(RSTACK(RTOS-1))
        PC=PC+3
        GO TO 1
      ENDIF
C270  IF (X .EQ. ENDPRD) THEN
      IF (X .EQ. ENDPRD) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 272 I=1,MVAR
              DO 271 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)=
     1           HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS-1)*FSTACK(FTOS)+
     2           HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)*FSTACK(FTOS-1)+
     2           GSTACK(DFVAR(I),GTOS-1)*GSTACK(DFVAR(J),GTOS)+
     3           GSTACK(DFVAR(J),GTOS-1)*GSTACK(DFVAR(I),GTOS)
 271          CONTINUE
 272        CONTINUE
            HTOS=HTOS-1
          ENDIF
          DO 273 I=1,MVAR
            GSTACK(DFVAR(I),GTOS-1)=FSTACK(FTOS)*GSTACK(DFVAR(I),GTOS-1)
     1                             +FSTACK(FTOS-1)*GSTACK(DFVAR(I),GTOS)
 273      CONTINUE
          GTOS=GTOS-1
        ENDIF
        FSTACK(FTOS-1)=FSTACK(FTOS-1)*FSTACK(FTOS)
        FTOS=FTOS-1
        RSTACK(RTOS)=RSTACK(RTOS)-1
        IF (RSTACK(RTOS) .GT. 0) THEN
          RSTACK(RTOS-1)=RSTACK(RTOS-1)+1
          VINDVA(RSTACK(RTOS-2))=VINDEX(RSTACK(RTOS-1))
          PC=RSTACK(RTOS-3)
        ELSE
          RTOS=RTOS-4
          PC=PC+1
        ENDIF
        GO TO 1
      ENDIF
C275  IF ((X .EQ. IF+128) .OR. (X .EQ. ENDIF+128)) THEN
      IF ((X .EQ. IF+128) .OR. (X .EQ. ENDIF+128)) THEN
        PC=PC+1
        GO TO 1
      ENDIF
C280  IF (X .EQ. RELOP) THEN
      IF (X .EQ. RELOP) THEN
        ITOS=ITOS+1
        IF (ITOS .GT. ISMDEP) THEN
          IERR=24
          RETURN
        ENDIF
        IF (VPFX(PC+1) .EQ. 1) THEN
          IF (FSTACK(FTOS-1) .EQ. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ELSE IF (VPFX(PC+1) .EQ. 2) THEN
          IF (FSTACK(FTOS-1) .NE. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ELSE IF (VPFX(PC+1) .EQ. 3) THEN
          IF (FSTACK(FTOS-1) .LT. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ELSE IF (VPFX(PC+1) .EQ. 4) THEN
          IF (FSTACK(FTOS-1) .LE. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ELSE IF (VPFX(PC+1) .EQ. 5) THEN
          IF (FSTACK(FTOS-1) .GT. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ELSE IF (VPFX(PC+1) .EQ. 6) THEN
          IF (FSTACK(FTOS-1) .GE. FSTACK(FTOS)) THEN
            ISTACK(ITOS)=1
          ELSE
            ISTACK(ITOS)=0
          ENDIF
        ENDIF
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) HTOS=HTOS-2
          GTOS=GTOS-2
        ENDIF
        FTOS=FTOS-2
        PC=PC+2
        GO TO 1
      ENDIF
C290  IF (X .EQ. AND) THEN
      IF (X .EQ. AND) THEN
        IF (ISTACK(ITOS-1)+ISTACK(ITOS) .EQ. 2) THEN
          ISTACK(ITOS-1)=1
        ELSE
          ISTACK(ITOS-1)=0
        ENDIF
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C300  IF (X .EQ. OR) THEN
      IF (X .EQ. OR) THEN
        IF (ISTACK(ITOS-1)+ISTACK(ITOS) .GT. 0) THEN
          ISTACK(ITOS-1)=1
        ELSE
          ISTACK(ITOS-1)=0
        ENDIF
        ITOS=ITOS-1
        PC=PC+1
        GO TO 1
      ENDIF
C310  IF (X .EQ. NOT) THEN
      IF (X .EQ. NOT) THEN
        ISTACK(ITOS)=1-ISTACK(ITOS)
        PC=PC+1
        GO TO 1
      ENDIF
C320  IF (X .EQ. BEQ) THEN
      IF (X .EQ. BEQ) THEN
        IF (ISTACK(ITOS) .EQ. 0) THEN
          ITOS=ITOS-1
          PC=VPFX(PC+1)
        ELSE
          ITOS=ITOS-1
          PC=PC+2
        ENDIF
        GO TO 1
      ENDIF
C330  IF (X .EQ. BRA) THEN
      IF (X .EQ. BRA) THEN
        PC=VPFX(PC+1)
        GO TO 1
      ENDIF
C340  IF (X .EQ. GOTO) THEN
      IF (X .EQ. GOTO) THEN
        PC=VPFX(PC+2)
        GO TO 1
      ENDIF
C350  IF (X .EQ. CONTIN) THEN
      IF (X .EQ. CONTIN) THEN
        PC=PC+2
        GO TO 1
      ENDIF
C360  IF (X .EQ. ASSIGN) THEN
      IF (X .EQ. ASSIGN) THEN
        IF (IFUNC(VPFX(PC+1),1) .LE. 0) THEN
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              DO 402 I=0,PVVA-1
                DO 401 J=1,PVVA
                  VHESS(IFUNC(VPFX(PC+1),7),I*PVVA+J)=0.0D0
 401            CONTINUE
 402          CONTINUE
              DO 362 I=1,MVAR
                DO 361 J=1,MVAR
                  VHESS(IFUNC(VPFX(PC+1),7),(DFVAR(I)-1)*PVVA+DFVAR(J))=
     1              HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 361            CONTINUE
 362          CONTINUE
              HTOS=HTOS-1
            ENDIF
            DO 403 I=1,PVVA
              VGRAD(IFUNC(VPFX(PC+1),5),I)=0.0D0
 403        CONTINUE
            DO 363 I=1,MVAR
              VGRAD(IFUNC(VPFX(PC+1),5),DFVAR(I))=GSTACK(DFVAR(I),GTOS)
 363        CONTINUE
            GTOS=GTOS-1
          ENDIF
          VFUNC(IFUNC(VPFX(PC+1),4))=FSTACK(FTOS)
        ELSE
          IF (MODE .GE. GRAD) THEN
            IF (MODE .EQ. HESS) THEN
              DO 405 I=0,PVVA-1
                DO 404 J=1,PVVA
                  VHESS(IFUNC(VPFX(PC+1),7)+VINDVA(IFUNC(VPFX(PC+1),2))-
     1                        1,I*PVVA+J)=0.0D0
 404            CONTINUE
 405          CONTINUE
              DO 365 I=1,MVAR
                DO 364 J=1,MVAR
                  VHESS(IFUNC(VPFX(PC+1),7)+VINDVA(IFUNC(VPFX(PC+1),
     1              2))-1,(DFVAR(I)-1)*PVVA+DFVAR(J))=
     1              HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 364            CONTINUE
 365          CONTINUE
              HTOS=HTOS-1
            ENDIF
            DO 406 I=1,PVVA
               VGRAD(IFUNC(VPFX(PC+1),5)+VINDVA(IFUNC(VPFX(PC+1),2))-
     1               1,I)=0.0D0
 406        CONTINUE
            DO 366 I=1,MVAR
               VGRAD(IFUNC(VPFX(PC+1),5)+VINDVA(IFUNC(VPFX(PC+1),2))-
     1               1,DFVAR(I))=GSTACK(DFVAR(I),GTOS)
 366        CONTINUE
            GTOS=GTOS-1
          ENDIF
          VFUNC(IFUNC(VPFX(PC+1),4)+VINDVA(IFUNC(VPFX(PC+1),2))-1)=
     1      FSTACK(FTOS)
        ENDIF
        FTOS=FTOS-1
        PC=PC+2
        GO TO 1
      ENDIF
C370  IF ((X .EQ. -ASSIGN) .OR. (X .EQ. -FUNC)) THEN
      IF ((X .EQ. -ASSIGN) .OR. (X .EQ. -FUNC)) THEN
        IERR=27
        RETURN
      ENDIF
C380  IF (X .EQ. CONINT) THEN
      IF (X .EQ. CONINT) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
            DO 382 I=1,MVAR
              DO 381 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=0.0D0
 381          CONTINUE
 382        CONTINUE
          ENDIF
          DO 383 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=0.0D0
 383      CONTINUE
        ENDIF
        HELP=IRCONS(VPFX(PC+1),4)+IRCONS(VPFX(PC+1),2)
        IF (IRCONS(VPFX(PC+1),2) .EQ. 0) THEN
          FSTACK(FTOS)=0.0D0
        ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4))) THEN
          FSTACK(FTOS)=0.0D0
        ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-2)) THEN
          FSTACK(FTOS)=VRCONS(HELP-1)
        ELSE
          DO 384 I=IRCONS(VPFX(PC+1),4),HELP-4,2
            IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND. 
     1          (FSTACK(FTOS) .LT. VRCONS(I+2)) ) THEN
              FSTACK(FTOS)=VRCONS(I+1)
              GO TO 385
            ENDIF
 384      CONTINUE
 385      CONTINUE
        ENDIF
        PC=PC+3
        GO TO 1
      ENDIF
C390  IF (X .EQ. LININT) THEN
      IF (X .EQ. LININT) THEN
        IF (MODE .GE. GRAD) THEN
          HELP=IRCONS(VPFX(PC+1),4)+IRCONS(VPFX(PC+1),2)
          IF (IRCONS(VPFX(PC+1),2) .EQ. 0) THEN
            STEIG=0.0D0
          ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4))) THEN
            STEIG=0.0D0
          ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-2)) THEN
            STEIG=0.0D0
          ELSE
            DO 391 I=IRCONS(VPFX(PC+1),4),HELP-4,2
              IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND. 
     1            (FSTACK(FTOS) .LT. VRCONS(I+2)) ) THEN
                STEIG=(VRCONS(I+3)-VRCONS(I+1))/(VRCONS(I+2)-VRCONS(I))
                GO TO 392
              ENDIF
 391        CONTINUE
 392        CONTINUE
          ENDIF
          IF (MODE .EQ. HESS) THEN
            DO 394 I=1,MVAR
              DO 393 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1            STEIG*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 393          CONTINUE
 394        CONTINUE
          ENDIF
          DO 397 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=STEIG*GSTACK(DFVAR(I),GTOS)
 397      CONTINUE
        ENDIF
        HELP=IRCONS(VPFX(PC+1),4)+IRCONS(VPFX(PC+1),2)
        IF (IRCONS(VPFX(PC+1),2) .EQ. 0) THEN
          FSTACK(FTOS)=0.0D0
        ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4))) THEN
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4)+1)
        ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-2)) THEN
          FSTACK(FTOS)=VRCONS(HELP-1)
        ELSE
          DO 398 I=IRCONS(VPFX(PC+1),4),HELP-4,2
            IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND. 
     1          (FSTACK(FTOS) .LT. VRCONS(I+2)) ) THEN
              STEIG=(VRCONS(I+3)-VRCONS(I+1))/(VRCONS(I+2)-VRCONS(I))
              FSTACK(FTOS)=VRCONS(I+1)+(FSTACK(FTOS)-VRCONS(I))*STEIG
              GO TO 399
            ENDIF
 398      CONTINUE
 399      CONTINUE
        ENDIF
        PC=PC+3
        GO TO 1
      ENDIF
C410  IF (X .EQ. SPLINE) THEN
      IF (X .EQ. SPLINE) THEN
        IF (MODE .GE. GRAD) THEN
          IF (MODE .EQ. HESS) THEN
C
          HELP=IRCONS(VPFX(PC+1),4)+IRCONS(VPFX(PC+1),2)
          IF (IRCONS(VPFX(PC+1),2) .EQ. 4*5) THEN
            B=VRCONS(IRCONS(VPFX(PC+1),4)+2)
            C=VRCONS(IRCONS(VPFX(PC+1),4)+3)
            D=VRCONS(IRCONS(VPFX(PC+1),4)+4)
            X0=0.0D0
          ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4)+15)) 
     1    THEN
            B=VRCONS(IRCONS(VPFX(PC+1),4)+2)
            C=VRCONS(IRCONS(VPFX(PC+1),4)+3)
            D=VRCONS(IRCONS(VPFX(PC+1),4)+4)
            X0=0.0D0
          ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-5)) THEN
            B=VRCONS(HELP-8)
            C=VRCONS(HELP-7)
            D=VRCONS(HELP-6)
            X0=VRCONS(HELP-10)
          ELSE
            DO 411 I=IRCONS(VPFX(PC+1),4)+15,HELP-10,5
              IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND.
     1            (FSTACK(FTOS) .LT. VRCONS(I+5)) ) THEN
                B=VRCONS(I+2)
                C=VRCONS(I+3)
                D=VRCONS(I+4)
                X0=VRCONS(I)
                GO TO 412
              ENDIF
 411        CONTINUE
 412        CONTINUE
          ENDIF
C
            DO 414 I=1,MVAR
              DO 413 J=1,MVAR
                HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)=
     1          B*HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     2          2*C*GSTACK(DFVAR(I),GTOS)*GSTACK(DFVAR(J),GTOS)+
     3          2*C*(FSTACK(FTOS)-X0)*
     4          HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)+
     5          6*D*(FSTACK(FTOS)-X0)*GSTACK(DFVAR(I),GTOS)*
     6          GSTACK(DFVAR(J),GTOS)+
     7          3*D*(FSTACK(FTOS)-X0)**2 * 
     8          HSTACK((DFVAR(I)-1)*PVVA+DFVAR(J),HTOS)
 413          CONTINUE
 414        CONTINUE
          ENDIF
          HELP=IRCONS(VPFX(PC+1),4)+IRCONS(VPFX(PC+1),2)
          IF (IRCONS(VPFX(PC+1),2) .EQ. 4*5) THEN
            B=VRCONS(IRCONS(VPFX(PC+1),4)+2)
            C=VRCONS(IRCONS(VPFX(PC+1),4)+3)
            D=VRCONS(IRCONS(VPFX(PC+1),4)+4)
            X0=0.0D0
          ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4)+15)) 
     1    THEN
            B=VRCONS(IRCONS(VPFX(PC+1),4)+2)
            C=VRCONS(IRCONS(VPFX(PC+1),4)+3)
            D=VRCONS(IRCONS(VPFX(PC+1),4)+4)
            X0=0.0D0
          ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-5)) THEN
            B=VRCONS(HELP-8)
            C=VRCONS(HELP-7)
            D=VRCONS(HELP-6)
            X0=VRCONS(HELP-10)
          ELSE
            DO 415 I=IRCONS(VPFX(PC+1),4)+15,HELP-10,5
              IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND.
     1            (FSTACK(FTOS) .LT. VRCONS(I+5)) ) THEN
                B=VRCONS(I+2)
                C=VRCONS(I+3)
                D=VRCONS(I+4)
                X0=VRCONS(I)
                GO TO 416
              ENDIF
 415        CONTINUE
 416        CONTINUE
          ENDIF
          DO 417 I=1,MVAR
            GSTACK(DFVAR(I),GTOS)=
     1        B*GSTACK(DFVAR(I),GTOS)+
     2        2*C*(FSTACK(FTOS)-X0) * GSTACK(DFVAR(I),GTOS)+
     3        3*D*(FSTACK(FTOS)-X0)**2 * GSTACK(DFVAR(I),GTOS)
 417      CONTINUE
        ENDIF
        HELP=IRCONS(VPFX(PC+1),2)+IRCONS(VPFX(PC+1),4)
        IF (IRCONS(VPFX(PC+1),2) .EQ. 4*5) THEN
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4)+1)+
     1                 VRCONS(IRCONS(VPFX(PC+1),4)+2)*FSTACK(FTOS)+
     2                 VRCONS(IRCONS(VPFX(PC+1),4)+3)*FSTACK(FTOS)**2+
     3                 VRCONS(IRCONS(VPFX(PC+1),4)+4)*FSTACK(FTOS)**3
        ELSE IF (FSTACK(FTOS) .LT. VRCONS(IRCONS(VPFX(PC+1),4)+15)) THEN
          FSTACK(FTOS)=VRCONS(IRCONS(VPFX(PC+1),4)+1)+
     1                 VRCONS(IRCONS(VPFX(PC+1),4)+2)*FSTACK(FTOS)+
     2                 VRCONS(IRCONS(VPFX(PC+1),4)+3)*FSTACK(FTOS)**2+
     3                 VRCONS(IRCONS(VPFX(PC+1),4)+4)*FSTACK(FTOS)**3
        ELSE IF (FSTACK(FTOS) .GE. VRCONS(HELP-5)) THEN
          FSTACK(FTOS)=VRCONS(HELP-9)+
     1                 VRCONS(HELP-8)*(FSTACK(FTOS)-VRCONS(HELP-10))+
     2                 VRCONS(HELP-7)*(FSTACK(FTOS)-VRCONS(HELP-10))**2+
     3                 VRCONS(HELP-6)*(FSTACK(FTOS)-VRCONS(HELP-10))**3
        ELSE
          DO 418 I=IRCONS(VPFX(PC+1),4)+15,HELP-10,5
            IF ((FSTACK(FTOS) .GE. VRCONS(I)) .AND.
     1          (FSTACK(FTOS) .LT. VRCONS(I+5)) ) THEN
              FSTACK(FTOS)=VRCONS(I+1)+
     1                     VRCONS(I+2)*(FSTACK(FTOS)-VRCONS(I))+
     2                     VRCONS(I+3)*(FSTACK(FTOS)-VRCONS(I))**2+
     3                     VRCONS(I+4)*(FSTACK(FTOS)-VRCONS(I))**3
              GO TO 419
            ENDIF
 418      CONTINUE
 419      CONTINUE
        ENDIF
C
        PC=PC+3
        GO TO 1
      ENDIF
C
      IERR=26
      WRITE(*,*) 'EVAL (3901) : unknown opcode ',X
      RETURN
      END
C
C
C
      SUBROUTINE SPLNES (VRCONS,DIM,IERR,LNUM)
      INTEGER DIM,IERR,LNUM
      DOUBLE PRECISION VRCONS((DIM+1)*5)
C
      DOUBLE PRECISION DY0,DYN
      DOUBLE PRECISION HELP,XK,YK,HELP1,HELP2,HELP3,HELP4,Y1,Y2,Y3,Y4
      INTEGER K
C     
      IF (DIM .LE. 2) THEN
        IERR=66
        LNUM=LNUM-1
        GO TO 9999
      ENDIF
      HELP1=VRCONS(2)
      HELP2=(VRCONS(7)-VRCONS(2))/(VRCONS(6)-VRCONS(1))
      HELP3=((VRCONS(12)-VRCONS(2))/
     1      ((VRCONS(11)-VRCONS(1))*(VRCONS(11)-VRCONS(6))))-
     2      (HELP2/(VRCONS(11)-VRCONS(6)))
      HELP4=((VRCONS(17)-VRCONS(2))/
     1      ((VRCONS(16)-VRCONS(1))*(VRCONS(16)-VRCONS(6))))-
     2      ((VRCONS(7)-VRCONS(2))/
     3      ((VRCONS(6)-VRCONS(1))*(VRCONS(16)-VRCONS(6))))-
     4      HELP3
      Y4 = HELP4/(VRCONS(16)-VRCONS(11))
      Y3 = HELP3 - (VRCONS(1) + VRCONS(6) + VRCONS(11)) * Y4
      Y2 = HELP2 - (VRCONS(1) + VRCONS(6)) * Y3 -
     1     (VRCONS(6)**2 + VRCONS(1)*VRCONS(6) + VRCONS(1)**2) * Y4
      Y1 = HELP1 - VRCONS(1) * Y2 - VRCONS(1)**2 * Y3 - 
     1             VRCONS(1)**3 * Y4
      DYN=0.0D0
      DY0=Y2 + 2.0D0*Y3*VRCONS(16) + 3.0D0*Y4*VRCONS(16)**2
      VRCONS(2) = Y1
      VRCONS(3) = Y2
      VRCONS(4) = Y3
      VRCONS(5) = Y4
C
      IF (DIM .GE. 4) THEN
        VRCONS(15+3) = 1.0D0
        HELP = VRCONS(15+6)-VRCONS(15+1)
        VRCONS(15+5) = (6.0D0/HELP)*((VRCONS(15+7)-VRCONS(15+2))/
     1                  HELP - DY0)
C
        DO 10 K=1+(4-1),DIM-1
          VRCONS(5*K+3) = (VRCONS(5*(K+1)+1)-VRCONS(5*K+1))/
     F                    (VRCONS(5*(K+1)+1)-VRCONS(5*(K-1)+1))
          VRCONS(5*K+4) = (VRCONS(5*K+1)-VRCONS(5*(K-1)+1))/
     F                    (VRCONS(5*(K+1)+1)-VRCONS(5*(K-1)+1))
          VRCONS(5*K+5) = 6.0D0/(VRCONS(5*(K+1)+1)-VRCONS(5*(K-1)+1))*
     F                    ( (VRCONS(5*(K+1)+2)-VRCONS(5*K+2))/
     F                      (VRCONS(5*(K+1)+1)-VRCONS(5*K+1)) -
     F                      (VRCONS(5*K+2)-VRCONS(5*(K-1)+2))/
     F                      (VRCONS(5*K+1)-VRCONS(5*(K-1)+1)) )
 10     CONTINUE
        VRCONS(5*DIM+4) = 1.0D0
        HELP = VRCONS(5*DIM+1)-VRCONS(5*(DIM-1)+1)
        VRCONS(5*DIM+5) = (6.0D0/HELP)*(DYN - 
     F                    (VRCONS(5*DIM+2)-VRCONS(5*(DIM-1)+2))/HELP)
C
        VRCONS(3+15) = -0.5D0 * VRCONS(3+15)
        VRCONS(4+15) = VRCONS(5+15)/2.0D0
        VRCONS(5*DIM+3) = 0.0D0
        DO 20 K=1+(4-1),DIM
          HELP = VRCONS(5*K+4)*VRCONS(5*(K-1)+3) + 2.0D0
          VRCONS(5*K+3) = -VRCONS(5*K+3)/HELP
          VRCONS(5*K+4) = (VRCONS(5*K+5)-VRCONS(5*K+4)*
     F                     VRCONS(5*(K-1)+4))/HELP
 20     CONTINUE
C
        VRCONS(5*DIM+5) = VRCONS(5*DIM+4)
        DO 30 K=DIM-1,0+(4-1), -1
          VRCONS(5*K+5) = VRCONS(5*K+3)*VRCONS(5*(K+1)+5)+VRCONS(5*K+4)
 30     CONTINUE
C
        DO 40 K=0+(4-1),DIM-1
          XK = VRCONS(5*(K+1)+1)-VRCONS(5*K+1)
          YK = VRCONS(5*(K+1)+2)-VRCONS(5*K+2)
          VRCONS(5*K+3) = YK/XK - (XK/6) *
     F                    (2*VRCONS(5*K+5)+VRCONS(5*(K+1)+5))
          VRCONS(5*K+4) = VRCONS(5*K+5)/2.0D0
          VRCONS(5*K+5) = (VRCONS(5*(K+1)+5)-VRCONS(5*K+5))/(6.0D0*XK)
 40     CONTINUE
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
C
C
C
      INTEGER FUNCTION GETIWA(FELD,DIM1,DIM2,IWA,LIWA,INFOLI)
C
      INTEGER FELD,DIM1,DIM2,LIWA
      INTEGER IWA(LIWA),INFOLI(15)
C
      INTEGER IIS,VIS,IIC,VIC,IRC,IVA,IFN,VPF,IV
      INTEGER LIIS,LIIC,LIRC,LIVA,LIFN
C
      PARAMETER (IIS=1,VIS=2,IIC=3,VIC=4,IRC=5,IVA=7,IFN=9,VPF=14,IV=15)
C
      LIIS=INFOLI(1)
C      LVIS=INFOLI(2)
      LIIC=INFOLI(3)
C      LVIC=INFOLI(4)
      LIRC=INFOLI(5)
      LIVA=INFOLI(7)
      LIFN=INFOLI(9)
C      LVPF=INFOLI(14)
C      LIV =INFOLI(15)
C
C
      IF (FELD .EQ. IIS) THEN
        IF (IWA(1) .GT. 1) THEN
          GETIWA=IWA(LIIS+IWA(1)*(DIM2-1)+DIM1)
        ELSE
          GETIWA=IWA(LIIS+DIM2)
        ENDIF
C
      ELSE IF (FELD .EQ. VIS) THEN
        GETIWA=IWA(INFOLI(2)+DIM1)
C 
      ELSE IF (FELD .EQ. IIC) THEN
        IF (IWA(3) .GT. 1) THEN
          GETIWA=IWA(LIIC+IWA(3)*(DIM2-1)+DIM1)
        ELSE
          GETIWA=IWA(LIIC+DIM2)
        ENDIF
C
      ELSE IF (FELD .EQ. VIC) THEN
        GETIWA=IWA(INFOLI(4)+DIM1)
C 
      ELSE IF (FELD .EQ. IRC) THEN
        IF (IWA(5) .GT. 1) THEN
          GETIWA=IWA(LIRC+IWA(5)*(DIM2-1)+DIM1)
        ELSE
          GETIWA=IWA(LIRC+DIM2)
        ENDIF
C
      ELSE IF (FELD .EQ. IVA) THEN
        IF (IWA(7) .GT. 1) THEN
          GETIWA=IWA(LIVA+IWA(7)*(DIM2-1)+DIM1)
        ELSE
          GETIWA=IWA(LIVA+DIM2)
        ENDIF
C
      ELSE IF (FELD .EQ. IFN) THEN
        IF (IWA(9) .GT. 1) THEN
          GETIWA=IWA(LIFN+IWA(9)*(DIM2-1)+DIM1)
        ELSE
          GETIWA=IWA(LIFN+DIM2)
        ENDIF
C
      ELSE IF (FELD .EQ. VPF) THEN
        GETIWA=IWA(INFOLI(14)+DIM1)
C 
      ELSE IF (FELD .EQ. IV) THEN
        GETIWA=IWA(INFOLI(15)+DIM1)
C 
      ELSE 
        STOP 'GETIWA: INTERNAL ERROR OF THE DYNAMIC PARSER.'
      ENDIF
      RETURN
      END

