C*********************************************
C                                            *
C   PROGRAM   : PCOMP                        *
C   MODULE    : ER (ERROR MESSAGES)          *
C   ABSTRACT  : FORTRAN PRECOMPILER          *
C   KEY WORD  : AUTOMATIC DIFFERENTIATION    *
C   SOURCE    : PCOMP 2.3 BY M.LIEPELT       *
C               PCOMP 3.0 BY M.DOBMANN       *
C   COPYRIGHT : C.TRASSL, K.SCHITTKOWSKI     *
C               MATHEMATISCHES INSTITUT,     *
C               UNIVERSITAET BAYREUTH,       *
C               D-95440 BAYREUTH, GERMANY    *
C   DATE      : JUNE 8, 1999                 *
C   VERSION   : 5.5                          *
C                                            *
C*********************************************
C
C
C
      SUBROUTINE SYMERR (LNUM,N)
      INTEGER LNUM,N
C
C**********************************************************************
C                                                                      
C   S Y M E R R   -   INDICATE ERROR MESSAGE AND THE LINE NUMBER IN THE
C                     SOURCE CODE, THE ERROR OCCURRED.           
C                                                                      
C   PARAMETERS:                                                       
C      LNUM   - LINE NUMBER OF ERROR.
C      N      - ERROR CODE.
C
C**********************************************************************
C
      CHARACTER*10 S
      INTEGER SLEN
C
      CALL ITOA2(LNUM,S,SLEN)
      GO TO (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
     1       21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
     2       38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
     3       55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71) N
    1 WRITE(*,1000) 'File not found, compilation denied'
      GOTO 9999
    2 WRITE(*,1000) 'File too long, compilation denied'
      GOTO 9999
    3 WRITE(*,1010) 'Identifier expected',S(1:SLEN)
      GOTO 9999
    4 WRITE(*,1010) 'Identifier redefined',S(1:SLEN)
      GOTO 9999
    5 WRITE(*,1010) ''','' expected',S(1:SLEN)
      GOTO 9999
    6 WRITE(*,1010) '''('' expected',S(1:SLEN)
      GOTO 9999
    7 WRITE(*,1010) 'Identifier not declared',S(1:SLEN)
      GOTO 9999
    8 WRITE(*,1010) 'Type mismatch',S(1:SLEN)
      GOTO 9999
    9 WRITE(*,1010) 'Division by zero',S(1:SLEN)
      GOTO 9999
   10 WRITE(*,1010) 'Constant expected',S(1:SLEN)
      GOTO 9999
   11 WRITE(*,1010) 'Operator expected',S(1:SLEN)
      GOTO 9999
   12 WRITE(*,1010) 'Unexpected end of source file',S(1:SLEN)
      GOTO 9999
   13 WRITE(*,1010) '''.'' expected',S(1:SLEN)
      GOTO 9999
   14 WRITE(*,1010) ''')'' expected',S(1:SLEN)
      GOTO 9999
   15 WRITE(*,1010) 'THEN expected',S(1:SLEN)
      GOTO 9999
   16 WRITE(*,1010) 'ELSE expected',S(1:SLEN)
      GOTO 9999
   17 WRITE(*,1010) 'ENDIF expected',S(1:SLEN)
      GOTO 9999
   18 WRITE(*,1010) 'THEN without IF',S(1:SLEN)
      GOTO 9999
   19 WRITE(*,1010) 'ELSE without IF',S(1:SLEN)
      GOTO 9999
   20 WRITE(*,1010) 'ENDIF without IF',S(1:SLEN)
      GOTO 9999
   21 WRITE(*,1010) '''='' expected',S(1:SLEN)
      GOTO 9999
   22 WRITE(*,1010) 'Bad integer constant',S(1:SLEN)
      GOTO 9999
   23 WRITE(*,1010) 'Bad real constant',S(1:SLEN)
      GOTO 9999
   24 WRITE(*,1010) 'Formula too complex',S(1:SLEN)
      GOTO 9999
   25 WRITE(*,1010) 'Error in expression',S(1:SLEN)
      GOTO 9999
   26 WRITE(*,1010) 'Compiler error',S(1:SLEN)
      GOTO 9999
   27 WRITE(*,1010) 'Identifier not valid',S(1:SLEN)
      GOTO 9999
   28 WRITE(*,1010) 'Unknown type identifier',S(1:SLEN)
      GOTO 9999
   29 WRITE(*,1010) 'Unknown character',S(1:SLEN)
      GOTO 9999
   30 WRITE(*,1010) 'Yacc stack overflow',S(1:SLEN)
      GOTO 9999
   31 WRITE(*,1010) 'Syntax error',S(1:SLEN)
      GOTO 9999
   32 WRITE(*,1010) 'Out of memory',S(1:SLEN)
      GOTO 9999
   33 WRITE(*,1010) 'Bad index',S(1:SLEN)
      GOTO 9999
   34 WRITE(*,1000) 'Internal error of the dynamic parser'   
      GOTO 9999
   35 WRITE(*,1010) 'Wrong number of subscripts',S(1:SLEN)
      GOTO 9999
   36 WRITE(*,1010) 'Wrong number of arguments',S(1:SLEN)
      GOTO 9999
   37 WRITE(*,1010) 'Too many index sets',S(1:SLEN)
      GOTO 9999
   38 WRITE(*,1010) 'Too many integer constants',S(1:SLEN)
      GOTO 9999
   39 WRITE(*,1010) 'Too many real constants',S(1:SLEN)
      GOTO 9999
   40 WRITE(*,1010) 'Too many variables',S(1:SLEN)
      GOTO 9999
   41 WRITE(*,1010) 'Too many functions',S(1:SLEN)
      GOTO 9999
   42 WRITE(*,1010) 'Too many index variables',S(1:SLEN)
      GOTO 9999
   43 WRITE(*,1010) 'Number of variables not consistent',S(1:SLEN)
      GOTO 9999
   44 WRITE(*,1010) 'Number of functions not consistent',S(1:SLEN)
      GOTO 9999
   45 WRITE(*,1010) 'False end symbol',S(1:SLEN)
      GOTO 9999
   46 WRITE(*,1010) 'FORTRAN code exceeds line',S(1:SLEN)
      GOTO 9999
   47 WRITE(*,1010) '**: Domain error',S(1:SLEN)
      GOTO 9999
   48 WRITE(*,1010) 'Bad input format',S(1:SLEN)
      GOTO 9999
   49 WRITE(*,1010) 'Length of working array IWA too small',S(1:SLEN)
      GOTO 9999
   50 WRITE(*,1010) 'Length of working array WA too small',S(1:SLEN)
      GOTO 9999
   51 WRITE(*,1010) 'ATANH: Domain error',S(1:SLEN)
      GOTO 9999
   52 WRITE(*,1010) 'LOG: Domain error',S(1:SLEN)
      GOTO 9999
   53 WRITE(*,1010) 'SQRT: Domain error',S(1:SLEN)
      GOTO 9999
   54 WRITE(*,1010) 'ASIN: Domain error',S(1:SLEN)
      GOTO 9999
   55 WRITE(*,1010) 'ACOS: Domain error',S(1:SLEN)
      GOTO 9999
   56 WRITE(*,1010) 'ACOSH: Domain error',S(1:SLEN)
      GOTO 9999
   57 WRITE(*,1020) 'Label ',S(1:SLEN),' defined more than once'
      GOTO 9999
   58 WRITE(*,1020) 'Label ',S(1:SLEN),' not found'
      GOTO 9999
   59 WRITE(*,1010) 'Wrong index expression',S(1:SLEN)
      GOTO 9999
   60 WRITE(*,1000) 'Wrong call of subroutine SYMINP'
      GOTO 9999
   61 WRITE(*,1000) 'Wrong call of subroutine SYMPRP'
      GOTO 9999
   62 WRITE(*,1000) 'Compilation of source file in GRAD-mode'
      GOTO 9999
   63 WRITE(*,1010) 'Wrong order of interpolation values',S(1:SLEN)
      GOTO 9999
   64 WRITE(*,1000) 'Insufficient memory for interpolation in '//
     &  'subroutine REVCDE'
      GOTO 9999
   65 WRITE(*,1000) 'Length of working array IWA in subroutine '//
     &  'SYMFOR too small'
      GOTO 9999
   66 WRITE(*,1010) 'Insufficient interpolation values',S(1:SLEN)
      GOTO 9999
   67 WRITE(*,1000) 'Compilation of source file not in GRAD-mode'
      GOTO 9999
   68 WRITE(*,1010) 'Missing macro name',S(1:SLEN)
      GOTO 9999
   69 WRITE(*,1010) 'More than MAXMAC macros defined',S(1:SLEN)
      GOTO 9999
   70 WRITE(*,1010) 'More than MAXBUF lines of macro statements',
     &  S(1:SLEN)
      GOTO 9999
   71 WRITE(*,1010) 'More than MAXBUF statements in function',S(1:SLEN)
      GOTO 9999
 1000 FORMAT(/,1X,'*** Error in PCOMP: ',A,'.')
 1010 FORMAT(/,1X,'*** Error in PCOMP: ',A,' (line ',A,').')
 1020 FORMAT(/,1X,'*** Error in PCOMP: ',3A,'.')
 9999 RETURN
      END
C
C
C
      SUBROUTINE ITOA2 (N,S,SLEN)
      INTEGER N
      CHARACTER*10 S
      INTEGER SLEN
C
      CHARACTER*10 DUMMY
      INTEGER I
C
      WRITE(S,'(I10)',ERR=11) N
      DO 10 I=1,10 
        IF (S(I:I) .NE. ' ') THEN
C         S=S(I:10)
          DUMMY=S(I:10)
          S=DUMMY
          SLEN=10-I+1
          RETURN
        ENDIF
 10   CONTINUE
 11   CONTINUE
      SLEN=10
      RETURN
      END
