C
C------------------------------------------------------
C
C     Problem:    ZOOPLANK
C
C     Date:       08.10.2004
C                                           
C------------------------------------------------------
C
*     REAL CONSTANT
      m = 40
      K1 = 500
      K2 = 200 
      C = 0.5     
C        
C------------------------------------------------------
C          
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r1, r2, w, w1, w2, w3, alpha1, alpha2, P1, P2, Z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION P1_t
      P1_t = r1*P1*(1 - P1/K1) - alpha1*P1*P2 - w*P1*Z
C
*     FUNCTION P2_t
      P2_t = r2*P2*(1 - P2/K2) - alpha2*P1*P2   
     /       - w1*P2*Z/(m + P2)   
C
*     FUNCTION Z_t
      Z_t = w2*P1*Z + w3*P2*Z/(m + P2) - c*Z
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION P1_0
      P1_0 = 285
C
*     FUNCTION P2_0
      P2_0 = 5100
C
*     FUNCTION Z_0
      Z_0 = 220    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION P1_fit
      P1_fit = P1
C
*     FUNCTION P2_fit
      P2_fit = P2
C
*     FUNCTION Z_fit
      Z_fit = Z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

