C
C------------------------------------------------------
C
C     Problem:    YEASTOSC
C
C     Date:       27.07.99
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      mumax=0.4
      KE=0.2
      sigSEm=0.3
      KS=0.1
      sigSGm=0.1
      k1=1   
      k2=1
      n=3
      sigGEm=0.2
      sigT1m=0.5
      sigT2m=0.5
      KG=0.01
      YXE=1
      KET=0.1
      SF=20 
      R0 = 2.0
      e0 = 0.2
      s0 = 0.004 
      G0 = 0.4
      te0 = 0.2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      D, R, E, S, G, TE, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C 
*     FUNCTION r_t
      X = G + R
      mu = mumax*E/(KE + E)
      rGE = sigGEm*E/(1 + (KG*X/G)**n)  
      rSE = sigSEm *S/(KS + S)   
      rEX = mu/YXE
      rSG = sigSGm*exp(-k1*E + k2*S)  
      rGE = sigGEm * G * TE   
      rT1 = sigT1m/(1 + abs((KG/G + KET/E))**n)  
      rT2 = sigT2m*TE   
      r_t = (mu-D)*R   
C 
*     FUNCTION E_t
      E_t = -D*E + (rGE + rSE - rEX)*R 
C 
*     FUNCTION S_t
      S_t = D*(SF - S) - (rSE + rSG)*R  
C 
*     FUNCTION G_t
      G_t = -D*G + (rSG - rGE)*R   
C 
*     FUNCTION TE_t
      TE_t = -D*TE + (rT1 - rT2)*R     
      
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION R_0
      R_0 = R0
C
*     FUNCTION E_0
      E_0 = E0
C
*     FUNCTION S_0
      S_0 = S0
C
*     FUNCTION G_0
      G_0 = G0
C
*     FUNCTION TE_0
      TE_0 = TE0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = G + R 
C
C
C------------------------------------------------------
C
C
*     END
C
C------------------------------------------------------
C
