C
C------------------------------------------------------
C
C     Problem:    W_WATER1
C
C     Date:       20.05.2003
C
C------------------------------------------------------
C                   
*     REAL CONSTANT
      k2 = 75                           
C
C------------------------------------------------------
C                   
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      b, muem, k1, ks, X, S, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      mue = muem*S/(kS + S)
      X_t = (mue - b)*X
C
*     FUNCTION S_t
      S_t = -k1*mue*X
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0 = 0.054
C
*     FUNCTION S_0
      S_0 = 3
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y
      mue = muem*S/(kS + S)
      y = k2*mue*X
C
*     FUNCTION X_fit
      X_fit = X
C
*     FUNCTION S_fit
      S_fit = S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
