C
C------------------------------------------------------
C
C     Problem:    WNDSHEAR
C
C     Date:       25.04.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A0 = 198199.97
      A1 = -349.94
      A2 = 0.69039
      B0 = 0.155233
      B1 = 0.1237
      B2 = 2.42065
      C0 = 0.7125
      C1 = 6.08768
      rho = 0.1225
      S = 145
      m = 68000
      g = 9.80665
      xc  = 1000
      yc = 0
      fh = 2
      fr = 2
      dw = 2000
      beta = 1
      pi = 3.1415926535
      hr = 400
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      alpha0, alpha1, alpha2, alpha3, alpha4
      mue0, mue1, mue2, mue3, mue4
      x, y, h, uG, vG, wG, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x_t
      x_t = uG
C
*     FUNCTION y_t
      y_t = vG
C
*     FUNCTION v_t
      v_t = -wG
C
*     FUNCTION uG_t
      alpha = alpha0 + alpha1*t + alpha2*t**2 + alpha3*t**3 
     /                                             + alpha4*t**4
      mue = mue0 + mue1*t + mue2*t**2 + mue3*t**3 + mue4*t**4
      r = sqrt((x-xc)**2 + (y-yc)**2)
      Wr = fr*(100/(((2*r-dw)/400)**2+10) - 100/(((2*r+dw)/400)**2+10))
      Wx = (x - xc)/r*Wr
      Wy = (y - yc)/r*Wr
      Wh = -fh*0.4*h/((r/400)**4 + 10)
      v = sqrt((uG - Wx)**2 + (vG - Wy)**2 + (wG - Wh)**2)
      sin_gamma = -(wG + Wh)/v
      cos_gamma = sqrt(abs(1 - sin_gamma**2))
      aux = sqrt((uG - Wx)**2 + (vG - Wy)**2)
      sin_chi = (vG - Wy)/aux
      cos_chi = (uG - Wx)/aux
      au1 = cos_gamma*cos_chi
      au2 = cos(mue)*sin_gamma*cos_chi + sin(mue)*sin_chi
      av1 = cos_gamma*sin_chi
      av2 = cos(mue)*sin_gamma*sin_chi - sin(mue)*cos_chi
      aw1 = -sin_gamma
      aw2 = cos(mue)*cos_gamma
      Tstar = A0 + A1*v + A2*v**2
      Tr = beta*Tstar
      CD = B0 + B1*alpha + B2*alpha**2
      rho_bar = 0.5*rho*v**2
      D = CD*rho_bar*S
      CL = C0 + C1*alpha
      L = CL*rho_bar*S
C
      uG_t = -au1*(D - Tr)/m - au2*L/m
C
*     FUNCTION vG_t
      vG_t = -av1*(D - Tr)/m - av2*L/m
C
*     FUNCTION wG_t
      wG_t = -aw1*(D - Tr)/m - aw2*L/m
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x_0
      x_0 = 0
C
*     FUNCTION y_0
      y_0 = 0
C
*     FUNCTION h_0
      h_0 = 130
C
*     FUNCTION uG_0
      r0 = sqrt(xc**2 + yc**2)
      Wr0 = fr*(100/(((2*r0-dw)/400)**2+10) 
     /                   - 100/(((2*r0+dw)/400)**2+10))
      Wx0 = -xc/r0*Wr0
      uG_0 = Wx0 + 70*cos(-3/180*pi)
C
*     FUNCTION vG_0
      vG_0 = 0
C
*     FUNCTION wG_0
      Wh0 = -fh*0.4*130/((r0/400)**4 + 10)
      wG_0 = -Wh0 - 70*sin(-3/180*pi)
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION hr_fit
      hr_fit = (h - hr)**3 + hr
C
*     FUNCTION h_fit
      h_fit = h
C
*     FUNCTION uG_fit
      uG_fit = uG
C
*     FUNCTION vG_fit
      vG_fit = vG
C
*     FUNCTION wG_fit
      wG_fit = wG
C
*     FUNCTION alpha_fit
      alpha = alpha0 + alpha1*t + alpha2*t**2 + alpha3*t**3 
     /                                             + alpha4*t**4
      alpha_fit = alpha
C
*     FUNCTION mue_fit
      mue = mue0 + mue1*t + mue2*t**2 + mue3*t**3 + mue4*t**4
      mue_fit = mue
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION alpha_low(i), i in ind
      alpha = alpha0 + alpha1*t + alpha2*t**2 + alpha3*t**3 
     /                                             + alpha4*t**4
      alpha_low(i) = alpha
C
*     FUNCTION alpha_upp(i), i in ind
      alpha_upp(i) = 0.3 - alpha
C
*     FUNCTION mue_low(i), i in ind
      mue = mue0 + mue1*t + mue2*t**2 + mue3*t**3 + mue4*t**4
      mue_low(i) = mue + 0.5
C
*     FUNCTION mue_upp(i), i in ind
      mue_upp(i) = 0.5 - mue
C
*     FUNCTION h_low(i), i in ind
      h_low(i) = h
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


