C
C------------------------------------------------------
C
C     Problem:    WEIBEL
C
C     Date:       1.2.1994
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ALPHA, BETA, KE, Y, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION YP
      IF (T.GT.0.0) THEN
      YP = ALPHA*BETA*T**(BETA-1.0)*DEXP(-ALPHA*T**BETA) - KE*Y
      ELSE
      YP=0.0
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y0
      Y0 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION YFIT
      YFIT = Y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
