C
C------------------------------------------------------
C
C     Problem:    WEEDS
C
C     Date:       28.3.2000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r1, r2, k1, k2, alpha, beta, N10, N20, N1, N2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION N1_t
      N1_t = r1*N1*(1 - (N1 + alpha*N2)/k1)
C
*     FUNCTION N2_t
      N2_t = r2*N2*(1 - (N2 + beta*N1)/k2)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION N1_0
      N1_0 = N10
C
*     FUNCTION N2_0
      N2_0 = N20   
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION N1_fit
      N1_fit = N1
C
*     FUNCTION N2_fit
      N2_fit = N2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

