C
C------------------------------------------------------
C
C     Problem:    WAVE_D
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C
*     PARAMETER
      n = 5
      n1 = 4
      n2 = 3
C
C------------------------------------------------------
C
*     INDEX
      k, k1, k2
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      L = 1.0
      h = 1/(n+1)
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind1 = 1..n1
      ind2 = 1..n2
C
C------------------------------------------------------
C
C   - Variables:
C
*     VARIABLE
      a
      u(i), i in ind
      v(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     differential equations:
C
*     FUNCTION u_t(i), i in ind
      u_t(i) = v(i)
C
*     FUNCTION v1_t
      v1_t = a**2*(u(2) - 2*u(1))/h**2
C
*     FUNCTION v_t(i), i in ind2
      v_t(i) = a**2*(u(i+2) - 2*u(i+1) + u(i))/h**2
C
*     FUNCTION vn1_t
      k = n
      k1 = n-1
      vn1_t = a**2*(-2*u(k) + u(k1))/h**2
C
C------------------------------------------------------
C
C   - Initial values:
C
*     FUNCTION u_0(i), i in ind
      x_i = i*L/(n+1)
      u_0(i) = sin(pi*x_i/L)
C
*     FUNCTION v_0(i), i in ind
      v_0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT(i), i IN ind
      x_i = i*L/(n+1)
      FIT(i) = u(i) - cos(a*pi*t/L)*sin(pi*x_i/L)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

