C
C------------------------------------------------------
C
C     Problem:    WAVE4
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, c
      u, v, u_x, v_x, u_xx, v_xx, fu, fv, fu_x, fv_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux_u
      flux_u = -u
C 
*     FUNCTION flux_v
      flux_v = v
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION up
      up = fu_x - a*u*v
C
*     FUNCTION vp
      vp = fv_x - a*u*v
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      if ((x.gt.-0.3).and.(x.lt.-0.1)) then
        u_0 = b*(1 + cos(c*pi*x))
      else
        u_0 = 0
      endif
C
*     FUNCTION v_0
      if ((x.gt.0.1).and.(x.lt.0.3)) then
        v_0 = b*(1 + cos(c*pi*x))
      else
        v_0 = 0
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l = 0
C
*     FUNCTION v_l
      v_l = 0
C
*     FUNCTION u_r
      u_r = 0
C
*     FUNCTION v_r
      v_r = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = u
C
*     FUNCTION FIT2
      FIT2 = v
C
*     FUNCTION FIT3
      FIT3 = u
C
*     FUNCTION FIT4
      FIT4 = v
C
*     FUNCTION FIT5
      FIT5 = u
C
*     FUNCTION FIT6
      FIT6 = v
C
*     FUNCTION FIT7
      FIT7 = u
C
*     FUNCTION FIT8
      FIT8 = v
C
*     FUNCTION FIT9
      FIT9 = u
C
*     FUNCTION FIT10
      FIT10 = v
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
