C
C------------------------------------------------------
C
C     Problem:    WAVE1
C
C     Date:       4.07.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      L = 1.0
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a, u1, u2, u1_x, u2_x, u1_xx, u2_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_t
      u1_t = u2
C
*     FUNCTION u2_t
      u2_t = a**2*u1_xx 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = sin(pi*x/L)
C
*     FUNCTION u2_0
      u2_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_l
      u1_l = 0
C
*     FUNCTION u1_r
      u1_r = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT(i), i IN ind
      FIT(i) = u1
c      FIT(i) = cos(a*pi*t/L)*sin(pi*x/L)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
