C
C------------------------------------------------------
C
C     Problem:    WATER
C
C     Date:       9.8.1996
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      b, u, phi, u_x, phi_x, u_xx, phi_xx
      fu, fphi, fu_x, fphi_x
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux1
      if (abs(x).gt.b) then
        h=0.0
      else
        h=10.0 - 10.0*(x/b)**2
      endif
      flux1 = -u**2/2 - 980*(phi + h)
C
*     FUNCTION flux2
      flux2 = -u*phi
C
*     FUNCTION u_t
      u_t = fu_x 
C
*     FUNCTION phi_t
      phi_t = fphi_x 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = b
C
*     FUNCTION phi_0
      if (abs(x).gt.b) then
        h=0.0
      else
        h=10.0 - 10.0*(x/b)**2
      endif
      phi_0 = 0.5*b - h
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_l
      u_l=b
C
*     FUNCTION phi_l
      phi_l=0.5*b
C
*     FUNCTION u_r
      u_r=b
C
*     FUNCTION phi_r
      phi_r=0.5*b
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u1_fit
      u1_fit = u
C
*     FUNCTION phi1_fit
      phi1_fit = phi
C
*     FUNCTION u2_fit
      u2_fit = u
C
*     FUNCTION phi2_fit
      phi2_fit = phi
C
*     FUNCTION u3_fit
      u3_fit = u
C
*     FUNCTION phi3_fit
      phi3_fit = phi
C
*     FUNCTION u4_fit
      u4_fit = u
C
*     FUNCTION phi4_fit
      phi4_fit = phi
C
*     FUNCTION u5_fit
      u5_fit = u
C
*     FUNCTION phi5_fit
      phi5_fit = phi
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
