C
C------------------------------------------------------
C
C     Problem:    WASTEWAT
C
C     Date:       20.05.2003
C
C------------------------------------------------------
C                                              
*     REAL CONSTANT
      beta = 0.5             
      k1 = 0.004       
      k2 = 0.004     
      ki = 41.85
      kS1 = 160   
      Y1 = 0.0264 
      mue2max = 0.4      
      Yb = 2.45              
      Yg = 74.54
C
C------------------------------------------------------
C                                              
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mue1max, kS2, Y2, CS0, CX1, CS1, CX2, CS2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CS0_t
      mue1 = mue1max*CS1/(kS1 + CS1)
      mue2 = mue2max*CS2/((kS2 + CS2)*(1 + CS2/ki))
      CS0_t = -beta*CX1*CS0
C
*     FUNCTION CX1_t
      CX1_t = (mue1 - k1)*CX1
C
*     FUNCTION CS1_t
      CS1_t = beta*CX1*CS0 - mue1*CX1/Y1
C
*     FUNCTION CX2_t
      CX2_t = (mue2 - k2)*CX2
C
*     FUNCTION CS2_t
      CS2_t = Yb*mue1*CX1 - mue2*CX2/Y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CS0_0
      CS0_0 = 0.2
C
*     FUNCTION CX1_0
      CX1_0 = 0.8
C
*     FUNCTION CS1_0
      CS1_0 = 0
C
*     FUNCTION CX2_0
      CX2_0 = 0.0005
C
*     FUNCTION CS2_0
      CS2_0 = 0.001
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Q
      mue2 = mue2max*CS2/((kS2 + CS2)*(1 + CS2/ki))
      Q = Yg*mue2*CX2
C
*     FUNCTION CS0_fit
      CS0_fit = CS0
C
*     FUNCTION CX1_fit
      CX1_fit = CX1
C
*     FUNCTION CS1_fit
      CS1_fit = CS1
C
*     FUNCTION CX2_fit
      CX2_fit = CX2
C
*     FUNCTION CS2_fit
      CS2_fit = CS2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
