C
C------------------------------------------------------
C
C     Problem:    VISCOUS
C
C     Date:       06.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      nu1, nu2, nu3, nu4, nu5
      u1, u2, u3, u4, u5
      u1_x, u2_x, u3_x, u4_x, u5_x
      u1_xx, u2_xx, u3_xx, u4_xx, u5_xx
      v1, v2, v3, v4, v5
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u1_t
      u1_t = nu1*u1_xx - sin(2*pi*x)*u1_x
C
*     FUNCTION u2_t
      u2_t = nu2*u2_xx - sin(2*pi*x)*u2_x
C
*     FUNCTION u3_t
      u3_t = nu3*u3_xx - sin(2*pi*x)*u3_x
C
*     FUNCTION u4_t
      u4_t = nu4*u4_xx - sin(2*pi*x)*u4_x
C
*     FUNCTION u5_t
      u5_t = nu5*u5_xx - sin(2*pi*x)*u5_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u1_0
      u1_0 = sin(2*pi*x)
C
*     FUNCTION u2_0
      u2_0 = sin(2*pi*x)
C
*     FUNCTION u3_0
      u3_0 = sin(2*pi*x)
C
*     FUNCTION u4_0
      u4_0 = sin(2*pi*x)
C
*     FUNCTION u5_0
      u5_0 = sin(2*pi*x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION v1_t
      v1_t = nu1*u1_xx - sin(2*pi*x)*u1_x
C
*     FUNCTION v2_t
      v2_t = nu2*u2_xx - sin(2*pi*x)*u2_x
C
*     FUNCTION v3_t
      v3_t = nu3*u3_xx - sin(2*pi*x)*u3_x
C
*     FUNCTION v4_t
      v4_t = nu4*u4_xx - sin(2*pi*x)*u4_x
C
*     FUNCTION v5_t
      v5_t = nu5*u5_xx - sin(2*pi*x)*u5_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION v1_0
      v1_0 = sin(2*pi*x)
C
*     FUNCTION v2_0
      v2_0 = sin(2*pi*x)
C
*     FUNCTION v3_0
      v3_0 = sin(2*pi*x)
C
*     FUNCTION v4_0
      v4_0 = sin(2*pi*x)
C
*     FUNCTION v5_0
      v5_0 = sin(2*pi*x)
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = v1
C
*     FUNCTION u2_left
      u2_left = v2
C
*     FUNCTION u3_left
      u3_left = v3
C
*     FUNCTION u4_left
      u4_left = v4
C
*     FUNCTION u5_left
      u5_left = v5
C
*     FUNCTION u1_right
      u1_right = v1
C
*     FUNCTION u2_right
      u2_right = v2
C
*     FUNCTION u3_right
      u3_right = v3
C
*     FUNCTION u4_right
      u4_right = v4
C
*     FUNCTION u5_right
      u5_right = v5
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = v1
C
*     FUNCTION fit2
      fit2 = v2
C
*     FUNCTION fit3
      fit3 = v3
C
*     FUNCTION fit4
      fit4 = v4
C
*     FUNCTION fit5
      fit5 = v5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


