C
C------------------------------------------------------
C
C     Problem:    VERT_CHL
C
C     Date:       10.2.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      w01, x01, w02, x02, w03, x03
      a, b, u, v, w, x, R, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION u_t
      u_t = v
C
*     FUNCTION v_t
      v_t = w
C
*     FUNCTION w_t
      w_t = x
C
*     FUNCTION x_t
      x_t = R*(a*v*w - b*u*x)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION u_0
      u_0 = 0
C
*     FUNCTION v_0
      v_0 = 0
C
*     FUNCTION w_0
      if (R.lt.11) then
        w_0 = w01
      else
      if (R.lt.21) then
        w_0 = w02
      else
        w_0 = w03
      endif
      endif
C
*     FUNCTION x_0
      if (R.lt.11) then
        x_0 = x01
      else
      if (R.lt.21) then
        x_0 = x02
      else
        x_0 = x03
      endif
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
*     FUNCTION v_fit
      v_fit = v
C
*     FUNCTION w_fit
      w_fit = w
C
*     FUNCTION x_fit
      x_fit = x
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION u1_right
      u1_right = u - 1
C
*     FUNCTION v1_right
      v1_right = v 
C
*     FUNCTION u2_right
      u2_right = u - 1
C
*     FUNCTION v2_right
      v2_right = v  
C
*     FUNCTION u3_right
      u3_right = u - 1
C
*     FUNCTION v3_right
      v3_right = v 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
