C
C------------------------------------------------------
C
C     Problem:    VDPOL_O
C
C     Date:       10.11.1995
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A, B, Y, Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION YP
      YP = Z
C
*     FUNCTION ZP
      if (Y.eq.1) then
        ZP = 0
      else
        ZP = (Z + 2*A*Y*Z**2)/(A*(1 - Y**2))
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y0
      Y0 = B
C
*     FUNCTION Z0
      Z0 = B/(A*(1 - B*B))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION YFIT
      YFIT = Y
C
*     FUNCTION ZFIT
      ZFIT = Z
C
*     FUNCTION EQU
      if (Y.eq.0) then
        EQU = 0
      else   
        EQU = (Y - (1 - Y**2)*Z)/Y
      endif
c
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




