C
C------------------------------------------------------
C
C     Problem:    VAS_ADSS
C
C     Date:       13.05.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0 = 5
      Sa = 4.88
      Va = 1.6
      Sb = 25.7
      Vb = 2.8
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      wtot, k, kminus, P
      a10, a11, a12
      a20, a21, a22
      a30, a31, a32
      ca1, cb1, ca2, cb2, ca3, cb3, cwa1, cwa2, cwa3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ca1_t    
      cwb1 = a10*exp(-a11*t) - a12                              
      ca1_t = -k*ca1*wtot + k*ca1*cwa1 + kminus*cwa1 - P*(ca1-cb1)/Va
C
*     FUNCTION cb1_t
      cb1_t = -k*cb1*wtot + k*cb1*cwb1 + kminus*cwb1 + P*(ca1-cb1)/Vb
C
*     FUNCTION ca2_t    
      cwb2 = a20*exp(-a21*t) - a22                             
      ca2_t = -k*ca2*wtot + k*ca2*cwa2 + kminus*cwa2 - P*(ca2-cb2)/Va
C
*     FUNCTION cb2_t
      cb2_t = -k*cb2*wtot + k*cb2*cwb2 + kminus*cwb2 + P*(ca2-cb2)/Vb
C
*     FUNCTION ca3_t    
      cwb3 = a30*exp(-a31*t) - a32                            
      ca3_t = -k*ca3*wtot + k*ca3*cwa3 + kminus*cwa3 - P*(ca3-cb3)/Va
C
*     FUNCTION cb3_t
      cb3_t = -k*cb3*wtot + k*cb3*cwb3 + kminus*cwb3 + P*(ca3-cb3)/Vb
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION equ1
      cwb1 = a10*exp(-a11*t) - a12                              
      equ1 = cwa1*Sa + ca1*Va + cwb1*Sb + cb1*Vb - C0*(Va+Vb)
C
*     FUNCTION equ2
      cwb2 = a20*exp(-a21*t) - a22                            
      equ2 = cwa2*Sa + ca2*Va + cwb2*Sb + cb2*Vb - C0*(Va+Vb)
C
*     FUNCTION equ3
      cwb3 = a30*exp(-a31*t) - a32                            
      equ3 = cwa3*Sa + ca3*Va + cwb3*Sb + cb3*Vb - C0*(Va+Vb)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION ca1_0
      ca1_0 = C0
C
*     FUNCTION cb1_0
      cb1_0 = C0
C
*     FUNCTION ca2_0
      ca2_0 = C0
C
*     FUNCTION cb2_0
      cb2_0 = 0
C
*     FUNCTION ca3_0
      ca3_0 = 0
C
*     FUNCTION cb3_0
      cb3_0 = C0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION cwa1_0
      cwa1_0 = 0
C
*     FUNCTION cwa2_0
      cwa2_0 = 0
C
*     FUNCTION cwa3_0
      cwa3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ca1_fit
      ca1_fit = ca1
C
*     FUNCTION cb1_fit
      cb1_fit = cb1
C
*     FUNCTION ca2_fit
      ca2_fit = ca2
C
*     FUNCTION cb2_fit
      cb2_fit = cb2
C
*     FUNCTION ca3_fit
      ca3_fit = ca3
C
*     FUNCTION cb3_fit
      cb3_fit = cb3
C                        
*     FUNCTION cwa1_plot
      cwa1_plot = cwa1
C
*     FUNCTION cwb1_plot        
      cwb1_plot = a10*exp(a11*t) - a12                           
C                        
*     FUNCTION cwa2_plot
      cwa2_plot = cwa2 
C      
*     FUNCTION cwb2_plot        
      cwb2_plot = a20*exp(a21*t) - a22                             
C                        
*     FUNCTION cwa3_plot
      cwa3_plot = cwa3
C      
*     FUNCTION cwb3_plot        
      cwb3_plot = a30*exp(a31*t) - a32                         
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g1
c      g1 = cwa1 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
