C
C------------------------------------------------------
C
C   Problem:    VAS_ADSP
C
C   Date:       13.05.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0 = 5
      Sa = 1
      Va = 1.4
      Sb = 2
      Vb = 2.5
      cwb = 0.01
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      wtot, k, kminus, P, ca, cb, cwa, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION ca_t
      ca_t = -k*ca*wtot + k*ca*cwa + kminus*cwa - P*(ca-cb)/Va
C
*     FUNCTION cb_t
      cb_t = -k*cb*wtot + k*cb*cwb + kminus*cwb + P*(ca-cb)/Vb
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION equ
      equ = cwa*Sa + ca*Va + cwb*Sb + cb*Vb - C0*(Va+Vb)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION ca_0
      ca_0 = C0
C
*     FUNCTION cb_0
      cb_0 = C0
C
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION cwa_0
      cwa_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ca_fit
      ca_fit = ca
C
*     FUNCTION cb_fit
      cb_fit = cb
C
*     FUNCTION cwa_fit
      cwa_fit = cwa
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
