C
C------------------------------------------------------
C
C     Problem:    VAR_META
C
C     Date:       14.10.2002
C
C------------------------------------------------------
C
*     PARAMETER
      n = 5
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
C
C------------------------------------------------------
C
*     INDEX 
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V1 = 2.53E-02
      Ki1 = 3.15E+00
      ni1 = 1.00E-10
      Ka1 = 2.11E-10
      na1 = 1.31E-01
      V2 = 8.22E-01
      Ki2 = 2.18E-01
      ni2 = 9.24E-02
      Ka2 = 1.19E+00
      na2 = 2.02E+00
      V3 = 9.31E+00
      Ki3 = 4.88E+00
      ni3 = 3.73E-01
      Ka3 = 9.14E-01
      na3 = 2.15E+00
      V4 = 1.22E+00
      K4 = 6.17E+00
      V5 = 1.34E-01
      K5 = 1.44E+00
      V6 = 6.66E-02
      K6 = 4.37E-01
      kcat1 = 2.13E+00
      Km1 = 3.94E-02
      Km2 = 1.16E-02
      kcat2 = 6.36E+00
      Km3 = 8.56E-01
      Km4 = 2.70E+00
      kcat3 = 4.81E+00
      Km5 = 1.21E+01
      Km6 = 4.37E-01
C
C------------------------------------------------------
C
*     TABLE Sv(j), j in ind
      1  0.1
      2  0.1
      3  0.1 
      4  0.1
      5  0.46
C
*     TABLE Pv(j), j in ind
      1  0.05
      2  0.14
      3  0.37
      4  1.0
      5  0.05
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k_1, k_2, k_3, k_4, k_5, k_6
      G1, G2, G3, E1, E2, E3, M1, M2, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION G1_t
      i = 1
      ri = 1
 1000 continue   
      if (c.lt.ri) then
        S = Sv(i)
        P = Pv(i)
        goto 2000
      endif
      i = i+1
      ri = ri+1
      if (i.le.n) then
        goto 1000
      endif
 2000 continue     
      G1_t = V1/(1+(P/Ki1)**ni1+(Ka1/S)**na1) - k_1*G1
C
*     FUNCTION G2_t
      G2_t = V2/(1+(P/Ki2)**ni2+(Ka2/M1)**na2) - k_2*G2
C
*     FUNCTION G3_t
      G3_t = V3/(1+(P/Ki3)**ni3+(Ka3/M2)**na3) - k_3*G3
C
*     FUNCTION E1_t
      E1_t = V4*G1/(K4+G1) - k_4*E1
C
*     FUNCTION E2_t
      E2_t = V5*G2/(K5+G2) - k_5*E2
C
*     FUNCTION E3_t
      E3_t = V6*G2/(K6+G3) - k_6*E3
C
*     FUNCTION M1_t
      M1_t = kcat1*E1*(1/Km1)*(S-M1)/(1+S/Km1+M1/Km2) -
     /       kcat2*E2*(1/Km3)*(M1-M2)/(1+M1/Km3+M2/Km4)
C              
*     FUNCTION M2_t
      M2_t = kcat2*E2*(1/Km3)*(M1-M2)/(1+M1/Km3+M2/Km4)-
     /       kcat3*E3*(1/Km5)*(M2-P)/(1+M2/Km5+P/Km6)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION G1_0
      G1_0 = 0.67
C
*     FUNCTION G2_0
      G2_0 = 0.57
C
*     FUNCTION G3_0
      G3_0 = 0.42
C
*     FUNCTION E1_0
      E1_0 = 0.4
C
*     FUNCTION E2_0
      E2_0 = 0.36
C
*     FUNCTION E3_0
      E3_0 = 0.29
C
*     FUNCTION M1_0
      M1_0 = 1.4
C
*     FUNCTION M2_0
      M2_0 = 0.93
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION G1_fit
      G1_fit = G1
C
*     FUNCTION G2_fit
      G2_fit = G2
C
*     FUNCTION G3_fit
      G3_fit = G3
C
*     FUNCTION E1_fit
      E1_fit = E1
C
*     FUNCTION E2_fit
      E2_fit = E2
C
*     FUNCTION E3_fit
      E3_fit = E3
C
*     FUNCTION M1_fit
      M1_fit = M1
C
*     FUNCTION M2_fit
      M2_fit = M2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

