C
C------------------------------------------------------
C
C     Problem:    VARVOL
C
C     Date:       02.07.98
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      S0,UM,KS,Y,V,VS,VX,F0,T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VP
      VP=F0
C
*     FUNCTION VSP
      X=VX/V
      S=VS/V
      U=UM*S/(KS+S)
      RX=U*X
      RS=-RX/Y
      VSP=F0*S0+RS*V
C
*     FUNCTION VXP
      X=VX/V
      S=VS/V
      U=UM*S/(KS+S)
      RX=U*X
      VXP=RX*V
C
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION V0
      V0=0.1
C
*     FUNCTION VS0
      VS0=0.2
C
*     FUNCTION VX0
      VX0=0.01
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XFIT
      X=VX/V
      XFIT=X
C
*     FUNCTION SFIT
      S=VS/V
      SFIT=S
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

