C
C------------------------------------------------------
C
C     Problem:    VARMOL
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      R=8.3144   
      NA0=5     
      NB0=0      
      Ninert=1  
      Area=0.012 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P, k, m, yAG, yBG, Temp, z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yAG_z
      NA=yAG*P/(R*Temp)
      NB=yBG*P/(R*Temp)
      G=(NA+NB+Ninert)*R*Temp/P
      yA=yAG/G
      yB=yBG/G
      yAG_z =-k*yA*Area
C
*     FUNCTION yBG_z
      yBG_z =m*k*yA*Area
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION yAG_0
      NA=NA0
      NB=NB0
      G=(NA+NB+Ninert)*R*Temp/P
      yA=NA/(NA+NB+Ninert)
      yB=NB/(NA+NB+Ninert)
      yAG_0 = yA*G
C
*     FUNCTION yBG_0
      yBG_0 = yB*G
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yAG_fit
      yAG_fit = yAG
C
*     FUNCTION yBG_fit
      yBG_fit = yBG
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
