C
C------------------------------------------------------
C
C     Problem:    VAPOR
C
C     Date:       20.01.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a1_water = 8.07131
      a2_water = 1730.63
      a3_water = 233.426
      a1_dioxane = 7.43155
      a2_dioxane = 1554.697
      a3_dioxane = 240.337
      T = 20.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      A12, A21, x1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION p
      x2 = 1 - x1
      p_water = 10**(a1_water - a2_water/(T+a3_water))
      p_dioxane = 10**(a1_dioxane - a2_dioxane/(T+a3_dioxane))
      p = x1*EXP(A12*(A21*x2/(A12*x1 + A21*x2))**2)*p_water
     /         + x2*EXP(A21*(A12*x1/(A12*x1 + A21*x2))**2)*p_dioxane
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






