C
C------------------------------------------------------
C
C     Problem:    US_CSTR
C
C     Date:       16.12.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ca0 = 0.9
      Cb0 = 0.3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, Ca, Cb, tb, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Ca_t
      Ca_t = Ca0 - Ca - tb*(k1*Ca*Cb + k2*Ca*(Ca - k3*Cb))
C
*     FUNCTION Cb_t
      Cb_t = Cb0 - Cb - tb*k1*Ca*Cb
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ca_0
      Ca_0 = Ca0
C
*     FUNCTION Cb_0
      Cb_0 = Cb0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ca_fit
      Ca_fit = Ca
C
*     FUNCTION Cb_fit
      Cb_fit = Cb
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

