C
C------------------------------------------------------
C
C     Problem:    URETHANX
C
C     Date:       26.2.2007
C
C------------------------------------------------------
C                 
*     PARAMETER
      n = 11      
      n_1 = 10
C
C------------------------------------------------------
C                 
*     INDEX
      i      
C               
C------------------------------------------------------
C                       
*     SET OF INDICES
      ind  = 1..n  
      ind1 = 1..n_1    
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      M1 = 0.11911
      M2 = 0.07412
      M3 = 0.19323
      M4 = 0.31234
      M5 = 0.35733
      M6 = 0.07806
      rho1 = 1095
      rho2 = 809
      rho3 = 1415
      rho4 = 1528
      rho5 = 1451
      rho6 = 1101
      Tref1 = 363.16
      Tref2 = 363.16
      Tref4 = 363.16
      Tg2 = 363.16
      R = 8.314       
C
C------------------------------------------------------
C            
*     TABLE time(k), k in ind
      1  0.0
      2  8.0
      3  16.0
      4  24.0
      5  32.0
      6  40.0
      7  48.0
      8  56.0
      9  64.0
      10 72.0
      11 80.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      kref1x, kref2x, kref4x, kc2x, Ea1x, Ea2x, Ea4x, dh2x   
      MV1, MV2, MV3, ga, gaea, gaeb, Va
      na1, na2, na6, na1ea, na2eb, na6ea, na6eb
      feeda_c(k), k in ind
      feedb_c(k), k in ind
      temp_c(k), k in ind
      n3, n4, n5, n1, n2, n6   
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION n3_t
      kref1 = kref1x*5E-4            
      kref2 = kref2x*8E-8
      kref4 = kref4x*1E-8
      kc2 = kc2x*1.7E-1
      Ea1 = Ea1x*3.52E+4
      Ea2 = Ea2x*8.5E+4
      Ea4 = Ea4x*3.5E+4
      dh2 = dh2x*1.08
      V = n1*M1/rho1 + n2*M2/rho2 + n3*M3/rho3 + n4*M4/rho4     
     /    + n5*M5/rho5 + n6*M6/rho6
      if (V.lt.1.0E-25) then
        V = 1.0E-25
      endif
      if (t.lt.time(1)) then
        temp = temp_c(1)
        goto 1000
      endif          
      i = n
      if (t.ge.time(i)) then
        temp = temp_c(i)
        goto 1000
      endif  
      i = 1
 1100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        temp = temp_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(temp_c(i+1)-temp_c(i)) 
        goto 1000
      endif
      i = i+1
      if (i.lt.n) then
        goto 1100
      endif       
 1000 continue      
      temp = temp*100
      kc = kc2*exp(-dh2/R*(1/temp - 1/Tg2))
      k1 = kref1*exp(-Ea1/R*(1/temp - 1/Tref1))
      k2 = kref2*exp(-Ea2/R*(1/temp - 1/Tref2))
      k3 = k2/kc
      k4 = kref4*exp(-Ea4/R*(1/Temp - 1/Tref4))
      r1 = k1*n1/V*n2/V
      r2 = k2*n1/V*n3/V
      r3 = k3*n4/V
      r4 = k4*n1/V*n1/V
      n3_t = V*(r1 - r2 + r3)
C
*     FUNCTION n4_t
      n4_t = V*(r2 - r3)
C
*     FUNCTION n5_t
      n5_t = V*r4
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ1
      if (t.lt.time(1)) then
        feeda = feeda_c(1)
        goto 2000
      endif          
      i = n
      if (t.ge.time(i)) then
        feeda = feeda_c(i)
        goto 2000
      endif  
      i = 1
 2100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        feeda = feeda_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(feeda_c(i+1)-feeda_c(i)) 
        goto 2000
      endif
      i = i+1
      if (i.lt.n) then
        goto 2100
      endif       
 2000 continue  
C    
      if (t.lt.time(1)) then
        feedb = feedb_c(1)
        goto 3000
      endif          
      i = n
      if (t.ge.time(i)) then
        feedb = feedb_c(i)
        goto 3000
      endif  
      i = 1
 3100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        feedb = feedb_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(feedb_c(i+1)-feedb_c(i)) 
        goto 3000
      endif
      i = i+1
      if (i.lt.n) then
        goto 3100
      endif       
 3000 continue   
c   
      n1ea = na1ea*feeda
      n2eb = na2eb*feedb
      n6ea = na6ea*feeda
      n6eb = na6eb*feedb
      alg_equ1 = n1 + n3 + 2*n4 + 3*n5 - na1 - n1ea
C
*     FUNCTION alg_equ2
      alg_equ2 = n2 + n3 + n4 - na2 - n2eb
C
*     FUNCTION alg_equ3
      alg_equ3 = n6 - na6 - n6ea - n6eb
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION n3_0          
      if (t.LT.0.001) then
        n3_0 = 0
      else
        n3_0 = n3
      endif    
C
*     FUNCTION n4_0
      if (t.LT.0.001) then
        n4_0 = 0
      else
        n4_0 = n4
      endif    
C
*     FUNCTION n5_0
      if (t.LT.0.001) then
        n5_0 = 0
      else
        n5_0 = n5
      endif    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION n1_0
      if (t.LT.0.001) then
        n1_0 = 0
      else
        n1_0 = n1
      endif    
C
*     FUNCTION n2_0
      if (t.LT.0.001) then
        n2_0 = 0
      else
        n2_0 = n2
      endif    
C
*     FUNCTION n6_0
      if (t.LT.0.001) then
        n6_0 = 0
      else
        n6_0 = n6
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION n1_fit
      if (t.lt.time(1)) then
        temp = temp_c(1)
        goto 5000
      endif          
      i = n
      if (t.ge.time(i)) then
        temp = temp_c(i)
        goto 5000
      endif  
      i = 1
 5100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        temp = temp_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(temp_c(i+1)-temp_c(i)) 
        goto 5000
      endif
      i = i+1
      if (i.lt.n) then
        goto 5100
      endif       
 5000 continue      
      temp = temp*100
      if (t.lt.time(1)) then
        feeda = feeda_c(1)
        goto 6000
      endif          
      i = n
      if (t.ge.time(i)) then
        feeda = feeda_c(i)
        goto 6000
      endif  
      i = 1
 6100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        feeda = feeda_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(feeda_c(i+1)-feeda_c(i)) 
        goto 6000
      endif
      i = i+1
      if (i.lt.n) then
        goto 6100
      endif       
 6000 continue  
C    
      if (t.lt.time(1)) then
        feedb = feedb_c(1)
        goto 7000
      endif          
      i = n
      if (t.ge.time(i)) then
        feedb = feedb_c(i)
        goto 7000
      endif  
      i = 1
 7100 continue      
      if ((t.ge.time(i)).and.(t.lt.time(i+1))) then
        feedb = feedb_c(i) 
     /          + (t - time(i))/(time(i+1)-time(i))*(feedb_c(i+1)-feedb_c(i)) 
        goto 7000
      endif
      i = i+1
      if (i.lt.n) then
        goto 7100
      endif       
 7000 continue   
      n1_fit = n1
C
*     FUNCTION n2_fit
      n2_fit = n2
C
*     FUNCTION n3_fit
      n3_fit = n3
C
*     FUNCTION n4_fit
      n4_fit = n4
C
*     FUNCTION n5_fit
      n5_fit = n5
C
*     FUNCTION n6_fit
      n6_fit = n6
C
*     FUNCTION feeda_fit
      feeda_fit = feeda
C
*     FUNCTION feedb_fit
      feedb_fit = feedb
C
*     FUNCTION temp_fit
      temp_fit = temp
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g1
      g1 = MV1*(na1 + na1ea) - (na2 + na2eb)
C
*     FUNCTION g2
      g2 = MV2*na1 - na1ea
C
*     FUNCTION g3
      g3 = MV3*na1 - na2eb
C
*     FUNCTION g4
      g4 = ga*(na1*M1 + na2*M2 + na6*M6) - (na1*M1 + na2*M2)
C
*     FUNCTION g5
      g5 = gaea*(na1ea*M1 + na6ea*M6) - na1ea*M1
C
*     FUNCTION g6
      g6 = gaeb*(na2eb*M2 + na6eb*M6) - na2eb*M2
C
*     FUNCTION g7
      g7 = Va - (na1*M1/rho1 + na2*M2/rho2 + na6*M6/rho6)*1.0E+5
C  
*     FUNCTION mono_a(k), k in ind1
      mono_a(k) = feeda_c(k+1) - feeda_c(k)
C  
*     FUNCTION mono_b(k), k in ind1
      mono_b(k) = feedb_c(k+1) - feedb_c(k)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

