C
C------------------------------------------------------
C
C     Problem:    URETHAN
C
C     Date:       28.1.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      M1 = 0.11911
      M2 = 0.07412
      M3 = 0.19323
      M4 = 0.31234
      M5 = 0.35733
      M6 = 0.07806
      rho1 = 1095
      rho2 = 809
      rho3 = 1415
      rho4 = 1528
      rho5 = 1451
      rho6 = 1101
      Tref1 = 363.16
      Tref2 = 363.16
      Tref4 = 363.16
      Tg2 = 363.16
      R = 8.314      
      na1 = 1.06E-01
      na2 = 1.06E-01
      na6 = 8.76E-02
      na1ea = 3.19E-02
      na2eb = 3.19E-02
      na6ea = 4.86E-02
      na6eb = 4.54E-02                    
C
C------------------------------------------------------
C
*     LININT feeda
      0.0   0.0
      8.0   0.33
      24.0  0.33
      32.0  0.66
      48.0  0.66
      56.0  1.0
      80.0  1.0
C
*     LININT feedb
      0.0   0.0
      8.0   0.5
      24.0  0.5
      32.0  1.0
      80.0  1.0
C
*     LININT Temp
      0.0   293.2
      8.0   473.2
      24.0  473.2
      32.0  424.5
      48.0  424.5
      56.0  380.2
      72.0  380.2
      80.0  340.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      kref1x, kref2x, kref4x, kc2x, Ea1x, Ea2x, Ea4x, dh2x
      MV1, MV2, MV3, ga, gaea, gaeb, Va   
      n3, n4, n5, n1, n2, n6   
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION n3_t   
      kref1 = kref1x*5.0E-4
      kref2 = kref2x*8.0E-8
      kref4 = kref4x*1.0E-8
      kc2 = kc2x*1.7E-1
      Ea1 = Ea1x*3.52E+4
      Ea2 = Ea2x*8.5E+4
      Ea4 = Ea4x*3.5E+4
      dh2 = -dh2x*1.7E+4
      V = n1*M1/rho1 + n2*M2/rho2 + n3*M3/rho3 + n4*M4/rho4
     /    + n5*M5/rho5 + n6*M6/rho6
      if (V.lt.1.0E-25) then
        V = 1.0E-25
      endif
      kc = kc2*exp(-dh2/R*(1/Temp(t) - 1/Tg2))
      k1 = kref1*exp(-Ea1/R*(1/Temp(t) - 1/Tref1))
      k2 = kref2*exp(-Ea2/R*(1/Temp(t) - 1/Tref2))
      k3 = k2/kc
      k4 = kref4*exp(-Ea4/R*(1/Temp(t) - 1/Tref4))
      r1 = k1*n1/V*n2/V
      r2 = k2*n1/V*n3/V
      r3 = k3*n4/V
      r4 = k4*n1/V*n1/V
      n3_t = V*(r1 - r2 + r3)
C
*     FUNCTION n4_t
      n4_t = V*(r2 - r3)
C
*     FUNCTION n5_t
      n5_t = V*r4
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ1
      n1ea = na1ea*feeda(t)
      n2eb = na2eb*feedb(t)
      n6ea = na6ea*feeda(t)
      n6eb = na6eb*feedb(t)
      alg_equ1 = n1 + n3 + 2*n4 + 3*n5 - na1 - n1ea
C
*     FUNCTION alg_equ2
      alg_equ2 = n2 + n3 + n4 - na2 - n2eb
C
*     FUNCTION alg_equ3
      alg_equ3 = n6 - na6 - n6ea - n6eb
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION n3_0          
      if (t.LT.0.001) then
        n3_0 = 0
      else
        n3_0 = n3
      endif    
C
*     FUNCTION n4_0
      if (t.LT.0.001) then
        n4_0 = 0
      else
        n4_0 = n4
      endif    
C
*     FUNCTION n5_0
      if (t.LT.0.001) then
        n5_0 = 0
      else
        n5_0 = n5
      endif    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION n1_0
      if (t.LT.0.001) then
        n1_0 = 0
      else
        n1_0 = n1
      endif    
C
*     FUNCTION n2_0
      if (t.LT.0.001) then
        n2_0 = 0
      else
        n2_0 = n2
      endif    
C
*     FUNCTION n6_0
      if (t.LT.0.001) then
        n6_0 = 0
      else
        n6_0 = n6
      endif    
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION n1_fit
      n1_fit = n1
C
*     FUNCTION n2_fit
      n2_fit = n2
C
*     FUNCTION n3_fit
      n3_fit = n3
C
*     FUNCTION n4_fit
      n4_fit = n4
C
*     FUNCTION n5_fit
      n5_fit = n5
C
*     FUNCTION n6_fit
      n6_fit = n6
C
*     FUNCTION feeda_fit
      feeda_fit = feeda(t)
C
*     FUNCTION feedb_fit
      feedb_fit = feedb(t)
C
*     FUNCTION temp_fit
      temp_fit = temp(t)
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION g1
      g1 = MV1*(na1 + na1ea) - (na2 + na2eb)
C
*     FUNCTION g2
      g2 = MV2*na1 - na1ea
C
*     FUNCTION g3
      g3 = MV3*na1 - na2eb
C
*     FUNCTION g4
      g4 = ga*(na1*M1 + na2*M2 + na6*M6) - (na1*M1 + na2*M2)
C
*     FUNCTION g5
      g5 = gaea*(na1ea*M1 + na6ea*M6) - na1ea*M1
C
*     FUNCTION g6
      g6 = gaeb*(na2eb*M2 + na6eb*M6) - na2eb*M2
C
*     FUNCTION g7
      g7 = Va - (na1*M1/rho1 + na2*M2/rho2 + na6*M6/rho6)*1.0E+5
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





