C
C------------------------------------------------------
C
C     Problem:    UNI_BEAM
C
C     Date:       26.11.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C
*     VARIABLE
      a1,    a2
      u1,    u2,    u3,    u4,    u5
      u1_x,  u2_x,  u3_x,  u4_x,  u5_x
      u1_xx, u2_xx, u3_xx, u4_xx, u5_xx,  x,  t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u1_t
      u1_t = u2
C
*     FUNCTION u2_t
      u2_t = -a1*u2 - a2*u5_x
C
*     FUNCTION equ1
      equ1 = u1_x - u3
C
*     FUNCTION equ2
      equ2 = u3_x - u4
C
*     FUNCTION equ3
      equ3 = u4_x - u5    
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0
C
*     FUNCTION u2_0
      u2_0 = 0
C
*     FUNCTION u3_0
      u3_0 = 0
C
*     FUNCTION u4_0
      u4_0 = 0
C
*     FUNCTION u5_0
      u5_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled differential algebraic equations, order 
C     defined by increasing spatial positions (e.g. 
C     implicit boundary conditions):
C
C*     FUNCTION w_t
C      w_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled differential
C     algebraic equations for t=0 in the same order:
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = u*t
C
*     FUNCTION u3_left
      u3_left = 0
C
*     FUNCTION u4_right
      u4_right = 0
C
*     FUNCTION u5_right
      u5_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u1_x_left
C      u1_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = u1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C









