C
C------------------------------------------------------
C
C     Problem:     ULTRA
C
C     Date:        02.10.2001
C
C------------------------------------------------------
C
*     REAl CONSTANT
      A1 = 5.7511909E-6
      A2 = A1
      B1 = 2E-8
      B2 = 1E-9
      M1 = 67000
      M2 = 6800
      rh = 6.7  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      lk, ch1, ch2, c, rr
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION equ
      w1 = ch1*exp(A1*M1*(rr**2 - rh**2)/(1 + M1*B1*c))
      w2 = ch2*exp(A2*M2*(rr**2 - rh**2)/(1 + M2*B2*c))
      equ = w1 + w2 + exp(lk)*w1*w2*(M1 + M2)/(M1*M2) - c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION c_0
      c_0 = (ch1 + ch2)/3
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


