C
C------------------------------------------------------
C
C     Problem:     ULTRA
C
C     Date:        02.10.2001
C
C------------------------------------------------------
C
*     REAl CONSTANT
      q = 0.26
      omega = 1047.2 
      R = 8.314*10**7 
      t = 298.15 
      A = (q*omega**2)/(2*R*t)
      rh = 6.7  
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ms, Bs, ch, c, rr
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION equ
      M = Ms*1E+4
      B = Bs*1E-7 
      equ = ch*exp(A*M*(rr**2 - rh**2)/(1 + M*B*c))-  c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION c_0
      c_0 = 10
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
