C
C------------------------------------------------------
C
C     Problem:    TWOTANK
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A1=4          
      A2=3          
      F0in=1         
      F30=1         
      F3AMP=0.5     
      H10=0         
      H20=0          
      H2set=2       
      EPS=1E-10
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, Kc, H1, H2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION H1P
      H1T=H1
      IF (H1.LE.EPS) THEN
        H1T=EPS
      ENDIF
      H2T=H2
      IF (H2.LE.EPS) THEN
        H2T=EPS
      ENDIF
      F1=K1*SQRT(H1T)
      F2=K2*SQRT(H2T)
      F3=F30+SIN(T/3)*F3AMP
      F0=F0in+Kc*(H2set-H2T)
      IF (F0.le.0) THEN
        F0=0
      ENDIF
      H1P=(F0-F1)/A1
C
*     FUNCTION H2P
      H2P=(F1+F3-F2)/A2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION H1_0
      H1_0=H10
C
*     FUNCTION H2_0
      H2_0=H20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION H1_fit
      H1_fit=H1
C
*     FUNCTION H2_fit
      H2_fit=H2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
