C
C------------------------------------------------------
C
C     Problem:    TWOONE
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      KSA=0.5
      KSB=0.02
      YA=0.5
      YB=0.5
      F=0.85
      V=1
      S0=10 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UMA, UMB, XA, XB, S, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XAP
      UA=UMA*S/(KSA+S)
      UB=UMB*S/(KSB+S)
      XAP=-F*XA/V+UA*XA   
C
*     FUNCTION XBP
      XBP=-F*XB/V+UB*XB   
C
*     FUNCTION SP
      SP=(F/V)*(S0-S)-UA*XA/YA-UB*XB/YB   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION XA_0
      XA_0=1
C
*     FUNCTION XB_0
      XB_0=1
C
*     FUNCTION S_0
      S_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION XA_fit
      XA_fit=XA
C
*     FUNCTION XB_fit
      XB_fit=XB
C
*     FUNCTION S_fit
      S_fit=S
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
