C
C------------------------------------------------------
C
C     Problem:    TWOEX
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      V1, V2, K2, X1, Y1, W1, Z1, K1, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      E1=1.25*Y1-0.2*Z1   
      E2=Z1+.5*Y1*Y1  
      X1P=-K1*(X1-E1)/V1  
C
*     FUNCTION Y1P
      Y1P= K1*(X1-E1)/V2  
C
*     FUNCTION W1P
      W1P=-K2*(W1-E2)/V1  
C
*     FUNCTION Z1P
      Z1P= K2*(W1-E2)/V2  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0
      IF (T.LT.0.1) THEN
        X1_0=1
      ELSE
        X1_0=X1
      ENDIF
C
*     FUNCTION Y1_0
      IF (T.LT.0.1) THEN
        Y1_0=0
      ELSE
        Y1_0=Y1
      ENDIF
C
*     FUNCTION W1_0
      IF (T.LT.0.1) THEN
        W1_0=0.75
      ELSE
        W1_0=W1
      ENDIF
C
*     FUNCTION Z1_0
      IF (T.LT.0.1) THEN
        Z1_0=0.1
      ELSE
        Z1_0=Z1+0.5
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION Y1_fit
      Y1_fit=Y1
C
*     FUNCTION W1_fit
      W1_fit=W1  
C
*     FUNCTION Z1_fit
      Z1_fit=Z1   
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
