C
C------------------------------------------------------
C
C     Problem:    TURBCON
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Y=0.8
      V=1.0
      TI=10
      KP=0.25 
      A=0.2
      B=0.15
      XS=2.0 
      X0=1.0
      S0=5.0
      P0=1.0
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      UM, KS, F0, X, S, P, INTG, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION XP
      E=X-XS  
      F=F0+KP*E+(KP/TI)*INTG
      IF (F.LT.0.0) THEN
        F=0
      ENDIF
      U=UM*S/(KS+S)   
      XP=-F*X/V+U*X   
C
*     FUNCTION SP
      SP=F*(S0-S)/V-U*X/Y 
C
*     FUNCTION PP
      PP=-F*P/V+A*U*X+B*X 
C
*     FUNCTION INTGP
      INTGP=E
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0=X0
C
*     FUNCTION S_0
      S_0=S0
C
*     FUNCTION P_0
      P_0=P0
C
*     FUNCTION INTG_0
      INTG_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X_fit
      X_fit=X
C
*     FUNCTION S_fit
      S_fit=S
C
*     FUNCTION P_fit
      P_fit=P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
