C
C------------------------------------------------------
C
C     Problem:    TUNNEL
C
C     Date:       18.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Tc0 = 430
      Tgl = 300
      Tb = 2000
      Fg = 1500
      Fb = 650
      V = 1
      Cc = 2000
      cg = 1.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Ah, Ac
      Tc, Tg, Tc_z, Tg_z, Tc_zz, Tg_zz, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Tch_t
      Tch_t = -V*Tc_z + Ah*(Tg - Tc)/Cc
C
*     FUNCTION alg_h
      alg_h = (Fg + Fb)*cg*Tg_z - Ah*(Tg - Tc)
C
*     FUNCTION Tcc_t
      Tcc_t = -V*Tc_z + Ac*(Tg - Tc)/Cc
C
*     FUNCTION alg_c
      alg_c = Fg*cg*Tg_z - Ac*(Tg - Tc)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Tch_0
      Tch_0 = Tc0
C
*     FUNCTION Tgh_0
      Tgh_0 = Tgl
C
*     FUNCTION Tcc_0
      Tcc_0 = Tc0
C
*     FUNCTION Tgc_0
      Tgc_0 = Tgl
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION Tch_left
      Tch_left = Tc0
C
*     FUNCTION Tgh_right
      Tgh_right = (Fg*Tg + Fb*Tb)/(Fg + Fb)
C
*     FUNCTION Tcc_left
      Tcc_left = Tc
C
*     FUNCTION Tgc_right
      Tgc_right = Tgl
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Tg_fit
      Tg_fit = Tg
C
*     FUNCTION Tc_fit
      Tc_fit = Tc
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
