C
C------------------------------------------------------
C
C     Problem:    TUBULAR
C
C     Date:       28.09.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      TW = 200
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, k6, k7, k8, cG, TG, cS, TS, z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cG_z
      cG_z = -k1*(cG - cS)
C
*     FUNCTION TG_z
      TG_z = -k2*(TS - TG) - k3*(TG - TW)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_1
      r = 3240*cS*exp(5500*(1/620-1/TS))
      alg_1 = -k4*(TS - TG) + k5*r - k6*(TS - TW)
C
*     FUNCTION alg_2
      alg_2 = k7*(cG - cS) - k8*r
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cG_0
      cG_0 = 0.0025
C
*     FUNCTION TG_0
      TG_0 = 400
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION cS_0
      cS_0 = 0.0025
C
*     FUNCTION TS_0
      TS_0 = 413.225
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cG_fit
      cG_fit = cG
C
*     FUNCTION TG_fit
      TG_fit = TG
C
*     FUNCTION alg_3
      r = 3240*cS*exp(5500*(1/620-1/TS))
      alg_3 = -k4*(TS - TG) + k5*r - k6*(TS - TW)
C
*     FUNCTION alg_4
      alg_4 = k7*(cG - cS) - k8*r
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C










