C
C------------------------------------------------------
C
C     Problem:    TUBETANK
C
C     Date:       06.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      Ca0 = 800  
      F   = 0.04 
      k   = 0.8
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      n, Xa
C
C------------------------------------------------------
C
C   - Functions defining right-hand side fitting criterion:
C
*     FUNCTION Vtuta
      Cata  = Ca0 - Xa*Ca0
      Catu  = Cata
      TAUta = Xa/(k*Ca0**(n-1)*(1 - Xa)**n)
      Vta   = TAUta*F        
      TAUtu = ((1 - Xa)**(1-n) - 1)/(k*Ca0**(n-1)*(n - 1))
      Vtu   = TAUtu*F        
      Vtuta = Vtu/Vta       
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




