C
C------------------------------------------------------
C
C     Problem:    TUBEMIX
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      Vtub=1000     
      R3=0.2        
      R4=0.6       
      R1=0.8      
      R2=0.5       
      CA0=500    
      CAinit=0      
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F0, n, k, CA1, CA2, CA3, CA4, CA5, CAIM, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CA1P
      F1=F0*R1
      F2=F0-F1
      F3=F2*R2
      V1=Vtub/3
      V2=Vtub/R3
      V3=V2/R4
      Vtot=Vtub+V2+V3
      IF (CA1.GT.0) THEN
        Ra1=-k*CA1**n              
      ELSE
        Ra1=0
      ENDIF
      CA1P=F1/V1*(CA0-CA1)+Ra1
C
*     FUNCTION CA2P
      IF (CA2.GT.0) THEN
        Ra2=-k*CA2**n
      ELSE
        Ra2=0
      ENDIF
      CA2P=F1/V1*(CA1-CA2)+Ra2
C
*     FUNCTION CA3P
      IF (CA3.GT.0) THEN
        Ra3=-k*CA3**n
      ELSE
        Ra3=0
      ENDIF
      CA3P=F1/V1*(CA2-CA3)+Ra3
C
*     FUNCTION CA4P
      IF (CA4.GT.0) THEN
        Ra4=-k*CA4**n
      ELSE
        Ra4=0
      ENDIF
      CA4P=1/V2*(F2*(CA0-CA4)+F3*(CA5-CA4))+Ra4
C
*     FUNCTION CA5P
      IF (CA5.GT.0) THEN
        Ra5=-k*CA5**n
      ELSE
        Ra5=0
      ENDIF
      CA5P=1/V3*F3*(CA4-CA5)+Ra5
C
*     FUNCTION CAIMP
      IF (CAIM.GT.0) THEN
        CAIMP=(F0*(CA0-CAIM))/Vtot-K*CAIM**n  
      ELSE
        CAIMP=(F0*(CA0-CAIM))/Vtot
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA1_0
      CA1_0=CAinit
C
*     FUNCTION CA2_0
      CA2_0=CAinit
C
*     FUNCTION CA3_0
      CA3_0=CAinit
C
*     FUNCTION CA4_0
      CA4_0=CAinit
C
*     FUNCTION CA5_0
      CA5_0=CAinit
C
*     FUNCTION CAIM_0
      CAIM_0=CAinit
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA6_FIT
      CA6_FIT=(F2*CA4+F1*CA3)/F0
C
*     FUNCTION CAIM_FIT
      CAIM_FIT=CAIM 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
