C
C------------------------------------------------------
C
C     Problem:    TUBED
C
C     Date:       06.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      A=20        
      F=10          
      L=20          
      CA0=0.8       
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k, n, CAd, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CAdP
      v=F/A 
      Zd=t  
      PAR=k*L/v*CA0**(n-1)   
      CAdp=-PAR*CAd**n
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CAd_0
      CAd_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CAd_fit
      CAd_fit = CAd
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
