C
C------------------------------------------------------
C
C     Problem:    TUBE
C
C     Date:       28.05.1996
C
C------------------------------------------------------
C      
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      gamma, rho, m, E, rho_x, m_x, E_x, rho_xx, m_xx, E_xx
      Frho, Fm, FE, Frho_x, Fm_x, FE_x
      x, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux_rho
      flux_rho = -m
C
*     FUNCTION flux_m
      p = (gamma - 1)*(E - 0.5*m**2/rho)
      flux_m = -(m**2/rho + p)
C
*     FUNCTION flux_E
      flux_E = -m/rho*(E + p)
C
*     FUNCTION rho_t
      rho_t = Frho_x
C
*     FUNCTION m_t
      m_t = Fm_x 
C
*     FUNCTION E_t
      E_t = FE_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
C------------------------------------------------------
C
*     FUNCTION rho_0
      IF (x.LT.0) THEN
        rho_0 = 2
      ELSE
        rho_0 = 1
      ENDIF
C
*     FUNCTION m_0
      m_0 = 0
C
*     FUNCTION E_0
      IF (x.LT.0) THEN
        E_0 = 2/(gamma-1)
      ELSE
        E_0 = 1/(gamma-1)
      ENDIF
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
C*     FUNCTION UL
C      UL = ...
C
C*     FUNCTION UR
C      UR = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION rho_x_left
      rho_x_left = 0
C
*     FUNCTION m_x_left
      m_x_left = 0
C
*     FUNCTION E_x_left
      E_x_left = 0
C
*     FUNCTION rho_x_right
      rho_x_right = 0
C
*     FUNCTION m_x_right
      m_x_right = 0
C
*     FUNCTION E_x_right
      E_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C       
*     FUNCTION p_fit(i), i in ind
      p_fit(i) = (gamma - 1)*(E - 0.5*m**2/rho)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




