C
C------------------------------------------------------
C
C     Problem:    TUBDYN
C
C     Date:       07.02.01
C
C------------------------------------------------------
C 
*     SET OF INDICES
      ind = 1..8
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      V = 100          
      CAinit = 0      
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      CA0, n, k
      CA(i), i IN ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CAp(i), i IN ind
      IF (t.LT.20) THEN
        F = 10
      ELSE
        F = 5
      ENDIF
      TAU = V/F
      IF (i.GT.1) THEN
        IF (CA(i).GT.0) THEN
          CAp(i) = 1/TAU*(CA(i-1) - CA(i)) - k*CA(i)**n
        ELSE
          CAp(i) = 1/TAU*(CA(i-1) - CA(i))
        ENDIF
      ELSE
        IF (CA(i).GT.0) THEN
          CAp(i) = 1/TAU*(CA0 - CA(i)) - k*CA(i)**n
        ELSE
          CAp(i) = 1/TAU*(CA0 - CA(i))
        ENDIF
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0(i), i IN ind
      IF (t.LT.1) THEN
        CA_0(i) = CAinit
      ELSE
        CA_0(i) = CA(i)
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_fit(i), i IN ind
      CA_fit(i) = CA(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

