C
C------------------------------------------------------
C
C     Problem:    TRUCK
C
C     Date:       18.11.1994
C
C------------------------------------------------------
C
*     SET OF INDICES
      ISET = 1..10
      ISET1 = 1..11
C
C------------------------------------------------------
C
*     TABLE A(I), I IN ISET
      1   1.2787390025886D-01
      2   7.0383441249932D-04
      3   3.1048302053411D-01
      4  -3.3706894757361D-01
      5   2.1524978898283D-01
      6  -2.0360351352725D-01
      7   3.0976190476190D-01
      8  -2.5602498162985D-01
      9  -6.4260459387813D-02
      10 -6.0495499212637D-02
C
*     TABLE B(I), I IN ISET
      1   3.2851543326605D-03
      2  -3.9247021690475D-01
      3  -2.1366627460535D-01
      4   1.2023541777852D-01
      5   6.2092591111477D-02
      6   4.2512072003927D-01
      7  -2.4454907830674D-01
      8  -4.0881660420336D-01
      9   9.2395636436012D-02
      10  7.4654599226469D-02
C
C------------------------------------------------------
C
*     REAL CONSTANT
      M1  = 1450.D0
      M2  = 600.D0
      M3  = 1980.D0
      M4  = 1355.D0
      M5  = 1.D+3
      M6  = 1.D+2
      M7  = 11515.D0
      L3  = 10367.D0
      L4  = 432.D0
      L5  = 948.D0
      L7  = 3.3D+4
      K10 = 4.4D+6
      K20 = 2.2D+6
      K34 = 2643833.D0 
      K43 = 779735.D0
      K35 = 135707.D0
      K53 = 135707.D0
      K56 = 1.D+3
      K37 = 9.D+5
      D10 = 6.D+2
      D20 = 3.D+2
      D34 = 618.D0
      D43 = 182.D0
      D35 = 12218.D0
      D53 = 12218.D0
      D56 = 447.D0
      D37 = 385.D+2
      A13 = 2.0625D0
      A23 = 2.4375D0
      A35 = 1.9375D0
      A34 = 1.8125D0
      A43 = 3.0375D0
      A53 = 3.6375D0
      A37 = 0.9825D0
      AZ1 = 3.0625D0
      AZ2 = 0.15D0
      B34 = 0.279D0
      B43 = 0.946D0
      C35 = 0.8D0
      C53 = 0.9D0
      C56 = 0.2D0
      E37 = 2.435D0
      EZ1 = 1.61D0
      EZ2 = 0.75D0
      HEQ = 0.9D0
      XN13 = 0.16D0
      XN23 = 0.16D0
      AA = 0.0562D0
      PA = 1.D+5
      SS = 39.1328D0
      FN10 =  0.1226542774000000E+06
      FN20 =  0.5392572260000000E+05
      FN34 =  0.1026510391836735E+05     
      FN43 =  0.3027446081632654E+04
      FN35 =  0.5597470588235294E+04
      FN53 =  0.5193529411764707E+04
      FN56 =  0.9810000000000000E+03
      FN37 = -0.6300385509270705E+06
      FN13 = -0.1084297774000000E+06
      FN23 = -0.4803972260000000E+05
      GG = 9.81D0
      T2 = 0.0D0
      T1 = 0.15D0
      A0 = -8.5238095238095D-02
      PI = 3.1415926535897D+00
      DE = 1.9047619047619D-01
      LAM0 = 0.6800070092707046D+5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      KK, D13, D23
      X(I), I IN ISET1
      V(I), I IN ISET1
      LAMBDA, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION DX(I), I IN ISET1
      DX(I) = V(I)
C
*     FUNCTION DV1
      TT1 = T-T1+3
      TT2 = T-T2+3
      SINP4 = SIN(X(4))
      COSP4 = COS(X(4))
      SINP6 = SIN(X(6))
      COSP6 = COS(X(6))
      SINP8 = SIN(X(8))
      COSP8 = COS(X(8))
      SINP11= SIN(X(11))
      COSP11= COS(X(11))
      S1 = SUM(A(L)*COS(2*PI*L*TT1*DE) +
     &       B(L)*SIN(2*PI*L*TT1*DE), L IN ISET)
      UTMT1 = 0.01D0*(S1 + A0*0.5D0)*EXP(-0.1D0*(TT1-7.0D0)**2)
      S2 = SUM(A(L)*COS(2*PI*L*TT2*DE) +
     &       B(L)*SIN(2*PI*L*TT2*DE), L IN ISET)
      UTMT2 = 0.01D0*(S2 + A0*0.5D0)*EXP(-0.1D0*(TT2-7.0D0)**2)
      S11 = SUM(A(L)*COS(2*PI*L*TT1*DE) +
     &        B(L)*SIN(2*PI*L*TT1*DE), L IN ISET)
      S12 = SUM(-A(L)*2*PI*L*DE*SIN(2*PI*L*TT1*DE) +
     &    B(L)*2*PI*L*DE*COS(2*PI*L*TT1*DE), L IN ISET)
      DUTMT1 = 0.01D0*S12*EXP(-0.1D0*(TT1-7.0D0)**2) -
     &    (S11 + A0*0.5D0)*0.002D0*(TT1-7.D0)*
     &    EXP(-0.1D0*(TT1-7.0D0)**2)
      S21 = SUM(A(L)*COS(2*PI*L*TT2*DE) +
     &        B(L)*SIN(2*PI*L*TT2*DE), L IN ISET)
      S22 = SUM(-A(L)*2*PI*L*DE*SIN(2*PI*L*TT2*DE) +
     &    B(L)*2*PI*L*DE*COS(2*PI*L*TT2*DE), L IN ISET)
      DUTMT2 = 0.01D0*S22*EXP(-0.1D0*(TT2-7.0D0)**2) -
     &    (S21 + A0*0.5D0)*0.002D0*(TT2-7.D0)*
     &    EXP(-0.1D0*(TT2-7.0D0)**2)
      F10 = K10*(X(1)-UTMT1) + D10*(V(1)-DUTMT1) - FN10
      F20 = K20*(X(2)-UTMT2) + D20*(V(2)-DUTMT2) - FN20
      F13 = (FN13+PA*AA)*((1.+SS*XN13)/(1.+SS*(XN13+
     &      X(3)+A13*SINP4-X(1))))**KK - PA*AA +
     &      D13*(V(3)+A13*COSP4*V(4)-V(1))
      F23 = (FN23+PA*AA)*((1.+SS*XN23)/(1.+SS*(XN23 +
     &      X(3)-A23*SINP4-X(2))))**KK - PA*AA +
     &      D23*(V(3)-A23*COSP4*V(4)-V(2))
      F34 = K34*(X(5)+B34*SINP6-X(3)+A34*SINP4) - FN34 +
     &      D34*(V(5)+B34*V(6)*COSP6-V(3)+A34*V(4)*COSP4)
      F43 = K43*(X(5)-B43*SINP6-X(3)+A43*SINP4) - FN43 +
     &      D43*(V(5)-B43*V(6)*COSP6-V(3)+A43*V(4)*COSP4)
      F35 = K35*(X(7)+C35*SINP8-X(3)+A35*SINP4) - FN35 +
     &      D35*(V(7)+C35*V(8)*COSP8-V(3)+A35*V(4)*COSP4)
      F53 = K53*(X(7)-C53*SINP8-X(3)+A53*SINP4) - FN53 +
     &      D53*(V(7)-C53*V(8)*COSP8-V(3)+A53*V(4)*COSP4)
      F56 = K56*(X(9)-X(7)+C56*SINP8) - FN56 +
     &      D56*(V(9)-V(7)+C56*V(8)*COSP8)
      F37 = K37*(X(10)-E37*SINP11-EZ2*COSP11-X(3)+A37*SINP4) +
     &      D37*(V(10)-E37*V(11)*COSP11+EZ2*V(11)*SINP11-V(3) +
     &      A37*V(4)*COSP4) - FN37
      DV1 = -(F10 - F13 + M1*GG)/M1
C
*     FUNCTION DV2
      DV2 = -(F20 - F23 + M2*GG)/M2
C
*     FUNCTION DV3
      DV3 = -(F13 + F23 - F35 - F34 - F43 - F53 - F37 +
     &        M3*GG + LAMBDA)/M3
C
*     FUNCTION DV4
      DV4 = -(-COSP4*(A23*F23 - A13*F13 -A37*F37 -
     &        A34*F34 - A35*F35 - A43*F43 - A53*F53) +
     &        LAMBDA*(AZ1*COSP4 - AZ2*SINP4))/L3
C
*     FUNCTION DV5
      DV5 = -(F43 + F34 + M4*GG)/M4
C
*     FUNCTION DV6
      DV6= COSP6*(B43*F43 - B34*F34)/L4
C
*     FUNCTION DV7
      DV7 = -(F53 + F35 - F56 + M5*GG)/M5
C
*     FUNCTION DV8
      DV8 = COSP8*(C53*F53 - C35*F35 - C56*F56)/L5
C
*     FUNCTION DV9
      DV9 = -(F56 + M6*GG)/M6
C
*     FUNCTION DV10
      DV10 = -(F37 + M7*GG - LAMBDA)/M7
C
*     FUNCTION DV11
      DV11 = (E37*COSP11*F37 - LAMBDA*(-EZ1*COSP11 -
     /       EZ2*SINP11))/L7
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION ALGEQ
      ALGEQ = -X(10) - EZ1*SINP11 + EZ2*COSP11 + X(3) +
     &         AZ1*SINP4 + AZ2*COSP4 - HEQ
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X0(I), I IN ISET1
      X0(I) = 0
C
*     FUNCTION V0(I), I IN ISET1
      V0(I) = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION L0
      L0 = LAM0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = X(1)
C
*     FUNCTION FIT2
      FIT2 = X(2)
C
*     FUNCTION FIT3
      FIT3 = X(3)
C
*     FUNCTION FIT4
      FIT4 = X(5)
C
*     FUNCTION FIT5
      FIT5 = X(7)
C
*     FUNCTION FIT6
      FIT6 = X(9)
C
*     FUNCTION FIT7
      FIT7 = X(10)
C
*     FUNCTION EQU
      EQU = -X(10) - EZ1*SINP11 + EZ2*COSP11 + X(3) +
     &      AZ1*SINP4 + AZ2*COSP4 - HEQ
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




