C
C------------------------------------------------------
C
C     Problem:    TRILEPT
C
C     Date:       04.06.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R = 8.314
      T = 253
      mC = 1.93E-02
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k10, k20, Eact1, Eact2, lag_time, end_time
      mR, Camy, Dia, Nas, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dmR_dt
      if (time.ge.lag_time) then
        dmR_dt = mC/60
          if (time.ge.end_time) then
            dmR_dt = 0
          else
            dmR_dt = mC/60
          endif
      else
        dmR_dt = 0
      endif
C
*     FUNCTION dCamy_dt
      k1 = k10*exp(-Eact1/(R*T))
      k2 = k20*exp(-Eact2/(R*T))
      if (time.ge.lag_time) then
        dCamy_dt = 0.2/mR*60 - k2*Nas*Camy -  
     /             dmR_dt*Nas/mR
      else
        dCamy_dt = 0
      endif
C
*     FUNCTION dDia_dt
      if (time.lt.lag_time) then
        dDia_dt = 0
      else
        dDia_dt = -k1*Dia*Camy - (dmR_dt)*Dia/mR  
      endif
C             
*     FUNCTION dNas_dt
      if (time.lt.lag_time) then
        dNas_dt = 0
      else
        dNas_dt = k1*Dia*Camy + (dmR_dt)*Dia/mR -
     /               k2*Nas*Camy - (dmR_dt)*Nas/mR
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION mR_0
      if (time.lt.lag_time) then
        mR_0 = 0.3186
      else
        mR_0 = mR
      endif
C
*     FUNCTION Camy_0
      if (time.lt.lag_time) then
        Camy_0 = 0
      else
        Camy_0 = Camy
      endif
C
*     FUNCTION Dia_0
      if (time.lt.lag_time) then
        Dia_0 = 0.627746 
      else
        Dia_0 = Dia
      endif
C
*     FUNCTION Nas_0
      if (time.lt.lag_time) then
        Nas_0 = 0
      else
        Nas_0 = Nas
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Dia_fit
      Dia_fit = Dia
C
*     FUNCTION Nas_fit
      Nas_fit = Nas
C
*     FUNCTION mR_fit
      mR_fit = mR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


