C
C------------------------------------------------------
C
C     Problem:    TRICHO
C
C     Date:       06.11.00
C
C------------------------------------------------------
C
*     REAL CONSTANT
      csf = 9
      ms  = 0.037
      yxs = 0.54
      V0  = 15
C
C------------------------------------------------------
C     
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      Ks, mu_max, a, tf, cx, cs, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cx_t
      mu = mu_max*cs/(Ks + cs)
      if (t.le.tf) then
        u = 0
      else
        u = a*(t - tf)
      endif
      D = u/V0
      cx_t = mu*cx - D*cx
C
*     FUNCTION cs_t
      cs_t = (-mu/yxs - ms)*cx + D*(csf - cs)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cx_0
      if (t.lt.0.1) then
        cx_0 = 0.5
      else
        cx_0 = cx
      endif
C
*     FUNCTION cs_0
      if (t.lt.0.1) then
        cs_0 = 6
      else
        cs_0 = cs
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cx_fit
      cx_fit = cx
C
*     FUNCTION cs_fit
      cs_fit = cs
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
