C
C------------------------------------------------------
C
C     Problem:    TREES
C
C     Date:       05.07.2005
C
C------------------------------------------------------
C               
*     SET OF INDICES
      ind = 1..2
C
C------------------------------------------------------
C                           
*     REAL CONSTANT
      h0 = 0.5  
C
C------------------------------------------------------
C                     
*     LININT si      
      1.0 16.1705118973319 
      2.0 18.5036067912464 
C
*     LININT sp
      1.0  1.264646875      
      2.0  2.52929375
C
C------------------------------------------------------
C                      
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a0, a1, a2, a3, a4, h, k, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION h_t             
      if (t.gt.0) then
        t1 = t**a2
      else
        t1 = 0
      endif    
      if (h.gt.0) then
        h1 = h**a2
      else
        h1 = 0
      endif    
      h_t =  a0*(sp(k)/10)**a1*t1*log(si(k))*(a3*h1 - a4*h)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION h_0
      h_0 = h0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION h_fit
      h_fit = h
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
