C
C------------------------------------------------------
C
C     Problem: TRAN_DEG
C  
C     Date: 21.07.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      theta_r = 0.03
      theta_s = 0.334
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C    
*     VARIABLE
      alpha, n, Ks, u, u_x, u_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION FLUX
      au = abs(u)
      if (au.eq.0) then
        au = 0.00001
      endif
      K = Ks*abs(1 - (alpha*au)**(n-1)
     /                 *(1 + (alpha*au**n)**(1/n-1))**2
     /         /(1 + (alpha*au)**n))**((1-1/n)/2)
      FLUX = K*(u_x - 1)
C            
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      au = alpha*abs(u)
      if (au.eq.0) then
        au = 0.00001
      endif
      C = alpha*(n-1)*(theta_s - theta_r)*(1 + au**n)**(1/n-2)
     /                                       *au**(n-1)
      u_t = f_x/C
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u0
      u0 = 670
C
C------------------------------------------------------
C
C   - Derivatives defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION u_x_left
      au = abs(u)
      if (au.eq.0) then
        au = 0.00001
      endif
      K = Ks*abs(1 - (alpha*au)**(n-1)
     /                 *(1 + (alpha*au**n)**(1/n-1))**2
     /         /(1 + (alpha*au)**n))**((1-1/n)/2)
      if ((t.le.6).and.(K.ne.0)) then
        u_x_left = 1 - 0.2/K 
      else
        u_x_left = 0
      endif
C
*     FUNCTION u_x_right
      u_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = u  
C
*     FUNCTION fit2
      fit2 = u  
C
*     FUNCTION fit3
      fit3 = u  
C
*     FUNCTION fit4
      fit4 = u  
C
C------------------------------------------------------
C
*     END
C

